// Because of vitejs/vite#12340, there's no way to reliably detect whether we're
// running as a (possibly bundled/polyfilled) ESM module or as a CommonJS
// module. In order to work everywhere, we have to provide the load function via
// a side channel on the global object. We write it as a stack so that multiple
// cli_pkg packages can depend on one another without clobbering their exports.
if (!globalThis._cliPkgExports) {
  globalThis._cliPkgExports = [];
}
let _cliPkgExports = {};
globalThis._cliPkgExports.push(_cliPkgExports);

_cliPkgExports.load = function(_cliPkgRequires, _cliPkgExportParam) {
var dartNodeIsActuallyNode = typeof process !== "undefined" && (process.versions || {}).hasOwnProperty('node');

// make sure to keep this as 'var'
// we don't want block scoping
var self = dartNodeIsActuallyNode ? Object.create(globalThis) : globalThis;

self.scheduleImmediate = typeof setImmediate !== "undefined"
    ? function (cb) {
        setImmediate(cb);
      }
    : function(cb) {
        setTimeout(cb, 0);
      };

// CommonJS globals.
if (typeof require !== "undefined") {
  self.require = require;
}
self.exports = _cliPkgExportParam || _cliPkgExports;

// Node.js specific exports, check to see if they exist & or polyfilled

if (typeof process !== "undefined") {
  self.process = process;
}

if (typeof __dirname !== "undefined") {
  self.__dirname = __dirname;
}

if (typeof __filename !== "undefined") {
  self.__filename = __filename;
}

if (typeof Buffer !== "undefined") {
  self.Buffer = Buffer;
}

// if we're running in a browser, Dart supports most of this out of box
// make sure we only run these in Node.js environment

if (dartNodeIsActuallyNode) {
  // This line is to:
  // 1) Prevent Webpack from bundling.
  // 2) In Webpack on Node.js, make sure we're using the native Node.js require, which is available via __non_webpack_require__
  // https://github.com/mbullington/node_preamble.dart/issues/18#issuecomment-527305561
  var url = ("undefined" !== typeof __webpack_require__ ? __non_webpack_require__ : require)("url");

  // Setting `self.location=` in Electron throws a `TypeError`, so we define it
  // as a property instead to be safe.
  Object.defineProperty(self, "location", {
    value: {
      get href() {
        if (url.pathToFileURL) {
          return url.pathToFileURL(process.cwd()).href + "/";
        } else {
          // This isn't really a correct transformation, but it's the best we have
          // for versions of Node <10.12.0 which introduced `url.pathToFileURL()`.
          // For example, it will fail for paths that contain characters that need
          // to be escaped in URLs.
          return "file://" + (function() {
            var cwd = process.cwd();
            if (process.platform != "win32") return cwd;
            return "/" + cwd.replace(/\\/g, "/");
          })() + "/"
        }
      }
    }
  });

  (function() {
    function computeCurrentScript() {
      try {
        throw new Error();
      } catch(e) {
        var stack = e.stack;
        var re = new RegExp("^ *at [^(]*\\((.*):[0-9]*:[0-9]*\\)$", "mg");
        var lastMatch = null;
        do {
          var match = re.exec(stack);
          if (match != null) lastMatch = match;
        } while (match != null);
        return lastMatch[1];
      }
    }

    // Setting `self.document=` isn't known to throw an error anywhere like
    // `self.location=` does on Electron, but it's better to be future-proof
    // just in case..
    var cachedCurrentScript = null;
    Object.defineProperty(self, "document", {
      value: {
        get currentScript() {
          if (cachedCurrentScript == null) {
            cachedCurrentScript = {src: computeCurrentScript()};
          }
          return cachedCurrentScript;
        }
      }
    });
  })();

  self.dartDeferredLibraryLoader = function(uri, successCallback, errorCallback) {
    try {
     load(uri);
      successCallback();
    } catch (error) {
      errorCallback(error);
    }
  };
}

self.immutable = _cliPkgRequires.immutable;
self.chokidar = _cliPkgRequires.chokidar;
self.readline = _cliPkgRequires.readline;
self.fs = _cliPkgRequires.fs;
self.nodeModule = _cliPkgRequires.nodeModule;
self.stream = _cliPkgRequires.stream;
self.util = _cliPkgRequires.util;
// Generated by dart2js (NullSafetyMode.sound, trust primitives, omit checks, lax runtime type, csp, intern-composite-values), the Dart to JavaScript compiler version: 3.4.3.
// The code supports the following hooks:
// dartPrint(message):
//    if this function is defined it is called instead of the Dart [print]
//    method.
//
// dartMainRunner(main, args):
//    if this function is defined, the Dart [main] method will not be invoked
//    directly. Instead, a closure that will invoke [main], and its arguments
//    [args] is passed to [dartMainRunner].
//
// dartDeferredLibraryLoader(uri, successCallback, errorCallback, loadId, loadPriority):
//    if this function is defined, it will be called when a deferred library
//    is loaded. It should load and eval the javascript of `uri`, and call
//    successCallback. If it fails to do so, it should call errorCallback with
//    an error. The loadId argument is the deferred import that resulted in
//    this uri being loaded. The loadPriority argument is the priority the
//    library should be loaded with as specified in the code via the
//    load-priority annotation (0: normal, 1: high).
// dartDeferredLibraryMultiLoader(uris, successCallback, errorCallback, loadId, loadPriority):
//    if this function is defined, it will be called when a deferred library
//    is loaded. It should load and eval the javascript of every URI in `uris`,
//    and call successCallback. If it fails to do so, it should call
//    errorCallback with an error. The loadId argument is the deferred import
//    that resulted in this uri being loaded. The loadPriority argument is the
//    priority the library should be loaded with as specified in the code via
//    the load-priority annotation (0: normal, 1: high).
//
// dartCallInstrumentation(id, qualifiedName):
//    if this function is defined, it will be called at each entry of a
//    method or constructor. Used only when compiling programs with
//    --experiment-call-instrumentation.
(function dartProgram() {
  function copyProperties(from, to) {
    var keys = Object.keys(from);
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      to[key] = from[key];
    }
  }
  function mixinPropertiesHard(from, to) {
    var keys = Object.keys(from);
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      if (!to.hasOwnProperty(key)) {
        to[key] = from[key];
      }
    }
  }
  function mixinPropertiesEasy(from, to) {
    Object.assign(to, from);
  }
  var supportsDirectProtoAccess = function() {
    var cls = function() {
    };
    cls.prototype = {p: {}};
    var object = new cls();
    if (!(Object.getPrototypeOf(object) && Object.getPrototypeOf(object).p === cls.prototype.p))
      return false;
    try {
      if (typeof navigator != "undefined" && typeof navigator.userAgent == "string" && navigator.userAgent.indexOf("Chrome/") >= 0)
        return true;
      if (typeof version == "function" && version.length == 0) {
        var v = version();
        if (/^\d+\.\d+\.\d+\.\d+$/.test(v))
          return true;
      }
    } catch (_) {
    }
    return false;
  }();
  function inherit(cls, sup) {
    cls.prototype.constructor = cls;
    cls.prototype["$is" + cls.name] = cls;
    if (sup != null) {
      if (supportsDirectProtoAccess) {
        Object.setPrototypeOf(cls.prototype, sup.prototype);
        return;
      }
      var clsPrototype = Object.create(sup.prototype);
      copyProperties(cls.prototype, clsPrototype);
      cls.prototype = clsPrototype;
    }
  }
  function inheritMany(sup, classes) {
    for (var i = 0; i < classes.length; i++) {
      inherit(classes[i], sup);
    }
  }
  function mixinEasy(cls, mixin) {
    mixinPropertiesEasy(mixin.prototype, cls.prototype);
    cls.prototype.constructor = cls;
  }
  function mixinHard(cls, mixin) {
    mixinPropertiesHard(mixin.prototype, cls.prototype);
    cls.prototype.constructor = cls;
  }
  function lazy(holder, name, getterName, initializer) {
    var uninitializedSentinel = holder;
    holder[name] = uninitializedSentinel;
    holder[getterName] = function() {
      if (holder[name] === uninitializedSentinel) {
        holder[name] = initializer();
      }
      holder[getterName] = function() {
        return this[name];
      };
      return holder[name];
    };
  }
  function lazyFinal(holder, name, getterName, initializer) {
    var uninitializedSentinel = holder;
    holder[name] = uninitializedSentinel;
    holder[getterName] = function() {
      if (holder[name] === uninitializedSentinel) {
        var value = initializer();
        if (holder[name] !== uninitializedSentinel) {
          A.throwLateFieldADI(name);
        }
        holder[name] = value;
      }
      var finalValue = holder[name];
      holder[getterName] = function() {
        return finalValue;
      };
      return finalValue;
    };
  }
  function makeConstList(list) {
    list.immutable$list = Array;
    list.fixed$length = Array;
    return list;
  }
  function convertToFastObject(properties) {
    function t() {
    }
    t.prototype = properties;
    new t();
    return properties;
  }
  function convertAllToFastObject(arrayOfObjects) {
    for (var i = 0; i < arrayOfObjects.length; ++i) {
      convertToFastObject(arrayOfObjects[i]);
    }
  }
  var functionCounter = 0;
  function instanceTearOffGetter(isIntercepted, parameters) {
    var cache = null;
    return isIntercepted ? function(receiver) {
      if (cache === null)
        cache = A.closureFromTearOff(parameters);
      return new cache(receiver, this);
    } : function() {
      if (cache === null)
        cache = A.closureFromTearOff(parameters);
      return new cache(this, null);
    };
  }
  function staticTearOffGetter(parameters) {
    var cache = null;
    return function() {
      if (cache === null)
        cache = A.closureFromTearOff(parameters).prototype;
      return cache;
    };
  }
  var typesOffset = 0;
  function tearOffParameters(container, isStatic, isIntercepted, requiredParameterCount, optionalParameterDefaultValues, callNames, funsOrNames, funType, applyIndex, needsDirectAccess) {
    if (typeof funType == "number") {
      funType += typesOffset;
    }
    return {co: container, iS: isStatic, iI: isIntercepted, rC: requiredParameterCount, dV: optionalParameterDefaultValues, cs: callNames, fs: funsOrNames, fT: funType, aI: applyIndex || 0, nDA: needsDirectAccess};
  }
  function installStaticTearOff(holder, getterName, requiredParameterCount, optionalParameterDefaultValues, callNames, funsOrNames, funType, applyIndex) {
    var parameters = tearOffParameters(holder, true, false, requiredParameterCount, optionalParameterDefaultValues, callNames, funsOrNames, funType, applyIndex, false);
    var getterFunction = staticTearOffGetter(parameters);
    holder[getterName] = getterFunction;
  }
  function installInstanceTearOff(prototype, getterName, isIntercepted, requiredParameterCount, optionalParameterDefaultValues, callNames, funsOrNames, funType, applyIndex, needsDirectAccess) {
    isIntercepted = !!isIntercepted;
    var parameters = tearOffParameters(prototype, false, isIntercepted, requiredParameterCount, optionalParameterDefaultValues, callNames, funsOrNames, funType, applyIndex, !!needsDirectAccess);
    var getterFunction = instanceTearOffGetter(isIntercepted, parameters);
    prototype[getterName] = getterFunction;
  }
  function setOrUpdateInterceptorsByTag(newTags) {
    var tags = init.interceptorsByTag;
    if (!tags) {
      init.interceptorsByTag = newTags;
      return;
    }
    copyProperties(newTags, tags);
  }
  function setOrUpdateLeafTags(newTags) {
    var tags = init.leafTags;
    if (!tags) {
      init.leafTags = newTags;
      return;
    }
    copyProperties(newTags, tags);
  }
  function updateTypes(newTypes) {
    var types = init.types;
    var length = types.length;
    types.push.apply(types, newTypes);
    return length;
  }
  function updateHolder(holder, newHolder) {
    copyProperties(newHolder, holder);
    return holder;
  }
  var hunkHelpers = function() {
    var mkInstance = function(isIntercepted, requiredParameterCount, optionalParameterDefaultValues, callNames, applyIndex) {
        return function(container, getterName, name, funType) {
          return installInstanceTearOff(container, getterName, isIntercepted, requiredParameterCount, optionalParameterDefaultValues, callNames, [name], funType, applyIndex, false);
        };
      },
      mkStatic = function(requiredParameterCount, optionalParameterDefaultValues, callNames, applyIndex) {
        return function(container, getterName, name, funType) {
          return installStaticTearOff(container, getterName, requiredParameterCount, optionalParameterDefaultValues, callNames, [name], funType, applyIndex);
        };
      };
    return {inherit: inherit, inheritMany: inheritMany, mixin: mixinEasy, mixinHard: mixinHard, installStaticTearOff: installStaticTearOff, installInstanceTearOff: installInstanceTearOff, _instance_0u: mkInstance(0, 0, null, ["call$0"], 0), _instance_1u: mkInstance(0, 1, null, ["call$1"], 0), _instance_2u: mkInstance(0, 2, null, ["call$2"], 0), _instance_0i: mkInstance(1, 0, null, ["call$0"], 0), _instance_1i: mkInstance(1, 1, null, ["call$1"], 0), _instance_2i: mkInstance(1, 2, null, ["call$2"], 0), _static_0: mkStatic(0, null, ["call$0"], 0), _static_1: mkStatic(1, null, ["call$1"], 0), _static_2: mkStatic(2, null, ["call$2"], 0), makeConstList: makeConstList, lazy: lazy, lazyFinal: lazyFinal, updateHolder: updateHolder, convertToFastObject: convertToFastObject, updateTypes: updateTypes, setOrUpdateInterceptorsByTag: setOrUpdateInterceptorsByTag, setOrUpdateLeafTags: setOrUpdateLeafTags};
  }();
  function initializeDeferredHunk(hunk) {
    typesOffset = init.types.length;
    hunk(hunkHelpers, init, holders, $);
  }
  var J = {
    makeDispatchRecord(interceptor, proto, extension, indexability) {
      return {i: interceptor, p: proto, e: extension, x: indexability};
    },
    getNativeInterceptor(object) {
      var proto, objectProto, $constructor, interceptor, t1,
        record = object[init.dispatchPropertyName];
      if (record == null)
        if ($.initNativeDispatchFlag == null) {
          A.initNativeDispatch();
          record = object[init.dispatchPropertyName];
        }
      if (record != null) {
        proto = record.p;
        if (false === proto)
          return record.i;
        if (true === proto)
          return object;
        objectProto = Object.getPrototypeOf(object);
        if (proto === objectProto)
          return record.i;
        if (record.e === objectProto)
          throw A.wrapException(A.UnimplementedError$("Return interceptor for " + A.S(proto(object, record))));
      }
      $constructor = object.constructor;
      if ($constructor == null)
        interceptor = null;
      else {
        t1 = $._JS_INTEROP_INTERCEPTOR_TAG;
        if (t1 == null)
          t1 = $._JS_INTEROP_INTERCEPTOR_TAG = init.getIsolateTag("_$dart_js");
        interceptor = $constructor[t1];
      }
      if (interceptor != null)
        return interceptor;
      interceptor = A.lookupAndCacheInterceptor(object);
      if (interceptor != null)
        return interceptor;
      if (typeof object == "function")
        return B.JavaScriptFunction_methods;
      proto = Object.getPrototypeOf(object);
      if (proto == null)
        return B.PlainJavaScriptObject_methods;
      if (proto === Object.prototype)
        return B.PlainJavaScriptObject_methods;
      if (typeof $constructor == "function") {
        t1 = $._JS_INTEROP_INTERCEPTOR_TAG;
        if (t1 == null)
          t1 = $._JS_INTEROP_INTERCEPTOR_TAG = init.getIsolateTag("_$dart_js");
        Object.defineProperty($constructor, t1, {value: B.UnknownJavaScriptObject_methods, enumerable: false, writable: true, configurable: true});
        return B.UnknownJavaScriptObject_methods;
      }
      return B.UnknownJavaScriptObject_methods;
    },
    JSArray_JSArray$fixed($length, $E) {
      if ($length < 0 || $length > 4294967295)
        throw A.wrapException(A.RangeError$range($length, 0, 4294967295, "length", null));
      return J.JSArray_JSArray$markFixed(new Array($length), $E);
    },
    JSArray_JSArray$allocateFixed($length, $E) {
      if ($length > 4294967295)
        throw A.wrapException(A.RangeError$range($length, 0, 4294967295, "length", null));
      return J.JSArray_JSArray$markFixed(new Array($length), $E);
    },
    JSArray_JSArray$growable($length, $E) {
      if ($length < 0)
        throw A.wrapException(A.ArgumentError$("Length must be a non-negative integer: " + $length, null));
      return A._setArrayType(new Array($length), $E._eval$1("JSArray<0>"));
    },
    JSArray_JSArray$allocateGrowable($length, $E) {
      if ($length < 0)
        throw A.wrapException(A.ArgumentError$("Length must be a non-negative integer: " + $length, null));
      return A._setArrayType(new Array($length), $E._eval$1("JSArray<0>"));
    },
    JSArray_JSArray$markFixed(allocation, $E) {
      return J.JSArray_markFixedList(A._setArrayType(allocation, $E._eval$1("JSArray<0>")));
    },
    JSArray_markFixedList(list) {
      list.fixed$length = Array;
      return list;
    },
    JSArray_markUnmodifiableList(list) {
      list.fixed$length = Array;
      list.immutable$list = Array;
      return list;
    },
    JSArray__compareAny(a, b) {
      return J.compareTo$1$ns(a, b);
    },
    JSString__isWhitespace(codeUnit) {
      if (codeUnit < 256)
        switch (codeUnit) {
          case 9:
          case 10:
          case 11:
          case 12:
          case 13:
          case 32:
          case 133:
          case 160:
            return true;
          default:
            return false;
        }
      switch (codeUnit) {
        case 5760:
        case 8192:
        case 8193:
        case 8194:
        case 8195:
        case 8196:
        case 8197:
        case 8198:
        case 8199:
        case 8200:
        case 8201:
        case 8202:
        case 8232:
        case 8233:
        case 8239:
        case 8287:
        case 12288:
        case 65279:
          return true;
        default:
          return false;
      }
    },
    JSString__skipLeadingWhitespace(string, index) {
      var t1, codeUnit;
      for (t1 = string.length; index < t1;) {
        codeUnit = string.charCodeAt(index);
        if (codeUnit !== 32 && codeUnit !== 13 && !J.JSString__isWhitespace(codeUnit))
          break;
        ++index;
      }
      return index;
    },
    JSString__skipTrailingWhitespace(string, index) {
      var index0, codeUnit;
      for (; index > 0; index = index0) {
        index0 = index - 1;
        codeUnit = string.charCodeAt(index0);
        if (codeUnit !== 32 && codeUnit !== 13 && !J.JSString__isWhitespace(codeUnit))
          break;
      }
      return index;
    },
    getInterceptor$(receiver) {
      if (typeof receiver == "number") {
        if (Math.floor(receiver) == receiver)
          return J.JSInt.prototype;
        return J.JSNumNotInt.prototype;
      }
      if (typeof receiver == "string")
        return J.JSString.prototype;
      if (receiver == null)
        return J.JSNull.prototype;
      if (typeof receiver == "boolean")
        return J.JSBool.prototype;
      if (Array.isArray(receiver))
        return J.JSArray.prototype;
      if (typeof receiver != "object") {
        if (typeof receiver == "function")
          return J.JavaScriptFunction.prototype;
        if (typeof receiver == "symbol")
          return J.JavaScriptSymbol.prototype;
        if (typeof receiver == "bigint")
          return J.JavaScriptBigInt.prototype;
        return receiver;
      }
      if (receiver instanceof A.Object)
        return receiver;
      return J.getNativeInterceptor(receiver);
    },
    getInterceptor$ansx(receiver) {
      if (typeof receiver == "number")
        return J.JSNumber.prototype;
      if (typeof receiver == "string")
        return J.JSString.prototype;
      if (receiver == null)
        return receiver;
      if (Array.isArray(receiver))
        return J.JSArray.prototype;
      if (typeof receiver != "object") {
        if (typeof receiver == "function")
          return J.JavaScriptFunction.prototype;
        if (typeof receiver == "symbol")
          return J.JavaScriptSymbol.prototype;
        if (typeof receiver == "bigint")
          return J.JavaScriptBigInt.prototype;
        return receiver;
      }
      if (receiver instanceof A.Object)
        return receiver;
      return J.getNativeInterceptor(receiver);
    },
    getInterceptor$asx(receiver) {
      if (typeof receiver == "string")
        return J.JSString.prototype;
      if (receiver == null)
        return receiver;
      if (Array.isArray(receiver))
        return J.JSArray.prototype;
      if (typeof receiver != "object") {
        if (typeof receiver == "function")
          return J.JavaScriptFunction.prototype;
        if (typeof receiver == "symbol")
          return J.JavaScriptSymbol.prototype;
        if (typeof receiver == "bigint")
          return J.JavaScriptBigInt.prototype;
        return receiver;
      }
      if (receiver instanceof A.Object)
        return receiver;
      return J.getNativeInterceptor(receiver);
    },
    getInterceptor$ax(receiver) {
      if (receiver == null)
        return receiver;
      if (Array.isArray(receiver))
        return J.JSArray.prototype;
      if (typeof receiver != "object") {
        if (typeof receiver == "function")
          return J.JavaScriptFunction.prototype;
        if (typeof receiver == "symbol")
          return J.JavaScriptSymbol.prototype;
        if (typeof receiver == "bigint")
          return J.JavaScriptBigInt.prototype;
        return receiver;
      }
      if (receiver instanceof A.Object)
        return receiver;
      return J.getNativeInterceptor(receiver);
    },
    getInterceptor$in(receiver) {
      if (typeof receiver == "number") {
        if (Math.floor(receiver) == receiver)
          return J.JSInt.prototype;
        return J.JSNumNotInt.prototype;
      }
      if (receiver == null)
        return receiver;
      if (!(receiver instanceof A.Object))
        return J.UnknownJavaScriptObject.prototype;
      return receiver;
    },
    getInterceptor$n(receiver) {
      if (typeof receiver == "number")
        return J.JSNumber.prototype;
      if (receiver == null)
        return receiver;
      if (!(receiver instanceof A.Object))
        return J.UnknownJavaScriptObject.prototype;
      return receiver;
    },
    getInterceptor$ns(receiver) {
      if (typeof receiver == "number")
        return J.JSNumber.prototype;
      if (typeof receiver == "string")
        return J.JSString.prototype;
      if (receiver == null)
        return receiver;
      if (!(receiver instanceof A.Object))
        return J.UnknownJavaScriptObject.prototype;
      return receiver;
    },
    getInterceptor$s(receiver) {
      if (typeof receiver == "string")
        return J.JSString.prototype;
      if (receiver == null)
        return receiver;
      if (!(receiver instanceof A.Object))
        return J.UnknownJavaScriptObject.prototype;
      return receiver;
    },
    getInterceptor$x(receiver) {
      if (receiver == null)
        return receiver;
      if (typeof receiver != "object") {
        if (typeof receiver == "function")
          return J.JavaScriptFunction.prototype;
        if (typeof receiver == "symbol")
          return J.JavaScriptSymbol.prototype;
        if (typeof receiver == "bigint")
          return J.JavaScriptBigInt.prototype;
        return receiver;
      }
      if (receiver instanceof A.Object)
        return receiver;
      return J.getNativeInterceptor(receiver);
    },
    getInterceptor$z(receiver) {
      if (receiver == null)
        return receiver;
      if (!(receiver instanceof A.Object))
        return J.UnknownJavaScriptObject.prototype;
      return receiver;
    },
    set$AsyncCompiler$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$AsyncCompiler(receiver, value);
    },
    set$CalculationInterpolation$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$CalculationInterpolation(receiver, value);
    },
    set$CalculationOperation$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$CalculationOperation(receiver, value);
    },
    set$Compiler$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$Compiler(receiver, value);
    },
    set$Exception$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$Exception(receiver, value);
    },
    set$FALSE$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$FALSE(receiver, value);
    },
    set$Logger$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$Logger(receiver, value);
    },
    set$NULL$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$NULL(receiver, value);
    },
    set$NodePackageImporter$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$NodePackageImporter(receiver, value);
    },
    set$SassArgumentList$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$SassArgumentList(receiver, value);
    },
    set$SassBoolean$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$SassBoolean(receiver, value);
    },
    set$SassCalculation$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$SassCalculation(receiver, value);
    },
    set$SassColor$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$SassColor(receiver, value);
    },
    set$SassFunction$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$SassFunction(receiver, value);
    },
    set$SassList$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$SassList(receiver, value);
    },
    set$SassMap$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$SassMap(receiver, value);
    },
    set$SassMixin$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$SassMixin(receiver, value);
    },
    set$SassNumber$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$SassNumber(receiver, value);
    },
    set$SassString$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$SassString(receiver, value);
    },
    set$TRUE$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$TRUE(receiver, value);
    },
    set$Value$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$Value(receiver, value);
    },
    set$Version$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$Version(receiver, value);
    },
    set$cli_pkg_main_0_$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$cli_pkg_main_0_(receiver, value);
    },
    set$compile$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$compile(receiver, value);
    },
    set$compileAsync$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$compileAsync(receiver, value);
    },
    set$compileString$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$compileString(receiver, value);
    },
    set$compileStringAsync$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$compileStringAsync(receiver, value);
    },
    set$context$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$context(receiver, value);
    },
    set$dartValue$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$dartValue(receiver, value);
    },
    set$deprecations$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$deprecations(receiver, value);
    },
    set$exitCode$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$exitCode(receiver, value);
    },
    set$info$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$info(receiver, value);
    },
    set$initAsyncCompiler$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$initAsyncCompiler(receiver, value);
    },
    set$initCompiler$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$initCompiler(receiver, value);
    },
    set$length$asx(receiver, value) {
      return J.getInterceptor$asx(receiver).set$length(receiver, value);
    },
    set$render$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$render(receiver, value);
    },
    set$renderSync$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$renderSync(receiver, value);
    },
    set$sassFalse$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$sassFalse(receiver, value);
    },
    set$sassNull$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$sassNull(receiver, value);
    },
    set$sassTrue$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$sassTrue(receiver, value);
    },
    set$types$x(receiver, value) {
      return J.getInterceptor$x(receiver).set$types(receiver, value);
    },
    get$$prototype$x(receiver) {
      return J.getInterceptor$x(receiver).get$$prototype(receiver);
    },
    get$_dartException$x(receiver) {
      return J.getInterceptor$x(receiver).get$_dartException(receiver);
    },
    get$alertAscii$x(receiver) {
      return J.getInterceptor$x(receiver).get$alertAscii(receiver);
    },
    get$alertColor$x(receiver) {
      return J.getInterceptor$x(receiver).get$alertColor(receiver);
    },
    get$argv$x(receiver) {
      return J.getInterceptor$x(receiver).get$argv(receiver);
    },
    get$blue$x(receiver) {
      return J.getInterceptor$x(receiver).get$blue(receiver);
    },
    get$brackets$x(receiver) {
      return J.getInterceptor$x(receiver).get$brackets(receiver);
    },
    get$charset$x(receiver) {
      return J.getInterceptor$x(receiver).get$charset(receiver);
    },
    get$code$x(receiver) {
      return J.getInterceptor$x(receiver).get$code(receiver);
    },
    get$current$x(receiver) {
      return J.getInterceptor$x(receiver).get$current(receiver);
    },
    get$dartValue$x(receiver) {
      return J.getInterceptor$x(receiver).get$dartValue(receiver);
    },
    get$debug$x(receiver) {
      return J.getInterceptor$x(receiver).get$debug(receiver);
    },
    get$denominatorUnits$x(receiver) {
      return J.getInterceptor$x(receiver).get$denominatorUnits(receiver);
    },
    get$end$z(receiver) {
      return J.getInterceptor$z(receiver).get$end(receiver);
    },
    get$env$x(receiver) {
      return J.getInterceptor$x(receiver).get$env(receiver);
    },
    get$exitCode$x(receiver) {
      return J.getInterceptor$x(receiver).get$exitCode(receiver);
    },
    get$fatalDeprecations$x(receiver) {
      return J.getInterceptor$x(receiver).get$fatalDeprecations(receiver);
    },
    get$fiber$x(receiver) {
      return J.getInterceptor$x(receiver).get$fiber(receiver);
    },
    get$file$x(receiver) {
      return J.getInterceptor$x(receiver).get$file(receiver);
    },
    get$filename$x(receiver) {
      return J.getInterceptor$x(receiver).get$filename(receiver);
    },
    get$first$ax(receiver) {
      return J.getInterceptor$ax(receiver).get$first(receiver);
    },
    get$functions$x(receiver) {
      return J.getInterceptor$x(receiver).get$functions(receiver);
    },
    get$futureDeprecations$x(receiver) {
      return J.getInterceptor$x(receiver).get$futureDeprecations(receiver);
    },
    get$green$x(receiver) {
      return J.getInterceptor$x(receiver).get$green(receiver);
    },
    get$hashCode$(receiver) {
      return J.getInterceptor$(receiver).get$hashCode(receiver);
    },
    get$id$x(receiver) {
      return J.getInterceptor$x(receiver).get$id(receiver);
    },
    get$importer$x(receiver) {
      return J.getInterceptor$x(receiver).get$importer(receiver);
    },
    get$importers$x(receiver) {
      return J.getInterceptor$x(receiver).get$importers(receiver);
    },
    get$isEmpty$asx(receiver) {
      return J.getInterceptor$asx(receiver).get$isEmpty(receiver);
    },
    get$isNotEmpty$asx(receiver) {
      return J.getInterceptor$asx(receiver).get$isNotEmpty(receiver);
    },
    get$isTTY$x(receiver) {
      return J.getInterceptor$x(receiver).get$isTTY(receiver);
    },
    get$iterator$ax(receiver) {
      return J.getInterceptor$ax(receiver).get$iterator(receiver);
    },
    get$keys$z(receiver) {
      return J.getInterceptor$z(receiver).get$keys(receiver);
    },
    get$last$ax(receiver) {
      return J.getInterceptor$ax(receiver).get$last(receiver);
    },
    get$length$asx(receiver) {
      return J.getInterceptor$asx(receiver).get$length(receiver);
    },
    get$loadPaths$x(receiver) {
      return J.getInterceptor$x(receiver).get$loadPaths(receiver);
    },
    get$logger$x(receiver) {
      return J.getInterceptor$x(receiver).get$logger(receiver);
    },
    get$message$x(receiver) {
      return J.getInterceptor$x(receiver).get$message(receiver);
    },
    get$mtime$x(receiver) {
      return J.getInterceptor$x(receiver).get$mtime(receiver);
    },
    get$name$x(receiver) {
      return J.getInterceptor$x(receiver).get$name(receiver);
    },
    get$numeratorUnits$x(receiver) {
      return J.getInterceptor$x(receiver).get$numeratorUnits(receiver);
    },
    get$options$x(receiver) {
      return J.getInterceptor$x(receiver).get$options(receiver);
    },
    get$parent$z(receiver) {
      return J.getInterceptor$z(receiver).get$parent(receiver);
    },
    get$path$x(receiver) {
      return J.getInterceptor$x(receiver).get$path(receiver);
    },
    get$platform$x(receiver) {
      return J.getInterceptor$x(receiver).get$platform(receiver);
    },
    get$quietDeps$x(receiver) {
      return J.getInterceptor$x(receiver).get$quietDeps(receiver);
    },
    get$quotes$x(receiver) {
      return J.getInterceptor$x(receiver).get$quotes(receiver);
    },
    get$red$x(receiver) {
      return J.getInterceptor$x(receiver).get$red(receiver);
    },
    get$release$x(receiver) {
      return J.getInterceptor$x(receiver).get$release(receiver);
    },
    get$reversed$ax(receiver) {
      return J.getInterceptor$ax(receiver).get$reversed(receiver);
    },
    get$runtimeType$(receiver) {
      return J.getInterceptor$(receiver).get$runtimeType(receiver);
    },
    get$separator$x(receiver) {
      return J.getInterceptor$x(receiver).get$separator(receiver);
    },
    get$sign$in(receiver) {
      if (typeof receiver === "number")
        return receiver > 0 ? 1 : receiver < 0 ? -1 : receiver;
      return J.getInterceptor$in(receiver).get$sign(receiver);
    },
    get$silenceDeprecations$x(receiver) {
      return J.getInterceptor$x(receiver).get$silenceDeprecations(receiver);
    },
    get$single$ax(receiver) {
      return J.getInterceptor$ax(receiver).get$single(receiver);
    },
    get$sourceMap$x(receiver) {
      return J.getInterceptor$x(receiver).get$sourceMap(receiver);
    },
    get$sourceMapIncludeSources$x(receiver) {
      return J.getInterceptor$x(receiver).get$sourceMapIncludeSources(receiver);
    },
    get$span$z(receiver) {
      return J.getInterceptor$z(receiver).get$span(receiver);
    },
    get$stderr$x(receiver) {
      return J.getInterceptor$x(receiver).get$stderr(receiver);
    },
    get$stdout$x(receiver) {
      return J.getInterceptor$x(receiver).get$stdout(receiver);
    },
    get$style$x(receiver) {
      return J.getInterceptor$x(receiver).get$style(receiver);
    },
    get$syntax$x(receiver) {
      return J.getInterceptor$x(receiver).get$syntax(receiver);
    },
    get$trace$z(receiver) {
      return J.getInterceptor$z(receiver).get$trace(receiver);
    },
    get$url$x(receiver) {
      return J.getInterceptor$x(receiver).get$url(receiver);
    },
    get$verbose$x(receiver) {
      return J.getInterceptor$x(receiver).get$verbose(receiver);
    },
    get$warn$x(receiver) {
      return J.getInterceptor$x(receiver).get$warn(receiver);
    },
    $add$ansx(receiver, a0) {
      if (typeof receiver == "number" && typeof a0 == "number")
        return receiver + a0;
      return J.getInterceptor$ansx(receiver).$add(receiver, a0);
    },
    $eq$(receiver, a0) {
      if (receiver == null)
        return a0 == null;
      if (typeof receiver != "object")
        return a0 != null && receiver === a0;
      return J.getInterceptor$(receiver).$eq(receiver, a0);
    },
    $index$asx(receiver, a0) {
      if (typeof a0 === "number")
        if (Array.isArray(receiver) || typeof receiver == "string" || A.isJsIndexable(receiver, receiver[init.dispatchPropertyName]))
          if (a0 >>> 0 === a0 && a0 < receiver.length)
            return receiver[a0];
      return J.getInterceptor$asx(receiver).$index(receiver, a0);
    },
    $indexSet$ax(receiver, a0, a1) {
      if (typeof a0 === "number")
        if ((Array.isArray(receiver) || A.isJsIndexable(receiver, receiver[init.dispatchPropertyName])) && !receiver.immutable$list && a0 >>> 0 === a0 && a0 < receiver.length)
          return receiver[a0] = a1;
      return J.getInterceptor$ax(receiver).$indexSet(receiver, a0, a1);
    },
    $set$2$x(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).$set$2(receiver, a0, a1);
    },
    add$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).add$1(receiver, a0);
    },
    addAll$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).addAll$1(receiver, a0);
    },
    allMatches$1$s(receiver, a0) {
      return J.getInterceptor$s(receiver).allMatches$1(receiver, a0);
    },
    allMatches$2$s(receiver, a0, a1) {
      return J.getInterceptor$s(receiver).allMatches$2(receiver, a0, a1);
    },
    any$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).any$1(receiver, a0);
    },
    apply$2$x(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).apply$2(receiver, a0, a1);
    },
    asImmutable$0$x(receiver) {
      return J.getInterceptor$x(receiver).asImmutable$0(receiver);
    },
    asMutable$0$x(receiver) {
      return J.getInterceptor$x(receiver).asMutable$0(receiver);
    },
    canonicalize$4$baseImporter$baseUrl$forImport$x(receiver, a0, a1, a2, a3) {
      return J.getInterceptor$x(receiver).canonicalize$4$baseImporter$baseUrl$forImport(receiver, a0, a1, a2, a3);
    },
    cast$1$0$ax(receiver, $T1) {
      return J.getInterceptor$ax(receiver).cast$1$0(receiver, $T1);
    },
    close$0$x(receiver) {
      return J.getInterceptor$x(receiver).close$0(receiver);
    },
    codeUnitAt$1$s(receiver, a0) {
      return J.getInterceptor$s(receiver).codeUnitAt$1(receiver, a0);
    },
    compareTo$1$ns(receiver, a0) {
      return J.getInterceptor$ns(receiver).compareTo$1(receiver, a0);
    },
    contains$1$asx(receiver, a0) {
      return J.getInterceptor$asx(receiver).contains$1(receiver, a0);
    },
    createInterface$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).createInterface$1(receiver, a0);
    },
    createRequire$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).createRequire$1(receiver, a0);
    },
    elementAt$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).elementAt$1(receiver, a0);
    },
    endsWith$1$s(receiver, a0) {
      return J.getInterceptor$s(receiver).endsWith$1(receiver, a0);
    },
    error$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).error$1(receiver, a0);
    },
    every$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).every$1(receiver, a0);
    },
    existsSync$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).existsSync$1(receiver, a0);
    },
    expand$1$1$ax(receiver, a0, $T1) {
      return J.getInterceptor$ax(receiver).expand$1$1(receiver, a0, $T1);
    },
    fillRange$3$ax(receiver, a0, a1, a2) {
      return J.getInterceptor$ax(receiver).fillRange$3(receiver, a0, a1, a2);
    },
    fold$2$ax(receiver, a0, a1) {
      return J.getInterceptor$ax(receiver).fold$2(receiver, a0, a1);
    },
    forEach$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).forEach$1(receiver, a0);
    },
    getRange$2$ax(receiver, a0, a1) {
      return J.getInterceptor$ax(receiver).getRange$2(receiver, a0, a1);
    },
    getTime$0$x(receiver) {
      return J.getInterceptor$x(receiver).getTime$0(receiver);
    },
    isDirectory$0$x(receiver) {
      return J.getInterceptor$x(receiver).isDirectory$0(receiver);
    },
    isFile$0$x(receiver) {
      return J.getInterceptor$x(receiver).isFile$0(receiver);
    },
    join$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).join$1(receiver, a0);
    },
    listen$1$z(receiver, a0) {
      return J.getInterceptor$z(receiver).listen$1(receiver, a0);
    },
    log$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).log$1(receiver, a0);
    },
    map$1$1$ax(receiver, a0, $T1) {
      return J.getInterceptor$ax(receiver).map$1$1(receiver, a0, $T1);
    },
    matchAsPrefix$2$s(receiver, a0, a1) {
      return J.getInterceptor$s(receiver).matchAsPrefix$2(receiver, a0, a1);
    },
    mkdirSync$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).mkdirSync$1(receiver, a0);
    },
    noSuchMethod$1$(receiver, a0) {
      return J.getInterceptor$(receiver).noSuchMethod$1(receiver, a0);
    },
    on$2$x(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).on$2(receiver, a0, a1);
    },
    readFileSync$2$x(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).readFileSync$2(receiver, a0, a1);
    },
    readdirSync$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).readdirSync$1(receiver, a0);
    },
    remove$1$z(receiver, a0) {
      return J.getInterceptor$z(receiver).remove$1(receiver, a0);
    },
    removeRange$2$ax(receiver, a0, a1) {
      return J.getInterceptor$ax(receiver).removeRange$2(receiver, a0, a1);
    },
    replaceFirst$2$s(receiver, a0, a1) {
      return J.getInterceptor$s(receiver).replaceFirst$2(receiver, a0, a1);
    },
    resolve$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).resolve$1(receiver, a0);
    },
    run$0$x(receiver) {
      return J.getInterceptor$x(receiver).run$0(receiver);
    },
    run$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).run$1(receiver, a0);
    },
    setRange$4$ax(receiver, a0, a1, a2, a3) {
      return J.getInterceptor$ax(receiver).setRange$4(receiver, a0, a1, a2, a3);
    },
    skip$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).skip$1(receiver, a0);
    },
    sort$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).sort$1(receiver, a0);
    },
    startsWith$1$s(receiver, a0) {
      return J.getInterceptor$s(receiver).startsWith$1(receiver, a0);
    },
    statSync$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).statSync$1(receiver, a0);
    },
    sublist$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).sublist$1(receiver, a0);
    },
    substring$1$s(receiver, a0) {
      return J.getInterceptor$s(receiver).substring$1(receiver, a0);
    },
    substring$2$s(receiver, a0, a1) {
      return J.getInterceptor$s(receiver).substring$2(receiver, a0, a1);
    },
    take$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).take$1(receiver, a0);
    },
    then$1$1$x(receiver, a0, $T1) {
      return J.getInterceptor$x(receiver).then$1$1(receiver, a0, $T1);
    },
    then$1$2$onError$x(receiver, a0, a1, $T1) {
      return J.getInterceptor$x(receiver).then$1$2$onError(receiver, a0, a1, $T1);
    },
    then$2$x(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).then$2(receiver, a0, a1);
    },
    toArray$0$x(receiver) {
      return J.getInterceptor$x(receiver).toArray$0(receiver);
    },
    toList$0$ax(receiver) {
      return J.getInterceptor$ax(receiver).toList$0(receiver);
    },
    toList$1$growable$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).toList$1$growable(receiver, a0);
    },
    toRadixString$1$n(receiver, a0) {
      return J.getInterceptor$n(receiver).toRadixString$1(receiver, a0);
    },
    toSet$0$ax(receiver) {
      return J.getInterceptor$ax(receiver).toSet$0(receiver);
    },
    toString$0$(receiver) {
      return J.getInterceptor$(receiver).toString$0(receiver);
    },
    toString$1$color$(receiver, a0) {
      return J.getInterceptor$(receiver).toString$1$color(receiver, a0);
    },
    trim$0$s(receiver) {
      return J.getInterceptor$s(receiver).trim$0(receiver);
    },
    unlinkSync$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).unlinkSync$1(receiver, a0);
    },
    watch$2$x(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).watch$2(receiver, a0, a1);
    },
    where$1$ax(receiver, a0) {
      return J.getInterceptor$ax(receiver).where$1(receiver, a0);
    },
    write$1$x(receiver, a0) {
      return J.getInterceptor$x(receiver).write$1(receiver, a0);
    },
    writeFileSync$2$x(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).writeFileSync$2(receiver, a0, a1);
    },
    yield$0$x(receiver) {
      return J.getInterceptor$x(receiver).yield$0(receiver);
    },
    Interceptor: function Interceptor() {
    },
    JSBool: function JSBool() {
    },
    JSNull: function JSNull() {
    },
    JavaScriptObject: function JavaScriptObject() {
    },
    LegacyJavaScriptObject: function LegacyJavaScriptObject() {
    },
    PlainJavaScriptObject: function PlainJavaScriptObject() {
    },
    UnknownJavaScriptObject: function UnknownJavaScriptObject() {
    },
    JavaScriptFunction: function JavaScriptFunction() {
    },
    JavaScriptBigInt: function JavaScriptBigInt() {
    },
    JavaScriptSymbol: function JavaScriptSymbol() {
    },
    JSArray: function JSArray(t0) {
      this.$ti = t0;
    },
    JSUnmodifiableArray: function JSUnmodifiableArray(t0) {
      this.$ti = t0;
    },
    ArrayIterator: function ArrayIterator(t0, t1, t2) {
      var _ = this;
      _._iterable = t0;
      _._length = t1;
      _._index = 0;
      _._current = null;
      _.$ti = t2;
    },
    JSNumber: function JSNumber() {
    },
    JSInt: function JSInt() {
    },
    JSNumNotInt: function JSNumNotInt() {
    },
    JSString: function JSString() {
    }
  },
  A = {JS_CONST: function JS_CONST() {
    },
    CastIterable_CastIterable(source, $S, $T) {
      if ($S._eval$1("EfficientLengthIterable<0>")._is(source))
        return new A._EfficientLengthCastIterable(source, $S._eval$1("@<0>")._bind$1($T)._eval$1("_EfficientLengthCastIterable<1,2>"));
      return new A.CastIterable(source, $S._eval$1("@<0>")._bind$1($T)._eval$1("CastIterable<1,2>"));
    },
    LateError$localNI(localName) {
      return new A.LateError("Local '" + localName + "' has not been initialized.");
    },
    ReachabilityError$(_message) {
      return new A.ReachabilityError(_message);
    },
    hexDigitValue(char) {
      var letter,
        digit = char ^ 48;
      if (digit <= 9)
        return digit;
      letter = char | 32;
      if (97 <= letter && letter <= 102)
        return letter - 87;
      return -1;
    },
    SystemHash_combine(hash, value) {
      hash = hash + value & 536870911;
      hash = hash + ((hash & 524287) << 10) & 536870911;
      return hash ^ hash >>> 6;
    },
    SystemHash_finish(hash) {
      hash = hash + ((hash & 67108863) << 3) & 536870911;
      hash ^= hash >>> 11;
      return hash + ((hash & 16383) << 15) & 536870911;
    },
    checkNotNullable(value, $name, $T) {
      return value;
    },
    isToStringVisiting(object) {
      var t1, i;
      for (t1 = $.toStringVisiting.length, i = 0; i < t1; ++i)
        if (object === $.toStringVisiting[i])
          return true;
      return false;
    },
    SubListIterable$(_iterable, _start, _endOrLength, $E) {
      A.RangeError_checkNotNegative(_start, "start");
      if (_endOrLength != null) {
        A.RangeError_checkNotNegative(_endOrLength, "end");
        if (_start > _endOrLength)
          A.throwExpression(A.RangeError$range(_start, 0, _endOrLength, "start", null));
      }
      return new A.SubListIterable(_iterable, _start, _endOrLength, $E._eval$1("SubListIterable<0>"));
    },
    MappedIterable_MappedIterable(iterable, $function, $S, $T) {
      if (type$.EfficientLengthIterable_dynamic._is(iterable))
        return new A.EfficientLengthMappedIterable(iterable, $function, $S._eval$1("@<0>")._bind$1($T)._eval$1("EfficientLengthMappedIterable<1,2>"));
      return new A.MappedIterable(iterable, $function, $S._eval$1("@<0>")._bind$1($T)._eval$1("MappedIterable<1,2>"));
    },
    TakeIterable_TakeIterable(iterable, takeCount, $E) {
      var _s9_ = "takeCount";
      A.ArgumentError_checkNotNull(takeCount, _s9_);
      A.RangeError_checkNotNegative(takeCount, _s9_);
      if (type$.EfficientLengthIterable_dynamic._is(iterable))
        return new A.EfficientLengthTakeIterable(iterable, takeCount, $E._eval$1("EfficientLengthTakeIterable<0>"));
      return new A.TakeIterable(iterable, takeCount, $E._eval$1("TakeIterable<0>"));
    },
    SkipIterable_SkipIterable(iterable, count, $E) {
      var _s5_ = "count";
      if (type$.EfficientLengthIterable_dynamic._is(iterable)) {
        A.ArgumentError_checkNotNull(count, _s5_);
        A.RangeError_checkNotNegative(count, _s5_);
        return new A.EfficientLengthSkipIterable(iterable, count, $E._eval$1("EfficientLengthSkipIterable<0>"));
      }
      A.ArgumentError_checkNotNull(count, _s5_);
      A.RangeError_checkNotNegative(count, _s5_);
      return new A.SkipIterable(iterable, count, $E._eval$1("SkipIterable<0>"));
    },
    FollowedByIterable_FollowedByIterable$firstEfficient(first, second, $E) {
      if ($E._eval$1("EfficientLengthIterable<0>")._is(second))
        return new A.EfficientLengthFollowedByIterable(first, second, $E._eval$1("EfficientLengthFollowedByIterable<0>"));
      return new A.FollowedByIterable(first, second, $E._eval$1("FollowedByIterable<0>"));
    },
    IterableElementError_noElement() {
      return new A.StateError("No element");
    },
    IterableElementError_tooMany() {
      return new A.StateError("Too many elements");
    },
    IterableElementError_tooFew() {
      return new A.StateError("Too few elements");
    },
    Sort__doSort(a, left, right, compare) {
      if (right - left <= 32)
        A.Sort__insertionSort(a, left, right, compare);
      else
        A.Sort__dualPivotQuicksort(a, left, right, compare);
    },
    Sort__insertionSort(a, left, right, compare) {
      var i, t1, el, j, j0;
      for (i = left + 1, t1 = J.getInterceptor$asx(a); i <= right; ++i) {
        el = t1.$index(a, i);
        j = i;
        while (true) {
          if (!(j > left && compare.call$2(t1.$index(a, j - 1), el) > 0))
            break;
          j0 = j - 1;
          t1.$indexSet(a, j, t1.$index(a, j0));
          j = j0;
        }
        t1.$indexSet(a, j, el);
      }
    },
    Sort__dualPivotQuicksort(a, left, right, compare) {
      var t0, less, great, pivots_are_equal, k, ak, comp, great0, less0, t2,
        sixth = B.JSInt_methods._tdivFast$1(right - left + 1, 6),
        index1 = left + sixth,
        index5 = right - sixth,
        index3 = B.JSInt_methods._tdivFast$1(left + right, 2),
        index2 = index3 - sixth,
        index4 = index3 + sixth,
        t1 = J.getInterceptor$asx(a),
        el1 = t1.$index(a, index1),
        el2 = t1.$index(a, index2),
        el3 = t1.$index(a, index3),
        el4 = t1.$index(a, index4),
        el5 = t1.$index(a, index5);
      if (compare.call$2(el1, el2) > 0) {
        t0 = el2;
        el2 = el1;
        el1 = t0;
      }
      if (compare.call$2(el4, el5) > 0) {
        t0 = el5;
        el5 = el4;
        el4 = t0;
      }
      if (compare.call$2(el1, el3) > 0) {
        t0 = el3;
        el3 = el1;
        el1 = t0;
      }
      if (compare.call$2(el2, el3) > 0) {
        t0 = el3;
        el3 = el2;
        el2 = t0;
      }
      if (compare.call$2(el1, el4) > 0) {
        t0 = el4;
        el4 = el1;
        el1 = t0;
      }
      if (compare.call$2(el3, el4) > 0) {
        t0 = el4;
        el4 = el3;
        el3 = t0;
      }
      if (compare.call$2(el2, el5) > 0) {
        t0 = el5;
        el5 = el2;
        el2 = t0;
      }
      if (compare.call$2(el2, el3) > 0) {
        t0 = el3;
        el3 = el2;
        el2 = t0;
      }
      if (compare.call$2(el4, el5) > 0) {
        t0 = el5;
        el5 = el4;
        el4 = t0;
      }
      t1.$indexSet(a, index1, el1);
      t1.$indexSet(a, index3, el3);
      t1.$indexSet(a, index5, el5);
      t1.$indexSet(a, index2, t1.$index(a, left));
      t1.$indexSet(a, index4, t1.$index(a, right));
      less = left + 1;
      great = right - 1;
      pivots_are_equal = J.$eq$(compare.call$2(el2, el4), 0);
      if (pivots_are_equal)
        for (k = less; k <= great; ++k) {
          ak = t1.$index(a, k);
          comp = compare.call$2(ak, el2);
          if (comp === 0)
            continue;
          if (comp < 0) {
            if (k !== less) {
              t1.$indexSet(a, k, t1.$index(a, less));
              t1.$indexSet(a, less, ak);
            }
            ++less;
          } else
            for (; true;) {
              comp = compare.call$2(t1.$index(a, great), el2);
              if (comp > 0) {
                --great;
                continue;
              } else {
                great0 = great - 1;
                if (comp < 0) {
                  t1.$indexSet(a, k, t1.$index(a, less));
                  less0 = less + 1;
                  t1.$indexSet(a, less, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                  great = great0;
                  less = less0;
                  break;
                } else {
                  t1.$indexSet(a, k, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                  great = great0;
                  break;
                }
              }
            }
        }
      else
        for (k = less; k <= great; ++k) {
          ak = t1.$index(a, k);
          if (compare.call$2(ak, el2) < 0) {
            if (k !== less) {
              t1.$indexSet(a, k, t1.$index(a, less));
              t1.$indexSet(a, less, ak);
            }
            ++less;
          } else if (compare.call$2(ak, el4) > 0)
            for (; true;)
              if (compare.call$2(t1.$index(a, great), el4) > 0) {
                --great;
                if (great < k)
                  break;
                continue;
              } else {
                great0 = great - 1;
                if (compare.call$2(t1.$index(a, great), el2) < 0) {
                  t1.$indexSet(a, k, t1.$index(a, less));
                  less0 = less + 1;
                  t1.$indexSet(a, less, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                  less = less0;
                } else {
                  t1.$indexSet(a, k, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                }
                great = great0;
                break;
              }
        }
      t2 = less - 1;
      t1.$indexSet(a, left, t1.$index(a, t2));
      t1.$indexSet(a, t2, el2);
      t2 = great + 1;
      t1.$indexSet(a, right, t1.$index(a, t2));
      t1.$indexSet(a, t2, el4);
      A.Sort__doSort(a, left, less - 2, compare);
      A.Sort__doSort(a, great + 2, right, compare);
      if (pivots_are_equal)
        return;
      if (less < index1 && great > index5) {
        for (; J.$eq$(compare.call$2(t1.$index(a, less), el2), 0);)
          ++less;
        for (; J.$eq$(compare.call$2(t1.$index(a, great), el4), 0);)
          --great;
        for (k = less; k <= great; ++k) {
          ak = t1.$index(a, k);
          if (compare.call$2(ak, el2) === 0) {
            if (k !== less) {
              t1.$indexSet(a, k, t1.$index(a, less));
              t1.$indexSet(a, less, ak);
            }
            ++less;
          } else if (compare.call$2(ak, el4) === 0)
            for (; true;)
              if (compare.call$2(t1.$index(a, great), el4) === 0) {
                --great;
                if (great < k)
                  break;
                continue;
              } else {
                great0 = great - 1;
                if (compare.call$2(t1.$index(a, great), el2) < 0) {
                  t1.$indexSet(a, k, t1.$index(a, less));
                  less0 = less + 1;
                  t1.$indexSet(a, less, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                  less = less0;
                } else {
                  t1.$indexSet(a, k, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                }
                great = great0;
                break;
              }
        }
        A.Sort__doSort(a, less, great, compare);
      } else
        A.Sort__doSort(a, less, great, compare);
    },
    _CastIterableBase: function _CastIterableBase() {
    },
    CastIterator: function CastIterator(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    CastIterable: function CastIterable(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    _EfficientLengthCastIterable: function _EfficientLengthCastIterable(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    _CastListBase: function _CastListBase() {
    },
    _CastListBase_sort_closure: function _CastListBase_sort_closure(t0, t1) {
      this.$this = t0;
      this.compare = t1;
    },
    CastList: function CastList(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    CastSet: function CastSet(t0, t1, t2) {
      this._source = t0;
      this._emptySet = t1;
      this.$ti = t2;
    },
    CastMap: function CastMap(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    CastMap_forEach_closure: function CastMap_forEach_closure(t0, t1) {
      this.$this = t0;
      this.f = t1;
    },
    CastMap_entries_closure: function CastMap_entries_closure(t0) {
      this.$this = t0;
    },
    LateError: function LateError(t0) {
      this._message = t0;
    },
    ReachabilityError: function ReachabilityError(t0) {
      this._message = t0;
    },
    CodeUnits: function CodeUnits(t0) {
      this._string = t0;
    },
    nullFuture_closure: function nullFuture_closure() {
    },
    SentinelValue: function SentinelValue() {
    },
    EfficientLengthIterable: function EfficientLengthIterable() {
    },
    ListIterable: function ListIterable() {
    },
    SubListIterable: function SubListIterable(t0, t1, t2, t3) {
      var _ = this;
      _.__internal$_iterable = t0;
      _._start = t1;
      _._endOrLength = t2;
      _.$ti = t3;
    },
    ListIterator: function ListIterator(t0, t1, t2) {
      var _ = this;
      _.__internal$_iterable = t0;
      _.__internal$_length = t1;
      _.__internal$_index = 0;
      _.__internal$_current = null;
      _.$ti = t2;
    },
    MappedIterable: function MappedIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._f = t1;
      this.$ti = t2;
    },
    EfficientLengthMappedIterable: function EfficientLengthMappedIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._f = t1;
      this.$ti = t2;
    },
    MappedIterator: function MappedIterator(t0, t1, t2) {
      var _ = this;
      _.__internal$_current = null;
      _._iterator = t0;
      _._f = t1;
      _.$ti = t2;
    },
    MappedListIterable: function MappedListIterable(t0, t1, t2) {
      this._source = t0;
      this._f = t1;
      this.$ti = t2;
    },
    WhereIterable: function WhereIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._f = t1;
      this.$ti = t2;
    },
    WhereIterator: function WhereIterator(t0, t1) {
      this._iterator = t0;
      this._f = t1;
    },
    ExpandIterable: function ExpandIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._f = t1;
      this.$ti = t2;
    },
    ExpandIterator: function ExpandIterator(t0, t1, t2, t3) {
      var _ = this;
      _._iterator = t0;
      _._f = t1;
      _._currentExpansion = t2;
      _.__internal$_current = null;
      _.$ti = t3;
    },
    TakeIterable: function TakeIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._takeCount = t1;
      this.$ti = t2;
    },
    EfficientLengthTakeIterable: function EfficientLengthTakeIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._takeCount = t1;
      this.$ti = t2;
    },
    TakeIterator: function TakeIterator(t0, t1, t2) {
      this._iterator = t0;
      this._remaining = t1;
      this.$ti = t2;
    },
    SkipIterable: function SkipIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._skipCount = t1;
      this.$ti = t2;
    },
    EfficientLengthSkipIterable: function EfficientLengthSkipIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._skipCount = t1;
      this.$ti = t2;
    },
    SkipIterator: function SkipIterator(t0, t1) {
      this._iterator = t0;
      this._skipCount = t1;
    },
    SkipWhileIterable: function SkipWhileIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._f = t1;
      this.$ti = t2;
    },
    SkipWhileIterator: function SkipWhileIterator(t0, t1) {
      this._iterator = t0;
      this._f = t1;
      this._hasSkipped = false;
    },
    EmptyIterable: function EmptyIterable(t0) {
      this.$ti = t0;
    },
    EmptyIterator: function EmptyIterator() {
    },
    FollowedByIterable: function FollowedByIterable(t0, t1, t2) {
      this.__internal$_first = t0;
      this._second = t1;
      this.$ti = t2;
    },
    EfficientLengthFollowedByIterable: function EfficientLengthFollowedByIterable(t0, t1, t2) {
      this.__internal$_first = t0;
      this._second = t1;
      this.$ti = t2;
    },
    FollowedByIterator: function FollowedByIterator(t0, t1) {
      this._currentIterator = t0;
      this._nextIterable = t1;
    },
    WhereTypeIterable: function WhereTypeIterable(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    WhereTypeIterator: function WhereTypeIterator(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    FixedLengthListMixin: function FixedLengthListMixin() {
    },
    UnmodifiableListMixin: function UnmodifiableListMixin() {
    },
    UnmodifiableListBase: function UnmodifiableListBase() {
    },
    ReversedListIterable: function ReversedListIterable(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    Symbol: function Symbol(t0) {
      this.__internal$_name = t0;
    },
    __CastListBase__CastIterableBase_ListMixin: function __CastListBase__CastIterableBase_ListMixin() {
    },
    ConstantMap_ConstantMap$from(other, $K, $V) {
      var allStrings, k, object, index, index0, map,
        keys = A.List_List$from(other.get$keys(other), true, $K),
        t1 = keys.length,
        _i = 0;
      while (true) {
        if (!(_i < t1)) {
          allStrings = true;
          break;
        }
        k = keys[_i];
        if (typeof k != "string" || "__proto__" === k) {
          allStrings = false;
          break;
        }
        ++_i;
      }
      if (allStrings) {
        object = {};
        for (index = 0, _i = 0; _i < keys.length; keys.length === t1 || (0, A.throwConcurrentModificationError)(keys), ++_i, index = index0) {
          k = keys[_i];
          other.$index(0, k);
          index0 = index + 1;
          object[k] = index;
        }
        map = new A.ConstantStringMap(object, A.List_List$from(other.get$values(other), true, $V), $K._eval$1("@<0>")._bind$1($V)._eval$1("ConstantStringMap<1,2>"));
        map.$keys = keys;
        return map;
      }
      return new A.ConstantMapView(A.LinkedHashMap_LinkedHashMap$from(other, $K, $V), $K._eval$1("@<0>")._bind$1($V)._eval$1("ConstantMapView<1,2>"));
    },
    ConstantMap__throwUnmodifiable() {
      throw A.wrapException(A.UnsupportedError$("Cannot modify unmodifiable Map"));
    },
    ConstantSet__throwUnmodifiable() {
      throw A.wrapException(A.UnsupportedError$("Cannot modify constant Set"));
    },
    instantiate1(f, T1) {
      var t1 = new A.Instantiation1(f, T1._eval$1("Instantiation1<0>"));
      t1.Instantiation$1(f);
      return t1;
    },
    unminifyOrTag(rawClassName) {
      var preserved = init.mangledGlobalNames[rawClassName];
      if (preserved != null)
        return preserved;
      return rawClassName;
    },
    isJsIndexable(object, record) {
      var result;
      if (record != null) {
        result = record.x;
        if (result != null)
          return result;
      }
      return type$.JavaScriptIndexingBehavior_dynamic._is(object);
    },
    S(value) {
      var result;
      if (typeof value == "string")
        return value;
      if (typeof value == "number") {
        if (value !== 0)
          return "" + value;
      } else if (true === value)
        return "true";
      else if (false === value)
        return "false";
      else if (value == null)
        return "null";
      result = J.toString$0$(value);
      return result;
    },
    JSInvocationMirror$(_memberName, _internalName, _kind, _arguments, _namedArgumentNames, _typeArgumentCount) {
      return new A.JSInvocationMirror(_memberName, _kind, _arguments, _namedArgumentNames, _typeArgumentCount);
    },
    Primitives_objectHashCode(object) {
      var hash,
        property = $.Primitives__identityHashCodeProperty;
      if (property == null)
        property = $.Primitives__identityHashCodeProperty = Symbol("identityHashCode");
      hash = object[property];
      if (hash == null) {
        hash = Math.random() * 0x3fffffff | 0;
        object[property] = hash;
      }
      return hash;
    },
    Primitives_parseInt(source, radix) {
      var decimalMatch, maxCharCode, digitsPart, t1, i, _null = null,
        match = /^\s*[+-]?((0x[a-f0-9]+)|(\d+)|([a-z0-9]+))\s*$/i.exec(source);
      if (match == null)
        return _null;
      decimalMatch = match[3];
      if (radix == null) {
        if (decimalMatch != null)
          return parseInt(source, 10);
        if (match[2] != null)
          return parseInt(source, 16);
        return _null;
      }
      if (radix < 2 || radix > 36)
        throw A.wrapException(A.RangeError$range(radix, 2, 36, "radix", _null));
      if (radix === 10 && decimalMatch != null)
        return parseInt(source, 10);
      if (radix < 10 || decimalMatch == null) {
        maxCharCode = radix <= 10 ? 47 + radix : 86 + radix;
        digitsPart = match[1];
        for (t1 = digitsPart.length, i = 0; i < t1; ++i)
          if ((digitsPart.charCodeAt(i) | 32) > maxCharCode)
            return _null;
      }
      return parseInt(source, radix);
    },
    Primitives_parseDouble(source) {
      var result, trimmed;
      if (!/^\s*[+-]?(?:Infinity|NaN|(?:\.\d+|\d+(?:\.\d*)?)(?:[eE][+-]?\d+)?)\s*$/.test(source))
        return null;
      result = parseFloat(source);
      if (isNaN(result)) {
        trimmed = B.JSString_methods.trim$0(source);
        if (trimmed === "NaN" || trimmed === "+NaN" || trimmed === "-NaN")
          return result;
        return null;
      }
      return result;
    },
    Primitives_objectTypeName(object) {
      return A.Primitives__objectTypeNameNewRti(object);
    },
    Primitives__objectTypeNameNewRti(object) {
      var interceptor, dispatchName, $constructor, constructorName;
      if (object instanceof A.Object)
        return A._rtiToString(A.instanceType(object), null);
      interceptor = J.getInterceptor$(object);
      if (interceptor === B.Interceptor_methods || interceptor === B.JavaScriptObject_methods || type$.UnknownJavaScriptObject._is(object)) {
        dispatchName = B.C_JS_CONST(object);
        if (dispatchName !== "Object" && dispatchName !== "")
          return dispatchName;
        $constructor = object.constructor;
        if (typeof $constructor == "function") {
          constructorName = $constructor.name;
          if (typeof constructorName == "string" && constructorName !== "Object" && constructorName !== "")
            return constructorName;
        }
      }
      return A._rtiToString(A.instanceType(object), null);
    },
    Primitives_safeToString(object) {
      if (object == null || typeof object == "number" || A._isBool(object))
        return J.toString$0$(object);
      if (typeof object == "string")
        return JSON.stringify(object);
      if (object instanceof A.Closure)
        return object.toString$0(0);
      if (object instanceof A._Record)
        return object._toString$1(true);
      return "Instance of '" + A.Primitives_objectTypeName(object) + "'";
    },
    Primitives_currentUri() {
      if (!!self.location)
        return self.location.href;
      return null;
    },
    Primitives__fromCharCodeApply(array) {
      var result, i, i0, chunkEnd,
        end = array.length;
      if (end <= 500)
        return String.fromCharCode.apply(null, array);
      for (result = "", i = 0; i < end; i = i0) {
        i0 = i + 500;
        chunkEnd = i0 < end ? i0 : end;
        result += String.fromCharCode.apply(null, array.slice(i, chunkEnd));
      }
      return result;
    },
    Primitives_stringFromCodePoints(codePoints) {
      var t1, _i, i,
        a = A._setArrayType([], type$.JSArray_int);
      for (t1 = codePoints.length, _i = 0; _i < codePoints.length; codePoints.length === t1 || (0, A.throwConcurrentModificationError)(codePoints), ++_i) {
        i = codePoints[_i];
        if (!A._isInt(i))
          throw A.wrapException(A.argumentErrorValue(i));
        if (i <= 65535)
          a.push(i);
        else if (i <= 1114111) {
          a.push(55296 + (B.JSInt_methods._shrOtherPositive$1(i - 65536, 10) & 1023));
          a.push(56320 + (i & 1023));
        } else
          throw A.wrapException(A.argumentErrorValue(i));
      }
      return A.Primitives__fromCharCodeApply(a);
    },
    Primitives_stringFromCharCodes(charCodes) {
      var t1, _i, i;
      for (t1 = charCodes.length, _i = 0; _i < t1; ++_i) {
        i = charCodes[_i];
        if (!A._isInt(i))
          throw A.wrapException(A.argumentErrorValue(i));
        if (i < 0)
          throw A.wrapException(A.argumentErrorValue(i));
        if (i > 65535)
          return A.Primitives_stringFromCodePoints(charCodes);
      }
      return A.Primitives__fromCharCodeApply(charCodes);
    },
    Primitives_stringFromNativeUint8List(charCodes, start, end) {
      var i, result, i0, chunkEnd;
      if (end <= 500 && start === 0 && end === charCodes.length)
        return String.fromCharCode.apply(null, charCodes);
      for (i = start, result = ""; i < end; i = i0) {
        i0 = i + 500;
        chunkEnd = i0 < end ? i0 : end;
        result += String.fromCharCode.apply(null, charCodes.subarray(i, chunkEnd));
      }
      return result;
    },
    Primitives_stringFromCharCode(charCode) {
      var bits;
      if (0 <= charCode) {
        if (charCode <= 65535)
          return String.fromCharCode(charCode);
        if (charCode <= 1114111) {
          bits = charCode - 65536;
          return String.fromCharCode((B.JSInt_methods._shrOtherPositive$1(bits, 10) | 55296) >>> 0, bits & 1023 | 56320);
        }
      }
      throw A.wrapException(A.RangeError$range(charCode, 0, 1114111, null, null));
    },
    Primitives_lazyAsJsDate(receiver) {
      if (receiver.date === void 0)
        receiver.date = new Date(receiver._value);
      return receiver.date;
    },
    Primitives_getYear(receiver) {
      var t1 = A.Primitives_lazyAsJsDate(receiver).getFullYear() + 0;
      return t1;
    },
    Primitives_getMonth(receiver) {
      var t1 = A.Primitives_lazyAsJsDate(receiver).getMonth() + 1;
      return t1;
    },
    Primitives_getDay(receiver) {
      var t1 = A.Primitives_lazyAsJsDate(receiver).getDate() + 0;
      return t1;
    },
    Primitives_getHours(receiver) {
      var t1 = A.Primitives_lazyAsJsDate(receiver).getHours() + 0;
      return t1;
    },
    Primitives_getMinutes(receiver) {
      var t1 = A.Primitives_lazyAsJsDate(receiver).getMinutes() + 0;
      return t1;
    },
    Primitives_getSeconds(receiver) {
      var t1 = A.Primitives_lazyAsJsDate(receiver).getSeconds() + 0;
      return t1;
    },
    Primitives_getMilliseconds(receiver) {
      var t1 = A.Primitives_lazyAsJsDate(receiver).getMilliseconds() + 0;
      return t1;
    },
    Primitives_functionNoSuchMethod($function, positionalArguments, namedArguments) {
      var $arguments, namedArgumentList, t1 = {};
      t1.argumentCount = 0;
      $arguments = [];
      namedArgumentList = [];
      t1.argumentCount = positionalArguments.length;
      B.JSArray_methods.addAll$1($arguments, positionalArguments);
      t1.names = "";
      if (namedArguments != null && namedArguments.__js_helper$_length !== 0)
        namedArguments.forEach$1(0, new A.Primitives_functionNoSuchMethod_closure(t1, namedArgumentList, $arguments));
      return J.noSuchMethod$1$($function, new A.JSInvocationMirror(B.Symbol_call, 0, $arguments, namedArgumentList, 0));
    },
    Primitives_applyFunction($function, positionalArguments, namedArguments) {
      var t1, argumentCount, jsStub;
      if (Array.isArray(positionalArguments))
        t1 = namedArguments == null || namedArguments.__js_helper$_length === 0;
      else
        t1 = false;
      if (t1) {
        argumentCount = positionalArguments.length;
        if (argumentCount === 0) {
          if (!!$function.call$0)
            return $function.call$0();
        } else if (argumentCount === 1) {
          if (!!$function.call$1)
            return $function.call$1(positionalArguments[0]);
        } else if (argumentCount === 2) {
          if (!!$function.call$2)
            return $function.call$2(positionalArguments[0], positionalArguments[1]);
        } else if (argumentCount === 3) {
          if (!!$function.call$3)
            return $function.call$3(positionalArguments[0], positionalArguments[1], positionalArguments[2]);
        } else if (argumentCount === 4) {
          if (!!$function.call$4)
            return $function.call$4(positionalArguments[0], positionalArguments[1], positionalArguments[2], positionalArguments[3]);
        } else if (argumentCount === 5)
          if (!!$function.call$5)
            return $function.call$5(positionalArguments[0], positionalArguments[1], positionalArguments[2], positionalArguments[3], positionalArguments[4]);
        jsStub = $function["call" + "$" + argumentCount];
        if (jsStub != null)
          return jsStub.apply($function, positionalArguments);
      }
      return A.Primitives__generalApplyFunction($function, positionalArguments, namedArguments);
    },
    Primitives__generalApplyFunction($function, positionalArguments, namedArguments) {
      var defaultValuesClosure, t1, defaultValues, interceptor, jsFunction, maxArguments, missingDefaults, keys, _i, defaultValue, used, t2,
        $arguments = Array.isArray(positionalArguments) ? positionalArguments : A.List_List$of(positionalArguments, true, type$.dynamic),
        argumentCount = $arguments.length,
        requiredParameterCount = $function.$requiredArgCount;
      if (argumentCount < requiredParameterCount)
        return A.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
      defaultValuesClosure = $function.$defaultValues;
      t1 = defaultValuesClosure == null;
      defaultValues = !t1 ? defaultValuesClosure() : null;
      interceptor = J.getInterceptor$($function);
      jsFunction = interceptor["call*"];
      if (typeof jsFunction == "string")
        jsFunction = interceptor[jsFunction];
      if (t1) {
        if (namedArguments != null && namedArguments.__js_helper$_length !== 0)
          return A.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
        if (argumentCount === requiredParameterCount)
          return jsFunction.apply($function, $arguments);
        return A.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
      }
      if (Array.isArray(defaultValues)) {
        if (namedArguments != null && namedArguments.__js_helper$_length !== 0)
          return A.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
        maxArguments = requiredParameterCount + defaultValues.length;
        if (argumentCount > maxArguments)
          return A.Primitives_functionNoSuchMethod($function, $arguments, null);
        if (argumentCount < maxArguments) {
          missingDefaults = defaultValues.slice(argumentCount - requiredParameterCount);
          if ($arguments === positionalArguments)
            $arguments = A.List_List$of($arguments, true, type$.dynamic);
          B.JSArray_methods.addAll$1($arguments, missingDefaults);
        }
        return jsFunction.apply($function, $arguments);
      } else {
        if (argumentCount > requiredParameterCount)
          return A.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
        if ($arguments === positionalArguments)
          $arguments = A.List_List$of($arguments, true, type$.dynamic);
        keys = Object.keys(defaultValues);
        if (namedArguments == null)
          for (t1 = keys.length, _i = 0; _i < keys.length; keys.length === t1 || (0, A.throwConcurrentModificationError)(keys), ++_i) {
            defaultValue = defaultValues[keys[_i]];
            if (B.C__Required === defaultValue)
              return A.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
            B.JSArray_methods.add$1($arguments, defaultValue);
          }
        else {
          for (t1 = keys.length, used = 0, _i = 0; _i < keys.length; keys.length === t1 || (0, A.throwConcurrentModificationError)(keys), ++_i) {
            t2 = keys[_i];
            if (namedArguments.containsKey$1(t2)) {
              ++used;
              B.JSArray_methods.add$1($arguments, namedArguments.$index(0, t2));
            } else {
              defaultValue = defaultValues[t2];
              if (B.C__Required === defaultValue)
                return A.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
              B.JSArray_methods.add$1($arguments, defaultValue);
            }
          }
          if (used !== namedArguments.__js_helper$_length)
            return A.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
        }
        return jsFunction.apply($function, $arguments);
      }
    },
    Primitives_extractStackTrace(error) {
      var jsError = error.$thrownJsError;
      if (jsError == null)
        return null;
      return A.getTraceFromException(jsError);
    },
    diagnoseIndexError(indexable, index) {
      var $length, _s5_ = "index";
      if (!A._isInt(index))
        return new A.ArgumentError(true, index, _s5_, null);
      $length = J.get$length$asx(indexable);
      if (index < 0 || index >= $length)
        return A.IndexError$withLength(index, $length, indexable, null, _s5_);
      return A.RangeError$value(index, _s5_, null);
    },
    diagnoseRangeError(start, end, $length) {
      if (start < 0 || start > $length)
        return A.RangeError$range(start, 0, $length, "start", null);
      if (end != null)
        if (end < start || end > $length)
          return A.RangeError$range(end, start, $length, "end", null);
      return new A.ArgumentError(true, end, "end", null);
    },
    argumentErrorValue(object) {
      return new A.ArgumentError(true, object, null, null);
    },
    checkNum(value) {
      return value;
    },
    wrapException(ex) {
      return A.initializeExceptionWrapper(new Error(), ex);
    },
    initializeExceptionWrapper(wrapper, ex) {
      var t1;
      if (ex == null)
        ex = new A.TypeError();
      wrapper.dartException = ex;
      t1 = A.toStringWrapper;
      if ("defineProperty" in Object) {
        Object.defineProperty(wrapper, "message", {get: t1});
        wrapper.name = "";
      } else
        wrapper.toString = t1;
      return wrapper;
    },
    toStringWrapper() {
      return J.toString$0$(this.dartException);
    },
    throwExpression(ex) {
      throw A.wrapException(ex);
    },
    throwExpressionWithWrapper(ex, wrapper) {
      throw A.initializeExceptionWrapper(wrapper, ex);
    },
    throwConcurrentModificationError(collection) {
      throw A.wrapException(A.ConcurrentModificationError$(collection));
    },
    TypeErrorDecoder_extractPattern(message) {
      var match, $arguments, argumentsExpr, expr, method, receiver;
      message = A.quoteStringForRegExp(message.replace(String({}), "$receiver$"));
      match = message.match(/\\\$[a-zA-Z]+\\\$/g);
      if (match == null)
        match = A._setArrayType([], type$.JSArray_String);
      $arguments = match.indexOf("\\$arguments\\$");
      argumentsExpr = match.indexOf("\\$argumentsExpr\\$");
      expr = match.indexOf("\\$expr\\$");
      method = match.indexOf("\\$method\\$");
      receiver = match.indexOf("\\$receiver\\$");
      return new A.TypeErrorDecoder(message.replace(new RegExp("\\\\\\$arguments\\\\\\$", "g"), "((?:x|[^x])*)").replace(new RegExp("\\\\\\$argumentsExpr\\\\\\$", "g"), "((?:x|[^x])*)").replace(new RegExp("\\\\\\$expr\\\\\\$", "g"), "((?:x|[^x])*)").replace(new RegExp("\\\\\\$method\\\\\\$", "g"), "((?:x|[^x])*)").replace(new RegExp("\\\\\\$receiver\\\\\\$", "g"), "((?:x|[^x])*)"), $arguments, argumentsExpr, expr, method, receiver);
    },
    TypeErrorDecoder_provokeCallErrorOn(expression) {
      return function($expr$) {
        var $argumentsExpr$ = "$arguments$";
        try {
          $expr$.$method$($argumentsExpr$);
        } catch (e) {
          return e.message;
        }
      }(expression);
    },
    TypeErrorDecoder_provokePropertyErrorOn(expression) {
      return function($expr$) {
        try {
          $expr$.$method$;
        } catch (e) {
          return e.message;
        }
      }(expression);
    },
    JsNoSuchMethodError$(_message, match) {
      var t1 = match == null,
        t2 = t1 ? null : match.method;
      return new A.JsNoSuchMethodError(_message, t2, t1 ? null : match.receiver);
    },
    unwrapException(ex) {
      if (ex == null)
        return new A.NullThrownFromJavaScriptException(ex);
      if (ex instanceof A.ExceptionAndStackTrace)
        return A.saveStackTrace(ex, ex.dartException);
      if (typeof ex !== "object")
        return ex;
      if ("dartException" in ex)
        return A.saveStackTrace(ex, ex.dartException);
      return A._unwrapNonDartException(ex);
    },
    saveStackTrace(ex, error) {
      if (type$.Error._is(error))
        if (error.$thrownJsError == null)
          error.$thrownJsError = ex;
      return error;
    },
    _unwrapNonDartException(ex) {
      var message, number, ieErrorCode, nsme, notClosure, nullCall, nullLiteralCall, undefCall, undefLiteralCall, nullProperty, undefProperty, undefLiteralProperty, match;
      if (!("message" in ex))
        return ex;
      message = ex.message;
      if ("number" in ex && typeof ex.number == "number") {
        number = ex.number;
        ieErrorCode = number & 65535;
        if ((B.JSInt_methods._shrOtherPositive$1(number, 16) & 8191) === 10)
          switch (ieErrorCode) {
            case 438:
              return A.saveStackTrace(ex, A.JsNoSuchMethodError$(A.S(message) + " (Error " + ieErrorCode + ")", null));
            case 445:
            case 5007:
              A.S(message);
              return A.saveStackTrace(ex, new A.NullError());
          }
      }
      if (ex instanceof TypeError) {
        nsme = $.$get$TypeErrorDecoder_noSuchMethodPattern();
        notClosure = $.$get$TypeErrorDecoder_notClosurePattern();
        nullCall = $.$get$TypeErrorDecoder_nullCallPattern();
        nullLiteralCall = $.$get$TypeErrorDecoder_nullLiteralCallPattern();
        undefCall = $.$get$TypeErrorDecoder_undefinedCallPattern();
        undefLiteralCall = $.$get$TypeErrorDecoder_undefinedLiteralCallPattern();
        nullProperty = $.$get$TypeErrorDecoder_nullPropertyPattern();
        $.$get$TypeErrorDecoder_nullLiteralPropertyPattern();
        undefProperty = $.$get$TypeErrorDecoder_undefinedPropertyPattern();
        undefLiteralProperty = $.$get$TypeErrorDecoder_undefinedLiteralPropertyPattern();
        match = nsme.matchTypeError$1(message);
        if (match != null)
          return A.saveStackTrace(ex, A.JsNoSuchMethodError$(message, match));
        else {
          match = notClosure.matchTypeError$1(message);
          if (match != null) {
            match.method = "call";
            return A.saveStackTrace(ex, A.JsNoSuchMethodError$(message, match));
          } else if (nullCall.matchTypeError$1(message) != null || nullLiteralCall.matchTypeError$1(message) != null || undefCall.matchTypeError$1(message) != null || undefLiteralCall.matchTypeError$1(message) != null || nullProperty.matchTypeError$1(message) != null || nullLiteralCall.matchTypeError$1(message) != null || undefProperty.matchTypeError$1(message) != null || undefLiteralProperty.matchTypeError$1(message) != null)
            return A.saveStackTrace(ex, new A.NullError());
        }
        return A.saveStackTrace(ex, new A.UnknownJsTypeError(typeof message == "string" ? message : ""));
      }
      if (ex instanceof RangeError) {
        if (typeof message == "string" && message.indexOf("call stack") !== -1)
          return new A.StackOverflowError();
        message = function(ex) {
          try {
            return String(ex);
          } catch (e) {
          }
          return null;
        }(ex);
        return A.saveStackTrace(ex, new A.ArgumentError(false, null, null, typeof message == "string" ? message.replace(/^RangeError:\s*/, "") : message));
      }
      if (typeof InternalError == "function" && ex instanceof InternalError)
        if (typeof message == "string" && message === "too much recursion")
          return new A.StackOverflowError();
      return ex;
    },
    getTraceFromException(exception) {
      var trace;
      if (exception instanceof A.ExceptionAndStackTrace)
        return exception.stackTrace;
      if (exception == null)
        return new A._StackTrace(exception);
      trace = exception.$cachedTrace;
      if (trace != null)
        return trace;
      trace = new A._StackTrace(exception);
      if (typeof exception === "object")
        exception.$cachedTrace = trace;
      return trace;
    },
    objectHashCode(object) {
      if (object == null)
        return J.get$hashCode$(object);
      if (typeof object == "object")
        return A.Primitives_objectHashCode(object);
      return J.get$hashCode$(object);
    },
    constantHashCode(key) {
      if (typeof key == "number")
        return B.JSNumber_methods.get$hashCode(key);
      if (key instanceof A._Type)
        return A.Primitives_objectHashCode(key);
      if (key instanceof A._Record)
        return key.get$hashCode(key);
      if (key instanceof A.Symbol)
        return key.get$hashCode(0);
      return A.objectHashCode(key);
    },
    fillLiteralMap(keyValuePairs, result) {
      var index, index0, index1,
        $length = keyValuePairs.length;
      for (index = 0; index < $length; index = index1) {
        index0 = index + 1;
        index1 = index0 + 1;
        result.$indexSet(0, keyValuePairs[index], keyValuePairs[index0]);
      }
      return result;
    },
    fillLiteralSet(values, result) {
      var index,
        $length = values.length;
      for (index = 0; index < $length; ++index)
        result.add$1(0, values[index]);
      return result;
    },
    _invokeClosure(closure, numberOfArguments, arg1, arg2, arg3, arg4) {
      switch (numberOfArguments) {
        case 0:
          return closure.call$0();
        case 1:
          return closure.call$1(arg1);
        case 2:
          return closure.call$2(arg1, arg2);
        case 3:
          return closure.call$3(arg1, arg2, arg3);
        case 4:
          return closure.call$4(arg1, arg2, arg3, arg4);
      }
      throw A.wrapException(new A._Exception("Unsupported number of arguments for wrapped closure"));
    },
    convertDartClosureToJS(closure, arity) {
      var $function;
      if (closure == null)
        return null;
      $function = closure.$identity;
      if (!!$function)
        return $function;
      $function = A.convertDartClosureToJSUncached(closure, arity);
      closure.$identity = $function;
      return $function;
    },
    convertDartClosureToJSUncached(closure, arity) {
      var entry;
      switch (arity) {
        case 0:
          entry = closure.call$0;
          break;
        case 1:
          entry = closure.call$1;
          break;
        case 2:
          entry = closure.call$2;
          break;
        case 3:
          entry = closure.call$3;
          break;
        case 4:
          entry = closure.call$4;
          break;
        default:
          entry = null;
      }
      if (entry != null)
        return entry.bind(closure);
      return function(closure, arity, invoke) {
        return function(a1, a2, a3, a4) {
          return invoke(closure, arity, a1, a2, a3, a4);
        };
      }(closure, arity, A._invokeClosure);
    },
    Closure_fromTearOff(parameters) {
      var $prototype, $constructor, t2, trampoline, applyTrampoline, i, stub, stub0, stubName, stubCallName,
        container = parameters.co,
        isStatic = parameters.iS,
        isIntercepted = parameters.iI,
        needsDirectAccess = parameters.nDA,
        applyTrampolineIndex = parameters.aI,
        funsOrNames = parameters.fs,
        callNames = parameters.cs,
        $name = funsOrNames[0],
        callName = callNames[0],
        $function = container[$name],
        t1 = parameters.fT;
      t1.toString;
      $prototype = isStatic ? Object.create(new A.StaticClosure().constructor.prototype) : Object.create(new A.BoundClosure(null, null).constructor.prototype);
      $prototype.$initialize = $prototype.constructor;
      $constructor = isStatic ? function static_tear_off() {
        this.$initialize();
      } : function tear_off(a, b) {
        this.$initialize(a, b);
      };
      $prototype.constructor = $constructor;
      $constructor.prototype = $prototype;
      $prototype.$_name = $name;
      $prototype.$_target = $function;
      t2 = !isStatic;
      if (t2)
        trampoline = A.Closure_forwardCallTo($name, $function, isIntercepted, needsDirectAccess);
      else {
        $prototype.$static_name = $name;
        trampoline = $function;
      }
      $prototype.$signature = A.Closure__computeSignatureFunctionNewRti(t1, isStatic, isIntercepted);
      $prototype[callName] = trampoline;
      for (applyTrampoline = trampoline, i = 1; i < funsOrNames.length; ++i) {
        stub = funsOrNames[i];
        if (typeof stub == "string") {
          stub0 = container[stub];
          stubName = stub;
          stub = stub0;
        } else
          stubName = "";
        stubCallName = callNames[i];
        if (stubCallName != null) {
          if (t2)
            stub = A.Closure_forwardCallTo(stubName, stub, isIntercepted, needsDirectAccess);
          $prototype[stubCallName] = stub;
        }
        if (i === applyTrampolineIndex)
          applyTrampoline = stub;
      }
      $prototype["call*"] = applyTrampoline;
      $prototype.$requiredArgCount = parameters.rC;
      $prototype.$defaultValues = parameters.dV;
      return $constructor;
    },
    Closure__computeSignatureFunctionNewRti(functionType, isStatic, isIntercepted) {
      if (typeof functionType == "number")
        return functionType;
      if (typeof functionType == "string") {
        if (isStatic)
          throw A.wrapException("Cannot compute signature for static tearoff.");
        return function(recipe, evalOnReceiver) {
          return function() {
            return evalOnReceiver(this, recipe);
          };
        }(functionType, A.BoundClosure_evalRecipe);
      }
      throw A.wrapException("Error in functionType of tearoff");
    },
    Closure_cspForwardCall(arity, needsDirectAccess, stubName, $function) {
      var getReceiver = A.BoundClosure_receiverOf;
      switch (needsDirectAccess ? -1 : arity) {
        case 0:
          return function(entry, receiverOf) {
            return function() {
              return receiverOf(this)[entry]();
            };
          }(stubName, getReceiver);
        case 1:
          return function(entry, receiverOf) {
            return function(a) {
              return receiverOf(this)[entry](a);
            };
          }(stubName, getReceiver);
        case 2:
          return function(entry, receiverOf) {
            return function(a, b) {
              return receiverOf(this)[entry](a, b);
            };
          }(stubName, getReceiver);
        case 3:
          return function(entry, receiverOf) {
            return function(a, b, c) {
              return receiverOf(this)[entry](a, b, c);
            };
          }(stubName, getReceiver);
        case 4:
          return function(entry, receiverOf) {
            return function(a, b, c, d) {
              return receiverOf(this)[entry](a, b, c, d);
            };
          }(stubName, getReceiver);
        case 5:
          return function(entry, receiverOf) {
            return function(a, b, c, d, e) {
              return receiverOf(this)[entry](a, b, c, d, e);
            };
          }(stubName, getReceiver);
        default:
          return function(f, receiverOf) {
            return function() {
              return f.apply(receiverOf(this), arguments);
            };
          }($function, getReceiver);
      }
    },
    Closure_forwardCallTo(stubName, $function, isIntercepted, needsDirectAccess) {
      if (isIntercepted)
        return A.Closure_forwardInterceptedCallTo(stubName, $function, needsDirectAccess);
      return A.Closure_cspForwardCall($function.length, needsDirectAccess, stubName, $function);
    },
    Closure_cspForwardInterceptedCall(arity, needsDirectAccess, stubName, $function) {
      var getReceiver = A.BoundClosure_receiverOf,
        getInterceptor = A.BoundClosure_interceptorOf;
      switch (needsDirectAccess ? -1 : arity) {
        case 0:
          throw A.wrapException(new A.RuntimeError("Intercepted function with no arguments."));
        case 1:
          return function(entry, interceptorOf, receiverOf) {
            return function() {
              return interceptorOf(this)[entry](receiverOf(this));
            };
          }(stubName, getInterceptor, getReceiver);
        case 2:
          return function(entry, interceptorOf, receiverOf) {
            return function(a) {
              return interceptorOf(this)[entry](receiverOf(this), a);
            };
          }(stubName, getInterceptor, getReceiver);
        case 3:
          return function(entry, interceptorOf, receiverOf) {
            return function(a, b) {
              return interceptorOf(this)[entry](receiverOf(this), a, b);
            };
          }(stubName, getInterceptor, getReceiver);
        case 4:
          return function(entry, interceptorOf, receiverOf) {
            return function(a, b, c) {
              return interceptorOf(this)[entry](receiverOf(this), a, b, c);
            };
          }(stubName, getInterceptor, getReceiver);
        case 5:
          return function(entry, interceptorOf, receiverOf) {
            return function(a, b, c, d) {
              return interceptorOf(this)[entry](receiverOf(this), a, b, c, d);
            };
          }(stubName, getInterceptor, getReceiver);
        case 6:
          return function(entry, interceptorOf, receiverOf) {
            return function(a, b, c, d, e) {
              return interceptorOf(this)[entry](receiverOf(this), a, b, c, d, e);
            };
          }(stubName, getInterceptor, getReceiver);
        default:
          return function(f, interceptorOf, receiverOf) {
            return function() {
              var a = [receiverOf(this)];
              Array.prototype.push.apply(a, arguments);
              return f.apply(interceptorOf(this), a);
            };
          }($function, getInterceptor, getReceiver);
      }
    },
    Closure_forwardInterceptedCallTo(stubName, $function, needsDirectAccess) {
      var arity, t1;
      if ($.BoundClosure__interceptorFieldNameCache == null)
        $.BoundClosure__interceptorFieldNameCache = A.BoundClosure__computeFieldNamed("interceptor");
      if ($.BoundClosure__receiverFieldNameCache == null)
        $.BoundClosure__receiverFieldNameCache = A.BoundClosure__computeFieldNamed("receiver");
      arity = $function.length;
      t1 = A.Closure_cspForwardInterceptedCall(arity, needsDirectAccess, stubName, $function);
      return t1;
    },
    closureFromTearOff(parameters) {
      return A.Closure_fromTearOff(parameters);
    },
    BoundClosure_evalRecipe(closure, recipe) {
      return A._Universe_evalInEnvironment(init.typeUniverse, A.instanceType(closure._receiver), recipe);
    },
    BoundClosure_receiverOf(closure) {
      return closure._receiver;
    },
    BoundClosure_interceptorOf(closure) {
      return closure._interceptor;
    },
    BoundClosure__computeFieldNamed(fieldName) {
      var t1, i, $name,
        template = new A.BoundClosure("receiver", "interceptor"),
        names = J.JSArray_markFixedList(Object.getOwnPropertyNames(template));
      for (t1 = names.length, i = 0; i < t1; ++i) {
        $name = names[i];
        if (template[$name] === fieldName)
          return $name;
      }
      throw A.wrapException(A.ArgumentError$("Field name " + fieldName + " not found.", null));
    },
    throwCyclicInit(staticName) {
      throw A.wrapException(new A._CyclicInitializationError(staticName));
    },
    getIsolateAffinityTag($name) {
      return init.getIsolateTag($name);
    },
    LinkedHashMapKeyIterator$(_map, _modifications) {
      var t1 = new A.LinkedHashMapKeyIterator(_map, _modifications);
      t1.__js_helper$_cell = _map.__js_helper$_first;
      return t1;
    },
    defineProperty(obj, property, value) {
      Object.defineProperty(obj, property, {value: value, enumerable: false, writable: true, configurable: true});
    },
    lookupAndCacheInterceptor(obj) {
      var interceptor, interceptorClass, altTag, mark, t1,
        tag = $.getTagFunction.call$1(obj),
        record = $.dispatchRecordsForInstanceTags[tag];
      if (record != null) {
        Object.defineProperty(obj, init.dispatchPropertyName, {value: record, enumerable: false, writable: true, configurable: true});
        return record.i;
      }
      interceptor = $.interceptorsForUncacheableTags[tag];
      if (interceptor != null)
        return interceptor;
      interceptorClass = init.interceptorsByTag[tag];
      if (interceptorClass == null) {
        altTag = $.alternateTagFunction.call$2(obj, tag);
        if (altTag != null) {
          record = $.dispatchRecordsForInstanceTags[altTag];
          if (record != null) {
            Object.defineProperty(obj, init.dispatchPropertyName, {value: record, enumerable: false, writable: true, configurable: true});
            return record.i;
          }
          interceptor = $.interceptorsForUncacheableTags[altTag];
          if (interceptor != null)
            return interceptor;
          interceptorClass = init.interceptorsByTag[altTag];
          tag = altTag;
        }
      }
      if (interceptorClass == null)
        return null;
      interceptor = interceptorClass.prototype;
      mark = tag[0];
      if (mark === "!") {
        record = A.makeLeafDispatchRecord(interceptor);
        $.dispatchRecordsForInstanceTags[tag] = record;
        Object.defineProperty(obj, init.dispatchPropertyName, {value: record, enumerable: false, writable: true, configurable: true});
        return record.i;
      }
      if (mark === "~") {
        $.interceptorsForUncacheableTags[tag] = interceptor;
        return interceptor;
      }
      if (mark === "-") {
        t1 = A.makeLeafDispatchRecord(interceptor);
        Object.defineProperty(Object.getPrototypeOf(obj), init.dispatchPropertyName, {value: t1, enumerable: false, writable: true, configurable: true});
        return t1.i;
      }
      if (mark === "+")
        return A.patchInteriorProto(obj, interceptor);
      if (mark === "*")
        throw A.wrapException(A.UnimplementedError$(tag));
      if (init.leafTags[tag] === true) {
        t1 = A.makeLeafDispatchRecord(interceptor);
        Object.defineProperty(Object.getPrototypeOf(obj), init.dispatchPropertyName, {value: t1, enumerable: false, writable: true, configurable: true});
        return t1.i;
      } else
        return A.patchInteriorProto(obj, interceptor);
    },
    patchInteriorProto(obj, interceptor) {
      var proto = Object.getPrototypeOf(obj);
      Object.defineProperty(proto, init.dispatchPropertyName, {value: J.makeDispatchRecord(interceptor, proto, null, null), enumerable: false, writable: true, configurable: true});
      return interceptor;
    },
    makeLeafDispatchRecord(interceptor) {
      return J.makeDispatchRecord(interceptor, false, null, !!interceptor.$isJavaScriptIndexingBehavior);
    },
    makeDefaultDispatchRecord(tag, interceptorClass, proto) {
      var interceptor = interceptorClass.prototype;
      if (init.leafTags[tag] === true)
        return A.makeLeafDispatchRecord(interceptor);
      else
        return J.makeDispatchRecord(interceptor, proto, null, null);
    },
    initNativeDispatch() {
      if (true === $.initNativeDispatchFlag)
        return;
      $.initNativeDispatchFlag = true;
      A.initNativeDispatchContinue();
    },
    initNativeDispatchContinue() {
      var map, tags, fun, i, tag, proto, record, interceptorClass;
      $.dispatchRecordsForInstanceTags = Object.create(null);
      $.interceptorsForUncacheableTags = Object.create(null);
      A.initHooks();
      map = init.interceptorsByTag;
      tags = Object.getOwnPropertyNames(map);
      if (typeof window != "undefined") {
        window;
        fun = function() {
        };
        for (i = 0; i < tags.length; ++i) {
          tag = tags[i];
          proto = $.prototypeForTagFunction.call$1(tag);
          if (proto != null) {
            record = A.makeDefaultDispatchRecord(tag, map[tag], proto);
            if (record != null) {
              Object.defineProperty(proto, init.dispatchPropertyName, {value: record, enumerable: false, writable: true, configurable: true});
              fun.prototype = proto;
            }
          }
        }
      }
      for (i = 0; i < tags.length; ++i) {
        tag = tags[i];
        if (/^[A-Za-z_]/.test(tag)) {
          interceptorClass = map[tag];
          map["!" + tag] = interceptorClass;
          map["~" + tag] = interceptorClass;
          map["-" + tag] = interceptorClass;
          map["+" + tag] = interceptorClass;
          map["*" + tag] = interceptorClass;
        }
      }
    },
    initHooks() {
      var transformers, i, transformer, getTag, getUnknownTag, prototypeForTag,
        hooks = B.C_JS_CONST0();
      hooks = A.applyHooksTransformer(B.C_JS_CONST1, A.applyHooksTransformer(B.C_JS_CONST2, A.applyHooksTransformer(B.C_JS_CONST3, A.applyHooksTransformer(B.C_JS_CONST3, A.applyHooksTransformer(B.C_JS_CONST4, A.applyHooksTransformer(B.C_JS_CONST5, A.applyHooksTransformer(B.C_JS_CONST6(B.C_JS_CONST), hooks)))))));
      if (typeof dartNativeDispatchHooksTransformer != "undefined") {
        transformers = dartNativeDispatchHooksTransformer;
        if (typeof transformers == "function")
          transformers = [transformers];
        if (Array.isArray(transformers))
          for (i = 0; i < transformers.length; ++i) {
            transformer = transformers[i];
            if (typeof transformer == "function")
              hooks = transformer(hooks) || hooks;
          }
      }
      getTag = hooks.getTag;
      getUnknownTag = hooks.getUnknownTag;
      prototypeForTag = hooks.prototypeForTag;
      $.getTagFunction = new A.initHooks_closure(getTag);
      $.alternateTagFunction = new A.initHooks_closure0(getUnknownTag);
      $.prototypeForTagFunction = new A.initHooks_closure1(prototypeForTag);
    },
    applyHooksTransformer(transformer, hooks) {
      return transformer(hooks) || hooks;
    },
    _RecordN__equalValues(a, b) {
      var i;
      for (i = 0; i < a.length; ++i)
        if (!J.$eq$(a[i], b[i]))
          return false;
      return true;
    },
    createRecordTypePredicate(shape, fieldRtis) {
      var $length = fieldRtis.length,
        $function = init.rttc["" + $length + ";" + shape];
      if ($function == null)
        return null;
      if ($length === 0)
        return $function;
      if ($length === $function.length)
        return $function.apply(null, fieldRtis);
      return $function(fieldRtis);
    },
    JSSyntaxRegExp_makeNative(source, multiLine, caseSensitive, unicode, dotAll, global) {
      var m = multiLine ? "m" : "",
        i = caseSensitive ? "" : "i",
        u = unicode ? "u" : "",
        s = dotAll ? "s" : "",
        g = global ? "g" : "",
        regexp = function(source, modifiers) {
          try {
            return new RegExp(source, modifiers);
          } catch (e) {
            return e;
          }
        }(source, m + i + u + s + g);
      if (regexp instanceof RegExp)
        return regexp;
      throw A.wrapException(A.FormatException$("Illegal RegExp pattern (" + String(regexp) + ")", source, null));
    },
    stringContainsUnchecked(receiver, other, startIndex) {
      var t1;
      if (typeof other == "string")
        return receiver.indexOf(other, startIndex) >= 0;
      else if (other instanceof A.JSSyntaxRegExp) {
        t1 = B.JSString_methods.substring$1(receiver, startIndex);
        return other._nativeRegExp.test(t1);
      } else
        return !J.allMatches$1$s(other, B.JSString_methods.substring$1(receiver, startIndex)).get$isEmpty(0);
    },
    escapeReplacement(replacement) {
      if (replacement.indexOf("$", 0) >= 0)
        return replacement.replace(/\$/g, "$$$$");
      return replacement;
    },
    stringReplaceFirstRE(receiver, regexp, replacement, startIndex) {
      var match = regexp._execGlobal$2(receiver, startIndex);
      if (match == null)
        return receiver;
      return A.stringReplaceRangeUnchecked(receiver, match._match.index, match.get$end(0), replacement);
    },
    quoteStringForRegExp(string) {
      if (/[[\]{}()*+?.\\^$|]/.test(string))
        return string.replace(/[[\]{}()*+?.\\^$|]/g, "\\$&");
      return string;
    },
    stringReplaceAllUnchecked(receiver, pattern, replacement) {
      var nativeRegexp;
      if (typeof pattern == "string")
        return A.stringReplaceAllUncheckedString(receiver, pattern, replacement);
      if (pattern instanceof A.JSSyntaxRegExp) {
        nativeRegexp = pattern.get$_nativeGlobalVersion();
        nativeRegexp.lastIndex = 0;
        return receiver.replace(nativeRegexp, A.escapeReplacement(replacement));
      }
      return A.stringReplaceAllGeneral(receiver, pattern, replacement);
    },
    stringReplaceAllGeneral(receiver, pattern, replacement) {
      var t1, startIndex, t2, match;
      for (t1 = J.allMatches$1$s(pattern, receiver), t1 = t1.get$iterator(t1), startIndex = 0, t2 = ""; t1.moveNext$0();) {
        match = t1.get$current(t1);
        t2 = t2 + receiver.substring(startIndex, match.get$start(match)) + replacement;
        startIndex = match.get$end(match);
      }
      t1 = t2 + receiver.substring(startIndex);
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    stringReplaceAllUncheckedString(receiver, pattern, replacement) {
      var $length, t1, i;
      if (pattern === "") {
        if (receiver === "")
          return replacement;
        $length = receiver.length;
        t1 = "" + replacement;
        for (i = 0; i < $length; ++i)
          t1 = t1 + receiver[i] + replacement;
        return t1.charCodeAt(0) == 0 ? t1 : t1;
      }
      if (receiver.indexOf(pattern, 0) < 0)
        return receiver;
      if (receiver.length < 500 || replacement.indexOf("$", 0) >= 0)
        return receiver.split(pattern).join(replacement);
      return receiver.replace(new RegExp(A.quoteStringForRegExp(pattern), "g"), A.escapeReplacement(replacement));
    },
    stringReplaceFirstUnchecked(receiver, pattern, replacement, startIndex) {
      var index, t1, matches, match;
      if (typeof pattern == "string") {
        index = receiver.indexOf(pattern, startIndex);
        if (index < 0)
          return receiver;
        return A.stringReplaceRangeUnchecked(receiver, index, index + pattern.length, replacement);
      }
      if (pattern instanceof A.JSSyntaxRegExp)
        return startIndex === 0 ? receiver.replace(pattern._nativeRegExp, A.escapeReplacement(replacement)) : A.stringReplaceFirstRE(receiver, pattern, replacement, startIndex);
      t1 = J.allMatches$2$s(pattern, receiver, startIndex);
      matches = t1.get$iterator(t1);
      if (!matches.moveNext$0())
        return receiver;
      match = matches.get$current(matches);
      return B.JSString_methods.replaceRange$3(receiver, match.get$start(match), match.get$end(match), replacement);
    },
    stringReplaceRangeUnchecked(receiver, start, end, replacement) {
      return receiver.substring(0, start) + replacement + receiver.substring(end);
    },
    _Record_1: function _Record_1(t0) {
      this._0 = t0;
    },
    _Record_2: function _Record_2(t0, t1) {
      this._0 = t0;
      this._1 = t1;
    },
    _Record_2_forImport: function _Record_2_forImport(t0, t1) {
      this._0 = t0;
      this._1 = t1;
    },
    _Record_2_imports_modules: function _Record_2_imports_modules(t0, t1) {
      this._0 = t0;
      this._1 = t1;
    },
    _Record_2_loadedUrls_stylesheet: function _Record_2_loadedUrls_stylesheet(t0, t1) {
      this._0 = t0;
      this._1 = t1;
    },
    _Record_2_sourceMap: function _Record_2_sourceMap(t0, t1) {
      this._0 = t0;
      this._1 = t1;
    },
    _Record_3: function _Record_3(t0, t1, t2) {
      this._0 = t0;
      this._1 = t1;
      this._2 = t2;
    },
    _Record_3_forImport: function _Record_3_forImport(t0, t1, t2) {
      this._0 = t0;
      this._1 = t1;
      this._2 = t2;
    },
    _Record_3_importer_isDependency: function _Record_3_importer_isDependency(t0, t1, t2) {
      this._0 = t0;
      this._1 = t1;
      this._2 = t2;
    },
    _Record_3_originalUrl: function _Record_3_originalUrl(t0, t1, t2) {
      this._0 = t0;
      this._1 = t1;
      this._2 = t2;
    },
    _Record_5_named_namedNodes_positional_positionalNodes_separator: function _Record_5_named_namedNodes_positional_positionalNodes_separator(t0) {
      this._values = t0;
    },
    ConstantMapView: function ConstantMapView(t0, t1) {
      this._map = t0;
      this.$ti = t1;
    },
    ConstantMap: function ConstantMap() {
    },
    ConstantStringMap: function ConstantStringMap(t0, t1, t2) {
      this._jsIndex = t0;
      this._values = t1;
      this.$ti = t2;
    },
    _KeysOrValues: function _KeysOrValues(t0, t1) {
      this._elements = t0;
      this.$ti = t1;
    },
    _KeysOrValuesOrElementsIterator: function _KeysOrValuesOrElementsIterator(t0, t1, t2) {
      var _ = this;
      _._elements = t0;
      _.__js_helper$_length = t1;
      _.__js_helper$_index = 0;
      _.__js_helper$_current = null;
      _.$ti = t2;
    },
    ConstantSet: function ConstantSet() {
    },
    ConstantStringSet: function ConstantStringSet(t0, t1, t2) {
      this._jsIndex = t0;
      this.__js_helper$_length = t1;
      this.$ti = t2;
    },
    GeneralConstantSet: function GeneralConstantSet(t0, t1) {
      this._elements = t0;
      this.$ti = t1;
    },
    Instantiation: function Instantiation() {
    },
    Instantiation1: function Instantiation1(t0, t1) {
      this._genericClosure = t0;
      this.$ti = t1;
    },
    JSInvocationMirror: function JSInvocationMirror(t0, t1, t2, t3, t4) {
      var _ = this;
      _.__js_helper$_memberName = t0;
      _.__js_helper$_kind = t1;
      _._arguments = t2;
      _._namedArgumentNames = t3;
      _._typeArgumentCount = t4;
    },
    Primitives_functionNoSuchMethod_closure: function Primitives_functionNoSuchMethod_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.namedArgumentList = t1;
      this.$arguments = t2;
    },
    TypeErrorDecoder: function TypeErrorDecoder(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._pattern = t0;
      _._arguments = t1;
      _._argumentsExpr = t2;
      _._expr = t3;
      _._method = t4;
      _._receiver = t5;
    },
    NullError: function NullError() {
    },
    JsNoSuchMethodError: function JsNoSuchMethodError(t0, t1, t2) {
      this.__js_helper$_message = t0;
      this._method = t1;
      this._receiver = t2;
    },
    UnknownJsTypeError: function UnknownJsTypeError(t0) {
      this.__js_helper$_message = t0;
    },
    NullThrownFromJavaScriptException: function NullThrownFromJavaScriptException(t0) {
      this._irritant = t0;
    },
    ExceptionAndStackTrace: function ExceptionAndStackTrace(t0, t1) {
      this.dartException = t0;
      this.stackTrace = t1;
    },
    _StackTrace: function _StackTrace(t0) {
      this._exception = t0;
      this._trace = null;
    },
    Closure: function Closure() {
    },
    Closure0Args: function Closure0Args() {
    },
    Closure2Args: function Closure2Args() {
    },
    TearOffClosure: function TearOffClosure() {
    },
    StaticClosure: function StaticClosure() {
    },
    BoundClosure: function BoundClosure(t0, t1) {
      this._receiver = t0;
      this._interceptor = t1;
    },
    _CyclicInitializationError: function _CyclicInitializationError(t0) {
      this.variableName = t0;
    },
    RuntimeError: function RuntimeError(t0) {
      this.message = t0;
    },
    _Required: function _Required() {
    },
    JsLinkedHashMap: function JsLinkedHashMap(t0) {
      var _ = this;
      _.__js_helper$_length = 0;
      _.__js_helper$_last = _.__js_helper$_first = _.__js_helper$_rest = _.__js_helper$_nums = _.__js_helper$_strings = null;
      _.__js_helper$_modifications = 0;
      _.$ti = t0;
    },
    JsLinkedHashMap_values_closure: function JsLinkedHashMap_values_closure(t0) {
      this.$this = t0;
    },
    JsLinkedHashMap_addAll_closure: function JsLinkedHashMap_addAll_closure(t0) {
      this.$this = t0;
    },
    LinkedHashMapCell: function LinkedHashMapCell(t0, t1) {
      var _ = this;
      _.hashMapCellKey = t0;
      _.hashMapCellValue = t1;
      _.__js_helper$_previous = _.__js_helper$_next = null;
    },
    LinkedHashMapKeyIterable: function LinkedHashMapKeyIterable(t0, t1) {
      this.__js_helper$_map = t0;
      this.$ti = t1;
    },
    LinkedHashMapKeyIterator: function LinkedHashMapKeyIterator(t0, t1) {
      var _ = this;
      _.__js_helper$_map = t0;
      _.__js_helper$_modifications = t1;
      _.__js_helper$_current = _.__js_helper$_cell = null;
    },
    JsIdentityLinkedHashMap: function JsIdentityLinkedHashMap(t0) {
      var _ = this;
      _.__js_helper$_length = 0;
      _.__js_helper$_last = _.__js_helper$_first = _.__js_helper$_rest = _.__js_helper$_nums = _.__js_helper$_strings = null;
      _.__js_helper$_modifications = 0;
      _.$ti = t0;
    },
    JsConstantLinkedHashMap: function JsConstantLinkedHashMap(t0) {
      var _ = this;
      _.__js_helper$_length = 0;
      _.__js_helper$_last = _.__js_helper$_first = _.__js_helper$_rest = _.__js_helper$_nums = _.__js_helper$_strings = null;
      _.__js_helper$_modifications = 0;
      _.$ti = t0;
    },
    initHooks_closure: function initHooks_closure(t0) {
      this.getTag = t0;
    },
    initHooks_closure0: function initHooks_closure0(t0) {
      this.getUnknownTag = t0;
    },
    initHooks_closure1: function initHooks_closure1(t0) {
      this.prototypeForTag = t0;
    },
    _Record: function _Record() {
    },
    _Record2: function _Record2() {
    },
    _Record1: function _Record1() {
    },
    _Record3: function _Record3() {
    },
    _RecordN: function _RecordN() {
    },
    JSSyntaxRegExp: function JSSyntaxRegExp(t0, t1) {
      var _ = this;
      _.pattern = t0;
      _._nativeRegExp = t1;
      _._nativeAnchoredRegExp = _._nativeGlobalRegExp = null;
    },
    _MatchImplementation: function _MatchImplementation(t0) {
      this._match = t0;
    },
    _AllMatchesIterable: function _AllMatchesIterable(t0, t1, t2) {
      this._re = t0;
      this.__js_helper$_string = t1;
      this.__js_helper$_start = t2;
    },
    _AllMatchesIterator: function _AllMatchesIterator(t0, t1, t2) {
      var _ = this;
      _._regExp = t0;
      _.__js_helper$_string = t1;
      _._nextIndex = t2;
      _.__js_helper$_current = null;
    },
    StringMatch: function StringMatch(t0, t1) {
      this.start = t0;
      this.pattern = t1;
    },
    _StringAllMatchesIterable: function _StringAllMatchesIterable(t0, t1, t2) {
      this._input = t0;
      this._pattern = t1;
      this.__js_helper$_index = t2;
    },
    _StringAllMatchesIterator: function _StringAllMatchesIterator(t0, t1, t2) {
      var _ = this;
      _._input = t0;
      _._pattern = t1;
      _.__js_helper$_index = t2;
      _.__js_helper$_current = null;
    },
    throwLateFieldADI(fieldName) {
      A.throwExpressionWithWrapper(new A.LateError("Field '" + fieldName + "' has been assigned during initialization."), new Error());
    },
    throwUnnamedLateFieldNI() {
      A.throwExpressionWithWrapper(new A.LateError("Field '' has not been initialized."), new Error());
    },
    throwUnnamedLateFieldAI() {
      A.throwExpressionWithWrapper(new A.LateError("Field '' has already been initialized."), new Error());
    },
    throwUnnamedLateFieldADI() {
      A.throwExpressionWithWrapper(new A.LateError("Field '' has been assigned during initialization."), new Error());
    },
    _Cell$() {
      var t1 = new A._Cell();
      return t1.__late_helper$_value = t1;
    },
    _Cell: function _Cell() {
      this.__late_helper$_value = null;
    },
    _ensureNativeList(list) {
      return list;
    },
    NativeInt8List__create1(arg) {
      return new Int8Array(arg);
    },
    NativeUint8List_NativeUint8List($length) {
      return new Uint8Array($length);
    },
    _checkValidIndex(index, list, $length) {
      if (index >>> 0 !== index || index >= $length)
        throw A.wrapException(A.diagnoseIndexError(list, index));
    },
    _checkValidRange(start, end, $length) {
      var t1;
      if (!(start >>> 0 !== start))
        if (end == null)
          t1 = start > $length;
        else
          t1 = end >>> 0 !== end || start > end || end > $length;
      else
        t1 = true;
      if (t1)
        throw A.wrapException(A.diagnoseRangeError(start, end, $length));
      if (end == null)
        return $length;
      return end;
    },
    NativeByteBuffer: function NativeByteBuffer() {
    },
    NativeTypedData: function NativeTypedData() {
    },
    NativeByteData: function NativeByteData() {
    },
    NativeTypedArray: function NativeTypedArray() {
    },
    NativeTypedArrayOfDouble: function NativeTypedArrayOfDouble() {
    },
    NativeTypedArrayOfInt: function NativeTypedArrayOfInt() {
    },
    NativeFloat32List: function NativeFloat32List() {
    },
    NativeFloat64List: function NativeFloat64List() {
    },
    NativeInt16List: function NativeInt16List() {
    },
    NativeInt32List: function NativeInt32List() {
    },
    NativeInt8List: function NativeInt8List() {
    },
    NativeUint16List: function NativeUint16List() {
    },
    NativeUint32List: function NativeUint32List() {
    },
    NativeUint8ClampedList: function NativeUint8ClampedList() {
    },
    NativeUint8List: function NativeUint8List() {
    },
    _NativeTypedArrayOfDouble_NativeTypedArray_ListMixin: function _NativeTypedArrayOfDouble_NativeTypedArray_ListMixin() {
    },
    _NativeTypedArrayOfDouble_NativeTypedArray_ListMixin_FixedLengthListMixin: function _NativeTypedArrayOfDouble_NativeTypedArray_ListMixin_FixedLengthListMixin() {
    },
    _NativeTypedArrayOfInt_NativeTypedArray_ListMixin: function _NativeTypedArrayOfInt_NativeTypedArray_ListMixin() {
    },
    _NativeTypedArrayOfInt_NativeTypedArray_ListMixin_FixedLengthListMixin: function _NativeTypedArrayOfInt_NativeTypedArray_ListMixin_FixedLengthListMixin() {
    },
    Rti__getQuestionFromStar(universe, rti) {
      var question = rti._precomputed1;
      return question == null ? rti._precomputed1 = A._Universe__lookupQuestionRti(universe, rti._primary, true) : question;
    },
    Rti__getFutureFromFutureOr(universe, rti) {
      var future = rti._precomputed1;
      return future == null ? rti._precomputed1 = A._Universe__lookupInterfaceRti(universe, "Future", [rti._primary]) : future;
    },
    Rti__isUnionOfFunctionType(rti) {
      var kind = rti._kind;
      if (kind === 6 || kind === 7 || kind === 8)
        return A.Rti__isUnionOfFunctionType(rti._primary);
      return kind === 12 || kind === 13;
    },
    Rti__getCanonicalRecipe(rti) {
      return rti._canonicalRecipe;
    },
    pairwiseIsTest(fieldRtis, values) {
      var i,
        $length = values.length;
      for (i = 0; i < $length; ++i)
        if (!fieldRtis[i]._is(values[i]))
          return false;
      return true;
    },
    findType(recipe) {
      return A._Universe_eval(init.typeUniverse, recipe, false);
    },
    instantiatedGenericFunctionType(genericFunctionRti, instantiationRti) {
      var t1, cache, key, probe, rti;
      if (genericFunctionRti == null)
        return null;
      t1 = instantiationRti._rest;
      cache = genericFunctionRti._bindCache;
      if (cache == null)
        cache = genericFunctionRti._bindCache = new Map();
      key = instantiationRti._canonicalRecipe;
      probe = cache.get(key);
      if (probe != null)
        return probe;
      rti = A._substitute(init.typeUniverse, genericFunctionRti._primary, t1, 0);
      cache.set(key, rti);
      return rti;
    },
    _substitute(universe, rti, typeArguments, depth) {
      var baseType, substitutedBaseType, interfaceTypeArguments, substitutedInterfaceTypeArguments, base, substitutedBase, $arguments, substitutedArguments, t1, fields, substitutedFields, returnType, substitutedReturnType, functionParameters, substitutedFunctionParameters, bounds, substitutedBounds, index, argument,
        kind = rti._kind;
      switch (kind) {
        case 5:
        case 1:
        case 2:
        case 3:
        case 4:
          return rti;
        case 6:
          baseType = rti._primary;
          substitutedBaseType = A._substitute(universe, baseType, typeArguments, depth);
          if (substitutedBaseType === baseType)
            return rti;
          return A._Universe__lookupStarRti(universe, substitutedBaseType, true);
        case 7:
          baseType = rti._primary;
          substitutedBaseType = A._substitute(universe, baseType, typeArguments, depth);
          if (substitutedBaseType === baseType)
            return rti;
          return A._Universe__lookupQuestionRti(universe, substitutedBaseType, true);
        case 8:
          baseType = rti._primary;
          substitutedBaseType = A._substitute(universe, baseType, typeArguments, depth);
          if (substitutedBaseType === baseType)
            return rti;
          return A._Universe__lookupFutureOrRti(universe, substitutedBaseType, true);
        case 9:
          interfaceTypeArguments = rti._rest;
          substitutedInterfaceTypeArguments = A._substituteArray(universe, interfaceTypeArguments, typeArguments, depth);
          if (substitutedInterfaceTypeArguments === interfaceTypeArguments)
            return rti;
          return A._Universe__lookupInterfaceRti(universe, rti._primary, substitutedInterfaceTypeArguments);
        case 10:
          base = rti._primary;
          substitutedBase = A._substitute(universe, base, typeArguments, depth);
          $arguments = rti._rest;
          substitutedArguments = A._substituteArray(universe, $arguments, typeArguments, depth);
          if (substitutedBase === base && substitutedArguments === $arguments)
            return rti;
          return A._Universe__lookupBindingRti(universe, substitutedBase, substitutedArguments);
        case 11:
          t1 = rti._primary;
          fields = rti._rest;
          substitutedFields = A._substituteArray(universe, fields, typeArguments, depth);
          if (substitutedFields === fields)
            return rti;
          return A._Universe__lookupRecordRti(universe, t1, substitutedFields);
        case 12:
          returnType = rti._primary;
          substitutedReturnType = A._substitute(universe, returnType, typeArguments, depth);
          functionParameters = rti._rest;
          substitutedFunctionParameters = A._substituteFunctionParameters(universe, functionParameters, typeArguments, depth);
          if (substitutedReturnType === returnType && substitutedFunctionParameters === functionParameters)
            return rti;
          return A._Universe__lookupFunctionRti(universe, substitutedReturnType, substitutedFunctionParameters);
        case 13:
          bounds = rti._rest;
          depth += bounds.length;
          substitutedBounds = A._substituteArray(universe, bounds, typeArguments, depth);
          base = rti._primary;
          substitutedBase = A._substitute(universe, base, typeArguments, depth);
          if (substitutedBounds === bounds && substitutedBase === base)
            return rti;
          return A._Universe__lookupGenericFunctionRti(universe, substitutedBase, substitutedBounds, true);
        case 14:
          index = rti._primary;
          if (index < depth)
            return rti;
          argument = typeArguments[index - depth];
          if (argument == null)
            return rti;
          return argument;
        default:
          throw A.wrapException(A.AssertionError$("Attempted to substitute unexpected RTI kind " + kind));
      }
    },
    _substituteArray(universe, rtiArray, typeArguments, depth) {
      var changed, i, rti, substitutedRti,
        $length = rtiArray.length,
        result = A._Utils_newArrayOrEmpty($length);
      for (changed = false, i = 0; i < $length; ++i) {
        rti = rtiArray[i];
        substitutedRti = A._substitute(universe, rti, typeArguments, depth);
        if (substitutedRti !== rti)
          changed = true;
        result[i] = substitutedRti;
      }
      return changed ? result : rtiArray;
    },
    _substituteNamed(universe, namedArray, typeArguments, depth) {
      var changed, i, t1, t2, rti, substitutedRti,
        $length = namedArray.length,
        result = A._Utils_newArrayOrEmpty($length);
      for (changed = false, i = 0; i < $length; i += 3) {
        t1 = namedArray[i];
        t2 = namedArray[i + 1];
        rti = namedArray[i + 2];
        substitutedRti = A._substitute(universe, rti, typeArguments, depth);
        if (substitutedRti !== rti)
          changed = true;
        result.splice(i, 3, t1, t2, substitutedRti);
      }
      return changed ? result : namedArray;
    },
    _substituteFunctionParameters(universe, functionParameters, typeArguments, depth) {
      var result,
        requiredPositional = functionParameters._requiredPositional,
        substitutedRequiredPositional = A._substituteArray(universe, requiredPositional, typeArguments, depth),
        optionalPositional = functionParameters._optionalPositional,
        substitutedOptionalPositional = A._substituteArray(universe, optionalPositional, typeArguments, depth),
        named = functionParameters._named,
        substitutedNamed = A._substituteNamed(universe, named, typeArguments, depth);
      if (substitutedRequiredPositional === requiredPositional && substitutedOptionalPositional === optionalPositional && substitutedNamed === named)
        return functionParameters;
      result = new A._FunctionParameters();
      result._requiredPositional = substitutedRequiredPositional;
      result._optionalPositional = substitutedOptionalPositional;
      result._named = substitutedNamed;
      return result;
    },
    _setArrayType(target, rti) {
      target[init.arrayRti] = rti;
      return target;
    },
    closureFunctionType(closure) {
      var signature = closure.$signature;
      if (signature != null) {
        if (typeof signature == "number")
          return A.getTypeFromTypesTable(signature);
        return closure.$signature();
      }
      return null;
    },
    instanceOrFunctionType(object, testRti) {
      var rti;
      if (A.Rti__isUnionOfFunctionType(testRti))
        if (object instanceof A.Closure) {
          rti = A.closureFunctionType(object);
          if (rti != null)
            return rti;
        }
      return A.instanceType(object);
    },
    instanceType(object) {
      if (object instanceof A.Object)
        return A._instanceType(object);
      if (Array.isArray(object))
        return A._arrayInstanceType(object);
      return A._instanceTypeFromConstructor(J.getInterceptor$(object));
    },
    _arrayInstanceType(object) {
      var rti = object[init.arrayRti],
        defaultRti = type$.JSArray_dynamic;
      if (rti == null)
        return defaultRti;
      if (rti.constructor !== defaultRti.constructor)
        return defaultRti;
      return rti;
    },
    _instanceType(object) {
      var rti = object.$ti;
      return rti != null ? rti : A._instanceTypeFromConstructor(object);
    },
    _instanceTypeFromConstructor(instance) {
      var $constructor = instance.constructor,
        probe = $constructor.$ccache;
      if (probe != null)
        return probe;
      return A._instanceTypeFromConstructorMiss(instance, $constructor);
    },
    _instanceTypeFromConstructorMiss(instance, $constructor) {
      var effectiveConstructor = instance instanceof A.Closure ? Object.getPrototypeOf(Object.getPrototypeOf(instance)).constructor : $constructor,
        rti = A._Universe_findErasedType(init.typeUniverse, effectiveConstructor.name);
      $constructor.$ccache = rti;
      return rti;
    },
    getTypeFromTypesTable(index) {
      var rti,
        table = init.types,
        type = table[index];
      if (typeof type == "string") {
        rti = A._Universe_eval(init.typeUniverse, type, false);
        table[index] = rti;
        return rti;
      }
      return type;
    },
    getRuntimeTypeOfDartObject(object) {
      return A.createRuntimeType(A._instanceType(object));
    },
    getRuntimeTypeOfClosure(closure) {
      var rti = A.closureFunctionType(closure);
      return A.createRuntimeType(rti == null ? A.instanceType(closure) : rti);
    },
    _structuralTypeOf(object) {
      var functionRti;
      if (object instanceof A._Record)
        return A.evaluateRtiForRecord(object.$recipe, object._getFieldValues$0());
      functionRti = object instanceof A.Closure ? A.closureFunctionType(object) : null;
      if (functionRti != null)
        return functionRti;
      if (type$.TrustedGetRuntimeType._is(object))
        return J.get$runtimeType$(object)._rti;
      if (Array.isArray(object))
        return A._arrayInstanceType(object);
      return A.instanceType(object);
    },
    createRuntimeType(rti) {
      var t1 = rti._cachedRuntimeType;
      return t1 == null ? rti._cachedRuntimeType = A._createRuntimeType(rti) : t1;
    },
    _createRuntimeType(rti) {
      var starErasedRti, t1,
        s = rti._canonicalRecipe,
        starErasedRecipe = s.replace(/\*/g, "");
      if (starErasedRecipe === s)
        return rti._cachedRuntimeType = new A._Type(rti);
      starErasedRti = A._Universe_eval(init.typeUniverse, starErasedRecipe, true);
      t1 = starErasedRti._cachedRuntimeType;
      return t1 == null ? starErasedRti._cachedRuntimeType = A._createRuntimeType(starErasedRti) : t1;
    },
    evaluateRtiForRecord(recordRecipe, valuesList) {
      var bindings, i,
        values = valuesList,
        $length = values.length;
      if ($length === 0)
        return type$.Record_0;
      bindings = A._Universe_evalInEnvironment(init.typeUniverse, A._structuralTypeOf(values[0]), "@<0>");
      for (i = 1; i < $length; ++i)
        bindings = A._Universe_bind(init.typeUniverse, bindings, A._structuralTypeOf(values[i]));
      return A._Universe_evalInEnvironment(init.typeUniverse, bindings, recordRecipe);
    },
    typeLiteral(recipe) {
      return A.createRuntimeType(A._Universe_eval(init.typeUniverse, recipe, false));
    },
    _installSpecializedIsTest(object) {
      var t1, unstarred, unstarredKind, isFn, $name, predicate, testRti = this;
      if (testRti === type$.Object)
        return A._finishIsFn(testRti, object, A._isObject);
      if (!A.isSoundTopType(testRti))
        t1 = testRti === type$.legacy_Object;
      else
        t1 = true;
      if (t1)
        return A._finishIsFn(testRti, object, A._isTop);
      t1 = testRti._kind;
      if (t1 === 7)
        return A._finishIsFn(testRti, object, A._generalNullableIsTestImplementation);
      if (t1 === 1)
        return A._finishIsFn(testRti, object, A._isNever);
      unstarred = t1 === 6 ? testRti._primary : testRti;
      unstarredKind = unstarred._kind;
      if (unstarredKind === 8)
        return A._finishIsFn(testRti, object, A._isFutureOr);
      if (unstarred === type$.int)
        isFn = A._isInt;
      else if (unstarred === type$.double || unstarred === type$.num)
        isFn = A._isNum;
      else if (unstarred === type$.String)
        isFn = A._isString;
      else
        isFn = unstarred === type$.bool ? A._isBool : null;
      if (isFn != null)
        return A._finishIsFn(testRti, object, isFn);
      if (unstarredKind === 9) {
        $name = unstarred._primary;
        if (unstarred._rest.every(A.isDefinitelyTopType)) {
          testRti._specializedTestResource = "$is" + $name;
          if ($name === "List")
            return A._finishIsFn(testRti, object, A._isListTestViaProperty);
          return A._finishIsFn(testRti, object, A._isTestViaProperty);
        }
      } else if (unstarredKind === 11) {
        predicate = A.createRecordTypePredicate(unstarred._primary, unstarred._rest);
        return A._finishIsFn(testRti, object, predicate == null ? A._isNever : predicate);
      }
      return A._finishIsFn(testRti, object, A._generalIsTestImplementation);
    },
    _finishIsFn(testRti, object, isFn) {
      testRti._is = isFn;
      return testRti._is(object);
    },
    _installSpecializedAsCheck(object) {
      var t1, testRti = this,
        asFn = A._generalAsCheckImplementation;
      if (!A.isSoundTopType(testRti))
        t1 = testRti === type$.legacy_Object;
      else
        t1 = true;
      if (t1)
        asFn = A._asTop;
      else if (testRti === type$.Object)
        asFn = A._asObject;
      else {
        t1 = A.isNullable(testRti);
        if (t1)
          asFn = A._generalNullableAsCheckImplementation;
      }
      testRti._as = asFn;
      return testRti._as(object);
    },
    _nullIs(testRti) {
      var t1,
        kind = testRti._kind;
      if (!A.isSoundTopType(testRti))
        if (!(testRti === type$.legacy_Object))
          if (!(testRti === type$.legacy_Never))
            if (kind !== 7)
              if (!(kind === 6 && A._nullIs(testRti._primary)))
                t1 = kind === 8 && A._nullIs(testRti._primary) || testRti === type$.Null || testRti === type$.JSNull;
              else
                t1 = true;
            else
              t1 = true;
          else
            t1 = true;
        else
          t1 = true;
      else
        t1 = true;
      return t1;
    },
    _generalIsTestImplementation(object) {
      var testRti = this;
      if (object == null)
        return A._nullIs(testRti);
      return A.isSubtype(init.typeUniverse, A.instanceOrFunctionType(object, testRti), testRti);
    },
    _generalNullableIsTestImplementation(object) {
      if (object == null)
        return true;
      return this._primary._is(object);
    },
    _isTestViaProperty(object) {
      var tag, testRti = this;
      if (object == null)
        return A._nullIs(testRti);
      tag = testRti._specializedTestResource;
      if (object instanceof A.Object)
        return !!object[tag];
      return !!J.getInterceptor$(object)[tag];
    },
    _isListTestViaProperty(object) {
      var tag, testRti = this;
      if (object == null)
        return A._nullIs(testRti);
      if (typeof object != "object")
        return false;
      if (Array.isArray(object))
        return true;
      tag = testRti._specializedTestResource;
      if (object instanceof A.Object)
        return !!object[tag];
      return !!J.getInterceptor$(object)[tag];
    },
    _generalAsCheckImplementation(object) {
      var testRti = this;
      if (object == null) {
        if (A.isNullable(testRti))
          return object;
      } else if (testRti._is(object))
        return object;
      A._failedAsCheck(object, testRti);
    },
    _generalNullableAsCheckImplementation(object) {
      var testRti = this;
      if (object == null)
        return object;
      else if (testRti._is(object))
        return object;
      A._failedAsCheck(object, testRti);
    },
    _failedAsCheck(object, testRti) {
      throw A.wrapException(A._TypeError$fromMessage(A._Error_compose(object, A._rtiToString(testRti, null))));
    },
    _Error_compose(object, checkedTypeDescription) {
      return A.Error_safeToString(object) + ": type '" + A._rtiToString(A._structuralTypeOf(object), null) + "' is not a subtype of type '" + checkedTypeDescription + "'";
    },
    _TypeError$fromMessage(message) {
      return new A._TypeError("TypeError: " + message);
    },
    _TypeError__TypeError$forType(object, type) {
      return new A._TypeError("TypeError: " + A._Error_compose(object, type));
    },
    _isFutureOr(object) {
      var testRti = this,
        unstarred = testRti._kind === 6 ? testRti._primary : testRti;
      return unstarred._primary._is(object) || A.Rti__getFutureFromFutureOr(init.typeUniverse, unstarred)._is(object);
    },
    _isObject(object) {
      return object != null;
    },
    _asObject(object) {
      if (object != null)
        return object;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "Object"));
    },
    _isTop(object) {
      return true;
    },
    _asTop(object) {
      return object;
    },
    _isNever(object) {
      return false;
    },
    _isBool(object) {
      return true === object || false === object;
    },
    _asBool(object) {
      if (true === object)
        return true;
      if (false === object)
        return false;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "bool"));
    },
    _asBoolS(object) {
      if (true === object)
        return true;
      if (false === object)
        return false;
      if (object == null)
        return object;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "bool"));
    },
    _asBoolQ(object) {
      if (true === object)
        return true;
      if (false === object)
        return false;
      if (object == null)
        return object;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "bool?"));
    },
    _asDouble(object) {
      if (typeof object == "number")
        return object;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "double"));
    },
    _asDoubleS(object) {
      if (typeof object == "number")
        return object;
      if (object == null)
        return object;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "double"));
    },
    _asDoubleQ(object) {
      if (typeof object == "number")
        return object;
      if (object == null)
        return object;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "double?"));
    },
    _isInt(object) {
      return typeof object == "number" && Math.floor(object) === object;
    },
    _asInt(object) {
      if (typeof object == "number" && Math.floor(object) === object)
        return object;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "int"));
    },
    _asIntS(object) {
      if (typeof object == "number" && Math.floor(object) === object)
        return object;
      if (object == null)
        return object;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "int"));
    },
    _asIntQ(object) {
      if (typeof object == "number" && Math.floor(object) === object)
        return object;
      if (object == null)
        return object;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "int?"));
    },
    _isNum(object) {
      return typeof object == "number";
    },
    _asNum(object) {
      if (typeof object == "number")
        return object;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "num"));
    },
    _asNumS(object) {
      if (typeof object == "number")
        return object;
      if (object == null)
        return object;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "num"));
    },
    _asNumQ(object) {
      if (typeof object == "number")
        return object;
      if (object == null)
        return object;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "num?"));
    },
    _isString(object) {
      return typeof object == "string";
    },
    _asString(object) {
      if (typeof object == "string")
        return object;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "String"));
    },
    _asStringS(object) {
      if (typeof object == "string")
        return object;
      if (object == null)
        return object;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "String"));
    },
    _asStringQ(object) {
      if (typeof object == "string")
        return object;
      if (object == null)
        return object;
      throw A.wrapException(A._TypeError__TypeError$forType(object, "String?"));
    },
    _rtiArrayToString(array, genericContext) {
      var s, sep, i;
      for (s = "", sep = "", i = 0; i < array.length; ++i, sep = ", ")
        s += sep + A._rtiToString(array[i], genericContext);
      return s;
    },
    _recordRtiToString(recordType, genericContext) {
      var fieldCount, names, namesIndex, s, comma, i,
        partialShape = recordType._primary,
        fields = recordType._rest;
      if ("" === partialShape)
        return "(" + A._rtiArrayToString(fields, genericContext) + ")";
      fieldCount = fields.length;
      names = partialShape.split(",");
      namesIndex = names.length - fieldCount;
      for (s = "(", comma = "", i = 0; i < fieldCount; ++i, comma = ", ") {
        s += comma;
        if (namesIndex === 0)
          s += "{";
        s += A._rtiToString(fields[i], genericContext);
        if (namesIndex >= 0)
          s += " " + names[namesIndex];
        ++namesIndex;
      }
      return s + "})";
    },
    _functionRtiToString(functionType, genericContext, bounds) {
      var boundsLength, outerContextLength, offset, i, t1, t2, typeParametersText, typeSep, boundRti, kind, t3, parameters, requiredPositional, requiredPositionalLength, optionalPositional, optionalPositionalLength, named, namedLength, returnTypeText, argumentsText, sep, _s2_ = ", ";
      if (bounds != null) {
        boundsLength = bounds.length;
        if (genericContext == null) {
          genericContext = A._setArrayType([], type$.JSArray_String);
          outerContextLength = null;
        } else
          outerContextLength = genericContext.length;
        offset = genericContext.length;
        for (i = boundsLength; i > 0; --i)
          genericContext.push("T" + (offset + i));
        for (t1 = type$.nullable_Object, t2 = type$.legacy_Object, typeParametersText = "<", typeSep = "", i = 0; i < boundsLength; ++i, typeSep = _s2_) {
          typeParametersText = B.JSString_methods.$add(typeParametersText + typeSep, genericContext[genericContext.length - 1 - i]);
          boundRti = bounds[i];
          kind = boundRti._kind;
          if (!(kind === 2 || kind === 3 || kind === 4 || kind === 5 || boundRti === t1))
            t3 = boundRti === t2;
          else
            t3 = true;
          if (!t3)
            typeParametersText += " extends " + A._rtiToString(boundRti, genericContext);
        }
        typeParametersText += ">";
      } else {
        typeParametersText = "";
        outerContextLength = null;
      }
      t1 = functionType._primary;
      parameters = functionType._rest;
      requiredPositional = parameters._requiredPositional;
      requiredPositionalLength = requiredPositional.length;
      optionalPositional = parameters._optionalPositional;
      optionalPositionalLength = optionalPositional.length;
      named = parameters._named;
      namedLength = named.length;
      returnTypeText = A._rtiToString(t1, genericContext);
      for (argumentsText = "", sep = "", i = 0; i < requiredPositionalLength; ++i, sep = _s2_)
        argumentsText += sep + A._rtiToString(requiredPositional[i], genericContext);
      if (optionalPositionalLength > 0) {
        argumentsText += sep + "[";
        for (sep = "", i = 0; i < optionalPositionalLength; ++i, sep = _s2_)
          argumentsText += sep + A._rtiToString(optionalPositional[i], genericContext);
        argumentsText += "]";
      }
      if (namedLength > 0) {
        argumentsText += sep + "{";
        for (sep = "", i = 0; i < namedLength; i += 3, sep = _s2_) {
          argumentsText += sep;
          if (named[i + 1])
            argumentsText += "required ";
          argumentsText += A._rtiToString(named[i + 2], genericContext) + " " + named[i];
        }
        argumentsText += "}";
      }
      if (outerContextLength != null) {
        genericContext.toString;
        genericContext.length = outerContextLength;
      }
      return typeParametersText + "(" + argumentsText + ") => " + returnTypeText;
    },
    _rtiToString(rti, genericContext) {
      var questionArgument, s, argumentKind, $name, $arguments, t1,
        kind = rti._kind;
      if (kind === 5)
        return "erased";
      if (kind === 2)
        return "dynamic";
      if (kind === 3)
        return "void";
      if (kind === 1)
        return "Never";
      if (kind === 4)
        return "any";
      if (kind === 6)
        return A._rtiToString(rti._primary, genericContext);
      if (kind === 7) {
        questionArgument = rti._primary;
        s = A._rtiToString(questionArgument, genericContext);
        argumentKind = questionArgument._kind;
        return (argumentKind === 12 || argumentKind === 13 ? "(" + s + ")" : s) + "?";
      }
      if (kind === 8)
        return "FutureOr<" + A._rtiToString(rti._primary, genericContext) + ">";
      if (kind === 9) {
        $name = A._unminifyOrTag(rti._primary);
        $arguments = rti._rest;
        return $arguments.length > 0 ? $name + ("<" + A._rtiArrayToString($arguments, genericContext) + ">") : $name;
      }
      if (kind === 11)
        return A._recordRtiToString(rti, genericContext);
      if (kind === 12)
        return A._functionRtiToString(rti, genericContext, null);
      if (kind === 13)
        return A._functionRtiToString(rti._primary, genericContext, rti._rest);
      if (kind === 14) {
        t1 = rti._primary;
        return genericContext[genericContext.length - 1 - t1];
      }
      return "?";
    },
    _unminifyOrTag(rawClassName) {
      var preserved = init.mangledGlobalNames[rawClassName];
      if (preserved != null)
        return preserved;
      return rawClassName;
    },
    _Universe_findRule(universe, targetType) {
      var rule = universe.tR[targetType];
      for (; typeof rule == "string";)
        rule = universe.tR[rule];
      return rule;
    },
    _Universe_findErasedType(universe, cls) {
      var $length, erased, $arguments, i, $interface,
        t1 = universe.eT,
        probe = t1[cls];
      if (probe == null)
        return A._Universe_eval(universe, cls, false);
      else if (typeof probe == "number") {
        $length = probe;
        erased = A._Universe__lookupTerminalRti(universe, 5, "#");
        $arguments = A._Utils_newArrayOrEmpty($length);
        for (i = 0; i < $length; ++i)
          $arguments[i] = erased;
        $interface = A._Universe__lookupInterfaceRti(universe, cls, $arguments);
        t1[cls] = $interface;
        return $interface;
      } else
        return probe;
    },
    _Universe_addRules(universe, rules) {
      return A._Utils_objectAssign(universe.tR, rules);
    },
    _Universe_addErasedTypes(universe, types) {
      return A._Utils_objectAssign(universe.eT, types);
    },
    _Universe_eval(universe, recipe, normalize) {
      var rti,
        t1 = universe.eC,
        probe = t1.get(recipe);
      if (probe != null)
        return probe;
      rti = A._Parser_parse(A._Parser_create(universe, null, recipe, normalize));
      t1.set(recipe, rti);
      return rti;
    },
    _Universe_evalInEnvironment(universe, environment, recipe) {
      var probe, rti,
        cache = environment._evalCache;
      if (cache == null)
        cache = environment._evalCache = new Map();
      probe = cache.get(recipe);
      if (probe != null)
        return probe;
      rti = A._Parser_parse(A._Parser_create(universe, environment, recipe, true));
      cache.set(recipe, rti);
      return rti;
    },
    _Universe_bind(universe, environment, argumentsRti) {
      var argumentsRecipe, probe, rti,
        cache = environment._bindCache;
      if (cache == null)
        cache = environment._bindCache = new Map();
      argumentsRecipe = argumentsRti._canonicalRecipe;
      probe = cache.get(argumentsRecipe);
      if (probe != null)
        return probe;
      rti = A._Universe__lookupBindingRti(universe, environment, argumentsRti._kind === 10 ? argumentsRti._rest : [argumentsRti]);
      cache.set(argumentsRecipe, rti);
      return rti;
    },
    _Universe__installTypeTests(universe, rti) {
      rti._as = A._installSpecializedAsCheck;
      rti._is = A._installSpecializedIsTest;
      return rti;
    },
    _Universe__lookupTerminalRti(universe, kind, key) {
      var rti, t1,
        probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      rti = new A.Rti(null, null);
      rti._kind = kind;
      rti._canonicalRecipe = key;
      t1 = A._Universe__installTypeTests(universe, rti);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__lookupStarRti(universe, baseType, normalize) {
      var t1,
        key = baseType._canonicalRecipe + "*",
        probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      t1 = A._Universe__createStarRti(universe, baseType, key, normalize);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__createStarRti(universe, baseType, key, normalize) {
      var baseKind, t1, rti;
      if (normalize) {
        baseKind = baseType._kind;
        if (!A.isSoundTopType(baseType))
          t1 = baseType === type$.Null || baseType === type$.JSNull || baseKind === 7 || baseKind === 6;
        else
          t1 = true;
        if (t1)
          return baseType;
      }
      rti = new A.Rti(null, null);
      rti._kind = 6;
      rti._primary = baseType;
      rti._canonicalRecipe = key;
      return A._Universe__installTypeTests(universe, rti);
    },
    _Universe__lookupQuestionRti(universe, baseType, normalize) {
      var t1,
        key = baseType._canonicalRecipe + "?",
        probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      t1 = A._Universe__createQuestionRti(universe, baseType, key, normalize);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__createQuestionRti(universe, baseType, key, normalize) {
      var baseKind, t1, starArgument, rti;
      if (normalize) {
        baseKind = baseType._kind;
        if (!A.isSoundTopType(baseType))
          if (!(baseType === type$.Null || baseType === type$.JSNull))
            if (baseKind !== 7)
              t1 = baseKind === 8 && A.isNullable(baseType._primary);
            else
              t1 = true;
          else
            t1 = true;
        else
          t1 = true;
        if (t1)
          return baseType;
        else if (baseKind === 1 || baseType === type$.legacy_Never)
          return type$.Null;
        else if (baseKind === 6) {
          starArgument = baseType._primary;
          if (starArgument._kind === 8 && A.isNullable(starArgument._primary))
            return starArgument;
          else
            return A.Rti__getQuestionFromStar(universe, baseType);
        }
      }
      rti = new A.Rti(null, null);
      rti._kind = 7;
      rti._primary = baseType;
      rti._canonicalRecipe = key;
      return A._Universe__installTypeTests(universe, rti);
    },
    _Universe__lookupFutureOrRti(universe, baseType, normalize) {
      var t1,
        key = baseType._canonicalRecipe + "/",
        probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      t1 = A._Universe__createFutureOrRti(universe, baseType, key, normalize);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__createFutureOrRti(universe, baseType, key, normalize) {
      var t1, rti;
      if (normalize) {
        t1 = baseType._kind;
        if (A.isSoundTopType(baseType) || baseType === type$.Object || baseType === type$.legacy_Object)
          return baseType;
        else if (t1 === 1)
          return A._Universe__lookupInterfaceRti(universe, "Future", [baseType]);
        else if (baseType === type$.Null || baseType === type$.JSNull)
          return type$.nullable_Future_Null;
      }
      rti = new A.Rti(null, null);
      rti._kind = 8;
      rti._primary = baseType;
      rti._canonicalRecipe = key;
      return A._Universe__installTypeTests(universe, rti);
    },
    _Universe__lookupGenericFunctionParameterRti(universe, index) {
      var rti, t1,
        key = "" + index + "^",
        probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      rti = new A.Rti(null, null);
      rti._kind = 14;
      rti._primary = index;
      rti._canonicalRecipe = key;
      t1 = A._Universe__installTypeTests(universe, rti);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__canonicalRecipeJoin($arguments) {
      var s, sep, i,
        $length = $arguments.length;
      for (s = "", sep = "", i = 0; i < $length; ++i, sep = ",")
        s += sep + $arguments[i]._canonicalRecipe;
      return s;
    },
    _Universe__canonicalRecipeJoinNamed($arguments) {
      var s, sep, i, t1, nameSep,
        $length = $arguments.length;
      for (s = "", sep = "", i = 0; i < $length; i += 3, sep = ",") {
        t1 = $arguments[i];
        nameSep = $arguments[i + 1] ? "!" : ":";
        s += sep + t1 + nameSep + $arguments[i + 2]._canonicalRecipe;
      }
      return s;
    },
    _Universe__lookupInterfaceRti(universe, $name, $arguments) {
      var probe, rti, t1,
        s = $name;
      if ($arguments.length > 0)
        s += "<" + A._Universe__canonicalRecipeJoin($arguments) + ">";
      probe = universe.eC.get(s);
      if (probe != null)
        return probe;
      rti = new A.Rti(null, null);
      rti._kind = 9;
      rti._primary = $name;
      rti._rest = $arguments;
      if ($arguments.length > 0)
        rti._precomputed1 = $arguments[0];
      rti._canonicalRecipe = s;
      t1 = A._Universe__installTypeTests(universe, rti);
      universe.eC.set(s, t1);
      return t1;
    },
    _Universe__lookupBindingRti(universe, base, $arguments) {
      var newBase, newArguments, key, probe, rti, t1;
      if (base._kind === 10) {
        newBase = base._primary;
        newArguments = base._rest.concat($arguments);
      } else {
        newArguments = $arguments;
        newBase = base;
      }
      key = newBase._canonicalRecipe + (";<" + A._Universe__canonicalRecipeJoin(newArguments) + ">");
      probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      rti = new A.Rti(null, null);
      rti._kind = 10;
      rti._primary = newBase;
      rti._rest = newArguments;
      rti._canonicalRecipe = key;
      t1 = A._Universe__installTypeTests(universe, rti);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__lookupRecordRti(universe, partialShapeTag, fields) {
      var rti, t1,
        key = "+" + (partialShapeTag + "(" + A._Universe__canonicalRecipeJoin(fields) + ")"),
        probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      rti = new A.Rti(null, null);
      rti._kind = 11;
      rti._primary = partialShapeTag;
      rti._rest = fields;
      rti._canonicalRecipe = key;
      t1 = A._Universe__installTypeTests(universe, rti);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__lookupFunctionRti(universe, returnType, parameters) {
      var sep, key, probe, rti, t1,
        s = returnType._canonicalRecipe,
        requiredPositional = parameters._requiredPositional,
        requiredPositionalLength = requiredPositional.length,
        optionalPositional = parameters._optionalPositional,
        optionalPositionalLength = optionalPositional.length,
        named = parameters._named,
        namedLength = named.length,
        recipe = "(" + A._Universe__canonicalRecipeJoin(requiredPositional);
      if (optionalPositionalLength > 0) {
        sep = requiredPositionalLength > 0 ? "," : "";
        recipe += sep + "[" + A._Universe__canonicalRecipeJoin(optionalPositional) + "]";
      }
      if (namedLength > 0) {
        sep = requiredPositionalLength > 0 ? "," : "";
        recipe += sep + "{" + A._Universe__canonicalRecipeJoinNamed(named) + "}";
      }
      key = s + (recipe + ")");
      probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      rti = new A.Rti(null, null);
      rti._kind = 12;
      rti._primary = returnType;
      rti._rest = parameters;
      rti._canonicalRecipe = key;
      t1 = A._Universe__installTypeTests(universe, rti);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__lookupGenericFunctionRti(universe, baseFunctionType, bounds, normalize) {
      var t1,
        key = baseFunctionType._canonicalRecipe + ("<" + A._Universe__canonicalRecipeJoin(bounds) + ">"),
        probe = universe.eC.get(key);
      if (probe != null)
        return probe;
      t1 = A._Universe__createGenericFunctionRti(universe, baseFunctionType, bounds, key, normalize);
      universe.eC.set(key, t1);
      return t1;
    },
    _Universe__createGenericFunctionRti(universe, baseFunctionType, bounds, key, normalize) {
      var $length, typeArguments, count, i, bound, substitutedBase, substitutedBounds, rti;
      if (normalize) {
        $length = bounds.length;
        typeArguments = A._Utils_newArrayOrEmpty($length);
        for (count = 0, i = 0; i < $length; ++i) {
          bound = bounds[i];
          if (bound._kind === 1) {
            typeArguments[i] = bound;
            ++count;
          }
        }
        if (count > 0) {
          substitutedBase = A._substitute(universe, baseFunctionType, typeArguments, 0);
          substitutedBounds = A._substituteArray(universe, bounds, typeArguments, 0);
          return A._Universe__lookupGenericFunctionRti(universe, substitutedBase, substitutedBounds, bounds !== substitutedBounds);
        }
      }
      rti = new A.Rti(null, null);
      rti._kind = 13;
      rti._primary = baseFunctionType;
      rti._rest = bounds;
      rti._canonicalRecipe = key;
      return A._Universe__installTypeTests(universe, rti);
    },
    _Parser_create(universe, environment, recipe, normalize) {
      return {u: universe, e: environment, r: recipe, s: [], p: 0, n: normalize};
    },
    _Parser_parse(parser) {
      var t2, i, ch, t3, array, end, item,
        source = parser.r,
        t1 = parser.s;
      for (t2 = source.length, i = 0; i < t2;) {
        ch = source.charCodeAt(i);
        if (ch >= 48 && ch <= 57)
          i = A._Parser_handleDigit(i + 1, ch, source, t1);
        else if ((((ch | 32) >>> 0) - 97 & 65535) < 26 || ch === 95 || ch === 36 || ch === 124)
          i = A._Parser_handleIdentifier(parser, i, source, t1, false);
        else if (ch === 46)
          i = A._Parser_handleIdentifier(parser, i, source, t1, true);
        else {
          ++i;
          switch (ch) {
            case 44:
              break;
            case 58:
              t1.push(false);
              break;
            case 33:
              t1.push(true);
              break;
            case 59:
              t1.push(A._Parser_toType(parser.u, parser.e, t1.pop()));
              break;
            case 94:
              t1.push(A._Universe__lookupGenericFunctionParameterRti(parser.u, t1.pop()));
              break;
            case 35:
              t1.push(A._Universe__lookupTerminalRti(parser.u, 5, "#"));
              break;
            case 64:
              t1.push(A._Universe__lookupTerminalRti(parser.u, 2, "@"));
              break;
            case 126:
              t1.push(A._Universe__lookupTerminalRti(parser.u, 3, "~"));
              break;
            case 60:
              t1.push(parser.p);
              parser.p = t1.length;
              break;
            case 62:
              A._Parser_handleTypeArguments(parser, t1);
              break;
            case 38:
              A._Parser_handleExtendedOperations(parser, t1);
              break;
            case 42:
              t3 = parser.u;
              t1.push(A._Universe__lookupStarRti(t3, A._Parser_toType(t3, parser.e, t1.pop()), parser.n));
              break;
            case 63:
              t3 = parser.u;
              t1.push(A._Universe__lookupQuestionRti(t3, A._Parser_toType(t3, parser.e, t1.pop()), parser.n));
              break;
            case 47:
              t3 = parser.u;
              t1.push(A._Universe__lookupFutureOrRti(t3, A._Parser_toType(t3, parser.e, t1.pop()), parser.n));
              break;
            case 40:
              t1.push(-3);
              t1.push(parser.p);
              parser.p = t1.length;
              break;
            case 41:
              A._Parser_handleArguments(parser, t1);
              break;
            case 91:
              t1.push(parser.p);
              parser.p = t1.length;
              break;
            case 93:
              array = t1.splice(parser.p);
              A._Parser_toTypes(parser.u, parser.e, array);
              parser.p = t1.pop();
              t1.push(array);
              t1.push(-1);
              break;
            case 123:
              t1.push(parser.p);
              parser.p = t1.length;
              break;
            case 125:
              array = t1.splice(parser.p);
              A._Parser_toTypesNamed(parser.u, parser.e, array);
              parser.p = t1.pop();
              t1.push(array);
              t1.push(-2);
              break;
            case 43:
              end = source.indexOf("(", i);
              t1.push(source.substring(i, end));
              t1.push(-4);
              t1.push(parser.p);
              parser.p = t1.length;
              i = end + 1;
              break;
            default:
              throw "Bad character " + ch;
          }
        }
      }
      item = t1.pop();
      return A._Parser_toType(parser.u, parser.e, item);
    },
    _Parser_handleDigit(i, digit, source, stack) {
      var t1, ch,
        value = digit - 48;
      for (t1 = source.length; i < t1; ++i) {
        ch = source.charCodeAt(i);
        if (!(ch >= 48 && ch <= 57))
          break;
        value = value * 10 + (ch - 48);
      }
      stack.push(value);
      return i;
    },
    _Parser_handleIdentifier(parser, start, source, stack, hasPeriod) {
      var t1, ch, t2, string, environment, recipe,
        i = start + 1;
      for (t1 = source.length; i < t1; ++i) {
        ch = source.charCodeAt(i);
        if (ch === 46) {
          if (hasPeriod)
            break;
          hasPeriod = true;
        } else {
          if (!((((ch | 32) >>> 0) - 97 & 65535) < 26 || ch === 95 || ch === 36 || ch === 124))
            t2 = ch >= 48 && ch <= 57;
          else
            t2 = true;
          if (!t2)
            break;
        }
      }
      string = source.substring(start, i);
      if (hasPeriod) {
        t1 = parser.u;
        environment = parser.e;
        if (environment._kind === 10)
          environment = environment._primary;
        recipe = A._Universe_findRule(t1, environment._primary)[string];
        if (recipe == null)
          A.throwExpression('No "' + string + '" in "' + A.Rti__getCanonicalRecipe(environment) + '"');
        stack.push(A._Universe_evalInEnvironment(t1, environment, recipe));
      } else
        stack.push(string);
      return i;
    },
    _Parser_handleTypeArguments(parser, stack) {
      var base,
        t1 = parser.u,
        $arguments = A._Parser_collectArray(parser, stack),
        head = stack.pop();
      if (typeof head == "string")
        stack.push(A._Universe__lookupInterfaceRti(t1, head, $arguments));
      else {
        base = A._Parser_toType(t1, parser.e, head);
        switch (base._kind) {
          case 12:
            stack.push(A._Universe__lookupGenericFunctionRti(t1, base, $arguments, parser.n));
            break;
          default:
            stack.push(A._Universe__lookupBindingRti(t1, base, $arguments));
            break;
        }
      }
    },
    _Parser_handleArguments(parser, stack) {
      var optionalPositional, named, requiredPositional, returnType, parameters, _null = null,
        t1 = parser.u,
        head = stack.pop();
      if (typeof head == "number")
        switch (head) {
          case -1:
            optionalPositional = stack.pop();
            named = _null;
            break;
          case -2:
            named = stack.pop();
            optionalPositional = _null;
            break;
          default:
            stack.push(head);
            named = _null;
            optionalPositional = named;
            break;
        }
      else {
        stack.push(head);
        named = _null;
        optionalPositional = named;
      }
      requiredPositional = A._Parser_collectArray(parser, stack);
      head = stack.pop();
      switch (head) {
        case -3:
          head = stack.pop();
          if (optionalPositional == null)
            optionalPositional = t1.sEA;
          if (named == null)
            named = t1.sEA;
          returnType = A._Parser_toType(t1, parser.e, head);
          parameters = new A._FunctionParameters();
          parameters._requiredPositional = requiredPositional;
          parameters._optionalPositional = optionalPositional;
          parameters._named = named;
          stack.push(A._Universe__lookupFunctionRti(t1, returnType, parameters));
          return;
        case -4:
          stack.push(A._Universe__lookupRecordRti(t1, stack.pop(), requiredPositional));
          return;
        default:
          throw A.wrapException(A.AssertionError$("Unexpected state under `()`: " + A.S(head)));
      }
    },
    _Parser_handleExtendedOperations(parser, stack) {
      var $top = stack.pop();
      if (0 === $top) {
        stack.push(A._Universe__lookupTerminalRti(parser.u, 1, "0&"));
        return;
      }
      if (1 === $top) {
        stack.push(A._Universe__lookupTerminalRti(parser.u, 4, "1&"));
        return;
      }
      throw A.wrapException(A.AssertionError$("Unexpected extended operation " + A.S($top)));
    },
    _Parser_collectArray(parser, stack) {
      var array = stack.splice(parser.p);
      A._Parser_toTypes(parser.u, parser.e, array);
      parser.p = stack.pop();
      return array;
    },
    _Parser_toType(universe, environment, item) {
      if (typeof item == "string")
        return A._Universe__lookupInterfaceRti(universe, item, universe.sEA);
      else if (typeof item == "number") {
        environment.toString;
        return A._Parser_indexToType(universe, environment, item);
      } else
        return item;
    },
    _Parser_toTypes(universe, environment, items) {
      var i,
        $length = items.length;
      for (i = 0; i < $length; ++i)
        items[i] = A._Parser_toType(universe, environment, items[i]);
    },
    _Parser_toTypesNamed(universe, environment, items) {
      var i,
        $length = items.length;
      for (i = 2; i < $length; i += 3)
        items[i] = A._Parser_toType(universe, environment, items[i]);
    },
    _Parser_indexToType(universe, environment, index) {
      var typeArguments, len,
        kind = environment._kind;
      if (kind === 10) {
        if (index === 0)
          return environment._primary;
        typeArguments = environment._rest;
        len = typeArguments.length;
        if (index <= len)
          return typeArguments[index - 1];
        index -= len;
        environment = environment._primary;
        kind = environment._kind;
      } else if (index === 0)
        return environment;
      if (kind !== 9)
        throw A.wrapException(A.AssertionError$("Indexed base must be an interface type"));
      typeArguments = environment._rest;
      if (index <= typeArguments.length)
        return typeArguments[index - 1];
      throw A.wrapException(A.AssertionError$("Bad index " + index + " for " + environment.toString$0(0)));
    },
    isSubtype(universe, s, t) {
      var result,
        sCache = s._isSubtypeCache;
      if (sCache == null)
        sCache = s._isSubtypeCache = new Map();
      result = sCache.get(t);
      if (result == null) {
        result = A._isSubtype(universe, s, null, t, null, false) ? 1 : 0;
        sCache.set(t, result);
      }
      if (0 === result)
        return false;
      if (1 === result)
        return true;
      return true;
    },
    _isSubtype(universe, s, sEnv, t, tEnv, isLegacy) {
      var t1, sKind, leftTypeVariable, tKind, t2, sBounds, tBounds, sLength, i, sBound, tBound;
      if (s === t)
        return true;
      if (!A.isSoundTopType(t))
        t1 = t === type$.legacy_Object;
      else
        t1 = true;
      if (t1)
        return true;
      sKind = s._kind;
      if (sKind === 4)
        return true;
      if (A.isSoundTopType(s))
        return false;
      t1 = s._kind;
      if (t1 === 1)
        return true;
      leftTypeVariable = sKind === 14;
      if (leftTypeVariable)
        if (A._isSubtype(universe, sEnv[s._primary], sEnv, t, tEnv, false))
          return true;
      tKind = t._kind;
      t1 = s === type$.Null || s === type$.JSNull;
      if (t1) {
        if (tKind === 8)
          return A._isSubtype(universe, s, sEnv, t._primary, tEnv, false);
        return t === type$.Null || t === type$.JSNull || tKind === 7 || tKind === 6;
      }
      if (t === type$.Object) {
        if (sKind === 8)
          return A._isSubtype(universe, s._primary, sEnv, t, tEnv, false);
        if (sKind === 6)
          return A._isSubtype(universe, s._primary, sEnv, t, tEnv, false);
        return sKind !== 7;
      }
      if (sKind === 6)
        return A._isSubtype(universe, s._primary, sEnv, t, tEnv, false);
      if (tKind === 6) {
        t1 = A.Rti__getQuestionFromStar(universe, t);
        return A._isSubtype(universe, s, sEnv, t1, tEnv, false);
      }
      if (sKind === 8) {
        if (!A._isSubtype(universe, s._primary, sEnv, t, tEnv, false))
          return false;
        return A._isSubtype(universe, A.Rti__getFutureFromFutureOr(universe, s), sEnv, t, tEnv, false);
      }
      if (sKind === 7) {
        t1 = A._isSubtype(universe, type$.Null, sEnv, t, tEnv, false);
        return t1 && A._isSubtype(universe, s._primary, sEnv, t, tEnv, false);
      }
      if (tKind === 8) {
        if (A._isSubtype(universe, s, sEnv, t._primary, tEnv, false))
          return true;
        return A._isSubtype(universe, s, sEnv, A.Rti__getFutureFromFutureOr(universe, t), tEnv, false);
      }
      if (tKind === 7) {
        t1 = A._isSubtype(universe, s, sEnv, type$.Null, tEnv, false);
        return t1 || A._isSubtype(universe, s, sEnv, t._primary, tEnv, false);
      }
      if (leftTypeVariable)
        return false;
      t1 = sKind !== 12;
      if ((!t1 || sKind === 13) && t === type$.Function)
        return true;
      t2 = sKind === 11;
      if (t2 && t === type$.Record)
        return true;
      if (tKind === 13) {
        if (s === type$.JavaScriptFunction)
          return true;
        if (sKind !== 13)
          return false;
        sBounds = s._rest;
        tBounds = t._rest;
        sLength = sBounds.length;
        if (sLength !== tBounds.length)
          return false;
        sEnv = sEnv == null ? sBounds : sBounds.concat(sEnv);
        tEnv = tEnv == null ? tBounds : tBounds.concat(tEnv);
        for (i = 0; i < sLength; ++i) {
          sBound = sBounds[i];
          tBound = tBounds[i];
          if (!A._isSubtype(universe, sBound, sEnv, tBound, tEnv, false) || !A._isSubtype(universe, tBound, tEnv, sBound, sEnv, false))
            return false;
        }
        return A._isFunctionSubtype(universe, s._primary, sEnv, t._primary, tEnv, false);
      }
      if (tKind === 12) {
        if (s === type$.JavaScriptFunction)
          return true;
        if (t1)
          return false;
        return A._isFunctionSubtype(universe, s, sEnv, t, tEnv, false);
      }
      if (sKind === 9) {
        if (tKind !== 9)
          return false;
        return A._isInterfaceSubtype(universe, s, sEnv, t, tEnv, false);
      }
      if (t2 && tKind === 11)
        return A._isRecordSubtype(universe, s, sEnv, t, tEnv, false);
      return false;
    },
    _isFunctionSubtype(universe, s, sEnv, t, tEnv, isLegacy) {
      var sParameters, tParameters, sRequiredPositional, tRequiredPositional, sRequiredPositionalLength, tRequiredPositionalLength, requiredPositionalDelta, sOptionalPositional, tOptionalPositional, sOptionalPositionalLength, tOptionalPositionalLength, i, t1, sNamed, tNamed, sNamedLength, tNamedLength, sIndex, tIndex, tName, sName, sIsRequired;
      if (!A._isSubtype(universe, s._primary, sEnv, t._primary, tEnv, false))
        return false;
      sParameters = s._rest;
      tParameters = t._rest;
      sRequiredPositional = sParameters._requiredPositional;
      tRequiredPositional = tParameters._requiredPositional;
      sRequiredPositionalLength = sRequiredPositional.length;
      tRequiredPositionalLength = tRequiredPositional.length;
      if (sRequiredPositionalLength > tRequiredPositionalLength)
        return false;
      requiredPositionalDelta = tRequiredPositionalLength - sRequiredPositionalLength;
      sOptionalPositional = sParameters._optionalPositional;
      tOptionalPositional = tParameters._optionalPositional;
      sOptionalPositionalLength = sOptionalPositional.length;
      tOptionalPositionalLength = tOptionalPositional.length;
      if (sRequiredPositionalLength + sOptionalPositionalLength < tRequiredPositionalLength + tOptionalPositionalLength)
        return false;
      for (i = 0; i < sRequiredPositionalLength; ++i) {
        t1 = sRequiredPositional[i];
        if (!A._isSubtype(universe, tRequiredPositional[i], tEnv, t1, sEnv, false))
          return false;
      }
      for (i = 0; i < requiredPositionalDelta; ++i) {
        t1 = sOptionalPositional[i];
        if (!A._isSubtype(universe, tRequiredPositional[sRequiredPositionalLength + i], tEnv, t1, sEnv, false))
          return false;
      }
      for (i = 0; i < tOptionalPositionalLength; ++i) {
        t1 = sOptionalPositional[requiredPositionalDelta + i];
        if (!A._isSubtype(universe, tOptionalPositional[i], tEnv, t1, sEnv, false))
          return false;
      }
      sNamed = sParameters._named;
      tNamed = tParameters._named;
      sNamedLength = sNamed.length;
      tNamedLength = tNamed.length;
      for (sIndex = 0, tIndex = 0; tIndex < tNamedLength; tIndex += 3) {
        tName = tNamed[tIndex];
        for (; true;) {
          if (sIndex >= sNamedLength)
            return false;
          sName = sNamed[sIndex];
          sIndex += 3;
          if (tName < sName)
            return false;
          sIsRequired = sNamed[sIndex - 2];
          if (sName < tName) {
            if (sIsRequired)
              return false;
            continue;
          }
          t1 = tNamed[tIndex + 1];
          if (sIsRequired && !t1)
            return false;
          t1 = sNamed[sIndex - 1];
          if (!A._isSubtype(universe, tNamed[tIndex + 2], tEnv, t1, sEnv, false))
            return false;
          break;
        }
      }
      for (; sIndex < sNamedLength;) {
        if (sNamed[sIndex + 1])
          return false;
        sIndex += 3;
      }
      return true;
    },
    _isInterfaceSubtype(universe, s, sEnv, t, tEnv, isLegacy) {
      var rule, recipes, $length, supertypeArgs, i,
        sName = s._primary,
        tName = t._primary;
      for (; sName !== tName;) {
        rule = universe.tR[sName];
        if (rule == null)
          return false;
        if (typeof rule == "string") {
          sName = rule;
          continue;
        }
        recipes = rule[tName];
        if (recipes == null)
          return false;
        $length = recipes.length;
        supertypeArgs = $length > 0 ? new Array($length) : init.typeUniverse.sEA;
        for (i = 0; i < $length; ++i)
          supertypeArgs[i] = A._Universe_evalInEnvironment(universe, s, recipes[i]);
        return A._areArgumentsSubtypes(universe, supertypeArgs, null, sEnv, t._rest, tEnv, false);
      }
      return A._areArgumentsSubtypes(universe, s._rest, null, sEnv, t._rest, tEnv, false);
    },
    _areArgumentsSubtypes(universe, sArgs, sVariances, sEnv, tArgs, tEnv, isLegacy) {
      var i,
        $length = sArgs.length;
      for (i = 0; i < $length; ++i)
        if (!A._isSubtype(universe, sArgs[i], sEnv, tArgs[i], tEnv, false))
          return false;
      return true;
    },
    _isRecordSubtype(universe, s, sEnv, t, tEnv, isLegacy) {
      var i,
        sFields = s._rest,
        tFields = t._rest,
        sCount = sFields.length;
      if (sCount !== tFields.length)
        return false;
      if (s._primary !== t._primary)
        return false;
      for (i = 0; i < sCount; ++i)
        if (!A._isSubtype(universe, sFields[i], sEnv, tFields[i], tEnv, false))
          return false;
      return true;
    },
    isNullable(t) {
      var t1,
        kind = t._kind;
      if (!(t === type$.Null || t === type$.JSNull))
        if (!A.isSoundTopType(t))
          if (kind !== 7)
            if (!(kind === 6 && A.isNullable(t._primary)))
              t1 = kind === 8 && A.isNullable(t._primary);
            else
              t1 = true;
          else
            t1 = true;
        else
          t1 = true;
      else
        t1 = true;
      return t1;
    },
    isDefinitelyTopType(t) {
      var t1;
      if (!A.isSoundTopType(t))
        t1 = t === type$.legacy_Object;
      else
        t1 = true;
      return t1;
    },
    isSoundTopType(t) {
      var kind = t._kind;
      return kind === 2 || kind === 3 || kind === 4 || kind === 5 || t === type$.nullable_Object;
    },
    _Utils_objectAssign(o, other) {
      var i, key,
        keys = Object.keys(other),
        $length = keys.length;
      for (i = 0; i < $length; ++i) {
        key = keys[i];
        o[key] = other[key];
      }
    },
    _Utils_newArrayOrEmpty($length) {
      return $length > 0 ? new Array($length) : init.typeUniverse.sEA;
    },
    Rti: function Rti(t0, t1) {
      var _ = this;
      _._as = t0;
      _._is = t1;
      _._cachedRuntimeType = _._specializedTestResource = _._isSubtypeCache = _._precomputed1 = null;
      _._kind = 0;
      _._canonicalRecipe = _._bindCache = _._evalCache = _._rest = _._primary = null;
    },
    _FunctionParameters: function _FunctionParameters() {
      this._named = this._optionalPositional = this._requiredPositional = null;
    },
    _Type: function _Type(t0) {
      this._rti = t0;
    },
    _Error: function _Error() {
    },
    _TypeError: function _TypeError(t0) {
      this.__rti$_message = t0;
    },
    _AsyncRun__initializeScheduleImmediate() {
      var div, span, t1 = {};
      if (self.scheduleImmediate != null)
        return A.async__AsyncRun__scheduleImmediateJsOverride$closure();
      if (self.MutationObserver != null && self.document != null) {
        div = self.document.createElement("div");
        span = self.document.createElement("span");
        t1.storedCallback = null;
        new self.MutationObserver(A.convertDartClosureToJS(new A._AsyncRun__initializeScheduleImmediate_internalCallback(t1), 1)).observe(div, {childList: true});
        return new A._AsyncRun__initializeScheduleImmediate_closure(t1, div, span);
      } else if (self.setImmediate != null)
        return A.async__AsyncRun__scheduleImmediateWithSetImmediate$closure();
      return A.async__AsyncRun__scheduleImmediateWithTimer$closure();
    },
    _AsyncRun__scheduleImmediateJsOverride(callback) {
      self.scheduleImmediate(A.convertDartClosureToJS(new A._AsyncRun__scheduleImmediateJsOverride_internalCallback(callback), 0));
    },
    _AsyncRun__scheduleImmediateWithSetImmediate(callback) {
      self.setImmediate(A.convertDartClosureToJS(new A._AsyncRun__scheduleImmediateWithSetImmediate_internalCallback(callback), 0));
    },
    _AsyncRun__scheduleImmediateWithTimer(callback) {
      A.Timer__createTimer(B.Duration_0, callback);
    },
    Timer__createTimer(duration, callback) {
      var milliseconds = B.JSInt_methods._tdivFast$1(duration._duration, 1000);
      return A._TimerImpl$(milliseconds < 0 ? 0 : milliseconds, callback);
    },
    _TimerImpl$(milliseconds, callback) {
      var t1 = new A._TimerImpl(true);
      t1._TimerImpl$2(milliseconds, callback);
      return t1;
    },
    _TimerImpl$periodic(milliseconds, callback) {
      var t1 = new A._TimerImpl(false);
      t1._TimerImpl$periodic$2(milliseconds, callback);
      return t1;
    },
    _makeAsyncAwaitCompleter($T) {
      return new A._AsyncAwaitCompleter(new A._Future($.Zone__current, $T._eval$1("_Future<0>")), $T._eval$1("_AsyncAwaitCompleter<0>"));
    },
    _asyncStartSync(bodyFunction, completer) {
      bodyFunction.call$2(0, null);
      completer.isSync = true;
      return completer._future;
    },
    _asyncAwait(object, bodyFunction) {
      A._awaitOnObject(object, bodyFunction);
    },
    _asyncReturn(object, completer) {
      completer.complete$1(object);
    },
    _asyncRethrow(object, completer) {
      completer.completeError$2(A.unwrapException(object), A.getTraceFromException(object));
    },
    _awaitOnObject(object, bodyFunction) {
      var t1, future,
        thenCallback = new A._awaitOnObject_closure(bodyFunction),
        errorCallback = new A._awaitOnObject_closure0(bodyFunction);
      if (object instanceof A._Future)
        object._thenAwait$1$2(thenCallback, errorCallback, type$.dynamic);
      else {
        t1 = type$.dynamic;
        if (object instanceof A._Future)
          object.then$1$2$onError(0, thenCallback, errorCallback, t1);
        else {
          future = new A._Future($.Zone__current, type$._Future_dynamic);
          future._state = 8;
          future._resultOrListeners = object;
          future._thenAwait$1$2(thenCallback, errorCallback, t1);
        }
      }
    },
    _wrapJsFunctionForAsync($function) {
      var $protected = function(fn, ERROR) {
        return function(errorCode, result) {
          while (true) {
            try {
              fn(errorCode, result);
              break;
            } catch (error) {
              result = error;
              errorCode = ERROR;
            }
          }
        };
      }($function, 1);
      return $.Zone__current.registerBinaryCallback$3$1(new A._wrapJsFunctionForAsync_closure($protected), type$.void, type$.int, type$.dynamic);
    },
    _SyncStarIterator__terminatedBody(_1, _2, _3) {
      return 0;
    },
    AsyncError$(error, stackTrace) {
      var t1 = A.checkNotNullable(error, "error", type$.Object);
      return new A.AsyncError(t1, stackTrace == null ? A.AsyncError_defaultStackTrace(error) : stackTrace);
    },
    AsyncError_defaultStackTrace(error) {
      var stackTrace;
      if (type$.Error._is(error)) {
        stackTrace = error.get$stackTrace();
        if (stackTrace != null)
          return stackTrace;
      }
      return B._StringStackTrace_uwd;
    },
    Future_Future$value(value, $T) {
      var t1;
      $T._as(value);
      t1 = new A._Future($.Zone__current, $T._eval$1("_Future<0>"));
      t1._asyncComplete$1(value);
      return t1;
    },
    Future_Future$error(error, stackTrace, $T) {
      var t1, replacement;
      A.checkNotNullable(error, "error", type$.Object);
      t1 = $.Zone__current;
      if (t1 !== B.C__RootZone) {
        replacement = t1.errorCallback$2(error, stackTrace);
        if (replacement != null) {
          error = replacement.error;
          stackTrace = replacement.stackTrace;
        }
      }
      if (stackTrace == null)
        stackTrace = A.AsyncError_defaultStackTrace(error);
      t1 = new A._Future($.Zone__current, $T._eval$1("_Future<0>"));
      t1._asyncCompleteError$2(error, stackTrace);
      return t1;
    },
    Future_wait(futures, eagerError, $T) {
      var handleError, future, pos, e, st, t1, t2, exception, _box_0 = {}, cleanUp = null,
        _future = new A._Future($.Zone__current, $T._eval$1("_Future<List<0>>"));
      _box_0.values = null;
      _box_0.remaining = 0;
      _box_0.stackTrace = _box_0.error = null;
      handleError = new A.Future_wait_handleError(_box_0, cleanUp, eagerError, _future);
      try {
        for (t1 = J.get$iterator$ax(futures), t2 = type$.Null; t1.moveNext$0();) {
          future = t1.get$current(t1);
          pos = _box_0.remaining;
          J.then$1$2$onError$x(future, new A.Future_wait_closure(_box_0, pos, _future, $T, cleanUp, eagerError), handleError, t2);
          ++_box_0.remaining;
        }
        t1 = _box_0.remaining;
        if (t1 === 0) {
          t1 = _future;
          t1._completeWithValue$1(A._setArrayType([], $T._eval$1("JSArray<0>")));
          return t1;
        }
        _box_0.values = A.List_List$filled(t1, null, false, $T._eval$1("0?"));
      } catch (exception) {
        e = A.unwrapException(exception);
        st = A.getTraceFromException(exception);
        if (_box_0.remaining === 0 || eagerError)
          return A.Future_Future$error(e, st, $T._eval$1("List<0>"));
        else {
          _box_0.error = e;
          _box_0.stackTrace = st;
        }
      }
      return _future;
    },
    _Future$zoneValue(value, _zone, $T) {
      var t1 = new A._Future(_zone, $T._eval$1("_Future<0>"));
      t1._state = 8;
      t1._resultOrListeners = value;
      return t1;
    },
    _Future$value(value, $T) {
      var t1 = new A._Future($.Zone__current, $T._eval$1("_Future<0>"));
      t1._state = 8;
      t1._resultOrListeners = value;
      return t1;
    },
    _Future__chainCoreFutureSync(source, target) {
      var t1, listeners;
      for (; t1 = source._state, (t1 & 4) !== 0;)
        source = source._resultOrListeners;
      t1 |= target._state & 1;
      source._state = t1;
      if ((t1 & 24) !== 0) {
        listeners = target._removeListeners$0();
        target._cloneResult$1(source);
        A._Future__propagateToListeners(target, listeners);
      } else {
        listeners = target._resultOrListeners;
        target._setChained$1(source);
        source._prependListeners$1(listeners);
      }
    },
    _Future__chainCoreFutureAsync(source, target) {
      var t2, listeners, _box_0 = {},
        t1 = _box_0.source = source;
      for (; t2 = t1._state, (t2 & 4) !== 0;) {
        t1 = t1._resultOrListeners;
        _box_0.source = t1;
      }
      if ((t2 & 24) === 0) {
        listeners = target._resultOrListeners;
        target._setChained$1(t1);
        _box_0.source._prependListeners$1(listeners);
        return;
      }
      if ((t2 & 16) === 0 && target._resultOrListeners == null) {
        target._cloneResult$1(t1);
        return;
      }
      target._state ^= 2;
      target._zone.scheduleMicrotask$1(new A._Future__chainCoreFutureAsync_closure(_box_0, target));
    },
    _Future__propagateToListeners(source, listeners) {
      var _box_0, t2, t3, hasError, nextListener, nextListener0, sourceResult, t4, zone, oldZone, result, current, _box_1 = {},
        t1 = _box_1.source = source;
      for (; true;) {
        _box_0 = {};
        t2 = t1._state;
        t3 = (t2 & 16) === 0;
        hasError = !t3;
        if (listeners == null) {
          if (hasError && (t2 & 1) === 0) {
            t2 = t1._resultOrListeners;
            t1._zone.handleUncaughtError$2(t2.error, t2.stackTrace);
          }
          return;
        }
        _box_0.listener = listeners;
        nextListener = listeners._nextListener;
        for (t1 = listeners; nextListener != null; t1 = nextListener, nextListener = nextListener0) {
          t1._nextListener = null;
          A._Future__propagateToListeners(_box_1.source, t1);
          _box_0.listener = nextListener;
          nextListener0 = nextListener._nextListener;
        }
        t2 = _box_1.source;
        sourceResult = t2._resultOrListeners;
        _box_0.listenerHasError = hasError;
        _box_0.listenerValueOrError = sourceResult;
        if (t3) {
          t4 = t1.state;
          t4 = (t4 & 1) !== 0 || (t4 & 15) === 8;
        } else
          t4 = true;
        if (t4) {
          zone = t1.result._zone;
          if (hasError) {
            t1 = t2._zone;
            t1 = !(t1 === zone || t1.get$errorZone() === zone.get$errorZone());
          } else
            t1 = false;
          if (t1) {
            t1 = _box_1.source;
            t2 = t1._resultOrListeners;
            t1._zone.handleUncaughtError$2(t2.error, t2.stackTrace);
            return;
          }
          oldZone = $.Zone__current;
          if (oldZone !== zone)
            $.Zone__current = zone;
          else
            oldZone = null;
          t1 = _box_0.listener.state;
          if ((t1 & 15) === 8)
            new A._Future__propagateToListeners_handleWhenCompleteCallback(_box_0, _box_1, hasError).call$0();
          else if (t3) {
            if ((t1 & 1) !== 0)
              new A._Future__propagateToListeners_handleValueCallback(_box_0, sourceResult).call$0();
          } else if ((t1 & 2) !== 0)
            new A._Future__propagateToListeners_handleError(_box_1, _box_0).call$0();
          if (oldZone != null)
            $.Zone__current = oldZone;
          t1 = _box_0.listenerValueOrError;
          if (t1 instanceof A._Future) {
            t2 = _box_0.listener.$ti;
            t2 = t2._eval$1("Future<2>")._is(t1) || !t2._rest[1]._is(t1);
          } else
            t2 = false;
          if (t2) {
            result = _box_0.listener.result;
            if ((t1._state & 24) !== 0) {
              current = result._resultOrListeners;
              result._resultOrListeners = null;
              listeners = result._reverseListeners$1(current);
              result._state = t1._state & 30 | result._state & 1;
              result._resultOrListeners = t1._resultOrListeners;
              _box_1.source = t1;
              continue;
            } else
              A._Future__chainCoreFutureSync(t1, result);
            return;
          }
        }
        result = _box_0.listener.result;
        current = result._resultOrListeners;
        result._resultOrListeners = null;
        listeners = result._reverseListeners$1(current);
        t1 = _box_0.listenerHasError;
        t2 = _box_0.listenerValueOrError;
        if (!t1) {
          result._state = 8;
          result._resultOrListeners = t2;
        } else {
          result._state = result._state & 1 | 16;
          result._resultOrListeners = t2;
        }
        _box_1.source = result;
        t1 = result;
      }
    },
    _registerErrorHandler(errorHandler, zone) {
      if (type$.dynamic_Function_Object_StackTrace._is(errorHandler))
        return zone.registerBinaryCallback$3$1(errorHandler, type$.dynamic, type$.Object, type$.StackTrace);
      if (type$.dynamic_Function_Object._is(errorHandler))
        return zone.registerUnaryCallback$2$1(errorHandler, type$.dynamic, type$.Object);
      throw A.wrapException(A.ArgumentError$value(errorHandler, "onError", string$.Error_));
    },
    _microtaskLoop() {
      var entry, next;
      for (entry = $._nextCallback; entry != null; entry = $._nextCallback) {
        $._lastPriorityCallback = null;
        next = entry.next;
        $._nextCallback = next;
        if (next == null)
          $._lastCallback = null;
        entry.callback.call$0();
      }
    },
    _startMicrotaskLoop() {
      $._isInCallbackLoop = true;
      try {
        A._microtaskLoop();
      } finally {
        $._lastPriorityCallback = null;
        $._isInCallbackLoop = false;
        if ($._nextCallback != null)
          $.$get$_AsyncRun__scheduleImmediateClosure().call$1(A.async___startMicrotaskLoop$closure());
      }
    },
    _scheduleAsyncCallback(callback) {
      var newEntry = new A._AsyncCallbackEntry(callback),
        lastCallback = $._lastCallback;
      if (lastCallback == null) {
        $._nextCallback = $._lastCallback = newEntry;
        if (!$._isInCallbackLoop)
          $.$get$_AsyncRun__scheduleImmediateClosure().call$1(A.async___startMicrotaskLoop$closure());
      } else
        $._lastCallback = lastCallback.next = newEntry;
    },
    _schedulePriorityAsyncCallback(callback) {
      var entry, lastPriorityCallback, next,
        t1 = $._nextCallback;
      if (t1 == null) {
        A._scheduleAsyncCallback(callback);
        $._lastPriorityCallback = $._lastCallback;
        return;
      }
      entry = new A._AsyncCallbackEntry(callback);
      lastPriorityCallback = $._lastPriorityCallback;
      if (lastPriorityCallback == null) {
        entry.next = t1;
        $._nextCallback = $._lastPriorityCallback = entry;
      } else {
        next = lastPriorityCallback.next;
        entry.next = next;
        $._lastPriorityCallback = lastPriorityCallback.next = entry;
        if (next == null)
          $._lastCallback = entry;
      }
    },
    scheduleMicrotask(callback) {
      var t1, _null = null,
        currentZone = $.Zone__current;
      if (B.C__RootZone === currentZone) {
        A._rootScheduleMicrotask(_null, _null, B.C__RootZone, callback);
        return;
      }
      if (B.C__RootZone === currentZone.get$_scheduleMicrotask().zone)
        t1 = B.C__RootZone.get$errorZone() === currentZone.get$errorZone();
      else
        t1 = false;
      if (t1) {
        A._rootScheduleMicrotask(_null, _null, currentZone, currentZone.registerCallback$1$1(callback, type$.void));
        return;
      }
      t1 = $.Zone__current;
      t1.scheduleMicrotask$1(t1.bindCallbackGuarded$1(callback));
    },
    Stream_Stream$fromFuture(future, $T) {
      var _null = null,
        t1 = $T._eval$1("_SyncStreamController<0>"),
        controller = new A._SyncStreamController(_null, _null, _null, _null, t1);
      future.then$1$2$onError(0, new A.Stream_Stream$fromFuture_closure(controller, $T), new A.Stream_Stream$fromFuture_closure0(controller), type$.Null);
      return new A._ControllerStream(controller, t1._eval$1("_ControllerStream<1>"));
    },
    StreamIterator_StreamIterator(stream) {
      return new A._StreamIterator(A.checkNotNullable(stream, "stream", type$.Object));
    },
    StreamController_StreamController(onCancel, onListen, onPause, onResume, sync, $T) {
      return sync ? new A._SyncStreamController(onListen, onPause, onResume, onCancel, $T._eval$1("_SyncStreamController<0>")) : new A._AsyncStreamController(onListen, onPause, onResume, onCancel, $T._eval$1("_AsyncStreamController<0>"));
    },
    _runGuarded(notificationHandler) {
      var e, s, exception;
      if (notificationHandler == null)
        return;
      try {
        notificationHandler.call$0();
      } catch (exception) {
        e = A.unwrapException(exception);
        s = A.getTraceFromException(exception);
        $.Zone__current.handleUncaughtError$2(e, s);
      }
    },
    _ControllerSubscription$(_controller, onData, onError, onDone, cancelOnError, $T) {
      var t1 = $.Zone__current,
        t2 = cancelOnError ? 1 : 0,
        t3 = onError != null ? 32 : 0,
        t4 = A._BufferingStreamSubscription__registerDataHandler(t1, onData, $T),
        t5 = A._BufferingStreamSubscription__registerErrorHandler(t1, onError),
        t6 = onDone == null ? A.async___nullDoneHandler$closure() : onDone;
      return new A._ControllerSubscription(_controller, t4, t5, t1.registerCallback$1$1(t6, type$.void), t1, t2 | t3, $T._eval$1("_ControllerSubscription<0>"));
    },
    _AddStreamState_makeErrorHandler(controller) {
      return new A._AddStreamState_makeErrorHandler_closure(controller);
    },
    _BufferingStreamSubscription__registerDataHandler(zone, handleData, $T) {
      var t1 = handleData == null ? A.async___nullDataHandler$closure() : handleData;
      return zone.registerUnaryCallback$2$1(t1, type$.void, $T);
    },
    _BufferingStreamSubscription__registerErrorHandler(zone, handleError) {
      if (handleError == null)
        handleError = A.async___nullErrorHandler$closure();
      if (type$.void_Function_Object_StackTrace._is(handleError))
        return zone.registerBinaryCallback$3$1(handleError, type$.dynamic, type$.Object, type$.StackTrace);
      if (type$.void_Function_Object._is(handleError))
        return zone.registerUnaryCallback$2$1(handleError, type$.dynamic, type$.Object);
      throw A.wrapException(A.ArgumentError$("handleError callback must take either an Object (the error), or both an Object (the error) and a StackTrace.", null));
    },
    _nullDataHandler(value) {
    },
    _nullErrorHandler(error, stackTrace) {
      $.Zone__current.handleUncaughtError$2(error, stackTrace);
    },
    _nullDoneHandler() {
    },
    Timer_Timer(duration, callback) {
      var t1 = $.Zone__current;
      if (t1 === B.C__RootZone)
        return t1.createTimer$2(duration, callback);
      return t1.createTimer$2(duration, t1.bindCallbackGuarded$1(callback));
    },
    _rootHandleUncaughtError($self, $parent, zone, error, stackTrace) {
      A._rootHandleError(error, stackTrace);
    },
    _rootHandleError(error, stackTrace) {
      A._schedulePriorityAsyncCallback(new A._rootHandleError_closure(error, stackTrace));
    },
    _rootRun($self, $parent, zone, f) {
      var old,
        t1 = $.Zone__current;
      if (t1 === zone)
        return f.call$0();
      $.Zone__current = zone;
      old = t1;
      try {
        t1 = f.call$0();
        return t1;
      } finally {
        $.Zone__current = old;
      }
    },
    _rootRunUnary($self, $parent, zone, f, arg) {
      var old,
        t1 = $.Zone__current;
      if (t1 === zone)
        return f.call$1(arg);
      $.Zone__current = zone;
      old = t1;
      try {
        t1 = f.call$1(arg);
        return t1;
      } finally {
        $.Zone__current = old;
      }
    },
    _rootRunBinary($self, $parent, zone, f, arg1, arg2) {
      var old,
        t1 = $.Zone__current;
      if (t1 === zone)
        return f.call$2(arg1, arg2);
      $.Zone__current = zone;
      old = t1;
      try {
        t1 = f.call$2(arg1, arg2);
        return t1;
      } finally {
        $.Zone__current = old;
      }
    },
    _rootRegisterCallback($self, $parent, zone, f) {
      return f;
    },
    _rootRegisterUnaryCallback($self, $parent, zone, f) {
      return f;
    },
    _rootRegisterBinaryCallback($self, $parent, zone, f) {
      return f;
    },
    _rootErrorCallback($self, $parent, zone, error, stackTrace) {
      return null;
    },
    _rootScheduleMicrotask($self, $parent, zone, f) {
      var t1, t2;
      if (B.C__RootZone !== zone) {
        t1 = B.C__RootZone.get$errorZone();
        t2 = zone.get$errorZone();
        f = t1 !== t2 ? zone.bindCallbackGuarded$1(f) : zone.bindCallback$1$1(f, type$.void);
      }
      A._scheduleAsyncCallback(f);
    },
    _rootCreateTimer($self, $parent, zone, duration, callback) {
      return A.Timer__createTimer(duration, B.C__RootZone !== zone ? zone.bindCallback$1$1(callback, type$.void) : callback);
    },
    _rootCreatePeriodicTimer($self, $parent, zone, duration, callback) {
      var milliseconds;
      if (B.C__RootZone !== zone)
        callback = zone.bindUnaryCallback$2$1(callback, type$.void, type$.Timer);
      milliseconds = B.JSInt_methods._tdivFast$1(duration._duration, 1000);
      return A._TimerImpl$periodic(milliseconds < 0 ? 0 : milliseconds, callback);
    },
    _rootPrint($self, $parent, zone, line) {
      A.printString(line);
    },
    _printToZone(line) {
      $.Zone__current.print$1(line);
    },
    _rootFork($self, $parent, zone, specification, zoneValues) {
      var valueMap, t1, handleUncaughtError;
      $.printToZone = A.async___printToZone$closure();
      if (specification == null)
        specification = B._ZoneSpecification_48t;
      if (zoneValues == null)
        valueMap = zone.get$_async$_map();
      else {
        t1 = type$.nullable_Object;
        valueMap = A.HashMap_HashMap$from(zoneValues, t1, t1);
      }
      t1 = new A._CustomZone(zone.get$_run(), zone.get$_runUnary(), zone.get$_runBinary(), zone.get$_registerCallback(), zone.get$_registerUnaryCallback(), zone.get$_registerBinaryCallback(), zone.get$_errorCallback(), zone.get$_scheduleMicrotask(), zone.get$_createTimer(), zone.get$_createPeriodicTimer(), zone.get$_print(), zone.get$_fork(), zone.get$_handleUncaughtError(), zone, valueMap);
      handleUncaughtError = specification.handleUncaughtError;
      if (handleUncaughtError != null)
        t1._handleUncaughtError = new A._ZoneFunction(t1, handleUncaughtError);
      return t1;
    },
    runZoned(body, zoneValues, $R) {
      A.checkNotNullable(body, "body", $R._eval$1("0()"));
      return A._runZoned(body, zoneValues, null, $R);
    },
    _runZoned(body, zoneValues, specification, $R) {
      return $.Zone__current.fork$2$specification$zoneValues(specification, zoneValues).run$1$1(0, body, $R);
    },
    _AsyncRun__initializeScheduleImmediate_internalCallback: function _AsyncRun__initializeScheduleImmediate_internalCallback(t0) {
      this._box_0 = t0;
    },
    _AsyncRun__initializeScheduleImmediate_closure: function _AsyncRun__initializeScheduleImmediate_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.div = t1;
      this.span = t2;
    },
    _AsyncRun__scheduleImmediateJsOverride_internalCallback: function _AsyncRun__scheduleImmediateJsOverride_internalCallback(t0) {
      this.callback = t0;
    },
    _AsyncRun__scheduleImmediateWithSetImmediate_internalCallback: function _AsyncRun__scheduleImmediateWithSetImmediate_internalCallback(t0) {
      this.callback = t0;
    },
    _TimerImpl: function _TimerImpl(t0) {
      this._once = t0;
      this._handle = null;
      this._tick = 0;
    },
    _TimerImpl_internalCallback: function _TimerImpl_internalCallback(t0, t1) {
      this.$this = t0;
      this.callback = t1;
    },
    _TimerImpl$periodic_closure: function _TimerImpl$periodic_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.milliseconds = t1;
      _.start = t2;
      _.callback = t3;
    },
    _AsyncAwaitCompleter: function _AsyncAwaitCompleter(t0, t1) {
      this._future = t0;
      this.isSync = false;
      this.$ti = t1;
    },
    _awaitOnObject_closure: function _awaitOnObject_closure(t0) {
      this.bodyFunction = t0;
    },
    _awaitOnObject_closure0: function _awaitOnObject_closure0(t0) {
      this.bodyFunction = t0;
    },
    _wrapJsFunctionForAsync_closure: function _wrapJsFunctionForAsync_closure(t0) {
      this.$protected = t0;
    },
    _SyncStarIterator: function _SyncStarIterator(t0) {
      var _ = this;
      _._body = t0;
      _._suspendedBodies = _._nestedIterator = _._datum = _._async$_current = null;
    },
    _SyncStarIterable: function _SyncStarIterable(t0, t1) {
      this._outerHelper = t0;
      this.$ti = t1;
    },
    AsyncError: function AsyncError(t0, t1) {
      this.error = t0;
      this.stackTrace = t1;
    },
    Future_wait_handleError: function Future_wait_handleError(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.cleanUp = t1;
      _.eagerError = t2;
      _._future = t3;
    },
    Future_wait_closure: function Future_wait_closure(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.pos = t1;
      _._future = t2;
      _.T = t3;
      _.cleanUp = t4;
      _.eagerError = t5;
    },
    _Completer: function _Completer() {
    },
    _AsyncCompleter: function _AsyncCompleter(t0, t1) {
      this.future = t0;
      this.$ti = t1;
    },
    _SyncCompleter: function _SyncCompleter(t0, t1) {
      this.future = t0;
      this.$ti = t1;
    },
    _FutureListener: function _FutureListener(t0, t1, t2, t3, t4) {
      var _ = this;
      _._nextListener = null;
      _.result = t0;
      _.state = t1;
      _.callback = t2;
      _.errorCallback = t3;
      _.$ti = t4;
    },
    _Future: function _Future(t0, t1) {
      var _ = this;
      _._state = 0;
      _._zone = t0;
      _._resultOrListeners = null;
      _.$ti = t1;
    },
    _Future__addListener_closure: function _Future__addListener_closure(t0, t1) {
      this.$this = t0;
      this.listener = t1;
    },
    _Future__prependListeners_closure: function _Future__prependListeners_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _Future__chainForeignFuture_closure: function _Future__chainForeignFuture_closure(t0) {
      this.$this = t0;
    },
    _Future__chainForeignFuture_closure0: function _Future__chainForeignFuture_closure0(t0) {
      this.$this = t0;
    },
    _Future__chainForeignFuture_closure1: function _Future__chainForeignFuture_closure1(t0, t1, t2) {
      this.$this = t0;
      this.e = t1;
      this.s = t2;
    },
    _Future__chainCoreFutureAsync_closure: function _Future__chainCoreFutureAsync_closure(t0, t1) {
      this._box_0 = t0;
      this.target = t1;
    },
    _Future__asyncCompleteWithValue_closure: function _Future__asyncCompleteWithValue_closure(t0, t1) {
      this.$this = t0;
      this.value = t1;
    },
    _Future__asyncCompleteError_closure: function _Future__asyncCompleteError_closure(t0, t1, t2) {
      this.$this = t0;
      this.error = t1;
      this.stackTrace = t2;
    },
    _Future__propagateToListeners_handleWhenCompleteCallback: function _Future__propagateToListeners_handleWhenCompleteCallback(t0, t1, t2) {
      this._box_0 = t0;
      this._box_1 = t1;
      this.hasError = t2;
    },
    _Future__propagateToListeners_handleWhenCompleteCallback_closure: function _Future__propagateToListeners_handleWhenCompleteCallback_closure(t0) {
      this.originalSource = t0;
    },
    _Future__propagateToListeners_handleValueCallback: function _Future__propagateToListeners_handleValueCallback(t0, t1) {
      this._box_0 = t0;
      this.sourceResult = t1;
    },
    _Future__propagateToListeners_handleError: function _Future__propagateToListeners_handleError(t0, t1) {
      this._box_1 = t0;
      this._box_0 = t1;
    },
    _AsyncCallbackEntry: function _AsyncCallbackEntry(t0) {
      this.callback = t0;
      this.next = null;
    },
    Stream: function Stream() {
    },
    Stream_Stream$fromFuture_closure: function Stream_Stream$fromFuture_closure(t0, t1) {
      this.controller = t0;
      this.T = t1;
    },
    Stream_Stream$fromFuture_closure0: function Stream_Stream$fromFuture_closure0(t0) {
      this.controller = t0;
    },
    Stream_length_closure: function Stream_length_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    Stream_length_closure0: function Stream_length_closure0(t0, t1) {
      this._box_0 = t0;
      this.future = t1;
    },
    _StreamController: function _StreamController() {
    },
    _StreamController__subscribe_closure: function _StreamController__subscribe_closure(t0) {
      this.$this = t0;
    },
    _StreamController__recordCancel_complete: function _StreamController__recordCancel_complete(t0) {
      this.$this = t0;
    },
    _SyncStreamControllerDispatch: function _SyncStreamControllerDispatch() {
    },
    _AsyncStreamControllerDispatch: function _AsyncStreamControllerDispatch() {
    },
    _AsyncStreamController: function _AsyncStreamController(t0, t1, t2, t3, t4) {
      var _ = this;
      _._varData = null;
      _._state = 0;
      _._doneFuture = null;
      _.onListen = t0;
      _.onPause = t1;
      _.onResume = t2;
      _.onCancel = t3;
      _.$ti = t4;
    },
    _SyncStreamController: function _SyncStreamController(t0, t1, t2, t3, t4) {
      var _ = this;
      _._varData = null;
      _._state = 0;
      _._doneFuture = null;
      _.onListen = t0;
      _.onPause = t1;
      _.onResume = t2;
      _.onCancel = t3;
      _.$ti = t4;
    },
    _ControllerStream: function _ControllerStream(t0, t1) {
      this._controller = t0;
      this.$ti = t1;
    },
    _ControllerSubscription: function _ControllerSubscription(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._controller = t0;
      _._onData = t1;
      _._onError = t2;
      _._onDone = t3;
      _._zone = t4;
      _._state = t5;
      _._pending = _._cancelFuture = null;
      _.$ti = t6;
    },
    _AddStreamState: function _AddStreamState() {
    },
    _AddStreamState_makeErrorHandler_closure: function _AddStreamState_makeErrorHandler_closure(t0) {
      this.controller = t0;
    },
    _AddStreamState_cancel_closure: function _AddStreamState_cancel_closure(t0) {
      this.$this = t0;
    },
    _StreamControllerAddStreamState: function _StreamControllerAddStreamState(t0, t1, t2) {
      this._varData = t0;
      this.addStreamFuture = t1;
      this.addSubscription = t2;
    },
    _BufferingStreamSubscription: function _BufferingStreamSubscription() {
    },
    _BufferingStreamSubscription__sendError_sendError: function _BufferingStreamSubscription__sendError_sendError(t0, t1, t2) {
      this.$this = t0;
      this.error = t1;
      this.stackTrace = t2;
    },
    _BufferingStreamSubscription__sendDone_sendDone: function _BufferingStreamSubscription__sendDone_sendDone(t0) {
      this.$this = t0;
    },
    _StreamImpl: function _StreamImpl() {
    },
    _DelayedEvent: function _DelayedEvent() {
    },
    _DelayedData: function _DelayedData(t0) {
      this.value = t0;
      this.next = null;
    },
    _DelayedError: function _DelayedError(t0, t1) {
      this.error = t0;
      this.stackTrace = t1;
      this.next = null;
    },
    _DelayedDone: function _DelayedDone() {
    },
    _PendingEvents: function _PendingEvents() {
      this._state = 0;
      this.lastPendingEvent = this.firstPendingEvent = null;
    },
    _PendingEvents_schedule_closure: function _PendingEvents_schedule_closure(t0, t1) {
      this.$this = t0;
      this.dispatch = t1;
    },
    _StreamIterator: function _StreamIterator(t0) {
      this._subscription = null;
      this._stateData = t0;
      this._async$_hasValue = false;
    },
    _ForwardingStream: function _ForwardingStream() {
    },
    _ForwardingStreamSubscription: function _ForwardingStreamSubscription(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._stream = t0;
      _._subscription = null;
      _._onData = t1;
      _._onError = t2;
      _._onDone = t3;
      _._zone = t4;
      _._state = t5;
      _._pending = _._cancelFuture = null;
      _.$ti = t6;
    },
    _ExpandStream: function _ExpandStream(t0, t1, t2) {
      this._expand = t0;
      this._async$_source = t1;
      this.$ti = t2;
    },
    _ZoneFunction: function _ZoneFunction(t0, t1) {
      this.zone = t0;
      this.$function = t1;
    },
    _ZoneSpecification: function _ZoneSpecification(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12) {
      var _ = this;
      _.handleUncaughtError = t0;
      _.run = t1;
      _.runUnary = t2;
      _.runBinary = t3;
      _.registerCallback = t4;
      _.registerUnaryCallback = t5;
      _.registerBinaryCallback = t6;
      _.errorCallback = t7;
      _.scheduleMicrotask = t8;
      _.createTimer = t9;
      _.createPeriodicTimer = t10;
      _.print = t11;
      _.fork = t12;
    },
    _ZoneDelegate: function _ZoneDelegate(t0) {
      this._delegationTarget = t0;
    },
    _Zone: function _Zone() {
    },
    _CustomZone: function _CustomZone(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) {
      var _ = this;
      _._run = t0;
      _._runUnary = t1;
      _._runBinary = t2;
      _._registerCallback = t3;
      _._registerUnaryCallback = t4;
      _._registerBinaryCallback = t5;
      _._errorCallback = t6;
      _._scheduleMicrotask = t7;
      _._createTimer = t8;
      _._createPeriodicTimer = t9;
      _._print = t10;
      _._fork = t11;
      _._handleUncaughtError = t12;
      _._delegateCache = null;
      _.parent = t13;
      _._async$_map = t14;
    },
    _CustomZone_bindCallback_closure: function _CustomZone_bindCallback_closure(t0, t1, t2) {
      this.$this = t0;
      this.registered = t1;
      this.R = t2;
    },
    _CustomZone_bindUnaryCallback_closure: function _CustomZone_bindUnaryCallback_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.registered = t1;
      _.T = t2;
      _.R = t3;
    },
    _CustomZone_bindCallbackGuarded_closure: function _CustomZone_bindCallbackGuarded_closure(t0, t1) {
      this.$this = t0;
      this.registered = t1;
    },
    _rootHandleError_closure: function _rootHandleError_closure(t0, t1) {
      this.error = t0;
      this.stackTrace = t1;
    },
    _RootZone: function _RootZone() {
    },
    _RootZone_bindCallback_closure: function _RootZone_bindCallback_closure(t0, t1, t2) {
      this.$this = t0;
      this.f = t1;
      this.R = t2;
    },
    _RootZone_bindUnaryCallback_closure: function _RootZone_bindUnaryCallback_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.f = t1;
      _.T = t2;
      _.R = t3;
    },
    _RootZone_bindCallbackGuarded_closure: function _RootZone_bindCallbackGuarded_closure(t0, t1) {
      this.$this = t0;
      this.f = t1;
    },
    HashMap_HashMap($K, $V) {
      return new A._HashMap($K._eval$1("@<0>")._bind$1($V)._eval$1("_HashMap<1,2>"));
    },
    _HashMap__getTableEntry(table, key) {
      var entry = table[key];
      return entry === table ? null : entry;
    },
    _HashMap__setTableEntry(table, key, value) {
      if (value == null)
        table[key] = table;
      else
        table[key] = value;
    },
    _HashMap__newHashTable() {
      var table = Object.create(null);
      A._HashMap__setTableEntry(table, "<non-identifier-key>", table);
      delete table["<non-identifier-key>"];
      return table;
    },
    LinkedHashMap_LinkedHashMap(equals, hashCode, isValidKey, $K, $V) {
      if (isValidKey == null)
        if (hashCode == null) {
          if (equals == null)
            return new A.JsLinkedHashMap($K._eval$1("@<0>")._bind$1($V)._eval$1("JsLinkedHashMap<1,2>"));
          hashCode = A.collection___defaultHashCode$closure();
        } else {
          if (A.core__identityHashCode$closure() === hashCode && A.core__identical$closure() === equals)
            return new A.JsIdentityLinkedHashMap($K._eval$1("@<0>")._bind$1($V)._eval$1("JsIdentityLinkedHashMap<1,2>"));
          if (equals == null)
            equals = A.collection___defaultEquals$closure();
        }
      else {
        if (hashCode == null)
          hashCode = A.collection___defaultHashCode$closure();
        if (equals == null)
          equals = A.collection___defaultEquals$closure();
      }
      return A._LinkedCustomHashMap$(equals, hashCode, isValidKey, $K, $V);
    },
    LinkedHashMap_LinkedHashMap$_literal(keyValuePairs, $K, $V) {
      return A.fillLiteralMap(keyValuePairs, new A.JsLinkedHashMap($K._eval$1("@<0>")._bind$1($V)._eval$1("JsLinkedHashMap<1,2>")));
    },
    LinkedHashMap_LinkedHashMap$_empty($K, $V) {
      return new A.JsLinkedHashMap($K._eval$1("@<0>")._bind$1($V)._eval$1("JsLinkedHashMap<1,2>"));
    },
    _LinkedCustomHashMap$(_equals, _hashCode, validKey, $K, $V) {
      var t1 = validKey != null ? validKey : new A._LinkedCustomHashMap_closure($K);
      return new A._LinkedCustomHashMap(_equals, _hashCode, t1, $K._eval$1("@<0>")._bind$1($V)._eval$1("_LinkedCustomHashMap<1,2>"));
    },
    LinkedHashSet_LinkedHashSet($E) {
      return new A._LinkedHashSet($E._eval$1("_LinkedHashSet<0>"));
    },
    LinkedHashSet_LinkedHashSet$_empty($E) {
      return new A._LinkedHashSet($E._eval$1("_LinkedHashSet<0>"));
    },
    LinkedHashSet_LinkedHashSet$_literal(values, $E) {
      return A.fillLiteralSet(values, new A._LinkedHashSet($E._eval$1("_LinkedHashSet<0>")));
    },
    _LinkedHashSet__newHashTable() {
      var table = Object.create(null);
      table["<non-identifier-key>"] = table;
      delete table["<non-identifier-key>"];
      return table;
    },
    _LinkedHashSetIterator$(_set, _modifications, $E) {
      var t1 = new A._LinkedHashSetIterator(_set, _modifications, $E._eval$1("_LinkedHashSetIterator<0>"));
      t1._cell = _set._first;
      return t1;
    },
    UnmodifiableListView$(source, $E) {
      return new A.UnmodifiableListView(source, $E._eval$1("UnmodifiableListView<0>"));
    },
    _defaultEquals(a, b) {
      return J.$eq$(a, b);
    },
    _defaultHashCode(a) {
      return J.get$hashCode$(a);
    },
    HashMap_HashMap$from(other, $K, $V) {
      var result = A.HashMap_HashMap($K, $V);
      other.forEach$1(0, new A.HashMap_HashMap$from_closure(result, $K, $V));
      return result;
    },
    LinkedHashMap_LinkedHashMap$from(other, $K, $V) {
      var result = A.LinkedHashMap_LinkedHashMap(null, null, null, $K, $V);
      other.forEach$1(0, new A.LinkedHashMap_LinkedHashMap$from_closure(result, $K, $V));
      return result;
    },
    LinkedHashMap_LinkedHashMap$of(other, $K, $V) {
      var t1 = A.LinkedHashMap_LinkedHashMap(null, null, null, $K, $V);
      t1.addAll$1(0, other);
      return t1;
    },
    LinkedHashSet_LinkedHashSet$from(elements, $E) {
      var t1, _i,
        result = A.LinkedHashSet_LinkedHashSet($E);
      for (t1 = elements.length, _i = 0; _i < elements.length; elements.length === t1 || (0, A.throwConcurrentModificationError)(elements), ++_i)
        result.add$1(0, $E._as(elements[_i]));
      return result;
    },
    LinkedHashSet_LinkedHashSet$of(elements, $E) {
      var t1 = A.LinkedHashSet_LinkedHashSet($E);
      t1.addAll$1(0, elements);
      return t1;
    },
    ListBase__compareAny(a, b) {
      var t1 = type$.Comparable_dynamic;
      return J.compareTo$1$ns(t1._as(a), t1._as(b));
    },
    MapBase_mapToString(m) {
      var result, t1 = {};
      if (A.isToStringVisiting(m))
        return "{...}";
      result = new A.StringBuffer("");
      try {
        $.toStringVisiting.push(m);
        result._contents += "{";
        t1.first = true;
        m.forEach$1(0, new A.MapBase_mapToString_closure(t1, result));
        result._contents += "}";
      } finally {
        $.toStringVisiting.pop();
      }
      t1 = result._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    MapBase__fillMapWithIterables(map, keys, values) {
      var keyIterator = keys.get$iterator(keys),
        valueIterator = values.get$iterator(values),
        hasNextKey = keyIterator.moveNext$0(),
        hasNextValue = valueIterator.moveNext$0();
      while (true) {
        if (!(hasNextKey && hasNextValue))
          break;
        map.$indexSet(0, keyIterator.get$current(keyIterator), valueIterator.get$current(valueIterator));
        hasNextKey = keyIterator.moveNext$0();
        hasNextValue = valueIterator.moveNext$0();
      }
      if (hasNextKey || hasNextValue)
        throw A.wrapException(A.ArgumentError$("Iterables do not have same length.", null));
    },
    ListQueue$($E) {
      return new A.ListQueue(A.List_List$filled(A.ListQueue__calculateCapacity(null), null, false, $E._eval$1("0?")), $E._eval$1("ListQueue<0>"));
    },
    ListQueue__calculateCapacity(initialCapacity) {
      return 8;
    },
    ListQueue__nextPowerOf2(number) {
      var nextNumber;
      number = (number << 1 >>> 0) - 1;
      for (; true; number = nextNumber) {
        nextNumber = (number & number - 1) >>> 0;
        if (nextNumber === 0)
          return number;
      }
    },
    _ListQueueIterator$(queue, $E) {
      return new A._ListQueueIterator(queue, queue._tail, queue._modificationCount, queue._head, $E._eval$1("_ListQueueIterator<0>"));
    },
    _UnmodifiableSetMixin__throwUnmodifiable() {
      throw A.wrapException(A.UnsupportedError$("Cannot change an unmodifiable set"));
    },
    _HashMap: function _HashMap(t0) {
      var _ = this;
      _._collection$_length = 0;
      _._collection$_keys = _._collection$_rest = _._nums = _._strings = null;
      _.$ti = t0;
    },
    _HashMap_values_closure: function _HashMap_values_closure(t0) {
      this.$this = t0;
    },
    _HashMap_addAll_closure: function _HashMap_addAll_closure(t0) {
      this.$this = t0;
    },
    _IdentityHashMap: function _IdentityHashMap(t0) {
      var _ = this;
      _._collection$_length = 0;
      _._collection$_keys = _._collection$_rest = _._nums = _._strings = null;
      _.$ti = t0;
    },
    _HashMapKeyIterable: function _HashMapKeyIterable(t0, t1) {
      this._map = t0;
      this.$ti = t1;
    },
    _HashMapKeyIterator: function _HashMapKeyIterator(t0, t1, t2) {
      var _ = this;
      _._map = t0;
      _._collection$_keys = t1;
      _._offset = 0;
      _._collection$_current = null;
      _.$ti = t2;
    },
    _LinkedCustomHashMap: function _LinkedCustomHashMap(t0, t1, t2, t3) {
      var _ = this;
      _._equals = t0;
      _._hashCode = t1;
      _._validKey = t2;
      _.__js_helper$_length = 0;
      _.__js_helper$_last = _.__js_helper$_first = _.__js_helper$_rest = _.__js_helper$_nums = _.__js_helper$_strings = null;
      _.__js_helper$_modifications = 0;
      _.$ti = t3;
    },
    _LinkedCustomHashMap_closure: function _LinkedCustomHashMap_closure(t0) {
      this.K = t0;
    },
    _LinkedHashSet: function _LinkedHashSet(t0) {
      var _ = this;
      _._collection$_length = 0;
      _._last = _._first = _._collection$_rest = _._nums = _._strings = null;
      _._modifications = 0;
      _.$ti = t0;
    },
    _LinkedIdentityHashSet: function _LinkedIdentityHashSet(t0) {
      var _ = this;
      _._collection$_length = 0;
      _._last = _._first = _._collection$_rest = _._nums = _._strings = null;
      _._modifications = 0;
      _.$ti = t0;
    },
    _LinkedHashSetCell: function _LinkedHashSetCell(t0) {
      this._element = t0;
      this._previous = this._next = null;
    },
    _LinkedHashSetIterator: function _LinkedHashSetIterator(t0, t1, t2) {
      var _ = this;
      _._set = t0;
      _._modifications = t1;
      _._collection$_current = _._cell = null;
      _.$ti = t2;
    },
    UnmodifiableListView: function UnmodifiableListView(t0, t1) {
      this._collection$_source = t0;
      this.$ti = t1;
    },
    HashMap_HashMap$from_closure: function HashMap_HashMap$from_closure(t0, t1, t2) {
      this.result = t0;
      this.K = t1;
      this.V = t2;
    },
    LinkedHashMap_LinkedHashMap$from_closure: function LinkedHashMap_LinkedHashMap$from_closure(t0, t1, t2) {
      this.result = t0;
      this.K = t1;
      this.V = t2;
    },
    ListBase: function ListBase() {
    },
    MapBase: function MapBase() {
    },
    MapBase_addAll_closure: function MapBase_addAll_closure(t0) {
      this.$this = t0;
    },
    MapBase_entries_closure: function MapBase_entries_closure(t0) {
      this.$this = t0;
    },
    MapBase_mapToString_closure: function MapBase_mapToString_closure(t0, t1) {
      this._box_0 = t0;
      this.result = t1;
    },
    UnmodifiableMapBase: function UnmodifiableMapBase() {
    },
    _MapBaseValueIterable: function _MapBaseValueIterable(t0, t1) {
      this._map = t0;
      this.$ti = t1;
    },
    _MapBaseValueIterator: function _MapBaseValueIterator(t0, t1, t2) {
      var _ = this;
      _._collection$_keys = t0;
      _._map = t1;
      _._collection$_current = null;
      _.$ti = t2;
    },
    _UnmodifiableMapMixin: function _UnmodifiableMapMixin() {
    },
    MapView: function MapView() {
    },
    UnmodifiableMapView: function UnmodifiableMapView(t0, t1) {
      this._map = t0;
      this.$ti = t1;
    },
    ListQueue: function ListQueue(t0, t1) {
      var _ = this;
      _._table = t0;
      _._modificationCount = _._tail = _._head = 0;
      _.$ti = t1;
    },
    _ListQueueIterator: function _ListQueueIterator(t0, t1, t2, t3, t4) {
      var _ = this;
      _._queue = t0;
      _._collection$_end = t1;
      _._modificationCount = t2;
      _._collection$_position = t3;
      _._collection$_current = null;
      _.$ti = t4;
    },
    SetBase: function SetBase() {
    },
    _SetBase: function _SetBase() {
    },
    _UnmodifiableSetMixin: function _UnmodifiableSetMixin() {
    },
    UnmodifiableSetView: function UnmodifiableSetView(t0, t1) {
      this._collection$_source = t0;
      this.$ti = t1;
    },
    _UnmodifiableMapView_MapView__UnmodifiableMapMixin: function _UnmodifiableMapView_MapView__UnmodifiableMapMixin() {
    },
    _UnmodifiableSetView_SetBase__UnmodifiableSetMixin: function _UnmodifiableSetView_SetBase__UnmodifiableSetMixin() {
    },
    _parseJson(source, reviver) {
      var e, exception, t1, parsed = null;
      try {
        parsed = JSON.parse(source);
      } catch (exception) {
        e = A.unwrapException(exception);
        t1 = A.FormatException$(String(e), null, null);
        throw A.wrapException(t1);
      }
      t1 = A._convertJsonToDartLazy(parsed);
      return t1;
    },
    _convertJsonToDartLazy(object) {
      var i;
      if (object == null)
        return null;
      if (typeof object != "object")
        return object;
      if (!Array.isArray(object))
        return new A._JsonMap(object, Object.create(null));
      for (i = 0; i < object.length; ++i)
        object[i] = A._convertJsonToDartLazy(object[i]);
      return object;
    },
    _Utf8Decoder__makeNativeUint8List(codeUnits, start, end) {
      var bytes, t1, i, b,
        $length = end - start;
      if ($length <= 4096)
        bytes = $.$get$_Utf8Decoder__reusableBuffer();
      else
        bytes = new Uint8Array($length);
      for (t1 = J.getInterceptor$asx(codeUnits), i = 0; i < $length; ++i) {
        b = t1.$index(codeUnits, start + i);
        if ((b & 255) !== b)
          b = 255;
        bytes[i] = b;
      }
      return bytes;
    },
    _Utf8Decoder__convertInterceptedUint8List(allowMalformed, codeUnits, start, end) {
      var decoder = allowMalformed ? $.$get$_Utf8Decoder__decoderNonfatal() : $.$get$_Utf8Decoder__decoder();
      if (decoder == null)
        return null;
      if (0 === start && end === codeUnits.length)
        return A._Utf8Decoder__useTextDecoder(decoder, codeUnits);
      return A._Utf8Decoder__useTextDecoder(decoder, codeUnits.subarray(start, end));
    },
    _Utf8Decoder__useTextDecoder(decoder, codeUnits) {
      var t1, exception;
      try {
        t1 = decoder.decode(codeUnits);
        return t1;
      } catch (exception) {
      }
      return null;
    },
    Base64Codec__checkPadding(source, sourceIndex, sourceEnd, firstPadding, paddingCount, $length) {
      if (B.JSInt_methods.$mod($length, 4) !== 0)
        throw A.wrapException(A.FormatException$("Invalid base64 padding, padded length must be multiple of four, is " + $length, source, sourceEnd));
      if (firstPadding + paddingCount !== $length)
        throw A.wrapException(A.FormatException$("Invalid base64 padding, '=' not at the end", source, sourceIndex));
      if (paddingCount > 2)
        throw A.wrapException(A.FormatException$("Invalid base64 padding, more than two '=' characters", source, sourceIndex));
    },
    _Base64Encoder_encodeChunk(alphabet, bytes, start, end, isLast, output, outputIndex, state) {
      var t1, i, byteOr, byte, outputIndex0, outputIndex1,
        bits = state >>> 2,
        expectedChars = 3 - (state & 3);
      for (t1 = J.getInterceptor$asx(bytes), i = start, byteOr = 0; i < end; ++i) {
        byte = t1.$index(bytes, i);
        byteOr = (byteOr | byte) >>> 0;
        bits = (bits << 8 | byte) & 16777215;
        --expectedChars;
        if (expectedChars === 0) {
          outputIndex0 = outputIndex + 1;
          output[outputIndex] = alphabet.charCodeAt(bits >>> 18 & 63);
          outputIndex = outputIndex0 + 1;
          output[outputIndex0] = alphabet.charCodeAt(bits >>> 12 & 63);
          outputIndex0 = outputIndex + 1;
          output[outputIndex] = alphabet.charCodeAt(bits >>> 6 & 63);
          outputIndex = outputIndex0 + 1;
          output[outputIndex0] = alphabet.charCodeAt(bits & 63);
          bits = 0;
          expectedChars = 3;
        }
      }
      if (byteOr >= 0 && byteOr <= 255) {
        if (isLast && expectedChars < 3) {
          outputIndex0 = outputIndex + 1;
          outputIndex1 = outputIndex0 + 1;
          if (3 - expectedChars === 1) {
            output[outputIndex] = alphabet.charCodeAt(bits >>> 2 & 63);
            output[outputIndex0] = alphabet.charCodeAt(bits << 4 & 63);
            output[outputIndex1] = 61;
            output[outputIndex1 + 1] = 61;
          } else {
            output[outputIndex] = alphabet.charCodeAt(bits >>> 10 & 63);
            output[outputIndex0] = alphabet.charCodeAt(bits >>> 4 & 63);
            output[outputIndex1] = alphabet.charCodeAt(bits << 2 & 63);
            output[outputIndex1 + 1] = 61;
          }
          return 0;
        }
        return (bits << 2 | 3 - expectedChars) >>> 0;
      }
      for (i = start; i < end;) {
        byte = t1.$index(bytes, i);
        if (byte < 0 || byte > 255)
          break;
        ++i;
      }
      throw A.wrapException(A.ArgumentError$value(bytes, "Not a byte value at index " + i + ": 0x" + J.toRadixString$1$n(t1.$index(bytes, i), 16), null));
    },
    JsonUnsupportedObjectError$(unsupportedObject, cause, partialResult) {
      return new A.JsonUnsupportedObjectError(unsupportedObject, cause);
    },
    _defaultToEncodable(object) {
      return object.toJson$0();
    },
    _JsonStringStringifier$(_sink, _toEncodable) {
      return new A._JsonStringStringifier(_sink, [], A.convert___defaultToEncodable$closure());
    },
    _JsonStringStringifier_stringify(object, toEncodable, indent) {
      var t1,
        output = new A.StringBuffer(""),
        stringifier = A._JsonStringStringifier$(output, toEncodable);
      stringifier.writeObject$1(object);
      t1 = output._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _Utf8Decoder_errorDescription(state) {
      switch (state) {
        case 65:
          return "Missing extension byte";
        case 67:
          return "Unexpected extension byte";
        case 69:
          return "Invalid UTF-8 byte";
        case 71:
          return "Overlong encoding";
        case 73:
          return "Out of unicode range";
        case 75:
          return "Encoded surrogate";
        case 77:
          return "Unfinished UTF-8 octet sequence";
        default:
          return "";
      }
    },
    _JsonMap: function _JsonMap(t0, t1) {
      this._original = t0;
      this._processed = t1;
      this._data = null;
    },
    _JsonMap_values_closure: function _JsonMap_values_closure(t0) {
      this.$this = t0;
    },
    _JsonMap_addAll_closure: function _JsonMap_addAll_closure(t0) {
      this.$this = t0;
    },
    _JsonMapKeyIterable: function _JsonMapKeyIterable(t0) {
      this._convert$_parent = t0;
    },
    _Utf8Decoder__decoder_closure: function _Utf8Decoder__decoder_closure() {
    },
    _Utf8Decoder__decoderNonfatal_closure: function _Utf8Decoder__decoderNonfatal_closure() {
    },
    AsciiCodec: function AsciiCodec() {
    },
    _UnicodeSubsetEncoder: function _UnicodeSubsetEncoder() {
    },
    AsciiEncoder: function AsciiEncoder(t0) {
      this._subsetMask = t0;
    },
    Base64Codec: function Base64Codec() {
    },
    Base64Encoder: function Base64Encoder() {
    },
    _Base64Encoder: function _Base64Encoder(t0) {
      this._convert$_state = 0;
      this._alphabet = t0;
    },
    _Base64EncoderSink: function _Base64EncoderSink() {
    },
    _Utf8Base64EncoderSink: function _Utf8Base64EncoderSink(t0, t1) {
      this._sink = t0;
      this._encoder = t1;
    },
    ByteConversionSink: function ByteConversionSink() {
    },
    Codec: function Codec() {
    },
    Converter: function Converter() {
    },
    Encoding: function Encoding() {
    },
    JsonUnsupportedObjectError: function JsonUnsupportedObjectError(t0, t1) {
      this.unsupportedObject = t0;
      this.cause = t1;
    },
    JsonCyclicError: function JsonCyclicError(t0, t1) {
      this.unsupportedObject = t0;
      this.cause = t1;
    },
    JsonCodec: function JsonCodec() {
    },
    JsonEncoder: function JsonEncoder(t0) {
      this._toEncodable = t0;
    },
    JsonDecoder: function JsonDecoder(t0) {
      this._reviver = t0;
    },
    _JsonStringifier: function _JsonStringifier() {
    },
    _JsonStringifier_writeMap_closure: function _JsonStringifier_writeMap_closure(t0, t1) {
      this._box_0 = t0;
      this.keyValueList = t1;
    },
    _JsonStringStringifier: function _JsonStringStringifier(t0, t1, t2) {
      this._sink = t0;
      this._seen = t1;
      this._toEncodable = t2;
    },
    StringConversionSink: function StringConversionSink() {
    },
    _StringSinkConversionSink: function _StringSinkConversionSink(t0) {
      this._stringSink = t0;
    },
    _StringCallbackSink: function _StringCallbackSink(t0, t1) {
      this._convert$_callback = t0;
      this._stringSink = t1;
    },
    _Utf8StringSinkAdapter: function _Utf8StringSinkAdapter(t0, t1, t2) {
      this._decoder = t0;
      this._sink = t1;
      this._stringSink = t2;
    },
    Utf8Codec: function Utf8Codec() {
    },
    Utf8Encoder: function Utf8Encoder() {
    },
    _Utf8Encoder: function _Utf8Encoder(t0) {
      this._bufferIndex = 0;
      this._buffer = t0;
    },
    Utf8Decoder: function Utf8Decoder(t0) {
      this._allowMalformed = t0;
    },
    _Utf8Decoder: function _Utf8Decoder(t0) {
      this.allowMalformed = t0;
      this._convert$_state = 16;
      this._charOrIndex = 0;
    },
    identityHashCode(object) {
      return A.objectHashCode(object);
    },
    Function_apply($function, positionalArguments) {
      return A.Primitives_applyFunction($function, positionalArguments, null);
    },
    Expando$() {
      return new A.Expando(new WeakMap());
    },
    Expando__checkType(object) {
      if (A._isBool(object) || typeof object == "number" || typeof object == "string" || object instanceof A._Record)
        A.Expando__badExpandoKey(object);
    },
    Expando__badExpandoKey(object) {
      throw A.wrapException(A.ArgumentError$value(object, "object", "Expandos are not allowed on strings, numbers, bools, records or null"));
    },
    int_parse(source, radix) {
      var value = A.Primitives_parseInt(source, radix);
      if (value != null)
        return value;
      throw A.wrapException(A.FormatException$(source, null, null));
    },
    double_parse(source) {
      var value = A.Primitives_parseDouble(source);
      if (value != null)
        return value;
      throw A.wrapException(A.FormatException$("Invalid double", source, null));
    },
    Error__throw(error, stackTrace) {
      error = A.wrapException(error);
      error.stack = stackTrace.toString$0(0);
      throw error;
      throw A.wrapException("unreachable");
    },
    List_List$filled($length, fill, growable, $E) {
      var i,
        result = growable ? J.JSArray_JSArray$growable($length, $E) : J.JSArray_JSArray$fixed($length, $E);
      if ($length !== 0 && fill != null)
        for (i = 0; i < result.length; ++i)
          result[i] = fill;
      return result;
    },
    List_List$from(elements, growable, $E) {
      var t1,
        list = A._setArrayType([], $E._eval$1("JSArray<0>"));
      for (t1 = J.get$iterator$ax(elements); t1.moveNext$0();)
        list.push(t1.get$current(t1));
      if (growable)
        return list;
      return J.JSArray_markFixedList(list);
    },
    List_List$of(elements, growable, $E) {
      var t1;
      if (growable)
        return A.List_List$_of(elements, $E);
      t1 = J.JSArray_markFixedList(A.List_List$_of(elements, $E));
      return t1;
    },
    List_List$_of(elements, $E) {
      var list, t1;
      if (Array.isArray(elements))
        return A._setArrayType(elements.slice(0), $E._eval$1("JSArray<0>"));
      list = A._setArrayType([], $E._eval$1("JSArray<0>"));
      for (t1 = J.get$iterator$ax(elements); t1.moveNext$0();)
        list.push(t1.get$current(t1));
      return list;
    },
    List_List$unmodifiable(elements, $E) {
      return J.JSArray_markUnmodifiableList(A.List_List$from(elements, false, $E));
    },
    String_String$fromCharCodes(charCodes, start, end) {
      var t1, t2, maxLength, array, len;
      A.RangeError_checkNotNegative(start, "start");
      t1 = end == null;
      t2 = !t1;
      if (t2) {
        maxLength = end - start;
        if (maxLength < 0)
          throw A.wrapException(A.RangeError$range(end, start, null, "end", null));
        if (maxLength === 0)
          return "";
      }
      if (Array.isArray(charCodes)) {
        array = charCodes;
        len = array.length;
        if (t1)
          end = len;
        return A.Primitives_stringFromCharCodes(start > 0 || end < len ? array.slice(start, end) : array);
      }
      if (type$.NativeUint8List._is(charCodes))
        return A.String__stringFromUint8List(charCodes, start, end);
      if (t2)
        charCodes = J.take$1$ax(charCodes, end);
      if (start > 0)
        charCodes = J.skip$1$ax(charCodes, start);
      return A.Primitives_stringFromCharCodes(A.List_List$of(charCodes, true, type$.int));
    },
    String_String$fromCharCode(charCode) {
      return A.Primitives_stringFromCharCode(charCode);
    },
    String__stringFromUint8List(charCodes, start, endOrNull) {
      var len = charCodes.length;
      if (start >= len)
        return "";
      return A.Primitives_stringFromNativeUint8List(charCodes, start, endOrNull == null || endOrNull > len ? len : endOrNull);
    },
    RegExp_RegExp(source, multiLine) {
      return new A.JSSyntaxRegExp(source, A.JSSyntaxRegExp_makeNative(source, multiLine, true, false, false, false));
    },
    identical(a, b) {
      return a == null ? b == null : a === b;
    },
    StringBuffer__writeAll(string, objects, separator) {
      var iterator = J.get$iterator$ax(objects);
      if (!iterator.moveNext$0())
        return string;
      if (separator.length === 0) {
        do
          string += A.S(iterator.get$current(iterator));
        while (iterator.moveNext$0());
      } else {
        string += A.S(iterator.get$current(iterator));
        for (; iterator.moveNext$0();)
          string = string + separator + A.S(iterator.get$current(iterator));
      }
      return string;
    },
    NoSuchMethodError_NoSuchMethodError$withInvocation(receiver, invocation) {
      return new A.NoSuchMethodError(receiver, invocation.get$memberName(), invocation.get$positionalArguments(), invocation.get$namedArguments());
    },
    Uri_base() {
      var cachedUri, uri,
        current = A.Primitives_currentUri();
      if (current == null)
        throw A.wrapException(A.UnsupportedError$("'Uri.base' is not supported"));
      cachedUri = $.Uri__cachedBaseUri;
      if (cachedUri != null && current === $.Uri__cachedBaseString)
        return cachedUri;
      uri = A.Uri_parse(current);
      $.Uri__cachedBaseUri = uri;
      $.Uri__cachedBaseString = current;
      return uri;
    },
    _Uri__uriEncode(canonicalTable, text, encoding, spaceToPlus) {
      var t1, bytes, i, t2, byte,
        _s16_ = "0123456789ABCDEF";
      if (encoding === B.C_Utf8Codec) {
        t1 = $.$get$_Uri__needsNoEncoding();
        t1 = t1._nativeRegExp.test(text);
      } else
        t1 = false;
      if (t1)
        return text;
      bytes = B.C_Utf8Encoder.convert$1(text);
      for (t1 = bytes.length, i = 0, t2 = ""; i < t1; ++i) {
        byte = bytes[i];
        if (byte < 128 && (canonicalTable[byte >>> 4] & 1 << (byte & 15)) !== 0)
          t2 += A.Primitives_stringFromCharCode(byte);
        else
          t2 = spaceToPlus && byte === 32 ? t2 + "+" : t2 + "%" + _s16_[byte >>> 4 & 15] + _s16_[byte & 15];
      }
      return t2.charCodeAt(0) == 0 ? t2 : t2;
    },
    StackTrace_current() {
      return A.getTraceFromException(new Error());
    },
    DateTime__fourDigits(n) {
      var absN = Math.abs(n),
        sign = n < 0 ? "-" : "";
      if (absN >= 1000)
        return "" + n;
      if (absN >= 100)
        return sign + "0" + absN;
      if (absN >= 10)
        return sign + "00" + absN;
      return sign + "000" + absN;
    },
    DateTime__threeDigits(n) {
      if (n >= 100)
        return "" + n;
      if (n >= 10)
        return "0" + n;
      return "00" + n;
    },
    DateTime__twoDigits(n) {
      if (n >= 10)
        return "" + n;
      return "0" + n;
    },
    Duration$(milliseconds) {
      return new A.Duration(1000 * milliseconds);
    },
    Error_safeToString(object) {
      if (typeof object == "number" || A._isBool(object) || object == null)
        return J.toString$0$(object);
      if (typeof object == "string")
        return JSON.stringify(object);
      return A.Primitives_safeToString(object);
    },
    Error_throwWithStackTrace(error, stackTrace) {
      A.checkNotNullable(error, "error", type$.Object);
      A.checkNotNullable(stackTrace, "stackTrace", type$.StackTrace);
      A.Error__throw(error, stackTrace);
    },
    AssertionError$(message) {
      return new A.AssertionError(message);
    },
    ArgumentError$(message, $name) {
      return new A.ArgumentError(false, null, $name, message);
    },
    ArgumentError$value(value, $name, message) {
      return new A.ArgumentError(true, value, $name, message);
    },
    ArgumentError_checkNotNull(argument, $name) {
      return argument;
    },
    RangeError$(message) {
      var _null = null;
      return new A.RangeError(_null, _null, false, _null, _null, message);
    },
    RangeError$value(value, $name, message) {
      return new A.RangeError(null, null, true, value, $name, message == null ? "Value not in range" : message);
    },
    RangeError$range(invalidValue, minValue, maxValue, $name, message) {
      return new A.RangeError(minValue, maxValue, true, invalidValue, $name, message == null ? "Invalid value" : message);
    },
    RangeError_checkValueInInterval(value, minValue, maxValue, $name) {
      if (value < minValue || value > maxValue)
        throw A.wrapException(A.RangeError$range(value, minValue, maxValue, $name, null));
      return value;
    },
    RangeError_checkValidRange(start, end, $length) {
      if (0 > start || start > $length)
        throw A.wrapException(A.RangeError$range(start, 0, $length, "start", null));
      if (end != null) {
        if (start > end || end > $length)
          throw A.wrapException(A.RangeError$range(end, start, $length, "end", null));
        return end;
      }
      return $length;
    },
    RangeError_checkNotNegative(value, $name) {
      if (value < 0)
        throw A.wrapException(A.RangeError$range(value, 0, null, $name, null));
      return value;
    },
    IndexError$withLength(invalidValue, $length, indexable, message, $name) {
      return new A.IndexError($length, true, invalidValue, $name, "Index out of range");
    },
    IndexError_check(index, $length, indexable, message, $name) {
      if (0 > index || index >= $length)
        throw A.wrapException(A.IndexError$withLength(index, $length, indexable, message, $name == null ? "index" : $name));
      return index;
    },
    UnsupportedError$(message) {
      return new A.UnsupportedError(message);
    },
    UnimplementedError$(message) {
      return new A.UnimplementedError(message);
    },
    StateError$(message) {
      return new A.StateError(message);
    },
    ConcurrentModificationError$(modifiedObject) {
      return new A.ConcurrentModificationError(modifiedObject);
    },
    FormatException$(message, source, offset) {
      return new A.FormatException(message, source, offset);
    },
    Iterable_Iterable$generate(count, generator, $E) {
      if (count <= 0)
        return new A.EmptyIterable($E._eval$1("EmptyIterable<0>"));
      return new A._GeneratorIterable(count, generator, $E._eval$1("_GeneratorIterable<0>"));
    },
    Iterable_iterableToShortString(iterable, leftDelimiter, rightDelimiter) {
      var parts, t1;
      if (A.isToStringVisiting(iterable)) {
        if (leftDelimiter === "(" && rightDelimiter === ")")
          return "(...)";
        return leftDelimiter + "..." + rightDelimiter;
      }
      parts = A._setArrayType([], type$.JSArray_String);
      $.toStringVisiting.push(iterable);
      try {
        A._iterablePartsToStrings(iterable, parts);
      } finally {
        $.toStringVisiting.pop();
      }
      t1 = A.StringBuffer__writeAll(leftDelimiter, parts, ", ") + rightDelimiter;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    Iterable_iterableToFullString(iterable, leftDelimiter, rightDelimiter) {
      var buffer, t1;
      if (A.isToStringVisiting(iterable))
        return leftDelimiter + "..." + rightDelimiter;
      buffer = new A.StringBuffer(leftDelimiter);
      $.toStringVisiting.push(iterable);
      try {
        t1 = buffer;
        t1._contents = A.StringBuffer__writeAll(t1._contents, iterable, ", ");
      } finally {
        $.toStringVisiting.pop();
      }
      buffer._contents += rightDelimiter;
      t1 = buffer._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _iterablePartsToStrings(iterable, parts) {
      var next, ultimateString, penultimateString, penultimate, ultimate, ultimate0, elision,
        it = iterable.get$iterator(iterable),
        $length = 0, count = 0;
      while (true) {
        if (!($length < 80 || count < 3))
          break;
        if (!it.moveNext$0())
          return;
        next = A.S(it.get$current(it));
        parts.push(next);
        $length += next.length + 2;
        ++count;
      }
      if (!it.moveNext$0()) {
        if (count <= 5)
          return;
        ultimateString = parts.pop();
        penultimateString = parts.pop();
      } else {
        penultimate = it.get$current(it);
        ++count;
        if (!it.moveNext$0()) {
          if (count <= 4) {
            parts.push(A.S(penultimate));
            return;
          }
          ultimateString = A.S(penultimate);
          penultimateString = parts.pop();
          $length += ultimateString.length + 2;
        } else {
          ultimate = it.get$current(it);
          ++count;
          for (; it.moveNext$0(); penultimate = ultimate, ultimate = ultimate0) {
            ultimate0 = it.get$current(it);
            ++count;
            if (count > 100) {
              while (true) {
                if (!($length > 75 && count > 3))
                  break;
                $length -= parts.pop().length + 2;
                --count;
              }
              parts.push("...");
              return;
            }
          }
          penultimateString = A.S(penultimate);
          ultimateString = A.S(ultimate);
          $length += ultimateString.length + penultimateString.length + 4;
        }
      }
      if (count > parts.length + 2) {
        $length += 5;
        elision = "...";
      } else
        elision = null;
      while (true) {
        if (!($length > 80 && parts.length > 3))
          break;
        $length -= parts.pop().length + 2;
        if (elision == null) {
          $length += 5;
          elision = "...";
        }
      }
      if (elision != null)
        parts.push(elision);
      parts.push(penultimateString);
      parts.push(ultimateString);
    },
    Map_castFrom(source, $K, $V, K2, V2) {
      return new A.CastMap(source, $K._eval$1("@<0>")._bind$1($V)._bind$1(K2)._bind$1(V2)._eval$1("CastMap<1,2,3,4>"));
    },
    Object_hash(object1, object2, object3, object4) {
      var t1;
      if (B.C_SentinelValue === object3) {
        t1 = J.get$hashCode$(object1);
        object2 = J.get$hashCode$(object2);
        return A.SystemHash_finish(A.SystemHash_combine(A.SystemHash_combine($.$get$_hashSeed(), t1), object2));
      }
      if (B.C_SentinelValue === object4) {
        t1 = J.get$hashCode$(object1);
        object2 = J.get$hashCode$(object2);
        object3 = J.get$hashCode$(object3);
        return A.SystemHash_finish(A.SystemHash_combine(A.SystemHash_combine(A.SystemHash_combine($.$get$_hashSeed(), t1), object2), object3));
      }
      t1 = J.get$hashCode$(object1);
      object2 = J.get$hashCode$(object2);
      object3 = J.get$hashCode$(object3);
      object4 = J.get$hashCode$(object4);
      object4 = A.SystemHash_finish(A.SystemHash_combine(A.SystemHash_combine(A.SystemHash_combine(A.SystemHash_combine($.$get$_hashSeed(), t1), object2), object3), object4));
      return object4;
    },
    Object_hashAll(objects) {
      var t1, _i,
        hash = $.$get$_hashSeed();
      for (t1 = objects.length, _i = 0; _i < objects.length; objects.length === t1 || (0, A.throwConcurrentModificationError)(objects), ++_i)
        hash = A.SystemHash_combine(hash, J.get$hashCode$(objects[_i]));
      return A.SystemHash_finish(hash);
    },
    print(object) {
      var line = A.S(object),
        toZone = $.printToZone;
      if (toZone == null)
        A.printString(line);
      else
        toZone.call$1(line);
    },
    Set_Set$unmodifiable(elements, $E) {
      return new A.UnmodifiableSetView(A.LinkedHashSet_LinkedHashSet$of(elements, $E), $E._eval$1("UnmodifiableSetView<0>"));
    },
    Set_castFrom(source, newSet, $S, $T) {
      return new A.CastSet(source, newSet, $S._eval$1("@<0>")._bind$1($T)._eval$1("CastSet<1,2>"));
    },
    _combineSurrogatePair(start, end) {
      return 65536 + ((start & 1023) << 10) + (end & 1023);
    },
    Uri_Uri$dataFromString($content, encoding, mimeType) {
      var encodingName, t1,
        buffer = new A.StringBuffer(""),
        indices = A._setArrayType([-1], type$.JSArray_int);
      if (encoding == null)
        encodingName = null;
      else
        encodingName = "utf-8";
      if (encoding == null)
        encoding = B.C_AsciiCodec;
      A.UriData__writeUri(mimeType, encodingName, null, buffer, indices);
      indices.push(buffer._contents.length);
      buffer._contents += ",";
      A.UriData__uriEncodeBytes(B.List_42A, encoding.encode$1($content), buffer);
      t1 = buffer._contents;
      return new A.UriData(t1.charCodeAt(0) == 0 ? t1 : t1, indices, null).get$uri();
    },
    Uri_parse(uri) {
      var delta, indices, schemeEnd, hostStart, portStart, pathStart, queryStart, fragmentStart, isSimple, scheme, t1, t2, schemeAuth, queryStart0, pathStart0, userInfoStart, userInfo, host, portNumber, port, path, query, _null = null,
        end = uri.length;
      if (end >= 5) {
        delta = ((uri.charCodeAt(4) ^ 58) * 3 | uri.charCodeAt(0) ^ 100 | uri.charCodeAt(1) ^ 97 | uri.charCodeAt(2) ^ 116 | uri.charCodeAt(3) ^ 97) >>> 0;
        if (delta === 0)
          return A.UriData__parse(end < end ? B.JSString_methods.substring$2(uri, 0, end) : uri, 5, _null).get$uri();
        else if (delta === 32)
          return A.UriData__parse(B.JSString_methods.substring$2(uri, 5, end), 0, _null).get$uri();
      }
      indices = A.List_List$filled(8, 0, false, type$.int);
      indices[0] = 0;
      indices[1] = -1;
      indices[2] = -1;
      indices[7] = -1;
      indices[3] = 0;
      indices[4] = 0;
      indices[5] = end;
      indices[6] = end;
      if (A._scan(uri, 0, end, 0, indices) >= 14)
        indices[7] = end;
      schemeEnd = indices[1];
      if (schemeEnd >= 0)
        if (A._scan(uri, 0, schemeEnd, 20, indices) === 20)
          indices[7] = schemeEnd;
      hostStart = indices[2] + 1;
      portStart = indices[3];
      pathStart = indices[4];
      queryStart = indices[5];
      fragmentStart = indices[6];
      if (fragmentStart < queryStart)
        queryStart = fragmentStart;
      if (pathStart < hostStart)
        pathStart = queryStart;
      else if (pathStart <= schemeEnd)
        pathStart = schemeEnd + 1;
      if (portStart < hostStart)
        portStart = pathStart;
      isSimple = indices[7] < 0;
      if (isSimple)
        if (hostStart > schemeEnd + 3) {
          scheme = _null;
          isSimple = false;
        } else {
          t1 = portStart > 0;
          if (t1 && portStart + 1 === pathStart) {
            scheme = _null;
            isSimple = false;
          } else {
            if (!B.JSString_methods.startsWith$2(uri, "\\", pathStart))
              if (hostStart > 0)
                t2 = B.JSString_methods.startsWith$2(uri, "\\", hostStart - 1) || B.JSString_methods.startsWith$2(uri, "\\", hostStart - 2);
              else
                t2 = false;
            else
              t2 = true;
            if (t2) {
              scheme = _null;
              isSimple = false;
            } else {
              if (!(queryStart < end && queryStart === pathStart + 2 && B.JSString_methods.startsWith$2(uri, "..", pathStart)))
                t2 = queryStart > pathStart + 2 && B.JSString_methods.startsWith$2(uri, "/..", queryStart - 3);
              else
                t2 = true;
              if (t2)
                scheme = _null;
              else if (schemeEnd === 4)
                if (B.JSString_methods.startsWith$2(uri, "file", 0)) {
                  if (hostStart <= 0) {
                    if (!B.JSString_methods.startsWith$2(uri, "/", pathStart)) {
                      schemeAuth = "file:///";
                      delta = 3;
                    } else {
                      schemeAuth = "file://";
                      delta = 2;
                    }
                    uri = schemeAuth + B.JSString_methods.substring$2(uri, pathStart, end);
                    schemeEnd -= 0;
                    t1 = delta - 0;
                    queryStart += t1;
                    fragmentStart += t1;
                    end = uri.length;
                    hostStart = 7;
                    portStart = 7;
                    pathStart = 7;
                  } else if (pathStart === queryStart) {
                    ++fragmentStart;
                    queryStart0 = queryStart + 1;
                    uri = B.JSString_methods.replaceRange$3(uri, pathStart, queryStart, "/");
                    ++end;
                    queryStart = queryStart0;
                  }
                  scheme = "file";
                } else if (B.JSString_methods.startsWith$2(uri, "http", 0)) {
                  if (t1 && portStart + 3 === pathStart && B.JSString_methods.startsWith$2(uri, "80", portStart + 1)) {
                    fragmentStart -= 3;
                    pathStart0 = pathStart - 3;
                    queryStart -= 3;
                    uri = B.JSString_methods.replaceRange$3(uri, portStart, pathStart, "");
                    end -= 3;
                    pathStart = pathStart0;
                  }
                  scheme = "http";
                } else
                  scheme = _null;
              else if (schemeEnd === 5 && B.JSString_methods.startsWith$2(uri, "https", 0)) {
                if (t1 && portStart + 4 === pathStart && B.JSString_methods.startsWith$2(uri, "443", portStart + 1)) {
                  fragmentStart -= 4;
                  pathStart0 = pathStart - 4;
                  queryStart -= 4;
                  uri = B.JSString_methods.replaceRange$3(uri, portStart, pathStart, "");
                  end -= 3;
                  pathStart = pathStart0;
                }
                scheme = "https";
              } else
                scheme = _null;
              isSimple = !t2;
            }
          }
        }
      else
        scheme = _null;
      if (isSimple) {
        if (end < uri.length) {
          uri = B.JSString_methods.substring$2(uri, 0, end);
          schemeEnd -= 0;
          hostStart -= 0;
          portStart -= 0;
          pathStart -= 0;
          queryStart -= 0;
          fragmentStart -= 0;
        }
        return new A._SimpleUri(uri, schemeEnd, hostStart, portStart, pathStart, queryStart, fragmentStart, scheme);
      }
      if (scheme == null)
        if (schemeEnd > 0)
          scheme = A._Uri__makeScheme(uri, 0, schemeEnd);
        else {
          if (schemeEnd === 0)
            A._Uri__fail(uri, 0, "Invalid empty scheme");
          scheme = "";
        }
      if (hostStart > 0) {
        userInfoStart = schemeEnd + 3;
        userInfo = userInfoStart < hostStart ? A._Uri__makeUserInfo(uri, userInfoStart, hostStart - 1) : "";
        host = A._Uri__makeHost(uri, hostStart, portStart, false);
        t1 = portStart + 1;
        if (t1 < pathStart) {
          portNumber = A.Primitives_parseInt(B.JSString_methods.substring$2(uri, t1, pathStart), _null);
          port = A._Uri__makePort(portNumber == null ? A.throwExpression(A.FormatException$("Invalid port", uri, t1)) : portNumber, scheme);
        } else
          port = _null;
      } else {
        port = _null;
        host = port;
        userInfo = "";
      }
      path = A._Uri__makePath(uri, pathStart, queryStart, _null, scheme, host != null);
      query = queryStart < fragmentStart ? A._Uri__makeQuery(uri, queryStart + 1, fragmentStart, _null) : _null;
      return A._Uri$_internal(scheme, userInfo, host, port, path, query, fragmentStart < end ? A._Uri__makeFragment(uri, fragmentStart + 1, end) : _null);
    },
    Uri_decodeComponent(encodedComponent) {
      return A._Uri__uriDecode(encodedComponent, 0, encodedComponent.length, B.C_Utf8Codec, false);
    },
    Uri__parseIPv4Address(host, start, end) {
      var i, partStart, partIndex, char, part, partIndex0,
        _s43_ = "IPv4 address should contain exactly 4 parts",
        _s37_ = "each part must be in the range 0..255",
        error = new A.Uri__parseIPv4Address_error(host),
        result = new Uint8Array(4);
      for (i = start, partStart = i, partIndex = 0; i < end; ++i) {
        char = host.charCodeAt(i);
        if (char !== 46) {
          if ((char ^ 48) > 9)
            error.call$2("invalid character", i);
        } else {
          if (partIndex === 3)
            error.call$2(_s43_, i);
          part = A.int_parse(B.JSString_methods.substring$2(host, partStart, i), null);
          if (part > 255)
            error.call$2(_s37_, partStart);
          partIndex0 = partIndex + 1;
          result[partIndex] = part;
          partStart = i + 1;
          partIndex = partIndex0;
        }
      }
      if (partIndex !== 3)
        error.call$2(_s43_, end);
      part = A.int_parse(B.JSString_methods.substring$2(host, partStart, end), null);
      if (part > 255)
        error.call$2(_s37_, partStart);
      result[partIndex] = part;
      return result;
    },
    Uri_parseIPv6Address(host, start, end) {
      var parts, i, partStart, wildcardSeen, seenDot, char, atEnd, t1, last, bytes, wildCardLength, index, value, j, _null = null,
        error = new A.Uri_parseIPv6Address_error(host),
        parseHex = new A.Uri_parseIPv6Address_parseHex(error, host);
      if (host.length < 2)
        error.call$2("address is too short", _null);
      parts = A._setArrayType([], type$.JSArray_int);
      for (i = start, partStart = i, wildcardSeen = false, seenDot = false; i < end; ++i) {
        char = host.charCodeAt(i);
        if (char === 58) {
          if (i === start) {
            ++i;
            if (host.charCodeAt(i) !== 58)
              error.call$2("invalid start colon.", i);
            partStart = i;
          }
          if (i === partStart) {
            if (wildcardSeen)
              error.call$2("only one wildcard `::` is allowed", i);
            parts.push(-1);
            wildcardSeen = true;
          } else
            parts.push(parseHex.call$2(partStart, i));
          partStart = i + 1;
        } else if (char === 46)
          seenDot = true;
      }
      if (parts.length === 0)
        error.call$2("too few parts", _null);
      atEnd = partStart === end;
      t1 = B.JSArray_methods.get$last(parts);
      if (atEnd && t1 !== -1)
        error.call$2("expected a part after last `:`", end);
      if (!atEnd)
        if (!seenDot)
          parts.push(parseHex.call$2(partStart, end));
        else {
          last = A.Uri__parseIPv4Address(host, partStart, end);
          parts.push((last[0] << 8 | last[1]) >>> 0);
          parts.push((last[2] << 8 | last[3]) >>> 0);
        }
      if (wildcardSeen) {
        if (parts.length > 7)
          error.call$2("an address with a wildcard must have less than 7 parts", _null);
      } else if (parts.length !== 8)
        error.call$2("an address without a wildcard must contain exactly 8 parts", _null);
      bytes = new Uint8Array(16);
      for (t1 = parts.length, wildCardLength = 9 - t1, i = 0, index = 0; i < t1; ++i) {
        value = parts[i];
        if (value === -1)
          for (j = 0; j < wildCardLength; ++j) {
            bytes[index] = 0;
            bytes[index + 1] = 0;
            index += 2;
          }
        else {
          bytes[index] = B.JSInt_methods._shrOtherPositive$1(value, 8);
          bytes[index + 1] = value & 255;
          index += 2;
        }
      }
      return bytes;
    },
    _Uri$_internal(scheme, _userInfo, _host, _port, path, _query, _fragment) {
      return new A._Uri(scheme, _userInfo, _host, _port, path, _query, _fragment);
    },
    _Uri__Uri(host, path, pathSegments, scheme) {
      var userInfo, query, fragment, port, isFile, t1, hasAuthority, t2, _null = null;
      scheme = scheme == null ? "" : A._Uri__makeScheme(scheme, 0, scheme.length);
      userInfo = A._Uri__makeUserInfo(_null, 0, 0);
      host = A._Uri__makeHost(host, 0, host == null ? 0 : host.length, false);
      query = A._Uri__makeQuery(_null, 0, 0, _null);
      fragment = A._Uri__makeFragment(_null, 0, 0);
      port = A._Uri__makePort(_null, scheme);
      isFile = scheme === "file";
      if (host == null)
        t1 = userInfo.length !== 0 || port != null || isFile;
      else
        t1 = false;
      if (t1)
        host = "";
      t1 = host == null;
      hasAuthority = !t1;
      path = A._Uri__makePath(path, 0, path == null ? 0 : path.length, pathSegments, scheme, hasAuthority);
      t2 = scheme.length === 0;
      if (t2 && t1 && !B.JSString_methods.startsWith$1(path, "/"))
        path = A._Uri__normalizeRelativePath(path, !t2 || hasAuthority);
      else
        path = A._Uri__removeDotSegments(path);
      return A._Uri$_internal(scheme, userInfo, t1 && B.JSString_methods.startsWith$1(path, "//") ? "" : host, port, path, query, fragment);
    },
    _Uri__defaultPort(scheme) {
      if (scheme === "http")
        return 80;
      if (scheme === "https")
        return 443;
      return 0;
    },
    _Uri__fail(uri, index, message) {
      throw A.wrapException(A.FormatException$(message, uri, index));
    },
    _Uri__Uri$file(path, windows) {
      return windows ? A._Uri__makeWindowsFileUrl(path, false) : A._Uri__makeFileUri(path, false);
    },
    _Uri__checkNonWindowsPathReservedCharacters(segments, argumentError) {
      var t1, _i, segment, t2, t3;
      for (t1 = segments.length, _i = 0; _i < t1; ++_i) {
        segment = segments[_i];
        t2 = J.getInterceptor$asx(segment);
        t3 = t2.get$length(segment);
        if (0 > t3)
          A.throwExpression(A.RangeError$range(0, 0, t2.get$length(segment), null, null));
        if (A.stringContainsUnchecked(segment, "/", 0)) {
          t1 = A.UnsupportedError$("Illegal path character " + A.S(segment));
          throw A.wrapException(t1);
        }
      }
    },
    _Uri__checkWindowsPathReservedCharacters(segments, argumentError, firstSegment) {
      var t1, t2, t3, t4;
      for (t1 = A.SubListIterable$(segments, firstSegment, null, A._arrayInstanceType(segments)._precomputed1), t2 = t1.$ti, t1 = new A.ListIterator(t1, t1.get$length(0), t2._eval$1("ListIterator<ListIterable.E>")), t2 = t2._eval$1("ListIterable.E"); t1.moveNext$0();) {
        t3 = t1.__internal$_current;
        if (t3 == null)
          t3 = t2._as(t3);
        t4 = A.RegExp_RegExp('["*/:<>?\\\\|]', false);
        if (A.stringContainsUnchecked(t3, t4, 0))
          if (argumentError)
            throw A.wrapException(A.ArgumentError$("Illegal character in path", null));
          else
            throw A.wrapException(A.UnsupportedError$("Illegal character in path: " + t3));
      }
    },
    _Uri__checkWindowsDriveLetter(charCode, argumentError) {
      var t1,
        _s21_ = "Illegal drive letter ";
      if (!(65 <= charCode && charCode <= 90))
        t1 = 97 <= charCode && charCode <= 122;
      else
        t1 = true;
      if (t1)
        return;
      if (argumentError)
        throw A.wrapException(A.ArgumentError$(_s21_ + A.String_String$fromCharCode(charCode), null));
      else
        throw A.wrapException(A.UnsupportedError$(_s21_ + A.String_String$fromCharCode(charCode)));
    },
    _Uri__makeFileUri(path, slashTerminated) {
      var _null = null,
        segments = A._setArrayType(path.split("/"), type$.JSArray_String);
      if (B.JSString_methods.startsWith$1(path, "/"))
        return A._Uri__Uri(_null, _null, segments, "file");
      else
        return A._Uri__Uri(_null, _null, segments, _null);
    },
    _Uri__makeWindowsFileUrl(path, slashTerminated) {
      var t1, pathSegments, pathStart, hostPart, _s1_ = "\\", _null = null, _s4_ = "file";
      if (B.JSString_methods.startsWith$1(path, "\\\\?\\"))
        if (B.JSString_methods.startsWith$2(path, "UNC\\", 4))
          path = B.JSString_methods.replaceRange$3(path, 0, 7, _s1_);
        else {
          path = B.JSString_methods.substring$1(path, 4);
          if (path.length < 3 || path.charCodeAt(1) !== 58 || path.charCodeAt(2) !== 92)
            throw A.wrapException(A.ArgumentError$value(path, "path", "Windows paths with \\\\?\\ prefix must be absolute"));
        }
      else
        path = A.stringReplaceAllUnchecked(path, "/", _s1_);
      t1 = path.length;
      if (t1 > 1 && path.charCodeAt(1) === 58) {
        A._Uri__checkWindowsDriveLetter(path.charCodeAt(0), true);
        if (t1 === 2 || path.charCodeAt(2) !== 92)
          throw A.wrapException(A.ArgumentError$value(path, "path", "Windows paths with drive letter must be absolute"));
        pathSegments = A._setArrayType(path.split(_s1_), type$.JSArray_String);
        A._Uri__checkWindowsPathReservedCharacters(pathSegments, true, 1);
        return A._Uri__Uri(_null, _null, pathSegments, _s4_);
      }
      if (B.JSString_methods.startsWith$1(path, _s1_))
        if (B.JSString_methods.startsWith$2(path, _s1_, 1)) {
          pathStart = B.JSString_methods.indexOf$2(path, _s1_, 2);
          t1 = pathStart < 0;
          hostPart = t1 ? B.JSString_methods.substring$1(path, 2) : B.JSString_methods.substring$2(path, 2, pathStart);
          pathSegments = A._setArrayType((t1 ? "" : B.JSString_methods.substring$1(path, pathStart + 1)).split(_s1_), type$.JSArray_String);
          A._Uri__checkWindowsPathReservedCharacters(pathSegments, true, 0);
          return A._Uri__Uri(hostPart, _null, pathSegments, _s4_);
        } else {
          pathSegments = A._setArrayType(path.split(_s1_), type$.JSArray_String);
          A._Uri__checkWindowsPathReservedCharacters(pathSegments, true, 0);
          return A._Uri__Uri(_null, _null, pathSegments, _s4_);
        }
      else {
        pathSegments = A._setArrayType(path.split(_s1_), type$.JSArray_String);
        A._Uri__checkWindowsPathReservedCharacters(pathSegments, true, 0);
        return A._Uri__Uri(_null, _null, pathSegments, _null);
      }
    },
    _Uri__makePort(port, scheme) {
      if (port != null && port === A._Uri__defaultPort(scheme))
        return null;
      return port;
    },
    _Uri__makeHost(host, start, end, strictIPv6) {
      var t1, t2, index, zoneIDstart, zoneID, i;
      if (host == null)
        return null;
      if (start === end)
        return "";
      if (host.charCodeAt(start) === 91) {
        t1 = end - 1;
        if (host.charCodeAt(t1) !== 93)
          A._Uri__fail(host, start, "Missing end `]` to match `[` in host");
        t2 = start + 1;
        index = A._Uri__checkZoneID(host, t2, t1);
        if (index < t1) {
          zoneIDstart = index + 1;
          zoneID = A._Uri__normalizeZoneID(host, B.JSString_methods.startsWith$2(host, "25", zoneIDstart) ? index + 3 : zoneIDstart, t1, "%25");
        } else
          zoneID = "";
        A.Uri_parseIPv6Address(host, t2, index);
        return B.JSString_methods.substring$2(host, start, index).toLowerCase() + zoneID + "]";
      }
      for (i = start; i < end; ++i)
        if (host.charCodeAt(i) === 58) {
          index = B.JSString_methods.indexOf$2(host, "%", start);
          index = index >= start && index < end ? index : end;
          if (index < end) {
            zoneIDstart = index + 1;
            zoneID = A._Uri__normalizeZoneID(host, B.JSString_methods.startsWith$2(host, "25", zoneIDstart) ? index + 3 : zoneIDstart, end, "%25");
          } else
            zoneID = "";
          A.Uri_parseIPv6Address(host, start, index);
          return "[" + B.JSString_methods.substring$2(host, start, index) + zoneID + "]";
        }
      return A._Uri__normalizeRegName(host, start, end);
    },
    _Uri__checkZoneID(host, start, end) {
      var index = B.JSString_methods.indexOf$2(host, "%", start);
      return index >= start && index < end ? index : end;
    },
    _Uri__normalizeZoneID(host, start, end, prefix) {
      var index, sectionStart, isNormalized, char, replacement, t1, t2, tail, sourceLength, slice,
        buffer = prefix !== "" ? new A.StringBuffer(prefix) : null;
      for (index = start, sectionStart = index, isNormalized = true; index < end;) {
        char = host.charCodeAt(index);
        if (char === 37) {
          replacement = A._Uri__normalizeEscape(host, index, true);
          t1 = replacement == null;
          if (t1 && isNormalized) {
            index += 3;
            continue;
          }
          if (buffer == null)
            buffer = new A.StringBuffer("");
          t2 = buffer._contents += B.JSString_methods.substring$2(host, sectionStart, index);
          if (t1)
            replacement = B.JSString_methods.substring$2(host, index, index + 3);
          else if (replacement === "%")
            A._Uri__fail(host, index, "ZoneID should not contain % anymore");
          buffer._contents = t2 + replacement;
          index += 3;
          sectionStart = index;
          isNormalized = true;
        } else if (char < 127 && (B.List_piR[char >>> 4] & 1 << (char & 15)) !== 0) {
          if (isNormalized && 65 <= char && 90 >= char) {
            if (buffer == null)
              buffer = new A.StringBuffer("");
            if (sectionStart < index) {
              buffer._contents += B.JSString_methods.substring$2(host, sectionStart, index);
              sectionStart = index;
            }
            isNormalized = false;
          }
          ++index;
        } else {
          if ((char & 64512) === 55296 && index + 1 < end) {
            tail = host.charCodeAt(index + 1);
            if ((tail & 64512) === 56320) {
              char = (char & 1023) << 10 | tail & 1023 | 65536;
              sourceLength = 2;
            } else
              sourceLength = 1;
          } else
            sourceLength = 1;
          slice = B.JSString_methods.substring$2(host, sectionStart, index);
          if (buffer == null) {
            buffer = new A.StringBuffer("");
            t1 = buffer;
          } else
            t1 = buffer;
          t1._contents += slice;
          t2 = A._Uri__escapeChar(char);
          t1._contents += t2;
          index += sourceLength;
          sectionStart = index;
        }
      }
      if (buffer == null)
        return B.JSString_methods.substring$2(host, start, end);
      if (sectionStart < end) {
        slice = B.JSString_methods.substring$2(host, sectionStart, end);
        buffer._contents += slice;
      }
      t1 = buffer._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _Uri__normalizeRegName(host, start, end) {
      var index, sectionStart, buffer, isNormalized, char, replacement, t1, slice, t2, sourceLength, tail;
      for (index = start, sectionStart = index, buffer = null, isNormalized = true; index < end;) {
        char = host.charCodeAt(index);
        if (char === 37) {
          replacement = A._Uri__normalizeEscape(host, index, true);
          t1 = replacement == null;
          if (t1 && isNormalized) {
            index += 3;
            continue;
          }
          if (buffer == null)
            buffer = new A.StringBuffer("");
          slice = B.JSString_methods.substring$2(host, sectionStart, index);
          if (!isNormalized)
            slice = slice.toLowerCase();
          t2 = buffer._contents += slice;
          if (t1) {
            replacement = B.JSString_methods.substring$2(host, index, index + 3);
            sourceLength = 3;
          } else if (replacement === "%") {
            replacement = "%25";
            sourceLength = 1;
          } else
            sourceLength = 3;
          buffer._contents = t2 + replacement;
          index += sourceLength;
          sectionStart = index;
          isNormalized = true;
        } else if (char < 127 && (B.List_4AN[char >>> 4] & 1 << (char & 15)) !== 0) {
          if (isNormalized && 65 <= char && 90 >= char) {
            if (buffer == null)
              buffer = new A.StringBuffer("");
            if (sectionStart < index) {
              buffer._contents += B.JSString_methods.substring$2(host, sectionStart, index);
              sectionStart = index;
            }
            isNormalized = false;
          }
          ++index;
        } else if (char <= 93 && (B.List_VOY[char >>> 4] & 1 << (char & 15)) !== 0)
          A._Uri__fail(host, index, "Invalid character");
        else {
          if ((char & 64512) === 55296 && index + 1 < end) {
            tail = host.charCodeAt(index + 1);
            if ((tail & 64512) === 56320) {
              char = (char & 1023) << 10 | tail & 1023 | 65536;
              sourceLength = 2;
            } else
              sourceLength = 1;
          } else
            sourceLength = 1;
          slice = B.JSString_methods.substring$2(host, sectionStart, index);
          if (!isNormalized)
            slice = slice.toLowerCase();
          if (buffer == null) {
            buffer = new A.StringBuffer("");
            t1 = buffer;
          } else
            t1 = buffer;
          t1._contents += slice;
          t2 = A._Uri__escapeChar(char);
          t1._contents += t2;
          index += sourceLength;
          sectionStart = index;
        }
      }
      if (buffer == null)
        return B.JSString_methods.substring$2(host, start, end);
      if (sectionStart < end) {
        slice = B.JSString_methods.substring$2(host, sectionStart, end);
        if (!isNormalized)
          slice = slice.toLowerCase();
        buffer._contents += slice;
      }
      t1 = buffer._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _Uri__makeScheme(scheme, start, end) {
      var i, containsUpperCase, codeUnit;
      if (start === end)
        return "";
      if (!A._Uri__isAlphabeticCharacter(scheme.charCodeAt(start)))
        A._Uri__fail(scheme, start, "Scheme not starting with alphabetic character");
      for (i = start, containsUpperCase = false; i < end; ++i) {
        codeUnit = scheme.charCodeAt(i);
        if (!(codeUnit < 128 && (B.List_GVy[codeUnit >>> 4] & 1 << (codeUnit & 15)) !== 0))
          A._Uri__fail(scheme, i, "Illegal scheme character");
        if (65 <= codeUnit && codeUnit <= 90)
          containsUpperCase = true;
      }
      scheme = B.JSString_methods.substring$2(scheme, start, end);
      return A._Uri__canonicalizeScheme(containsUpperCase ? scheme.toLowerCase() : scheme);
    },
    _Uri__canonicalizeScheme(scheme) {
      if (scheme === "http")
        return "http";
      if (scheme === "file")
        return "file";
      if (scheme === "https")
        return "https";
      if (scheme === "package")
        return "package";
      return scheme;
    },
    _Uri__makeUserInfo(userInfo, start, end) {
      if (userInfo == null)
        return "";
      return A._Uri__normalizeOrSubstring(userInfo, start, end, B.List_2jN, false, false);
    },
    _Uri__makePath(path, start, end, pathSegments, scheme, hasAuthority) {
      var result,
        isFile = scheme === "file",
        ensureLeadingSlash = isFile || hasAuthority;
      if (path == null) {
        if (pathSegments == null)
          return isFile ? "/" : "";
        result = new A.MappedListIterable(pathSegments, new A._Uri__makePath_closure(), A._arrayInstanceType(pathSegments)._eval$1("MappedListIterable<1,String>")).join$1(0, "/");
      } else if (pathSegments != null)
        throw A.wrapException(A.ArgumentError$("Both path and pathSegments specified", null));
      else
        result = A._Uri__normalizeOrSubstring(path, start, end, B.List_M2I, true, true);
      if (result.length === 0) {
        if (isFile)
          return "/";
      } else if (ensureLeadingSlash && !B.JSString_methods.startsWith$1(result, "/"))
        result = "/" + result;
      return A._Uri__normalizePath(result, scheme, hasAuthority);
    },
    _Uri__normalizePath(path, scheme, hasAuthority) {
      var t1 = scheme.length === 0;
      if (t1 && !hasAuthority && !B.JSString_methods.startsWith$1(path, "/") && !B.JSString_methods.startsWith$1(path, "\\"))
        return A._Uri__normalizeRelativePath(path, !t1 || hasAuthority);
      return A._Uri__removeDotSegments(path);
    },
    _Uri__makeQuery(query, start, end, queryParameters) {
      if (query != null)
        return A._Uri__normalizeOrSubstring(query, start, end, B.List_42A, true, false);
      return null;
    },
    _Uri__makeFragment(fragment, start, end) {
      if (fragment == null)
        return null;
      return A._Uri__normalizeOrSubstring(fragment, start, end, B.List_42A, true, false);
    },
    _Uri__normalizeEscape(source, index, lowerCase) {
      var firstDigit, secondDigit, firstDigitValue, secondDigitValue, value,
        t1 = index + 2;
      if (t1 >= source.length)
        return "%";
      firstDigit = source.charCodeAt(index + 1);
      secondDigit = source.charCodeAt(t1);
      firstDigitValue = A.hexDigitValue(firstDigit);
      secondDigitValue = A.hexDigitValue(secondDigit);
      if (firstDigitValue < 0 || secondDigitValue < 0)
        return "%";
      value = firstDigitValue * 16 + secondDigitValue;
      if (value < 127 && (B.List_piR[B.JSInt_methods._shrOtherPositive$1(value, 4)] & 1 << (value & 15)) !== 0)
        return A.Primitives_stringFromCharCode(lowerCase && 65 <= value && 90 >= value ? (value | 32) >>> 0 : value);
      if (firstDigit >= 97 || secondDigit >= 97)
        return B.JSString_methods.substring$2(source, index, index + 3).toUpperCase();
      return null;
    },
    _Uri__escapeChar(char) {
      var codeUnits, flag, encodedBytes, index, byte,
        _s16_ = "0123456789ABCDEF";
      if (char < 128) {
        codeUnits = new Uint8Array(3);
        codeUnits[0] = 37;
        codeUnits[1] = _s16_.charCodeAt(char >>> 4);
        codeUnits[2] = _s16_.charCodeAt(char & 15);
      } else {
        if (char > 2047)
          if (char > 65535) {
            flag = 240;
            encodedBytes = 4;
          } else {
            flag = 224;
            encodedBytes = 3;
          }
        else {
          flag = 192;
          encodedBytes = 2;
        }
        codeUnits = new Uint8Array(3 * encodedBytes);
        for (index = 0; --encodedBytes, encodedBytes >= 0; flag = 128) {
          byte = B.JSInt_methods._shrReceiverPositive$1(char, 6 * encodedBytes) & 63 | flag;
          codeUnits[index] = 37;
          codeUnits[index + 1] = _s16_.charCodeAt(byte >>> 4);
          codeUnits[index + 2] = _s16_.charCodeAt(byte & 15);
          index += 3;
        }
      }
      return A.String_String$fromCharCodes(codeUnits, 0, null);
    },
    _Uri__normalizeOrSubstring(component, start, end, charTable, escapeDelimiters, replaceBackslash) {
      var t1 = A._Uri__normalize(component, start, end, charTable, escapeDelimiters, replaceBackslash);
      return t1 == null ? B.JSString_methods.substring$2(component, start, end) : t1;
    },
    _Uri__normalize(component, start, end, charTable, escapeDelimiters, replaceBackslash) {
      var t1, index, sectionStart, buffer, char, replacement, sourceLength, t2, tail, t3, _null = null;
      for (t1 = !escapeDelimiters, index = start, sectionStart = index, buffer = _null; index < end;) {
        char = component.charCodeAt(index);
        if (char < 127 && (charTable[char >>> 4] & 1 << (char & 15)) !== 0)
          ++index;
        else {
          if (char === 37) {
            replacement = A._Uri__normalizeEscape(component, index, false);
            if (replacement == null) {
              index += 3;
              continue;
            }
            if ("%" === replacement) {
              replacement = "%25";
              sourceLength = 1;
            } else
              sourceLength = 3;
          } else if (char === 92 && replaceBackslash) {
            replacement = "/";
            sourceLength = 1;
          } else if (t1 && char <= 93 && (B.List_VOY[char >>> 4] & 1 << (char & 15)) !== 0) {
            A._Uri__fail(component, index, "Invalid character");
            sourceLength = _null;
            replacement = sourceLength;
          } else {
            if ((char & 64512) === 55296) {
              t2 = index + 1;
              if (t2 < end) {
                tail = component.charCodeAt(t2);
                if ((tail & 64512) === 56320) {
                  char = (char & 1023) << 10 | tail & 1023 | 65536;
                  sourceLength = 2;
                } else
                  sourceLength = 1;
              } else
                sourceLength = 1;
            } else
              sourceLength = 1;
            replacement = A._Uri__escapeChar(char);
          }
          if (buffer == null) {
            buffer = new A.StringBuffer("");
            t2 = buffer;
          } else
            t2 = buffer;
          t3 = t2._contents += B.JSString_methods.substring$2(component, sectionStart, index);
          t2._contents = t3 + A.S(replacement);
          index += sourceLength;
          sectionStart = index;
        }
      }
      if (buffer == null)
        return _null;
      if (sectionStart < end) {
        t1 = B.JSString_methods.substring$2(component, sectionStart, end);
        buffer._contents += t1;
      }
      t1 = buffer._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _Uri__mayContainDotSegments(path) {
      if (B.JSString_methods.startsWith$1(path, "."))
        return true;
      return B.JSString_methods.indexOf$1(path, "/.") !== -1;
    },
    _Uri__removeDotSegments(path) {
      var output, t1, t2, appendSlash, _i, segment;
      if (!A._Uri__mayContainDotSegments(path))
        return path;
      output = A._setArrayType([], type$.JSArray_String);
      for (t1 = path.split("/"), t2 = t1.length, appendSlash = false, _i = 0; _i < t2; ++_i) {
        segment = t1[_i];
        if (J.$eq$(segment, "..")) {
          if (output.length !== 0) {
            output.pop();
            if (output.length === 0)
              output.push("");
          }
          appendSlash = true;
        } else {
          appendSlash = "." === segment;
          if (!appendSlash)
            output.push(segment);
        }
      }
      if (appendSlash)
        output.push("");
      return B.JSArray_methods.join$1(output, "/");
    },
    _Uri__normalizeRelativePath(path, allowScheme) {
      var output, t1, t2, appendSlash, _i, segment;
      if (!A._Uri__mayContainDotSegments(path))
        return !allowScheme ? A._Uri__escapeScheme(path) : path;
      output = A._setArrayType([], type$.JSArray_String);
      for (t1 = path.split("/"), t2 = t1.length, appendSlash = false, _i = 0; _i < t2; ++_i) {
        segment = t1[_i];
        if (".." === segment) {
          appendSlash = output.length !== 0 && B.JSArray_methods.get$last(output) !== "..";
          if (appendSlash)
            output.pop();
          else
            output.push("..");
        } else {
          appendSlash = "." === segment;
          if (!appendSlash)
            output.push(segment);
        }
      }
      t1 = output.length;
      if (t1 !== 0)
        t1 = t1 === 1 && output[0].length === 0;
      else
        t1 = true;
      if (t1)
        return "./";
      if (appendSlash || B.JSArray_methods.get$last(output) === "..")
        output.push("");
      if (!allowScheme)
        output[0] = A._Uri__escapeScheme(output[0]);
      return B.JSArray_methods.join$1(output, "/");
    },
    _Uri__escapeScheme(path) {
      var i, char,
        t1 = path.length;
      if (t1 >= 2 && A._Uri__isAlphabeticCharacter(path.charCodeAt(0)))
        for (i = 1; i < t1; ++i) {
          char = path.charCodeAt(i);
          if (char === 58)
            return B.JSString_methods.substring$2(path, 0, i) + "%3A" + B.JSString_methods.substring$1(path, i + 1);
          if (char > 127 || (B.List_GVy[char >>> 4] & 1 << (char & 15)) === 0)
            break;
        }
      return path;
    },
    _Uri__packageNameEnd(uri, path) {
      if (uri.isScheme$1("package") && uri._host == null)
        return A._skipPackageNameChars(path, 0, path.length);
      return -1;
    },
    _Uri__toWindowsFilePath(uri) {
      var t2, host,
        segments = uri.get$pathSegments(),
        t1 = segments.length,
        hasDriveLetter = t1 > 0 && J.get$length$asx(segments[0]) === 2 && J.codeUnitAt$1$s(segments[0], 1) === 58;
      if (hasDriveLetter) {
        A._Uri__checkWindowsDriveLetter(J.codeUnitAt$1$s(segments[0], 0), false);
        A._Uri__checkWindowsPathReservedCharacters(segments, false, 1);
      } else
        A._Uri__checkWindowsPathReservedCharacters(segments, false, 0);
      t2 = uri.get$hasAbsolutePath() && !hasDriveLetter ? "" + "\\" : "";
      if (uri.get$hasAuthority()) {
        host = uri.get$host();
        if (host.length !== 0)
          t2 = t2 + "\\" + host + "\\";
      }
      t2 = A.StringBuffer__writeAll(t2, segments, "\\");
      t1 = hasDriveLetter && t1 === 1 ? t2 + "\\" : t2;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _Uri__hexCharPairToByte(s, pos) {
      var byte, i, charCode;
      for (byte = 0, i = 0; i < 2; ++i) {
        charCode = s.charCodeAt(pos + i);
        if (48 <= charCode && charCode <= 57)
          byte = byte * 16 + charCode - 48;
        else {
          charCode |= 32;
          if (97 <= charCode && charCode <= 102)
            byte = byte * 16 + charCode - 87;
          else
            throw A.wrapException(A.ArgumentError$("Invalid URL encoding", null));
        }
      }
      return byte;
    },
    _Uri__uriDecode(text, start, end, encoding, plusToSpace) {
      var simple, codeUnit, t1, bytes,
        i = start;
      while (true) {
        if (!(i < end)) {
          simple = true;
          break;
        }
        codeUnit = text.charCodeAt(i);
        if (codeUnit <= 127)
          t1 = codeUnit === 37;
        else
          t1 = true;
        if (t1) {
          simple = false;
          break;
        }
        ++i;
      }
      if (simple)
        if (B.C_Utf8Codec === encoding)
          return B.JSString_methods.substring$2(text, start, end);
        else
          bytes = new A.CodeUnits(B.JSString_methods.substring$2(text, start, end));
      else {
        bytes = A._setArrayType([], type$.JSArray_int);
        for (t1 = text.length, i = start; i < end; ++i) {
          codeUnit = text.charCodeAt(i);
          if (codeUnit > 127)
            throw A.wrapException(A.ArgumentError$("Illegal percent encoding in URI", null));
          if (codeUnit === 37) {
            if (i + 3 > t1)
              throw A.wrapException(A.ArgumentError$("Truncated URI", null));
            bytes.push(A._Uri__hexCharPairToByte(text, i + 1));
            i += 2;
          } else
            bytes.push(codeUnit);
        }
      }
      return B.Utf8Decoder_false.convert$1(bytes);
    },
    _Uri__isAlphabeticCharacter(codeUnit) {
      var lowerCase = codeUnit | 32;
      return 97 <= lowerCase && lowerCase <= 122;
    },
    UriData__writeUri(mimeType, charsetName, parameters, buffer, indices) {
      var t1, slashIndex;
      if (mimeType != null)
        t1 = 10 === mimeType.length && A._caseInsensitiveCompareStart("text/plain", mimeType, 0) >= 0;
      else
        t1 = true;
      if (t1)
        mimeType = "";
      if (mimeType.length === 0 || mimeType === "application/octet-stream")
        t1 = buffer._contents += mimeType;
      else {
        slashIndex = A.UriData__validateMimeType(mimeType);
        if (slashIndex < 0)
          throw A.wrapException(A.ArgumentError$value(mimeType, "mimeType", "Invalid MIME type"));
        t1 = A._Uri__uriEncode(B.List_oyU, B.JSString_methods.substring$2(mimeType, 0, slashIndex), B.C_Utf8Codec, false);
        t1 = buffer._contents += t1;
        buffer._contents = t1 + "/";
        t1 = A._Uri__uriEncode(B.List_oyU, B.JSString_methods.substring$1(mimeType, slashIndex + 1), B.C_Utf8Codec, false);
        t1 = buffer._contents += t1;
      }
      if (charsetName != null) {
        indices.push(t1.length);
        indices.push(buffer._contents.length + 8);
        buffer._contents += ";charset=";
        t1 = A._Uri__uriEncode(B.List_oyU, charsetName, B.C_Utf8Codec, false);
        buffer._contents += t1;
      }
    },
    UriData__validateMimeType(mimeType) {
      var t1, slashIndex, i;
      for (t1 = mimeType.length, slashIndex = -1, i = 0; i < t1; ++i) {
        if (mimeType.charCodeAt(i) !== 47)
          continue;
        if (slashIndex < 0) {
          slashIndex = i;
          continue;
        }
        return -1;
      }
      return slashIndex;
    },
    UriData__parse(text, start, sourceUri) {
      var t1, i, slashIndex, char, equalsIndex, lastSeparator, t2, data,
        _s17_ = "Invalid MIME type",
        indices = A._setArrayType([start - 1], type$.JSArray_int);
      for (t1 = text.length, i = start, slashIndex = -1, char = null; i < t1; ++i) {
        char = text.charCodeAt(i);
        if (char === 44 || char === 59)
          break;
        if (char === 47) {
          if (slashIndex < 0) {
            slashIndex = i;
            continue;
          }
          throw A.wrapException(A.FormatException$(_s17_, text, i));
        }
      }
      if (slashIndex < 0 && i > start)
        throw A.wrapException(A.FormatException$(_s17_, text, i));
      for (; char !== 44;) {
        indices.push(i);
        ++i;
        for (equalsIndex = -1; i < t1; ++i) {
          char = text.charCodeAt(i);
          if (char === 61) {
            if (equalsIndex < 0)
              equalsIndex = i;
          } else if (char === 59 || char === 44)
            break;
        }
        if (equalsIndex >= 0)
          indices.push(equalsIndex);
        else {
          lastSeparator = B.JSArray_methods.get$last(indices);
          if (char !== 44 || i !== lastSeparator + 7 || !B.JSString_methods.startsWith$2(text, "base64", lastSeparator + 1))
            throw A.wrapException(A.FormatException$("Expecting '='", text, i));
          break;
        }
      }
      indices.push(i);
      t2 = i + 1;
      if ((indices.length & 1) === 1)
        text = B.C_Base64Codec.normalize$3(text, t2, t1);
      else {
        data = A._Uri__normalize(text, t2, t1, B.List_42A, true, false);
        if (data != null)
          text = B.JSString_methods.replaceRange$3(text, t2, t1, data);
      }
      return new A.UriData(text, indices, sourceUri);
    },
    UriData__uriEncodeBytes(canonicalTable, bytes, buffer) {
      var t1, byteOr, i, byte, t2,
        _s16_ = "0123456789ABCDEF";
      for (t1 = bytes.length, byteOr = 0, i = 0; i < t1; ++i) {
        byte = bytes[i];
        byteOr |= byte;
        if (byte < 128 && (canonicalTable[byte >>> 4] & 1 << (byte & 15)) !== 0) {
          t2 = A.Primitives_stringFromCharCode(byte);
          buffer._contents += t2;
        } else {
          t2 = A.Primitives_stringFromCharCode(37);
          buffer._contents += t2;
          t2 = A.Primitives_stringFromCharCode(_s16_.charCodeAt(byte >>> 4));
          buffer._contents += t2;
          t2 = A.Primitives_stringFromCharCode(_s16_.charCodeAt(byte & 15));
          buffer._contents += t2;
        }
      }
      if ((byteOr & 4294967040) !== 0)
        for (i = 0; i < t1; ++i) {
          byte = bytes[i];
          if (byte > 255)
            throw A.wrapException(A.ArgumentError$value(byte, "non-byte value", null));
        }
    },
    _createTables() {
      var _i, t1, t2, t3, b,
        _s77_ = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~!$&'()*+,;=",
        _s1_ = ".", _s1_0 = ":", _s1_1 = "/", _s1_2 = "\\", _s1_3 = "?", _s1_4 = "#", _s2_ = "/\\",
        tables = J.JSArray_JSArray$allocateGrowable(22, type$.Uint8List);
      for (_i = 0; _i < 22; ++_i)
        tables[_i] = new Uint8Array(96);
      t1 = new A._createTables_build(tables);
      t2 = new A._createTables_setChars();
      t3 = new A._createTables_setRange();
      b = t1.call$2(0, 225);
      t2.call$3(b, _s77_, 1);
      t2.call$3(b, _s1_, 14);
      t2.call$3(b, _s1_0, 34);
      t2.call$3(b, _s1_1, 3);
      t2.call$3(b, _s1_2, 227);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(14, 225);
      t2.call$3(b, _s77_, 1);
      t2.call$3(b, _s1_, 15);
      t2.call$3(b, _s1_0, 34);
      t2.call$3(b, _s2_, 234);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(15, 225);
      t2.call$3(b, _s77_, 1);
      t2.call$3(b, "%", 225);
      t2.call$3(b, _s1_0, 34);
      t2.call$3(b, _s1_1, 9);
      t2.call$3(b, _s1_2, 233);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(1, 225);
      t2.call$3(b, _s77_, 1);
      t2.call$3(b, _s1_0, 34);
      t2.call$3(b, _s1_1, 10);
      t2.call$3(b, _s1_2, 234);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(2, 235);
      t2.call$3(b, _s77_, 139);
      t2.call$3(b, _s1_1, 131);
      t2.call$3(b, _s1_2, 131);
      t2.call$3(b, _s1_, 146);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(3, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_1, 68);
      t2.call$3(b, _s1_2, 68);
      t2.call$3(b, _s1_, 18);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(4, 229);
      t2.call$3(b, _s77_, 5);
      t3.call$3(b, "AZ", 229);
      t2.call$3(b, _s1_0, 102);
      t2.call$3(b, "@", 68);
      t2.call$3(b, "[", 232);
      t2.call$3(b, _s1_1, 138);
      t2.call$3(b, _s1_2, 138);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(5, 229);
      t2.call$3(b, _s77_, 5);
      t3.call$3(b, "AZ", 229);
      t2.call$3(b, _s1_0, 102);
      t2.call$3(b, "@", 68);
      t2.call$3(b, _s1_1, 138);
      t2.call$3(b, _s1_2, 138);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(6, 231);
      t3.call$3(b, "19", 7);
      t2.call$3(b, "@", 68);
      t2.call$3(b, _s1_1, 138);
      t2.call$3(b, _s1_2, 138);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(7, 231);
      t3.call$3(b, "09", 7);
      t2.call$3(b, "@", 68);
      t2.call$3(b, _s1_1, 138);
      t2.call$3(b, _s1_2, 138);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      t2.call$3(t1.call$2(8, 8), "]", 5);
      b = t1.call$2(9, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_, 16);
      t2.call$3(b, _s2_, 234);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(16, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_, 17);
      t2.call$3(b, _s2_, 234);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(17, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_1, 9);
      t2.call$3(b, _s1_2, 233);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(10, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_, 18);
      t2.call$3(b, _s1_1, 10);
      t2.call$3(b, _s1_2, 234);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(18, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_, 19);
      t2.call$3(b, _s2_, 234);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(19, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s2_, 234);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(11, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_1, 10);
      t2.call$3(b, _s1_2, 234);
      t2.call$3(b, _s1_3, 172);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(12, 236);
      t2.call$3(b, _s77_, 12);
      t2.call$3(b, _s1_3, 12);
      t2.call$3(b, _s1_4, 205);
      b = t1.call$2(13, 237);
      t2.call$3(b, _s77_, 13);
      t2.call$3(b, _s1_3, 13);
      t3.call$3(t1.call$2(20, 245), "az", 21);
      b = t1.call$2(21, 245);
      t3.call$3(b, "az", 21);
      t3.call$3(b, "09", 21);
      t2.call$3(b, "+-.", 21);
      return tables;
    },
    _scan(uri, start, end, state, indices) {
      var i, table, char, transition,
        tables = $.$get$_scannerTables();
      for (i = start; i < end; ++i) {
        table = tables[state];
        char = uri.charCodeAt(i) ^ 96;
        transition = table[char > 95 ? 31 : char];
        state = transition & 31;
        indices[transition >>> 5] = i;
      }
      return state;
    },
    _SimpleUri__packageNameEnd(uri) {
      if (uri._schemeEnd === 7 && B.JSString_methods.startsWith$1(uri._uri, "package") && uri._hostStart <= 0)
        return A._skipPackageNameChars(uri._uri, uri._pathStart, uri._queryStart);
      return -1;
    },
    _skipPackageNameChars(source, start, end) {
      var i, dots, char;
      for (i = start, dots = 0; i < end; ++i) {
        char = source.charCodeAt(i);
        if (char === 47)
          return dots !== 0 ? i : -1;
        if (char === 37 || char === 58)
          return -1;
        dots |= char ^ 46;
      }
      return -1;
    },
    _caseInsensitiveCompareStart(prefix, string, start) {
      var t1, result, i, stringChar, delta, lowerChar;
      for (t1 = prefix.length, result = 0, i = 0; i < t1; ++i) {
        stringChar = string.charCodeAt(start + i);
        delta = prefix.charCodeAt(i) ^ stringChar;
        if (delta !== 0) {
          if (delta === 32) {
            lowerChar = stringChar | delta;
            if (97 <= lowerChar && lowerChar <= 122) {
              result = 32;
              continue;
            }
          }
          return -1;
        }
      }
      return result;
    },
    NoSuchMethodError_toString_closure: function NoSuchMethodError_toString_closure(t0, t1) {
      this._box_0 = t0;
      this.sb = t1;
    },
    DateTime: function DateTime(t0, t1) {
      this._value = t0;
      this.isUtc = t1;
    },
    Duration: function Duration(t0) {
      this._duration = t0;
    },
    _Enum: function _Enum() {
    },
    Error: function Error() {
    },
    AssertionError: function AssertionError(t0) {
      this.message = t0;
    },
    TypeError: function TypeError() {
    },
    ArgumentError: function ArgumentError(t0, t1, t2, t3) {
      var _ = this;
      _._hasValue = t0;
      _.invalidValue = t1;
      _.name = t2;
      _.message = t3;
    },
    RangeError: function RangeError(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.start = t0;
      _.end = t1;
      _._hasValue = t2;
      _.invalidValue = t3;
      _.name = t4;
      _.message = t5;
    },
    IndexError: function IndexError(t0, t1, t2, t3, t4) {
      var _ = this;
      _.length = t0;
      _._hasValue = t1;
      _.invalidValue = t2;
      _.name = t3;
      _.message = t4;
    },
    NoSuchMethodError: function NoSuchMethodError(t0, t1, t2, t3) {
      var _ = this;
      _._core$_receiver = t0;
      _._memberName = t1;
      _._core$_arguments = t2;
      _._namedArguments = t3;
    },
    UnsupportedError: function UnsupportedError(t0) {
      this.message = t0;
    },
    UnimplementedError: function UnimplementedError(t0) {
      this.message = t0;
    },
    StateError: function StateError(t0) {
      this.message = t0;
    },
    ConcurrentModificationError: function ConcurrentModificationError(t0) {
      this.modifiedObject = t0;
    },
    OutOfMemoryError: function OutOfMemoryError() {
    },
    StackOverflowError: function StackOverflowError() {
    },
    _Exception: function _Exception(t0) {
      this.message = t0;
    },
    FormatException: function FormatException(t0, t1, t2) {
      this.message = t0;
      this.source = t1;
      this.offset = t2;
    },
    Iterable: function Iterable() {
    },
    _GeneratorIterable: function _GeneratorIterable(t0, t1, t2) {
      this.length = t0;
      this._generator = t1;
      this.$ti = t2;
    },
    MapEntry: function MapEntry(t0, t1, t2) {
      this.key = t0;
      this.value = t1;
      this.$ti = t2;
    },
    Null: function Null() {
    },
    Object: function Object() {
    },
    _StringStackTrace: function _StringStackTrace(t0) {
      this._stackTrace = t0;
    },
    Runes: function Runes(t0) {
      this.string = t0;
    },
    RuneIterator: function RuneIterator(t0) {
      var _ = this;
      _.string = t0;
      _._nextPosition = _._position = 0;
      _._currentCodePoint = -1;
    },
    StringBuffer: function StringBuffer(t0) {
      this._contents = t0;
    },
    Uri__parseIPv4Address_error: function Uri__parseIPv4Address_error(t0) {
      this.host = t0;
    },
    Uri_parseIPv6Address_error: function Uri_parseIPv6Address_error(t0) {
      this.host = t0;
    },
    Uri_parseIPv6Address_parseHex: function Uri_parseIPv6Address_parseHex(t0, t1) {
      this.error = t0;
      this.host = t1;
    },
    _Uri: function _Uri(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.scheme = t0;
      _._userInfo = t1;
      _._host = t2;
      _._port = t3;
      _.path = t4;
      _._query = t5;
      _._fragment = t6;
      _.___Uri_hashCode_FI = _.___Uri_pathSegments_FI = _.___Uri__text_FI = $;
    },
    _Uri__makePath_closure: function _Uri__makePath_closure() {
    },
    UriData: function UriData(t0, t1, t2) {
      this._text = t0;
      this._separatorIndices = t1;
      this._uriCache = t2;
    },
    _createTables_build: function _createTables_build(t0) {
      this.tables = t0;
    },
    _createTables_setChars: function _createTables_setChars() {
    },
    _createTables_setRange: function _createTables_setRange() {
    },
    _SimpleUri: function _SimpleUri(t0, t1, t2, t3, t4, t5, t6, t7) {
      var _ = this;
      _._uri = t0;
      _._schemeEnd = t1;
      _._hostStart = t2;
      _._portStart = t3;
      _._pathStart = t4;
      _._queryStart = t5;
      _._fragmentStart = t6;
      _._schemeCache = t7;
      _._hashCodeCache = null;
    },
    _DataUri: function _DataUri(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.scheme = t0;
      _._userInfo = t1;
      _._host = t2;
      _._port = t3;
      _.path = t4;
      _._query = t5;
      _._fragment = t6;
      _.___Uri_hashCode_FI = _.___Uri_pathSegments_FI = _.___Uri__text_FI = $;
    },
    Expando: function Expando(t0) {
      this._jsWeakMap = t0;
    },
    _convertDartFunctionFast(f) {
      var ret,
        existing = f.$dart_jsFunction;
      if (existing != null)
        return existing;
      ret = function(_call, f) {
        return function() {
          return _call(f, Array.prototype.slice.apply(arguments));
        };
      }(A._callDartFunctionFast, f);
      ret[$.$get$DART_CLOSURE_PROPERTY_NAME()] = f;
      f.$dart_jsFunction = ret;
      return ret;
    },
    _convertDartFunctionFastCaptureThis(f) {
      var ret,
        existing = f._$dart_jsFunctionCaptureThis;
      if (existing != null)
        return existing;
      ret = function(_call, f) {
        return function() {
          return _call(f, this, Array.prototype.slice.apply(arguments));
        };
      }(A._callDartFunctionFastCaptureThis, f);
      ret[$.$get$DART_CLOSURE_PROPERTY_NAME()] = f;
      f._$dart_jsFunctionCaptureThis = ret;
      return ret;
    },
    _callDartFunctionFast(callback, $arguments) {
      return A.Function_apply(callback, $arguments);
    },
    _callDartFunctionFastCaptureThis(callback, $self, $arguments) {
      var t1 = [$self];
      B.JSArray_methods.addAll$1(t1, $arguments);
      return A.Function_apply(callback, t1);
    },
    allowInterop(f) {
      if (typeof f == "function")
        return f;
      else
        return A._convertDartFunctionFast(f);
    },
    allowInteropCaptureThis(f) {
      if (typeof f == "function")
        throw A.wrapException(A.ArgumentError$("Function is already a JS function so cannot capture this.", null));
      else
        return A._convertDartFunctionFastCaptureThis(f);
    },
    _noJsifyRequired(o) {
      return o == null || A._isBool(o) || typeof o == "number" || typeof o == "string" || type$.Int8List._is(o) || type$.Uint8List._is(o) || type$.Uint8ClampedList._is(o) || type$.Int16List._is(o) || type$.Uint16List._is(o) || type$.Int32List._is(o) || type$.Uint32List._is(o) || type$.Float32List._is(o) || type$.Float64List._is(o) || type$.ByteBuffer._is(o) || type$.ByteData._is(o);
    },
    jsify(object) {
      if (A._noJsifyRequired(object))
        return object;
      return new A.jsify__convert(new A._IdentityHashMap(type$._IdentityHashMap_of_nullable_Object_and_nullable_Object)).call$1(object);
    },
    callConstructor(constr, $arguments) {
      var args, factoryFunction;
      if ($arguments instanceof Array)
        switch ($arguments.length) {
          case 0:
            return new constr();
          case 1:
            return new constr($arguments[0]);
          case 2:
            return new constr($arguments[0], $arguments[1]);
          case 3:
            return new constr($arguments[0], $arguments[1], $arguments[2]);
          case 4:
            return new constr($arguments[0], $arguments[1], $arguments[2], $arguments[3]);
        }
      args = [null];
      B.JSArray_methods.addAll$1(args, $arguments);
      factoryFunction = constr.bind.apply(constr, args);
      String(factoryFunction);
      return new factoryFunction();
    },
    promiseToFuture0(jsPromise, $T) {
      var t1 = new A._Future($.Zone__current, $T._eval$1("_Future<0>")),
        completer = new A._AsyncCompleter(t1, $T._eval$1("_AsyncCompleter<0>"));
      jsPromise.then(A.convertDartClosureToJS(new A.promiseToFuture_closure1(completer), 1), A.convertDartClosureToJS(new A.promiseToFuture_closure2(completer), 1));
      return t1;
    },
    jsify__convert: function jsify__convert(t0) {
      this._convertedObjects = t0;
    },
    promiseToFuture_closure1: function promiseToFuture_closure1(t0) {
      this.completer = t0;
    },
    promiseToFuture_closure2: function promiseToFuture_closure2(t0) {
      this.completer = t0;
    },
    NullRejectionException: function NullRejectionException(t0) {
      this.isUndefined = t0;
    },
    max(a, b) {
      return Math.max(a, b);
    },
    pow(x, exponent) {
      return Math.pow(x, exponent);
    },
    Random_Random() {
      return B.C__JSRandom;
    },
    _JSRandom: function _JSRandom() {
    },
    ArgParser: function ArgParser(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._arg_parser$_options = t0;
      _._aliases = t1;
      _.options = t2;
      _.commands = t3;
      _._optionsAndSeparators = t4;
      _.allowTrailingOptions = t5;
      _.usageLineLength = t6;
    },
    ArgParser__addOption_closure: function ArgParser__addOption_closure(t0) {
      this.$this = t0;
    },
    ArgParserException$(message, commands) {
      return new A.ArgParserException(commands == null ? B.List_empty : A.List_List$unmodifiable(commands, type$.String), message, null, null);
    },
    ArgParserException: function ArgParserException(t0, t1, t2, t3) {
      var _ = this;
      _.commands = t0;
      _.message = t1;
      _.source = t2;
      _.offset = t3;
    },
    ArgResults: function ArgResults(t0, t1, t2, t3) {
      var _ = this;
      _._parser = t0;
      _._parsed = t1;
      _.name = t2;
      _.rest = t3;
    },
    Option: function Option(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12) {
      var _ = this;
      _.name = t0;
      _.abbr = t1;
      _.help = t2;
      _.valueHelp = t3;
      _.allowed = t4;
      _.allowedHelp = t5;
      _.defaultsTo = t6;
      _.negatable = t7;
      _.callback = t8;
      _.type = t9;
      _.splitCommas = t10;
      _.mandatory = t11;
      _.hide = t12;
    },
    OptionType: function OptionType(t0) {
      this.name = t0;
    },
    Parser$(_commandName, _grammar, _args, _parent, rest) {
      var t1 = A._setArrayType([], type$.JSArray_String);
      if (rest != null)
        B.JSArray_methods.addAll$1(t1, rest);
      return new A.Parser0(_commandName, _parent, _grammar, _args, t1, A.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.dynamic));
    },
    _isLetterOrDigit(codeUnit) {
      var t1;
      if (!(codeUnit >= 65 && codeUnit <= 90))
        if (!(codeUnit >= 97 && codeUnit <= 122))
          t1 = codeUnit >= 48 && codeUnit <= 57;
        else
          t1 = true;
      else
        t1 = true;
      return t1;
    },
    Parser0: function Parser0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._commandName = t0;
      _._parser$_parent = t1;
      _._grammar = t2;
      _._args = t3;
      _._parser$_rest = t4;
      _._results = t5;
    },
    Parser_parse_closure: function Parser_parse_closure(t0) {
      this.$this = t0;
    },
    Parser__setOption_closure: function Parser__setOption_closure() {
    },
    _Usage: function _Usage(t0, t1, t2) {
      var _ = this;
      _._usage$_optionsAndSeparators = t0;
      _._usage$_buffer = t1;
      _._currentColumn = 0;
      _.___Usage__columnWidths_FI = $;
      _._newlinesNeeded = 0;
      _.lineLength = t2;
    },
    _Usage__writeOption_closure: function _Usage__writeOption_closure() {
    },
    _Usage__buildAllowedList_closure: function _Usage__buildAllowedList_closure(t0) {
      this.option = t0;
    },
    FutureGroup: function FutureGroup(t0, t1, t2) {
      var _ = this;
      _._future_group$_pending = 0;
      _._future_group$_closed = false;
      _._future_group$_completer = t0;
      _._future_group$_values = t1;
      _.$ti = t2;
    },
    FutureGroup_add_closure: function FutureGroup_add_closure(t0, t1) {
      this.$this = t0;
      this.index = t1;
    },
    FutureGroup_add_closure0: function FutureGroup_add_closure0(t0) {
      this.$this = t0;
    },
    ErrorResult: function ErrorResult(t0, t1) {
      this.error = t0;
      this.stackTrace = t1;
    },
    ValueResult: function ValueResult(t0, t1) {
      this.value = t0;
      this.$ti = t1;
    },
    StreamCompleter: function StreamCompleter(t0, t1) {
      this._stream_completer$_stream = t0;
      this.$ti = t1;
    },
    _CompleterStream: function _CompleterStream(t0) {
      this._sourceStream = this._stream_completer$_controller = null;
      this.$ti = t0;
    },
    StreamGroup: function StreamGroup(t0, t1, t2) {
      var _ = this;
      _.__StreamGroup__controller_A = $;
      _._closed = false;
      _._stream_group$_state = t0;
      _._subscriptions = t1;
      _.$ti = t2;
    },
    StreamGroup_add_closure: function StreamGroup_add_closure() {
    },
    StreamGroup_add_closure0: function StreamGroup_add_closure0(t0, t1) {
      this.$this = t0;
      this.stream = t1;
    },
    StreamGroup__onListen_closure: function StreamGroup__onListen_closure() {
    },
    StreamGroup__onCancel_closure: function StreamGroup__onCancel_closure(t0) {
      this.$this = t0;
    },
    StreamGroup__listenToStream_closure: function StreamGroup__listenToStream_closure(t0, t1) {
      this.$this = t0;
      this.stream = t1;
    },
    _StreamGroupState: function _StreamGroupState(t0) {
      this.name = t0;
    },
    StreamQueue: function StreamQueue(t0, t1, t2, t3) {
      var _ = this;
      _._stream_queue$_source = t0;
      _._stream_queue$_subscription = null;
      _._isDone = false;
      _._eventsReceived = 0;
      _._eventQueue = t1;
      _._requestQueue = t2;
      _.$ti = t3;
    },
    StreamQueue__ensureListening_closure: function StreamQueue__ensureListening_closure(t0) {
      this.$this = t0;
    },
    StreamQueue__ensureListening_closure1: function StreamQueue__ensureListening_closure1(t0) {
      this.$this = t0;
    },
    StreamQueue__ensureListening_closure0: function StreamQueue__ensureListening_closure0(t0) {
      this.$this = t0;
    },
    _NextRequest: function _NextRequest(t0, t1) {
      this._completer = t0;
      this.$ti = t1;
    },
    isNodeJs() {
      var t1 = self.process;
      if (t1 == null)
        t1 = null;
      else {
        t1 = J.get$release$x(t1);
        t1 = t1 == null ? null : J.get$name$x(t1);
      }
      return J.$eq$(t1, "node");
    },
    isBrowser() {
      return !A.isNodeJs() && self.document != null && typeof self.document.querySelector == "function";
    },
    wrapJSExceptions(callback) {
      var error, error0, error1, error2, t1, exception;
      if (!$.$get$_isStrictMode())
        return callback.call$0();
      try {
        t1 = callback.call$0();
        return t1;
      } catch (exception) {
        t1 = A.unwrapException(exception);
        if (typeof t1 == "string") {
          error = t1;
          throw A.wrapException(error);
        } else if (A._isBool(t1)) {
          error0 = t1;
          throw A.wrapException(error0);
        } else if (typeof t1 == "number") {
          error1 = t1;
          throw A.wrapException(error1);
        } else {
          error2 = t1;
          if (typeof error2 == "symbol" || typeof error2 == "bigint" || error2 == null)
            throw A.wrapException(error2.toString());
          throw exception;
        }
      }
    },
    _isStrictMode_closure: function _isStrictMode_closure() {
    },
    Repl: function Repl(t0, t1, t2, t3) {
      var _ = this;
      _.prompt = t0;
      _.continuation = t1;
      _.validator = t2;
      _.__Repl__adapter_A = $;
      _.history = t3;
    },
    alwaysValid_closure: function alwaysValid_closure() {
    },
    ReplAdapter: function ReplAdapter(t0) {
      this.repl = t0;
      this.rl = null;
    },
    ReplAdapter_runAsync_closure: function ReplAdapter_runAsync_closure(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.rl = t2;
      _.runController = t3;
    },
    ReplAdapter_runAsync__closure: function ReplAdapter_runAsync__closure(t0) {
      this.lineController = t0;
    },
    Stdin: function Stdin() {
    },
    Stdout: function Stdout() {
    },
    ReadlineModule: function ReadlineModule() {
    },
    ReadlineOptions: function ReadlineOptions() {
    },
    ReadlineInterface: function ReadlineInterface() {
    },
    EmptyUnmodifiableSet: function EmptyUnmodifiableSet(t0) {
      this.$ti = t0;
    },
    _EmptyUnmodifiableSet_IterableBase_UnmodifiableSetMixin: function _EmptyUnmodifiableSet_IterableBase_UnmodifiableSetMixin() {
    },
    DefaultEquality: function DefaultEquality() {
    },
    IterableEquality: function IterableEquality() {
    },
    ListEquality: function ListEquality() {
    },
    _MapEntry: function _MapEntry(t0, t1, t2) {
      this.equality = t0;
      this.key = t1;
      this.value = t2;
    },
    MapEquality: function MapEquality(t0) {
      this.$ti = t0;
    },
    QueueList$(initialCapacity, $E) {
      return new A.QueueList(A.List_List$filled(A.QueueList__computeInitialCapacity(initialCapacity), null, false, $E._eval$1("0?")), 0, 0, $E._eval$1("QueueList<0>"));
    },
    QueueList_QueueList$from(source, $E) {
      var $length, queue, t1;
      if (type$.List_dynamic._is(source)) {
        $length = J.get$length$asx(source);
        queue = A.QueueList$($length + 1, $E);
        J.setRange$4$ax(queue._queue_list$_table, 0, $length, source, 0);
        queue._queue_list$_tail = $length;
        return queue;
      } else {
        t1 = A.QueueList$(null, $E);
        t1.addAll$1(0, source);
        return t1;
      }
    },
    QueueList__computeInitialCapacity(initialCapacity) {
      if (initialCapacity == null || initialCapacity < 8)
        return 8;
      ++initialCapacity;
      if ((initialCapacity & initialCapacity - 1) >>> 0 === 0)
        return initialCapacity;
      return A.QueueList__nextPowerOf2(initialCapacity);
    },
    QueueList__nextPowerOf2(number) {
      var nextNumber;
      number = (number << 1 >>> 0) - 1;
      for (; true; number = nextNumber) {
        nextNumber = (number & number - 1) >>> 0;
        if (nextNumber === 0)
          return number;
      }
    },
    QueueList: function QueueList(t0, t1, t2, t3) {
      var _ = this;
      _._queue_list$_table = t0;
      _._queue_list$_head = t1;
      _._queue_list$_tail = t2;
      _.$ti = t3;
    },
    _CastQueueList: function _CastQueueList(t0, t1, t2, t3, t4) {
      var _ = this;
      _._queue_list$_delegate = t0;
      _._queue_list$_table = t1;
      _._queue_list$_head = t2;
      _._queue_list$_tail = t3;
      _.$ti = t4;
    },
    _QueueList_Object_ListMixin: function _QueueList_Object_ListMixin() {
    },
    UnionSet: function UnionSet(t0, t1) {
      this._sets = t0;
      this.$ti = t1;
    },
    UnionSet__iterable_closure: function UnionSet__iterable_closure(t0) {
      this.$this = t0;
    },
    UnionSet_contains_closure: function UnionSet_contains_closure(t0, t1) {
      this.$this = t0;
      this.element = t1;
    },
    _UnionSet_SetBase_UnmodifiableSetMixin: function _UnionSet_SetBase_UnmodifiableSetMixin() {
    },
    UnmodifiableSetMixin__throw() {
      throw A.wrapException(A.UnsupportedError$("Cannot modify an unmodifiable Set"));
    },
    UnmodifiableSetView0: function UnmodifiableSetView0(t0, t1) {
      this._base = t0;
      this.$ti = t1;
    },
    UnmodifiableSetMixin: function UnmodifiableSetMixin() {
    },
    _UnmodifiableSetView_DelegatingSet_UnmodifiableSetMixin: function _UnmodifiableSetView_DelegatingSet_UnmodifiableSetMixin() {
    },
    _DelegatingIterableBase: function _DelegatingIterableBase() {
    },
    DelegatingSet: function DelegatingSet(t0, t1) {
      this._base = t0;
      this.$ti = t1;
    },
    MapKeySet: function MapKeySet(t0, t1) {
      this._baseMap = t0;
      this.$ti = t1;
    },
    MapKeySet_difference_closure: function MapKeySet_difference_closure(t0, t1) {
      this.$this = t0;
      this.other = t1;
    },
    _MapKeySet__DelegatingIterableBase_UnmodifiableSetMixin: function _MapKeySet__DelegatingIterableBase_UnmodifiableSetMixin() {
    },
    BufferModule: function BufferModule() {
    },
    BufferConstants: function BufferConstants() {
    },
    Buffer: function Buffer() {
    },
    ConsoleModule: function ConsoleModule() {
    },
    Console: function Console() {
    },
    EventEmitter: function EventEmitter() {
    },
    fs() {
      var t1 = $._fs;
      return t1 == null ? $._fs = self.fs : t1;
    },
    FS: function FS() {
    },
    FSConstants: function FSConstants() {
    },
    FSWatcher: function FSWatcher() {
    },
    ReadStream: function ReadStream() {
    },
    ReadStreamOptions: function ReadStreamOptions() {
    },
    WriteStream: function WriteStream() {
    },
    WriteStreamOptions: function WriteStreamOptions() {
    },
    FileOptions: function FileOptions() {
    },
    StatOptions: function StatOptions() {
    },
    MkdirOptions: function MkdirOptions() {
    },
    RmdirOptions: function RmdirOptions() {
    },
    WatchOptions: function WatchOptions() {
    },
    WatchFileOptions: function WatchFileOptions() {
    },
    Stats: function Stats() {
    },
    Promise: function Promise() {
    },
    Date: function Date() {
    },
    JsError: function JsError() {
    },
    Atomics: function Atomics() {
    },
    Modules: function Modules() {
    },
    Module: function Module() {
    },
    Net: function Net() {
    },
    Socket: function Socket() {
    },
    NetAddress: function NetAddress() {
    },
    NetServer: function NetServer() {
    },
    NodeJsError: function NodeJsError() {
    },
    JsAssertionError: function JsAssertionError() {
    },
    JsRangeError: function JsRangeError() {
    },
    JsReferenceError: function JsReferenceError() {
    },
    JsSyntaxError: function JsSyntaxError() {
    },
    JsTypeError: function JsTypeError() {
    },
    JsSystemError: function JsSystemError() {
    },
    Process: function Process() {
    },
    CPUUsage: function CPUUsage() {
    },
    Release: function Release() {
    },
    StreamModule: function StreamModule() {
    },
    Readable: function Readable() {
    },
    Writable: function Writable() {
    },
    Duplex: function Duplex() {
    },
    Transform: function Transform() {
    },
    WritableOptions: function WritableOptions() {
    },
    ReadableOptions: function ReadableOptions() {
    },
    Immediate: function Immediate() {
    },
    Timeout: function Timeout() {
    },
    TTY: function TTY() {
    },
    TTYReadStream: function TTYReadStream() {
    },
    TTYWriteStream: function TTYWriteStream() {
    },
    jsify0(dartObject) {
      if (A._isBasicType(dartObject))
        return dartObject;
      return A.jsify(dartObject);
    },
    _isBasicType(value) {
      return false;
    },
    promiseToFuture(promise, $T) {
      var t1 = new A._Future($.Zone__current, $T._eval$1("_Future<0>")),
        completer = new A._SyncCompleter(t1, $T._eval$1("_SyncCompleter<0>"));
      J.then$2$x(promise, A.allowInterop(new A.promiseToFuture_closure(completer)), A.allowInterop(new A.promiseToFuture_closure0(completer)));
      return t1;
    },
    futureToPromise(future, $T) {
      return new self.Promise(A.allowInterop(new A.futureToPromise_closure(future, $T)));
    },
    Util: function Util() {
    },
    promiseToFuture_closure: function promiseToFuture_closure(t0) {
      this.completer = t0;
    },
    promiseToFuture_closure0: function promiseToFuture_closure0(t0) {
      this.completer = t0;
    },
    futureToPromise_closure: function futureToPromise_closure(t0, t1) {
      this.future = t0;
      this.T = t1;
    },
    futureToPromise__closure: function futureToPromise__closure(t0, t1) {
      this.resolve = t0;
      this.T = t1;
    },
    Context_Context(style) {
      return new A.Context(style, ".");
    },
    _parseUri(uri) {
      if (typeof uri == "string")
        return A.Uri_parse(uri);
      if (type$.Uri._is(uri))
        return uri;
      throw A.wrapException(A.ArgumentError$value(uri, "uri", "Value must be a String or a Uri"));
    },
    _validateArgList(method, args) {
      var numArgs, i, numArgs0, message, t1, t2, t3, t4;
      for (numArgs = args.length, i = 1; i < numArgs; ++i) {
        if (args[i] == null || args[i - 1] != null)
          continue;
        for (; numArgs >= 1; numArgs = numArgs0) {
          numArgs0 = numArgs - 1;
          if (args[numArgs0] != null)
            break;
        }
        message = new A.StringBuffer("");
        t1 = "" + (method + "(");
        message._contents = t1;
        t2 = A._arrayInstanceType(args);
        t3 = t2._eval$1("SubListIterable<1>");
        t4 = new A.SubListIterable(args, 0, numArgs, t3);
        t4.SubListIterable$3(args, 0, numArgs, t2._precomputed1);
        t3 = t1 + new A.MappedListIterable(t4, new A._validateArgList_closure(), t3._eval$1("MappedListIterable<ListIterable.E,String>")).join$1(0, ", ");
        message._contents = t3;
        message._contents = t3 + ("): part " + (i - 1) + " was null, but part " + i + " was not.");
        throw A.wrapException(A.ArgumentError$(message.toString$0(0), null));
      }
    },
    Context: function Context(t0, t1) {
      this.style = t0;
      this._context$_current = t1;
    },
    Context_joinAll_closure: function Context_joinAll_closure() {
    },
    Context_split_closure: function Context_split_closure() {
    },
    _validateArgList_closure: function _validateArgList_closure() {
    },
    _PathDirection: function _PathDirection(t0) {
      this.name = t0;
    },
    _PathRelation: function _PathRelation(t0) {
      this.name = t0;
    },
    InternalStyle: function InternalStyle() {
    },
    ParsedPath_ParsedPath$parse(path, style) {
      var t1, parts, separators, start, i,
        root = style.getRoot$1(path),
        isRootRelative = style.isRootRelative$1(path);
      if (root != null)
        path = B.JSString_methods.substring$1(path, root.length);
      t1 = type$.JSArray_String;
      parts = A._setArrayType([], t1);
      separators = A._setArrayType([], t1);
      t1 = path.length;
      if (t1 !== 0 && style.isSeparator$1(path.charCodeAt(0))) {
        separators.push(path[0]);
        start = 1;
      } else {
        separators.push("");
        start = 0;
      }
      for (i = start; i < t1; ++i)
        if (style.isSeparator$1(path.charCodeAt(i))) {
          parts.push(B.JSString_methods.substring$2(path, start, i));
          separators.push(path[i]);
          start = i + 1;
        }
      if (start < t1) {
        parts.push(B.JSString_methods.substring$1(path, start));
        separators.push("");
      }
      return new A.ParsedPath(style, root, isRootRelative, parts, separators);
    },
    ParsedPath: function ParsedPath(t0, t1, t2, t3, t4) {
      var _ = this;
      _.style = t0;
      _.root = t1;
      _.isRootRelative = t2;
      _.parts = t3;
      _.separators = t4;
    },
    ParsedPath__splitExtension_closure: function ParsedPath__splitExtension_closure() {
    },
    ParsedPath__splitExtension_closure0: function ParsedPath__splitExtension_closure0() {
    },
    PathException$(message) {
      return new A.PathException(message);
    },
    PathException: function PathException(t0) {
      this.message = t0;
    },
    PathMap__create(context, $V) {
      var t1 = {};
      t1.context = context;
      t1.context = $.$get$context();
      return A.LinkedHashMap_LinkedHashMap(new A.PathMap__create_closure(t1), new A.PathMap__create_closure0(t1), new A.PathMap__create_closure1(), type$.nullable_String, $V);
    },
    PathMap: function PathMap(t0, t1) {
      this._map = t0;
      this.$ti = t1;
    },
    PathMap__create_closure: function PathMap__create_closure(t0) {
      this._box_0 = t0;
    },
    PathMap__create_closure0: function PathMap__create_closure0(t0) {
      this._box_0 = t0;
    },
    PathMap__create_closure1: function PathMap__create_closure1() {
    },
    Style__getPlatformStyle() {
      if (A.Uri_base().get$scheme() !== "file")
        return $.$get$Style_url();
      var t1 = A.Uri_base();
      if (!B.JSString_methods.endsWith$1(t1.get$path(t1), "/"))
        return $.$get$Style_url();
      if (A._Uri__Uri(null, "a/b", null, null).toFilePath$0() === "a\\b")
        return $.$get$Style_windows();
      return $.$get$Style_posix();
    },
    Style: function Style() {
    },
    PosixStyle: function PosixStyle(t0, t1, t2) {
      this.separatorPattern = t0;
      this.needsSeparatorPattern = t1;
      this.rootPattern = t2;
    },
    UrlStyle: function UrlStyle(t0, t1, t2, t3) {
      var _ = this;
      _.separatorPattern = t0;
      _.needsSeparatorPattern = t1;
      _.rootPattern = t2;
      _.relativeRootPattern = t3;
    },
    WindowsStyle: function WindowsStyle(t0, t1, t2, t3) {
      var _ = this;
      _.separatorPattern = t0;
      _.needsSeparatorPattern = t1;
      _.rootPattern = t2;
      _.relativeRootPattern = t3;
    },
    WindowsStyle_absolutePathToUri_closure: function WindowsStyle_absolutePathToUri_closure() {
    },
    Version$_(major, minor, patch, preRelease, build, _text) {
      var t1 = preRelease == null ? A._setArrayType([], type$.JSArray_Object) : A.Version__splitParts(preRelease),
        t2 = build == null ? A._setArrayType([], type$.JSArray_Object) : A.Version__splitParts(build);
      if (major < 0)
        A.throwExpression(A.ArgumentError$("Major version must be non-negative.", null));
      if (minor < 0)
        A.throwExpression(A.ArgumentError$("Minor version must be non-negative.", null));
      if (patch < 0)
        A.throwExpression(A.ArgumentError$("Patch version must be non-negative.", null));
      return new A.Version(major, minor, patch, t1, t2, _text);
    },
    Version_Version(major, minor, patch, pre) {
      var text = "" + major + "." + minor + "." + patch;
      if (pre != null)
        text += "-" + pre;
      return A.Version$_(major, minor, patch, pre, null, text);
    },
    Version___parse_tearOff(text) {
      return A.Version_Version$parse(text);
    },
    Version_Version$parse(text) {
      var major, minor, patch, preRelease, build, t1, exception, _null = null,
        _s17_ = 'Could not parse "',
        match = $.$get$completeVersion().firstMatch$1(text);
      if (match == null)
        throw A.wrapException(A.FormatException$(_s17_ + text + '".', _null, _null));
      try {
        t1 = match._match[1];
        t1.toString;
        major = A.int_parse(t1, _null);
        t1 = match._match[2];
        t1.toString;
        minor = A.int_parse(t1, _null);
        t1 = match._match[3];
        t1.toString;
        patch = A.int_parse(t1, _null);
        preRelease = match._match[5];
        build = match._match[8];
        t1 = A.Version$_(major, minor, patch, preRelease, build, text);
        return t1;
      } catch (exception) {
        if (type$.FormatException._is(A.unwrapException(exception)))
          throw A.wrapException(A.FormatException$(_s17_ + text + '".', _null, _null));
        else
          throw exception;
      }
    },
    Version__splitParts(text) {
      var t1 = type$.MappedListIterable_String_Object;
      return A.List_List$of(new A.MappedListIterable(A._setArrayType(text.split("."), type$.JSArray_String), new A.Version__splitParts_closure(), t1), true, t1._eval$1("ListIterable.E"));
    },
    Version: function Version(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.major = t0;
      _.minor = t1;
      _.patch = t2;
      _.preRelease = t3;
      _.build = t4;
      _._version$_text = t5;
    },
    Version__splitParts_closure: function Version__splitParts_closure() {
    },
    VersionRange_VersionRange(includeMax, max) {
      return new A.VersionRange(null, max, false, true);
    },
    VersionRange: function VersionRange(t0, t1, t2, t3) {
      var _ = this;
      _.min = t0;
      _.max = t1;
      _.includeMin = t2;
      _.includeMax = t3;
    },
    CssMediaQuery_parseList(contents, interpolationMap, logger) {
      var t1 = A.SpanScanner$(contents, null);
      return new A.MediaQueryParser(t1, logger, interpolationMap).parse$0();
    },
    CssMediaQuery$type(type, conditions, modifier) {
      return new A.CssMediaQuery(modifier, type, true, conditions == null ? B.List_empty : A.List_List$unmodifiable(conditions, type$.String));
    },
    CssMediaQuery$condition(conditions, conjunction) {
      var t1 = A.List_List$unmodifiable(conditions, type$.String);
      if (t1.length > 1 && conjunction == null)
        A.throwExpression(A.ArgumentError$(string$.If_con, null));
      return new A.CssMediaQuery(null, null, conjunction !== false, t1);
    },
    CssMediaQuery: function CssMediaQuery(t0, t1, t2, t3) {
      var _ = this;
      _.modifier = t0;
      _.type = t1;
      _.conjunction = t2;
      _.conditions = t3;
    },
    _SingletonCssMediaQueryMergeResult: function _SingletonCssMediaQueryMergeResult(t0) {
      this._name = t0;
    },
    MediaQuerySuccessfulMergeResult: function MediaQuerySuccessfulMergeResult(t0) {
      this.query = t0;
    },
    ModifiableCssAtRule$($name, span, childless, value) {
      var t1 = A._setArrayType([], type$.JSArray_ModifiableCssNode);
      return new A.ModifiableCssAtRule($name, value, childless, span, new A.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode), t1);
    },
    ModifiableCssAtRule: function ModifiableCssAtRule(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.isChildless = t2;
      _.span = t3;
      _.children = t4;
      _._children = t5;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    ModifiableCssComment: function ModifiableCssComment(t0, t1) {
      var _ = this;
      _.text = t0;
      _.span = t1;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    ModifiableCssDeclaration$($name, value, span, parsedAsCustomProperty, valueSpanForMap) {
      var t2,
        t1 = valueSpanForMap == null ? value.span : valueSpanForMap;
      if (parsedAsCustomProperty)
        if (!J.startsWith$1$s($name.value, "--"))
          A.throwExpression(A.ArgumentError$(string$.parsed, null));
        else {
          t2 = value.value;
          if (!(t2 instanceof A.SassString))
            A.throwExpression(A.ArgumentError$(string$.If_par + value.toString$0(0) + "` of type " + A.getRuntimeTypeOfDartObject(t2).toString$0(0) + ").", null));
        }
      return new A.ModifiableCssDeclaration($name, value, parsedAsCustomProperty, t1, span);
    },
    ModifiableCssDeclaration: function ModifiableCssDeclaration(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.parsedAsCustomProperty = t2;
      _.valueSpanForMap = t3;
      _.span = t4;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    ModifiableCssImport: function ModifiableCssImport(t0, t1, t2) {
      var _ = this;
      _.url = t0;
      _.modifiers = t1;
      _.span = t2;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    ModifiableCssKeyframeBlock$(selector, span) {
      var t1 = A._setArrayType([], type$.JSArray_ModifiableCssNode);
      return new A.ModifiableCssKeyframeBlock(selector, span, new A.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode), t1);
    },
    ModifiableCssKeyframeBlock: function ModifiableCssKeyframeBlock(t0, t1, t2, t3) {
      var _ = this;
      _.selector = t0;
      _.span = t1;
      _.children = t2;
      _._children = t3;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    ModifiableCssMediaRule$(queries, span) {
      var t1 = A.List_List$unmodifiable(queries, type$.CssMediaQuery),
        t2 = A._setArrayType([], type$.JSArray_ModifiableCssNode);
      if (J.get$isEmpty$asx(queries))
        A.throwExpression(A.ArgumentError$value(queries, "queries", "may not be empty."));
      return new A.ModifiableCssMediaRule(t1, span, new A.UnmodifiableListView(t2, type$.UnmodifiableListView_ModifiableCssNode), t2);
    },
    ModifiableCssMediaRule: function ModifiableCssMediaRule(t0, t1, t2, t3) {
      var _ = this;
      _.queries = t0;
      _.span = t1;
      _.children = t2;
      _._children = t3;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    ModifiableCssNode: function ModifiableCssNode() {
    },
    ModifiableCssNode_hasFollowingSibling_closure: function ModifiableCssNode_hasFollowingSibling_closure() {
    },
    ModifiableCssParentNode: function ModifiableCssParentNode() {
    },
    ModifiableCssStyleRule$(_selector, span, fromPlainCss, originalSelector) {
      var t1 = A._setArrayType([], type$.JSArray_ModifiableCssNode);
      return new A.ModifiableCssStyleRule(_selector, originalSelector, span, fromPlainCss, new A.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode), t1);
    },
    ModifiableCssStyleRule: function ModifiableCssStyleRule(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._style_rule$_selector = t0;
      _.originalSelector = t1;
      _.span = t2;
      _.fromPlainCss = t3;
      _.children = t4;
      _._children = t5;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    ModifiableCssStylesheet$(span) {
      var t1 = A._setArrayType([], type$.JSArray_ModifiableCssNode);
      return new A.ModifiableCssStylesheet(span, new A.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode), t1);
    },
    ModifiableCssStylesheet: function ModifiableCssStylesheet(t0, t1, t2) {
      var _ = this;
      _.span = t0;
      _.children = t1;
      _._children = t2;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    ModifiableCssSupportsRule$(condition, span) {
      var t1 = A._setArrayType([], type$.JSArray_ModifiableCssNode);
      return new A.ModifiableCssSupportsRule(condition, span, new A.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode), t1);
    },
    ModifiableCssSupportsRule: function ModifiableCssSupportsRule(t0, t1, t2, t3) {
      var _ = this;
      _.condition = t0;
      _.span = t1;
      _.children = t2;
      _._children = t3;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    CssNode: function CssNode() {
    },
    CssParentNode: function CssParentNode() {
    },
    _IsInvisibleVisitor: function _IsInvisibleVisitor(t0, t1) {
      this.includeBogus = t0;
      this.includeComments = t1;
    },
    __IsInvisibleVisitor_Object_EveryCssVisitor: function __IsInvisibleVisitor_Object_EveryCssVisitor() {
    },
    CssStylesheet: function CssStylesheet(t0, t1) {
      this.children = t0;
      this.span = t1;
    },
    CssValue: function CssValue(t0, t1, t2) {
      this.value = t0;
      this.span = t1;
      this.$ti = t2;
    },
    _FakeAstNode: function _FakeAstNode(t0) {
      this._callback = t0;
    },
    Argument: function Argument(t0, t1, t2) {
      this.name = t0;
      this.defaultValue = t1;
      this.span = t2;
    },
    ArgumentDeclaration_ArgumentDeclaration$parse(contents, url) {
      return A.ScssParser$(contents, null, url).parseArgumentDeclaration$0();
    },
    ArgumentDeclaration: function ArgumentDeclaration(t0, t1, t2) {
      this.$arguments = t0;
      this.restArgument = t1;
      this.span = t2;
    },
    ArgumentDeclaration_verify_closure: function ArgumentDeclaration_verify_closure() {
    },
    ArgumentDeclaration_verify_closure0: function ArgumentDeclaration_verify_closure0() {
    },
    ArgumentInvocation$empty(span) {
      return new A.ArgumentInvocation(B.List_empty9, B.Map_empty6, null, null, span);
    },
    ArgumentInvocation: function ArgumentInvocation(t0, t1, t2, t3, t4) {
      var _ = this;
      _.positional = t0;
      _.named = t1;
      _.rest = t2;
      _.keywordRest = t3;
      _.span = t4;
    },
    AtRootQuery: function AtRootQuery(t0, t1, t2, t3) {
      var _ = this;
      _.include = t0;
      _.names = t1;
      _._all = t2;
      _._at_root_query$_rule = t3;
    },
    ConfiguredVariable: function ConfiguredVariable(t0, t1, t2, t3) {
      var _ = this;
      _.name = t0;
      _.expression = t1;
      _.isGuarded = t2;
      _.span = t3;
    },
    _IsCalculationSafeVisitor: function _IsCalculationSafeVisitor() {
    },
    _IsCalculationSafeVisitor_visitListExpression_closure: function _IsCalculationSafeVisitor_visitListExpression_closure(t0) {
      this.$this = t0;
    },
    BinaryOperationExpression: function BinaryOperationExpression(t0, t1, t2, t3) {
      var _ = this;
      _.operator = t0;
      _.left = t1;
      _.right = t2;
      _.allowsSlash = t3;
    },
    BinaryOperator: function BinaryOperator(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.operator = t1;
      _.precedence = t2;
      _.isAssociative = t3;
      _._name = t4;
    },
    BooleanExpression: function BooleanExpression(t0, t1) {
      this.value = t0;
      this.span = t1;
    },
    ColorExpression: function ColorExpression(t0, t1) {
      this.value = t0;
      this.span = t1;
    },
    FunctionExpression: function FunctionExpression(t0, t1, t2, t3, t4) {
      var _ = this;
      _.namespace = t0;
      _.name = t1;
      _.originalName = t2;
      _.$arguments = t3;
      _.span = t4;
    },
    IfExpression: function IfExpression(t0, t1) {
      this.$arguments = t0;
      this.span = t1;
    },
    InterpolatedFunctionExpression: function InterpolatedFunctionExpression(t0, t1, t2) {
      this.name = t0;
      this.$arguments = t1;
      this.span = t2;
    },
    ListExpression: function ListExpression(t0, t1, t2, t3) {
      var _ = this;
      _.contents = t0;
      _.separator = t1;
      _.hasBrackets = t2;
      _.span = t3;
    },
    ListExpression_toString_closure: function ListExpression_toString_closure(t0) {
      this.$this = t0;
    },
    MapExpression: function MapExpression(t0, t1) {
      this.pairs = t0;
      this.span = t1;
    },
    NullExpression: function NullExpression(t0) {
      this.span = t0;
    },
    NumberExpression: function NumberExpression(t0, t1, t2) {
      this.value = t0;
      this.unit = t1;
      this.span = t2;
    },
    ParenthesizedExpression: function ParenthesizedExpression(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    SelectorExpression: function SelectorExpression(t0) {
      this.span = t0;
    },
    StringExpression_quoteText(text) {
      var t1,
        quote = A.StringExpression__bestQuote(A._setArrayType([text], type$.JSArray_String)),
        buffer = new A.StringBuffer("");
      buffer._contents = "" + A.Primitives_stringFromCharCode(quote);
      A.StringExpression__quoteInnerText(text, quote, buffer, true);
      t1 = A.Primitives_stringFromCharCode(quote);
      t1 = buffer._contents += t1;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    StringExpression__quoteInnerText(text, quote, buffer, $static) {
      var t1, t2, i, _1_0, _0_0, t3, t4, t0;
      for (t1 = text.length, t2 = t1 - 1, i = 0; i < t1; ++i) {
        _1_0 = text.charCodeAt(i);
        if (_1_0 === 10 || _1_0 === 13 || _1_0 === 12) {
          buffer.writeCharCode$1(92);
          buffer.writeCharCode$1(97);
          if (i !== t2) {
            _0_0 = text.charCodeAt(i + 1);
            if (!(_0_0 === 32 || _0_0 === 9 || _0_0 === 10 || _0_0 === 13 || _0_0 === 12))
              if (!(_0_0 >= 48 && _0_0 <= 57))
                if (!(_0_0 >= 97 && _0_0 <= 102))
                  t3 = _0_0 >= 65 && _0_0 <= 70;
                else
                  t3 = true;
              else
                t3 = true;
            else
              t3 = true;
            if (t3)
              buffer.writeCharCode$1(32);
          }
          continue;
        }
        t3 = 92 === _1_0;
        if (t3)
          t4 = _1_0;
        else
          t4 = null;
        if (!t3) {
          t3 = _1_0 === quote;
          if (t3)
            t4 = _1_0;
          t0 = t4;
          t4 = t3;
          t3 = t0;
          if (!t4)
            if (35 === _1_0)
              if ($static)
                if (i < t2) {
                  t4 = text.charCodeAt(i + 1) === 123;
                  if (t4)
                    t3 = _1_0;
                } else
                  t4 = false;
              else
                t4 = false;
            else
              t4 = false;
          else
            t4 = true;
        } else {
          t3 = t4;
          t4 = true;
        }
        if (t4) {
          buffer.writeCharCode$1(92);
          buffer.writeCharCode$1(t3);
          continue;
        }
        buffer.writeCharCode$1(_1_0);
      }
    },
    StringExpression__bestQuote(strings) {
      var t1, t2, t3, containsDoubleQuote, t4, t5;
      for (t1 = J.get$iterator$ax(strings), t2 = type$.CodeUnits, t3 = t2._eval$1("ListIterator<ListBase.E>"), t2 = t2._eval$1("ListBase.E"), containsDoubleQuote = false; t1.moveNext$0();)
        for (t4 = new A.CodeUnits(t1.get$current(t1)), t4 = new A.ListIterator(t4, t4.get$length(0), t3); t4.moveNext$0();) {
          t5 = t4.__internal$_current;
          if (t5 == null)
            t5 = t2._as(t5);
          if (t5 === 39)
            return 34;
          if (t5 === 34)
            containsDoubleQuote = true;
        }
      return containsDoubleQuote ? 39 : 34;
    },
    StringExpression: function StringExpression(t0, t1) {
      this.text = t0;
      this.hasQuotes = t1;
    },
    SupportsExpression: function SupportsExpression(t0) {
      this.condition = t0;
    },
    UnaryOperationExpression: function UnaryOperationExpression(t0, t1, t2) {
      this.operator = t0;
      this.operand = t1;
      this.span = t2;
    },
    UnaryOperator: function UnaryOperator(t0, t1, t2) {
      this.name = t0;
      this.operator = t1;
      this._name = t2;
    },
    ValueExpression: function ValueExpression(t0, t1) {
      this.value = t0;
      this.span = t1;
    },
    VariableExpression: function VariableExpression(t0, t1, t2) {
      this.namespace = t0;
      this.name = t1;
      this.span = t2;
    },
    DynamicImport: function DynamicImport(t0, t1) {
      this.urlString = t0;
      this.span = t1;
    },
    StaticImport: function StaticImport(t0, t1, t2) {
      this.url = t0;
      this.modifiers = t1;
      this.span = t2;
    },
    Interpolation$(contents, span) {
      var t1 = new A.Interpolation(A.List_List$unmodifiable(contents, type$.Object), span);
      t1.Interpolation$2(contents, span);
      return t1;
    },
    Interpolation: function Interpolation(t0, t1) {
      this.contents = t0;
      this.span = t1;
    },
    Interpolation_toString_closure: function Interpolation_toString_closure() {
    },
    AtRootRule$(children, span, query) {
      var t1 = A.List_List$unmodifiable(children, type$.Statement),
        t2 = B.JSArray_methods.any$1(t1, new A.ParentStatement_closure());
      return new A.AtRootRule(query, span, t1, t2);
    },
    AtRootRule: function AtRootRule(t0, t1, t2, t3) {
      var _ = this;
      _.query = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    AtRule$($name, span, children, value) {
      var t1 = children == null ? null : A.List_List$unmodifiable(children, type$.Statement),
        t2 = t1 == null ? null : B.JSArray_methods.any$1(t1, new A.ParentStatement_closure());
      return new A.AtRule($name, value, span, t1, t2 === true);
    },
    AtRule: function AtRule(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    CallableDeclaration: function CallableDeclaration() {
    },
    ContentBlock$($arguments, children, span) {
      var _s8_ = "@content",
        t1 = A.stringReplaceAllUnchecked(_s8_, "_", "-"),
        t2 = A.List_List$unmodifiable(children, type$.Statement),
        t3 = B.JSArray_methods.any$1(t2, new A.ParentStatement_closure());
      return new A.ContentBlock(t1, _s8_, $arguments, span, t2, t3);
    },
    ContentBlock: function ContentBlock(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.name = t0;
      _.originalName = t1;
      _.$arguments = t2;
      _.span = t3;
      _.children = t4;
      _.hasDeclarations = t5;
    },
    ContentRule: function ContentRule(t0, t1) {
      this.$arguments = t0;
      this.span = t1;
    },
    DebugRule: function DebugRule(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    Declaration$($name, value, span) {
      return new A.Declaration($name, value, span, null, false);
    },
    Declaration$nested($name, children, span, value) {
      var t1 = A.List_List$unmodifiable(children, type$.Statement),
        t2 = B.JSArray_methods.any$1(t1, new A.ParentStatement_closure());
      return new A.Declaration($name, value, span, t1, t2);
    },
    Declaration: function Declaration(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    EachRule$(variables, list, children, span) {
      var t1 = A.List_List$unmodifiable(variables, type$.String),
        t2 = A.List_List$unmodifiable(children, type$.Statement),
        t3 = B.JSArray_methods.any$1(t2, new A.ParentStatement_closure());
      return new A.EachRule(t1, list, span, t2, t3);
    },
    EachRule: function EachRule(t0, t1, t2, t3, t4) {
      var _ = this;
      _.variables = t0;
      _.list = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    EachRule_toString_closure: function EachRule_toString_closure() {
    },
    ErrorRule: function ErrorRule(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    ExtendRule: function ExtendRule(t0, t1, t2) {
      this.selector = t0;
      this.isOptional = t1;
      this.span = t2;
    },
    ForRule$(variable, from, to, children, span, exclusive) {
      var t1 = A.List_List$unmodifiable(children, type$.Statement),
        t2 = B.JSArray_methods.any$1(t1, new A.ParentStatement_closure());
      return new A.ForRule(variable, from, to, exclusive, span, t1, t2);
    },
    ForRule: function ForRule(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.variable = t0;
      _.from = t1;
      _.to = t2;
      _.isExclusive = t3;
      _.span = t4;
      _.children = t5;
      _.hasDeclarations = t6;
    },
    ForwardRule: function ForwardRule(t0, t1, t2, t3, t4, t5, t6, t7) {
      var _ = this;
      _.url = t0;
      _.shownMixinsAndFunctions = t1;
      _.shownVariables = t2;
      _.hiddenMixinsAndFunctions = t3;
      _.hiddenVariables = t4;
      _.prefix = t5;
      _.configuration = t6;
      _.span = t7;
    },
    FunctionRule$($name, $arguments, children, span, comment) {
      var t1 = A.stringReplaceAllUnchecked($name, "_", "-"),
        t2 = A.List_List$unmodifiable(children, type$.Statement),
        t3 = B.JSArray_methods.any$1(t2, new A.ParentStatement_closure());
      return new A.FunctionRule(t1, $name, $arguments, span, t2, t3);
    },
    FunctionRule: function FunctionRule(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.name = t0;
      _.originalName = t1;
      _.$arguments = t2;
      _.span = t3;
      _.children = t4;
      _.hasDeclarations = t5;
    },
    IfClause$(expression, children) {
      var t1 = A.List_List$unmodifiable(children, type$.Statement);
      return new A.IfClause(expression, t1, B.JSArray_methods.any$1(t1, new A.IfRuleClause$__closure()));
    },
    ElseClause$(children) {
      var t1 = A.List_List$unmodifiable(children, type$.Statement);
      return new A.ElseClause(t1, B.JSArray_methods.any$1(t1, new A.IfRuleClause$__closure()));
    },
    IfRule: function IfRule(t0, t1, t2) {
      this.clauses = t0;
      this.lastClause = t1;
      this.span = t2;
    },
    IfRule_toString_closure: function IfRule_toString_closure() {
    },
    IfRuleClause: function IfRuleClause() {
    },
    IfRuleClause$__closure: function IfRuleClause$__closure() {
    },
    IfRuleClause$___closure: function IfRuleClause$___closure() {
    },
    IfClause: function IfClause(t0, t1, t2) {
      this.expression = t0;
      this.children = t1;
      this.hasDeclarations = t2;
    },
    ElseClause: function ElseClause(t0, t1) {
      this.children = t0;
      this.hasDeclarations = t1;
    },
    ImportRule: function ImportRule(t0, t1) {
      this.imports = t0;
      this.span = t1;
    },
    IncludeRule: function IncludeRule(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.namespace = t0;
      _.name = t1;
      _.originalName = t2;
      _.$arguments = t3;
      _.content = t4;
      _.span = t5;
    },
    LoudComment: function LoudComment(t0) {
      this.text = t0;
    },
    MediaRule$(query, children, span) {
      var t1 = A.List_List$unmodifiable(children, type$.Statement),
        t2 = B.JSArray_methods.any$1(t1, new A.ParentStatement_closure());
      return new A.MediaRule(query, span, t1, t2);
    },
    MediaRule: function MediaRule(t0, t1, t2, t3) {
      var _ = this;
      _.query = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    MixinRule$($name, $arguments, children, span, comment) {
      var t1 = A.stringReplaceAllUnchecked($name, "_", "-"),
        t2 = A.List_List$unmodifiable(children, type$.Statement),
        t3 = B.JSArray_methods.any$1(t2, new A.ParentStatement_closure());
      return new A.MixinRule(t1, $name, $arguments, span, t2, t3);
    },
    MixinRule: function MixinRule(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.__MixinRule_hasContent_FI = $;
      _.name = t0;
      _.originalName = t1;
      _.$arguments = t2;
      _.span = t3;
      _.children = t4;
      _.hasDeclarations = t5;
    },
    _HasContentVisitor: function _HasContentVisitor() {
    },
    __HasContentVisitor_Object_StatementSearchVisitor: function __HasContentVisitor_Object_StatementSearchVisitor() {
    },
    ParentStatement: function ParentStatement() {
    },
    ParentStatement_closure: function ParentStatement_closure() {
    },
    ParentStatement__closure: function ParentStatement__closure() {
    },
    ReturnRule: function ReturnRule(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    SilentComment: function SilentComment(t0, t1) {
      this.text = t0;
      this.span = t1;
    },
    StyleRule$(selector, children, span) {
      var t1 = A.List_List$unmodifiable(children, type$.Statement),
        t2 = B.JSArray_methods.any$1(t1, new A.ParentStatement_closure());
      return new A.StyleRule(selector, span, t1, t2);
    },
    StyleRule: function StyleRule(t0, t1, t2, t3) {
      var _ = this;
      _.selector = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    Stylesheet$(children, span) {
      var t1 = A._setArrayType([], type$.JSArray_UseRule),
        t2 = A._setArrayType([], type$.JSArray_ForwardRule),
        t3 = A.List_List$unmodifiable(children, type$.Statement),
        t4 = B.JSArray_methods.any$1(t3, new A.ParentStatement_closure());
      t1 = new A.Stylesheet(span, false, t1, t2, t3, t4);
      t1.Stylesheet$internal$3$plainCss(children, span, false);
      return t1;
    },
    Stylesheet$internal(children, span, plainCss) {
      var t1 = A._setArrayType([], type$.JSArray_UseRule),
        t2 = A._setArrayType([], type$.JSArray_ForwardRule),
        t3 = A.List_List$unmodifiable(children, type$.Statement),
        t4 = B.JSArray_methods.any$1(t3, new A.ParentStatement_closure());
      t1 = new A.Stylesheet(span, plainCss, t1, t2, t3, t4);
      t1.Stylesheet$internal$3$plainCss(children, span, plainCss);
      return t1;
    },
    Stylesheet_Stylesheet$parse(contents, syntax, logger, url) {
      var error, stackTrace, url0, t1, exception, t2;
      try {
        switch (syntax) {
          case B.Syntax_Sass_sass:
            t1 = A.SpanScanner$(contents, url);
            t1 = new A.SassParser(A.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.VariableDeclaration), t1, logger, null).parse$0();
            return t1;
          case B.Syntax_SCSS_scss:
            t1 = A.ScssParser$(contents, logger, url).parse$0();
            return t1;
          case B.Syntax_CSS_css:
            t1 = A.SpanScanner$(contents, url);
            t1 = new A.CssParser(A.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.VariableDeclaration), t1, logger, null).parse$0();
            return t1;
          default:
            t1 = A.ArgumentError$("Unknown syntax " + syntax.toString$0(0) + ".", null);
            throw A.wrapException(t1);
        }
      } catch (exception) {
        t1 = A.unwrapException(exception);
        if (t1 instanceof A.SassException) {
          error = t1;
          stackTrace = A.getTraceFromException(exception);
          t1 = error;
          t2 = J.getInterceptor$z(t1);
          t1 = A.SourceSpanException.prototype.get$span.call(t2, t1);
          url0 = t1.get$sourceUrl(t1);
          if (url0 == null || J.toString$0$(url0) === "stdin")
            throw exception;
          t1 = type$.Uri;
          throw A.wrapException(A.throwWithTrace(error.withLoadedUrls$1(A.Set_Set$unmodifiable(A.LinkedHashSet_LinkedHashSet$_literal([url0], t1), t1)), error, stackTrace));
        } else
          throw exception;
      }
    },
    Stylesheet: function Stylesheet(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.span = t0;
      _.plainCss = t1;
      _._uses = t2;
      _._forwards = t3;
      _.children = t4;
      _.hasDeclarations = t5;
    },
    SupportsRule$(condition, children, span) {
      var t1 = A.List_List$unmodifiable(children, type$.Statement),
        t2 = B.JSArray_methods.any$1(t1, new A.ParentStatement_closure());
      return new A.SupportsRule(condition, span, t1, t2);
    },
    SupportsRule: function SupportsRule(t0, t1, t2, t3) {
      var _ = this;
      _.condition = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    UseRule: function UseRule(t0, t1, t2, t3) {
      var _ = this;
      _.url = t0;
      _.namespace = t1;
      _.configuration = t2;
      _.span = t3;
    },
    VariableDeclaration$($name, expression, span, comment, global, guarded, namespace) {
      if (namespace != null && global)
        A.throwExpression(A.ArgumentError$(string$.Other_, null));
      return new A.VariableDeclaration(namespace, $name, expression, guarded, global, span);
    },
    VariableDeclaration: function VariableDeclaration(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.namespace = t0;
      _.name = t1;
      _.expression = t2;
      _.isGuarded = t3;
      _.isGlobal = t4;
      _.span = t5;
    },
    WarnRule: function WarnRule(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    WhileRule$(condition, children, span) {
      var t1 = A.List_List$unmodifiable(children, type$.Statement),
        t2 = B.JSArray_methods.any$1(t1, new A.ParentStatement_closure());
      return new A.WhileRule(condition, span, t1, t2);
    },
    WhileRule: function WhileRule(t0, t1, t2, t3) {
      var _ = this;
      _.condition = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    SupportsAnything: function SupportsAnything(t0, t1) {
      this.contents = t0;
      this.span = t1;
    },
    SupportsDeclaration: function SupportsDeclaration(t0, t1, t2) {
      this.name = t0;
      this.value = t1;
      this.span = t2;
    },
    SupportsFunction: function SupportsFunction(t0, t1, t2) {
      this.name = t0;
      this.$arguments = t1;
      this.span = t2;
    },
    SupportsInterpolation: function SupportsInterpolation(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    SupportsNegation: function SupportsNegation(t0, t1) {
      this.condition = t0;
      this.span = t1;
    },
    SupportsOperation$(left, right, operator, span) {
      var lowerOperator = operator.toLowerCase();
      if (lowerOperator !== "and" && lowerOperator !== "or")
        A.throwExpression(A.ArgumentError$value(operator, "operator", 'may only be "and" or "or".'));
      return new A.SupportsOperation(left, right, operator, span);
    },
    SupportsOperation: function SupportsOperation(t0, t1, t2, t3) {
      var _ = this;
      _.left = t0;
      _.right = t1;
      _.operator = t2;
      _.span = t3;
    },
    Selector: function Selector() {
    },
    _IsInvisibleVisitor0: function _IsInvisibleVisitor0(t0) {
      this.includeBogus = t0;
    },
    _IsBogusVisitor: function _IsBogusVisitor(t0) {
      this.includeLeadingCombinator = t0;
    },
    _IsBogusVisitor_visitComplexSelector_closure: function _IsBogusVisitor_visitComplexSelector_closure(t0) {
      this.$this = t0;
    },
    _IsUselessVisitor: function _IsUselessVisitor() {
    },
    _IsUselessVisitor_visitComplexSelector_closure: function _IsUselessVisitor_visitComplexSelector_closure(t0) {
      this.$this = t0;
    },
    __IsBogusVisitor_Object_AnySelectorVisitor: function __IsBogusVisitor_Object_AnySelectorVisitor() {
    },
    __IsInvisibleVisitor_Object_AnySelectorVisitor: function __IsInvisibleVisitor_Object_AnySelectorVisitor() {
    },
    __IsUselessVisitor_Object_AnySelectorVisitor: function __IsUselessVisitor_Object_AnySelectorVisitor() {
    },
    AttributeSelector: function AttributeSelector(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.op = t1;
      _.value = t2;
      _.modifier = t3;
      _.span = t4;
    },
    AttributeOperator: function AttributeOperator(t0, t1) {
      this._attribute$_text = t0;
      this._name = t1;
    },
    ClassSelector: function ClassSelector(t0, t1) {
      this.name = t0;
      this.span = t1;
    },
    Combinator: function Combinator(t0, t1) {
      this._combinator$_text = t0;
      this._name = t1;
    },
    ComplexSelector$(leadingCombinators, components, span, lineBreak) {
      var t1 = A.List_List$unmodifiable(leadingCombinators, type$.CssValue_Combinator),
        t2 = A.List_List$unmodifiable(components, type$.ComplexSelectorComponent);
      if (t1.length === 0 && t2.length === 0)
        A.throwExpression(A.ArgumentError$(string$.leadin, null));
      return new A.ComplexSelector(t1, t2, lineBreak, span);
    },
    ComplexSelector: function ComplexSelector(t0, t1, t2, t3) {
      var _ = this;
      _.leadingCombinators = t0;
      _.components = t1;
      _.lineBreak = t2;
      _.__ComplexSelector_specificity_FI = $;
      _.span = t3;
    },
    ComplexSelector_specificity_closure: function ComplexSelector_specificity_closure() {
    },
    ComplexSelectorComponent: function ComplexSelectorComponent(t0, t1, t2) {
      this.selector = t0;
      this.combinators = t1;
      this.span = t2;
    },
    ComplexSelectorComponent_toString_closure: function ComplexSelectorComponent_toString_closure() {
    },
    CompoundSelector$(components, span) {
      var t1 = A.List_List$unmodifiable(components, type$.SimpleSelector);
      if (t1.length === 0)
        A.throwExpression(A.ArgumentError$("components may not be empty.", null));
      return new A.CompoundSelector(t1, span);
    },
    CompoundSelector: function CompoundSelector(t0, t1) {
      var _ = this;
      _.components = t0;
      _.__CompoundSelector_hasComplicatedSuperselectorSemantics_FI = _.__CompoundSelector_specificity_FI = $;
      _.span = t1;
    },
    CompoundSelector_specificity_closure: function CompoundSelector_specificity_closure() {
    },
    CompoundSelector_hasComplicatedSuperselectorSemantics_closure: function CompoundSelector_hasComplicatedSuperselectorSemantics_closure() {
    },
    IDSelector: function IDSelector(t0, t1) {
      this.name = t0;
      this.span = t1;
    },
    IDSelector_unify_closure: function IDSelector_unify_closure(t0) {
      this.$this = t0;
    },
    SelectorList$(components, span) {
      var t1 = A.List_List$unmodifiable(components, type$.ComplexSelector);
      if (t1.length === 0)
        A.throwExpression(A.ArgumentError$("components may not be empty.", null));
      return new A.SelectorList(t1, span);
    },
    SelectorList_SelectorList$parse(contents, allowParent, interpolationMap, logger, plainCss) {
      return A.SelectorParser$(contents, allowParent, interpolationMap, logger, plainCss, null).parse$0();
    },
    SelectorList: function SelectorList(t0, t1) {
      this.components = t0;
      this.span = t1;
    },
    SelectorList_asSassList_closure: function SelectorList_asSassList_closure() {
    },
    SelectorList_nestWithin_closure: function SelectorList_nestWithin_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.preserveParentSelectors = t1;
      _.implicitParent = t2;
      _.parent = t3;
    },
    SelectorList_nestWithin__closure: function SelectorList_nestWithin__closure(t0) {
      this.complex = t0;
    },
    SelectorList_nestWithin__closure0: function SelectorList_nestWithin__closure0(t0) {
      this.complex = t0;
    },
    SelectorList__nestWithinCompound_closure: function SelectorList__nestWithinCompound_closure() {
    },
    SelectorList__nestWithinCompound_closure0: function SelectorList__nestWithinCompound_closure0(t0) {
      this.parent = t0;
    },
    SelectorList__nestWithinCompound_closure1: function SelectorList__nestWithinCompound_closure1(t0, t1, t2) {
      this.parentSelector = t0;
      this.resolvedSimples = t1;
      this.component = t2;
    },
    SelectorList_withAdditionalCombinators_closure: function SelectorList_withAdditionalCombinators_closure(t0) {
      this.combinators = t0;
    },
    _ParentSelectorVisitor: function _ParentSelectorVisitor() {
    },
    __ParentSelectorVisitor_Object_SelectorSearchVisitor: function __ParentSelectorVisitor_Object_SelectorSearchVisitor() {
    },
    ParentSelector: function ParentSelector(t0, t1) {
      this.suffix = t0;
      this.span = t1;
    },
    PlaceholderSelector: function PlaceholderSelector(t0, t1) {
      this.name = t0;
      this.span = t1;
    },
    PseudoSelector$($name, span, argument, element, selector) {
      var t1 = !element,
        t2 = t1 && !A.PseudoSelector__isFakePseudoElement($name);
      return new A.PseudoSelector($name, A.unvendor($name), t2, t1, argument, selector, span);
    },
    PseudoSelector__isFakePseudoElement($name) {
      switch ($name.charCodeAt(0)) {
        case 97:
        case 65:
          return A.equalsIgnoreCase($name, "after");
        case 98:
        case 66:
          return A.equalsIgnoreCase($name, "before");
        case 102:
        case 70:
          return A.equalsIgnoreCase($name, "first-line") || A.equalsIgnoreCase($name, "first-letter");
        default:
          return false;
      }
    },
    PseudoSelector: function PseudoSelector(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.name = t0;
      _.normalizedName = t1;
      _.isClass = t2;
      _.isSyntacticClass = t3;
      _.argument = t4;
      _.selector = t5;
      _.__PseudoSelector_specificity_FI = $;
      _.span = t6;
    },
    PseudoSelector_specificity_closure: function PseudoSelector_specificity_closure(t0) {
      this.$this = t0;
    },
    PseudoSelector_specificity__closure: function PseudoSelector_specificity__closure() {
    },
    PseudoSelector_specificity__closure0: function PseudoSelector_specificity__closure0() {
    },
    PseudoSelector_unify_closure: function PseudoSelector_unify_closure() {
    },
    QualifiedName: function QualifiedName(t0, t1) {
      this.name = t0;
      this.namespace = t1;
    },
    SimpleSelector: function SimpleSelector() {
    },
    SimpleSelector_isSuperselector_closure: function SimpleSelector_isSuperselector_closure(t0) {
      this.$this = t0;
    },
    SimpleSelector_isSuperselector__closure: function SimpleSelector_isSuperselector__closure(t0) {
      this.$this = t0;
    },
    TypeSelector: function TypeSelector(t0, t1) {
      this.name = t0;
      this.span = t1;
    },
    UniversalSelector: function UniversalSelector(t0, t1) {
      this.namespace = t0;
      this.span = t1;
    },
    compileAsync(path, charset, fatalDeprecations, futureDeprecations, importCache, logger, quietDeps, silenceDeprecations, sourceMap, style, syntax, verbose) {
      var $async$goto = 0,
        $async$completer = A._makeAsyncAwaitCompleter(type$.CompileResult),
        $async$returnValue, t3, t0, stylesheet, result, t1, t2;
      var $async$compileAsync = A._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return A._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = type$.Deprecation;
              t2 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
              t2.addAll$1(0, silenceDeprecations);
              t3 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
              t3.addAll$1(0, fatalDeprecations);
              t1 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
              t1.addAll$1(0, futureDeprecations);
              logger = A.DeprecationProcessingLogger$(logger, t3, t1, !verbose, t2);
              t1 = syntax === A.Syntax_forPath(path);
              $async$goto = t1 ? 3 : 5;
              break;
            case 3:
              // then
              t1 = $.$get$FilesystemImporter_cwd();
              t2 = A.isNodeJs() ? self.process : null;
              if (!J.$eq$(t2 == null ? null : J.get$platform$x(t2), "win32")) {
                t2 = A.isNodeJs() ? self.process : null;
                t2 = J.$eq$(t2 == null ? null : J.get$platform$x(t2), "darwin");
              } else
                t2 = true;
              if (t2) {
                t2 = $.$get$context();
                t3 = A._realCasePath(A.absolute(t2.normalize$1(path), null, null, null, null, null, null, null, null, null, null, null, null, null, null));
                t0 = t3;
                t3 = t2;
                t2 = t0;
              } else {
                t2 = $.$get$context();
                t3 = t2.canonicalize$1(0, path);
                t0 = t3;
                t3 = t2;
                t2 = t0;
              }
              $async$goto = 6;
              return A._asyncAwait(importCache.importCanonical$3$originalUrl(t1, t3.toUri$1(t2), t3.toUri$1(path)), $async$compileAsync);
            case 6:
              // returning from await.
              t3 = $async$result;
              t3.toString;
              stylesheet = t3;
              // goto join
              $async$goto = 4;
              break;
            case 5:
              // else
              t1 = A.readFile(path);
              stylesheet = A.Stylesheet_Stylesheet$parse(t1, syntax, logger, $.$get$context().toUri$1(path));
            case 4:
              // join
              $async$goto = 7;
              return A._asyncAwait(A._compileStylesheet0(stylesheet, logger, importCache, null, $.$get$FilesystemImporter_cwd(), null, style, true, null, null, quietDeps, sourceMap, charset), $async$compileAsync);
            case 7:
              // returning from await.
              result = $async$result;
              logger.summarize$1$js(false);
              $async$returnValue = result;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return A._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return A._asyncStartSync($async$compileAsync, $async$completer);
    },
    compileStringAsync(source, charset, fatalDeprecations, futureDeprecations, importCache, importer, logger, quietDeps, silenceDeprecations, sourceMap, style, syntax, verbose) {
      var $async$goto = 0,
        $async$completer = A._makeAsyncAwaitCompleter(type$.CompileResult),
        $async$returnValue, t3, stylesheet, result, t1, t2;
      var $async$compileStringAsync = A._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return A._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = type$.Deprecation;
              t2 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
              t2.addAll$1(0, silenceDeprecations);
              t3 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
              t3.addAll$1(0, fatalDeprecations);
              t1 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
              t1.addAll$1(0, futureDeprecations);
              logger = A.DeprecationProcessingLogger$(logger, t3, t1, !verbose, t2);
              stylesheet = A.Stylesheet_Stylesheet$parse(source, syntax, logger, null);
              $async$goto = 3;
              return A._asyncAwait(A._compileStylesheet0(stylesheet, logger, importCache, null, importer, null, style, true, null, null, quietDeps, sourceMap, charset), $async$compileStringAsync);
            case 3:
              // returning from await.
              result = $async$result;
              logger.summarize$1$js(false);
              $async$returnValue = result;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return A._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return A._asyncStartSync($async$compileStringAsync, $async$completer);
    },
    _compileStylesheet0(stylesheet, logger, importCache, nodeImporter, importer, functions, style, useSpaces, indentWidth, lineFeed, quietDeps, sourceMap, charset) {
      var $async$goto = 0,
        $async$completer = A._makeAsyncAwaitCompleter(type$.CompileResult),
        $async$returnValue, serializeResult, resultSourceMap, $async$temp1;
      var $async$_compileStylesheet0 = A._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return A._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              $async$temp1 = A;
              $async$goto = 3;
              return A._asyncAwait(A._EvaluateVisitor$0(functions, importCache, logger, nodeImporter, quietDeps, sourceMap).run$2(0, importer, stylesheet), $async$_compileStylesheet0);
            case 3:
              // returning from await.
              serializeResult = $async$temp1.serialize($async$result._1, charset, indentWidth, false, lineFeed, sourceMap, style, true);
              resultSourceMap = serializeResult._1;
              if (resultSourceMap != null)
                A.mapInPlace(resultSourceMap.urls, new A._compileStylesheet_closure0(stylesheet, importCache));
              $async$returnValue = new A.CompileResult(serializeResult);
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return A._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return A._asyncStartSync($async$_compileStylesheet0, $async$completer);
    },
    _compileStylesheet_closure0: function _compileStylesheet_closure0(t0, t1) {
      this.stylesheet = t0;
      this.importCache = t1;
    },
    AsyncEnvironment$() {
      var t1 = type$.String,
        t2 = type$.Module_AsyncCallable,
        t3 = type$.AstNode,
        t4 = type$.int,
        t5 = type$.AsyncCallable,
        t6 = type$.JSArray_Map_String_AsyncCallable;
      return new A.AsyncEnvironment(A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), A.LinkedHashMap_LinkedHashMap$_empty(t1, t3), A.LinkedHashMap_LinkedHashMap$_empty(t2, t3), A.LinkedHashMap_LinkedHashMap$_empty(t2, t3), null, null, A._setArrayType([], type$.JSArray_Module_AsyncCallable), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Value)], type$.JSArray_Map_String_Value), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, t3)], type$.JSArray_Map_String_AstNode), A.LinkedHashMap_LinkedHashMap$_empty(t1, t4), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), A.LinkedHashMap_LinkedHashMap$_empty(t1, t4), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), A.LinkedHashMap_LinkedHashMap$_empty(t1, t4), null);
    },
    AsyncEnvironment$_(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, _functions, _mixins, _content) {
      var t1 = type$.String,
        t2 = type$.int;
      return new A.AsyncEnvironment(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _functions, A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _mixins, A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _content);
    },
    _EnvironmentModule__EnvironmentModule0(environment, css, preModuleComments, extensionStore, forwarded) {
      var t1, t2, t3, t4, t5, t6, module, result, t7;
      if (forwarded == null)
        forwarded = B.Set_empty2;
      t1 = type$.dynamic;
      t1 = A.LinkedHashMap_LinkedHashMap$_empty(t1, t1);
      for (t2 = type$.Module_AsyncCallable, t3 = type$.List_CssComment, t4 = A.MapExtensions_get_pairs(preModuleComments, t2, t3), t4 = t4.get$iterator(t4), t5 = type$.CssComment; t4.moveNext$0();) {
        t6 = t4.get$current(t4);
        module = t6._0;
        result = A.List_List$from(t6._1, false, t5);
        result.fixed$length = Array;
        result.immutable$list = Array;
        t1.$indexSet(0, module, result);
      }
      t1 = A.ConstantMap_ConstantMap$from(t1, t2, t3);
      t2 = A._EnvironmentModule__makeModulesByVariable0(forwarded);
      t3 = A._EnvironmentModule__memberMap0(B.JSArray_methods.get$first(environment._async_environment$_variables), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure5(), type$.Map_String_Value), type$.Value);
      t4 = A._EnvironmentModule__memberMap0(B.JSArray_methods.get$first(environment._async_environment$_variableNodes), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure6(), type$.Map_String_AstNode), type$.AstNode);
      t5 = type$.Map_String_AsyncCallable;
      t6 = type$.AsyncCallable;
      t7 = A._EnvironmentModule__memberMap0(B.JSArray_methods.get$first(environment._async_environment$_functions), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure7(), t5), t6);
      t6 = A._EnvironmentModule__memberMap0(B.JSArray_methods.get$first(environment._async_environment$_mixins), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure8(), t5), t6);
      t5 = J.get$isNotEmpty$asx(css.get$children(css)) || preModuleComments.get$isNotEmpty(preModuleComments) || B.JSArray_methods.any$1(environment._async_environment$_allModules, new A._EnvironmentModule__EnvironmentModule_closure9());
      return A._EnvironmentModule$_0(environment, css, t1, extensionStore, t2, t3, t4, t7, t6, t5, !extensionStore.get$isEmpty(extensionStore) || B.JSArray_methods.any$1(environment._async_environment$_allModules, new A._EnvironmentModule__EnvironmentModule_closure10()));
    },
    _EnvironmentModule__makeModulesByVariable0(forwarded) {
      var modulesByVariable, t1, t2, t3, t4, t5;
      if (forwarded.get$isEmpty(forwarded))
        return B.Map_empty8;
      modulesByVariable = A.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.Module_AsyncCallable);
      for (t1 = forwarded.get$iterator(forwarded); t1.moveNext$0();) {
        t2 = t1.get$current(t1);
        if (t2 instanceof A._EnvironmentModule0) {
          for (t3 = t2._async_environment$_modulesByVariable, t3 = t3.get$values(t3), t3 = t3.get$iterator(t3); t3.moveNext$0();) {
            t4 = t3.get$current(t3);
            t5 = t4.get$variables();
            A.setAll(modulesByVariable, t5.get$keys(t5), t4);
          }
          A.setAll(modulesByVariable, J.get$keys$z(B.JSArray_methods.get$first(t2._async_environment$_environment._async_environment$_variables)), t2);
        } else {
          t3 = t2.get$variables();
          A.setAll(modulesByVariable, t3.get$keys(t3), t2);
        }
      }
      return modulesByVariable;
    },
    _EnvironmentModule__memberMap0(localMap, otherMaps, $V) {
      var t1, t2, t3;
      localMap = new A.PublicMemberMapView(localMap, $V._eval$1("PublicMemberMapView<0>"));
      if (otherMaps.get$isEmpty(otherMaps))
        return localMap;
      t1 = A._setArrayType([], $V._eval$1("JSArray<Map<String,0>>"));
      for (t2 = otherMaps.get$iterator(otherMaps); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        if (t3.get$isNotEmpty(t3))
          t1.push(t3);
      }
      t1.push(localMap);
      if (t1.length === 1)
        return localMap;
      return A.MergedMapView$(t1, type$.String, $V);
    },
    _EnvironmentModule$_0(_environment, css, preModuleComments, extensionStore, _modulesByVariable, variables, variableNodes, functions, mixins, transitivelyContainsCss, transitivelyContainsExtensions) {
      return new A._EnvironmentModule0(_environment._async_environment$_allModules, variables, variableNodes, functions, mixins, extensionStore, css, preModuleComments, transitivelyContainsCss, transitivelyContainsExtensions, _environment, _modulesByVariable);
    },
    AsyncEnvironment: function AsyncEnvironment(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) {
      var _ = this;
      _._async_environment$_modules = t0;
      _._async_environment$_namespaceNodes = t1;
      _._async_environment$_globalModules = t2;
      _._async_environment$_importedModules = t3;
      _._async_environment$_forwardedModules = t4;
      _._async_environment$_nestedForwardedModules = t5;
      _._async_environment$_allModules = t6;
      _._async_environment$_variables = t7;
      _._async_environment$_variableNodes = t8;
      _._async_environment$_variableIndices = t9;
      _._async_environment$_functions = t10;
      _._async_environment$_functionIndices = t11;
      _._async_environment$_mixins = t12;
      _._async_environment$_mixinIndices = t13;
      _._async_environment$_content = t14;
      _._async_environment$_inMixin = false;
      _._async_environment$_inSemiGlobalScope = true;
      _._async_environment$_lastVariableIndex = _._async_environment$_lastVariableName = null;
    },
    AsyncEnvironment__getVariableFromGlobalModule_closure: function AsyncEnvironment__getVariableFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    AsyncEnvironment_setVariable_closure: function AsyncEnvironment_setVariable_closure(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    AsyncEnvironment_setVariable_closure0: function AsyncEnvironment_setVariable_closure0(t0) {
      this.name = t0;
    },
    AsyncEnvironment_setVariable_closure1: function AsyncEnvironment_setVariable_closure1(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    AsyncEnvironment__getFunctionFromGlobalModule_closure: function AsyncEnvironment__getFunctionFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    AsyncEnvironment__getMixinFromGlobalModule_closure: function AsyncEnvironment__getMixinFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    AsyncEnvironment_toModule_closure: function AsyncEnvironment_toModule_closure() {
    },
    AsyncEnvironment_toDummyModule_closure: function AsyncEnvironment_toDummyModule_closure() {
    },
    _EnvironmentModule0: function _EnvironmentModule0(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11) {
      var _ = this;
      _.upstream = t0;
      _.variables = t1;
      _.variableNodes = t2;
      _.functions = t3;
      _.mixins = t4;
      _.extensionStore = t5;
      _.css = t6;
      _.preModuleComments = t7;
      _.transitivelyContainsCss = t8;
      _.transitivelyContainsExtensions = t9;
      _._async_environment$_environment = t10;
      _._async_environment$_modulesByVariable = t11;
    },
    _EnvironmentModule__EnvironmentModule_closure5: function _EnvironmentModule__EnvironmentModule_closure5() {
    },
    _EnvironmentModule__EnvironmentModule_closure6: function _EnvironmentModule__EnvironmentModule_closure6() {
    },
    _EnvironmentModule__EnvironmentModule_closure7: function _EnvironmentModule__EnvironmentModule_closure7() {
    },
    _EnvironmentModule__EnvironmentModule_closure8: function _EnvironmentModule__EnvironmentModule_closure8() {
    },
    _EnvironmentModule__EnvironmentModule_closure9: function _EnvironmentModule__EnvironmentModule_closure9() {
    },
    _EnvironmentModule__EnvironmentModule_closure10: function _EnvironmentModule__EnvironmentModule_closure10() {
    },
    AsyncImportCache__toImporters(importers, loadPaths, packageConfig) {
      var t1, t2, t3, t4, _i, path, _null = null,
        sassPath = A.getEnvironmentVariable("SASS_PATH");
      if (A.isBrowser()) {
        t1 = A._setArrayType([], type$.JSArray_AsyncImporter_2);
        B.JSArray_methods.addAll$1(t1, importers);
        return t1;
      }
      t1 = A._setArrayType([], type$.JSArray_AsyncImporter_2);
      B.JSArray_methods.addAll$1(t1, importers);
      for (t2 = J.get$iterator$ax(loadPaths); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        t1.push(new A.FilesystemImporter($.$get$context().absolute$15(t3, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null), false));
      }
      if (sassPath != null) {
        t2 = A.isNodeJs() ? self.process : _null;
        t3 = sassPath.split(J.$eq$(t2 == null ? _null : J.get$platform$x(t2), "win32") ? ";" : ":");
        t4 = t3.length;
        _i = 0;
        for (; _i < t4; ++_i) {
          path = t3[_i];
          t1.push(new A.FilesystemImporter($.$get$context().absolute$15(path, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null), false));
        }
      }
      return t1;
    },
    AsyncImportCache: function AsyncImportCache(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._async_import_cache$_importers = t0;
      _._async_import_cache$_logger = t1;
      _._async_import_cache$_canonicalizeCache = t2;
      _._async_import_cache$_perImporterCanonicalizeCache = t3;
      _._async_import_cache$_nonCanonicalRelativeUrls = t4;
      _._async_import_cache$_importCache = t5;
      _._async_import_cache$_resultsCache = t6;
    },
    AsyncImportCache_canonicalize_closure: function AsyncImportCache_canonicalize_closure(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.baseImporter = t1;
      _.resolvedUrl = t2;
      _.baseUrl = t3;
      _.forImport = t4;
      _.key = t5;
      _.url = t6;
    },
    AsyncImportCache__canonicalize_closure: function AsyncImportCache__canonicalize_closure(t0, t1) {
      this.importer = t0;
      this.url = t1;
    },
    AsyncImportCache_importCanonical_closure: function AsyncImportCache_importCanonical_closure(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _.originalUrl = t3;
      _.quiet = t4;
    },
    AsyncImportCache_humanize_closure: function AsyncImportCache_humanize_closure(t0) {
      this.canonicalUrl = t0;
    },
    AsyncImportCache_humanize_closure0: function AsyncImportCache_humanize_closure0() {
    },
    AsyncImportCache_humanize_closure1: function AsyncImportCache_humanize_closure1() {
    },
    AsyncImportCache_humanize_closure2: function AsyncImportCache_humanize_closure2(t0) {
      this.canonicalUrl = t0;
    },
    AsyncBuiltInCallable$mixin($name, $arguments, callback, acceptsContent, url) {
      return new A.AsyncBuiltInCallable($name, A.ScssParser$("@mixin " + $name + "(" + $arguments + ") {", null, url).parseArgumentDeclaration$0(), new A.AsyncBuiltInCallable$mixin_closure(callback), false);
    },
    AsyncBuiltInCallable: function AsyncBuiltInCallable(t0, t1, t2, t3) {
      var _ = this;
      _.name = t0;
      _._async_built_in$_arguments = t1;
      _._async_built_in$_callback = t2;
      _.acceptsContent = t3;
    },
    AsyncBuiltInCallable$mixin_closure: function AsyncBuiltInCallable$mixin_closure(t0) {
      this.callback = t0;
    },
    BuiltInCallable$function($name, $arguments, callback, url) {
      return new A.BuiltInCallable($name, A._setArrayType([new A._Record_2(A.ScssParser$("@function " + $name + "(" + $arguments + ") {", null, url).parseArgumentDeclaration$0(), callback)], type$.JSArray_Record_2_ArgumentDeclaration_and_Value_Function_List_Value), false);
    },
    BuiltInCallable$mixin($name, $arguments, callback, acceptsContent, url) {
      return new A.BuiltInCallable($name, A._setArrayType([new A._Record_2(A.ScssParser$("@mixin " + $name + "(" + $arguments + ") {", null, url).parseArgumentDeclaration$0(), new A.BuiltInCallable$mixin_closure(callback))], type$.JSArray_Record_2_ArgumentDeclaration_and_Value_Function_List_Value), acceptsContent);
    },
    BuiltInCallable$overloadedFunction($name, overloads) {
      var t2, t3, t4, t5, t6, args, callback,
        t1 = A._setArrayType([], type$.JSArray_Record_2_ArgumentDeclaration_and_Value_Function_List_Value);
      for (t2 = type$.String, t3 = A.MapExtensions_get_pairs(overloads, t2, type$.Value_Function_List_Value), t3 = t3.get$iterator(t3), t4 = "@function " + $name + "(", t5 = type$.VariableDeclaration; t3.moveNext$0();) {
        t6 = t3.get$current(t3);
        args = t6._0;
        callback = t6._1;
        t6 = A.SpanScanner$(t4 + args + ") {", null);
        t1.push(new A._Record_2(new A.ScssParser(A.LinkedHashMap_LinkedHashMap$_empty(t2, t5), t6, B.StderrLogger_false, null).parseArgumentDeclaration$0(), callback));
      }
      return new A.BuiltInCallable($name, t1, false);
    },
    BuiltInCallable: function BuiltInCallable(t0, t1, t2) {
      this.name = t0;
      this._overloads = t1;
      this.acceptsContent = t2;
    },
    BuiltInCallable$mixin_closure: function BuiltInCallable$mixin_closure(t0) {
      this.callback = t0;
    },
    PlainCssCallable: function PlainCssCallable(t0) {
      this.name = t0;
    },
    UserDefinedCallable: function UserDefinedCallable(t0, t1, t2, t3) {
      var _ = this;
      _.declaration = t0;
      _.environment = t1;
      _.inDependency = t2;
      _.$ti = t3;
    },
    _compileStylesheet(stylesheet, logger, importCache, nodeImporter, importer, functions, style, useSpaces, indentWidth, lineFeed, quietDeps, sourceMap, charset) {
      var serializeResult = A.serialize(A._EvaluateVisitor$(functions, importCache, logger, nodeImporter, quietDeps, sourceMap).run$2(0, importer, stylesheet)._1, charset, indentWidth, false, lineFeed, sourceMap, style, true),
        resultSourceMap = serializeResult._1;
      if (resultSourceMap != null)
        A.mapInPlace(resultSourceMap.urls, new A._compileStylesheet_closure(stylesheet, importCache));
      return new A.CompileResult(serializeResult);
    },
    _compileStylesheet_closure: function _compileStylesheet_closure(t0, t1) {
      this.stylesheet = t0;
      this.importCache = t1;
    },
    CompileResult: function CompileResult(t0) {
      this._serialize = t0;
    },
    Configuration: function Configuration(t0, t1) {
      this._configuration$_values = t0;
      this.__originalConfiguration = t1;
    },
    ExplicitConfiguration: function ExplicitConfiguration(t0, t1, t2) {
      this.nodeWithSpan = t0;
      this._configuration$_values = t1;
      this.__originalConfiguration = t2;
    },
    ConfiguredValue: function ConfiguredValue(t0, t1, t2) {
      this.value = t0;
      this.configurationSpan = t1;
      this.assignmentNode = t2;
    },
    Deprecation_fromId(id) {
      return A.IterableExtension_firstWhereOrNull(B.List_V43, new A.Deprecation_fromId_closure(id));
    },
    Deprecation_forVersion(version) {
      var t2, _i, deprecation, $self, t3,
        t1 = A.LinkedHashSet_LinkedHashSet$_empty(type$.Deprecation);
      for (t2 = A.VersionRange_VersionRange(true, version).get$allows(), _i = 0; _i < 18; ++_i) {
        deprecation = B.List_V43[_i];
        $self = deprecation._deprecatedIn;
        t3 = $self == null ? null : A.Version___parse_tearOff($self);
        t3 = t3 == null ? null : t2.call$1(t3);
        if (t3 == null ? false : t3)
          t1.add$1(0, deprecation);
      }
      return t1;
    },
    Deprecation: function Deprecation(t0, t1, t2, t3) {
      var _ = this;
      _.id = t0;
      _._deprecatedIn = t1;
      _.isFuture = t2;
      _._name = t3;
    },
    Deprecation_fromId_closure: function Deprecation_fromId_closure(t0) {
      this.id = t0;
    },
    Environment$() {
      var t1 = type$.String,
        t2 = type$.Module_Callable,
        t3 = type$.AstNode,
        t4 = type$.int,
        t5 = type$.Callable,
        t6 = type$.JSArray_Map_String_Callable;
      return new A.Environment(A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), A.LinkedHashMap_LinkedHashMap$_empty(t1, t3), A.LinkedHashMap_LinkedHashMap$_empty(t2, t3), A.LinkedHashMap_LinkedHashMap$_empty(t2, t3), null, null, A._setArrayType([], type$.JSArray_Module_Callable), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Value)], type$.JSArray_Map_String_Value), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, t3)], type$.JSArray_Map_String_AstNode), A.LinkedHashMap_LinkedHashMap$_empty(t1, t4), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), A.LinkedHashMap_LinkedHashMap$_empty(t1, t4), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), A.LinkedHashMap_LinkedHashMap$_empty(t1, t4), null);
    },
    Environment$_(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, _functions, _mixins, _content) {
      var t1 = type$.String,
        t2 = type$.int;
      return new A.Environment(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _functions, A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _mixins, A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _content);
    },
    _EnvironmentModule__EnvironmentModule(environment, css, preModuleComments, extensionStore, forwarded) {
      var t1, t2, t3, t4, t5, t6, module, result, t7;
      if (forwarded == null)
        forwarded = B.Set_empty0;
      t1 = type$.dynamic;
      t1 = A.LinkedHashMap_LinkedHashMap$_empty(t1, t1);
      for (t2 = type$.Module_Callable, t3 = type$.List_CssComment, t4 = A.MapExtensions_get_pairs(preModuleComments, t2, t3), t4 = t4.get$iterator(t4), t5 = type$.CssComment; t4.moveNext$0();) {
        t6 = t4.get$current(t4);
        module = t6._0;
        result = A.List_List$from(t6._1, false, t5);
        result.fixed$length = Array;
        result.immutable$list = Array;
        t1.$indexSet(0, module, result);
      }
      t1 = A.ConstantMap_ConstantMap$from(t1, t2, t3);
      t2 = A._EnvironmentModule__makeModulesByVariable(forwarded);
      t3 = A._EnvironmentModule__memberMap(B.JSArray_methods.get$first(environment._variables), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure(), type$.Map_String_Value), type$.Value);
      t4 = A._EnvironmentModule__memberMap(B.JSArray_methods.get$first(environment._variableNodes), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure0(), type$.Map_String_AstNode), type$.AstNode);
      t5 = type$.Map_String_Callable;
      t6 = type$.Callable;
      t7 = A._EnvironmentModule__memberMap(B.JSArray_methods.get$first(environment._functions), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure1(), t5), t6);
      t6 = A._EnvironmentModule__memberMap(B.JSArray_methods.get$first(environment._mixins), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure2(), t5), t6);
      t5 = J.get$isNotEmpty$asx(css.get$children(css)) || preModuleComments.get$isNotEmpty(preModuleComments) || B.JSArray_methods.any$1(environment._allModules, new A._EnvironmentModule__EnvironmentModule_closure3());
      return A._EnvironmentModule$_(environment, css, t1, extensionStore, t2, t3, t4, t7, t6, t5, !extensionStore.get$isEmpty(extensionStore) || B.JSArray_methods.any$1(environment._allModules, new A._EnvironmentModule__EnvironmentModule_closure4()));
    },
    _EnvironmentModule__makeModulesByVariable(forwarded) {
      var modulesByVariable, t1, t2, t3, t4, t5;
      if (forwarded.get$isEmpty(forwarded))
        return B.Map_empty1;
      modulesByVariable = A.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.Module_Callable);
      for (t1 = forwarded.get$iterator(forwarded); t1.moveNext$0();) {
        t2 = t1.get$current(t1);
        if (t2 instanceof A._EnvironmentModule) {
          for (t3 = t2._modulesByVariable, t3 = t3.get$values(t3), t3 = t3.get$iterator(t3); t3.moveNext$0();) {
            t4 = t3.get$current(t3);
            t5 = t4.get$variables();
            A.setAll(modulesByVariable, t5.get$keys(t5), t4);
          }
          A.setAll(modulesByVariable, J.get$keys$z(B.JSArray_methods.get$first(t2._environment$_environment._variables)), t2);
        } else {
          t3 = t2.get$variables();
          A.setAll(modulesByVariable, t3.get$keys(t3), t2);
        }
      }
      return modulesByVariable;
    },
    _EnvironmentModule__memberMap(localMap, otherMaps, $V) {
      var t1, t2, t3;
      localMap = new A.PublicMemberMapView(localMap, $V._eval$1("PublicMemberMapView<0>"));
      if (otherMaps.get$isEmpty(otherMaps))
        return localMap;
      t1 = A._setArrayType([], $V._eval$1("JSArray<Map<String,0>>"));
      for (t2 = otherMaps.get$iterator(otherMaps); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        if (t3.get$isNotEmpty(t3))
          t1.push(t3);
      }
      t1.push(localMap);
      if (t1.length === 1)
        return localMap;
      return A.MergedMapView$(t1, type$.String, $V);
    },
    _EnvironmentModule$_(_environment, css, preModuleComments, extensionStore, _modulesByVariable, variables, variableNodes, functions, mixins, transitivelyContainsCss, transitivelyContainsExtensions) {
      return new A._EnvironmentModule(_environment._allModules, variables, variableNodes, functions, mixins, extensionStore, css, preModuleComments, transitivelyContainsCss, transitivelyContainsExtensions, _environment, _modulesByVariable);
    },
    Environment: function Environment(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) {
      var _ = this;
      _._environment$_modules = t0;
      _._namespaceNodes = t1;
      _._globalModules = t2;
      _._importedModules = t3;
      _._forwardedModules = t4;
      _._nestedForwardedModules = t5;
      _._allModules = t6;
      _._variables = t7;
      _._variableNodes = t8;
      _._variableIndices = t9;
      _._functions = t10;
      _._functionIndices = t11;
      _._mixins = t12;
      _._mixinIndices = t13;
      _._content = t14;
      _._inMixin = false;
      _._inSemiGlobalScope = true;
      _._lastVariableIndex = _._lastVariableName = null;
    },
    Environment__getVariableFromGlobalModule_closure: function Environment__getVariableFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    Environment_setVariable_closure: function Environment_setVariable_closure(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    Environment_setVariable_closure0: function Environment_setVariable_closure0(t0) {
      this.name = t0;
    },
    Environment_setVariable_closure1: function Environment_setVariable_closure1(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    Environment__getFunctionFromGlobalModule_closure: function Environment__getFunctionFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    Environment__getMixinFromGlobalModule_closure: function Environment__getMixinFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    Environment_toModule_closure: function Environment_toModule_closure() {
    },
    Environment_toDummyModule_closure: function Environment_toDummyModule_closure() {
    },
    _EnvironmentModule: function _EnvironmentModule(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11) {
      var _ = this;
      _.upstream = t0;
      _.variables = t1;
      _.variableNodes = t2;
      _.functions = t3;
      _.mixins = t4;
      _.extensionStore = t5;
      _.css = t6;
      _.preModuleComments = t7;
      _.transitivelyContainsCss = t8;
      _.transitivelyContainsExtensions = t9;
      _._environment$_environment = t10;
      _._modulesByVariable = t11;
    },
    _EnvironmentModule__EnvironmentModule_closure: function _EnvironmentModule__EnvironmentModule_closure() {
    },
    _EnvironmentModule__EnvironmentModule_closure0: function _EnvironmentModule__EnvironmentModule_closure0() {
    },
    _EnvironmentModule__EnvironmentModule_closure1: function _EnvironmentModule__EnvironmentModule_closure1() {
    },
    _EnvironmentModule__EnvironmentModule_closure2: function _EnvironmentModule__EnvironmentModule_closure2() {
    },
    _EnvironmentModule__EnvironmentModule_closure3: function _EnvironmentModule__EnvironmentModule_closure3() {
    },
    _EnvironmentModule__EnvironmentModule_closure4: function _EnvironmentModule__EnvironmentModule_closure4() {
    },
    SassException$(message, span, loadedUrls) {
      return new A.SassException(loadedUrls == null ? B.Set_empty : A.Set_Set$unmodifiable(loadedUrls, type$.Uri), message, span);
    },
    MultiSpanSassException$(message, span, primaryLabel, secondarySpans, loadedUrls) {
      var t1 = A.ConstantMap_ConstantMap$from(secondarySpans, type$.FileSpan, type$.String);
      return new A.MultiSpanSassException(primaryLabel, t1, loadedUrls == null ? B.Set_empty : A.Set_Set$unmodifiable(loadedUrls, type$.Uri), message, span);
    },
    SassRuntimeException$(message, span, trace, loadedUrls) {
      return new A.SassRuntimeException(trace, loadedUrls == null ? B.Set_empty : A.Set_Set$unmodifiable(loadedUrls, type$.Uri), message, span);
    },
    MultiSpanSassRuntimeException$(message, span, primaryLabel, secondarySpans, trace, loadedUrls) {
      var t1 = A.ConstantMap_ConstantMap$from(secondarySpans, type$.FileSpan, type$.String);
      return new A.MultiSpanSassRuntimeException(trace, primaryLabel, t1, loadedUrls == null ? B.Set_empty : A.Set_Set$unmodifiable(loadedUrls, type$.Uri), message, span);
    },
    SassFormatException$(message, span, loadedUrls) {
      return new A.SassFormatException(loadedUrls == null ? B.Set_empty : A.Set_Set$unmodifiable(loadedUrls, type$.Uri), message, span);
    },
    MultiSpanSassFormatException$(message, span, primaryLabel, secondarySpans, loadedUrls) {
      var t1 = A.ConstantMap_ConstantMap$from(secondarySpans, type$.FileSpan, type$.String);
      return new A.MultiSpanSassFormatException(primaryLabel, t1, loadedUrls == null ? B.Set_empty : A.Set_Set$unmodifiable(loadedUrls, type$.Uri), message, span);
    },
    SassScriptException$(message, argumentName) {
      return new A.SassScriptException(argumentName == null ? message : "$" + argumentName + ": " + message);
    },
    MultiSpanSassScriptException$(message, primaryLabel, secondarySpans) {
      var t1 = A.ConstantMap_ConstantMap$from(secondarySpans, type$.FileSpan, type$.String);
      return new A.MultiSpanSassScriptException(primaryLabel, t1, message);
    },
    SassException: function SassException(t0, t1, t2) {
      this.loadedUrls = t0;
      this._span_exception$_message = t1;
      this._span = t2;
    },
    MultiSpanSassException: function MultiSpanSassException(t0, t1, t2, t3, t4) {
      var _ = this;
      _.primaryLabel = t0;
      _.secondarySpans = t1;
      _.loadedUrls = t2;
      _._span_exception$_message = t3;
      _._span = t4;
    },
    SassRuntimeException: function SassRuntimeException(t0, t1, t2, t3) {
      var _ = this;
      _.trace = t0;
      _.loadedUrls = t1;
      _._span_exception$_message = t2;
      _._span = t3;
    },
    MultiSpanSassRuntimeException: function MultiSpanSassRuntimeException(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.trace = t0;
      _.primaryLabel = t1;
      _.secondarySpans = t2;
      _.loadedUrls = t3;
      _._span_exception$_message = t4;
      _._span = t5;
    },
    SassFormatException: function SassFormatException(t0, t1, t2) {
      this.loadedUrls = t0;
      this._span_exception$_message = t1;
      this._span = t2;
    },
    MultiSpanSassFormatException: function MultiSpanSassFormatException(t0, t1, t2, t3, t4) {
      var _ = this;
      _.primaryLabel = t0;
      _.secondarySpans = t1;
      _.loadedUrls = t2;
      _._span_exception$_message = t3;
      _._span = t4;
    },
    SassScriptException: function SassScriptException(t0) {
      this.message = t0;
    },
    MultiSpanSassScriptException: function MultiSpanSassScriptException(t0, t1, t2) {
      this.primaryLabel = t0;
      this.secondarySpans = t1;
      this.message = t2;
    },
    compileStylesheet(options, graph, source, destination, ifModified) {
      return A.compileStylesheet$body(options, graph, source, destination, ifModified);
    },
    compileStylesheet$body(options, graph, source, destination, ifModified) {
      var $async$goto = 0,
        $async$completer = A._makeAsyncAwaitCompleter(type$.nullable_Record_3_int_and_String_and_nullable_String),
        $async$returnValue, $async$handler = 2, $async$currentError, error, stackTrace, message, error0, stackTrace0, path, message0, exception, t1, $async$exception;
      var $async$compileStylesheet = A._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1) {
          $async$currentError = $async$result;
          $async$goto = $async$handler;
        }
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              $async$handler = 4;
              $async$goto = 7;
              return A._asyncAwait(A._compileStylesheetWithoutErrorHandling(options, graph, source, destination, ifModified), $async$compileStylesheet);
            case 7:
              // returning from await.
              $async$handler = 2;
              // goto after finally
              $async$goto = 6;
              break;
            case 4:
              // catch
              $async$handler = 3;
              $async$exception = $async$currentError;
              t1 = A.unwrapException($async$exception);
              if (t1 instanceof A.SassException) {
                error = t1;
                stackTrace = A.getTraceFromException($async$exception);
                if (destination != null && !options.get$emitErrorCss())
                  A._tryDelete(destination);
                message = J.toString$1$color$(error, options.get$color());
                if (A._asBool(options._options.$index(0, "trace"))) {
                  t1 = A.getTrace(error);
                  if (t1 == null)
                    t1 = stackTrace;
                } else
                  t1 = null;
                $async$returnValue = A._getErrorWithStackTrace(65, message, t1);
                // goto return
                $async$goto = 1;
                break;
              } else if (t1 instanceof A.FileSystemException) {
                error0 = t1;
                stackTrace0 = A.getTraceFromException($async$exception);
                path = error0.path;
                message0 = path == null ? error0.message : "Error reading " + $.$get$context().relative$2$from(path, null) + ": " + error0.message + ".";
                if (A._asBool(options._options.$index(0, "trace"))) {
                  t1 = A.getTrace(error0);
                  if (t1 == null)
                    t1 = stackTrace0;
                } else
                  t1 = null;
                $async$returnValue = A._getErrorWithStackTrace(66, message0, t1);
                // goto return
                $async$goto = 1;
                break;
              } else
                throw $async$exception;
              // goto after finally
              $async$goto = 6;
              break;
            case 3:
              // uncaught
              // goto rethrow
              $async$goto = 2;
              break;
            case 6:
              // after finally
              $async$returnValue = null;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return A._asyncReturn($async$returnValue, $async$completer);
            case 2:
              // rethrow
              return A._asyncRethrow($async$currentError, $async$completer);
          }
      });
      return A._asyncStartSync($async$compileStylesheet, $async$completer);
    },
    _compileStylesheetWithoutErrorHandling(options, graph, source, destination, ifModified) {
      return A._compileStylesheetWithoutErrorHandling$body(options, graph, source, destination, ifModified);
    },
    _compileStylesheetWithoutErrorHandling$body(options, graph, source, destination, ifModified) {
      var $async$goto = 0,
        $async$completer = A._makeAsyncAwaitCompleter(type$.void),
        $async$returnValue, $async$handler = 2, $async$currentError, syntax, result, importCache, error, t1, exception, t2, t3, t4, t5, t6, t7, t8, t9, t10, result0, t11, t12, t13, t14, logger, stylesheet, t0, css, buffer, sourceName, destinationName, nowStr, timestamp, importer, $async$exception;
      var $async$_compileStylesheetWithoutErrorHandling = A._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1) {
          $async$currentError = $async$result;
          $async$goto = $async$handler;
        }
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              importer = $.$get$FilesystemImporter_cwd();
              if (ifModified)
                try {
                  if (source != null)
                    if (destination != null) {
                      t1 = A.absolute(source, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
                      t1 = !graph.modifiedSince$3($.$get$context().toUri$1(t1), A.modificationTime(destination), importer);
                    } else
                      t1 = false;
                  else
                    t1 = false;
                  if (t1) {
                    // goto return
                    $async$goto = 1;
                    break;
                  }
                } catch (exception) {
                  if (!(A.unwrapException(exception) instanceof A.FileSystemException))
                    throw exception;
                }
              syntax = null;
              if (A._asBoolQ(options._ifParsed$1("indented")) === true)
                syntax = B.Syntax_Sass_sass;
              else if (source != null)
                syntax = A.Syntax_forPath(source);
              else
                syntax = B.Syntax_SCSS_scss;
              result = null;
              $async$handler = 4;
              t1 = options._options;
              $async$goto = A._asBool(t1.$index(0, "async")) ? 7 : 9;
              break;
            case 7:
              // then
              t2 = options.get$pkgImporters();
              t3 = type$.List_String._as(t1.$index(0, "load-path"));
              t4 = A._asBool(t1.$index(0, "quiet")) ? $.$get$Logger_quiet() : new A.StderrLogger(options.get$color());
              t5 = type$.nullable_Record_3_AsyncImporter_and_Uri_and_Uri_originalUrl;
              t6 = type$.Record_3_AsyncImporter_and_Uri_and_bool_forImport;
              t7 = type$.Uri;
              t3 = A.AsyncImportCache__toImporters(t2, t3, null);
              importCache = new A.AsyncImportCache(t3, t4, A.LinkedHashMap_LinkedHashMap$_empty(type$.Record_2_Uri_and_bool_forImport, t5), A.LinkedHashMap_LinkedHashMap$_empty(t6, t5), A.LinkedHashMap_LinkedHashMap$_empty(t6, t7), A.LinkedHashMap_LinkedHashMap$_empty(t7, type$.nullable_Stylesheet), A.LinkedHashMap_LinkedHashMap$_empty(t7, type$.ImporterResult));
              $async$goto = source == null ? 10 : 12;
              break;
            case 10:
              // then
              $async$goto = 13;
              return A._asyncAwait(A.readStdin(), $async$_compileStylesheetWithoutErrorHandling);
            case 13:
              // returning from await.
              t2 = $async$result;
              t3 = syntax;
              t4 = A._asBool(t1.$index(0, "quiet")) ? $.$get$Logger_quiet() : new A.StderrLogger(options.get$color());
              t5 = $.$get$FilesystemImporter_cwd();
              t6 = J.$eq$(t1.$index(0, "style"), "compressed") ? B.OutputStyle_1 : B.OutputStyle_0;
              t7 = A._asBool(t1.$index(0, "quiet-deps"));
              t8 = A._asBool(t1.$index(0, "verbose"));
              t9 = options.get$emitSourceMap();
              t1 = A._asBool(t1.$index(0, "charset"));
              t10 = options.get$silenceDeprecations(0);
              $async$goto = 14;
              return A._asyncAwait(A.compileStringAsync(t2, t1, options.get$fatalDeprecations(0), options.get$futureDeprecations(0), importCache, t5, t4, t7, t10, t9, t6, t3, t8), $async$_compileStylesheetWithoutErrorHandling);
            case 14:
              // returning from await.
              result0 = $async$result;
              // goto join
              $async$goto = 11;
              break;
            case 12:
              // else
              t2 = syntax;
              t3 = A._asBool(t1.$index(0, "quiet")) ? $.$get$Logger_quiet() : new A.StderrLogger(options.get$color());
              t4 = J.$eq$(t1.$index(0, "style"), "compressed") ? B.OutputStyle_1 : B.OutputStyle_0;
              t5 = A._asBool(t1.$index(0, "quiet-deps"));
              t6 = A._asBool(t1.$index(0, "verbose"));
              t7 = options.get$emitSourceMap();
              t1 = A._asBool(t1.$index(0, "charset"));
              t8 = options.get$silenceDeprecations(0);
              $async$goto = 15;
              return A._asyncAwait(A.compileAsync(source, t1, options.get$fatalDeprecations(0), options.get$futureDeprecations(0), importCache, t3, t5, t8, t7, t4, t2, t6), $async$_compileStylesheetWithoutErrorHandling);
            case 15:
              // returning from await.
              result0 = $async$result;
            case 11:
              // join
              result = result0;
              // goto join
              $async$goto = 8;
              break;
            case 9:
              // else
              $async$goto = source == null ? 16 : 18;
              break;
            case 16:
              // then
              $async$goto = 19;
              return A._asyncAwait(A.readStdin(), $async$_compileStylesheetWithoutErrorHandling);
            case 19:
              // returning from await.
              t2 = $async$result;
              t3 = syntax;
              t4 = A._asBool(t1.$index(0, "quiet")) ? $.$get$Logger_quiet() : new A.StderrLogger(options.get$color());
              t5 = $.$get$FilesystemImporter_cwd();
              t6 = J.$eq$(t1.$index(0, "style"), "compressed") ? B.OutputStyle_1 : B.OutputStyle_0;
              t7 = A._asBool(t1.$index(0, "quiet-deps"));
              t8 = A._asBool(t1.$index(0, "verbose"));
              t9 = options.get$emitSourceMap();
              t1 = A._asBool(t1.$index(0, "charset"));
              t10 = options.get$silenceDeprecations(0);
              t11 = options.get$fatalDeprecations(0);
              t12 = options.get$futureDeprecations(0);
              t13 = type$.Deprecation;
              t14 = A.LinkedHashSet_LinkedHashSet$_empty(t13);
              t14.addAll$1(0, t10);
              t10 = A.LinkedHashSet_LinkedHashSet$_empty(t13);
              t10.addAll$1(0, t11);
              t11 = A.LinkedHashSet_LinkedHashSet$_empty(t13);
              t11.addAll$1(0, t12);
              logger = A.DeprecationProcessingLogger$(t4, t10, t11, !t8, t14);
              stylesheet = A.Stylesheet_Stylesheet$parse(t2, t3 == null ? B.Syntax_SCSS_scss : t3, logger, null);
              result0 = A._compileStylesheet(stylesheet, logger, graph.importCache, null, t5, null, t6, true, null, null, t7, t9, t1);
              logger.summarize$1$js(false);
              // goto join
              $async$goto = 17;
              break;
            case 18:
              // else
              t2 = syntax;
              t3 = A._asBool(t1.$index(0, "quiet")) ? $.$get$Logger_quiet() : new A.StderrLogger(options.get$color());
              importCache = graph.importCache;
              t4 = J.$eq$(t1.$index(0, "style"), "compressed") ? B.OutputStyle_1 : B.OutputStyle_0;
              t5 = A._asBool(t1.$index(0, "quiet-deps"));
              t6 = A._asBool(t1.$index(0, "verbose"));
              t7 = options.get$emitSourceMap();
              t1 = A._asBool(t1.$index(0, "charset"));
              t8 = options.get$silenceDeprecations(0);
              t9 = options.get$fatalDeprecations(0);
              t10 = options.get$futureDeprecations(0);
              t11 = type$.Deprecation;
              t12 = A.LinkedHashSet_LinkedHashSet$_empty(t11);
              t12.addAll$1(0, t8);
              t8 = A.LinkedHashSet_LinkedHashSet$_empty(t11);
              t8.addAll$1(0, t9);
              t9 = A.LinkedHashSet_LinkedHashSet$_empty(t11);
              t9.addAll$1(0, t10);
              logger = A.DeprecationProcessingLogger$(t3, t8, t9, !t6, t12);
              t3 = t2 == null || t2 === A.Syntax_forPath(source);
              if (t3) {
                t2 = $.$get$FilesystemImporter_cwd();
                t3 = A.isNodeJs() ? self.process : null;
                if (!J.$eq$(t3 == null ? null : J.get$platform$x(t3), "win32")) {
                  t3 = A.isNodeJs() ? self.process : null;
                  t3 = J.$eq$(t3 == null ? null : J.get$platform$x(t3), "darwin");
                } else
                  t3 = true;
                if (t3) {
                  t3 = $.$get$context();
                  t6 = A._realCasePath(A.absolute(t3.normalize$1(source), null, null, null, null, null, null, null, null, null, null, null, null, null, null));
                  t0 = t6;
                  t6 = t3;
                  t3 = t0;
                } else {
                  t3 = $.$get$context();
                  t6 = t3.canonicalize$1(0, source);
                  t0 = t6;
                  t6 = t3;
                  t3 = t0;
                }
                t6 = importCache.importCanonical$3$originalUrl(t2, t6.toUri$1(t3), t6.toUri$1(source));
                t6.toString;
                stylesheet = t6;
              } else {
                t3 = A.readFile(source);
                if (t2 == null)
                  t2 = A.Syntax_forPath(source);
                stylesheet = A.Stylesheet_Stylesheet$parse(t3, t2, logger, $.$get$context().toUri$1(source));
              }
              result0 = A._compileStylesheet(stylesheet, logger, importCache, null, $.$get$FilesystemImporter_cwd(), null, t4, true, null, null, t5, t7, t1);
              logger.summarize$1$js(false);
            case 17:
              // join
              result = result0;
            case 8:
              // join
              $async$handler = 2;
              // goto after finally
              $async$goto = 6;
              break;
            case 4:
              // catch
              $async$handler = 3;
              $async$exception = $async$currentError;
              t1 = A.unwrapException($async$exception);
              if (t1 instanceof A.SassException) {
                error = t1;
                if (options.get$emitErrorCss())
                  if (destination == null)
                    A.print(error.toCssString$0());
                  else {
                    A.ensureDir($.$get$context().dirname$1(destination));
                    A.writeFile(destination, error.toCssString$0() + "\n");
                  }
                throw $async$exception;
              } else
                throw $async$exception;
              // goto after finally
              $async$goto = 6;
              break;
            case 3:
              // uncaught
              // goto rethrow
              $async$goto = 2;
              break;
            case 6:
              // after finally
              css = result._serialize._0 + A._writeSourceMap(options, result._serialize._1, destination);
              if (destination == null) {
                if (css.length !== 0)
                  A.print(css);
              } else {
                A.ensureDir($.$get$context().dirname$1(destination));
                A.writeFile(destination, css + "\n");
              }
              t1 = options._options;
              if (!A._asBool(t1.$index(0, "quiet")))
                t1 = !A._asBool(t1.$index(0, "update")) && !A._asBool(t1.$index(0, "watch"));
              else
                t1 = true;
              if (t1) {
                // goto return
                $async$goto = 1;
                break;
              }
              buffer = new A.StringBuffer("");
              if (source == null)
                sourceName = "stdin";
              else {
                t1 = $.$get$context();
                sourceName = t1.prettyUri$1(t1.toUri$1(source));
              }
              destination.toString;
              t1 = $.$get$context();
              destinationName = t1.prettyUri$1(t1.toUri$1(destination));
              nowStr = new A.DateTime(Date.now(), false).toString$0(0);
              timestamp = B.JSString_methods.substring$2(nowStr, 0, nowStr.length - 7);
              t1 = options.get$color() ? buffer._contents = "" + "\x1b[90m" : "";
              t1 = buffer._contents = t1 + ("[" + timestamp + "] ");
              if (options.get$color())
                t1 = buffer._contents = t1 + "\x1b[32m";
              t1 += "Compiled " + sourceName + " to " + destinationName + ".";
              buffer._contents = t1;
              if (options.get$color())
                buffer._contents = t1 + "\x1b[0m";
              t1 = A.isNodeJs() ? self.process : null;
              if (t1 != null) {
                t1 = J.get$stdout$x(t1);
                J.write$1$x(t1, buffer.toString$0(0) + "\n");
              } else {
                t1 = self.console;
                J.log$1$x(t1, buffer);
              }
            case 1:
              // return
              return A._asyncReturn($async$returnValue, $async$completer);
            case 2:
              // rethrow
              return A._asyncRethrow($async$currentError, $async$completer);
          }
      });
      return A._asyncStartSync($async$_compileStylesheetWithoutErrorHandling, $async$completer);
    },
    _writeSourceMap(options, sourceMap, destination) {
      var t1, sourceMapText, url, sourceMapPath, t2, escapedUrl;
      if (sourceMap == null)
        return "";
      if (destination != null) {
        t1 = $.$get$context();
        sourceMap.targetUrl = t1.toUri$1(A.ParsedPath_ParsedPath$parse(destination, t1.style).get$basename()).toString$0(0);
      }
      A.mapInPlace(sourceMap.urls, new A._writeSourceMap_closure(options, destination));
      t1 = options._options;
      sourceMapText = B.C_JsonCodec.encode$2$toEncodable(sourceMap.toJson$1$includeSourceContents(A._asBool(t1.$index(0, "embed-sources"))), null);
      if (A._asBool(t1.$index(0, "embed-source-map")))
        url = A.Uri_Uri$dataFromString(sourceMapText, B.C_Utf8Codec, "application/json");
      else {
        destination.toString;
        sourceMapPath = destination + ".map";
        t2 = $.$get$context();
        A.ensureDir(t2.dirname$1(sourceMapPath));
        A.writeFile(sourceMapPath, sourceMapText);
        url = t2.toUri$1(t2.relative$2$from(sourceMapPath, t2.dirname$1(destination)));
      }
      t2 = url.toString$0(0);
      escapedUrl = A.stringReplaceAllUnchecked(t2, "*/", "%2A/");
      t1 = (J.$eq$(t1.$index(0, "style"), "compressed") ? B.OutputStyle_1 : B.OutputStyle_0) === B.OutputStyle_1 ? "" : "\n\n";
      return t1 + ("/*# sourceMappingURL=" + escapedUrl + " */");
    },
    _tryDelete(path) {
      var exception;
      try {
        A.deleteFile(path);
      } catch (exception) {
        if (!(A.unwrapException(exception) instanceof A.FileSystemException))
          throw exception;
      }
    },
    _getErrorWithStackTrace(exitCode, error, stackTrace) {
      return new A._Record_3(exitCode, error, stackTrace != null ? B.JSString_methods.trimRight$0(A.Trace_Trace$from(stackTrace).get$terse().toString$0(0)) : null);
    },
    _writeSourceMap_closure: function _writeSourceMap_closure(t0, t1) {
      this.options = t0;
      this.destination = t1;
    },
    ExecutableOptions__separator(text) {
      var t1 = $.$get$ExecutableOptions__separatorBar(),
        t2 = B.JSString_methods.$mul(t1, 3),
        t3 = A.hasTerminal() ? "\x1b[1m" : "",
        t4 = A.hasTerminal() ? "\x1b[0m" : "";
      return t2 + " " + t3 + text + t4 + " " + B.JSString_methods.$mul(t1, 35 - text.length);
    },
    ExecutableOptions__fail(message) {
      return A.throwExpression(A.UsageException$(message));
    },
    ExecutableOptions_ExecutableOptions$parse(args) {
      var options, error, t1, t2, exception;
      try {
        t1 = $.$get$ExecutableOptions__parser();
        t2 = A.ListQueue$(type$.String);
        t2.addAll$1(0, args);
        t2 = A.Parser$(null, t1, t2, null, null).parse$0();
        if (t2.wasParsed$1("poll") && !A._asBool(t2.$index(0, "watch")))
          A.ExecutableOptions__fail("--poll may not be passed without --watch.");
        options = new A.ExecutableOptions(t2);
        if (A._asBool(options._options.$index(0, "help")))
          A.ExecutableOptions__fail("Compile Sass to CSS.");
        return options;
      } catch (exception) {
        t1 = A.unwrapException(exception);
        if (type$.FormatException._is(t1)) {
          error = t1;
          A.ExecutableOptions__fail(J.get$message$x(error));
        } else
          throw exception;
      }
    },
    UsageException$(message) {
      return new A.UsageException(message);
    },
    ExecutableOptions: function ExecutableOptions(t0) {
      var _ = this;
      _._options = t0;
      _.__ExecutableOptions_interactive_FI = $;
      _._sourcesToDestinations = null;
      _.__ExecutableOptions__sourceDirectoriesToDestinations_F = $;
      _._fatalDeprecations = null;
    },
    ExecutableOptions__parser_closure: function ExecutableOptions__parser_closure() {
    },
    ExecutableOptions_interactive_closure: function ExecutableOptions_interactive_closure(t0) {
      this.$this = t0;
    },
    ExecutableOptions_emitErrorCss_closure: function ExecutableOptions_emitErrorCss_closure() {
    },
    ExecutableOptions_fatalDeprecations_closure: function ExecutableOptions_fatalDeprecations_closure(t0) {
      this.$this = t0;
    },
    UsageException: function UsageException(t0) {
      this.message = t0;
    },
    watch(options, graph) {
      var $async$goto = 0,
        $async$completer = A._makeAsyncAwaitCompleter(type$.void),
        $async$returnValue, t1, t2, t3, t4, t5, t6, dirWatcher, sourcesToDestinations, t0;
      var $async$watch = A._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return A._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              options._ensureSources$0();
              t1 = options.__ExecutableOptions__sourceDirectoriesToDestinations_F;
              t1 === $ && A.throwUnnamedLateFieldNI();
              t2 = type$.String;
              t1 = t1.cast$2$0(0, t2, t2);
              t1 = A.List_List$of(t1.get$keys(t1), true, t2);
              for (options._ensureSources$0(), t3 = options._sourcesToDestinations.cast$2$0(0, t2, t2), t3 = J.get$iterator$ax(t3.get$keys(t3)); t3.moveNext$0();) {
                t4 = t3.get$current(t3);
                t1.push($.$get$context().dirname$1(t4));
              }
              t3 = options._options;
              B.JSArray_methods.addAll$1(t1, type$.List_String._as(t3.$index(0, "load-path")));
              t4 = A._asBool(t3.$index(0, "poll"));
              t5 = type$.Stream_WatchEvent;
              t6 = A.PathMap__create(null, t5);
              t5 = new A.StreamGroup(B._StreamGroupState_dormant, A.LinkedHashMap_LinkedHashMap$_empty(t5, type$.nullable_StreamSubscription_WatchEvent), type$.StreamGroup_WatchEvent);
              t5.__StreamGroup__controller_A = A.StreamController_StreamController(t5.get$_onCancel(), t5.get$_onListen(), t5.get$_onPause(), t5.get$_onResume(), true, type$.WatchEvent);
              dirWatcher = new A.MultiDirWatcher(new A.PathMap(t6, type$.PathMap_Stream_WatchEvent), t5, t4);
              $async$goto = 3;
              return A._asyncAwait(A.Future_wait(new A.MappedListIterable(t1, new A.watch_closure(dirWatcher), A._arrayInstanceType(t1)._eval$1("MappedListIterable<1,Future<~>>")), false, type$.void), $async$watch);
            case 3:
              // returning from await.
              options._ensureSources$0();
              sourcesToDestinations = options._sourcesToDestinations.cast$2$0(0, t2, t2);
              for (t1 = J.get$iterator$ax(sourcesToDestinations.get$keys(sourcesToDestinations)); t1.moveNext$0();) {
                t2 = t1.get$current(t1);
                t4 = $.$get$FilesystemImporter_cwd();
                t5 = self.process;
                if (t5 == null)
                  t5 = null;
                else {
                  t5 = J.get$release$x(t5);
                  t5 = t5 == null ? null : J.get$name$x(t5);
                }
                t5 = J.$eq$(t5, "node") ? self.process : null;
                if (!J.$eq$(t5 == null ? null : J.get$platform$x(t5), "win32")) {
                  t5 = self.process;
                  if (t5 == null)
                    t5 = null;
                  else {
                    t5 = J.get$release$x(t5);
                    t5 = t5 == null ? null : J.get$name$x(t5);
                  }
                  t5 = J.$eq$(t5, "node") ? self.process : null;
                  t5 = J.$eq$(t5 == null ? null : J.get$platform$x(t5), "darwin");
                } else
                  t5 = true;
                if (t5) {
                  t5 = $.$get$context();
                  t6 = A._realCasePath(t5.absolute$15(t5.normalize$1(t2), null, null, null, null, null, null, null, null, null, null, null, null, null, null));
                  t0 = t6;
                  t6 = t5;
                  t5 = t0;
                } else {
                  t5 = $.$get$context();
                  t6 = t5.canonicalize$1(0, t2);
                  t0 = t6;
                  t6 = t5;
                  t5 = t0;
                }
                graph.addCanonical$4$recanonicalize(t4, t6.toUri$1(t5), t6.toUri$1(t2), false);
              }
              $async$goto = 4;
              return A._asyncAwait(A.compileStylesheets(options, graph, sourcesToDestinations, true), $async$watch);
            case 4:
              // returning from await.
              if (!$async$result && A._asBool(t3.$index(0, "stop-on-error"))) {
                t1 = dirWatcher._group.__StreamGroup__controller_A;
                t1 === $ && A.throwUnnamedLateFieldNI();
                new A._ControllerStream(t1, A._instanceType(t1)._eval$1("_ControllerStream<1>")).listen$1(0, null).cancel$0();
                // goto return
                $async$goto = 1;
                break;
              }
              A.print("Sass is watching for changes. Press Ctrl-C to stop.\n");
              $async$goto = 5;
              return A._asyncAwait(new A._Watcher(options, graph).watch$1(0, dirWatcher), $async$watch);
            case 5:
              // returning from await.
            case 1:
              // return
              return A._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return A._asyncStartSync($async$watch, $async$completer);
    },
    watch_closure: function watch_closure(t0) {
      this.dirWatcher = t0;
    },
    _Watcher: function _Watcher(t0, t1) {
      this._watch$_options = t0;
      this._graph = t1;
    },
    _Watcher__debounceEvents_closure: function _Watcher__debounceEvents_closure() {
    },
    EmptyExtensionStore: function EmptyExtensionStore() {
    },
    Extension: function Extension(t0, t1, t2, t3, t4) {
      var _ = this;
      _.extender = t0;
      _.target = t1;
      _.mediaContext = t2;
      _.isOptional = t3;
      _.span = t4;
    },
    Extender: function Extender(t0, t1) {
      this.selector = t0;
      this.isOriginal = t1;
      this._extension = null;
    },
    ExtensionStore__extendOrReplace(selector, source, targets, mode, span) {
      var t1, t2, t3, t4, t5, t6, t7, t8, _i, complex, compound, t9, t10, t11, _i0, simple, t12, _i1, t13, t14,
        extender = A.ExtensionStore$_mode(mode);
      if (!selector.accept$1(B._IsInvisibleVisitor_true))
        extender._originals.addAll$1(0, selector.components);
      for (t1 = targets.components, t2 = t1.length, t3 = source.components, t4 = t3.length, t5 = type$.ComplexSelector, t6 = type$.Extension, t7 = type$.SimpleSelector, t8 = type$.Map_ComplexSelector_Extension, _i = 0; _i < t2; ++_i) {
        complex = t1[_i];
        compound = complex.get$singleCompound();
        if (compound == null)
          throw A.wrapException(A.SassScriptException$("Can't extend complex selector " + A.S(complex) + ".", null));
        t9 = A.LinkedHashMap_LinkedHashMap$_empty(t7, t8);
        for (t10 = compound.components, t11 = t10.length, _i0 = 0; _i0 < t11; ++_i0) {
          simple = t10[_i0];
          t12 = A.LinkedHashMap_LinkedHashMap$_empty(t5, t6);
          for (_i1 = 0; _i1 < t4; ++_i1) {
            complex = t3[_i1];
            complex.get$specificity();
            t13 = new A.Extender(complex, false);
            t14 = new A.Extension(t13, simple, null, true, span);
            t13._extension = t14;
            t12.$indexSet(0, complex, t14);
          }
          t9.$indexSet(0, simple, t12);
        }
        selector = extender._extendList$2(selector, t9);
      }
      return selector;
    },
    ExtensionStore$() {
      var t1 = type$.SimpleSelector;
      return new A.ExtensionStore(A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Set_ModifiableBox_SelectorList), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Map_ComplexSelector_Extension), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.List_Extension), A.LinkedHashMap_LinkedHashMap$_empty(type$.ModifiableBox_SelectorList, type$.List_CssMediaQuery), new A.JsIdentityLinkedHashMap(type$.JsIdentityLinkedHashMap_SimpleSelector_int), new A._LinkedIdentityHashSet(type$._LinkedIdentityHashSet_ComplexSelector), B.ExtendMode_normal_normal);
    },
    ExtensionStore$_mode(_mode) {
      var t1 = type$.SimpleSelector;
      return new A.ExtensionStore(A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Set_ModifiableBox_SelectorList), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Map_ComplexSelector_Extension), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.List_Extension), A.LinkedHashMap_LinkedHashMap$_empty(type$.ModifiableBox_SelectorList, type$.List_CssMediaQuery), new A.JsIdentityLinkedHashMap(type$.JsIdentityLinkedHashMap_SimpleSelector_int), new A._LinkedIdentityHashSet(type$._LinkedIdentityHashSet_ComplexSelector), _mode);
    },
    ExtensionStore: function ExtensionStore(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._selectors = t0;
      _._extensions = t1;
      _._extensionsByExtender = t2;
      _._mediaContexts = t3;
      _._sourceSpecificity = t4;
      _._originals = t5;
      _._mode = t6;
    },
    ExtensionStore_extensionsWhereTarget_closure: function ExtensionStore_extensionsWhereTarget_closure() {
    },
    ExtensionStore__registerSelector_closure: function ExtensionStore__registerSelector_closure() {
    },
    ExtensionStore_addExtension_closure: function ExtensionStore_addExtension_closure() {
    },
    ExtensionStore_addExtension_closure0: function ExtensionStore_addExtension_closure0() {
    },
    ExtensionStore_addExtension_closure1: function ExtensionStore_addExtension_closure1(t0) {
      this.complex = t0;
    },
    ExtensionStore__extendExistingExtensions_closure: function ExtensionStore__extendExistingExtensions_closure() {
    },
    ExtensionStore__extendExistingExtensions_closure0: function ExtensionStore__extendExistingExtensions_closure0() {
    },
    ExtensionStore_addExtensions_closure: function ExtensionStore_addExtensions_closure() {
    },
    ExtensionStore__extendComplex_closure: function ExtensionStore__extendComplex_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.complex = t2;
    },
    ExtensionStore__extendComplex__closure: function ExtensionStore__extendComplex__closure(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.complex = t2;
    },
    ExtensionStore__extendCompound_closure: function ExtensionStore__extendCompound_closure() {
    },
    ExtensionStore__extendCompound_closure0: function ExtensionStore__extendCompound_closure0() {
    },
    ExtensionStore__extendCompound_closure1: function ExtensionStore__extendCompound_closure1(t0) {
      this.original = t0;
    },
    ExtensionStore__extendSimple_withoutPseudo: function ExtensionStore__extendSimple_withoutPseudo(t0, t1, t2) {
      this.$this = t0;
      this.extensions = t1;
      this.targetsUsed = t2;
    },
    ExtensionStore__extendSimple_closure: function ExtensionStore__extendSimple_closure(t0, t1) {
      this.$this = t0;
      this.withoutPseudo = t1;
    },
    ExtensionStore__extendSimple_closure0: function ExtensionStore__extendSimple_closure0() {
    },
    ExtensionStore__extendPseudo_closure: function ExtensionStore__extendPseudo_closure() {
    },
    ExtensionStore__extendPseudo_closure0: function ExtensionStore__extendPseudo_closure0() {
    },
    ExtensionStore__extendPseudo_closure1: function ExtensionStore__extendPseudo_closure1() {
    },
    ExtensionStore__extendPseudo_closure2: function ExtensionStore__extendPseudo_closure2(t0) {
      this.pseudo = t0;
    },
    ExtensionStore__extendPseudo_closure3: function ExtensionStore__extendPseudo_closure3(t0, t1) {
      this.pseudo = t0;
      this.selector = t1;
    },
    ExtensionStore__trim_closure: function ExtensionStore__trim_closure(t0, t1) {
      this._box_0 = t0;
      this.complex1 = t1;
    },
    ExtensionStore__trim_closure0: function ExtensionStore__trim_closure0(t0, t1) {
      this._box_0 = t0;
      this.complex1 = t1;
    },
    ExtensionStore_clone_closure: function ExtensionStore_clone_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.newSelectors = t1;
      _.oldToNewSelectors = t2;
      _.newMediaContexts = t3;
    },
    unifyComplex(complexes, span) {
      var t2, trailingCombinator, leadingCombinator, unifiedBase, t3, t4, _0_6_isSet, _0_6, t5, newLeadingCombinator, base, _1_1, newTrailingCombinator, _i, t6, t7, t8, _null = null,
        t1 = J.getInterceptor$asx(complexes);
      if (t1.get$length(complexes) === 1)
        return complexes;
      for (t2 = t1.get$iterator(complexes), trailingCombinator = _null, leadingCombinator = trailingCombinator, unifiedBase = leadingCombinator; t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        if (t3.accept$1(B.C__IsUselessVisitor))
          return _null;
        t4 = t3.components;
        _0_6_isSet = t4.length === 1;
        if (_0_6_isSet) {
          _0_6 = t3.leadingCombinators;
          t5 = _0_6.length === 1;
        } else {
          _0_6 = _null;
          t5 = false;
        }
        if (t5) {
          newLeadingCombinator = (_0_6_isSet ? _0_6 : t3.leadingCombinators)[0];
          if (leadingCombinator == null)
            leadingCombinator = newLeadingCombinator;
          else if (!(leadingCombinator.$ti._is(newLeadingCombinator) && J.$eq$(newLeadingCombinator.value, leadingCombinator.value)))
            return _null;
        }
        base = B.JSArray_methods.get$last(t4);
        _1_1 = base.combinators;
        if (_1_1.length === 1) {
          newTrailingCombinator = _1_1[0];
          if (trailingCombinator != null)
            t3 = !(trailingCombinator.$ti._is(newTrailingCombinator) && J.$eq$(newTrailingCombinator.value, trailingCombinator.value));
          else
            t3 = false;
          if (t3)
            return _null;
          trailingCombinator = newTrailingCombinator;
        }
        if (unifiedBase == null)
          unifiedBase = base.selector.components;
        else
          for (t3 = base.selector.components, t4 = t3.length, _i = 0; _i < t4; ++_i) {
            unifiedBase = t3[_i].unify$1(unifiedBase);
            if (unifiedBase == null)
              return _null;
          }
      }
      t2 = type$.JSArray_ComplexSelector;
      t3 = A._setArrayType([], t2);
      for (t4 = t1.get$iterator(complexes); t4.moveNext$0();) {
        t5 = t4.get$current(t4);
        t6 = t5.components;
        t7 = t6.length;
        if (t7 > 1) {
          t8 = t5.leadingCombinators;
          t3.push(A.ComplexSelector$(t8, B.JSArray_methods.take$1(t6, t7 - 1), t5.span, t5.lineBreak));
        }
      }
      t4 = leadingCombinator == null ? B.List_empty0 : A._setArrayType([leadingCombinator], type$.JSArray_CssValue_Combinator);
      unifiedBase.toString;
      t5 = A.CompoundSelector$(unifiedBase, span);
      t6 = trailingCombinator == null ? B.List_empty0 : A._setArrayType([trailingCombinator], type$.JSArray_CssValue_Combinator);
      base = A.ComplexSelector$(t4, A._setArrayType([new A.ComplexSelectorComponent(t5, A.List_List$unmodifiable(t6, type$.CssValue_Combinator), span)], type$.JSArray_ComplexSelectorComponent), span, t1.any$1(complexes, new A.unifyComplex_closure()));
      if (t3.length === 0)
        t1 = A._setArrayType([base], t2);
      else {
        t1 = A.List_List$of(A.IterableExtension_get_exceptLast(t3), true, type$.ComplexSelector);
        t1.push(B.JSArray_methods.get$last(t3).concatenate$2(base, span));
      }
      return A.weave(t1, span, false);
    },
    unifyCompound(compound1, compound2) {
      var t1, t2, _i, unified,
        result = compound2.components;
      for (t1 = compound1.components, t2 = t1.length, _i = 0; _i < t2; ++_i, result = unified) {
        unified = t1[_i].unify$1(result);
        if (unified == null)
          return null;
      }
      return A.CompoundSelector$(result, compound1.span);
    },
    unifyUniversalAndElement(selector1, selector2) {
      var namespace, $name, t1,
        _0_0 = A._namespaceAndName(selector1, "selector1"),
        namespace1 = _0_0._0,
        name1 = _0_0._1,
        _1_0 = A._namespaceAndName(selector2, "selector2"),
        namespace2 = _1_0._0,
        name2 = _1_0._1;
      if (namespace1 == namespace2 || namespace2 === "*")
        namespace = namespace1;
      else {
        if (namespace1 !== "*")
          return null;
        namespace = namespace2;
      }
      if (name1 == name2 || name2 == null)
        $name = name1;
      else {
        if (!(name1 == null || name1 === "*"))
          return null;
        $name = name2;
      }
      t1 = selector1.span;
      return $name == null ? new A.UniversalSelector(namespace, t1) : new A.TypeSelector(new A.QualifiedName($name, namespace), t1);
    },
    _namespaceAndName(selector, $name) {
      var t1, _0_4;
      $label0$0: {
        if (selector instanceof A.UniversalSelector) {
          t1 = new A._Record_2(selector.namespace, null);
          break $label0$0;
        }
        if (selector instanceof A.TypeSelector) {
          _0_4 = selector.name;
          t1 = new A._Record_2(_0_4.namespace, _0_4.name);
          break $label0$0;
        }
        t1 = A.throwExpression(A.ArgumentError$value(selector, $name, string$.must_b));
      }
      return t1;
    },
    weave(complexes, span, forceLineBreak) {
      var complex, t2, prefixes, t3, t4, t5, t6, i, t7, t8, _i, t9, t10, _i0, parentPrefix, t11, t12,
        t1 = J.getInterceptor$asx(complexes);
      if (t1.get$length(complexes) === 1) {
        complex = t1.$index(complexes, 0);
        if (!forceLineBreak || complex.lineBreak)
          return complexes;
        return A._setArrayType([A.ComplexSelector$(complex.leadingCombinators, complex.components, complex.span, true)], type$.JSArray_ComplexSelector);
      }
      t2 = type$.JSArray_ComplexSelector;
      prefixes = A._setArrayType([t1.get$first(complexes)], t2);
      for (t1 = t1.skip$1(complexes, 1), t3 = t1.$ti, t1 = new A.ListIterator(t1, t1.get$length(0), t3._eval$1("ListIterator<ListIterable.E>")), t4 = type$.ComplexSelectorComponent, t3 = t3._eval$1("ListIterable.E"); t1.moveNext$0();) {
        t5 = t1.__internal$_current;
        if (t5 == null)
          t5 = t3._as(t5);
        t6 = t5.components;
        if (t6.length === 1) {
          for (i = 0; i < prefixes.length; ++i)
            prefixes[i] = prefixes[i].concatenate$3$forceLineBreak(t5, span, forceLineBreak);
          continue;
        }
        t7 = A._setArrayType([], t2);
        for (t8 = prefixes.length, _i = 0; _i < prefixes.length; prefixes.length === t8 || (0, A.throwConcurrentModificationError)(prefixes), ++_i) {
          t9 = A._weaveParents(prefixes[_i], t5, span);
          if (t9 == null)
            t9 = B.List_empty1;
          t10 = t9.length;
          _i0 = 0;
          for (; _i0 < t9.length; t9.length === t10 || (0, A.throwConcurrentModificationError)(t9), ++_i0) {
            parentPrefix = t9[_i0];
            t11 = B.JSArray_methods.get$last(t6);
            t12 = A.List_List$of(parentPrefix.components, true, t4);
            t12.push(t11);
            t11 = parentPrefix.lineBreak || forceLineBreak;
            t7.push(A.ComplexSelector$(parentPrefix.leadingCombinators, t12, span, t11));
          }
        }
        prefixes = t7;
      }
      return prefixes;
    },
    _weaveParents(prefix, base, span) {
      var t1, queue1, queue2, trailingCombinators, _0_1, _0_3, _0_3_isSet, rootish1, t2, rootish2, _0_30, rootish, t3, rootish_case_0, t0, rootish_case_1, groups1, groups2, lcs, choices, t4, _i, group, t5, t6, t7, _i0, chunk, t8, t9, _null = null,
        leadingCombinators = A._mergeLeadingCombinators(prefix.leadingCombinators, base.leadingCombinators);
      if (leadingCombinators == null)
        return _null;
      t1 = type$.ComplexSelectorComponent;
      queue1 = A.QueueList_QueueList$from(prefix.components, t1);
      queue2 = A.QueueList_QueueList$from(A.IterableExtension_get_exceptLast(base.components), t1);
      trailingCombinators = A._mergeTrailingCombinators(queue1, queue2, span, _null);
      if (trailingCombinators == null)
        return _null;
      $label0$0: {
        _0_1 = A._firstIfRootish(queue1);
        _0_3 = A._firstIfRootish(queue2);
        _0_3_isSet = _0_1 != null;
        if (_0_3_isSet) {
          rootish1 = _0_1 == null ? t1._as(_0_1) : _0_1;
          t2 = _0_3 != null;
          if (t2)
            rootish2 = _0_3 == null ? t1._as(_0_3) : _0_3;
          else
            rootish2 = _null;
          _0_30 = _0_3;
        } else {
          rootish2 = _null;
          rootish1 = rootish2;
          _0_30 = rootish1;
          t2 = false;
        }
        if (t2) {
          rootish = A.unifyCompound(rootish1.selector, rootish2.selector);
          if (rootish == null)
            return _null;
          t1 = rootish1.combinators;
          t2 = rootish1.span;
          t3 = type$.CssValue_Combinator;
          queue1.addFirst$1(new A.ComplexSelectorComponent(rootish, A.List_List$unmodifiable(t1, t3), t2));
          queue2.addFirst$1(new A.ComplexSelectorComponent(rootish, A.List_List$unmodifiable(rootish2.combinators, t3), t2));
          break $label0$0;
        }
        if (_0_1 != null) {
          rootish_case_0 = _0_1;
          if (_0_3_isSet)
            t2 = _0_30;
          else {
            t2 = _0_3;
            _0_30 = t2;
            _0_3_isSet = true;
          }
          t2 = t2 == null;
          t3 = t2 ? rootish_case_0 : _null;
          t0 = t3;
          t3 = t2;
          t2 = t0;
        } else {
          t2 = _null;
          t3 = false;
        }
        if (!t3)
          if (_0_1 == null) {
            if (_0_3_isSet)
              t3 = _0_30;
            else {
              t3 = _0_3;
              _0_30 = t3;
              _0_3_isSet = true;
            }
            t3 = t3 != null;
            if (t3) {
              rootish_case_1 = _0_3_isSet ? _0_30 : _0_3;
              if (rootish_case_1 == null)
                rootish_case_1 = t1._as(rootish_case_1);
              t1 = rootish_case_1;
            } else
              t1 = t2;
            t2 = t3;
          } else {
            t1 = t2;
            t2 = false;
          }
        else {
          t1 = t2;
          t2 = true;
        }
        if (t2) {
          queue1.addFirst$1(t1);
          queue2.addFirst$1(t1);
        }
      }
      groups1 = A._groupSelectors(queue1);
      groups2 = A._groupSelectors(queue2);
      t1 = type$.List_ComplexSelectorComponent;
      lcs = A.longestCommonSubsequence(groups2, groups1, new A._weaveParents_closure(span), t1);
      choices = A._setArrayType([], type$.JSArray_List_Iterable_ComplexSelectorComponent);
      for (t2 = lcs.length, t3 = type$.JSArray_Iterable_ComplexSelectorComponent, t4 = type$.JSArray_ComplexSelectorComponent, _i = 0; _i < lcs.length; lcs.length === t2 || (0, A.throwConcurrentModificationError)(lcs), ++_i) {
        group = lcs[_i];
        t5 = A._setArrayType([], t3);
        for (t6 = A._chunks(groups1, groups2, new A._weaveParents_closure0(group), t1), t7 = t6.length, _i0 = 0; _i0 < t6.length; t6.length === t7 || (0, A.throwConcurrentModificationError)(t6), ++_i0) {
          chunk = t6[_i0];
          t8 = A._setArrayType([], t4);
          for (t9 = B.JSArray_methods.get$iterator(chunk); t9.moveNext$0();)
            B.JSArray_methods.addAll$1(t8, t9.get$current(0));
          t5.push(t8);
        }
        choices.push(t5);
        choices.push(A._setArrayType([group], t3));
        groups1.removeFirst$0();
        groups2.removeFirst$0();
      }
      t2 = A._setArrayType([], t3);
      for (t1 = A._chunks(groups1, groups2, new A._weaveParents_closure1(), t1), t3 = t1.length, _i = 0; _i < t1.length; t1.length === t3 || (0, A.throwConcurrentModificationError)(t1), ++_i) {
        chunk = t1[_i];
        t5 = A._setArrayType([], t4);
        for (t6 = B.JSArray_methods.get$iterator(chunk); t6.moveNext$0();)
          B.JSArray_methods.addAll$1(t5, t6.get$current(0));
        t2.push(t5);
      }
      choices.push(t2);
      B.JSArray_methods.addAll$1(choices, trailingCombinators);
      t1 = A._setArrayType([], type$.JSArray_ComplexSelector);
      for (t2 = J.get$iterator$ax(A.paths(new A.WhereIterable(choices, new A._weaveParents_closure2(), type$.WhereIterable_List_Iterable_ComplexSelectorComponent), type$.Iterable_ComplexSelectorComponent)), t3 = !prefix.lineBreak, t5 = base.lineBreak; t2.moveNext$0();) {
        t6 = t2.get$current(t2);
        t7 = A._setArrayType([], t4);
        for (t6 = J.get$iterator$ax(t6); t6.moveNext$0();)
          B.JSArray_methods.addAll$1(t7, t6.get$current(t6));
        t1.push(A.ComplexSelector$(leadingCombinators, t7, span, !t3 || t5));
      }
      return t1;
    },
    _firstIfRootish(queue) {
      var first, t1, t2, _i, simple, t3;
      if (queue.get$length(0) >= 1) {
        first = queue.$index(0, 0);
        for (t1 = first.selector.components, t2 = t1.length, _i = 0; _i < t2; ++_i) {
          simple = t1[_i];
          if (simple instanceof A.PseudoSelector)
            if (simple.isClass)
              t3 = $._rootishPseudoClasses.contains$1(0, simple.normalizedName);
            else
              t3 = false;
          else
            t3 = false;
          if (t3) {
            queue.removeFirst$0();
            return first;
          }
        }
      }
      return null;
    },
    _mergeLeadingCombinators(combinators1, combinators2) {
      var _0_4, t1, _0_7_isSet, _0_7, t2, _0_11_isSet, _0_11, _0_4_isSet, combinators, _null = null;
      $label0$0: {
        _0_4 = combinators2;
        t1 = type$.List_CssValue_Combinator;
        _0_7_isSet = t1._is(combinators1);
        if (_0_7_isSet) {
          _0_7 = combinators1.length;
          t2 = _0_7;
          t2 = t2 > 1;
        } else {
          _0_7 = _null;
          t2 = false;
        }
        if (!t2) {
          t2 = _0_4;
          _0_11_isSet = t1._is(t2);
          if (_0_11_isSet) {
            t2 = _0_4;
            _0_11 = (t2 == null ? t1._as(t2) : t2).length;
            t2 = _0_11;
            _0_4_isSet = true;
            t2 = t2 > 1;
          } else {
            _0_11 = _null;
            _0_4_isSet = true;
            t2 = false;
          }
        } else {
          _0_11 = _null;
          _0_4_isSet = true;
          _0_11_isSet = false;
          t2 = true;
        }
        if (t2) {
          t1 = _null;
          break $label0$0;
        }
        if (t1._is(combinators1)) {
          if (_0_7_isSet)
            t2 = _0_7;
          else {
            _0_7 = combinators1.length;
            t2 = _0_7;
          }
          t2 = t2 <= 0;
          if (t2)
            if (_0_4_isSet)
              combinators = _0_4;
            else {
              combinators = combinators2;
              _0_4 = combinators;
              _0_4_isSet = true;
            }
          else
            combinators = _null;
        } else {
          combinators = _null;
          t2 = false;
        }
        if (!t2) {
          if (_0_4_isSet)
            t2 = _0_4;
          else {
            t2 = combinators2;
            _0_4 = t2;
            _0_4_isSet = true;
          }
          if (t1._is(t2)) {
            if (_0_11_isSet)
              t1 = _0_11;
            else {
              t2 = _0_4_isSet ? _0_4 : combinators2;
              _0_11 = (t2 == null ? t1._as(t2) : t2).length;
              t1 = _0_11;
            }
            t1 = t1 <= 0;
          } else
            t1 = false;
          combinators = combinators1;
        } else
          t1 = true;
        if (t1) {
          t1 = combinators;
          break $label0$0;
        }
        t1 = B.C_ListEquality.equals$2(0, combinators1, combinators2) ? combinators1 : _null;
        break $label0$0;
      }
      return t1;
    },
    _mergeTrailingCombinators(components1, components2, span, result) {
      var _0_1, t1, _1_1, t2, t3, _4_1, _4_3, _4_4_isSet, _4_4, _4_5, component1, component2, t4, t5, choices, _2_0, _4_4_isSet0, _4_9, _4_6_isSet, _4_6, _4_7, nextComponents, followingComponents, _4_7_isSet, _4_10_isSet, _4_10, _4_5_isSet, next, following, _3_0, siblingComponents_case_0, t0, siblingComponents_case_1, combinator1, combinator2, unified, combinator_case_0, combinatorComponents_case_0, descendantComponents_case_0, t6, combinator_case_1, descendantComponents_case_1, combinatorComponents_case_1, _null = null;
      if (result == null)
        result = A.QueueList$(_null, type$.List_List_ComplexSelectorComponent);
      $label0$0: {
        _0_1 = components1.get$length(0);
        if (_0_1 >= 1) {
          t1 = components1.$index(0, _0_1 - 1).combinators;
          break $label0$0;
        }
        t1 = B.List_empty0;
        break $label0$0;
      }
      $label1$1: {
        _1_1 = components2.get$length(0);
        if (_1_1 >= 1) {
          t2 = components2.$index(0, _1_1 - 1).combinators;
          break $label1$1;
        }
        t2 = B.List_empty0;
        break $label1$1;
      }
      t3 = t1.length;
      if (t3 === 0 && t2.length === 0)
        return result;
      if (t3 > 1 || t2.length > 1)
        return _null;
      $label2$2: {
        t3 = A.IterableExtension_get_firstOrNull(t1);
        t3 = t3 == null ? _null : t3.value;
        t2 = A.IterableExtension_get_firstOrNull(t2);
        t2 = [t3, t2 == null ? _null : t2.value, components1, components2];
        _4_1 = t2[0];
        _4_3 = B.Combinator_y18 === _4_1;
        _4_4_isSet = _4_3;
        if (_4_4_isSet) {
          _4_4 = t2[1];
          _4_5 = B.Combinator_y18 === _4_4;
          t3 = _4_5;
        } else {
          _4_4 = _null;
          _4_5 = _4_4;
          t3 = false;
        }
        if (t3) {
          component1 = components1.removeLast$0(0);
          component2 = components2.removeLast$0(0);
          t2 = component1.selector;
          t3 = component2.selector;
          if (A.compoundIsSuperselector(t2, t3, _null))
            result.addFirst$1(A._setArrayType([A._setArrayType([component2], type$.JSArray_ComplexSelectorComponent)], type$.JSArray_List_ComplexSelectorComponent));
          else {
            t4 = type$.JSArray_ComplexSelectorComponent;
            t5 = type$.JSArray_List_ComplexSelectorComponent;
            if (A.compoundIsSuperselector(t3, t2, _null))
              result.addFirst$1(A._setArrayType([A._setArrayType([component1], t4)], t5));
            else {
              choices = A._setArrayType([A._setArrayType([component1, component2], t4), A._setArrayType([component2, component1], t4)], t5);
              _2_0 = A.unifyCompound(t2, t3);
              if (_2_0 != null)
                choices.push(A._setArrayType([new A.ComplexSelectorComponent(_2_0, A.List_List$unmodifiable(A._setArrayType([B.JSArray_methods.get$first(t1)], type$.JSArray_CssValue_Combinator), type$.CssValue_Combinator), span)], t4));
              result.addFirst$1(choices);
            }
          }
          break $label2$2;
        }
        if (_4_3) {
          if (_4_4_isSet) {
            t3 = _4_4;
            _4_4_isSet0 = _4_4_isSet;
          } else {
            _4_4 = t2[1];
            t3 = _4_4;
            _4_4_isSet0 = true;
          }
          _4_9 = B.Combinator_gRV === t3;
          _4_6_isSet = _4_9;
          if (_4_6_isSet) {
            _4_6 = t2[2];
            _4_7 = t2[3];
            nextComponents = _4_7;
            followingComponents = _4_6;
          } else {
            nextComponents = _null;
            followingComponents = nextComponents;
            _4_7 = followingComponents;
            _4_6 = _4_7;
          }
          t3 = _4_6_isSet;
          _4_7_isSet = t3;
        } else {
          nextComponents = _null;
          followingComponents = nextComponents;
          _4_7 = followingComponents;
          _4_6 = _4_7;
          _4_9 = _4_6;
          _4_4_isSet0 = _4_4_isSet;
          _4_6_isSet = false;
          _4_7_isSet = false;
          t3 = false;
        }
        _4_10_isSet = !t3;
        if (_4_10_isSet) {
          _4_10 = B.Combinator_gRV === _4_1;
          t3 = _4_10;
          if (t3) {
            if (_4_4_isSet) {
              t3 = _4_5;
              _4_5_isSet = _4_4_isSet;
              _4_4_isSet = _4_4_isSet0;
            } else {
              if (_4_4_isSet0) {
                t3 = _4_4;
                _4_4_isSet = _4_4_isSet0;
              } else {
                _4_4 = t2[1];
                t3 = _4_4;
                _4_4_isSet = true;
              }
              _4_5 = B.Combinator_y18 === t3;
              t3 = _4_5;
              _4_5_isSet = true;
            }
            if (t3) {
              if (_4_6_isSet)
                nextComponents = _4_6;
              else {
                _4_6 = t2[2];
                nextComponents = _4_6;
                _4_6_isSet = true;
              }
              if (_4_7_isSet)
                followingComponents = _4_7;
              else {
                _4_7 = t2[3];
                followingComponents = _4_7;
                _4_7_isSet = true;
              }
            }
          } else {
            _4_5_isSet = _4_4_isSet;
            _4_4_isSet = _4_4_isSet0;
            t3 = false;
          }
        } else {
          _4_10 = _null;
          _4_5_isSet = _4_4_isSet;
          _4_4_isSet = _4_4_isSet0;
          t3 = true;
        }
        if (t3) {
          next = nextComponents.removeLast$0(0);
          following = followingComponents.removeLast$0(0);
          t1 = following.selector;
          t2 = next.selector;
          t3 = type$.JSArray_ComplexSelectorComponent;
          t4 = type$.JSArray_List_ComplexSelectorComponent;
          if (A.compoundIsSuperselector(t1, t2, _null))
            result.addFirst$1(A._setArrayType([A._setArrayType([next], t3)], t4));
          else {
            t4 = A._setArrayType([A._setArrayType([following, next], t3)], t4);
            _3_0 = A.unifyCompound(t1, t2);
            if (_3_0 != null)
              t4.push(A._setArrayType([new A.ComplexSelectorComponent(_3_0, A.List_List$unmodifiable(next.combinators, type$.CssValue_Combinator), span)], t3));
            result.addFirst$1(t4);
          }
          break $label2$2;
        }
        if (B.Combinator_8I8 === _4_1) {
          if (_4_3)
            t3 = _4_9;
          else {
            if (_4_4_isSet)
              t3 = _4_4;
            else {
              _4_4 = t2[1];
              t3 = _4_4;
              _4_4_isSet = true;
            }
            _4_9 = B.Combinator_gRV === t3;
            t3 = _4_9;
          }
          if (!t3)
            if (_4_5_isSet)
              t3 = _4_5;
            else {
              if (_4_4_isSet)
                t3 = _4_4;
              else {
                _4_4 = t2[1];
                t3 = _4_4;
                _4_4_isSet = true;
              }
              _4_5 = B.Combinator_y18 === t3;
              t3 = _4_5;
            }
          else
            t3 = true;
          if (t3) {
            if (_4_7_isSet)
              siblingComponents_case_0 = _4_7;
            else {
              _4_7 = t2[3];
              siblingComponents_case_0 = _4_7;
              _4_7_isSet = true;
            }
            t4 = siblingComponents_case_0;
          } else
            t4 = _null;
          t0 = t4;
          t4 = t3;
          t3 = t0;
        } else {
          t3 = _null;
          t4 = false;
        }
        if (!t4) {
          if (_4_10_isSet)
            t4 = _4_10;
          else {
            _4_10 = B.Combinator_gRV === _4_1;
            t4 = _4_10;
          }
          if (!t4)
            t4 = _4_3;
          else
            t4 = true;
          if (t4) {
            if (_4_4_isSet)
              t4 = _4_4;
            else {
              _4_4 = t2[1];
              t4 = _4_4;
              _4_4_isSet = true;
            }
            t4 = B.Combinator_8I8 === t4;
            if (t4) {
              if (_4_6_isSet)
                siblingComponents_case_1 = _4_6;
              else {
                _4_6 = t2[2];
                siblingComponents_case_1 = _4_6;
                _4_6_isSet = true;
              }
              t3 = siblingComponents_case_1;
            }
          } else
            t4 = false;
        } else
          t4 = true;
        if (t4) {
          result.addFirst$1(A._setArrayType([A._setArrayType([t3.removeLast$0(0)], type$.JSArray_ComplexSelectorComponent)], type$.JSArray_List_ComplexSelectorComponent));
          break $label2$2;
        }
        t3 = _4_1 == null;
        t4 = !t3;
        if (t4) {
          combinator1 = _4_1;
          if (_4_4_isSet)
            t5 = _4_4;
          else {
            _4_4 = t2[1];
            t5 = _4_4;
            _4_4_isSet = true;
          }
          if (t5 != null) {
            if (_4_4_isSet)
              combinator2 = _4_4;
            else {
              _4_4 = t2[1];
              combinator2 = _4_4;
              _4_4_isSet = true;
            }
            t5 = combinator1 === (combinator2 == null ? type$.Combinator._as(combinator2) : combinator2);
          } else
            t5 = false;
        } else
          t5 = false;
        if (t5) {
          unified = A.unifyCompound(components1.removeLast$0(0).selector, components2.removeLast$0(0).selector);
          if (unified == null)
            return _null;
          result.addFirst$1(A._setArrayType([A._setArrayType([new A.ComplexSelectorComponent(unified, A.List_List$unmodifiable(A._setArrayType([B.JSArray_methods.get$first(t1)], type$.JSArray_CssValue_Combinator), type$.CssValue_Combinator), span)], type$.JSArray_ComplexSelectorComponent)], type$.JSArray_List_ComplexSelectorComponent));
          break $label2$2;
        }
        if (t4) {
          combinator_case_0 = _4_1;
          if (_4_4_isSet)
            t1 = _4_4;
          else {
            _4_4 = t2[1];
            t1 = _4_4;
            _4_4_isSet = true;
          }
          t1 = t1 == null;
          if (t1) {
            if (_4_6_isSet)
              combinatorComponents_case_0 = _4_6;
            else {
              _4_6 = t2[2];
              combinatorComponents_case_0 = _4_6;
              _4_6_isSet = true;
            }
            if (_4_7_isSet)
              descendantComponents_case_0 = _4_7;
            else {
              _4_7 = t2[3];
              descendantComponents_case_0 = _4_7;
              _4_7_isSet = true;
            }
            t4 = descendantComponents_case_0;
            t6 = t4;
            t4 = combinator_case_0;
            t5 = combinatorComponents_case_0;
          } else {
            t6 = _null;
            t5 = t6;
            t4 = t5;
          }
          t0 = t6;
          t6 = t1;
          t1 = t4;
          t4 = t5;
          t5 = t0;
        } else {
          t5 = _null;
          t4 = t5;
          t1 = t4;
          t6 = false;
        }
        if (!t6)
          if (t3) {
            if (_4_4_isSet)
              t3 = _4_4;
            else {
              _4_4 = t2[1];
              t3 = _4_4;
              _4_4_isSet = true;
            }
            t3 = t3 != null;
            if (t3) {
              combinator_case_1 = _4_4_isSet ? _4_4 : t2[1];
              if (combinator_case_1 == null)
                combinator_case_1 = type$.Combinator._as(combinator_case_1);
              descendantComponents_case_1 = _4_6_isSet ? _4_6 : t2[2];
              combinatorComponents_case_1 = _4_7_isSet ? _4_7 : t2[3];
              t1 = combinatorComponents_case_1;
              t2 = descendantComponents_case_1;
              t4 = t2;
              t2 = t1;
              t1 = combinator_case_1;
            } else {
              t2 = t4;
              t4 = t5;
            }
            t0 = t4;
            t4 = t3;
            t3 = t0;
          } else {
            t3 = t5;
            t2 = t4;
            t4 = false;
          }
        else {
          t3 = t5;
          t2 = t4;
          t4 = true;
        }
        if (t4) {
          if (t1 === B.Combinator_8I8) {
            t1 = A.IterableExtension_get_lastOrNull(t3);
            t1 = t1 == null ? _null : A.compoundIsSuperselector(t1.selector, t2.get$last(t2).selector, _null);
            t1 = t1 === true;
          } else
            t1 = false;
          if (t1)
            t3.removeLast$0(0);
          result.addFirst$1(A._setArrayType([A._setArrayType([t2.removeLast$0(0)], type$.JSArray_ComplexSelectorComponent)], type$.JSArray_List_ComplexSelectorComponent));
          break $label2$2;
        }
        return _null;
      }
      return A._mergeTrailingCombinators(components1, components2, span, result);
    },
    _mustUnify(complex1, complex2) {
      var t2, t3, t4,
        t1 = A.LinkedHashSet_LinkedHashSet$_empty(type$.SimpleSelector);
      for (t2 = J.get$iterator$ax(complex1); t2.moveNext$0();)
        for (t3 = B.JSArray_methods.get$iterator(t2.get$current(t2).selector.components), t4 = new A.WhereIterator(t3, A.functions___isUnique$closure()); t4.moveNext$0();)
          t1.add$1(0, t3.get$current(0));
      if (t1._collection$_length === 0)
        return false;
      return J.any$1$ax(complex2, new A._mustUnify_closure(t1));
    },
    _isUnique(simple) {
      var t1;
      if (!(simple instanceof A.IDSelector))
        t1 = simple instanceof A.PseudoSelector && !simple.isClass;
      else
        t1 = true;
      return t1;
    },
    _chunks(queue1, queue2, done, $T) {
      var chunk2, _0_4, _0_5_isSet, _0_1, _0_7, _0_5, chunk, _0_5_isSet0, t2, _null = null,
        t1 = $T._eval$1("JSArray<0>"),
        chunk1 = A._setArrayType([], t1);
      for (; !done.call$1(queue1);)
        chunk1.push(queue1.removeFirst$0());
      chunk2 = A._setArrayType([], t1);
      for (; !done.call$1(queue2);)
        chunk2.push(queue2.removeFirst$0());
      $label0$0: {
        _0_4 = chunk1.length <= 0;
        _0_5_isSet = _0_4;
        _0_1 = chunk1;
        if (_0_5_isSet) {
          _0_7 = chunk2.length <= 0;
          t1 = _0_7;
          _0_5 = chunk2;
        } else {
          _0_5 = _null;
          _0_7 = _0_5;
          t1 = false;
        }
        if (t1) {
          t1 = A._setArrayType([], $T._eval$1("JSArray<List<0>>"));
          break $label0$0;
        }
        if (_0_4)
          if (_0_5_isSet) {
            chunk = _0_5;
            _0_5_isSet0 = _0_5_isSet;
          } else {
            chunk = chunk2;
            _0_5 = chunk;
            _0_5_isSet0 = true;
          }
        else {
          chunk = _null;
          _0_5_isSet0 = _0_5_isSet;
        }
        if (!_0_4) {
          if (_0_5_isSet)
            t1 = _0_7;
          else {
            _0_7 = (_0_5_isSet0 ? _0_5 : chunk2).length <= 0;
            t1 = _0_7;
          }
          chunk = _0_1;
        } else
          t1 = true;
        if (t1) {
          t1 = A._setArrayType([chunk], $T._eval$1("JSArray<List<0>>"));
          break $label0$0;
        }
        t1 = A.List_List$of(chunk1, true, $T);
        B.JSArray_methods.addAll$1(t1, chunk2);
        t2 = A.List_List$of(chunk2, true, $T);
        B.JSArray_methods.addAll$1(t2, chunk1);
        t2 = A._setArrayType([t1, t2], $T._eval$1("JSArray<List<0>>"));
        t1 = t2;
        break $label0$0;
      }
      return t1;
    },
    paths(choices, $T) {
      return J.fold$2$ax(choices, A._setArrayType([A._setArrayType([], $T._eval$1("JSArray<0>"))], $T._eval$1("JSArray<List<0>>")), new A.paths_closure($T));
    },
    _groupSelectors(complex) {
      var t2, t3, t4,
        groups = A.QueueList$(null, type$.List_ComplexSelectorComponent),
        t1 = type$.JSArray_ComplexSelectorComponent,
        group = A._setArrayType([], t1);
      for (t2 = complex.$ti, t3 = new A.ListIterator(complex, complex.get$length(0), t2._eval$1("ListIterator<ListBase.E>")), t2 = t2._eval$1("ListBase.E"); t3.moveNext$0();) {
        t4 = t3.__internal$_current;
        if (t4 == null)
          t4 = t2._as(t4);
        group.push(t4);
        if (t4.combinators.length === 0) {
          groups._queue_list$_add$1(group);
          group = A._setArrayType([], t1);
        }
      }
      if (group.length !== 0)
        groups._queue_list$_add$1(group);
      return groups;
    },
    listIsSuperselector(list1, list2) {
      return B.JSArray_methods.every$1(list2, new A.listIsSuperselector_closure(list1));
    },
    _complexIsParentSuperselector(complex1, complex2) {
      var t1, base, t2;
      if (J.get$length$asx(complex1) > J.get$length$asx(complex2))
        return false;
      t1 = $.$get$bogusSpan();
      base = new A.ComplexSelectorComponent(A.CompoundSelector$(A._setArrayType([new A.PlaceholderSelector("<temp>", t1)], type$.JSArray_SimpleSelector), t1), A.List_List$unmodifiable(B.List_empty0, type$.CssValue_Combinator), t1);
      t1 = type$.ComplexSelectorComponent;
      t2 = A.List_List$of(complex1, true, t1);
      t2.push(base);
      t1 = A.List_List$of(complex2, true, t1);
      t1.push(base);
      return A.complexIsSuperselector(t2, t1);
    },
    complexIsSuperselector(complex1, complex2) {
      var t1, t2, previousCombinator, i1, i2, remaining1, remaining2, component1, t3, t4, endOfSubselector, component2, t5, combinator1, _null = null;
      if (B.JSArray_methods.get$last(complex1).combinators.length !== 0)
        return false;
      if (B.JSArray_methods.get$last(complex2).combinators.length !== 0)
        return false;
      for (t1 = A._arrayInstanceType(complex2), t2 = t1._precomputed1, t1 = t1._eval$1("SubListIterable<1>"), previousCombinator = _null, i1 = 0, i2 = 0; true; previousCombinator = combinator1) {
        remaining1 = complex1.length - i1;
        remaining2 = complex2.length - i2;
        if (remaining1 === 0 || remaining2 === 0)
          return false;
        if (remaining1 > remaining2)
          return false;
        component1 = complex1[i1];
        t3 = component1.combinators;
        if (t3.length > 1)
          return false;
        if (remaining1 === 1)
          if (B.JSArray_methods.any$1(complex2, new A.complexIsSuperselector_closure()))
            return false;
          else {
            t1 = component1.selector;
            t2 = B.JSArray_methods.get$last(complex2).selector;
            return A.compoundIsSuperselector(t1, t2, t1.get$hasComplicatedSuperselectorSemantics() ? B.JSArray_methods.sublist$2(complex2, i2, complex2.length - 1) : _null);
          }
        for (t4 = component1.selector, endOfSubselector = i2; true;) {
          component2 = complex2[endOfSubselector];
          if (component2.combinators.length > 1)
            return false;
          t5 = component2.selector;
          if (A.compoundIsSuperselector(t4, t5, t4.get$hasComplicatedSuperselectorSemantics() ? B.JSArray_methods.sublist$2(complex2, i2, endOfSubselector) : _null))
            break;
          ++endOfSubselector;
          if (endOfSubselector === complex2.length - 1)
            return false;
        }
        t4 = new A.SubListIterable(complex2, 0, endOfSubselector, t1);
        t4.SubListIterable$3(complex2, 0, endOfSubselector, t2);
        if (!A._compatibleWithPreviousCombinator(previousCombinator, t4.skip$1(0, i2)))
          return false;
        component2 = complex2[endOfSubselector];
        combinator1 = A.IterableExtension_get_firstOrNull(t3);
        if (!A._isSupercombinator(combinator1, A.IterableExtension_get_firstOrNull(component2.combinators)))
          return false;
        ++i1;
        i2 = endOfSubselector + 1;
        if (complex1.length - i1 === 1) {
          t3 = combinator1 == null;
          if (J.$eq$(t3 ? _null : combinator1.value, B.Combinator_y18)) {
            t3 = complex2.length - 1;
            t4 = new A.SubListIterable(complex2, 0, t3, t1);
            t4.SubListIterable$3(complex2, 0, t3, t2);
            if (!t4.skip$1(0, i2).every$1(0, new A.complexIsSuperselector_closure0(combinator1)))
              return false;
          } else if (!t3)
            if (complex2.length - i2 > 1)
              return false;
        }
      }
    },
    _compatibleWithPreviousCombinator(previous, parents) {
      if (parents.get$isEmpty(parents))
        return true;
      if (previous == null)
        return true;
      if (previous.value !== B.Combinator_y18)
        return false;
      return parents.every$1(0, new A._compatibleWithPreviousCombinator_closure());
    },
    _isSupercombinator(combinator1, combinator2) {
      var t1, t2;
      if (!J.$eq$(combinator1, combinator2)) {
        t1 = combinator1 == null;
        if (t1)
          t2 = J.$eq$(combinator2 == null ? null : combinator2.value, B.Combinator_8I8);
        else
          t2 = false;
        if (!t2)
          if (J.$eq$(t1 ? null : combinator1.value, B.Combinator_y18))
            t1 = J.$eq$(combinator2 == null ? null : combinator2.value, B.Combinator_gRV);
          else
            t1 = false;
        else
          t1 = true;
      } else
        t1 = true;
      return t1;
    },
    compoundIsSuperselector(compound1, compound2, parents) {
      var t1, _0_1, _0_5, _0_5_isSet, t2, pseudo1, index1, t3, pseudo2, index2, _0_50, t4, t5, _i, simple1, _null = null;
      if (!compound1.get$hasComplicatedSuperselectorSemantics() && !compound2.get$hasComplicatedSuperselectorSemantics()) {
        t1 = compound1.components;
        if (t1.length > compound2.components.length)
          return false;
        return B.JSArray_methods.every$1(t1, new A.compoundIsSuperselector_closure(compound2));
      }
      _0_1 = A._findPseudoElementIndexed(compound1);
      _0_5 = A._findPseudoElementIndexed(compound2);
      t1 = type$.Record_2_nullable_Object_and_nullable_Object;
      _0_5_isSet = t1._is(_0_1);
      if (_0_5_isSet) {
        t2 = _0_1 == null;
        pseudo1 = (t2 ? t1._as(_0_1) : _0_1)._0;
        index1 = (t2 ? t1._as(_0_1) : _0_1)._1;
        t2 = t1._is(_0_5);
        if (t2) {
          t3 = _0_5 == null;
          pseudo2 = (t3 ? t1._as(_0_5) : _0_5)._0;
          index2 = (t3 ? t1._as(_0_5) : _0_5)._1;
        } else {
          index2 = _null;
          pseudo2 = index2;
        }
        t1 = t2;
        _0_50 = _0_5;
      } else {
        index2 = _null;
        pseudo2 = index2;
        index1 = pseudo2;
        pseudo1 = index1;
        _0_50 = pseudo1;
        t1 = false;
      }
      if (t1) {
        if (pseudo1.isSuperselector$1(pseudo2)) {
          t1 = compound1.components;
          t2 = type$.int;
          t3 = A._arrayInstanceType(t1)._precomputed1;
          t4 = compound2.components;
          t5 = A._arrayInstanceType(t4)._precomputed1;
          t1 = A._compoundComponentsIsSuperselector(A.SubListIterable$(t1, 0, A.checkNotNullable(index1, "count", t2), t3), A.SubListIterable$(t4, 0, A.checkNotNullable(index2, "count", t2), t5), parents) && A._compoundComponentsIsSuperselector(A.SubListIterable$(t1, index1 + 1, _null, t3), A.SubListIterable$(t4, index2 + 1, _null, t5), parents);
        } else
          t1 = false;
        return t1;
      }
      if (_0_1 == null)
        t1 = (_0_5_isSet ? _0_50 : _0_5) != null;
      else
        t1 = true;
      if (t1)
        return false;
      for (t1 = compound1.components, t2 = t1.length, t3 = compound2.components, _i = 0; _i < t2; ++_i) {
        simple1 = t1[_i];
        if (simple1 instanceof A.PseudoSelector)
          t4 = simple1.selector != null;
        else
          t4 = false;
        if (t4) {
          if (!A._selectorPseudoIsSuperselector(simple1, compound2, parents))
            return false;
        } else if (!B.JSArray_methods.any$1(t3, simple1.get$isSuperselector()))
          return false;
      }
      return true;
    },
    _findPseudoElementIndexed(compound) {
      var t1, t2, i, simple;
      for (t1 = compound.components, t2 = t1.length, i = 0; i < t2; ++i) {
        simple = t1[i];
        if (simple instanceof A.PseudoSelector && !simple.isClass)
          return new A._Record_2(simple, i);
      }
      return null;
    },
    _compoundComponentsIsSuperselector(compound1, compound2, parents) {
      var t1;
      if (compound1.get$length(0) === 0)
        return true;
      if (compound2.get$length(0) === 0)
        compound2 = A._setArrayType([new A.UniversalSelector("*", $.$get$bogusSpan())], type$.JSArray_SimpleSelector);
      t1 = $.$get$bogusSpan();
      return A.compoundIsSuperselector(A.CompoundSelector$(compound1, t1), A.CompoundSelector$(compound2, t1), parents);
    },
    _selectorPseudoIsSuperselector(pseudo1, compound2, parents) {
      var selector1 = pseudo1.selector;
      if (selector1 == null)
        throw A.wrapException(A.ArgumentError$("Selector " + pseudo1.toString$0(0) + " must have a selector argument.", null));
      switch (pseudo1.normalizedName) {
        case "is":
        case "matches":
        case "any":
        case "where":
          return A._selectorPseudoArgs(compound2, pseudo1.name, true).any$1(0, new A._selectorPseudoIsSuperselector_closure(selector1)) || B.JSArray_methods.any$1(selector1.components, new A._selectorPseudoIsSuperselector_closure0(parents, compound2));
        case "has":
        case "host":
        case "host-context":
          return A._selectorPseudoArgs(compound2, pseudo1.name, true).any$1(0, new A._selectorPseudoIsSuperselector_closure1(selector1));
        case "slotted":
          return A._selectorPseudoArgs(compound2, pseudo1.name, false).any$1(0, new A._selectorPseudoIsSuperselector_closure2(selector1));
        case "not":
          return B.JSArray_methods.every$1(selector1.components, new A._selectorPseudoIsSuperselector_closure3(compound2, pseudo1));
        case "current":
          return A._selectorPseudoArgs(compound2, pseudo1.name, true).any$1(0, new A._selectorPseudoIsSuperselector_closure4(selector1));
        case "nth-child":
        case "nth-last-child":
          return B.JSArray_methods.any$1(compound2.components, new A._selectorPseudoIsSuperselector_closure5(pseudo1, selector1));
        default:
          throw A.wrapException("unreachable");
      }
    },
    _selectorPseudoArgs(compound, $name, isClass) {
      var t1 = type$.WhereTypeIterable_PseudoSelector;
      return A.IterableNullableExtension_whereNotNull(new A.MappedIterable(new A.WhereIterable(new A.WhereTypeIterable(compound.components, t1), new A._selectorPseudoArgs_closure(isClass, $name), t1._eval$1("WhereIterable<Iterable.E>")), new A._selectorPseudoArgs_closure0(), t1._eval$1("MappedIterable<Iterable.E,SelectorList?>")), type$.SelectorList);
    },
    unifyComplex_closure: function unifyComplex_closure() {
    },
    _weaveParents_closure: function _weaveParents_closure(t0) {
      this.span = t0;
    },
    _weaveParents_closure0: function _weaveParents_closure0(t0) {
      this.group = t0;
    },
    _weaveParents_closure1: function _weaveParents_closure1() {
    },
    _weaveParents_closure2: function _weaveParents_closure2() {
    },
    _mustUnify_closure: function _mustUnify_closure(t0) {
      this.uniqueSelectors = t0;
    },
    _mustUnify__closure: function _mustUnify__closure(t0) {
      this.uniqueSelectors = t0;
    },
    paths_closure: function paths_closure(t0) {
      this.T = t0;
    },
    paths__closure: function paths__closure(t0, t1) {
      this.paths = t0;
      this.T = t1;
    },
    paths___closure: function paths___closure(t0, t1) {
      this.option = t0;
      this.T = t1;
    },
    listIsSuperselector_closure: function listIsSuperselector_closure(t0) {
      this.list1 = t0;
    },
    listIsSuperselector__closure: function listIsSuperselector__closure(t0) {
      this.complex1 = t0;
    },
    complexIsSuperselector_closure: function complexIsSuperselector_closure() {
    },
    complexIsSuperselector_closure0: function complexIsSuperselector_closure0(t0) {
      this.combinator1 = t0;
    },
    _compatibleWithPreviousCombinator_closure: function _compatibleWithPreviousCombinator_closure() {
    },
    compoundIsSuperselector_closure: function compoundIsSuperselector_closure(t0) {
      this.compound2 = t0;
    },
    _selectorPseudoIsSuperselector_closure: function _selectorPseudoIsSuperselector_closure(t0) {
      this.selector1 = t0;
    },
    _selectorPseudoIsSuperselector_closure0: function _selectorPseudoIsSuperselector_closure0(t0, t1) {
      this.parents = t0;
      this.compound2 = t1;
    },
    _selectorPseudoIsSuperselector_closure1: function _selectorPseudoIsSuperselector_closure1(t0) {
      this.selector1 = t0;
    },
    _selectorPseudoIsSuperselector_closure2: function _selectorPseudoIsSuperselector_closure2(t0) {
      this.selector1 = t0;
    },
    _selectorPseudoIsSuperselector_closure3: function _selectorPseudoIsSuperselector_closure3(t0, t1) {
      this.compound2 = t0;
      this.pseudo1 = t1;
    },
    _selectorPseudoIsSuperselector__closure: function _selectorPseudoIsSuperselector__closure(t0, t1) {
      this.complex = t0;
      this.pseudo1 = t1;
    },
    _selectorPseudoIsSuperselector___closure: function _selectorPseudoIsSuperselector___closure(t0) {
      this.simple2 = t0;
    },
    _selectorPseudoIsSuperselector___closure0: function _selectorPseudoIsSuperselector___closure0(t0) {
      this.simple2 = t0;
    },
    _selectorPseudoIsSuperselector_closure4: function _selectorPseudoIsSuperselector_closure4(t0) {
      this.selector1 = t0;
    },
    _selectorPseudoIsSuperselector_closure5: function _selectorPseudoIsSuperselector_closure5(t0, t1) {
      this.pseudo1 = t0;
      this.selector1 = t1;
    },
    _selectorPseudoArgs_closure: function _selectorPseudoArgs_closure(t0, t1) {
      this.isClass = t0;
      this.name = t1;
    },
    _selectorPseudoArgs_closure0: function _selectorPseudoArgs_closure0() {
    },
    MergedExtension_merge(left, right) {
      var t2, t3, t4,
        t1 = left.extender.selector;
      if (!t1.$eq(0, right.extender.selector) || !left.target.$eq(0, right.target))
        throw A.wrapException(A.ArgumentError$(left.toString$0(0) + " and " + right.toString$0(0) + " aren't the same extension.", null));
      t2 = left.mediaContext;
      t3 = t2 == null;
      if (!t3) {
        t4 = right.mediaContext;
        t4 = t4 != null && !B.C_ListEquality.equals$2(0, t2, t4);
      } else
        t4 = false;
      if (t4)
        throw A.wrapException(A.SassException$("From " + left.span.message$1(0, "") + string$.x0aYou_m, right.span, null));
      if (right.isOptional && right.mediaContext == null)
        return left;
      if (left.isOptional && t3)
        return right;
      if (t3)
        t2 = right.mediaContext;
      t1.get$specificity();
      t1 = new A.Extender(t1, false);
      return t1._extension = new A.MergedExtension(left, right, t1, left.target, t2, true, left.span);
    },
    MergedExtension: function MergedExtension(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.left = t0;
      _.right = t1;
      _.extender = t2;
      _.target = t3;
      _.mediaContext = t4;
      _.isOptional = t5;
      _.span = t6;
    },
    ExtendMode: function ExtendMode(t0, t1) {
      this.name = t0;
      this._name = t1;
    },
    globalFunctions_closure: function globalFunctions_closure() {
    },
    _updateComponents($arguments, adjust, change, scale) {
      var keywords, alpha, red, green, blue, hue, saturation, lightness, whiteness, blackness, hasRgb, hasSL, hasWB, t2, t3, t4, t5, _null = null,
        t1 = J.getInterceptor$asx($arguments),
        color = t1.$index($arguments, 0).assertColor$1("color"),
        argumentList = type$.SassArgumentList._as(t1.$index($arguments, 1));
      if (argumentList._list$_contents.length !== 0)
        throw A.wrapException(A.SassScriptException$(string$.Only_op, _null));
      argumentList._wereKeywordsAccessed = true;
      keywords = A.LinkedHashMap_LinkedHashMap$of(argumentList._keywords, type$.String, type$.Value);
      t1 = new A._updateComponents_getParam(keywords, scale, change);
      alpha = t1.call$3$checkUnitless("alpha", 1, true);
      red = t1.call$2("red", 255);
      green = t1.call$2("green", 255);
      blue = t1.call$2("blue", 255);
      hue = scale ? _null : A.NullableExtension_andThen(keywords.remove$1(0, "hue"), new A._updateComponents_closure());
      saturation = t1.call$3$checkPercent("saturation", 100, true);
      lightness = t1.call$3$checkPercent("lightness", 100, true);
      whiteness = t1.call$3$assertPercent("whiteness", 100, true);
      blackness = t1.call$3$assertPercent("blackness", 100, true);
      t1 = keywords.__js_helper$_length;
      if (t1 !== 0)
        throw A.wrapException(A.SassScriptException$("No " + A.pluralize("argument", t1, _null) + " named " + A.toSentence(keywords.get$keys(0).map$1$1(0, new A._updateComponents_closure0(), type$.Object), "or") + ".", _null));
      hasRgb = red != null || green != null || blue != null;
      hasSL = saturation != null || lightness != null;
      hasWB = whiteness != null || blackness != null;
      if (hasRgb)
        t1 = hasSL || hasWB || hue != null;
      else
        t1 = false;
      if (t1)
        throw A.wrapException(A.SassScriptException$(string$.RGB_pa + (hasWB ? "HWB" : "HSL") + " parameters.", _null));
      if (hasSL && hasWB)
        throw A.wrapException(A.SassScriptException$(string$.HSL_pa, _null));
      t1 = new A._updateComponents_updateValue(change, adjust);
      t2 = new A._updateComponents_updateRgb(t1);
      if (hasRgb) {
        t3 = t2.call$2(color.get$red(0), red);
        t4 = t2.call$2(color.get$green(0), green);
        t2 = t2.call$2(color.get$blue(0), blue);
        return color.changeRgb$4$alpha$blue$green$red(t1.call$3(color._alpha, alpha, 1), t2, t4, t3);
      } else if (hasWB) {
        if (change)
          t2 = hue;
        else {
          t2 = color.get$hue(0);
          t2 += hue == null ? 0 : hue;
        }
        t3 = t1.call$3(color.get$whiteness(0), whiteness, 100);
        t4 = t1.call$3(color.get$blackness(0), blackness, 100);
        t5 = color._alpha;
        t1 = t1.call$3(t5, alpha, 1);
        if (t2 == null)
          t2 = color.get$hue(0);
        if (t3 == null)
          t3 = color.get$whiteness(0);
        if (t4 == null)
          t4 = color.get$blackness(0);
        return A.SassColor_SassColor$hwb(t2, t3, t4, t1 == null ? t5 : t1);
      } else {
        t2 = hue == null;
        if (!t2 || hasSL) {
          if (change)
            t2 = hue;
          else {
            t3 = color.get$hue(0);
            t3 += t2 ? 0 : hue;
            t2 = t3;
          }
          t3 = t1.call$3(color.get$saturation(0), saturation, 100);
          t4 = t1.call$3(color.get$lightness(0), lightness, 100);
          return color.changeHsl$4$alpha$hue$lightness$saturation(t1.call$3(color._alpha, alpha, 1), t2, t4, t3);
        } else if (alpha != null)
          return color.changeAlpha$1(t1.call$3(color._alpha, alpha, 1));
        else
          return color;
      }
    },
    _functionString($name, $arguments) {
      return new A.SassString($name + "(" + J.map$1$1$ax($arguments, new A._functionString_closure(), type$.String).join$1(0, ", ") + ")", false);
    },
    _removedColorFunction($name, argument, negative) {
      return A.BuiltInCallable$function($name, "$color, $amount", new A._removedColorFunction_closure($name, argument, negative), "sass:color");
    },
    _rgb($name, $arguments) {
      var t2, red, green, blue, t3, t4,
        t1 = J.getInterceptor$asx($arguments),
        alpha = t1.get$length($arguments) > 3 ? t1.$index($arguments, 3) : null;
      if (!t1.$index($arguments, 0).get$isSpecialNumber())
        if (!t1.$index($arguments, 1).get$isSpecialNumber())
          if (!t1.$index($arguments, 2).get$isSpecialNumber()) {
            t2 = alpha == null ? null : alpha.get$isSpecialNumber();
            t2 = t2 === true;
          } else
            t2 = true;
        else
          t2 = true;
      else
        t2 = true;
      if (t2)
        return A._functionString($name, $arguments);
      red = t1.$index($arguments, 0).assertNumber$1("red");
      green = t1.$index($arguments, 1).assertNumber$1("green");
      blue = t1.$index($arguments, 2).assertNumber$1("blue");
      t1 = A.fuzzyRound(A._percentageOrUnitless(red, 255, "red"));
      t2 = A.fuzzyRound(A._percentageOrUnitless(green, 255, "green"));
      t3 = A.fuzzyRound(A._percentageOrUnitless(blue, 255, "blue"));
      t4 = A.NullableExtension_andThen(alpha, new A._rgb_closure());
      return A.SassColor$rgbInternal(t1, t2, t3, t4 == null ? 1 : t4, B._ColorFormatEnum_rgbFunction);
    },
    _rgbTwoArg($name, $arguments) {
      var t2, color,
        t1 = J.getInterceptor$asx($arguments);
      if (!t1.$index($arguments, 0).get$isVar())
        t2 = !(t1.$index($arguments, 0) instanceof A.SassColor) && t1.$index($arguments, 1).get$isVar();
      else
        t2 = true;
      if (t2)
        return A._functionString($name, $arguments);
      else if (t1.$index($arguments, 1).get$isSpecialNumber()) {
        color = t1.$index($arguments, 0).assertColor$1("color");
        return new A.SassString($name + "(" + color.get$red(0) + ", " + color.get$green(0) + ", " + color.get$blue(0) + ", " + A.serializeValue(t1.$index($arguments, 1), false, true) + ")", false);
      }
      return t1.$index($arguments, 0).assertColor$1("color").changeAlpha$1(A._percentageOrUnitless(t1.$index($arguments, 1).assertNumber$1("alpha"), 1, "alpha"));
    },
    _hsl($name, $arguments) {
      var t2, hue, saturation, lightness, t3,
        _s10_ = "saturation",
        _s9_ = "lightness",
        t1 = J.getInterceptor$asx($arguments),
        alpha = t1.get$length($arguments) > 3 ? t1.$index($arguments, 3) : null;
      if (!t1.$index($arguments, 0).get$isSpecialNumber())
        if (!t1.$index($arguments, 1).get$isSpecialNumber())
          if (!t1.$index($arguments, 2).get$isSpecialNumber()) {
            t2 = alpha == null ? null : alpha.get$isSpecialNumber();
            t2 = t2 === true;
          } else
            t2 = true;
        else
          t2 = true;
      else
        t2 = true;
      if (t2)
        return A._functionString($name, $arguments);
      hue = A._angleValue(t1.$index($arguments, 0), "hue");
      saturation = t1.$index($arguments, 1).assertNumber$1(_s10_);
      lightness = t1.$index($arguments, 2).assertNumber$1(_s9_);
      A._checkPercent(saturation, _s10_);
      A._checkPercent(lightness, _s9_);
      t1 = B.JSNumber_methods.clamp$2(saturation._number$_value, 0, 100);
      t2 = B.JSNumber_methods.clamp$2(lightness._number$_value, 0, 100);
      t3 = A.NullableExtension_andThen(alpha, new A._hsl_closure());
      return A.SassColor$hslInternal(hue, t1, t2, t3 == null ? 1 : t3, B._ColorFormatEnum_hslFunction);
    },
    _angleValue(angleValue, $name) {
      var angle = angleValue.assertNumber$1($name);
      if (angle.compatibleWithUnit$1("deg"))
        return angle.coerceValueToUnit$1("deg");
      A.warnForDeprecation("$" + $name + ": Passing a unit other than deg (" + angle.toString$0(0) + string$.x29x20is_d + angle.unitSuggestion$1($name) + string$.x0a_See_, B.Deprecation_2jN);
      return angle._number$_value;
    },
    _checkPercent(number, $name) {
      if (number.hasUnit$1("%"))
        return;
      A.warnForDeprecation("$" + $name + ": Passing a number without unit % (" + number.toString$0(0) + string$.x29x20is_d + number.unitSuggestion$2($name, "%") + string$.x0a_Morex3a, B.Deprecation_2jN);
    },
    _hwb($arguments) {
      var t2, t3,
        _s9_ = "whiteness",
        _s9_0 = "blackness",
        t1 = J.getInterceptor$asx($arguments),
        alpha = t1.get$length($arguments) > 3 ? t1.$index($arguments, 3) : null,
        hue = A._angleValue(t1.$index($arguments, 0), "hue"),
        whiteness = t1.$index($arguments, 1).assertNumber$1(_s9_),
        blackness = t1.$index($arguments, 2).assertNumber$1(_s9_0);
      whiteness.assertUnit$2("%", _s9_);
      blackness.assertUnit$2("%", _s9_0);
      t1 = whiteness.valueInRange$3(0, 100, _s9_);
      t2 = blackness.valueInRange$3(0, 100, _s9_0);
      t3 = A.NullableExtension_andThen(alpha, new A._hwb_closure());
      return A.SassColor_SassColor$hwb(hue, t1, t2, t3 == null ? 1 : t3);
    },
    _parseChannels($name, argumentNames, channels) {
      var list, t1, channels0, alphaFromSlashList, isCommaSeparated, isBracketed, buffer, _0_4, _1_0, _1_2_isSet, _1_2, t2, _null = null,
        _s17_ = "$channels must be";
      if (channels.get$isVar())
        return A._functionString($name, A._setArrayType([channels], type$.JSArray_Value));
      if (channels.get$separator(channels) === B.ListSeparator_cQA) {
        list = channels.get$asList();
        t1 = list.length;
        if (t1 !== 2)
          throw A.wrapException(A.SassScriptException$(string$.Only_2 + t1 + " " + A.pluralize("was", t1, "were") + " passed.", _null));
        channels0 = list[0];
        alphaFromSlashList = list[1];
        if (!alphaFromSlashList.get$isSpecialNumber())
          alphaFromSlashList.assertNumber$1("alpha");
        if (list[0].get$isVar())
          return A._functionString($name, A._setArrayType([channels], type$.JSArray_Value));
      } else {
        alphaFromSlashList = _null;
        channels0 = channels;
      }
      isCommaSeparated = channels0.get$separator(channels0) === B.ListSeparator_ECn;
      isBracketed = channels0.get$hasBrackets();
      if (isCommaSeparated || isBracketed) {
        buffer = new A.StringBuffer(_s17_);
        if (isBracketed) {
          t1 = _s17_ + " an unbracketed";
          buffer._contents = t1;
        } else
          t1 = _s17_;
        if (isCommaSeparated) {
          t1 += isBracketed ? "," : " a";
          buffer._contents = t1;
          t1 = buffer._contents = t1 + " space-separated";
        }
        buffer._contents = t1 + " list.";
        throw A.wrapException(A.SassScriptException$(buffer.toString$0(0), _null));
      }
      list = channels0.get$asList();
      if (list.length >= 2) {
        _0_4 = list[0];
        t1 = _0_4;
        if (t1 instanceof A.SassString) {
          type$.SassString._as(_0_4);
          t1 = !_0_4._hasQuotes && A.equalsIgnoreCase(_0_4._string$_text, "from");
        } else
          t1 = false;
      } else
        t1 = false;
      if (t1)
        return A._functionString($name, A._setArrayType([channels], type$.JSArray_Value));
      t1 = list.length;
      if (t1 > 3)
        throw A.wrapException(A.SassScriptException$("Only 3 elements allowed, but " + t1 + " were passed.", _null));
      else if (t1 < 3) {
        if (!B.JSArray_methods.any$1(list, new A._parseChannels_closure()))
          if (list.length !== 0) {
            t1 = B.JSArray_methods.get$last(list);
            if (t1 instanceof A.SassString)
              if (t1._hasQuotes) {
                t1 = t1._string$_text;
                t1 = A.startsWithIgnoreCase(t1, "var(") && B.JSString_methods.contains$1(t1, "/");
              } else
                t1 = false;
            else
              t1 = false;
          } else
            t1 = false;
        else
          t1 = true;
        if (t1)
          return A._functionString($name, A._setArrayType([channels], type$.JSArray_Value));
        else
          throw A.wrapException(A.SassScriptException$("Missing element " + argumentNames[list.length] + ".", _null));
      }
      if (alphaFromSlashList != null) {
        t1 = A.List_List$of(list, true, type$.Value);
        t1.push(alphaFromSlashList);
        return t1;
      }
      _1_0 = list[2];
      $label0$0: {
        _1_2_isSet = _1_0 instanceof A.SassNumber;
        if (_1_2_isSet) {
          _1_2 = _1_0.asSlash;
          t1 = type$.Record_2_nullable_Object_and_nullable_Object._is(_1_2);
        } else {
          _1_2 = _null;
          t1 = false;
        }
        if (t1) {
          if (_1_2_isSet)
            t1 = _1_2;
          else {
            _1_2 = _1_0.asSlash;
            t1 = _1_2;
            _1_2_isSet = true;
          }
          if (t1 == null)
            t1 = type$.Record_2_nullable_Object_and_nullable_Object._as(t1);
          t2 = _1_2_isSet ? _1_2 : _1_0.asSlash;
          if (t2 == null)
            t2 = type$.Record_2_nullable_Object_and_nullable_Object._as(t2);
          t2 = A._setArrayType([list[0], list[1], t1._0, t2._1], type$.JSArray_Value);
          t1 = t2;
          break $label0$0;
        }
        if (_1_0 instanceof A.SassString)
          if (!_1_0._hasQuotes)
            t1 = B.JSString_methods.contains$1(_1_0._string$_text, "/");
          else
            t1 = false;
        else
          t1 = false;
        if (t1) {
          t1 = A._functionString($name, A._setArrayType([channels0], type$.JSArray_Value));
          break $label0$0;
        }
        t1 = list;
        break $label0$0;
      }
      return t1;
    },
    _percentageOrUnitless(number, max, $name) {
      var value;
      if (!number.get$hasUnits())
        value = number._number$_value;
      else if (number.hasUnit$1("%"))
        value = max * number._number$_value / 100;
      else
        throw A.wrapException(A.SassScriptException$("$" + $name + ": Expected " + number.toString$0(0) + ' to have unit "%" or no units.', null));
      return B.JSNumber_methods.clamp$2(value, 0, max);
    },
    _mixColors(color1, color2, weight) {
      var weightScale, normalizedWeight, t1, t2, alphaDistance, t3, weight1, weight2;
      A._checkPercent(weight, "weight");
      weightScale = weight.valueInRange$3(0, 100, "weight") / 100;
      normalizedWeight = weightScale * 2 - 1;
      t1 = color1._alpha;
      t2 = color2._alpha;
      alphaDistance = t1 - t2;
      t3 = normalizedWeight * alphaDistance;
      weight1 = ((t3 === -1 ? normalizedWeight : (normalizedWeight + alphaDistance) / (1 + t3)) + 1) / 2;
      weight2 = 1 - weight1;
      return A.SassColor$rgb(A.fuzzyRound(color1.get$red(0) * weight1 + color2.get$red(0) * weight2), A.fuzzyRound(color1.get$green(0) * weight1 + color2.get$green(0) * weight2), A.fuzzyRound(color1.get$blue(0) * weight1 + color2.get$blue(0) * weight2), t1 * weightScale + t2 * (1 - weightScale));
    },
    _opacify($arguments) {
      var t1 = J.getInterceptor$asx($arguments),
        color = t1.$index($arguments, 0).assertColor$1("color");
      return color.changeAlpha$1(B.JSNumber_methods.clamp$2(color._alpha + t1.$index($arguments, 1).assertNumber$1("amount").valueInRangeWithUnit$4(0, 1, "amount", ""), 0, 1));
    },
    _transparentize($arguments) {
      var t1 = J.getInterceptor$asx($arguments),
        color = t1.$index($arguments, 0).assertColor$1("color");
      return color.changeAlpha$1(B.JSNumber_methods.clamp$2(color._alpha - t1.$index($arguments, 1).assertNumber$1("amount").valueInRangeWithUnit$4(0, 1, "amount", ""), 0, 1));
    },
    _function4($name, $arguments, callback) {
      return A.BuiltInCallable$function($name, $arguments, callback, "sass:color");
    },
    global_closure0: function global_closure0() {
    },
    global_closure1: function global_closure1() {
    },
    global_closure2: function global_closure2() {
    },
    global_closure3: function global_closure3() {
    },
    global_closure4: function global_closure4() {
    },
    global_closure5: function global_closure5() {
    },
    global_closure6: function global_closure6() {
    },
    global_closure7: function global_closure7() {
    },
    global_closure8: function global_closure8() {
    },
    global_closure9: function global_closure9() {
    },
    global_closure10: function global_closure10() {
    },
    global_closure11: function global_closure11() {
    },
    global_closure12: function global_closure12() {
    },
    global_closure13: function global_closure13() {
    },
    global_closure14: function global_closure14() {
    },
    global_closure15: function global_closure15() {
    },
    global_closure16: function global_closure16() {
    },
    global_closure17: function global_closure17() {
    },
    global_closure18: function global_closure18() {
    },
    global_closure19: function global_closure19() {
    },
    global_closure20: function global_closure20() {
    },
    global_closure21: function global_closure21() {
    },
    global_closure22: function global_closure22() {
    },
    global_closure23: function global_closure23() {
    },
    global_closure24: function global_closure24() {
    },
    global_closure25: function global_closure25() {
    },
    global__closure: function global__closure() {
    },
    global_closure26: function global_closure26() {
    },
    module_closure1: function module_closure1() {
    },
    module_closure2: function module_closure2() {
    },
    module_closure3: function module_closure3() {
    },
    module_closure4: function module_closure4() {
    },
    module_closure5: function module_closure5() {
    },
    module_closure6: function module_closure6() {
    },
    module_closure7: function module_closure7() {
    },
    module_closure8: function module_closure8() {
    },
    module__closure1: function module__closure1() {
    },
    module_closure9: function module_closure9() {
    },
    _red_closure: function _red_closure() {
    },
    _green_closure: function _green_closure() {
    },
    _blue_closure: function _blue_closure() {
    },
    _mix_closure: function _mix_closure() {
    },
    _hue_closure: function _hue_closure() {
    },
    _saturation_closure: function _saturation_closure() {
    },
    _lightness_closure: function _lightness_closure() {
    },
    _complement_closure: function _complement_closure() {
    },
    _adjust_closure: function _adjust_closure() {
    },
    _scale_closure: function _scale_closure() {
    },
    _change_closure: function _change_closure() {
    },
    _ieHexStr_closure: function _ieHexStr_closure() {
    },
    _ieHexStr_closure_hexString: function _ieHexStr_closure_hexString() {
    },
    _updateComponents_getParam: function _updateComponents_getParam(t0, t1, t2) {
      this.keywords = t0;
      this.scale = t1;
      this.change = t2;
    },
    _updateComponents_closure: function _updateComponents_closure() {
    },
    _updateComponents_closure0: function _updateComponents_closure0() {
    },
    _updateComponents_updateValue: function _updateComponents_updateValue(t0, t1) {
      this.change = t0;
      this.adjust = t1;
    },
    _updateComponents_updateRgb: function _updateComponents_updateRgb(t0) {
      this.updateValue = t0;
    },
    _functionString_closure: function _functionString_closure() {
    },
    _removedColorFunction_closure: function _removedColorFunction_closure(t0, t1, t2) {
      this.name = t0;
      this.argument = t1;
      this.negative = t2;
    },
    _rgb_closure: function _rgb_closure() {
    },
    _hsl_closure: function _hsl_closure() {
    },
    _hwb_closure: function _hwb_closure() {
    },
    _parseChannels_closure: function _parseChannels_closure() {
    },
    _function3($name, $arguments, callback) {
      return A.BuiltInCallable$function($name, $arguments, callback, "sass:list");
    },
    _length_closure0: function _length_closure0() {
    },
    _nth_closure: function _nth_closure() {
    },
    _setNth_closure: function _setNth_closure() {
    },
    _join_closure: function _join_closure() {
    },
    _append_closure0: function _append_closure0() {
    },
    _zip_closure: function _zip_closure() {
    },
    _zip__closure: function _zip__closure() {
    },
    _zip__closure0: function _zip__closure0(t0) {
      this._box_0 = t0;
    },
    _zip__closure1: function _zip__closure1(t0) {
      this._box_0 = t0;
    },
    _index_closure0: function _index_closure0() {
    },
    _separator_closure: function _separator_closure() {
    },
    _isBracketed_closure: function _isBracketed_closure() {
    },
    _slash_closure: function _slash_closure() {
    },
    _modify(map, keys, modify, addNesting) {
      var keyIterator = J.get$iterator$ax(keys);
      return keyIterator.moveNext$0() ? new A._modify_modifyNestedMap(keyIterator, modify, addNesting).call$1(map) : modify.call$1(map);
    },
    _deepMergeImpl(map1, map2) {
      var t2, t3, result, t4, key, value, _1_1, _1_3, _1_3_isSet, resultMap, _1_30, valueMap, merged, _null = null,
        t1 = map1._map$_contents;
      if (t1.get$isEmpty(t1))
        return map2;
      t2 = map2._map$_contents;
      if (t2.get$isEmpty(t2))
        return map1;
      t3 = type$.Value;
      result = A.LinkedHashMap_LinkedHashMap$of(t1, t3, t3);
      for (t1 = A.MapExtensions_get_pairs(t2, t3, t3), t1 = t1.get$iterator(t1), t2 = type$.SassMap; t1.moveNext$0();) {
        t4 = t1.get$current(t1);
        key = t4._0;
        value = t4._1;
        t4 = result.$index(0, key);
        _1_1 = t4 == null ? _null : t4.tryMap$0();
        _1_3 = value.tryMap$0();
        _1_3_isSet = _1_1 != null;
        if (_1_3_isSet) {
          resultMap = _1_1 == null ? t2._as(_1_1) : _1_1;
          t4 = _1_3 != null;
          _1_30 = _1_3;
        } else {
          resultMap = _null;
          _1_30 = resultMap;
          t4 = false;
        }
        if (t4) {
          valueMap = _1_3_isSet ? _1_30 : _1_3;
          merged = A._deepMergeImpl(resultMap, valueMap == null ? t2._as(valueMap) : valueMap);
          if (merged === resultMap)
            continue;
          result.$indexSet(0, key, merged);
        } else
          result.$indexSet(0, key, value);
      }
      return new A.SassMap(A.ConstantMap_ConstantMap$from(result, t3, t3));
    },
    _function2($name, $arguments, callback) {
      return A.BuiltInCallable$function($name, $arguments, callback, "sass:map");
    },
    _get_closure: function _get_closure() {
    },
    _set_closure: function _set_closure() {
    },
    _set__closure0: function _set__closure0(t0) {
      this.$arguments = t0;
    },
    _set_closure0: function _set_closure0() {
    },
    _set__closure: function _set__closure(t0) {
      this._box_0 = t0;
    },
    _merge_closure: function _merge_closure() {
    },
    _merge_closure0: function _merge_closure0() {
    },
    _merge__closure: function _merge__closure(t0) {
      this.map2 = t0;
    },
    _deepMerge_closure: function _deepMerge_closure() {
    },
    _deepRemove_closure: function _deepRemove_closure() {
    },
    _deepRemove__closure: function _deepRemove__closure(t0) {
      this.keys = t0;
    },
    _remove_closure: function _remove_closure() {
    },
    _remove_closure0: function _remove_closure0() {
    },
    _keys_closure: function _keys_closure() {
    },
    _values_closure: function _values_closure() {
    },
    _hasKey_closure: function _hasKey_closure() {
    },
    _modify_modifyNestedMap: function _modify_modifyNestedMap(t0, t1, t2) {
      this.keyIterator = t0;
      this.modify = t1;
      this.addNesting = t2;
    },
    _singleArgumentMathFunc($name, mathFunc) {
      return A.BuiltInCallable$function($name, "$number", new A._singleArgumentMathFunc_closure(mathFunc), "sass:math");
    },
    _numberFunction($name, transform) {
      return A.BuiltInCallable$function($name, "$number", new A._numberFunction_closure(transform), "sass:math");
    },
    _function1($name, $arguments, callback) {
      return A.BuiltInCallable$function($name, $arguments, callback, "sass:math");
    },
    global_closure: function global_closure() {
    },
    module_closure0: function module_closure0() {
    },
    _ceil_closure: function _ceil_closure() {
    },
    _clamp_closure: function _clamp_closure() {
    },
    _floor_closure: function _floor_closure() {
    },
    _max_closure: function _max_closure() {
    },
    _min_closure: function _min_closure() {
    },
    _round_closure: function _round_closure() {
    },
    _hypot_closure: function _hypot_closure() {
    },
    _hypot__closure: function _hypot__closure() {
    },
    _log_closure: function _log_closure() {
    },
    _pow_closure: function _pow_closure() {
    },
    _atan2_closure: function _atan2_closure() {
    },
    _compatible_closure: function _compatible_closure() {
    },
    _isUnitless_closure: function _isUnitless_closure() {
    },
    _unit_closure: function _unit_closure() {
    },
    _percentage_closure: function _percentage_closure() {
    },
    _randomFunction_closure: function _randomFunction_closure() {
    },
    _div_closure: function _div_closure() {
    },
    _singleArgumentMathFunc_closure: function _singleArgumentMathFunc_closure(t0) {
      this.mathFunc = t0;
    },
    _numberFunction_closure: function _numberFunction_closure(t0) {
      this.transform = t0;
    },
    _function5($name, $arguments, callback) {
      return A.BuiltInCallable$function($name, $arguments, callback, "sass:meta");
    },
    global_closure27: function global_closure27() {
    },
    global_closure28: function global_closure28() {
    },
    global_closure29: function global_closure29() {
    },
    global_closure30: function global_closure30() {
    },
    local_closure: function local_closure() {
    },
    local_closure0: function local_closure0() {
    },
    local__closure: function local__closure() {
    },
    local_closure1: function local_closure1() {
    },
    _prependParent(compound) {
      var _0_3, _0_4, _0_4_isSet, rest, _null = null,
        t1 = A.EvaluationContext_currentOrNull(),
        span = (t1 == null ? A.throwExpression(A.StateError$(string$.No_Sass)) : t1).get$currentCallableSpan(),
        _0_0 = compound.components;
      $label0$0: {
        _0_3 = _0_0.length >= 1;
        if (_0_3) {
          _0_4 = _0_0[0];
          t1 = _0_4;
          t1 = t1 instanceof A.UniversalSelector;
        } else {
          _0_4 = _null;
          t1 = false;
        }
        if (t1) {
          t1 = _null;
          break $label0$0;
        }
        if (_0_3) {
          t1 = _0_4;
          if (t1 instanceof A.TypeSelector) {
            t1 = _0_4;
            t1 = type$.TypeSelector._as(t1).name.namespace != null;
            _0_4_isSet = true;
          } else {
            _0_4_isSet = true;
            t1 = false;
          }
        } else {
          _0_4_isSet = _0_3;
          t1 = false;
        }
        if (t1) {
          t1 = _null;
          break $label0$0;
        }
        if (_0_3) {
          if (_0_4_isSet)
            t1 = _0_4;
          else {
            _0_4 = _0_0[0];
            t1 = _0_4;
            _0_4_isSet = true;
          }
          t1 = t1 instanceof A.TypeSelector;
        } else
          t1 = false;
        if (t1) {
          t1 = _0_4_isSet ? _0_4 : _0_0[0];
          type$.TypeSelector._as(t1);
          rest = B.JSArray_methods.sublist$1(_0_0, 1);
          t1 = A._setArrayType([new A.ParentSelector(t1.name.name, span)], type$.JSArray_SimpleSelector);
          B.JSArray_methods.addAll$1(t1, rest);
          t1 = A.CompoundSelector$(t1, span);
          break $label0$0;
        }
        t1 = A._setArrayType([new A.ParentSelector(_null, span)], type$.JSArray_SimpleSelector);
        B.JSArray_methods.addAll$1(t1, _0_0);
        t1 = A.CompoundSelector$(t1, span);
        break $label0$0;
      }
      return t1;
    },
    _function0($name, $arguments, callback) {
      return A.BuiltInCallable$function($name, $arguments, callback, "sass:selector");
    },
    _nest_closure: function _nest_closure() {
    },
    _nest__closure: function _nest__closure(t0) {
      this._box_0 = t0;
    },
    _nest__closure0: function _nest__closure0() {
    },
    _append_closure: function _append_closure() {
    },
    _append__closure: function _append__closure() {
    },
    _append__closure0: function _append__closure0(t0) {
      this.span = t0;
    },
    _append___closure: function _append___closure(t0, t1) {
      this.parent = t0;
      this.span = t1;
    },
    _extend_closure: function _extend_closure() {
    },
    _replace_closure: function _replace_closure() {
    },
    _unify_closure: function _unify_closure() {
    },
    _isSuperselector_closure: function _isSuperselector_closure() {
    },
    _simpleSelectors_closure: function _simpleSelectors_closure() {
    },
    _simpleSelectors__closure: function _simpleSelectors__closure() {
    },
    _parse_closure: function _parse_closure() {
    },
    _codepointForIndex(index, lengthInCodepoints, allowNegative) {
      var result;
      if (index === 0)
        return 0;
      if (index > 0)
        return Math.min(index - 1, lengthInCodepoints);
      result = lengthInCodepoints + index;
      if (result < 0 && !allowNegative)
        return 0;
      return result;
    },
    _function($name, $arguments, callback) {
      return A.BuiltInCallable$function($name, $arguments, callback, "sass:string");
    },
    module_closure: function module_closure() {
    },
    module__closure: function module__closure(t0) {
      this.string = t0;
    },
    module__closure0: function module__closure0(t0) {
      this.string = t0;
    },
    _unquote_closure: function _unquote_closure() {
    },
    _quote_closure: function _quote_closure() {
    },
    _length_closure: function _length_closure() {
    },
    _insert_closure: function _insert_closure() {
    },
    _index_closure: function _index_closure() {
    },
    _slice_closure: function _slice_closure() {
    },
    _toUpperCase_closure: function _toUpperCase_closure() {
    },
    _toLowerCase_closure: function _toLowerCase_closure() {
    },
    _uniqueId_closure: function _uniqueId_closure() {
    },
    ImportCache$(importers, loadPaths, logger) {
      var t1 = type$.nullable_Record_3_Importer_and_Uri_and_Uri_originalUrl,
        t2 = type$.Record_3_Importer_and_Uri_and_bool_forImport,
        t3 = type$.Uri,
        t4 = A.ImportCache__toImporters(importers, loadPaths, null);
      return new A.ImportCache(t4, logger, A.LinkedHashMap_LinkedHashMap$_empty(type$.Record_2_Uri_and_bool_forImport, t1), A.LinkedHashMap_LinkedHashMap$_empty(t2, t1), A.LinkedHashMap_LinkedHashMap$_empty(t2, t3), A.LinkedHashMap_LinkedHashMap$_empty(t3, type$.nullable_Stylesheet), A.LinkedHashMap_LinkedHashMap$_empty(t3, type$.ImporterResult));
    },
    ImportCache__toImporters(importers, loadPaths, packageConfig) {
      var t1, t2, t3, t4, _i, path, _null = null,
        sassPath = A.getEnvironmentVariable("SASS_PATH");
      if (A.isBrowser()) {
        t1 = A._setArrayType([], type$.JSArray_Importer);
        B.JSArray_methods.addAll$1(t1, importers);
        return t1;
      }
      t1 = A._setArrayType([], type$.JSArray_Importer);
      B.JSArray_methods.addAll$1(t1, importers);
      for (t2 = J.get$iterator$ax(loadPaths); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        t1.push(new A.FilesystemImporter($.$get$context().absolute$15(t3, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null), false));
      }
      if (sassPath != null) {
        t2 = A.isNodeJs() ? self.process : _null;
        t3 = sassPath.split(J.$eq$(t2 == null ? _null : J.get$platform$x(t2), "win32") ? ";" : ":");
        t4 = t3.length;
        _i = 0;
        for (; _i < t4; ++_i) {
          path = t3[_i];
          t1.push(new A.FilesystemImporter($.$get$context().absolute$15(path, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null), false));
        }
      }
      return t1;
    },
    ImportCache: function ImportCache(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._importers = t0;
      _._logger = t1;
      _._canonicalizeCache = t2;
      _._perImporterCanonicalizeCache = t3;
      _._nonCanonicalRelativeUrls = t4;
      _._importCache = t5;
      _._resultsCache = t6;
    },
    ImportCache_canonicalize_closure: function ImportCache_canonicalize_closure(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.baseImporter = t1;
      _.resolvedUrl = t2;
      _.baseUrl = t3;
      _.forImport = t4;
      _.key = t5;
      _.url = t6;
    },
    ImportCache__canonicalize_closure: function ImportCache__canonicalize_closure(t0, t1) {
      this.importer = t0;
      this.url = t1;
    },
    ImportCache_importCanonical_closure: function ImportCache_importCanonical_closure(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _.originalUrl = t3;
      _.quiet = t4;
    },
    ImportCache_humanize_closure: function ImportCache_humanize_closure(t0) {
      this.canonicalUrl = t0;
    },
    ImportCache_humanize_closure0: function ImportCache_humanize_closure0() {
    },
    ImportCache_humanize_closure1: function ImportCache_humanize_closure1() {
    },
    ImportCache_humanize_closure2: function ImportCache_humanize_closure2(t0) {
      this.canonicalUrl = t0;
    },
    ImportCache_clearCanonicalize_closure: function ImportCache_clearCanonicalize_closure(t0, t1) {
      this.$this = t0;
      this.url = t1;
    },
    Importer: function Importer() {
    },
    AsyncImporter: function AsyncImporter() {
    },
    CanonicalizeContext: function CanonicalizeContext(t0, t1) {
      this._fromImport = t0;
      this._containingUrl = t1;
      this._wasContainingUrlAccessed = false;
    },
    FilesystemImporter: function FilesystemImporter(t0, t1) {
      this._loadPath = t0;
      this._loadPathDeprecated = t1;
    },
    FilesystemImporter_canonicalize_closure: function FilesystemImporter_canonicalize_closure() {
    },
    NoOpImporter: function NoOpImporter() {
    },
    NodePackageImporter: function NodePackageImporter() {
      this.__NodePackageImporter__entryPointDirectory_F = $;
    },
    NodePackageImporter__nodePackageExportsResolve_closure: function NodePackageImporter__nodePackageExportsResolve_closure() {
    },
    NodePackageImporter__nodePackageExportsResolve_closure0: function NodePackageImporter__nodePackageExportsResolve_closure0() {
    },
    NodePackageImporter__nodePackageExportsResolve_closure1: function NodePackageImporter__nodePackageExportsResolve_closure1() {
    },
    NodePackageImporter__nodePackageExportsResolve_closure2: function NodePackageImporter__nodePackageExportsResolve_closure2(t0, t1, t2) {
      this.$this = t0;
      this.exports = t1;
      this.packageRoot = t2;
    },
    NodePackageImporter__nodePackageExportsResolve__closure: function NodePackageImporter__nodePackageExportsResolve__closure(t0, t1, t2) {
      this.$this = t0;
      this.variant = t1;
      this.packageRoot = t2;
    },
    NodePackageImporter__nodePackageExportsResolve__closure0: function NodePackageImporter__nodePackageExportsResolve__closure0() {
    },
    NodePackageImporter__getMainExport_closure: function NodePackageImporter__getMainExport_closure() {
    },
    ImporterResult: function ImporterResult(t0, t1, t2) {
      this.contents = t0;
      this._sourceMapUrl = t1;
      this.syntax = t2;
    },
    fromImport() {
      var t1 = type$.nullable_CanonicalizeContext._as($.Zone__current.$index(0, B.Symbol__canonicalizeContext));
      t1 = t1 == null ? null : t1._fromImport;
      return t1 === true;
    },
    canonicalizeContext() {
      var t1,
        _0_0 = $.Zone__current.$index(0, B.Symbol__canonicalizeContext);
      $label0$0: {
        if (_0_0 == null)
          A.throwExpression(A.StateError$(string$.canoni));
        if (_0_0 instanceof A.CanonicalizeContext) {
          t1 = _0_0;
          break $label0$0;
        }
        t1 = A.throwExpression(A.StateError$(string$.Unexpe + A.S(_0_0) + "."));
      }
      return t1;
    },
    resolveImportPath(path) {
      var t1,
        extension = A.ParsedPath_ParsedPath$parse(path, $.$get$context().style)._splitExtension$1(1)[1];
      if (extension === ".sass" || extension === ".scss" || extension === ".css") {
        t1 = A.fromImport() ? new A.resolveImportPath_closure(path, extension).call$0() : null;
        return t1 == null ? A._exactlyOne(A._tryPath(path)) : t1;
      }
      t1 = A.fromImport() ? new A.resolveImportPath_closure0(path).call$0() : null;
      if (t1 == null)
        t1 = A._exactlyOne(A._tryPathWithExtensions(path));
      return t1 == null ? A._tryPathAsDirectory(path) : t1;
    },
    _tryPathWithExtensions(path) {
      var result = A._tryPath(path + ".sass");
      B.JSArray_methods.addAll$1(result, A._tryPath(path + ".scss"));
      return result.length !== 0 ? result : A._tryPath(path + ".css");
    },
    _tryPath(path) {
      var t1 = $.$get$context(),
        partial = A.join(t1.dirname$1(path), "_" + A.ParsedPath_ParsedPath$parse(path, t1.style).get$basename(), null);
      t1 = A._setArrayType([], type$.JSArray_String);
      if (A.fileExists(partial))
        t1.push(partial);
      if (A.fileExists(path))
        t1.push(path);
      return t1;
    },
    _tryPathAsDirectory(path) {
      var t1;
      if (!A.dirExists(path))
        return null;
      t1 = A.fromImport() ? new A._tryPathAsDirectory_closure(path).call$0() : null;
      return t1 == null ? A._exactlyOne(A._tryPathWithExtensions(A.join(path, "index", null))) : t1;
    },
    _exactlyOne(paths) {
      var _0_1, t1, path;
      $label0$0: {
        _0_1 = paths.length;
        if (_0_1 <= 0) {
          t1 = null;
          break $label0$0;
        }
        if (_0_1 === 1) {
          path = paths[0];
          t1 = path;
          break $label0$0;
        }
        t1 = A.throwExpression(string$.It_s_n + B.JSArray_methods.map$1$1(paths, new A._exactlyOne_closure(), type$.String).join$1(0, "\n"));
      }
      return t1;
    },
    resolveImportPath_closure: function resolveImportPath_closure(t0, t1) {
      this.path = t0;
      this.extension = t1;
    },
    resolveImportPath_closure0: function resolveImportPath_closure0(t0) {
      this.path = t0;
    },
    _tryPathAsDirectory_closure: function _tryPathAsDirectory_closure(t0) {
      this.path = t0;
    },
    _exactlyOne_closure: function _exactlyOne_closure() {
    },
    InterpolationBuffer: function InterpolationBuffer(t0, t1) {
      this._interpolation_buffer$_text = t0;
      this._interpolation_buffer$_contents = t1;
    },
    InterpolationMap$(_interpolation, targetLocations) {
      var t1 = A.List_List$unmodifiable(targetLocations, type$.SourceLocation),
        t2 = _interpolation.contents.length,
        expectedLocations = Math.max(0, t2 - 1);
      if (t1.length !== expectedLocations)
        A.throwExpression(A.ArgumentError$("InterpolationMap must have " + A.S(expectedLocations) + string$.x20targe + t2 + " components.", null));
      return new A.InterpolationMap(_interpolation, t1);
    },
    InterpolationMap: function InterpolationMap(t0, t1) {
      this._interpolation = t0;
      this._targetLocations = t1;
    },
    InterpolationMap_mapException_closure: function InterpolationMap_mapException_closure() {
    },
    _realCasePath(path) {
      var prefix, _null = null,
        t1 = A.isNodeJs() ? self.process : _null;
      if (!J.$eq$(t1 == null ? _null : J.get$platform$x(t1), "win32")) {
        t1 = A.isNodeJs() ? self.process : _null;
        t1 = J.$eq$(t1 == null ? _null : J.get$platform$x(t1), "darwin");
      } else
        t1 = true;
      if (!t1)
        return path;
      t1 = A.isNodeJs() ? self.process : _null;
      if (J.$eq$(t1 == null ? _null : J.get$platform$x(t1), "win32")) {
        prefix = B.JSString_methods.substring$2(path, 0, $.$get$context().style.rootLength$1(path));
        t1 = prefix.length;
        if (t1 !== 0 && A.CharacterExtension_get_isAlphabetic(prefix.charCodeAt(0)))
          path = prefix.toUpperCase() + B.JSString_methods.substring$1(path, t1);
      }
      return new A._realCasePath_helper().call$1(path);
    },
    _realCasePath_helper: function _realCasePath_helper() {
    },
    _realCasePath_helper_closure: function _realCasePath_helper_closure(t0, t1, t2) {
      this.helper = t0;
      this.dirname = t1;
      this.path = t2;
    },
    _realCasePath_helper__closure: function _realCasePath_helper__closure(t0) {
      this.basename = t0;
    },
    printError(message) {
      var t1 = A.isNodeJs() ? self.process : null;
      if (t1 != null) {
        t1 = J.get$stderr$x(t1);
        J.write$1$x(t1, A.S(message == null ? "" : message) + "\n");
      } else {
        t1 = self.console;
        J.error$1$x(t1, message == null ? "" : message);
      }
    },
    readFile(path) {
      var contents, sourceFile, t1, i;
      if (!A.isNodeJs())
        throw A.wrapException(A.UnsupportedError$("readFile() is only supported on Node.js"));
      contents = A._asString(A._readFile(path, "utf8"));
      if (!B.JSString_methods.contains$1(contents, "\ufffd"))
        return contents;
      sourceFile = A.SourceFile$fromString(contents, $.$get$context().toUri$1(path));
      for (t1 = contents.length, i = 0; i < t1; ++i) {
        if (contents.charCodeAt(i) !== 65533)
          continue;
        throw A.wrapException(A.SassException$("Invalid UTF-8.", A.FileLocation$_(sourceFile, i).pointSpan$0(), null));
      }
      return contents;
    },
    _readFile(path, encoding) {
      return A._systemErrorToFileSystemException(new A._readFile_closure(path, encoding));
    },
    writeFile(path, contents) {
      if (!A.isNodeJs())
        throw A.wrapException(A.UnsupportedError$("writeFile() is only supported on Node.js"));
      return A._systemErrorToFileSystemException(new A.writeFile_closure(path, contents));
    },
    deleteFile(path) {
      if (!A.isNodeJs())
        throw A.wrapException(A.UnsupportedError$("deleteFile() is only supported on Node.js"));
      return A._systemErrorToFileSystemException(new A.deleteFile_closure(path));
    },
    readStdin() {
      return A.readStdin$body();
    },
    readStdin$body() {
      var $async$goto = 0,
        $async$completer = A._makeAsyncAwaitCompleter(type$.String),
        $async$returnValue, t3, completer, sink, t1, t2;
      var $async$readStdin = A._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return A._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = {};
              t2 = A.isNodeJs() ? self.process : null;
              if (t2 == null)
                throw A.wrapException(A.UnsupportedError$("readStdin() is only supported on Node.js"));
              t3 = new A._Future($.Zone__current, type$._Future_String);
              completer = new A._AsyncCompleter(t3, type$._AsyncCompleter_String);
              t1.contents = null;
              sink = new A._StringCallbackSink(new A.readStdin_closure(t1, completer), new A.StringBuffer("")).asUtf8Sink$1(false);
              t1 = J.getInterceptor$x(t2);
              J.on$2$x(t1.get$stdin(t2), "data", A.allowInterop(new A.readStdin_closure0(sink)));
              J.on$2$x(t1.get$stdin(t2), "end", A.allowInterop(new A.readStdin_closure1(sink)));
              J.on$2$x(t1.get$stdin(t2), "error", A.allowInterop(new A.readStdin_closure2(completer)));
              $async$returnValue = t3;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return A._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return A._asyncStartSync($async$readStdin, $async$completer);
    },
    fileExists(path) {
      if (!A.isNodeJs())
        throw A.wrapException(A.UnsupportedError$(string$.fileEx));
      return A._systemErrorToFileSystemException(new A.fileExists_closure(path));
    },
    dirExists(path) {
      if (!A.isNodeJs())
        throw A.wrapException(A.UnsupportedError$("dirExists() is only supported on Node.js"));
      return A._systemErrorToFileSystemException(new A.dirExists_closure(path));
    },
    ensureDir(path) {
      if (!A.isNodeJs())
        throw A.wrapException(A.UnsupportedError$("ensureDir() is only supported on Node.js"));
      return A._systemErrorToFileSystemException(new A.ensureDir_closure(path));
    },
    listDir(path, recursive) {
      if (!A.isNodeJs())
        throw A.wrapException(A.UnsupportedError$("listDir() is only supported on Node.js"));
      return A._systemErrorToFileSystemException(new A.listDir_closure(recursive, path));
    },
    modificationTime(path) {
      if (!A.isNodeJs())
        throw A.wrapException(A.UnsupportedError$("modificationTime() is only supported on Node.js"));
      return A._systemErrorToFileSystemException(new A.modificationTime_closure(path));
    },
    getEnvironmentVariable($name) {
      var t1 = A.isNodeJs() ? self.process : null,
        env = t1 == null ? null : J.get$env$x(t1);
      if (env == null)
        t1 = null;
      else
        t1 = A._asStringQ(env[$name]);
      return t1;
    },
    _systemErrorToFileSystemException(callback) {
      var error, t1, exception, t2;
      try {
        t1 = callback.call$0();
        return t1;
      } catch (exception) {
        error = A.unwrapException(exception);
        if (!type$.JsSystemError._is(error))
          throw exception;
        t1 = error;
        t2 = J.getInterceptor$x(t1);
        throw A.wrapException(new A.FileSystemException(J.substring$2$s(t2.get$message(t1), (A.S(t2.get$code(t1)) + ": ").length, J.get$length$asx(t2.get$message(t1)) - (", " + A.S(t2.get$syscall(t1)) + " '" + A.S(t2.get$path(t1)) + "'").length), J.get$path$x(error)));
      }
    },
    hasTerminal() {
      var t1 = A.isNodeJs() ? self.process : null;
      return J.$eq$(t1 == null ? null : J.get$isTTY$x(J.get$stdout$x(t1)), true);
    },
    isWindows() {
      var t1 = A.isNodeJs() ? self.process : null;
      return J.$eq$(t1 == null ? null : J.get$platform$x(t1), "win32");
    },
    watchDir(path, poll) {
      var watcher, t2, t3, t1 = {};
      if (!A.isNodeJs())
        throw A.wrapException(A.UnsupportedError$("watchDir() is only supported on Node.js"));
      watcher = J.watch$2$x(self.chokidar, path, {disableGlobbing: true, usePolling: poll});
      t1.controller = null;
      t2 = J.getInterceptor$x(watcher);
      t2.on$2(watcher, "add", A.allowInterop(new A.watchDir_closure(t1)));
      t2.on$2(watcher, "change", A.allowInterop(new A.watchDir_closure0(t1)));
      t2.on$2(watcher, "unlink", A.allowInterop(new A.watchDir_closure1(t1)));
      t2.on$2(watcher, "error", A.allowInterop(new A.watchDir_closure2(t1)));
      t3 = new A._Future($.Zone__current, type$._Future_Stream_WatchEvent);
      t2.on$2(watcher, "ready", A.allowInterop(new A.watchDir_closure3(t1, watcher, new A._AsyncCompleter(t3, type$._AsyncCompleter_Stream_WatchEvent))));
      return t3;
    },
    FileSystemException: function FileSystemException(t0, t1) {
      this.message = t0;
      this.path = t1;
    },
    _readFile_closure: function _readFile_closure(t0, t1) {
      this.path = t0;
      this.encoding = t1;
    },
    writeFile_closure: function writeFile_closure(t0, t1) {
      this.path = t0;
      this.contents = t1;
    },
    deleteFile_closure: function deleteFile_closure(t0) {
      this.path = t0;
    },
    readStdin_closure: function readStdin_closure(t0, t1) {
      this._box_0 = t0;
      this.completer = t1;
    },
    readStdin_closure0: function readStdin_closure0(t0) {
      this.sink = t0;
    },
    readStdin_closure1: function readStdin_closure1(t0) {
      this.sink = t0;
    },
    readStdin_closure2: function readStdin_closure2(t0) {
      this.completer = t0;
    },
    fileExists_closure: function fileExists_closure(t0) {
      this.path = t0;
    },
    dirExists_closure: function dirExists_closure(t0) {
      this.path = t0;
    },
    ensureDir_closure: function ensureDir_closure(t0) {
      this.path = t0;
    },
    listDir_closure: function listDir_closure(t0, t1) {
      this.recursive = t0;
      this.path = t1;
    },
    listDir__closure: function listDir__closure(t0) {
      this.path = t0;
    },
    listDir__closure0: function listDir__closure0() {
    },
    listDir_closure_list: function listDir_closure_list() {
    },
    listDir__list_closure: function listDir__list_closure(t0, t1) {
      this.parent = t0;
      this.list = t1;
    },
    modificationTime_closure: function modificationTime_closure(t0) {
      this.path = t0;
    },
    watchDir_closure: function watchDir_closure(t0) {
      this._box_0 = t0;
    },
    watchDir_closure0: function watchDir_closure0(t0) {
      this._box_0 = t0;
    },
    watchDir_closure1: function watchDir_closure1(t0) {
      this._box_0 = t0;
    },
    watchDir_closure2: function watchDir_closure2(t0) {
      this._box_0 = t0;
    },
    watchDir_closure3: function watchDir_closure3(t0, t1, t2) {
      this._box_0 = t0;
      this.watcher = t1;
      this.completer = t2;
    },
    watchDir__closure: function watchDir__closure(t0) {
      this.watcher = t0;
    },
    JSArray0: function JSArray0() {
    },
    Chokidar: function Chokidar() {
    },
    ChokidarOptions: function ChokidarOptions() {
    },
    ChokidarWatcher: function ChokidarWatcher() {
    },
    JSFunction: function JSFunction() {
    },
    ImmutableList: function ImmutableList() {
    },
    ImmutableMap: function ImmutableMap() {
    },
    NodeImporterResult: function NodeImporterResult() {
    },
    RenderContext: function RenderContext() {
    },
    RenderContextOptions: function RenderContextOptions() {
    },
    RenderContextResult: function RenderContextResult() {
    },
    RenderContextResultStats: function RenderContextResultStats() {
    },
    JSModule: function JSModule() {
    },
    JSModuleRequire: function JSModuleRequire() {
    },
    JSClass: function JSClass() {
    },
    JSUrl: function JSUrl() {
    },
    jsThrow0(error) {
      return type$.Never._as($.$get$_jsThrow0().call$1(error));
    },
    _PropertyDescriptor: function _PropertyDescriptor() {
    },
    _RequireMain: function _RequireMain() {
    },
    WarnForDeprecation_warnForDeprecation(_this, deprecation, message, span, trace) {
      if (deprecation.isFuture && !(_this instanceof A.DeprecationProcessingLogger))
        return;
      if (_this instanceof A.DeprecationProcessingLogger)
        _this.internalWarn$4$deprecation$span$trace(message, deprecation, span, trace);
      else
        _this.warn$4$deprecation$span$trace(0, message, true, span, trace);
    },
    LoggerWithDeprecationType0: function LoggerWithDeprecationType0() {
    },
    _QuietLogger: function _QuietLogger() {
    },
    DeprecationProcessingLogger$(_inner, fatalDeprecations, futureDeprecations, limitRepetition, silenceDeprecations) {
      var t1 = new A.DeprecationProcessingLogger(A.LinkedHashMap_LinkedHashMap$_empty(type$.Deprecation, type$.int), _inner, silenceDeprecations, fatalDeprecations, futureDeprecations, limitRepetition);
      t1.DeprecationProcessingLogger$5$fatalDeprecations$futureDeprecations$limitRepetition$silenceDeprecations(_inner, fatalDeprecations, futureDeprecations, limitRepetition, silenceDeprecations);
      return t1;
    },
    DeprecationProcessingLogger: function DeprecationProcessingLogger(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._warningCounts = t0;
      _._inner = t1;
      _.silenceDeprecations = t2;
      _.fatalDeprecations = t3;
      _.futureDeprecations = t4;
      _.limitRepetition = t5;
    },
    DeprecationProcessingLogger_summarize_closure: function DeprecationProcessingLogger_summarize_closure() {
    },
    DeprecationProcessingLogger_summarize_closure0: function DeprecationProcessingLogger_summarize_closure0() {
    },
    StderrLogger: function StderrLogger(t0) {
      this.color = t0;
    },
    TrackingLogger: function TrackingLogger(t0) {
      this._tracking$_logger = t0;
      this._emittedDebug = this._emittedWarning = false;
    },
    BuiltInModule$($name, functions, mixins, variables, $T) {
      var t1 = A._Uri__Uri(null, $name, null, "sass"),
        t2 = A.BuiltInModule__callableMap(functions, $T),
        t3 = A.BuiltInModule__callableMap(mixins, $T),
        t4 = variables == null ? B.Map_empty5 : new A.UnmodifiableMapView(variables, type$.UnmodifiableMapView_String_Value);
      return new A.BuiltInModule(t1, t2, t3, t4, $T._eval$1("BuiltInModule<0>"));
    },
    BuiltInModule__callableMap(callables, $T) {
      var t2, _i, callable,
        t1 = type$.String;
      if (callables == null)
        t1 = A.LinkedHashMap_LinkedHashMap$_empty(t1, $T);
      else {
        t1 = A.LinkedHashMap_LinkedHashMap$_empty(t1, $T);
        for (t2 = callables.length, _i = 0; _i < callables.length; callables.length === t2 || (0, A.throwConcurrentModificationError)(callables), ++_i) {
          callable = callables[_i];
          t1.$indexSet(0, J.get$name$x(callable), callable);
        }
        t1 = new A.UnmodifiableMapView(t1, type$.$env_1_1_String._bind$1($T)._eval$1("UnmodifiableMapView<1,2>"));
      }
      return new A.UnmodifiableMapView(t1, type$.$env_1_1_String._bind$1($T)._eval$1("UnmodifiableMapView<1,2>"));
    },
    BuiltInModule: function BuiltInModule(t0, t1, t2, t3, t4) {
      var _ = this;
      _.url = t0;
      _.functions = t1;
      _.mixins = t2;
      _.variables = t3;
      _.$ti = t4;
    },
    ForwardedModuleView_ifNecessary(inner, rule, $T) {
      var t1;
      if (rule.prefix == null)
        if (rule.shownMixinsAndFunctions == null)
          if (rule.shownVariables == null) {
            t1 = rule.hiddenMixinsAndFunctions;
            t1 = t1 == null ? null : t1._base.get$isEmpty(0);
            if (t1 === true) {
              t1 = rule.hiddenVariables;
              t1 = t1 == null ? null : t1._base.get$isEmpty(0);
              t1 = t1 === true;
            } else
              t1 = false;
          } else
            t1 = false;
        else
          t1 = false;
      else
        t1 = false;
      if (t1)
        return inner;
      else
        return A.ForwardedModuleView$(inner, rule, $T);
    },
    ForwardedModuleView$(_inner, _rule, $T) {
      var t1 = _rule.prefix,
        t2 = _rule.shownVariables,
        t3 = _rule.hiddenVariables,
        t4 = _rule.shownMixinsAndFunctions,
        t5 = _rule.hiddenMixinsAndFunctions;
      return new A.ForwardedModuleView(_inner, _rule, A.ForwardedModuleView__forwardedMap(_inner.get$variables(), t1, t2, t3, type$.Value), A.ForwardedModuleView__forwardedMap(_inner.get$variableNodes(), t1, t2, t3, type$.AstNode), A.ForwardedModuleView__forwardedMap(_inner.get$functions(_inner), t1, t4, t5, $T), A.ForwardedModuleView__forwardedMap(_inner.get$mixins(), t1, t4, t5, $T), $T._eval$1("ForwardedModuleView<0>"));
    },
    ForwardedModuleView__forwardedMap(map, prefix, safelist, blocklist, $V) {
      var t2,
        t1 = prefix == null;
      if (t1)
        if (safelist == null)
          t2 = blocklist == null || blocklist._base.get$isEmpty(0);
        else
          t2 = false;
      else
        t2 = false;
      if (t2)
        return map;
      if (!t1)
        map = new A.PrefixedMapView(map, prefix, $V._eval$1("PrefixedMapView<0>"));
      if (safelist != null)
        map = new A.LimitedMapView(map, safelist._base.intersection$1(new A.MapKeySet(map, type$.MapKeySet_nullable_Object)), type$.$env_1_1_String._bind$1($V)._eval$1("LimitedMapView<1,2>"));
      else if (blocklist != null && blocklist._base.get$isNotEmpty(0))
        map = A.LimitedMapView$blocklist(map, blocklist, type$.String, $V);
      return map;
    },
    ForwardedModuleView: function ForwardedModuleView(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._forwarded_view$_inner = t0;
      _._rule = t1;
      _.variables = t2;
      _.variableNodes = t3;
      _.functions = t4;
      _.mixins = t5;
      _.$ti = t6;
    },
    ShadowedModuleView_ifNecessary(inner, functions, mixins, variables, $T) {
      return A.ShadowedModuleView__needsBlocklist(inner.get$variables(), variables) || A.ShadowedModuleView__needsBlocklist(inner.get$functions(inner), functions) || A.ShadowedModuleView__needsBlocklist(inner.get$mixins(), mixins) ? new A.ShadowedModuleView(inner, A.ShadowedModuleView__shadowedMap(inner.get$variables(), variables, type$.Value), A.ShadowedModuleView__shadowedMap(inner.get$variableNodes(), variables, type$.AstNode), A.ShadowedModuleView__shadowedMap(inner.get$functions(inner), functions, $T), A.ShadowedModuleView__shadowedMap(inner.get$mixins(), mixins, $T), $T._eval$1("ShadowedModuleView<0>")) : null;
    },
    ShadowedModuleView__shadowedMap(map, blocklist, $V) {
      var t1 = A.ShadowedModuleView__needsBlocklist(map, blocklist);
      return !t1 ? map : A.LimitedMapView$blocklist(map, blocklist, type$.String, $V);
    },
    ShadowedModuleView__needsBlocklist(map, blocklist) {
      return map.get$isNotEmpty(map) && blocklist.any$1(0, map.get$containsKey());
    },
    ShadowedModuleView: function ShadowedModuleView(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._shadowed_view$_inner = t0;
      _.variables = t1;
      _.variableNodes = t2;
      _.functions = t3;
      _.mixins = t4;
      _.$ti = t5;
    },
    AtRootQueryParser$(contents, logger, url) {
      var t1 = A.SpanScanner$(contents, url);
      return new A.AtRootQueryParser(t1, logger, null);
    },
    AtRootQueryParser: function AtRootQueryParser(t0, t1, t2) {
      this.scanner = t0;
      this.logger = t1;
      this._interpolationMap = t2;
    },
    AtRootQueryParser_parse_closure: function AtRootQueryParser_parse_closure(t0) {
      this.$this = t0;
    },
    _disallowedFunctionNames_closure: function _disallowedFunctionNames_closure() {
    },
    CssParser: function CssParser(t0, t1, t2, t3) {
      var _ = this;
      _._isUseAllowed = true;
      _._inExpression = _._inParentheses = _._inStyleRule = _._stylesheet$_inUnknownAtRule = _._inControlDirective = _._inContentBlock = _._stylesheet$_inMixin = false;
      _._globalVariables = t0;
      _.lastSilentComment = null;
      _.scanner = t1;
      _.logger = t2;
      _._interpolationMap = t3;
    },
    KeyframeSelectorParser$(contents, interpolationMap, logger) {
      var t1 = A.SpanScanner$(contents, null);
      return new A.KeyframeSelectorParser(t1, logger, interpolationMap);
    },
    KeyframeSelectorParser: function KeyframeSelectorParser(t0, t1, t2) {
      this.scanner = t0;
      this.logger = t1;
      this._interpolationMap = t2;
    },
    KeyframeSelectorParser_parse_closure: function KeyframeSelectorParser_parse_closure(t0) {
      this.$this = t0;
    },
    MediaQueryParser: function MediaQueryParser(t0, t1, t2) {
      this.scanner = t0;
      this.logger = t1;
      this._interpolationMap = t2;
    },
    MediaQueryParser_parse_closure: function MediaQueryParser_parse_closure(t0) {
      this.$this = t0;
    },
    Parser_isIdentifier(text) {
      var t1, t2, exception, logger = null;
      try {
        t1 = logger;
        t2 = A.SpanScanner$(text, null);
        new A.Parser(t2, t1 == null ? B.StderrLogger_false : t1, null)._parseIdentifier$0();
        return true;
      } catch (exception) {
        if (type$.SassFormatException._is(A.unwrapException(exception)))
          return false;
        else
          throw exception;
      }
    },
    Parser: function Parser(t0, t1, t2) {
      this.scanner = t0;
      this.logger = t1;
      this._interpolationMap = t2;
    },
    Parser__parseIdentifier_closure: function Parser__parseIdentifier_closure(t0) {
      this.$this = t0;
    },
    Parser_escape_closure: function Parser_escape_closure() {
    },
    Parser_scanIdentChar_matches: function Parser_scanIdentChar_matches(t0, t1) {
      this.caseSensitive = t0;
      this.char = t1;
    },
    Parser_spanFrom_closure: function Parser_spanFrom_closure(t0, t1) {
      this.$this = t0;
      this.span = t1;
    },
    SassParser: function SassParser(t0, t1, t2, t3) {
      var _ = this;
      _._currentIndentation = 0;
      _._spaces = _._nextIndentationEnd = _._nextIndentation = null;
      _._isUseAllowed = true;
      _._inExpression = _._inParentheses = _._inStyleRule = _._stylesheet$_inUnknownAtRule = _._inControlDirective = _._inContentBlock = _._stylesheet$_inMixin = false;
      _._globalVariables = t0;
      _.lastSilentComment = null;
      _.scanner = t1;
      _.logger = t2;
      _._interpolationMap = t3;
    },
    SassParser_styleRuleSelector_closure: function SassParser_styleRuleSelector_closure() {
    },
    SassParser_children_closure: function SassParser_children_closure(t0, t1, t2) {
      this.$this = t0;
      this.child = t1;
      this.children = t2;
    },
    SassParser__peekIndentation_closure: function SassParser__peekIndentation_closure() {
    },
    SassParser__peekIndentation_closure0: function SassParser__peekIndentation_closure0() {
    },
    ScssParser$(contents, logger, url) {
      var t1 = A.SpanScanner$(contents, url),
        t2 = logger == null ? B.StderrLogger_false : logger;
      return new A.ScssParser(A.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.VariableDeclaration), t1, t2, null);
    },
    ScssParser: function ScssParser(t0, t1, t2, t3) {
      var _ = this;
      _._isUseAllowed = true;
      _._inExpression = _._inParentheses = _._inStyleRule = _._stylesheet$_inUnknownAtRule = _._inControlDirective = _._inContentBlock = _._stylesheet$_inMixin = false;
      _._globalVariables = t0;
      _.lastSilentComment = null;
      _.scanner = t1;
      _.logger = t2;
      _._interpolationMap = t3;
    },
    SelectorParser$(contents, allowParent, interpolationMap, logger, plainCss, url) {
      var t1 = A.SpanScanner$(contents, url);
      return new A.SelectorParser(allowParent, plainCss, t1, logger == null ? B.StderrLogger_false : logger, interpolationMap);
    },
    SelectorParser: function SelectorParser(t0, t1, t2, t3, t4) {
      var _ = this;
      _._allowParent = t0;
      _._plainCss = t1;
      _.scanner = t2;
      _.logger = t3;
      _._interpolationMap = t4;
    },
    SelectorParser_parse_closure: function SelectorParser_parse_closure(t0) {
      this.$this = t0;
    },
    SelectorParser_parseCompoundSelector_closure: function SelectorParser_parseCompoundSelector_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser: function StylesheetParser() {
    },
    StylesheetParser_parse_closure: function StylesheetParser_parse_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser_parse__closure: function StylesheetParser_parse__closure(t0) {
      this.$this = t0;
    },
    StylesheetParser_parse__closure0: function StylesheetParser_parse__closure0() {
    },
    StylesheetParser_parseArgumentDeclaration_closure: function StylesheetParser_parseArgumentDeclaration_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser_parseVariableDeclaration_closure: function StylesheetParser_parseVariableDeclaration_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser_parseUseRule_closure: function StylesheetParser_parseUseRule_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser__parseSingleProduction_closure: function StylesheetParser__parseSingleProduction_closure(t0, t1, t2) {
      this.$this = t0;
      this.production = t1;
      this.T = t2;
    },
    StylesheetParser__statement_closure: function StylesheetParser__statement_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser_variableDeclarationWithoutNamespace_closure: function StylesheetParser_variableDeclarationWithoutNamespace_closure(t0, t1) {
      this.$this = t0;
      this.start = t1;
    },
    StylesheetParser_variableDeclarationWithoutNamespace_closure0: function StylesheetParser_variableDeclarationWithoutNamespace_closure0(t0) {
      this.declaration = t0;
    },
    StylesheetParser__styleRule_closure: function StylesheetParser__styleRule_closure(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.wasInStyleRule = t2;
      _.start = t3;
    },
    StylesheetParser__tryDeclarationChildren_closure: function StylesheetParser__tryDeclarationChildren_closure(t0, t1) {
      this.name = t0;
      this.value = t1;
    },
    StylesheetParser__atRootRule_closure: function StylesheetParser__atRootRule_closure(t0) {
      this.query = t0;
    },
    StylesheetParser__atRootRule_closure0: function StylesheetParser__atRootRule_closure0() {
    },
    StylesheetParser__eachRule_closure: function StylesheetParser__eachRule_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.wasInControlDirective = t1;
      _.variables = t2;
      _.list = t3;
    },
    StylesheetParser__functionRule_closure: function StylesheetParser__functionRule_closure(t0, t1, t2) {
      this.name = t0;
      this.$arguments = t1;
      this.precedingComment = t2;
    },
    StylesheetParser__forRule_closure: function StylesheetParser__forRule_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    StylesheetParser__forRule_closure0: function StylesheetParser__forRule_closure0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.wasInControlDirective = t2;
      _.variable = t3;
      _.from = t4;
      _.to = t5;
    },
    StylesheetParser__memberList_closure: function StylesheetParser__memberList_closure(t0, t1, t2) {
      this.$this = t0;
      this.variables = t1;
      this.identifiers = t2;
    },
    StylesheetParser__includeRule_closure: function StylesheetParser__includeRule_closure(t0) {
      this.contentArguments_ = t0;
    },
    StylesheetParser_mediaRule_closure: function StylesheetParser_mediaRule_closure(t0) {
      this.query = t0;
    },
    StylesheetParser__mixinRule_closure: function StylesheetParser__mixinRule_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.name = t1;
      _.$arguments = t2;
      _.precedingComment = t3;
    },
    StylesheetParser_mozDocumentRule_closure: function StylesheetParser_mozDocumentRule_closure(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.name = t2;
      _.value = t3;
    },
    StylesheetParser_supportsRule_closure: function StylesheetParser_supportsRule_closure(t0) {
      this.condition = t0;
    },
    StylesheetParser__whileRule_closure: function StylesheetParser__whileRule_closure(t0, t1, t2) {
      this.$this = t0;
      this.wasInControlDirective = t1;
      this.condition = t2;
    },
    StylesheetParser_unknownAtRule_closure: function StylesheetParser_unknownAtRule_closure(t0, t1) {
      this._box_0 = t0;
      this.name = t1;
    },
    StylesheetParser__expression_resetState: function StylesheetParser__expression_resetState(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.start = t2;
    },
    StylesheetParser__expression_resolveOneOperation: function StylesheetParser__expression_resolveOneOperation(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    StylesheetParser__expression_resolveOperations: function StylesheetParser__expression_resolveOperations(t0, t1) {
      this._box_0 = t0;
      this.resolveOneOperation = t1;
    },
    StylesheetParser__expression_addSingleExpression: function StylesheetParser__expression_addSingleExpression(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.resetState = t2;
      _.resolveOperations = t3;
    },
    StylesheetParser__expression_addOperator: function StylesheetParser__expression_addOperator(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.resolveOneOperation = t2;
    },
    StylesheetParser__expression_resolveSpaceExpressions: function StylesheetParser__expression_resolveSpaceExpressions(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.resolveOperations = t2;
    },
    StylesheetParser_expressionUntilComma_closure: function StylesheetParser_expressionUntilComma_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser__isHexColor_closure: function StylesheetParser__isHexColor_closure() {
    },
    StylesheetParser__unicodeRange_closure: function StylesheetParser__unicodeRange_closure() {
    },
    StylesheetParser__unicodeRange_closure0: function StylesheetParser__unicodeRange_closure0() {
    },
    StylesheetParser_namespacedExpression_closure: function StylesheetParser_namespacedExpression_closure(t0, t1) {
      this.$this = t0;
      this.start = t1;
    },
    StylesheetParser_trySpecialFunction_closure: function StylesheetParser_trySpecialFunction_closure() {
    },
    StylesheetParser__expressionUntilComparison_closure: function StylesheetParser__expressionUntilComparison_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser__publicIdentifier_closure: function StylesheetParser__publicIdentifier_closure(t0, t1) {
      this.$this = t0;
      this.start = t1;
    },
    StylesheetNode$_(_stylesheet, importer, canonicalUrl, allUpstream) {
      var t1 = new A.StylesheetNode(_stylesheet, importer, canonicalUrl, allUpstream._1, allUpstream._0, A.LinkedHashSet_LinkedHashSet$_empty(type$.StylesheetNode));
      t1.StylesheetNode$_$4(_stylesheet, importer, canonicalUrl, allUpstream);
      return t1;
    },
    StylesheetGraph: function StylesheetGraph(t0, t1, t2) {
      this._nodes = t0;
      this.importCache = t1;
      this._transitiveModificationTimes = t2;
    },
    StylesheetGraph_modifiedSince_transitiveModificationTime: function StylesheetGraph_modifiedSince_transitiveModificationTime(t0) {
      this.$this = t0;
    },
    StylesheetGraph_modifiedSince_transitiveModificationTime_closure: function StylesheetGraph_modifiedSince_transitiveModificationTime_closure(t0, t1) {
      this.node = t0;
      this.transitiveModificationTime = t1;
    },
    StylesheetGraph__add_closure: function StylesheetGraph__add_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.baseImporter = t2;
      _.baseUrl = t3;
    },
    StylesheetGraph_addCanonical_closure: function StylesheetGraph_addCanonical_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _.originalUrl = t3;
    },
    StylesheetGraph_reload_closure: function StylesheetGraph_reload_closure(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.canonicalUrl = t2;
    },
    StylesheetGraph__nodeFor_closure: function StylesheetGraph__nodeFor_closure(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.baseImporter = t2;
      _.baseUrl = t3;
      _.forImport = t4;
    },
    StylesheetGraph__nodeFor_closure0: function StylesheetGraph__nodeFor_closure0(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    StylesheetNode: function StylesheetNode(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._stylesheet = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _._upstream = t3;
      _._upstreamImports = t4;
      _._downstream = t5;
    },
    Syntax_forPath(path) {
      var t1,
        _0_0 = A.ParsedPath_ParsedPath$parse(path, $.$get$context().style)._splitExtension$1(1)[1];
      $label0$0: {
        if (".sass" === _0_0) {
          t1 = B.Syntax_Sass_sass;
          break $label0$0;
        }
        if (".css" === _0_0) {
          t1 = B.Syntax_CSS_css;
          break $label0$0;
        }
        t1 = B.Syntax_SCSS_scss;
        break $label0$0;
      }
      return t1;
    },
    Syntax: function Syntax(t0, t1) {
      this._syntax$_name = t0;
      this._name = t1;
    },
    Box: function Box(t0, t1) {
      this._box$_inner = t0;
      this.$ti = t1;
    },
    ModifiableBox: function ModifiableBox(t0, t1) {
      this.value = t0;
      this.$ti = t1;
    },
    LazyFileSpan: function LazyFileSpan(t0) {
      this._builder = t0;
      this._lazy_file_span$_span = null;
    },
    LimitedMapView$blocklist(_map, blocklist, $K, $V) {
      var t2, key,
        t1 = A.LinkedHashSet_LinkedHashSet$_empty($K);
      for (t2 = J.get$iterator$ax(_map.get$keys(_map)); t2.moveNext$0();) {
        key = t2.get$current(t2);
        if (!blocklist.contains$1(0, key))
          t1.add$1(0, key);
      }
      return new A.LimitedMapView(_map, t1, $K._eval$1("@<0>")._bind$1($V)._eval$1("LimitedMapView<1,2>"));
    },
    LimitedMapView: function LimitedMapView(t0, t1, t2) {
      this._limited_map_view$_map = t0;
      this._limited_map_view$_keys = t1;
      this.$ti = t2;
    },
    MapExtensions_get_pairs(_this, $K, $V) {
      return _this.get$entries(_this).map$1$1(0, new A.MapExtensions_get_pairs_closure($K, $V), $K._eval$1("@<0>")._bind$1($V)._eval$1("+(1,2)"));
    },
    MapExtensions_get_pairs_closure: function MapExtensions_get_pairs_closure(t0, t1) {
      this.K = t0;
      this.V = t1;
    },
    MergedMapView$(maps, $K, $V) {
      var t1 = $K._eval$1("@<0>")._bind$1($V);
      t1 = new A.MergedMapView(A.LinkedHashMap_LinkedHashMap$_empty($K, t1._eval$1("Map<1,2>")), t1._eval$1("MergedMapView<1,2>"));
      t1.MergedMapView$1(maps, $K, $V);
      return t1;
    },
    MergedMapView: function MergedMapView(t0, t1) {
      this._mapsByKey = t0;
      this.$ti = t1;
    },
    MultiDirWatcher: function MultiDirWatcher(t0, t1, t2) {
      this._watchers = t0;
      this._group = t1;
      this._poll = t2;
    },
    MultiSpan: function MultiSpan(t0, t1, t2) {
      this._multi_span$_primary = t0;
      this.primaryLabel = t1;
      this.secondarySpans = t2;
    },
    NoSourceMapBuffer: function NoSourceMapBuffer(t0) {
      this._no_source_map_buffer$_buffer = t0;
    },
    PrefixedMapView: function PrefixedMapView(t0, t1, t2) {
      this._prefixed_map_view$_map = t0;
      this._prefix = t1;
      this.$ti = t2;
    },
    _PrefixedKeys: function _PrefixedKeys(t0) {
      this._view = t0;
    },
    _PrefixedKeys_iterator_closure: function _PrefixedKeys_iterator_closure(t0) {
      this.$this = t0;
    },
    PublicMemberMapView: function PublicMemberMapView(t0, t1) {
      this._public_member_map_view$_inner = t0;
      this.$ti = t1;
    },
    SourceMapBuffer: function SourceMapBuffer(t0, t1) {
      var _ = this;
      _._source_map_buffer$_buffer = t0;
      _._entries = t1;
      _._column = _._line = 0;
      _._inSpan = false;
    },
    SourceMapBuffer_buildSourceMap_closure: function SourceMapBuffer_buildSourceMap_closure(t0, t1) {
      this._box_0 = t0;
      this.prefixLength = t1;
    },
    UnprefixedMapView: function UnprefixedMapView(t0, t1, t2) {
      this._unprefixed_map_view$_map = t0;
      this._unprefixed_map_view$_prefix = t1;
      this.$ti = t2;
    },
    _UnprefixedKeys: function _UnprefixedKeys(t0) {
      this._unprefixed_map_view$_view = t0;
    },
    _UnprefixedKeys_iterator_closure: function _UnprefixedKeys_iterator_closure(t0) {
      this.$this = t0;
    },
    _UnprefixedKeys_iterator_closure0: function _UnprefixedKeys_iterator_closure0(t0) {
      this.$this = t0;
    },
    toSentence(iter, conjunction) {
      if (iter.get$length(iter) === 1)
        return J.toString$0$(iter.get$first(iter));
      return A.IterableExtension_get_exceptLast(iter).join$1(0, ", ") + (" " + conjunction + " " + A.S(iter.get$last(iter)));
    },
    indent(string, indentation) {
      return new A.MappedListIterable(A._setArrayType(string.split("\n"), type$.JSArray_String), new A.indent_closure(indentation), type$.MappedListIterable_String_String).join$1(0, "\n");
    },
    pluralize($name, number, plural) {
      if (number === 1)
        return $name;
      if (plural != null)
        return plural;
      return $name + "s";
    },
    trimAscii(string, excludeEscape) {
      var t1,
        start = A._firstNonWhitespace(string);
      if (start == null)
        t1 = "";
      else {
        t1 = A._lastNonWhitespace(string, true);
        t1.toString;
        t1 = B.JSString_methods.substring$2(string, start, t1 + 1);
      }
      return t1;
    },
    trimAsciiRight(string, excludeEscape) {
      var end = A._lastNonWhitespace(string, excludeEscape);
      return end == null ? "" : B.JSString_methods.substring$2(string, 0, end + 1);
    },
    _firstNonWhitespace(string) {
      var t1, i, t2;
      for (t1 = string.length, i = 0; i < t1; ++i) {
        t2 = string.charCodeAt(i);
        if (!(t2 === 32 || t2 === 9 || t2 === 10 || t2 === 13 || t2 === 12))
          return i;
      }
      return null;
    },
    _lastNonWhitespace(string, excludeEscape) {
      var i, i0, codeUnit;
      for (i = string.length - 1, i0 = i; i0 >= 0; --i0) {
        codeUnit = string.charCodeAt(i0);
        if (!(codeUnit === 32 || codeUnit === 9 || codeUnit === 10 || codeUnit === 13 || codeUnit === 12))
          if (excludeEscape && i0 !== 0 && i0 !== i && codeUnit === 92)
            return i0 + 1;
          else
            return i0;
      }
      return null;
    },
    isPublic(member) {
      var start = member.charCodeAt(0);
      return start !== 45 && start !== 95;
    },
    flattenVertically(iterable, $T) {
      var result,
        t1 = iterable.$ti._eval$1("@<ListIterable.E>")._bind$1($T._eval$1("QueueList<0>"))._eval$1("MappedListIterable<1,2>"),
        queues = A.List_List$of(new A.MappedListIterable(iterable, new A.flattenVertically_closure($T), t1), true, t1._eval$1("ListIterable.E"));
      if (queues.length === 1)
        return B.JSArray_methods.get$first(queues);
      result = A._setArrayType([], $T._eval$1("JSArray<0>"));
      for (; queues.length !== 0;) {
        if (!!queues.fixed$length)
          A.throwExpression(A.UnsupportedError$("removeWhere"));
        B.JSArray_methods._removeWhere$2(queues, new A.flattenVertically_closure0(result, $T), true);
      }
      return result;
    },
    codepointIndexToCodeUnitIndex(string, codepointIndex) {
      var codeUnitIndex, i, codeUnitIndex0;
      for (codeUnitIndex = 0, i = 0; i < codepointIndex; ++i) {
        codeUnitIndex0 = codeUnitIndex + 1;
        codeUnitIndex = string.charCodeAt(codeUnitIndex) >>> 10 === 54 ? codeUnitIndex0 + 1 : codeUnitIndex0;
      }
      return codeUnitIndex;
    },
    codeUnitIndexToCodepointIndex(string, codeUnitIndex) {
      var codepointIndex, i;
      for (codepointIndex = 0, i = 0; i < codeUnitIndex; i = (string.charCodeAt(i) >>> 10 === 54 ? i + 1 : i) + 1)
        ++codepointIndex;
      return codepointIndex;
    },
    frameForSpan(span, member, url) {
      var t2, t3,
        t1 = url == null ? span.get$sourceUrl(span) : url;
      if (t1 == null)
        t1 = $.$get$_noSourceUrl();
      t2 = span.get$start(span);
      t2 = t2.file.getLine$1(t2.offset);
      t3 = span.get$start(span);
      return new A.Frame(t1, t2 + 1, t3.file.getColumn$1(t3.offset) + 1, member);
    },
    declarationName(span) {
      var text = A.String_String$fromCharCodes(B.NativeUint32List_methods.sublist$2(span.file._decodedChars, span._file$_start, span._end), 0, null);
      return A.trimAsciiRight(B.JSString_methods.substring$2(text, 0, B.JSString_methods.indexOf$1(text, ":")), false);
    },
    unvendor($name) {
      var i,
        t1 = $name.length;
      if (t1 < 2)
        return $name;
      if ($name.charCodeAt(0) !== 45)
        return $name;
      if ($name.charCodeAt(1) === 45)
        return $name;
      for (i = 2; i < t1; ++i)
        if ($name.charCodeAt(i) === 45)
          return B.JSString_methods.substring$1($name, i + 1);
      return $name;
    },
    equalsIgnoreCase(string1, string2) {
      var t1, i;
      if (string1 === string2)
        return true;
      if (string1 == null)
        return false;
      t1 = string1.length;
      if (t1 !== string2.length)
        return false;
      for (i = 0; i < t1; ++i)
        if (!A.characterEqualsIgnoreCase(string1.charCodeAt(i), string2.charCodeAt(i)))
          return false;
      return true;
    },
    startsWithIgnoreCase(string, prefix) {
      var i,
        t1 = prefix.length;
      if (string.length < t1)
        return false;
      for (i = 0; i < t1; ++i)
        if (!A.characterEqualsIgnoreCase(string.charCodeAt(i), prefix.charCodeAt(i)))
          return false;
      return true;
    },
    mapInPlace(list, $function) {
      var i;
      for (i = 0; i < list.length; ++i)
        list[i] = $function.call$1(list[i]);
    },
    longestCommonSubsequence(list1, list2, select, $T) {
      var t1, _i, selections, i, i0, j, selection, j0,
        _length = list1.get$length(0) + 1,
        lengths = J.JSArray_JSArray$allocateFixed(_length, type$.List_int);
      for (t1 = type$.int, _i = 0; _i < _length; ++_i)
        lengths[_i] = A.List_List$filled(((list2._queue_list$_tail - list2._queue_list$_head & J.get$length$asx(list2._queue_list$_table) - 1) >>> 0) + 1, 0, false, t1);
      _length = list1.get$length(0);
      selections = J.JSArray_JSArray$allocateFixed(_length, $T._eval$1("List<0?>"));
      for (t1 = $T._eval$1("0?"), _i = 0; _i < _length; ++_i)
        selections[_i] = A.List_List$filled((list2._queue_list$_tail - list2._queue_list$_head & J.get$length$asx(list2._queue_list$_table) - 1) >>> 0, null, false, t1);
      for (i = 0; i < (list1._queue_list$_tail - list1._queue_list$_head & J.get$length$asx(list1._queue_list$_table) - 1) >>> 0; i = i0)
        for (i0 = i + 1, j = 0; j < (list2._queue_list$_tail - list2._queue_list$_head & J.get$length$asx(list2._queue_list$_table) - 1) >>> 0; j = j0) {
          selection = select.call$2(list1.$index(0, i), list2.$index(0, j));
          selections[i][j] = selection;
          t1 = lengths[i0];
          j0 = j + 1;
          t1[j0] = selection == null ? Math.max(t1[j], lengths[i][j0]) : lengths[i][j] + 1;
        }
      return new A.longestCommonSubsequence_backtrack(selections, lengths, $T).call$2(list1.get$length(0) - 1, list2.get$length(0) - 1);
    },
    removeFirstWhere(list, test, orElse) {
      var i;
      for (i = 0; i < list.length; ++i) {
        if (!test.call$1(list[i]))
          continue;
        B.JSArray_methods.removeAt$1(list, i);
        return;
      }
      orElse.call$0();
    },
    mapAddAll2(destination, source, K1, K2, $V) {
      source.forEach$1(0, new A.mapAddAll2_closure(destination, K1, K2, $V));
    },
    setAll(map, keys, value) {
      var t1;
      for (t1 = J.get$iterator$ax(keys); t1.moveNext$0();)
        map.$indexSet(0, t1.get$current(t1), value);
    },
    rotateSlice(list, start, end) {
      var i, next,
        element = list.$index(0, end - 1);
      for (i = start; i < end; ++i, element = next) {
        next = list.$index(0, i);
        list.$indexSet(0, i, element);
      }
    },
    mapAsync(iterable, callback, $E, $F) {
      return A.mapAsync$body(iterable, callback, $E, $F, $F._eval$1("Iterable<0>"));
    },
    mapAsync$body(iterable, callback, $E, $F, $async$type) {
      var $async$goto = 0,
        $async$completer = A._makeAsyncAwaitCompleter($async$type),
        $async$returnValue, t2, _i, t1, $async$temp1;
      var $async$mapAsync = A._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return A._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = A._setArrayType([], $F._eval$1("JSArray<0>"));
              t2 = iterable.length, _i = 0;
            case 3:
              // for condition
              if (!(_i < t2)) {
                // goto after for
                $async$goto = 5;
                break;
              }
              $async$temp1 = t1;
              $async$goto = 6;
              return A._asyncAwait(callback.call$1(iterable[_i]), $async$mapAsync);
            case 6:
              // returning from await.
              $async$temp1.push($async$result);
            case 4:
              // for update
              ++_i;
              // goto for condition
              $async$goto = 3;
              break;
            case 5:
              // after for
              $async$returnValue = t1;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return A._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return A._asyncStartSync($async$mapAsync, $async$completer);
    },
    putIfAbsentAsync(map, key, ifAbsent, $K, $V) {
      return A.putIfAbsentAsync$body(map, key, ifAbsent, $K, $V, $V);
    },
    putIfAbsentAsync$body(map, key, ifAbsent, $K, $V, $async$type) {
      var $async$goto = 0,
        $async$completer = A._makeAsyncAwaitCompleter($async$type),
        $async$returnValue, t1, value;
      var $async$putIfAbsentAsync = A._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return A._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              if (map.containsKey$1(key)) {
                t1 = map.$index(0, key);
                $async$returnValue = t1 == null ? $V._as(t1) : t1;
                // goto return
                $async$goto = 1;
                break;
              }
              $async$goto = 3;
              return A._asyncAwait(ifAbsent.call$0(), $async$putIfAbsentAsync);
            case 3:
              // returning from await.
              value = $async$result;
              map.$indexSet(0, key, value);
              $async$returnValue = value;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return A._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return A._asyncStartSync($async$putIfAbsentAsync, $async$completer);
    },
    copyMapOfMap(map, K1, K2, $V) {
      var t3, key, child,
        t1 = K2._eval$1("@<0>")._bind$1($V)._eval$1("Map<1,2>"),
        t2 = A.LinkedHashMap_LinkedHashMap$_empty(K1, t1);
      for (t1 = A.MapExtensions_get_pairs(map, K1, t1), t1 = t1.get$iterator(t1); t1.moveNext$0();) {
        t3 = t1.get$current(t1);
        key = t3._0;
        child = t3._1;
        t3 = A.LinkedHashMap_LinkedHashMap(null, null, null, K2, $V);
        t3.addAll$1(0, child);
        t2.$indexSet(0, key, t3);
      }
      return t2;
    },
    copyMapOfList(map, $K, $E) {
      var t3,
        t1 = $E._eval$1("List<0>"),
        t2 = A.LinkedHashMap_LinkedHashMap$_empty($K, t1);
      for (t1 = A.MapExtensions_get_pairs(map, $K, t1), t1 = t1.get$iterator(t1); t1.moveNext$0();) {
        t3 = t1.get$current(t1);
        t2.$indexSet(0, t3._0, J.toList$0$ax(t3._1));
      }
      return t2;
    },
    consumeEscapedCharacter(scanner) {
      var _1_0, value, i, next, t1;
      scanner.expectChar$1(92);
      _1_0 = scanner.peekChar$0();
      if (_1_0 == null)
        return 65533;
      if (_1_0 === 10 || _1_0 === 13 || _1_0 === 12)
        scanner.error$1(0, "Expected escape sequence.");
      if (A.CharacterExtension_get_isHex(_1_0)) {
        for (value = 0, i = 0; i < 6; ++i) {
          next = scanner.peekChar$0();
          if (next != null) {
            if (!(next >= 48 && next <= 57))
              if (!(next >= 97 && next <= 102))
                t1 = next >= 65 && next <= 70;
              else
                t1 = true;
            else
              t1 = true;
            t1 = !t1;
          } else
            t1 = true;
          if (t1)
            break;
          value = (value << 4 >>> 0) + A.asHex(scanner.readChar$0());
        }
        t1 = scanner.peekChar$0();
        if (t1 === 32 || t1 === 9 || t1 === 10 || t1 === 13 || t1 === 12)
          scanner.readChar$0();
        $label0$1: {
          if (0 !== value)
            t1 = value >= 55296 && value <= 57343 || value >= 1114111;
          else
            t1 = true;
          if (t1) {
            t1 = 65533;
            break $label0$1;
          }
          t1 = value;
          break $label0$1;
        }
        return t1;
      }
      return scanner.readChar$0();
    },
    throwWithTrace(error, originalError, trace) {
      var t1 = A.getTrace(originalError);
      A.attachTrace(error, t1 == null ? trace : t1);
      throw A.wrapException(error);
    },
    attachTrace(error, trace) {
      var t1;
      if (trace.toString$0(0).length === 0)
        return;
      t1 = $.$get$_traces();
      A.Expando__checkType(error);
      if (t1._jsWeakMap.get(error) == null)
        t1.$indexSet(0, error, trace);
    },
    getTrace(error) {
      var t1;
      if (typeof error == "string" || typeof error == "number" || A._isBool(error))
        t1 = null;
      else {
        t1 = $.$get$_traces();
        A.Expando__checkType(error);
        t1 = t1._jsWeakMap.get(error);
      }
      return t1;
    },
    indent_closure: function indent_closure(t0) {
      this.indentation = t0;
    },
    flattenVertically_closure: function flattenVertically_closure(t0) {
      this.T = t0;
    },
    flattenVertically_closure0: function flattenVertically_closure0(t0, t1) {
      this.result = t0;
      this.T = t1;
    },
    longestCommonSubsequence_backtrack: function longestCommonSubsequence_backtrack(t0, t1, t2) {
      this.selections = t0;
      this.lengths = t1;
      this.T = t2;
    },
    mapAddAll2_closure: function mapAddAll2_closure(t0, t1, t2, t3) {
      var _ = this;
      _.destination = t0;
      _.K1 = t1;
      _.K2 = t2;
      _.V = t3;
    },
    SassApiValue_assertSelector(_this, allowParent, $name) {
      var error, stackTrace, t1, exception,
        string = _this._selectorString$1($name);
      try {
        t1 = A.SelectorList_SelectorList$parse(string, allowParent, null, null, false);
        return t1;
      } catch (exception) {
        t1 = A.unwrapException(exception);
        if (type$.SassFormatException._is(t1)) {
          error = t1;
          stackTrace = A.getTraceFromException(exception);
          t1 = B.JSString_methods.replaceFirst$2(J.toString$0$(error), "Error: ", "");
          A.throwWithTrace(new A.SassScriptException($name == null ? t1 : "$" + $name + ": " + t1), error, stackTrace);
        } else
          throw exception;
      }
    },
    SassApiValue_assertCompoundSelector(_this, $name) {
      var error, stackTrace, t1, exception,
        allowParent = false,
        string = _this._selectorString$1($name);
      try {
        t1 = A.SelectorParser$(string, allowParent, null, null, false, null).parseCompoundSelector$0();
        return t1;
      } catch (exception) {
        t1 = A.unwrapException(exception);
        if (type$.SassFormatException._is(t1)) {
          error = t1;
          stackTrace = A.getTraceFromException(exception);
          t1 = B.JSString_methods.replaceFirst$2(J.toString$0$(error), "Error: ", "");
          A.throwWithTrace(new A.SassScriptException("$" + $name + ": " + t1), error, stackTrace);
        } else
          throw exception;
      }
    },
    Value: function Value() {
    },
    SassArgumentList$(contents, keywords, separator) {
      var t1 = type$.Value;
      t1 = new A.SassArgumentList(A.ConstantMap_ConstantMap$from(keywords, type$.String, t1), A.List_List$unmodifiable(contents, t1), separator, false);
      t1.SassList$3$brackets(contents, separator, false);
      return t1;
    },
    SassArgumentList: function SassArgumentList(t0, t1, t2, t3) {
      var _ = this;
      _._keywords = t0;
      _._wereKeywordsAccessed = false;
      _._list$_contents = t1;
      _._separator = t2;
      _._hasBrackets = t3;
    },
    SassBoolean: function SassBoolean(t0) {
      this.value = t0;
    },
    SassCalculation_calc(argument) {
      var t1,
        _0_0 = A.SassCalculation__simplify(argument);
      $label0$0: {
        if (_0_0 instanceof A.SassNumber) {
          t1 = _0_0;
          break $label0$0;
        }
        if (_0_0 instanceof A.SassCalculation) {
          t1 = _0_0;
          break $label0$0;
        }
        t1 = new A.SassCalculation("calc", A.List_List$unmodifiable([_0_0], type$.Object));
        break $label0$0;
      }
      return t1;
    },
    SassCalculation_min($arguments) {
      var minimum, _i, arg, t2,
        args = A.List_List$unmodifiable(new A.MappedListIterable($arguments, A.calculation_SassCalculation__simplify$closure(), A._arrayInstanceType($arguments)._eval$1("MappedListIterable<1,@>")), type$.Object),
        t1 = args.length;
      if (t1 === 0)
        throw A.wrapException(A.ArgumentError$("min() must have at least one argument.", null));
      for (minimum = null, _i = 0; _i < t1; ++_i) {
        arg = args[_i];
        if (arg instanceof A.SassNumber)
          t2 = minimum != null && !minimum.isComparableTo$1(arg);
        else
          t2 = true;
        if (t2) {
          minimum = null;
          break;
        } else if (minimum == null || minimum.greaterThan$1(arg).value)
          minimum = arg;
      }
      if (minimum != null)
        return minimum;
      A.SassCalculation__verifyCompatibleNumbers(args);
      return new A.SassCalculation("min", args);
    },
    SassCalculation_max($arguments) {
      var maximum, _i, arg, t2,
        args = A.List_List$unmodifiable(new A.MappedListIterable($arguments, A.calculation_SassCalculation__simplify$closure(), A._arrayInstanceType($arguments)._eval$1("MappedListIterable<1,@>")), type$.Object),
        t1 = args.length;
      if (t1 === 0)
        throw A.wrapException(A.ArgumentError$("max() must have at least one argument.", null));
      for (maximum = null, _i = 0; _i < t1; ++_i) {
        arg = args[_i];
        if (arg instanceof A.SassNumber)
          t2 = maximum != null && !maximum.isComparableTo$1(arg);
        else
          t2 = true;
        if (t2) {
          maximum = null;
          break;
        } else if (maximum == null || maximum.lessThan$1(arg).value)
          maximum = arg;
      }
      if (maximum != null)
        return maximum;
      A.SassCalculation__verifyCompatibleNumbers(args);
      return new A.SassCalculation("max", args);
    },
    SassCalculation_hypot($arguments) {
      var first, subtotal, i, number, value, t2, t3,
        args = A.List_List$unmodifiable(new A.MappedListIterable($arguments, A.calculation_SassCalculation__simplify$closure(), A._arrayInstanceType($arguments)._eval$1("MappedListIterable<1,@>")), type$.Object),
        t1 = args.length;
      if (t1 === 0)
        throw A.wrapException(A.ArgumentError$("hypot() must have at least one argument.", null));
      A.SassCalculation__verifyCompatibleNumbers(args);
      first = B.JSArray_methods.get$first(args);
      if (!(first instanceof A.SassNumber) || first.hasUnit$1("%"))
        return new A.SassCalculation("hypot", args);
      for (subtotal = 0, i = 0; i < t1;) {
        number = args[i];
        if (!(number instanceof A.SassNumber) || !number.hasCompatibleUnits$1(first))
          return new A.SassCalculation("hypot", args);
        ++i;
        value = number.convertValueToMatch$3(first, "numbers[" + i + "]", "numbers[1]");
        subtotal += value * value;
      }
      t1 = Math.sqrt(subtotal);
      t2 = J.getInterceptor$x(first);
      t3 = t2.get$numeratorUnits(first);
      return A.SassNumber_SassNumber$withUnits(t1, t2.get$denominatorUnits(first), t3);
    },
    SassCalculation_abs(argument) {
      argument = A.SassCalculation__simplify(argument);
      if (!(argument instanceof A.SassNumber))
        return new A.SassCalculation("abs", A._setArrayType([argument], type$.JSArray_Object));
      if (argument.hasUnit$1("%"))
        A.warnForDeprecation(string$.Passinp + argument.toString$0(0) + ")\nTo emit a CSS abs() now: abs(#{" + argument.toString$0(0) + string$.x7d__Mor, B.Deprecation_GFc);
      return A.SassNumber_SassNumber(Math.abs(argument._number$_value), null).coerceToMatch$1(argument);
    },
    SassCalculation_exp(argument) {
      argument = A.SassCalculation__simplify(argument);
      if (!(argument instanceof A.SassNumber))
        return new A.SassCalculation("exp", A._setArrayType([argument], type$.JSArray_Object));
      argument.assertNoUnits$0();
      return A.pow0(A.SassNumber_SassNumber(2.718281828459045, null), argument);
    },
    SassCalculation_sign(argument) {
      var t1, _0_2, t2, arg;
      argument = A.SassCalculation__simplify(argument);
      $label0$0: {
        t1 = argument instanceof A.SassNumber;
        if (t1) {
          _0_2 = argument._number$_value;
          if (!isNaN(_0_2))
            t2 = 0 === _0_2;
          else
            t2 = true;
        } else
          t2 = false;
        if (t2) {
          t1 = argument;
          break $label0$0;
        }
        if (t1) {
          t1 = !argument.hasUnit$1("%");
          arg = argument;
        } else {
          arg = null;
          t1 = false;
        }
        if (t1) {
          t1 = A.SassNumber_SassNumber(J.get$sign$in(arg._number$_value), null).coerceToMatch$1(argument);
          break $label0$0;
        }
        t1 = new A.SassCalculation("sign", A._setArrayType([argument], type$.JSArray_Object));
        break $label0$0;
      }
      return t1;
    },
    SassCalculation_clamp(min, value, max) {
      var t1, args;
      if (value == null && max != null)
        throw A.wrapException(A.ArgumentError$("If value is null, max must also be null.", null));
      min = A.SassCalculation__simplify(min);
      value = A.NullableExtension_andThen(value, A.calculation_SassCalculation__simplify$closure());
      max = A.NullableExtension_andThen(max, A.calculation_SassCalculation__simplify$closure());
      if (min instanceof A.SassNumber && value instanceof A.SassNumber && max instanceof A.SassNumber && min.hasCompatibleUnits$1(value) && min.hasCompatibleUnits$1(max)) {
        if (value.lessThanOrEquals$1(min).value)
          return min;
        if (value.greaterThanOrEquals$1(max).value)
          return max;
        return value;
      }
      t1 = [min];
      if (value != null)
        t1.push(value);
      if (max != null)
        t1.push(max);
      args = A.List_List$unmodifiable(t1, type$.Object);
      A.SassCalculation__verifyCompatibleNumbers(args);
      A.SassCalculation__verifyLength(args, 3);
      return new A.SassCalculation("clamp", args);
    },
    SassCalculation_pow(base, exponent) {
      var t1 = A._setArrayType([base], type$.JSArray_Object);
      if (exponent != null)
        t1.push(exponent);
      A.SassCalculation__verifyLength(t1, 2);
      base = A.SassCalculation__simplify(base);
      exponent = A.NullableExtension_andThen(exponent, A.calculation_SassCalculation__simplify$closure());
      if (!(base instanceof A.SassNumber) || !(exponent instanceof A.SassNumber))
        return new A.SassCalculation("pow", t1);
      base.assertNoUnits$0();
      exponent.assertNoUnits$0();
      return A.pow0(base, exponent);
    },
    SassCalculation_log(number, base) {
      var t1, t2;
      number = A.SassCalculation__simplify(number);
      base = A.NullableExtension_andThen(base, A.calculation_SassCalculation__simplify$closure());
      t1 = A._setArrayType([number], type$.JSArray_Object);
      t2 = base != null;
      if (t2)
        t1.push(base);
      if (number instanceof A.SassNumber)
        t2 = t2 && !(base instanceof A.SassNumber);
      else
        t2 = true;
      if (t2)
        return new A.SassCalculation("log", t1);
      number.assertNoUnits$0();
      if (base instanceof A.SassNumber) {
        base.assertNoUnits$0();
        return A.log(number, base);
      }
      return A.log(number, null);
    },
    SassCalculation_atan2(y, x) {
      var t1;
      y = A.SassCalculation__simplify(y);
      x = A.NullableExtension_andThen(x, A.calculation_SassCalculation__simplify$closure());
      t1 = A._setArrayType([y], type$.JSArray_Object);
      if (x != null)
        t1.push(x);
      A.SassCalculation__verifyLength(t1, 2);
      A.SassCalculation__verifyCompatibleNumbers(t1);
      if (!(y instanceof A.SassNumber) || !(x instanceof A.SassNumber) || y.hasUnit$1("%") || x.hasUnit$1("%") || !y.hasCompatibleUnits$1(x))
        return new A.SassCalculation("atan2", t1);
      return A.SassNumber_SassNumber$withUnits(Math.atan2(y._number$_value, x.convertValueToMatch$3(y, "x", "y")) * 57.29577951308232, null, A._setArrayType(["deg"], type$.JSArray_String));
    },
    SassCalculation_rem(dividend, modulus) {
      var t1, result;
      dividend = A.SassCalculation__simplify(dividend);
      modulus = A.NullableExtension_andThen(modulus, A.calculation_SassCalculation__simplify$closure());
      t1 = A._setArrayType([dividend], type$.JSArray_Object);
      if (modulus != null)
        t1.push(modulus);
      A.SassCalculation__verifyLength(t1, 2);
      A.SassCalculation__verifyCompatibleNumbers(t1);
      if (!(dividend instanceof A.SassNumber) || !(modulus instanceof A.SassNumber) || !dividend.hasCompatibleUnits$1(modulus))
        return new A.SassCalculation("rem", t1);
      result = dividend.modulo$1(modulus);
      t1 = modulus._number$_value;
      if (A.DoubleWithSignedZero_get_signIncludingZero(t1) !== A.DoubleWithSignedZero_get_signIncludingZero(dividend._number$_value)) {
        if (t1 == 1 / 0 || t1 == -1 / 0)
          return dividend;
        if (result._number$_value === 0)
          return result.unaryMinus$0();
        return result.minus$1(modulus);
      }
      return result;
    },
    SassCalculation_mod(dividend, modulus) {
      var t1;
      dividend = A.SassCalculation__simplify(dividend);
      modulus = A.NullableExtension_andThen(modulus, A.calculation_SassCalculation__simplify$closure());
      t1 = A._setArrayType([dividend], type$.JSArray_Object);
      if (modulus != null)
        t1.push(modulus);
      A.SassCalculation__verifyLength(t1, 2);
      A.SassCalculation__verifyCompatibleNumbers(t1);
      if (!(dividend instanceof A.SassNumber) || !(modulus instanceof A.SassNumber) || !dividend.hasCompatibleUnits$1(modulus))
        return new A.SassCalculation("mod", t1);
      return dividend.modulo$1(modulus);
    },
    SassCalculation_round(strategyOrNumber, numberOrStep, step) {
      var _0_4, _0_5_isSet, _0_20, _0_6, t1, _0_50, _0_6_isSet, number, t2, _0_2_isSet, _0_10_isSet, _0_8, _0_12_isSet, _0_12, _0_14_isSet, _0_14, _0_16_isSet, _0_16, t3, strategy, _0_8_isSet, t4, rest, _null = null, _s5_ = "round",
        _0_1 = A.SassCalculation__simplify(strategyOrNumber),
        _0_2 = A.NullableExtension_andThen(numberOrStep, A.calculation_SassCalculation__simplify$closure()),
        _0_5 = A.NullableExtension_andThen(step, A.calculation_SassCalculation__simplify$closure()),
        _0_10 = _0_1,
        _0_4_isSet = _0_1 instanceof A.SassNumber;
      if (_0_4_isSet) {
        type$.SassNumber._as(_0_10);
        _0_4 = _0_2 == null;
        _0_5_isSet = _0_4;
        _0_20 = _0_2;
        if (_0_5_isSet) {
          _0_6 = _0_5 == null;
          t1 = _0_6;
          _0_50 = _0_5;
        } else {
          _0_50 = _null;
          _0_6 = _0_50;
          t1 = false;
        }
        _0_6_isSet = _0_5_isSet;
        number = _0_10;
        _0_1 = number;
      } else {
        number = _null;
        _0_50 = number;
        _0_6 = _0_50;
        _0_20 = _0_6;
        _0_4 = _0_20;
        _0_1 = _0_10;
        _0_6_isSet = false;
        _0_5_isSet = false;
        t1 = false;
      }
      if (t1) {
        t1 = B.JSNumber_methods.round$0(number._number$_value);
        t2 = number.get$numeratorUnits(number);
        return A.SassNumber_SassNumber$withUnits(t1, number.get$denominatorUnits(number), t2);
      }
      if (_0_1 instanceof A.SassNumber) {
        if (_0_4_isSet) {
          t1 = _0_20;
          _0_2_isSet = _0_4_isSet;
        } else {
          t1 = _0_2;
          _0_20 = t1;
          _0_2_isSet = true;
        }
        if (t1 instanceof A.SassNumber) {
          if (_0_2_isSet)
            t1 = _0_20;
          else {
            t1 = _0_2;
            _0_20 = t1;
            _0_2_isSet = true;
          }
          type$.SassNumber._as(t1);
          if (_0_6_isSet)
            t2 = _0_6;
          else {
            if (_0_5_isSet)
              t2 = _0_50;
            else {
              t2 = _0_5;
              _0_50 = t2;
              _0_5_isSet = true;
            }
            _0_6 = t2 == null;
            t2 = _0_6;
            _0_6_isSet = true;
          }
          t2 = t2 && !_0_1.hasCompatibleUnits$1(t1);
          step = t1;
          t1 = t2;
        } else {
          step = _null;
          t1 = false;
        }
        number = _0_1;
      } else {
        step = _null;
        number = step;
        _0_2_isSet = _0_4_isSet;
        t1 = false;
      }
      if (t1) {
        t1 = type$.JSArray_Object;
        A.SassCalculation__verifyCompatibleNumbers(A._setArrayType([number, step], t1));
        return new A.SassCalculation(_s5_, A._setArrayType([number, step], t1));
      }
      if (_0_1 instanceof A.SassNumber) {
        if (_0_2_isSet)
          t1 = _0_20;
        else {
          t1 = _0_2;
          _0_20 = t1;
          _0_2_isSet = true;
        }
        if (t1 instanceof A.SassNumber) {
          if (_0_2_isSet)
            t1 = _0_20;
          else {
            t1 = _0_2;
            _0_20 = t1;
            _0_2_isSet = true;
          }
          type$.SassNumber._as(t1);
          if (_0_6_isSet)
            t2 = _0_6;
          else {
            if (_0_5_isSet)
              t2 = _0_50;
            else {
              t2 = _0_5;
              _0_50 = t2;
              _0_5_isSet = true;
            }
            _0_6 = t2 == null;
            t2 = _0_6;
            _0_6_isSet = true;
          }
          step = t1;
          t1 = t2;
        } else {
          step = _null;
          t1 = false;
        }
        number = _0_1;
      } else {
        step = _null;
        number = step;
        t1 = false;
      }
      if (t1) {
        A.SassCalculation__verifyCompatibleNumbers(A._setArrayType([number, step], type$.JSArray_Object));
        return A.SassCalculation__roundWithStep("nearest", number, step);
      }
      _0_10_isSet = _0_1 instanceof A.SassString;
      if (_0_10_isSet) {
        _0_8 = _0_1._string$_text;
        t1 = _0_8;
        _0_10 = "nearest" === t1;
        t1 = _0_10;
        _0_12_isSet = !t1;
        if (_0_12_isSet) {
          _0_12 = "up" === _0_8;
          t1 = _0_12;
          _0_14_isSet = !t1;
          if (_0_14_isSet) {
            _0_14 = "down" === _0_8;
            t1 = _0_14;
            _0_16_isSet = !t1;
            if (_0_16_isSet) {
              _0_16 = "to-zero" === _0_8;
              t1 = _0_16;
            } else {
              _0_16 = _null;
              t1 = true;
            }
          } else {
            _0_16 = _null;
            _0_14 = _0_16;
            _0_16_isSet = false;
            t1 = true;
          }
        } else {
          _0_16 = _null;
          _0_14 = _0_16;
          _0_12 = _0_14;
          _0_14_isSet = false;
          _0_16_isSet = false;
          t1 = true;
        }
        if (t1) {
          if (_0_2_isSet)
            t1 = _0_20;
          else {
            t1 = _0_2;
            _0_20 = t1;
            _0_2_isSet = true;
          }
          if (t1 instanceof A.SassNumber) {
            if (_0_2_isSet)
              t1 = _0_20;
            else {
              t1 = _0_2;
              _0_20 = t1;
              _0_2_isSet = true;
            }
            t2 = type$.SassNumber;
            t2._as(t1);
            if (_0_5_isSet)
              t3 = _0_50;
            else {
              t3 = _0_5;
              _0_50 = t3;
              _0_5_isSet = true;
            }
            if (t3 instanceof A.SassNumber) {
              if (_0_5_isSet)
                t3 = _0_50;
              else {
                t3 = _0_5;
                _0_50 = t3;
                _0_5_isSet = true;
              }
              t2._as(t3);
              t2 = !t1.hasCompatibleUnits$1(t3);
              step = t3;
            } else {
              step = _null;
              t2 = false;
            }
            number = t1;
            t1 = t2;
          } else {
            step = _null;
            number = step;
            t1 = false;
          }
          strategy = _0_1;
        } else {
          step = _null;
          number = step;
          strategy = number;
          t1 = false;
        }
      } else {
        step = _null;
        number = step;
        strategy = number;
        _0_16 = strategy;
        _0_14 = _0_16;
        _0_12 = _0_14;
        _0_8 = _0_12;
        _0_10 = _0_8;
        _0_12_isSet = false;
        _0_14_isSet = false;
        _0_16_isSet = false;
        t1 = false;
      }
      if (t1) {
        t1 = type$.JSArray_Object;
        A.SassCalculation__verifyCompatibleNumbers(A._setArrayType([number, step], t1));
        return new A.SassCalculation(_s5_, A._setArrayType([strategy, number, step], t1));
      }
      if (_0_1 instanceof A.SassString) {
        if (_0_10_isSet) {
          t1 = _0_10;
          _0_8_isSet = _0_10_isSet;
        } else {
          _0_8 = _0_1._string$_text;
          t1 = _0_8;
          _0_10 = "nearest" === t1;
          t1 = _0_10;
          _0_10_isSet = true;
          _0_8_isSet = true;
        }
        if (!t1) {
          if (_0_12_isSet)
            t1 = _0_12;
          else {
            if (_0_8_isSet)
              t1 = _0_8;
            else {
              _0_8 = _0_1._string$_text;
              t1 = _0_8;
              _0_8_isSet = true;
            }
            _0_12 = "up" === t1;
            t1 = _0_12;
            _0_12_isSet = true;
          }
          if (!t1) {
            if (_0_14_isSet)
              t1 = _0_14;
            else {
              if (_0_8_isSet)
                t1 = _0_8;
              else {
                _0_8 = _0_1._string$_text;
                t1 = _0_8;
                _0_8_isSet = true;
              }
              _0_14 = "down" === t1;
              t1 = _0_14;
              _0_14_isSet = true;
            }
            if (!t1)
              if (_0_16_isSet)
                t1 = _0_16;
              else {
                if (_0_8_isSet)
                  t1 = _0_8;
                else {
                  _0_8 = _0_1._string$_text;
                  t1 = _0_8;
                  _0_8_isSet = true;
                }
                _0_16 = "to-zero" === t1;
                t1 = _0_16;
                _0_16_isSet = true;
              }
            else
              t1 = true;
          } else
            t1 = true;
        } else
          t1 = true;
        if (t1) {
          if (_0_2_isSet)
            t1 = _0_20;
          else {
            t1 = _0_2;
            _0_20 = t1;
            _0_2_isSet = true;
          }
          if (t1 instanceof A.SassNumber) {
            if (_0_2_isSet)
              t1 = _0_20;
            else {
              t1 = _0_2;
              _0_20 = t1;
              _0_2_isSet = true;
            }
            t2 = type$.SassNumber;
            t2._as(t1);
            if (_0_5_isSet)
              t3 = _0_50;
            else {
              t3 = _0_5;
              _0_50 = t3;
              _0_5_isSet = true;
            }
            t3 = t3 instanceof A.SassNumber;
            if (t3) {
              if (_0_5_isSet)
                t4 = _0_50;
              else {
                t4 = _0_5;
                _0_50 = t4;
                _0_5_isSet = true;
              }
              t2._as(t4);
              step = t4;
            } else
              step = _null;
            t2 = t3;
            number = t1;
            t1 = t2;
          } else {
            step = _null;
            number = step;
            t1 = false;
          }
          strategy = _0_1;
        } else {
          step = _null;
          number = step;
          strategy = number;
          t1 = false;
        }
      } else {
        step = _null;
        number = step;
        strategy = number;
        _0_8_isSet = _0_10_isSet;
        t1 = false;
      }
      if (t1) {
        A.SassCalculation__verifyCompatibleNumbers(A._setArrayType([number, step], type$.JSArray_Object));
        return A.SassCalculation__roundWithStep(strategy._string$_text, number, step);
      }
      if (_0_1 instanceof A.SassString) {
        if (_0_10_isSet)
          t1 = _0_10;
        else {
          if (_0_8_isSet)
            t1 = _0_8;
          else {
            _0_8 = _0_1._string$_text;
            t1 = _0_8;
            _0_8_isSet = true;
          }
          _0_10 = "nearest" === t1;
          t1 = _0_10;
          _0_10_isSet = true;
        }
        if (!t1) {
          if (_0_12_isSet)
            t1 = _0_12;
          else {
            if (_0_8_isSet)
              t1 = _0_8;
            else {
              _0_8 = _0_1._string$_text;
              t1 = _0_8;
              _0_8_isSet = true;
            }
            _0_12 = "up" === t1;
            t1 = _0_12;
            _0_12_isSet = true;
          }
          if (!t1) {
            if (_0_14_isSet)
              t1 = _0_14;
            else {
              if (_0_8_isSet)
                t1 = _0_8;
              else {
                _0_8 = _0_1._string$_text;
                t1 = _0_8;
                _0_8_isSet = true;
              }
              _0_14 = "down" === t1;
              t1 = _0_14;
              _0_14_isSet = true;
            }
            if (!t1)
              if (_0_16_isSet)
                t1 = _0_16;
              else {
                if (_0_8_isSet)
                  t1 = _0_8;
                else {
                  _0_8 = _0_1._string$_text;
                  t1 = _0_8;
                  _0_8_isSet = true;
                }
                _0_16 = "to-zero" === t1;
                t1 = _0_16;
                _0_16_isSet = true;
              }
            else
              t1 = true;
          } else
            t1 = true;
        } else
          t1 = true;
        if (t1) {
          if (_0_2_isSet)
            t1 = _0_20;
          else {
            t1 = _0_2;
            _0_20 = t1;
            _0_2_isSet = true;
          }
          if (t1 instanceof A.SassString) {
            if (_0_2_isSet)
              t1 = _0_20;
            else {
              t1 = _0_2;
              _0_20 = t1;
              _0_2_isSet = true;
            }
            type$.SassString._as(t1);
            if (_0_6_isSet)
              t2 = _0_6;
            else {
              if (_0_5_isSet)
                t2 = _0_50;
              else {
                t2 = _0_5;
                _0_50 = t2;
                _0_5_isSet = true;
              }
              _0_6 = t2 == null;
              t2 = _0_6;
              _0_6_isSet = true;
            }
            rest = t1;
            t1 = t2;
          } else {
            rest = _null;
            t1 = false;
          }
          strategy = _0_1;
        } else {
          rest = _null;
          strategy = rest;
          t1 = false;
        }
      } else {
        rest = _null;
        strategy = rest;
        t1 = false;
      }
      if (t1)
        return new A.SassCalculation(_s5_, A._setArrayType([strategy, rest], type$.JSArray_Object));
      if (_0_1 instanceof A.SassString) {
        if (_0_10_isSet)
          t1 = _0_10;
        else {
          if (_0_8_isSet)
            t1 = _0_8;
          else {
            _0_8 = _0_1._string$_text;
            t1 = _0_8;
            _0_8_isSet = true;
          }
          _0_10 = "nearest" === t1;
          t1 = _0_10;
          _0_10_isSet = true;
        }
        if (!t1) {
          if (_0_12_isSet)
            t1 = _0_12;
          else {
            if (_0_8_isSet)
              t1 = _0_8;
            else {
              _0_8 = _0_1._string$_text;
              t1 = _0_8;
              _0_8_isSet = true;
            }
            _0_12 = "up" === t1;
            t1 = _0_12;
            _0_12_isSet = true;
          }
          if (!t1) {
            if (_0_14_isSet)
              t1 = _0_14;
            else {
              if (_0_8_isSet)
                t1 = _0_8;
              else {
                _0_8 = _0_1._string$_text;
                t1 = _0_8;
                _0_8_isSet = true;
              }
              _0_14 = "down" === t1;
              t1 = _0_14;
              _0_14_isSet = true;
            }
            if (!t1)
              if (_0_16_isSet)
                t1 = _0_16;
              else {
                if (_0_8_isSet)
                  t1 = _0_8;
                else {
                  _0_8 = _0_1._string$_text;
                  t1 = _0_8;
                  _0_8_isSet = true;
                }
                _0_16 = "to-zero" === t1;
                t1 = _0_16;
                _0_16_isSet = true;
              }
            else
              t1 = true;
          } else
            t1 = true;
        } else
          t1 = true;
        if (t1) {
          if (_0_2_isSet)
            t1 = _0_20;
          else {
            t1 = _0_2;
            _0_20 = t1;
            _0_2_isSet = true;
          }
          if (t1 != null)
            if (_0_6_isSet)
              t1 = _0_6;
            else {
              if (_0_5_isSet)
                t1 = _0_50;
              else {
                t1 = _0_5;
                _0_50 = t1;
                _0_5_isSet = true;
              }
              _0_6 = t1 == null;
              t1 = _0_6;
              _0_6_isSet = true;
            }
          else
            t1 = false;
        } else
          t1 = false;
      } else
        t1 = false;
      if (t1)
        throw A.wrapException(A.SassScriptException$(string$.If_str, _null));
      if (_0_1 instanceof A.SassString) {
        if (_0_10_isSet)
          t1 = _0_10;
        else {
          if (_0_8_isSet)
            t1 = _0_8;
          else {
            _0_8 = _0_1._string$_text;
            t1 = _0_8;
            _0_8_isSet = true;
          }
          _0_10 = "nearest" === t1;
          t1 = _0_10;
          _0_10_isSet = true;
        }
        if (!t1) {
          if (_0_12_isSet)
            t1 = _0_12;
          else {
            if (_0_8_isSet)
              t1 = _0_8;
            else {
              _0_8 = _0_1._string$_text;
              t1 = _0_8;
              _0_8_isSet = true;
            }
            _0_12 = "up" === t1;
            t1 = _0_12;
            _0_12_isSet = true;
          }
          if (!t1) {
            if (_0_14_isSet)
              t1 = _0_14;
            else {
              if (_0_8_isSet)
                t1 = _0_8;
              else {
                _0_8 = _0_1._string$_text;
                t1 = _0_8;
                _0_8_isSet = true;
              }
              _0_14 = "down" === t1;
              t1 = _0_14;
              _0_14_isSet = true;
            }
            if (!t1)
              if (_0_16_isSet)
                t1 = _0_16;
              else {
                if (_0_8_isSet)
                  t1 = _0_8;
                else {
                  _0_8 = _0_1._string$_text;
                  t1 = _0_8;
                  _0_8_isSet = true;
                }
                _0_16 = "to-zero" === t1;
                t1 = _0_16;
                _0_16_isSet = true;
              }
            else
              t1 = true;
          } else
            t1 = true;
        } else
          t1 = true;
        if (t1) {
          if (_0_4_isSet)
            t1 = _0_4;
          else {
            if (_0_2_isSet)
              t1 = _0_20;
            else {
              t1 = _0_2;
              _0_20 = t1;
              _0_2_isSet = true;
            }
            _0_4 = t1 == null;
            t1 = _0_4;
            _0_4_isSet = true;
          }
          if (t1)
            if (_0_6_isSet)
              t1 = _0_6;
            else {
              if (_0_5_isSet)
                t1 = _0_50;
              else {
                t1 = _0_5;
                _0_50 = t1;
                _0_5_isSet = true;
              }
              _0_6 = t1 == null;
              t1 = _0_6;
              _0_6_isSet = true;
            }
          else
            t1 = false;
        } else
          t1 = false;
      } else
        t1 = false;
      if (t1)
        throw A.wrapException(A.SassScriptException$(string$.Number, _null));
      if (_0_1 instanceof A.SassString) {
        if (_0_4_isSet)
          t1 = _0_4;
        else {
          if (_0_2_isSet)
            t1 = _0_20;
          else {
            t1 = _0_2;
            _0_20 = t1;
            _0_2_isSet = true;
          }
          _0_4 = t1 == null;
          t1 = _0_4;
          _0_4_isSet = true;
        }
        if (t1)
          if (_0_6_isSet)
            t1 = _0_6;
          else {
            if (_0_5_isSet)
              t1 = _0_50;
            else {
              t1 = _0_5;
              _0_50 = t1;
              _0_5_isSet = true;
            }
            _0_6 = t1 == null;
            t1 = _0_6;
            _0_6_isSet = true;
          }
        else
          t1 = false;
        rest = _0_1;
      } else {
        rest = _null;
        t1 = false;
      }
      if (t1)
        return new A.SassCalculation(_s5_, A._setArrayType([rest], type$.JSArray_Object));
      if (_0_4_isSet)
        t1 = _0_4;
      else {
        if (_0_2_isSet)
          t1 = _0_20;
        else {
          t1 = _0_2;
          _0_20 = t1;
          _0_2_isSet = true;
        }
        _0_4 = t1 == null;
        t1 = _0_4;
      }
      if (t1)
        if (_0_6_isSet)
          t1 = _0_6;
        else {
          if (_0_5_isSet)
            t1 = _0_50;
          else {
            t1 = _0_5;
            _0_50 = t1;
            _0_5_isSet = true;
          }
          _0_6 = t1 == null;
          t1 = _0_6;
          _0_6_isSet = true;
        }
      else
        t1 = false;
      if (t1)
        throw A.wrapException(A.SassScriptException$("Single argument " + A.S(_0_1) + " expected to be simplifiable.", _null));
      if (_0_2_isSet)
        t1 = _0_20;
      else {
        t1 = _0_2;
        _0_20 = t1;
        _0_2_isSet = true;
      }
      if (t1 != null) {
        if (_0_2_isSet)
          step = _0_20;
        else {
          step = _0_2;
          _0_20 = step;
          _0_2_isSet = true;
        }
        if (step == null)
          step = type$.Object._as(step);
        if (_0_6_isSet)
          t1 = _0_6;
        else {
          if (_0_5_isSet)
            t1 = _0_50;
          else {
            t1 = _0_5;
            _0_50 = t1;
            _0_5_isSet = true;
          }
          _0_6 = t1 == null;
          t1 = _0_6;
        }
      } else {
        step = _null;
        t1 = false;
      }
      if (t1)
        return new A.SassCalculation(_s5_, A._setArrayType([_0_1, step], type$.JSArray_Object));
      if (_0_1 instanceof A.SassString) {
        if (_0_10_isSet)
          t1 = _0_10;
        else {
          if (_0_8_isSet)
            t1 = _0_8;
          else {
            _0_8 = _0_1._string$_text;
            t1 = _0_8;
            _0_8_isSet = true;
          }
          _0_10 = "nearest" === t1;
          t1 = _0_10;
        }
        if (!t1) {
          if (_0_12_isSet)
            t1 = _0_12;
          else {
            if (_0_8_isSet)
              t1 = _0_8;
            else {
              _0_8 = _0_1._string$_text;
              t1 = _0_8;
              _0_8_isSet = true;
            }
            _0_12 = "up" === t1;
            t1 = _0_12;
          }
          if (!t1) {
            if (_0_14_isSet)
              t1 = _0_14;
            else {
              if (_0_8_isSet)
                t1 = _0_8;
              else {
                _0_8 = _0_1._string$_text;
                t1 = _0_8;
                _0_8_isSet = true;
              }
              _0_14 = "down" === t1;
              t1 = _0_14;
            }
            if (!t1)
              if (_0_16_isSet)
                t1 = _0_16;
              else {
                if (_0_8_isSet)
                  t1 = _0_8;
                else {
                  _0_8 = _0_1._string$_text;
                  t1 = _0_8;
                }
                _0_16 = "to-zero" === t1;
                t1 = _0_16;
              }
            else
              t1 = true;
          } else
            t1 = true;
        } else
          t1 = true;
      } else
        t1 = false;
      if (!t1)
        if (_0_1 instanceof A.SassString)
          t1 = _0_1.get$isVar();
        else
          t1 = false;
      else
        t1 = true;
      if (t1) {
        type$.SassString._as(_0_1);
        if (_0_2_isSet)
          t1 = _0_20;
        else {
          t1 = _0_2;
          _0_20 = t1;
          _0_2_isSet = true;
        }
        if (t1 != null) {
          if (_0_2_isSet)
            number = _0_20;
          else {
            number = _0_2;
            _0_20 = number;
            _0_2_isSet = true;
          }
          if (number == null)
            number = type$.Object._as(number);
          if (_0_5_isSet)
            t1 = _0_50;
          else {
            t1 = _0_5;
            _0_50 = t1;
            _0_5_isSet = true;
          }
          t1 = t1 != null;
          if (t1) {
            if (_0_5_isSet)
              step = _0_50;
            else {
              step = _0_5;
              _0_50 = step;
              _0_5_isSet = true;
            }
            if (step == null)
              step = type$.Object._as(step);
          } else
            step = _null;
        } else {
          step = _null;
          number = step;
          t1 = false;
        }
        strategy = _0_1;
      } else {
        step = _null;
        number = step;
        strategy = number;
        t1 = false;
      }
      if (t1)
        return new A.SassCalculation(_s5_, A._setArrayType([strategy, number, step], type$.JSArray_Object));
      if ((_0_2_isSet ? _0_20 : _0_2) != null)
        t1 = (_0_5_isSet ? _0_50 : _0_5) != null;
      else
        t1 = false;
      if (t1)
        throw A.wrapException(A.SassScriptException$(A.S(strategyOrNumber) + string$.x20must_b, _null));
      t1 = A.SassScriptException$("Invalid parameters.", _null);
      throw A.wrapException(t1);
    },
    SassCalculation_operateInternal(operator, left, right, inLegacySassFunction, simplify) {
      var t1;
      if (!simplify)
        return new A.CalculationOperation(operator, left, right);
      left = A.SassCalculation__simplify(left);
      right = A.SassCalculation__simplify(right);
      if (B.CalculationOperator_g2q === operator || B.CalculationOperator_CxF === operator) {
        if (left instanceof A.SassNumber)
          if (right instanceof A.SassNumber)
            t1 = inLegacySassFunction ? left.isComparableTo$1(right) : left.hasCompatibleUnits$1(right);
          else
            t1 = false;
        else
          t1 = false;
        if (t1)
          return operator === B.CalculationOperator_g2q ? left.plus$1(right) : left.minus$1(right);
        A.SassCalculation__verifyCompatibleNumbers(A._setArrayType([left, right], type$.JSArray_Object));
        if (right instanceof A.SassNumber) {
          t1 = right._number$_value;
          t1 = t1 < 0 && !A.fuzzyEquals(t1, 0);
        } else
          t1 = false;
        if (t1) {
          right = right.times$1(A.SassNumber_SassNumber(-1, null));
          operator = operator === B.CalculationOperator_g2q ? B.CalculationOperator_CxF : B.CalculationOperator_g2q;
        }
        return new A.CalculationOperation(operator, left, right);
      } else if (left instanceof A.SassNumber && right instanceof A.SassNumber)
        return operator === B.CalculationOperator_171 ? left.times$1(right) : left.dividedBy$1(right);
      else
        return new A.CalculationOperation(operator, left, right);
    },
    SassCalculation__roundWithStep(strategy, number, step) {
      var _0_2, t1, _0_6, _0_8_isSet, _0_8, _0_9_isSet, _0_9, _0_11, _0_13, stepWithNumberUnit, t2, _null = null;
      if (!A.LinkedHashSet_LinkedHashSet$_literal(["nearest", "up", "down", "to-zero"], type$.String).contains$1(0, strategy))
        throw A.wrapException(A.ArgumentError$(strategy + string$.x20must_b, _null));
      _0_2 = number._number$_value;
      if (_0_2 == 1 / 0 || _0_2 == -1 / 0) {
        t1 = step._number$_value;
        t1 = t1 == 1 / 0 || t1 == -1 / 0;
      } else
        t1 = false;
      if (!t1) {
        t1 = step._number$_value;
        t1 = t1 === 0 || isNaN(_0_2) || isNaN(t1);
      } else
        t1 = true;
      if (t1) {
        t1 = number.get$numeratorUnits(number);
        return A.SassNumber_SassNumber$withUnits(0 / 0, number.get$denominatorUnits(number), t1);
      }
      if (_0_2 == 1 / 0 || _0_2 == -1 / 0)
        return number;
      t1 = step._number$_value;
      if (t1 == 1 / 0 || t1 == -1 / 0) {
        $label0$0: {
          if (0 === _0_2) {
            t1 = number;
            break $label0$0;
          }
          _0_6 = "nearest" === strategy;
          t1 = _0_6;
          _0_8_isSet = !t1;
          if (_0_8_isSet) {
            _0_8 = "to-zero" === strategy;
            _0_9_isSet = _0_8;
          } else {
            _0_8 = _null;
            _0_9_isSet = true;
          }
          if (_0_9_isSet) {
            _0_9 = _0_2 > 0;
            t1 = _0_9;
          } else {
            _0_9 = _null;
            t1 = false;
          }
          if (t1) {
            t1 = number.get$numeratorUnits(number);
            t1 = A.SassNumber_SassNumber$withUnits(0, number.get$denominatorUnits(number), t1);
            break $label0$0;
          }
          if (!_0_6)
            if (_0_8_isSet)
              t1 = _0_8;
            else {
              _0_8 = "to-zero" === strategy;
              t1 = _0_8;
            }
          else
            t1 = true;
          if (t1) {
            t1 = number.get$numeratorUnits(number);
            t1 = A.SassNumber_SassNumber$withUnits(-0.0, number.get$denominatorUnits(number), t1);
            break $label0$0;
          }
          _0_11 = "up" === strategy;
          t1 = _0_11;
          if (t1)
            if (_0_9_isSet)
              t1 = _0_9;
            else {
              _0_9 = _0_2 > 0;
              t1 = _0_9;
            }
          else
            t1 = false;
          if (t1) {
            t1 = number.get$numeratorUnits(number);
            t1 = A.SassNumber_SassNumber$withUnits(1 / 0, number.get$denominatorUnits(number), t1);
            break $label0$0;
          }
          if (_0_11) {
            t1 = number.get$numeratorUnits(number);
            t1 = A.SassNumber_SassNumber$withUnits(-0.0, number.get$denominatorUnits(number), t1);
            break $label0$0;
          }
          _0_13 = "down" === strategy;
          t1 = _0_13;
          if (t1)
            t1 = _0_2 < 0;
          else
            t1 = false;
          if (t1) {
            t1 = number.get$numeratorUnits(number);
            t1 = A.SassNumber_SassNumber$withUnits(-1 / 0, number.get$denominatorUnits(number), t1);
            break $label0$0;
          }
          if (_0_13) {
            t1 = number.get$numeratorUnits(number);
            t1 = A.SassNumber_SassNumber$withUnits(0, number.get$denominatorUnits(number), t1);
            break $label0$0;
          }
          t1 = A.throwExpression(A.UnsupportedError$("Invalid argument: " + strategy + "."));
        }
        return t1;
      }
      stepWithNumberUnit = step.convertValueToMatch$1(number);
      $label1$1: {
        if ("nearest" === strategy) {
          t1 = B.JSNumber_methods.round$0(_0_2 / stepWithNumberUnit);
          t2 = number.get$numeratorUnits(number);
          t2 = A.SassNumber_SassNumber$withUnits(t1 * stepWithNumberUnit, number.get$denominatorUnits(number), t2);
          t1 = t2;
          break $label1$1;
        }
        if ("up" === strategy) {
          t2 = _0_2 / stepWithNumberUnit;
          t1 = t1 < 0 ? B.JSNumber_methods.floor$0(t2) : B.JSNumber_methods.ceil$0(t2);
          t2 = number.get$numeratorUnits(number);
          t2 = A.SassNumber_SassNumber$withUnits(t1 * stepWithNumberUnit, number.get$denominatorUnits(number), t2);
          t1 = t2;
          break $label1$1;
        }
        if ("down" === strategy) {
          t2 = _0_2 / stepWithNumberUnit;
          t1 = t1 < 0 ? B.JSNumber_methods.ceil$0(t2) : B.JSNumber_methods.floor$0(t2);
          t2 = number.get$numeratorUnits(number);
          t2 = A.SassNumber_SassNumber$withUnits(t1 * stepWithNumberUnit, number.get$denominatorUnits(number), t2);
          t1 = t2;
          break $label1$1;
        }
        if ("to-zero" === strategy) {
          t1 = _0_2 / stepWithNumberUnit;
          if (_0_2 < 0) {
            t1 = B.JSNumber_methods.ceil$0(t1);
            t2 = number.get$numeratorUnits(number);
            t2 = A.SassNumber_SassNumber$withUnits(t1 * stepWithNumberUnit, number.get$denominatorUnits(number), t2);
            t1 = t2;
          } else {
            t1 = B.JSNumber_methods.floor$0(t1);
            t2 = number.get$numeratorUnits(number);
            t2 = A.SassNumber_SassNumber$withUnits(t1 * stepWithNumberUnit, number.get$denominatorUnits(number), t2);
            t1 = t2;
          }
          break $label1$1;
        }
        t1 = number.get$numeratorUnits(number);
        t1 = A.SassNumber_SassNumber$withUnits(0 / 0, number.get$denominatorUnits(number), t1);
        break $label1$1;
      }
      return t1;
    },
    SassCalculation__simplify(arg) {
      var t1, _0_11_isSet, _0_11, _0_12, _0_15, _0_16_isSet, _0_16, text, _0_12_isSet, _0_15_isSet, value, _null = null,
        _s32_ = " can't be used in a calculation.";
      $label0$0: {
        if (arg instanceof A.SassNumber || arg instanceof A.CalculationOperation) {
          t1 = arg;
          break $label0$0;
        }
        t1 = arg instanceof A.SassString;
        if (t1 && !arg._hasQuotes) {
          t1 = arg;
          break $label0$0;
        }
        if (t1)
          A.throwExpression(A.SassScriptException$("Quoted string " + arg.toString$0(0) + _s32_, _null));
        _0_11_isSet = arg instanceof A.SassCalculation;
        if (_0_11_isSet) {
          _0_11 = "calc" === arg.name;
          if (_0_11) {
            _0_12 = arg.$arguments;
            _0_15 = _0_12.length === 1;
            _0_16_isSet = _0_15;
            if (_0_16_isSet) {
              _0_16 = _0_12[0];
              t1 = _0_16;
              if (t1 instanceof A.SassString) {
                type$.SassString._as(_0_16);
                if (!_0_16._hasQuotes) {
                  text = _0_16._string$_text;
                  t1 = A.SassCalculation__needsParentheses(text);
                } else {
                  text = _null;
                  t1 = false;
                }
              } else {
                text = _null;
                t1 = false;
              }
            } else {
              text = _null;
              _0_16 = text;
              t1 = false;
            }
          } else {
            text = _null;
            _0_16 = text;
            _0_12 = _0_16;
            _0_15 = _0_12;
            _0_16_isSet = false;
            t1 = false;
          }
          _0_12_isSet = _0_11;
          _0_15_isSet = _0_12_isSet;
        } else {
          text = _null;
          _0_16 = text;
          _0_12 = _0_16;
          _0_15 = _0_12;
          _0_11 = _0_15;
          _0_15_isSet = false;
          _0_12_isSet = false;
          _0_16_isSet = false;
          t1 = false;
        }
        if (t1) {
          t1 = new A.SassString("(" + A.S(text) + ")", false);
          break $label0$0;
        }
        if (_0_11_isSet)
          if (_0_11)
            if (_0_15_isSet)
              t1 = _0_15;
            else {
              if (_0_12_isSet)
                t1 = _0_12;
              else {
                _0_12 = arg.$arguments;
                t1 = _0_12;
                _0_12_isSet = true;
              }
              _0_15 = t1.length === 1;
              t1 = _0_15;
            }
          else
            t1 = false;
        else
          t1 = false;
        if (t1) {
          if (_0_16_isSet)
            value = _0_16;
          else {
            _0_16 = (_0_12_isSet ? _0_12 : arg.$arguments)[0];
            value = _0_16;
          }
          t1 = value;
          break $label0$0;
        }
        if (_0_11_isSet) {
          t1 = arg;
          break $label0$0;
        }
        if (arg instanceof A.Value)
          A.throwExpression(A.SassScriptException$("Value " + arg.toString$0(0) + _s32_, _null));
        t1 = A.throwExpression(A.ArgumentError$("Unexpected calculation argument " + A.S(arg) + ".", _null));
      }
      return t1;
    },
    SassCalculation__needsParentheses(text) {
      var t1, couldBeVar, second, third, fourth, i, t2,
        first = text.charCodeAt(0);
      if (first === 32 || first === 9 || first === 10 || first === 13 || first === 12 || first === 47 || first === 42)
        return true;
      t1 = text.length;
      couldBeVar = t1 >= 4 && A.characterEqualsIgnoreCase(first, 118);
      if (t1 < 2)
        return false;
      second = text.charCodeAt(1);
      if (second === 32 || second === 9 || second === 10 || second === 13 || second === 12 || second === 47 || second === 42)
        return true;
      couldBeVar = couldBeVar && A.characterEqualsIgnoreCase(second, 97);
      if (t1 < 3)
        return false;
      third = text.charCodeAt(2);
      if (third === 32 || third === 9 || third === 10 || third === 13 || third === 12 || third === 47 || third === 42)
        return true;
      couldBeVar = couldBeVar && A.characterEqualsIgnoreCase(third, 114);
      if (t1 < 4)
        return false;
      fourth = text.charCodeAt(3);
      if (couldBeVar && fourth === 40)
        return true;
      if (fourth === 32 || fourth === 9 || fourth === 10 || fourth === 13 || fourth === 12 || fourth === 47 || fourth === 42)
        return true;
      for (i = 4; i < t1; ++i) {
        t2 = text.charCodeAt(i);
        if (t2 === 32 || t2 === 9 || t2 === 10 || t2 === 13 || t2 === 12 || t2 === 47 || t2 === 42)
          return true;
      }
      return false;
    },
    SassCalculation__verifyCompatibleNumbers(args) {
      var t1, _i, t2, arg, i, number1, j, number2;
      for (t1 = args.length, _i = 0; t2 = args.length, _i < t2; args.length === t1 || (0, A.throwConcurrentModificationError)(args), ++_i) {
        arg = args[_i];
        if (arg instanceof A.SassNumber && arg.get$hasComplexUnits())
          throw A.wrapException(A.SassScriptException$("Number " + A.S(arg) + " isn't compatible with CSS calculations.", null));
      }
      for (t1 = t2, i = 0; i < t1 - 1; ++i) {
        number1 = args[i];
        if (!(number1 instanceof A.SassNumber))
          continue;
        for (j = i + 1; t1 = args.length, j < t1; ++j) {
          number2 = args[j];
          if (!(number2 instanceof A.SassNumber))
            continue;
          if (number1.hasPossiblyCompatibleUnits$1(number2))
            continue;
          throw A.wrapException(A.SassScriptException$(number1.toString$0(0) + " and " + number2.toString$0(0) + " are incompatible.", null));
        }
      }
    },
    SassCalculation__verifyLength(args, expectedLength) {
      var t1;
      if (args.length === expectedLength)
        return;
      if (B.JSArray_methods.any$1(args, new A.SassCalculation__verifyLength_closure()))
        return;
      t1 = args.length;
      throw A.wrapException(A.SassScriptException$("" + expectedLength + " arguments required, but only " + t1 + " " + A.pluralize("was", t1, "were") + " passed.", null));
    },
    SassCalculation__singleArgument($name, argument, mathFunc, forbidUnits) {
      argument = A.SassCalculation__simplify(argument);
      if (!(argument instanceof A.SassNumber))
        return new A.SassCalculation($name, A._setArrayType([argument], type$.JSArray_Object));
      if (forbidUnits)
        argument.assertNoUnits$0();
      return mathFunc.call$1(argument);
    },
    SassCalculation: function SassCalculation(t0, t1) {
      this.name = t0;
      this.$arguments = t1;
    },
    SassCalculation__verifyLength_closure: function SassCalculation__verifyLength_closure() {
    },
    CalculationOperation: function CalculationOperation(t0, t1, t2) {
      this._operator = t0;
      this._left = t1;
      this._right = t2;
    },
    CalculationOperator: function CalculationOperator(t0, t1, t2, t3) {
      var _ = this;
      _.name = t0;
      _.operator = t1;
      _.precedence = t2;
      _._name = t3;
    },
    SassColor$rgb(red, green, blue, alpha) {
      var _null = null,
        t1 = new A.SassColor(red, green, blue, _null, _null, _null, A.fuzzyAssertRange(A.SassColor__handleNullAlpha(alpha), 0, 1, "alpha"), _null);
      A.RangeError_checkValueInInterval(t1.get$red(0), 0, 255, "red");
      A.RangeError_checkValueInInterval(t1.get$green(0), 0, 255, "green");
      A.RangeError_checkValueInInterval(t1.get$blue(0), 0, 255, "blue");
      return t1;
    },
    SassColor$rgbInternal(_red, _green, _blue, alpha, format) {
      var t1 = new A.SassColor(_red, _green, _blue, null, null, null, A.fuzzyAssertRange(alpha, 0, 1, "alpha"), format);
      A.RangeError_checkValueInInterval(t1.get$red(0), 0, 255, "red");
      A.RangeError_checkValueInInterval(t1.get$green(0), 0, 255, "green");
      A.RangeError_checkValueInInterval(t1.get$blue(0), 0, 255, "blue");
      return t1;
    },
    SassColor$hslInternal(hue, saturation, lightness, alpha, format) {
      return new A.SassColor(null, null, null, B.JSNumber_methods.$mod(hue, 360), A.fuzzyAssertRange(saturation, 0, 100, "saturation"), A.fuzzyAssertRange(lightness, 0, 100, "lightness"), A.fuzzyAssertRange(alpha, 0, 1, "alpha"), format);
    },
    SassColor_SassColor$hwb(hue, whiteness, blackness, alpha) {
      var t2, t1 = {},
        scaledHue = B.JSNumber_methods.$mod(hue, 360) / 360,
        scaledWhiteness = t1.scaledWhiteness = A.fuzzyAssertRange(whiteness, 0, 100, "whiteness") / 100,
        scaledBlackness = A.fuzzyAssertRange(blackness, 0, 100, "blackness") / 100,
        sum = scaledWhiteness + scaledBlackness;
      if (sum > 1) {
        t2 = t1.scaledWhiteness = scaledWhiteness / sum;
        scaledBlackness /= sum;
      } else
        t2 = scaledWhiteness;
      t2 = new A.SassColor_SassColor$hwb_toRgb(t1, 1 - t2 - scaledBlackness);
      return A.SassColor$rgb(t2.call$1(scaledHue + 0.3333333333333333), t2.call$1(scaledHue), t2.call$1(scaledHue - 0.3333333333333333), alpha);
    },
    SassColor__handleNullAlpha(alpha) {
      return alpha;
    },
    SassColor__hueToRgb(m1, m2, hue) {
      var t1;
      if (hue < 0)
        ++hue;
      if (hue > 1)
        --hue;
      $label0$0: {
        if (hue < 0.16666666666666666) {
          t1 = m1 + (m2 - m1) * hue * 6;
          break $label0$0;
        }
        if (hue < 0.5) {
          t1 = m2;
          break $label0$0;
        }
        if (hue < 0.6666666666666666) {
          t1 = m1 + (m2 - m1) * (0.6666666666666666 - hue) * 6;
          break $label0$0;
        }
        t1 = m1;
        break $label0$0;
      }
      return t1;
    },
    SassColor: function SassColor(t0, t1, t2, t3, t4, t5, t6, t7) {
      var _ = this;
      _._red = t0;
      _._green = t1;
      _._blue = t2;
      _._hue = t3;
      _._saturation = t4;
      _._lightness = t5;
      _._alpha = t6;
      _.format = t7;
    },
    SassColor_SassColor$hwb_toRgb: function SassColor_SassColor$hwb_toRgb(t0, t1) {
      this._box_0 = t0;
      this.factor = t1;
    },
    _ColorFormatEnum: function _ColorFormatEnum(t0) {
      this._color$_name = t0;
    },
    SpanColorFormat: function SpanColorFormat(t0) {
      this._color$_span = t0;
    },
    SassFunction: function SassFunction(t0) {
      this.callable = t0;
    },
    SassList$(contents, _separator, brackets) {
      var t1 = new A.SassList(A.List_List$unmodifiable(contents, type$.Value), _separator, brackets);
      t1.SassList$3$brackets(contents, _separator, brackets);
      return t1;
    },
    SassList: function SassList(t0, t1, t2) {
      this._list$_contents = t0;
      this._separator = t1;
      this._hasBrackets = t2;
    },
    SassList_isBlank_closure: function SassList_isBlank_closure() {
    },
    ListSeparator: function ListSeparator(t0, t1, t2) {
      this._list$_name = t0;
      this.separator = t1;
      this._name = t2;
    },
    SassMap: function SassMap(t0) {
      this._map$_contents = t0;
    },
    SassMixin: function SassMixin(t0) {
      this.callable = t0;
    },
    _SassNull: function _SassNull() {
    },
    conversionFactor(unit1, unit2) {
      var _0_0;
      if (unit1 === unit2)
        return 1;
      _0_0 = B.Map_gQqJO.$index(0, unit1);
      if (_0_0 != null)
        return _0_0.$index(0, unit2);
      return null;
    },
    SassNumber_SassNumber(value, unit) {
      return unit == null ? new A.UnitlessSassNumber(value, null) : new A.SingleUnitSassNumber(unit, value, null);
    },
    SassNumber_SassNumber$withUnits(value, denominatorUnits, numeratorUnits) {
      var _0_4, t1, _0_6, _0_8_isSet, _0_8, _0_10_isSet, _0_10, _0_7, t2, _0_4_isSet, unit, _0_7_isSet, numerators, t3, denominators, unsimplifiedDenominators, valueDouble, _i, denominator, simplifiedAway, i, factor, _1_2, _1_7_isSet, _1_7, _null = null,
        _0_6_isSet = !false;
      if (_0_6_isSet) {
        _0_4 = (numeratorUnits === null ? type$.List_String._as(numeratorUnits) : numeratorUnits).length;
        t1 = _0_4;
        _0_6 = t1 <= 0;
        _0_8_isSet = _0_6;
      } else {
        _0_4 = _null;
        _0_6 = _0_4;
        _0_8_isSet = true;
      }
      if (_0_8_isSet) {
        _0_8 = denominatorUnits == null;
        t1 = _0_8;
        _0_10_isSet = !t1;
        if (_0_10_isSet) {
          _0_10 = (denominatorUnits == null ? type$.List_String._as(denominatorUnits) : denominatorUnits).length <= 0;
          t1 = _0_10;
        } else {
          _0_10 = _null;
          t1 = true;
        }
        _0_7 = denominatorUnits;
      } else {
        _0_10 = _null;
        _0_7 = _0_10;
        _0_8 = _0_7;
        _0_10_isSet = false;
        t1 = false;
      }
      if (t1)
        return new A.UnitlessSassNumber(value, _null);
      t1 = type$.List_String;
      if (t1._is(numeratorUnits)) {
        if (_0_6_isSet) {
          t2 = _0_4;
          _0_4_isSet = _0_6_isSet;
        } else {
          _0_4 = numeratorUnits.length;
          t2 = _0_4;
          _0_4_isSet = true;
        }
        if (t2 === 1) {
          unit = numeratorUnits[0];
          if (_0_8_isSet) {
            t2 = _0_8;
            _0_7_isSet = _0_8_isSet;
          } else {
            _0_8 = denominatorUnits == null;
            t2 = _0_8;
            _0_7 = denominatorUnits;
            _0_8_isSet = true;
            _0_7_isSet = true;
          }
          if (!t2)
            if (_0_10_isSet)
              t2 = _0_10;
            else {
              if (_0_7_isSet)
                t2 = _0_7;
              else {
                t2 = denominatorUnits;
                _0_7 = t2;
                _0_7_isSet = true;
              }
              _0_10 = (t2 == null ? t1._as(t2) : t2).length <= 0;
              t2 = _0_10;
              _0_10_isSet = true;
            }
          else
            t2 = true;
        } else {
          unit = _null;
          _0_7_isSet = _0_8_isSet;
          t2 = false;
        }
      } else {
        unit = _null;
        _0_7_isSet = _0_8_isSet;
        _0_4_isSet = _0_6_isSet;
        t2 = false;
      }
      if (t2)
        return new A.SingleUnitSassNumber(unit, value, _null);
      t2 = numeratorUnits === null;
      if (!t2) {
        numerators = numeratorUnits;
        if (_0_8_isSet)
          t3 = _0_8;
        else {
          if (_0_7_isSet)
            t3 = _0_7;
          else {
            t3 = denominatorUnits;
            _0_7 = t3;
            _0_7_isSet = true;
          }
          _0_8 = t3 == null;
          t3 = _0_8;
        }
        if (!t3)
          if (_0_10_isSet)
            t3 = _0_10;
          else {
            if (_0_7_isSet)
              t3 = _0_7;
            else {
              t3 = denominatorUnits;
              _0_7 = t3;
              _0_7_isSet = true;
            }
            _0_10 = (t3 == null ? t1._as(t3) : t3).length <= 0;
            t3 = _0_10;
          }
        else
          t3 = true;
      } else {
        numerators = _null;
        t3 = false;
      }
      if (t3)
        return new A.ComplexSassNumber(A.List_List$unmodifiable(numerators, type$.String), B.List_empty, value, _null);
      if (!false)
        if (_0_6_isSet)
          t2 = _0_6;
        else {
          if (_0_4_isSet)
            t2 = _0_4;
          else {
            _0_4 = (t2 ? t1._as(numeratorUnits) : numeratorUnits).length;
            t2 = _0_4;
          }
          _0_6 = t2 <= 0;
          t2 = _0_6;
        }
      else
        t2 = true;
      if (t2) {
        if (_0_7_isSet)
          t2 = _0_7;
        else {
          t2 = denominatorUnits;
          _0_7 = t2;
          _0_7_isSet = true;
        }
        t2 = t2 != null;
        if (t2) {
          denominators = _0_7_isSet ? _0_7 : denominatorUnits;
          if (denominators == null)
            denominators = t1._as(denominators);
        } else
          denominators = _null;
        t1 = t2;
      } else {
        denominators = _null;
        t1 = false;
      }
      if (t1)
        return new A.ComplexSassNumber(B.List_empty, A.List_List$unmodifiable(denominators, type$.String), value, _null);
      numerators = A._setArrayType(numeratorUnits.slice(0), A._arrayInstanceType(numeratorUnits));
      unsimplifiedDenominators = A._setArrayType(denominatorUnits.slice(0), A.instanceType(denominatorUnits));
      denominators = A._setArrayType([], type$.JSArray_String);
      for (t1 = unsimplifiedDenominators.length, valueDouble = value, _i = 0; _i < unsimplifiedDenominators.length; unsimplifiedDenominators.length === t1 || (0, A.throwConcurrentModificationError)(unsimplifiedDenominators), ++_i) {
        denominator = unsimplifiedDenominators[_i];
        i = 0;
        while (true) {
          if (!(i < numerators.length)) {
            simplifiedAway = false;
            break;
          }
          c$0: {
            factor = A.conversionFactor(denominator, numerators[i]);
            if (factor == null)
              break c$0;
            valueDouble *= factor;
            B.JSArray_methods.removeAt$1(numerators, i);
            simplifiedAway = true;
            break;
          }
          ++i;
        }
        if (!simplifiedAway)
          denominators.push(denominator);
      }
      $label0$1: {
        _1_2 = numerators.length;
        t1 = _1_2;
        _1_7_isSet = t1 <= 0;
        if (_1_7_isSet) {
          _1_7 = denominators.length <= 0;
          t1 = _1_7;
        } else {
          _1_7 = _null;
          t1 = false;
        }
        if (t1) {
          t1 = new A.UnitlessSassNumber(valueDouble, _null);
          break $label0$1;
        }
        if (_1_2 === 1) {
          unit = numerators[0];
          t1 = _1_7_isSet ? _1_7 : denominators.length <= 0;
        } else {
          unit = _null;
          t1 = false;
        }
        if (t1) {
          t1 = new A.SingleUnitSassNumber(unit, valueDouble, _null);
          break $label0$1;
        }
        t1 = type$.String;
        t1 = new A.ComplexSassNumber(A.List_List$unmodifiable(numerators, t1), A.List_List$unmodifiable(denominators, t1), valueDouble, _null);
        break $label0$1;
      }
      return t1;
    },
    SassNumber: function SassNumber() {
    },
    SassNumber__coerceOrConvertValue_compatibilityException: function SassNumber__coerceOrConvertValue_compatibilityException(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.other = t1;
      _.otherName = t2;
      _.otherHasUnits = t3;
      _.name = t4;
      _.newNumerators = t5;
      _.newDenominators = t6;
    },
    SassNumber__coerceOrConvertValue_closure: function SassNumber__coerceOrConvertValue_closure(t0, t1) {
      this._box_0 = t0;
      this.newNumerator = t1;
    },
    SassNumber__coerceOrConvertValue_closure0: function SassNumber__coerceOrConvertValue_closure0(t0) {
      this.compatibilityException = t0;
    },
    SassNumber__coerceOrConvertValue_closure1: function SassNumber__coerceOrConvertValue_closure1(t0, t1) {
      this._box_0 = t0;
      this.newDenominator = t1;
    },
    SassNumber__coerceOrConvertValue_closure2: function SassNumber__coerceOrConvertValue_closure2(t0) {
      this.compatibilityException = t0;
    },
    SassNumber_plus_closure: function SassNumber_plus_closure() {
    },
    SassNumber_minus_closure: function SassNumber_minus_closure() {
    },
    SassNumber_multiplyUnits_closure: function SassNumber_multiplyUnits_closure(t0, t1) {
      this._box_0 = t0;
      this.numerator = t1;
    },
    SassNumber_multiplyUnits_closure0: function SassNumber_multiplyUnits_closure0(t0, t1) {
      this.newNumerators = t0;
      this.numerator = t1;
    },
    SassNumber_multiplyUnits_closure1: function SassNumber_multiplyUnits_closure1(t0, t1) {
      this._box_0 = t0;
      this.numerator = t1;
    },
    SassNumber_multiplyUnits_closure2: function SassNumber_multiplyUnits_closure2(t0, t1) {
      this.newNumerators = t0;
      this.numerator = t1;
    },
    SassNumber__areAnyConvertible_closure: function SassNumber__areAnyConvertible_closure(t0) {
      this.units2 = t0;
    },
    SassNumber__canonicalizeUnitList_closure: function SassNumber__canonicalizeUnitList_closure() {
    },
    SassNumber__canonicalMultiplier_closure: function SassNumber__canonicalMultiplier_closure(t0) {
      this.$this = t0;
    },
    SassNumber_unitSuggestion_closure: function SassNumber_unitSuggestion_closure() {
    },
    SassNumber_unitSuggestion_closure0: function SassNumber_unitSuggestion_closure0() {
    },
    ComplexSassNumber: function ComplexSassNumber(t0, t1, t2, t3) {
      var _ = this;
      _._numeratorUnits = t0;
      _._denominatorUnits = t1;
      _._number$_value = t2;
      _.hashCache = null;
      _.asSlash = t3;
    },
    SingleUnitSassNumber: function SingleUnitSassNumber(t0, t1, t2) {
      var _ = this;
      _._unit = t0;
      _._number$_value = t1;
      _.hashCache = null;
      _.asSlash = t2;
    },
    SingleUnitSassNumber__coerceToUnit_closure: function SingleUnitSassNumber__coerceToUnit_closure(t0, t1) {
      this.$this = t0;
      this.unit = t1;
    },
    SingleUnitSassNumber__coerceValueToUnit_closure: function SingleUnitSassNumber__coerceValueToUnit_closure(t0) {
      this.$this = t0;
    },
    SingleUnitSassNumber_multiplyUnits_closure: function SingleUnitSassNumber_multiplyUnits_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    SingleUnitSassNumber_multiplyUnits_closure0: function SingleUnitSassNumber_multiplyUnits_closure0(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    UnitlessSassNumber: function UnitlessSassNumber(t0, t1) {
      this._number$_value = t0;
      this.hashCache = null;
      this.asSlash = t1;
    },
    SassString$(_text, quotes) {
      return new A.SassString(_text, quotes);
    },
    SassString: function SassString(t0, t1) {
      var _ = this;
      _._string$_text = t0;
      _._hasQuotes = t1;
      _.__SassString__sassLength_FI = $;
      _._hashCache = null;
    },
    AnySelectorVisitor: function AnySelectorVisitor() {
    },
    AnySelectorVisitor_visitComplexSelector_closure: function AnySelectorVisitor_visitComplexSelector_closure(t0) {
      this.$this = t0;
    },
    AnySelectorVisitor_visitCompoundSelector_closure: function AnySelectorVisitor_visitCompoundSelector_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor$0(functions, importCache, logger, nodeImporter, quietDeps, sourceMap) {
      var t1 = type$.Uri,
        t2 = type$.Module_AsyncCallable,
        t3 = A._setArrayType([], type$.JSArray_Record_2_String_and_AstNode);
      t1 = new A._EvaluateVisitor0(importCache, nodeImporter, A.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.AsyncCallable), A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Configuration), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.AstNode), logger, A.LinkedHashSet_LinkedHashSet$_empty(type$.Record_2_String_and_SourceSpan), quietDeps, sourceMap, A.AsyncEnvironment$(), A.LinkedHashSet_LinkedHashSet$_empty(t1), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.nullable_AstNode), t3, B.Configuration_Map_empty_null);
      t1._EvaluateVisitor$6$functions$importCache$logger$nodeImporter$quietDeps$sourceMap0(functions, importCache, logger, nodeImporter, quietDeps, sourceMap);
      return t1;
    },
    _EvaluateVisitor0: function _EvaluateVisitor0(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15) {
      var _ = this;
      _._async_evaluate$_importCache = t0;
      _._async_evaluate$_nodeImporter = t1;
      _._async_evaluate$_builtInFunctions = t2;
      _._async_evaluate$_builtInModules = t3;
      _._async_evaluate$_modules = t4;
      _._async_evaluate$_moduleConfigurations = t5;
      _._async_evaluate$_moduleNodes = t6;
      _._async_evaluate$_logger = t7;
      _._async_evaluate$_warningsEmitted = t8;
      _._async_evaluate$_quietDeps = t9;
      _._async_evaluate$_sourceMap = t10;
      _._async_evaluate$_environment = t11;
      _._async_evaluate$_declarationName = _._async_evaluate$__parent = _._async_evaluate$_mediaQuerySources = _._async_evaluate$_mediaQueries = _._async_evaluate$_styleRuleIgnoringAtRoot = null;
      _._async_evaluate$_member = "root stylesheet";
      _._async_evaluate$_importSpan = _._async_evaluate$_callableNode = _._async_evaluate$_currentCallable = null;
      _._async_evaluate$_inSupportsDeclaration = _._async_evaluate$_inKeyframes = _._async_evaluate$_atRootExcludingStyleRule = _._async_evaluate$_inUnknownAtRule = _._async_evaluate$_inFunction = false;
      _._async_evaluate$_loadedUrls = t12;
      _._async_evaluate$_activeModules = t13;
      _._async_evaluate$_stack = t14;
      _._async_evaluate$_importer = null;
      _._async_evaluate$_inDependency = false;
      _._async_evaluate$__extensionStore = _._async_evaluate$_preModuleComments = _._async_evaluate$_outOfOrderImports = _._async_evaluate$__endOfImports = _._async_evaluate$__root = _._async_evaluate$__stylesheet = null;
      _._async_evaluate$_configuration = t15;
    },
    _EvaluateVisitor_closure12: function _EvaluateVisitor_closure12(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure13: function _EvaluateVisitor_closure13(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure14: function _EvaluateVisitor_closure14(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure15: function _EvaluateVisitor_closure15(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure16: function _EvaluateVisitor_closure16(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure17: function _EvaluateVisitor_closure17(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure18: function _EvaluateVisitor_closure18(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure19: function _EvaluateVisitor_closure19(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure20: function _EvaluateVisitor_closure20(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure6: function _EvaluateVisitor__closure6(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.module = t2;
    },
    _EvaluateVisitor_closure21: function _EvaluateVisitor_closure21(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure5: function _EvaluateVisitor__closure5(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.module = t2;
    },
    _EvaluateVisitor_closure22: function _EvaluateVisitor_closure22(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure23: function _EvaluateVisitor_closure23(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure3: function _EvaluateVisitor__closure3(t0, t1, t2) {
      this.values = t0;
      this.span = t1;
      this.callableNode = t2;
    },
    _EvaluateVisitor__closure4: function _EvaluateVisitor__closure4(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure24: function _EvaluateVisitor_closure24(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_run_closure0: function _EvaluateVisitor_run_closure0(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.importer = t2;
    },
    _EvaluateVisitor_run__closure0: function _EvaluateVisitor_run__closure0(t0, t1, t2) {
      this.$this = t0;
      this.importer = t1;
      this.node = t2;
    },
    _EvaluateVisitor__loadModule_closure1: function _EvaluateVisitor__loadModule_closure1(t0, t1) {
      this._box_1 = t0;
      this.callback = t1;
    },
    _EvaluateVisitor__loadModule_closure2: function _EvaluateVisitor__loadModule_closure2(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.nodeWithSpan = t2;
      _.baseUrl = t3;
      _.namesInErrors = t4;
      _.configuration = t5;
      _.callback = t6;
    },
    _EvaluateVisitor__loadModule__closure1: function _EvaluateVisitor__loadModule__closure1(t0, t1) {
      this.$this = t0;
      this.message = t1;
    },
    _EvaluateVisitor__loadModule__closure2: function _EvaluateVisitor__loadModule__closure2(t0, t1, t2) {
      this._box_0 = t0;
      this.callback = t1;
      this.firstLoad = t2;
    },
    _EvaluateVisitor__execute_closure0: function _EvaluateVisitor__execute_closure0(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.stylesheet = t2;
      _.extensionStore = t3;
      _.configuration = t4;
      _.css = t5;
      _.preModuleComments = t6;
    },
    _EvaluateVisitor__combineCss_closure1: function _EvaluateVisitor__combineCss_closure1() {
    },
    _EvaluateVisitor__combineCss_closure2: function _EvaluateVisitor__combineCss_closure2(t0) {
      this.selectors = t0;
    },
    _EvaluateVisitor__combineCss_visitModule0: function _EvaluateVisitor__combineCss_visitModule0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.seen = t1;
      _.clone = t2;
      _.css = t3;
      _.imports = t4;
      _.sorted = t5;
    },
    _EvaluateVisitor__extendModules_closure1: function _EvaluateVisitor__extendModules_closure1(t0) {
      this.originalSelectors = t0;
    },
    _EvaluateVisitor__extendModules_closure2: function _EvaluateVisitor__extendModules_closure2() {
    },
    _EvaluateVisitor_visitAtRootRule_closure1: function _EvaluateVisitor_visitAtRootRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure2: function _EvaluateVisitor_visitAtRootRule_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure5: function _EvaluateVisitor__scopeForAtRoot_closure5(t0, t1, t2) {
      this.$this = t0;
      this.newParent = t1;
      this.node = t2;
    },
    _EvaluateVisitor__scopeForAtRoot_closure6: function _EvaluateVisitor__scopeForAtRoot_closure6(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure7: function _EvaluateVisitor__scopeForAtRoot_closure7(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot__closure0: function _EvaluateVisitor__scopeForAtRoot__closure0(t0, t1) {
      this.innerScope = t0;
      this.callback = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure8: function _EvaluateVisitor__scopeForAtRoot_closure8(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure9: function _EvaluateVisitor__scopeForAtRoot_closure9() {
    },
    _EvaluateVisitor__scopeForAtRoot_closure10: function _EvaluateVisitor__scopeForAtRoot_closure10(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor_visitContentRule_closure0: function _EvaluateVisitor_visitContentRule_closure0(t0, t1) {
      this.$this = t0;
      this.content = t1;
    },
    _EvaluateVisitor_visitDeclaration_closure0: function _EvaluateVisitor_visitDeclaration_closure0(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitEachRule_closure2: function _EvaluateVisitor_visitEachRule_closure2(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure3: function _EvaluateVisitor_visitEachRule_closure3(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure4: function _EvaluateVisitor_visitEachRule_closure4(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.list = t1;
      _.setVariables = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitEachRule__closure0: function _EvaluateVisitor_visitEachRule__closure0(t0, t1, t2) {
      this.$this = t0;
      this.setVariables = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitEachRule___closure0: function _EvaluateVisitor_visitEachRule___closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitAtRule_closure2: function _EvaluateVisitor_visitAtRule_closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitAtRule_closure3: function _EvaluateVisitor_visitAtRule_closure3(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.children = t2;
    },
    _EvaluateVisitor_visitAtRule__closure0: function _EvaluateVisitor_visitAtRule__closure0(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitAtRule_closure4: function _EvaluateVisitor_visitAtRule_closure4() {
    },
    _EvaluateVisitor_visitForRule_closure4: function _EvaluateVisitor_visitForRule_closure4(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure5: function _EvaluateVisitor_visitForRule_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure6: function _EvaluateVisitor_visitForRule_closure6(t0) {
      this.fromNumber = t0;
    },
    _EvaluateVisitor_visitForRule_closure7: function _EvaluateVisitor_visitForRule_closure7(t0, t1) {
      this.toNumber = t0;
      this.fromNumber = t1;
    },
    _EvaluateVisitor_visitForRule_closure8: function _EvaluateVisitor_visitForRule_closure8(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.node = t2;
      _.from = t3;
      _.direction = t4;
      _.fromNumber = t5;
    },
    _EvaluateVisitor_visitForRule__closure0: function _EvaluateVisitor_visitForRule__closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitForwardRule_closure1: function _EvaluateVisitor_visitForwardRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForwardRule_closure2: function _EvaluateVisitor_visitForwardRule_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__registerCommentsForModule_closure0: function _EvaluateVisitor__registerCommentsForModule_closure0() {
    },
    _EvaluateVisitor_visitIfRule_closure0: function _EvaluateVisitor_visitIfRule_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIfRule__closure0: function _EvaluateVisitor_visitIfRule__closure0(t0, t1) {
      this.$this = t0;
      this.clause = t1;
    },
    _EvaluateVisitor_visitIfRule___closure0: function _EvaluateVisitor_visitIfRule___closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport_closure0: function _EvaluateVisitor__visitDynamicImport_closure0(t0, t1) {
      this.$this = t0;
      this.$import = t1;
    },
    _EvaluateVisitor__visitDynamicImport__closure3: function _EvaluateVisitor__visitDynamicImport__closure3(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport__closure4: function _EvaluateVisitor__visitDynamicImport__closure4() {
    },
    _EvaluateVisitor__visitDynamicImport__closure5: function _EvaluateVisitor__visitDynamicImport__closure5() {
    },
    _EvaluateVisitor__visitDynamicImport__closure6: function _EvaluateVisitor__visitDynamicImport__closure6(t0, t1, t2, t3, t4) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.loadsUserDefinedModules = t2;
      _.environment = t3;
      _.children = t4;
    },
    _EvaluateVisitor__applyMixin_closure1: function _EvaluateVisitor__applyMixin_closure1(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.$arguments = t1;
      _.mixin = t2;
      _.nodeWithSpanWithoutContent = t3;
    },
    _EvaluateVisitor__applyMixin__closure2: function _EvaluateVisitor__applyMixin__closure2(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.$arguments = t1;
      _.mixin = t2;
      _.nodeWithSpanWithoutContent = t3;
    },
    _EvaluateVisitor__applyMixin_closure2: function _EvaluateVisitor__applyMixin_closure2(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.contentCallable = t1;
      _.mixin = t2;
      _.nodeWithSpanWithoutContent = t3;
    },
    _EvaluateVisitor__applyMixin__closure1: function _EvaluateVisitor__applyMixin__closure1(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpanWithoutContent = t2;
    },
    _EvaluateVisitor__applyMixin___closure0: function _EvaluateVisitor__applyMixin___closure0(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpanWithoutContent = t2;
    },
    _EvaluateVisitor__applyMixin____closure0: function _EvaluateVisitor__applyMixin____closure0(t0, t1) {
      this.$this = t0;
      this.statement = t1;
    },
    _EvaluateVisitor_visitIncludeRule_closure2: function _EvaluateVisitor_visitIncludeRule_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitIncludeRule_closure3: function _EvaluateVisitor_visitIncludeRule_closure3(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure4: function _EvaluateVisitor_visitIncludeRule_closure4(t0) {
      this.node = t0;
    },
    _EvaluateVisitor_visitMediaRule_closure2: function _EvaluateVisitor_visitMediaRule_closure2(t0, t1) {
      this.$this = t0;
      this.queries = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure3: function _EvaluateVisitor_visitMediaRule_closure3(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.mergedQueries = t1;
      _.queries = t2;
      _.mergedSources = t3;
      _.node = t4;
    },
    _EvaluateVisitor_visitMediaRule__closure0: function _EvaluateVisitor_visitMediaRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule___closure0: function _EvaluateVisitor_visitMediaRule___closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure4: function _EvaluateVisitor_visitMediaRule_closure4(t0) {
      this.mergedSources = t0;
    },
    _EvaluateVisitor_visitStyleRule_closure4: function _EvaluateVisitor_visitStyleRule_closure4(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure5: function _EvaluateVisitor_visitStyleRule_closure5() {
    },
    _EvaluateVisitor_visitStyleRule_closure7: function _EvaluateVisitor_visitStyleRule_closure7(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitStyleRule__closure0: function _EvaluateVisitor_visitStyleRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure6: function _EvaluateVisitor_visitStyleRule_closure6() {
    },
    _EvaluateVisitor_visitStyleRule_closure8: function _EvaluateVisitor_visitStyleRule_closure8() {
    },
    _EvaluateVisitor_visitSupportsRule_closure1: function _EvaluateVisitor_visitSupportsRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule__closure0: function _EvaluateVisitor_visitSupportsRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule_closure2: function _EvaluateVisitor_visitSupportsRule_closure2() {
    },
    _EvaluateVisitor__visitSupportsCondition_closure0: function _EvaluateVisitor__visitSupportsCondition_closure0(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure2: function _EvaluateVisitor_visitVariableDeclaration_closure2(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure3: function _EvaluateVisitor_visitVariableDeclaration_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure4: function _EvaluateVisitor_visitVariableDeclaration_closure4(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.value = t2;
    },
    _EvaluateVisitor_visitUseRule_closure0: function _EvaluateVisitor_visitUseRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWarnRule_closure0: function _EvaluateVisitor_visitWarnRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule_closure0: function _EvaluateVisitor_visitWhileRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule__closure0: function _EvaluateVisitor_visitWhileRule__closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitBinaryOperationExpression_closure0: function _EvaluateVisitor_visitBinaryOperationExpression_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__slash_recommendation0: function _EvaluateVisitor__slash_recommendation0() {
    },
    _EvaluateVisitor_visitVariableExpression_closure0: function _EvaluateVisitor_visitVariableExpression_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitUnaryOperationExpression_closure0: function _EvaluateVisitor_visitUnaryOperationExpression_closure0(t0, t1) {
      this.node = t0;
      this.operand = t1;
    },
    _EvaluateVisitor_visitListExpression_closure0: function _EvaluateVisitor_visitListExpression_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitFunctionExpression_closure2: function _EvaluateVisitor_visitFunctionExpression_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitFunctionExpression_closure3: function _EvaluateVisitor_visitFunctionExpression_closure3() {
    },
    _EvaluateVisitor_visitFunctionExpression_closure4: function _EvaluateVisitor_visitFunctionExpression_closure4(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.node = t2;
    },
    _EvaluateVisitor__checkCalculationArguments_check0: function _EvaluateVisitor__checkCalculationArguments_check0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__visitCalculationExpression_closure0: function _EvaluateVisitor__visitCalculationExpression_closure0(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.node = t2;
      _.inLegacySassFunction = t3;
    },
    _EvaluateVisitor_visitInterpolatedFunctionExpression_closure0: function _EvaluateVisitor_visitInterpolatedFunctionExpression_closure0(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.$function = t2;
    },
    _EvaluateVisitor__runUserDefinedCallable_closure0: function _EvaluateVisitor__runUserDefinedCallable_closure0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.callable = t1;
      _.evaluated = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable__closure0: function _EvaluateVisitor__runUserDefinedCallable__closure0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable___closure0: function _EvaluateVisitor__runUserDefinedCallable___closure0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable____closure0: function _EvaluateVisitor__runUserDefinedCallable____closure0() {
    },
    _EvaluateVisitor__runFunctionCallable_closure0: function _EvaluateVisitor__runFunctionCallable_closure0(t0, t1) {
      this.$this = t0;
      this.callable = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure2: function _EvaluateVisitor__runBuiltInCallable_closure2(t0, t1, t2) {
      this._box_0 = t0;
      this.evaluated = t1;
      this.namedSet = t2;
    },
    _EvaluateVisitor__runBuiltInCallable_closure3: function _EvaluateVisitor__runBuiltInCallable_closure3(t0, t1) {
      this._box_0 = t0;
      this.evaluated = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure4: function _EvaluateVisitor__runBuiltInCallable_closure4() {
    },
    _EvaluateVisitor__evaluateArguments_closure3: function _EvaluateVisitor__evaluateArguments_closure3() {
    },
    _EvaluateVisitor__evaluateArguments_closure4: function _EvaluateVisitor__evaluateArguments_closure4(t0, t1) {
      this.$this = t0;
      this.restNodeForSpan = t1;
    },
    _EvaluateVisitor__evaluateArguments_closure5: function _EvaluateVisitor__evaluateArguments_closure5(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.namedNodes = t3;
    },
    _EvaluateVisitor__evaluateArguments_closure6: function _EvaluateVisitor__evaluateArguments_closure6() {
    },
    _EvaluateVisitor__evaluateMacroArguments_closure3: function _EvaluateVisitor__evaluateMacroArguments_closure3(t0) {
      this.restArgs = t0;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure4: function _EvaluateVisitor__evaluateMacroArguments_closure4(t0, t1, t2) {
      this.$this = t0;
      this.restNodeForSpan = t1;
      this.restArgs = t2;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure5: function _EvaluateVisitor__evaluateMacroArguments_closure5(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.restArgs = t3;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure6: function _EvaluateVisitor__evaluateMacroArguments_closure6(t0, t1, t2) {
      this.$this = t0;
      this.keywordRestNodeForSpan = t1;
      this.keywordRestArgs = t2;
    },
    _EvaluateVisitor__addRestMap_closure0: function _EvaluateVisitor__addRestMap_closure0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.values = t1;
      _.convert = t2;
      _.expressionNode = t3;
      _.map = t4;
      _.nodeWithSpan = t5;
    },
    _EvaluateVisitor__verifyArguments_closure0: function _EvaluateVisitor__verifyArguments_closure0(t0, t1, t2) {
      this.$arguments = t0;
      this.positional = t1;
      this.named = t2;
    },
    _EvaluateVisitor_visitCssAtRule_closure1: function _EvaluateVisitor_visitCssAtRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssAtRule_closure2: function _EvaluateVisitor_visitCssAtRule_closure2() {
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure1: function _EvaluateVisitor_visitCssKeyframeBlock_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure2: function _EvaluateVisitor_visitCssKeyframeBlock_closure2() {
    },
    _EvaluateVisitor_visitCssMediaRule_closure2: function _EvaluateVisitor_visitCssMediaRule_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure3: function _EvaluateVisitor_visitCssMediaRule_closure3(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.mergedQueries = t1;
      _.node = t2;
      _.mergedSources = t3;
    },
    _EvaluateVisitor_visitCssMediaRule__closure0: function _EvaluateVisitor_visitCssMediaRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule___closure0: function _EvaluateVisitor_visitCssMediaRule___closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure4: function _EvaluateVisitor_visitCssMediaRule_closure4(t0) {
      this.mergedSources = t0;
    },
    _EvaluateVisitor_visitCssStyleRule_closure2: function _EvaluateVisitor_visitCssStyleRule_closure2(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssStyleRule__closure0: function _EvaluateVisitor_visitCssStyleRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssStyleRule_closure1: function _EvaluateVisitor_visitCssStyleRule_closure1() {
    },
    _EvaluateVisitor_visitCssSupportsRule_closure1: function _EvaluateVisitor_visitCssSupportsRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule__closure0: function _EvaluateVisitor_visitCssSupportsRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule_closure2: function _EvaluateVisitor_visitCssSupportsRule_closure2() {
    },
    _EvaluateVisitor__performInterpolationHelper_closure0: function _EvaluateVisitor__performInterpolationHelper_closure0(t0) {
      this.interpolation = t0;
    },
    _EvaluateVisitor__serialize_closure0: function _EvaluateVisitor__serialize_closure0(t0, t1) {
      this.value = t0;
      this.quote = t1;
    },
    _EvaluateVisitor__expressionNode_closure0: function _EvaluateVisitor__expressionNode_closure0(t0, t1) {
      this.$this = t0;
      this.expression = t1;
    },
    _EvaluateVisitor__withoutSlash_recommendation0: function _EvaluateVisitor__withoutSlash_recommendation0() {
    },
    _EvaluateVisitor__stackFrame_closure0: function _EvaluateVisitor__stackFrame_closure0(t0) {
      this.$this = t0;
    },
    _ImportedCssVisitor0: function _ImportedCssVisitor0(t0) {
      this._async_evaluate$_visitor = t0;
    },
    _ImportedCssVisitor_visitCssAtRule_closure0: function _ImportedCssVisitor_visitCssAtRule_closure0() {
    },
    _ImportedCssVisitor_visitCssMediaRule_closure0: function _ImportedCssVisitor_visitCssMediaRule_closure0(t0) {
      this.hasBeenMerged = t0;
    },
    _ImportedCssVisitor_visitCssStyleRule_closure0: function _ImportedCssVisitor_visitCssStyleRule_closure0() {
    },
    _ImportedCssVisitor_visitCssSupportsRule_closure0: function _ImportedCssVisitor_visitCssSupportsRule_closure0() {
    },
    _EvaluationContext0: function _EvaluationContext0(t0, t1) {
      this._async_evaluate$_visitor = t0;
      this._async_evaluate$_defaultWarnNodeWithSpan = t1;
    },
    cloneCssStylesheet(stylesheet, extensionStore) {
      var _0_0 = extensionStore.clone$0();
      return new A._Record_2(new A._CloneCssVisitor(_0_0._1)._visitChildren$2(A.ModifiableCssStylesheet$(stylesheet.get$span(stylesheet)), stylesheet), _0_0._0);
    },
    _CloneCssVisitor: function _CloneCssVisitor(t0) {
      this._oldToNewSelectors = t0;
    },
    _EvaluateVisitor$(functions, importCache, logger, nodeImporter, quietDeps, sourceMap) {
      var t1 = type$.Uri,
        t2 = type$.Module_Callable,
        t3 = A._setArrayType([], type$.JSArray_Record_2_String_and_AstNode);
      t1 = new A._EvaluateVisitor(importCache, nodeImporter, A.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.Callable), A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Configuration), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.AstNode), logger, A.LinkedHashSet_LinkedHashSet$_empty(type$.Record_2_String_and_SourceSpan), quietDeps, sourceMap, A.Environment$(), A.LinkedHashSet_LinkedHashSet$_empty(t1), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.nullable_AstNode), t3, B.Configuration_Map_empty_null);
      t1._EvaluateVisitor$6$functions$importCache$logger$nodeImporter$quietDeps$sourceMap(functions, importCache, logger, nodeImporter, quietDeps, sourceMap);
      return t1;
    },
    Evaluator: function Evaluator(t0, t1) {
      this._visitor = t0;
      this._importer = t1;
    },
    _EvaluateVisitor: function _EvaluateVisitor(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15) {
      var _ = this;
      _._evaluate$_importCache = t0;
      _._evaluate$_nodeImporter = t1;
      _._builtInFunctions = t2;
      _._builtInModules = t3;
      _._modules = t4;
      _._moduleConfigurations = t5;
      _._moduleNodes = t6;
      _._evaluate$_logger = t7;
      _._warningsEmitted = t8;
      _._quietDeps = t9;
      _._sourceMap = t10;
      _._environment = t11;
      _._declarationName = _.__parent = _._mediaQuerySources = _._mediaQueries = _._styleRuleIgnoringAtRoot = null;
      _._member = "root stylesheet";
      _._importSpan = _._callableNode = _._currentCallable = null;
      _._inSupportsDeclaration = _._inKeyframes = _._atRootExcludingStyleRule = _._inUnknownAtRule = _._inFunction = false;
      _._loadedUrls = t12;
      _._activeModules = t13;
      _._stack = t14;
      _._importer = null;
      _._inDependency = false;
      _.__extensionStore = _._preModuleComments = _._outOfOrderImports = _.__endOfImports = _.__root = _.__stylesheet = null;
      _._configuration = t15;
    },
    _EvaluateVisitor_closure: function _EvaluateVisitor_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure0: function _EvaluateVisitor_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure1: function _EvaluateVisitor_closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure2: function _EvaluateVisitor_closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure3: function _EvaluateVisitor_closure3(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure4: function _EvaluateVisitor_closure4(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure5: function _EvaluateVisitor_closure5(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure6: function _EvaluateVisitor_closure6(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure7: function _EvaluateVisitor_closure7(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure2: function _EvaluateVisitor__closure2(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.module = t2;
    },
    _EvaluateVisitor_closure8: function _EvaluateVisitor_closure8(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure1: function _EvaluateVisitor__closure1(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.module = t2;
    },
    _EvaluateVisitor_closure9: function _EvaluateVisitor_closure9(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure10: function _EvaluateVisitor_closure10(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure: function _EvaluateVisitor__closure(t0, t1, t2) {
      this.values = t0;
      this.span = t1;
      this.callableNode = t2;
    },
    _EvaluateVisitor__closure0: function _EvaluateVisitor__closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure11: function _EvaluateVisitor_closure11(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_run_closure: function _EvaluateVisitor_run_closure(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.importer = t2;
    },
    _EvaluateVisitor_run__closure: function _EvaluateVisitor_run__closure(t0, t1, t2) {
      this.$this = t0;
      this.importer = t1;
      this.node = t2;
    },
    _EvaluateVisitor_runExpression_closure: function _EvaluateVisitor_runExpression_closure(t0, t1, t2) {
      this.$this = t0;
      this.importer = t1;
      this.expression = t2;
    },
    _EvaluateVisitor_runExpression__closure: function _EvaluateVisitor_runExpression__closure(t0, t1) {
      this.$this = t0;
      this.expression = t1;
    },
    _EvaluateVisitor_runExpression___closure: function _EvaluateVisitor_runExpression___closure(t0, t1) {
      this.$this = t0;
      this.expression = t1;
    },
    _EvaluateVisitor_runStatement_closure: function _EvaluateVisitor_runStatement_closure(t0, t1, t2) {
      this.$this = t0;
      this.importer = t1;
      this.statement = t2;
    },
    _EvaluateVisitor_runStatement__closure: function _EvaluateVisitor_runStatement__closure(t0, t1) {
      this.$this = t0;
      this.statement = t1;
    },
    _EvaluateVisitor_runStatement___closure: function _EvaluateVisitor_runStatement___closure(t0, t1) {
      this.$this = t0;
      this.statement = t1;
    },
    _EvaluateVisitor__loadModule_closure: function _EvaluateVisitor__loadModule_closure(t0, t1) {
      this._box_1 = t0;
      this.callback = t1;
    },
    _EvaluateVisitor__loadModule_closure0: function _EvaluateVisitor__loadModule_closure0(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.nodeWithSpan = t2;
      _.baseUrl = t3;
      _.namesInErrors = t4;
      _.configuration = t5;
      _.callback = t6;
    },
    _EvaluateVisitor__loadModule__closure: function _EvaluateVisitor__loadModule__closure(t0, t1) {
      this.$this = t0;
      this.message = t1;
    },
    _EvaluateVisitor__loadModule__closure0: function _EvaluateVisitor__loadModule__closure0(t0, t1, t2) {
      this._box_0 = t0;
      this.callback = t1;
      this.firstLoad = t2;
    },
    _EvaluateVisitor__execute_closure: function _EvaluateVisitor__execute_closure(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.stylesheet = t2;
      _.extensionStore = t3;
      _.configuration = t4;
      _.css = t5;
      _.preModuleComments = t6;
    },
    _EvaluateVisitor__combineCss_closure: function _EvaluateVisitor__combineCss_closure() {
    },
    _EvaluateVisitor__combineCss_closure0: function _EvaluateVisitor__combineCss_closure0(t0) {
      this.selectors = t0;
    },
    _EvaluateVisitor__combineCss_visitModule: function _EvaluateVisitor__combineCss_visitModule(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.seen = t1;
      _.clone = t2;
      _.css = t3;
      _.imports = t4;
      _.sorted = t5;
    },
    _EvaluateVisitor__extendModules_closure: function _EvaluateVisitor__extendModules_closure(t0) {
      this.originalSelectors = t0;
    },
    _EvaluateVisitor__extendModules_closure0: function _EvaluateVisitor__extendModules_closure0() {
    },
    _EvaluateVisitor_visitAtRootRule_closure: function _EvaluateVisitor_visitAtRootRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure0: function _EvaluateVisitor_visitAtRootRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure: function _EvaluateVisitor__scopeForAtRoot_closure(t0, t1, t2) {
      this.$this = t0;
      this.newParent = t1;
      this.node = t2;
    },
    _EvaluateVisitor__scopeForAtRoot_closure0: function _EvaluateVisitor__scopeForAtRoot_closure0(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure1: function _EvaluateVisitor__scopeForAtRoot_closure1(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot__closure: function _EvaluateVisitor__scopeForAtRoot__closure(t0, t1) {
      this.innerScope = t0;
      this.callback = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure2: function _EvaluateVisitor__scopeForAtRoot_closure2(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure3: function _EvaluateVisitor__scopeForAtRoot_closure3() {
    },
    _EvaluateVisitor__scopeForAtRoot_closure4: function _EvaluateVisitor__scopeForAtRoot_closure4(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor_visitContentRule_closure: function _EvaluateVisitor_visitContentRule_closure(t0, t1) {
      this.$this = t0;
      this.content = t1;
    },
    _EvaluateVisitor_visitDeclaration_closure: function _EvaluateVisitor_visitDeclaration_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitEachRule_closure: function _EvaluateVisitor_visitEachRule_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure0: function _EvaluateVisitor_visitEachRule_closure0(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure1: function _EvaluateVisitor_visitEachRule_closure1(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.list = t1;
      _.setVariables = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitEachRule__closure: function _EvaluateVisitor_visitEachRule__closure(t0, t1, t2) {
      this.$this = t0;
      this.setVariables = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitEachRule___closure: function _EvaluateVisitor_visitEachRule___closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitAtRule_closure: function _EvaluateVisitor_visitAtRule_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitAtRule_closure0: function _EvaluateVisitor_visitAtRule_closure0(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.children = t2;
    },
    _EvaluateVisitor_visitAtRule__closure: function _EvaluateVisitor_visitAtRule__closure(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitAtRule_closure1: function _EvaluateVisitor_visitAtRule_closure1() {
    },
    _EvaluateVisitor_visitForRule_closure: function _EvaluateVisitor_visitForRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure0: function _EvaluateVisitor_visitForRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure1: function _EvaluateVisitor_visitForRule_closure1(t0) {
      this.fromNumber = t0;
    },
    _EvaluateVisitor_visitForRule_closure2: function _EvaluateVisitor_visitForRule_closure2(t0, t1) {
      this.toNumber = t0;
      this.fromNumber = t1;
    },
    _EvaluateVisitor_visitForRule_closure3: function _EvaluateVisitor_visitForRule_closure3(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.node = t2;
      _.from = t3;
      _.direction = t4;
      _.fromNumber = t5;
    },
    _EvaluateVisitor_visitForRule__closure: function _EvaluateVisitor_visitForRule__closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitForwardRule_closure: function _EvaluateVisitor_visitForwardRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForwardRule_closure0: function _EvaluateVisitor_visitForwardRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__registerCommentsForModule_closure: function _EvaluateVisitor__registerCommentsForModule_closure() {
    },
    _EvaluateVisitor_visitIfRule_closure: function _EvaluateVisitor_visitIfRule_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIfRule__closure: function _EvaluateVisitor_visitIfRule__closure(t0, t1) {
      this.$this = t0;
      this.clause = t1;
    },
    _EvaluateVisitor_visitIfRule___closure: function _EvaluateVisitor_visitIfRule___closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport_closure: function _EvaluateVisitor__visitDynamicImport_closure(t0, t1) {
      this.$this = t0;
      this.$import = t1;
    },
    _EvaluateVisitor__visitDynamicImport__closure: function _EvaluateVisitor__visitDynamicImport__closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport__closure0: function _EvaluateVisitor__visitDynamicImport__closure0() {
    },
    _EvaluateVisitor__visitDynamicImport__closure1: function _EvaluateVisitor__visitDynamicImport__closure1() {
    },
    _EvaluateVisitor__visitDynamicImport__closure2: function _EvaluateVisitor__visitDynamicImport__closure2(t0, t1, t2, t3, t4) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.loadsUserDefinedModules = t2;
      _.environment = t3;
      _.children = t4;
    },
    _EvaluateVisitor__applyMixin_closure: function _EvaluateVisitor__applyMixin_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.$arguments = t1;
      _.mixin = t2;
      _.nodeWithSpanWithoutContent = t3;
    },
    _EvaluateVisitor__applyMixin__closure0: function _EvaluateVisitor__applyMixin__closure0(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.$arguments = t1;
      _.mixin = t2;
      _.nodeWithSpanWithoutContent = t3;
    },
    _EvaluateVisitor__applyMixin_closure0: function _EvaluateVisitor__applyMixin_closure0(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.contentCallable = t1;
      _.mixin = t2;
      _.nodeWithSpanWithoutContent = t3;
    },
    _EvaluateVisitor__applyMixin__closure: function _EvaluateVisitor__applyMixin__closure(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpanWithoutContent = t2;
    },
    _EvaluateVisitor__applyMixin___closure: function _EvaluateVisitor__applyMixin___closure(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpanWithoutContent = t2;
    },
    _EvaluateVisitor__applyMixin____closure: function _EvaluateVisitor__applyMixin____closure(t0, t1) {
      this.$this = t0;
      this.statement = t1;
    },
    _EvaluateVisitor_visitIncludeRule_closure: function _EvaluateVisitor_visitIncludeRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitIncludeRule_closure0: function _EvaluateVisitor_visitIncludeRule_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure1: function _EvaluateVisitor_visitIncludeRule_closure1(t0) {
      this.node = t0;
    },
    _EvaluateVisitor_visitMediaRule_closure: function _EvaluateVisitor_visitMediaRule_closure(t0, t1) {
      this.$this = t0;
      this.queries = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure0: function _EvaluateVisitor_visitMediaRule_closure0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.mergedQueries = t1;
      _.queries = t2;
      _.mergedSources = t3;
      _.node = t4;
    },
    _EvaluateVisitor_visitMediaRule__closure: function _EvaluateVisitor_visitMediaRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule___closure: function _EvaluateVisitor_visitMediaRule___closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure1: function _EvaluateVisitor_visitMediaRule_closure1(t0) {
      this.mergedSources = t0;
    },
    _EvaluateVisitor_visitStyleRule_closure: function _EvaluateVisitor_visitStyleRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure0: function _EvaluateVisitor_visitStyleRule_closure0() {
    },
    _EvaluateVisitor_visitStyleRule_closure2: function _EvaluateVisitor_visitStyleRule_closure2(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitStyleRule__closure: function _EvaluateVisitor_visitStyleRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure1: function _EvaluateVisitor_visitStyleRule_closure1() {
    },
    _EvaluateVisitor_visitStyleRule_closure3: function _EvaluateVisitor_visitStyleRule_closure3() {
    },
    _EvaluateVisitor_visitSupportsRule_closure: function _EvaluateVisitor_visitSupportsRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule__closure: function _EvaluateVisitor_visitSupportsRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule_closure0: function _EvaluateVisitor_visitSupportsRule_closure0() {
    },
    _EvaluateVisitor__visitSupportsCondition_closure: function _EvaluateVisitor__visitSupportsCondition_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure: function _EvaluateVisitor_visitVariableDeclaration_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure0: function _EvaluateVisitor_visitVariableDeclaration_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure1: function _EvaluateVisitor_visitVariableDeclaration_closure1(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.value = t2;
    },
    _EvaluateVisitor_visitUseRule_closure: function _EvaluateVisitor_visitUseRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWarnRule_closure: function _EvaluateVisitor_visitWarnRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule_closure: function _EvaluateVisitor_visitWhileRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule__closure: function _EvaluateVisitor_visitWhileRule__closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitBinaryOperationExpression_closure: function _EvaluateVisitor_visitBinaryOperationExpression_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__slash_recommendation: function _EvaluateVisitor__slash_recommendation() {
    },
    _EvaluateVisitor_visitVariableExpression_closure: function _EvaluateVisitor_visitVariableExpression_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitUnaryOperationExpression_closure: function _EvaluateVisitor_visitUnaryOperationExpression_closure(t0, t1) {
      this.node = t0;
      this.operand = t1;
    },
    _EvaluateVisitor_visitListExpression_closure: function _EvaluateVisitor_visitListExpression_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitFunctionExpression_closure: function _EvaluateVisitor_visitFunctionExpression_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitFunctionExpression_closure0: function _EvaluateVisitor_visitFunctionExpression_closure0() {
    },
    _EvaluateVisitor_visitFunctionExpression_closure1: function _EvaluateVisitor_visitFunctionExpression_closure1(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.node = t2;
    },
    _EvaluateVisitor__checkCalculationArguments_check: function _EvaluateVisitor__checkCalculationArguments_check(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__visitCalculationExpression_closure: function _EvaluateVisitor__visitCalculationExpression_closure(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.node = t2;
      _.inLegacySassFunction = t3;
    },
    _EvaluateVisitor_visitInterpolatedFunctionExpression_closure: function _EvaluateVisitor_visitInterpolatedFunctionExpression_closure(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.$function = t2;
    },
    _EvaluateVisitor__runUserDefinedCallable_closure: function _EvaluateVisitor__runUserDefinedCallable_closure(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.callable = t1;
      _.evaluated = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable__closure: function _EvaluateVisitor__runUserDefinedCallable__closure(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable___closure: function _EvaluateVisitor__runUserDefinedCallable___closure(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable____closure: function _EvaluateVisitor__runUserDefinedCallable____closure() {
    },
    _EvaluateVisitor__runFunctionCallable_closure: function _EvaluateVisitor__runFunctionCallable_closure(t0, t1) {
      this.$this = t0;
      this.callable = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure: function _EvaluateVisitor__runBuiltInCallable_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.evaluated = t1;
      this.namedSet = t2;
    },
    _EvaluateVisitor__runBuiltInCallable_closure0: function _EvaluateVisitor__runBuiltInCallable_closure0(t0, t1) {
      this._box_0 = t0;
      this.evaluated = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure1: function _EvaluateVisitor__runBuiltInCallable_closure1() {
    },
    _EvaluateVisitor__evaluateArguments_closure: function _EvaluateVisitor__evaluateArguments_closure() {
    },
    _EvaluateVisitor__evaluateArguments_closure0: function _EvaluateVisitor__evaluateArguments_closure0(t0, t1) {
      this.$this = t0;
      this.restNodeForSpan = t1;
    },
    _EvaluateVisitor__evaluateArguments_closure1: function _EvaluateVisitor__evaluateArguments_closure1(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.namedNodes = t3;
    },
    _EvaluateVisitor__evaluateArguments_closure2: function _EvaluateVisitor__evaluateArguments_closure2() {
    },
    _EvaluateVisitor__evaluateMacroArguments_closure: function _EvaluateVisitor__evaluateMacroArguments_closure(t0) {
      this.restArgs = t0;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure0: function _EvaluateVisitor__evaluateMacroArguments_closure0(t0, t1, t2) {
      this.$this = t0;
      this.restNodeForSpan = t1;
      this.restArgs = t2;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure1: function _EvaluateVisitor__evaluateMacroArguments_closure1(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.restArgs = t3;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure2: function _EvaluateVisitor__evaluateMacroArguments_closure2(t0, t1, t2) {
      this.$this = t0;
      this.keywordRestNodeForSpan = t1;
      this.keywordRestArgs = t2;
    },
    _EvaluateVisitor__addRestMap_closure: function _EvaluateVisitor__addRestMap_closure(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.values = t1;
      _.convert = t2;
      _.expressionNode = t3;
      _.map = t4;
      _.nodeWithSpan = t5;
    },
    _EvaluateVisitor__verifyArguments_closure: function _EvaluateVisitor__verifyArguments_closure(t0, t1, t2) {
      this.$arguments = t0;
      this.positional = t1;
      this.named = t2;
    },
    _EvaluateVisitor_visitCssAtRule_closure: function _EvaluateVisitor_visitCssAtRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssAtRule_closure0: function _EvaluateVisitor_visitCssAtRule_closure0() {
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure: function _EvaluateVisitor_visitCssKeyframeBlock_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure0: function _EvaluateVisitor_visitCssKeyframeBlock_closure0() {
    },
    _EvaluateVisitor_visitCssMediaRule_closure: function _EvaluateVisitor_visitCssMediaRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure0: function _EvaluateVisitor_visitCssMediaRule_closure0(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.mergedQueries = t1;
      _.node = t2;
      _.mergedSources = t3;
    },
    _EvaluateVisitor_visitCssMediaRule__closure: function _EvaluateVisitor_visitCssMediaRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule___closure: function _EvaluateVisitor_visitCssMediaRule___closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure1: function _EvaluateVisitor_visitCssMediaRule_closure1(t0) {
      this.mergedSources = t0;
    },
    _EvaluateVisitor_visitCssStyleRule_closure0: function _EvaluateVisitor_visitCssStyleRule_closure0(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssStyleRule__closure: function _EvaluateVisitor_visitCssStyleRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssStyleRule_closure: function _EvaluateVisitor_visitCssStyleRule_closure() {
    },
    _EvaluateVisitor_visitCssSupportsRule_closure: function _EvaluateVisitor_visitCssSupportsRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule__closure: function _EvaluateVisitor_visitCssSupportsRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule_closure0: function _EvaluateVisitor_visitCssSupportsRule_closure0() {
    },
    _EvaluateVisitor__performInterpolationHelper_closure: function _EvaluateVisitor__performInterpolationHelper_closure(t0) {
      this.interpolation = t0;
    },
    _EvaluateVisitor__serialize_closure: function _EvaluateVisitor__serialize_closure(t0, t1) {
      this.value = t0;
      this.quote = t1;
    },
    _EvaluateVisitor__expressionNode_closure: function _EvaluateVisitor__expressionNode_closure(t0, t1) {
      this.$this = t0;
      this.expression = t1;
    },
    _EvaluateVisitor__withoutSlash_recommendation: function _EvaluateVisitor__withoutSlash_recommendation() {
    },
    _EvaluateVisitor__stackFrame_closure: function _EvaluateVisitor__stackFrame_closure(t0) {
      this.$this = t0;
    },
    _ImportedCssVisitor: function _ImportedCssVisitor(t0) {
      this._visitor = t0;
    },
    _ImportedCssVisitor_visitCssAtRule_closure: function _ImportedCssVisitor_visitCssAtRule_closure() {
    },
    _ImportedCssVisitor_visitCssMediaRule_closure: function _ImportedCssVisitor_visitCssMediaRule_closure(t0) {
      this.hasBeenMerged = t0;
    },
    _ImportedCssVisitor_visitCssStyleRule_closure: function _ImportedCssVisitor_visitCssStyleRule_closure() {
    },
    _ImportedCssVisitor_visitCssSupportsRule_closure: function _ImportedCssVisitor_visitCssSupportsRule_closure() {
    },
    _EvaluationContext: function _EvaluationContext(t0, t1) {
      this._visitor = t0;
      this._defaultWarnNodeWithSpan = t1;
    },
    EveryCssVisitor: function EveryCssVisitor() {
    },
    EveryCssVisitor_visitCssAtRule_closure: function EveryCssVisitor_visitCssAtRule_closure(t0) {
      this.$this = t0;
    },
    EveryCssVisitor_visitCssKeyframeBlock_closure: function EveryCssVisitor_visitCssKeyframeBlock_closure(t0) {
      this.$this = t0;
    },
    EveryCssVisitor_visitCssMediaRule_closure: function EveryCssVisitor_visitCssMediaRule_closure(t0) {
      this.$this = t0;
    },
    EveryCssVisitor_visitCssStyleRule_closure: function EveryCssVisitor_visitCssStyleRule_closure(t0) {
      this.$this = t0;
    },
    EveryCssVisitor_visitCssStylesheet_closure: function EveryCssVisitor_visitCssStylesheet_closure(t0) {
      this.$this = t0;
    },
    EveryCssVisitor_visitCssSupportsRule_closure: function EveryCssVisitor_visitCssSupportsRule_closure(t0) {
      this.$this = t0;
    },
    expressionToCalc(expression) {
      var t4,
        t1 = A._setArrayType([B.C__MakeExpressionCalculationSafe.visitBinaryOperationExpression$1(expression)], type$.JSArray_Expression),
        t2 = expression.get$span(0),
        t3 = type$.Expression;
      t1 = A.List_List$unmodifiable(t1, t3);
      t3 = A.ConstantMap_ConstantMap$from(B.Map_empty6, type$.String, t3);
      t4 = expression.get$span(0);
      return new A.FunctionExpression(null, A.stringReplaceAllUnchecked("calc", "_", "-"), "calc", new A.ArgumentInvocation(t1, t3, null, null, t2), t4);
    },
    _MakeExpressionCalculationSafe: function _MakeExpressionCalculationSafe() {
    },
    __MakeExpressionCalculationSafe_Object_ReplaceExpressionVisitor: function __MakeExpressionCalculationSafe_Object_ReplaceExpressionVisitor() {
    },
    _FindDependenciesVisitor: function _FindDependenciesVisitor(t0, t1, t2, t3, t4) {
      var _ = this;
      _._find_dependencies$_uses = t0;
      _._find_dependencies$_forwards = t1;
      _._metaLoadCss = t2;
      _._imports = t3;
      _._metaNamespaces = t4;
    },
    DependencyReport: function DependencyReport(t0, t1, t2, t3) {
      var _ = this;
      _.uses = t0;
      _.forwards = t1;
      _.metaLoadCss = t2;
      _.imports = t3;
    },
    __FindDependenciesVisitor_Object_RecursiveStatementVisitor: function __FindDependenciesVisitor_Object_RecursiveStatementVisitor() {
    },
    RecursiveStatementVisitor: function RecursiveStatementVisitor() {
    },
    ReplaceExpressionVisitor: function ReplaceExpressionVisitor() {
    },
    ReplaceExpressionVisitor_visitListExpression_closure: function ReplaceExpressionVisitor_visitListExpression_closure(t0) {
      this.$this = t0;
    },
    ReplaceExpressionVisitor_visitArgumentInvocation_closure: function ReplaceExpressionVisitor_visitArgumentInvocation_closure(t0) {
      this.$this = t0;
    },
    ReplaceExpressionVisitor_visitInterpolation_closure: function ReplaceExpressionVisitor_visitInterpolation_closure(t0) {
      this.$this = t0;
    },
    SelectorSearchVisitor: function SelectorSearchVisitor() {
    },
    SelectorSearchVisitor_visitComplexSelector_closure: function SelectorSearchVisitor_visitComplexSelector_closure(t0) {
      this.$this = t0;
    },
    SelectorSearchVisitor_visitCompoundSelector_closure: function SelectorSearchVisitor_visitCompoundSelector_closure(t0) {
      this.$this = t0;
    },
    serialize(node, charset, indentWidth, inspect, lineFeed, sourceMap, style, useSpaces) {
      var t1, css, t2, prefix,
        visitor = A._SerializeVisitor$(2, inspect, lineFeed, true, sourceMap, style, true);
      node.accept$1(visitor);
      t1 = visitor._serialize$_buffer;
      css = t1.toString$0(0);
      if (charset) {
        t2 = new A.CodeUnits(css);
        t2 = t2.any$1(t2, new A.serialize_closure());
      } else
        t2 = false;
      if (t2)
        prefix = style === B.OutputStyle_1 ? "\ufeff" : '@charset "UTF-8";\n';
      else
        prefix = "";
      t1 = sourceMap ? t1.buildSourceMap$1$prefix(prefix) : null;
      return new A._Record_2_sourceMap(prefix + css, t1);
    },
    serializeValue(value, inspect, quote) {
      var visitor = A._SerializeVisitor$(null, inspect, null, quote, false, null, true);
      value.accept$1(visitor);
      return visitor._serialize$_buffer.toString$0(0);
    },
    serializeSelector(selector, inspect) {
      var visitor = A._SerializeVisitor$(null, true, null, true, false, null, true);
      selector.accept$1(visitor);
      return visitor._serialize$_buffer.toString$0(0);
    },
    _SerializeVisitor$(indentWidth, inspect, lineFeed, quote, sourceMap, style, useSpaces) {
      var t1 = sourceMap ? new A.SourceMapBuffer(new A.StringBuffer(""), A._setArrayType([], type$.JSArray_Entry)) : new A.NoSourceMapBuffer(new A.StringBuffer("")),
        t2 = style == null ? B.OutputStyle_0 : style,
        t3 = indentWidth == null ? 2 : indentWidth;
      A.RangeError_checkValueInInterval(t3, 0, 10, "indentWidth");
      return new A._SerializeVisitor(t1, t2, inspect, quote, 32, t3, B.LineFeed_lf);
    },
    serialize_closure: function serialize_closure() {
    },
    _SerializeVisitor: function _SerializeVisitor(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._serialize$_buffer = t0;
      _._indentation = 0;
      _._style = t1;
      _._inspect = t2;
      _._quote = t3;
      _._indentCharacter = t4;
      _._indentWidth = t5;
      _._serialize$_lineFeed = t6;
    },
    _SerializeVisitor_visitCssComment_closure: function _SerializeVisitor_visitCssComment_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssAtRule_closure: function _SerializeVisitor_visitCssAtRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssMediaRule_closure: function _SerializeVisitor_visitCssMediaRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssImport_closure: function _SerializeVisitor_visitCssImport_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssImport__closure: function _SerializeVisitor_visitCssImport__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssKeyframeBlock_closure: function _SerializeVisitor_visitCssKeyframeBlock_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssStyleRule_closure: function _SerializeVisitor_visitCssStyleRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssSupportsRule_closure: function _SerializeVisitor_visitCssSupportsRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssDeclaration_closure: function _SerializeVisitor_visitCssDeclaration_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssDeclaration_closure0: function _SerializeVisitor_visitCssDeclaration_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitList_closure: function _SerializeVisitor_visitList_closure() {
    },
    _SerializeVisitor_visitList_closure0: function _SerializeVisitor_visitList_closure0(t0, t1) {
      this.$this = t0;
      this.value = t1;
    },
    _SerializeVisitor_visitList_closure1: function _SerializeVisitor_visitList_closure1(t0) {
      this.$this = t0;
    },
    _SerializeVisitor_visitMap_closure: function _SerializeVisitor_visitMap_closure(t0) {
      this.$this = t0;
    },
    _SerializeVisitor_visitSelectorList_closure: function _SerializeVisitor_visitSelectorList_closure() {
    },
    _SerializeVisitor__write_closure: function _SerializeVisitor__write_closure(t0, t1) {
      this.$this = t0;
      this.value = t1;
    },
    _SerializeVisitor__visitChildren_closure: function _SerializeVisitor__visitChildren_closure(t0, t1) {
      this.$this = t0;
      this.child = t1;
    },
    _SerializeVisitor__visitChildren_closure0: function _SerializeVisitor__visitChildren_closure0(t0, t1) {
      this.$this = t0;
      this.child = t1;
    },
    OutputStyle: function OutputStyle(t0) {
      this._name = t0;
    },
    LineFeed: function LineFeed(t0) {
      this._name = t0;
    },
    StatementSearchVisitor: function StatementSearchVisitor() {
    },
    StatementSearchVisitor_visitIfRule_closure: function StatementSearchVisitor_visitIfRule_closure(t0) {
      this.$this = t0;
    },
    StatementSearchVisitor_visitIfRule__closure0: function StatementSearchVisitor_visitIfRule__closure0(t0) {
      this.$this = t0;
    },
    StatementSearchVisitor_visitIfRule_closure0: function StatementSearchVisitor_visitIfRule_closure0(t0) {
      this.$this = t0;
    },
    StatementSearchVisitor_visitIfRule__closure: function StatementSearchVisitor_visitIfRule__closure(t0) {
      this.$this = t0;
    },
    StatementSearchVisitor_visitChildren_closure: function StatementSearchVisitor_visitChildren_closure(t0) {
      this.$this = t0;
    },
    Entry: function Entry(t0, t1, t2) {
      this.source = t0;
      this.target = t1;
      this.identifierName = t2;
    },
    SingleMapping_SingleMapping$fromEntries(entries) {
      var lines, t1, t2, urls, names, files, targetEntries, t3, lineNum, _i, sourceEntry, t4, t5, sourceUrl, t6, urlId,
        sourceEntries = J.toList$0$ax(entries);
      B.JSArray_methods.sort$0(sourceEntries);
      lines = A._setArrayType([], type$.JSArray_TargetLineEntry);
      t1 = type$.String;
      t2 = type$.int;
      urls = A.LinkedHashMap_LinkedHashMap$_empty(t1, t2);
      names = A.LinkedHashMap_LinkedHashMap$_empty(t1, t2);
      files = A.LinkedHashMap_LinkedHashMap$_empty(t2, type$.SourceFile);
      targetEntries = A._Cell$();
      for (t2 = sourceEntries.length, t3 = type$.JSArray_TargetEntry, lineNum = null, _i = 0; _i < sourceEntries.length; sourceEntries.length === t2 || (0, A.throwConcurrentModificationError)(sourceEntries), ++_i) {
        sourceEntry = sourceEntries[_i];
        if (lineNum == null || sourceEntry.target.line > lineNum) {
          lineNum = sourceEntry.target.line;
          t4 = A._setArrayType([], t3);
          targetEntries.__late_helper$_value = t4;
          lines.push(new A.TargetLineEntry(lineNum, t4));
        }
        t4 = sourceEntry.source;
        t5 = t4.file;
        sourceUrl = t5.url;
        t6 = sourceUrl == null ? "" : sourceUrl.toString$0(0);
        urlId = urls.putIfAbsent$2(t6, new A.SingleMapping_SingleMapping$fromEntries_closure(urls));
        files.putIfAbsent$2(urlId, new A.SingleMapping_SingleMapping$fromEntries_closure0(sourceEntry));
        t6 = targetEntries.__late_helper$_value;
        if (t6 === targetEntries)
          A.throwExpression(A.LateError$localNI(""));
        t4 = t4.offset;
        J.add$1$ax(t6, new A.TargetEntry(sourceEntry.target.column, urlId, t5.getLine$1(t4), t5.getColumn$1(t4), null));
      }
      t2 = urls.get$values(0);
      t2 = A.MappedIterable_MappedIterable(t2, new A.SingleMapping_SingleMapping$fromEntries_closure1(files), A._instanceType(t2)._eval$1("Iterable.E"), type$.nullable_SourceFile);
      t2 = A.List_List$of(t2, true, A._instanceType(t2)._eval$1("Iterable.E"));
      t3 = urls.$ti._eval$1("LinkedHashMapKeyIterable<1>");
      t4 = names.$ti._eval$1("LinkedHashMapKeyIterable<1>");
      return new A.SingleMapping(A.List_List$of(new A.LinkedHashMapKeyIterable(urls, t3), true, t3._eval$1("Iterable.E")), A.List_List$of(new A.LinkedHashMapKeyIterable(names, t4), true, t4._eval$1("Iterable.E")), t2, lines, null, A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.dynamic));
    },
    Mapping: function Mapping() {
    },
    SingleMapping: function SingleMapping(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.urls = t0;
      _.names = t1;
      _.files = t2;
      _.lines = t3;
      _.targetUrl = t4;
      _.sourceRoot = null;
      _.extensions = t5;
    },
    SingleMapping_SingleMapping$fromEntries_closure: function SingleMapping_SingleMapping$fromEntries_closure(t0) {
      this.urls = t0;
    },
    SingleMapping_SingleMapping$fromEntries_closure0: function SingleMapping_SingleMapping$fromEntries_closure0(t0) {
      this.sourceEntry = t0;
    },
    SingleMapping_SingleMapping$fromEntries_closure1: function SingleMapping_SingleMapping$fromEntries_closure1(t0) {
      this.files = t0;
    },
    SingleMapping_toJson_closure: function SingleMapping_toJson_closure() {
    },
    SingleMapping_toJson_closure0: function SingleMapping_toJson_closure0(t0) {
      this.result = t0;
    },
    TargetLineEntry: function TargetLineEntry(t0, t1) {
      this.line = t0;
      this.entries = t1;
    },
    TargetEntry: function TargetEntry(t0, t1, t2, t3, t4) {
      var _ = this;
      _.column = t0;
      _.sourceUrlId = t1;
      _.sourceLine = t2;
      _.sourceColumn = t3;
      _.sourceNameId = t4;
    },
    SourceFile$fromString(text, url) {
      var t1 = new A.CodeUnits(text),
        t2 = A._setArrayType([0], type$.JSArray_int),
        t3 = typeof url == "string" ? A.Uri_parse(url) : type$.nullable_Uri._as(url);
      t2 = new A.SourceFile(t3, t2, new Uint32Array(A._ensureNativeList(t1.toList$0(t1))));
      t2.SourceFile$decoded$2$url(t1, url);
      return t2;
    },
    SourceFile$decoded(decodedChars, url) {
      var t1 = A._setArrayType([0], type$.JSArray_int),
        t2 = typeof url == "string" ? A.Uri_parse(url) : type$.nullable_Uri._as(url);
      t1 = new A.SourceFile(t2, t1, new Uint32Array(A._ensureNativeList(J.toList$0$ax(decodedChars))));
      t1.SourceFile$decoded$2$url(decodedChars, url);
      return t1;
    },
    FileLocation$_(file, offset) {
      if (offset < 0)
        A.throwExpression(A.RangeError$("Offset may not be negative, was " + offset + "."));
      else if (offset > file._decodedChars.length)
        A.throwExpression(A.RangeError$("Offset " + offset + string$.x20must_n + file.get$length(0) + "."));
      return new A.FileLocation(file, offset);
    },
    _FileSpan$(file, _start, _end) {
      if (_end < _start)
        A.throwExpression(A.ArgumentError$("End " + _end + " must come after start " + _start + ".", null));
      else if (_end > file._decodedChars.length)
        A.throwExpression(A.RangeError$("End " + _end + string$.x20must_n + file.get$length(0) + "."));
      else if (_start < 0)
        A.throwExpression(A.RangeError$("Start may not be negative, was " + _start + "."));
      return new A._FileSpan(file, _start, _end);
    },
    FileSpanExtension_subspan(_this, start, end) {
      var t1, startOffset, t2;
      A.RangeError_checkValidRange(start, end, _this.get$length(_this));
      if (start === 0)
        t1 = end == null || end === _this.get$length(_this);
      else
        t1 = false;
      if (t1)
        return _this;
      startOffset = _this.get$start(_this).offset;
      t1 = _this.get$file(_this);
      t2 = end == null ? _this.get$end(_this).offset : startOffset + end;
      return t1.span$2(0, startOffset + start, t2);
    },
    SourceFile: function SourceFile(t0, t1, t2) {
      var _ = this;
      _.url = t0;
      _._lineStarts = t1;
      _._decodedChars = t2;
      _._cachedLine = null;
    },
    FileLocation: function FileLocation(t0, t1) {
      this.file = t0;
      this.offset = t1;
    },
    _FileSpan: function _FileSpan(t0, t1, t2) {
      this.file = t0;
      this._file$_start = t1;
      this._end = t2;
    },
    Highlighter$(span, color) {
      var t1 = A.Highlighter__collateLines(A._setArrayType([A._Highlight$(span, null, true)], type$.JSArray__Highlight)),
        t2 = new A.Highlighter_closure(color).call$0(),
        t3 = B.JSInt_methods.toString$0(B.JSArray_methods.get$last(t1).number + 1),
        t4 = A.Highlighter__contiguous(t1) ? 0 : 3,
        t5 = A._arrayInstanceType(t1);
      return new A.Highlighter(t1, t2, null, 1 + Math.max(t3.length, t4), new A.MappedListIterable(t1, new A.Highlighter$__closure(), t5._eval$1("MappedListIterable<1,int>")).reduce$1(0, B.CONSTANT), !A.isAllTheSame(new A.MappedListIterable(t1, new A.Highlighter$__closure0(), t5._eval$1("MappedListIterable<1,Object?>"))), new A.StringBuffer(""));
    },
    Highlighter$multiple(primarySpan, primaryLabel, secondarySpans, color, primaryColor, secondaryColor) {
      var t2, t3, t4, t5, t6,
        t1 = A._setArrayType([A._Highlight$(primarySpan, primaryLabel, true)], type$.JSArray__Highlight);
      for (t2 = secondarySpans.get$entries(secondarySpans), t2 = t2.get$iterator(t2); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        t1.push(A._Highlight$(t3.key, t3.value, false));
      }
      t1 = A.Highlighter__collateLines(t1);
      if (color)
        t2 = primaryColor == null ? "\x1b[31m" : primaryColor;
      else
        t2 = null;
      if (color)
        t3 = "\x1b[34m";
      else
        t3 = null;
      t4 = B.JSInt_methods.toString$0(B.JSArray_methods.get$last(t1).number + 1);
      t5 = A.Highlighter__contiguous(t1) ? 0 : 3;
      t6 = A._arrayInstanceType(t1);
      return new A.Highlighter(t1, t2, t3, 1 + Math.max(t4.length, t5), new A.MappedListIterable(t1, new A.Highlighter$__closure(), t6._eval$1("MappedListIterable<1,int>")).reduce$1(0, B.CONSTANT), !A.isAllTheSame(new A.MappedListIterable(t1, new A.Highlighter$__closure0(), t6._eval$1("MappedListIterable<1,Object?>"))), new A.StringBuffer(""));
    },
    Highlighter__contiguous(lines) {
      var i, thisLine, nextLine;
      for (i = 0; i < lines.length - 1;) {
        thisLine = lines[i];
        ++i;
        nextLine = lines[i];
        if (thisLine.number + 1 !== nextLine.number && J.$eq$(thisLine.url, nextLine.url))
          return false;
      }
      return true;
    },
    Highlighter__collateLines(highlights) {
      var t1, t2, t3,
        highlightsByUrl = A.groupBy(highlights, new A.Highlighter__collateLines_closure(), type$._Highlight, type$.Object);
      for (t1 = highlightsByUrl.get$values(0), t2 = A._instanceType(t1), t2 = t2._eval$1("@<1>")._bind$1(t2._rest[1]), t1 = new A.MappedIterator(J.get$iterator$ax(t1.__internal$_iterable), t1._f, t2._eval$1("MappedIterator<1,2>")), t2 = t2._rest[1]; t1.moveNext$0();) {
        t3 = t1.__internal$_current;
        if (t3 == null)
          t3 = t2._as(t3);
        J.sort$1$ax(t3, new A.Highlighter__collateLines_closure0());
      }
      t1 = highlightsByUrl.get$entries(0);
      t2 = A._instanceType(t1)._eval$1("ExpandIterable<Iterable.E,_Line>");
      return A.List_List$of(new A.ExpandIterable(t1, new A.Highlighter__collateLines_closure1(), t2), true, t2._eval$1("Iterable.E"));
    },
    _Highlight$(span, label, primary) {
      var t2,
        t1 = new A._Highlight_closure(span).call$0();
      if (label == null)
        t2 = null;
      else
        t2 = A.stringReplaceAllUnchecked(label, "\r\n", "\n");
      return new A._Highlight(t1, primary, t2);
    },
    _Highlight__normalizeNewlines(span) {
      var endOffset, t1, i, t2, t3, t4,
        text = span.get$text();
      if (!B.JSString_methods.contains$1(text, "\r\n"))
        return span;
      endOffset = span.get$end(span).get$offset();
      for (t1 = text.length - 1, i = 0; i < t1; ++i)
        if (text.charCodeAt(i) === 13 && text.charCodeAt(i + 1) === 10)
          --endOffset;
      t1 = span.get$start(span);
      t2 = span.get$sourceUrl(span);
      t3 = span.get$end(span).get$line();
      t2 = A.SourceLocation$(endOffset, span.get$end(span).get$column(), t3, t2);
      t3 = A.stringReplaceAllUnchecked(text, "\r\n", "\n");
      t4 = span.get$context(span);
      return A.SourceSpanWithContext$(t1, t2, t3, A.stringReplaceAllUnchecked(t4, "\r\n", "\n"));
    },
    _Highlight__normalizeTrailingNewline(span) {
      var context, text, start, end, t1, t2, t3;
      if (!B.JSString_methods.endsWith$1(span.get$context(span), "\n"))
        return span;
      if (B.JSString_methods.endsWith$1(span.get$text(), "\n\n"))
        return span;
      context = B.JSString_methods.substring$2(span.get$context(span), 0, span.get$context(span).length - 1);
      text = span.get$text();
      start = span.get$start(span);
      end = span.get$end(span);
      if (B.JSString_methods.endsWith$1(span.get$text(), "\n")) {
        t1 = A.findLineStart(span.get$context(span), span.get$text(), span.get$start(span).get$column());
        t1.toString;
        t1 = t1 + span.get$start(span).get$column() + span.get$length(span) === span.get$context(span).length;
      } else
        t1 = false;
      if (t1) {
        text = B.JSString_methods.substring$2(span.get$text(), 0, span.get$text().length - 1);
        if (text.length === 0)
          end = start;
        else {
          t1 = span.get$end(span).get$offset();
          t2 = span.get$sourceUrl(span);
          t3 = span.get$end(span).get$line();
          end = A.SourceLocation$(t1 - 1, A._Highlight__lastLineLength(context), t3 - 1, t2);
          start = span.get$start(span).get$offset() === span.get$end(span).get$offset() ? end : span.get$start(span);
        }
      }
      return A.SourceSpanWithContext$(start, end, text, context);
    },
    _Highlight__normalizeEndOfLine(span) {
      var text, t1, t2, t3, t4;
      if (span.get$end(span).get$column() !== 0)
        return span;
      if (span.get$end(span).get$line() === span.get$start(span).get$line())
        return span;
      text = B.JSString_methods.substring$2(span.get$text(), 0, span.get$text().length - 1);
      t1 = span.get$start(span);
      t2 = span.get$end(span).get$offset();
      t3 = span.get$sourceUrl(span);
      t4 = span.get$end(span).get$line();
      t3 = A.SourceLocation$(t2 - 1, text.length - B.JSString_methods.lastIndexOf$1(text, "\n") - 1, t4 - 1, t3);
      return A.SourceSpanWithContext$(t1, t3, text, B.JSString_methods.endsWith$1(span.get$context(span), "\n") ? B.JSString_methods.substring$2(span.get$context(span), 0, span.get$context(span).length - 1) : span.get$context(span));
    },
    _Highlight__lastLineLength(text) {
      var t1 = text.length;
      if (t1 === 0)
        return 0;
      else if (text.charCodeAt(t1 - 1) === 10)
        return t1 === 1 ? 0 : t1 - B.JSString_methods.lastIndexOf$2(text, "\n", t1 - 2) - 1;
      else
        return t1 - B.JSString_methods.lastIndexOf$1(text, "\n") - 1;
    },
    Highlighter: function Highlighter(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._lines = t0;
      _._primaryColor = t1;
      _._secondaryColor = t2;
      _._paddingBeforeSidebar = t3;
      _._maxMultilineSpans = t4;
      _._multipleFiles = t5;
      _._highlighter$_buffer = t6;
    },
    Highlighter_closure: function Highlighter_closure(t0) {
      this.color = t0;
    },
    Highlighter$__closure: function Highlighter$__closure() {
    },
    Highlighter$___closure: function Highlighter$___closure() {
    },
    Highlighter$__closure0: function Highlighter$__closure0() {
    },
    Highlighter__collateLines_closure: function Highlighter__collateLines_closure() {
    },
    Highlighter__collateLines_closure0: function Highlighter__collateLines_closure0() {
    },
    Highlighter__collateLines_closure1: function Highlighter__collateLines_closure1() {
    },
    Highlighter__collateLines__closure: function Highlighter__collateLines__closure(t0) {
      this.line = t0;
    },
    Highlighter_highlight_closure: function Highlighter_highlight_closure() {
    },
    Highlighter__writeFileStart_closure: function Highlighter__writeFileStart_closure(t0) {
      this.$this = t0;
    },
    Highlighter__writeMultilineHighlights_closure: function Highlighter__writeMultilineHighlights_closure(t0, t1, t2) {
      this.$this = t0;
      this.startLine = t1;
      this.line = t2;
    },
    Highlighter__writeMultilineHighlights_closure0: function Highlighter__writeMultilineHighlights_closure0(t0, t1) {
      this.$this = t0;
      this.highlight = t1;
    },
    Highlighter__writeMultilineHighlights_closure1: function Highlighter__writeMultilineHighlights_closure1(t0) {
      this.$this = t0;
    },
    Highlighter__writeMultilineHighlights_closure2: function Highlighter__writeMultilineHighlights_closure2(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.current = t2;
      _.startLine = t3;
      _.line = t4;
      _.highlight = t5;
      _.endLine = t6;
    },
    Highlighter__writeMultilineHighlights__closure: function Highlighter__writeMultilineHighlights__closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    Highlighter__writeMultilineHighlights__closure0: function Highlighter__writeMultilineHighlights__closure0(t0, t1) {
      this.$this = t0;
      this.vertical = t1;
    },
    Highlighter__writeHighlightedText_closure: function Highlighter__writeHighlightedText_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.text = t1;
      _.startColumn = t2;
      _.endColumn = t3;
    },
    Highlighter__writeIndicator_closure: function Highlighter__writeIndicator_closure(t0, t1, t2) {
      this.$this = t0;
      this.line = t1;
      this.highlight = t2;
    },
    Highlighter__writeIndicator_closure0: function Highlighter__writeIndicator_closure0(t0, t1, t2) {
      this.$this = t0;
      this.line = t1;
      this.highlight = t2;
    },
    Highlighter__writeIndicator_closure1: function Highlighter__writeIndicator_closure1(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.coversWholeLine = t1;
      _.line = t2;
      _.highlight = t3;
    },
    Highlighter__writeLabel_closure: function Highlighter__writeLabel_closure(t0, t1) {
      this.$this = t0;
      this.lines = t1;
    },
    Highlighter__writeLabel_closure0: function Highlighter__writeLabel_closure0(t0, t1) {
      this.$this = t0;
      this.text = t1;
    },
    Highlighter__writeSidebar_closure: function Highlighter__writeSidebar_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.end = t2;
    },
    _Highlight: function _Highlight(t0, t1, t2) {
      this.span = t0;
      this.isPrimary = t1;
      this.label = t2;
    },
    _Highlight_closure: function _Highlight_closure(t0) {
      this.span = t0;
    },
    _Line: function _Line(t0, t1, t2, t3) {
      var _ = this;
      _.text = t0;
      _.number = t1;
      _.url = t2;
      _.highlights = t3;
    },
    SourceLocation$(offset, column, line, sourceUrl) {
      var t1 = line == null,
        t2 = t1 ? 0 : line,
        t3 = column == null,
        t4 = t3 ? offset : column;
      if (offset < 0)
        A.throwExpression(A.RangeError$("Offset may not be negative, was " + offset + "."));
      else if (!t1 && line < 0)
        A.throwExpression(A.RangeError$("Line may not be negative, was " + A.S(line) + "."));
      else if (!t3 && column < 0)
        A.throwExpression(A.RangeError$("Column may not be negative, was " + A.S(column) + "."));
      return new A.SourceLocation(sourceUrl, offset, t2, t4);
    },
    SourceLocation: function SourceLocation(t0, t1, t2, t3) {
      var _ = this;
      _.sourceUrl = t0;
      _.offset = t1;
      _.line = t2;
      _.column = t3;
    },
    SourceLocationMixin: function SourceLocationMixin() {
    },
    SourceSpanExtension_messageMultiple(_this, message, label, secondarySpans, color, primaryColor, secondaryColor) {
      var t2, t3,
        t1 = _this.get$start(_this);
      t1 = t1.file.getLine$1(t1.offset);
      t2 = _this.get$start(_this);
      t2 = "" + ("line " + (t1 + 1) + ", column " + (t2.file.getColumn$1(t2.offset) + 1));
      if (_this.get$sourceUrl(_this) != null) {
        t1 = _this.get$sourceUrl(_this);
        t3 = $.$get$context();
        t1.toString;
        t1 = t2 + (" of " + t3.prettyUri$1(t1));
      } else
        t1 = t2;
      t1 = t1 + (": " + message + "\n") + A.Highlighter$multiple(_this, label, secondarySpans, color, primaryColor, secondaryColor).highlight$0();
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    SourceSpanBase: function SourceSpanBase() {
    },
    SourceSpanException: function SourceSpanException() {
    },
    SourceSpanFormatException: function SourceSpanFormatException(t0, t1, t2) {
      this.source = t0;
      this._span_exception$_message = t1;
      this._span = t2;
    },
    MultiSourceSpanException: function MultiSourceSpanException() {
    },
    MultiSourceSpanFormatException: function MultiSourceSpanFormatException(t0, t1, t2, t3, t4) {
      var _ = this;
      _.source = t0;
      _.primaryLabel = t1;
      _.secondarySpans = t2;
      _._span_exception$_message = t3;
      _._span = t4;
    },
    SourceSpanMixin: function SourceSpanMixin() {
    },
    SourceSpanWithContext$(start, end, text, _context) {
      var t1 = new A.SourceSpanWithContext(_context, start, end, text);
      t1.SourceSpanBase$3(start, end, text);
      if (!B.JSString_methods.contains$1(_context, text))
        A.throwExpression(A.ArgumentError$('The context line "' + _context + '" must contain "' + text + '".', null));
      if (A.findLineStart(_context, text, start.get$column()) == null)
        A.throwExpression(A.ArgumentError$('The span text "' + text + '" must start at column ' + (start.get$column() + 1) + ' in a line within "' + _context + '".', null));
      return t1;
    },
    SourceSpanWithContext: function SourceSpanWithContext(t0, t1, t2, t3) {
      var _ = this;
      _._context = t0;
      _.start = t1;
      _.end = t2;
      _.text = t3;
    },
    Chain_Chain$parse(chain) {
      var t1, t2,
        _s51_ = string$.x3d_____;
      if (chain.length === 0)
        return new A.Chain(A.List_List$unmodifiable(A._setArrayType([], type$.JSArray_Trace), type$.Trace));
      t1 = $.$get$vmChainGap();
      if (B.JSString_methods.contains$1(chain, t1)) {
        t1 = B.JSString_methods.split$1(chain, t1);
        t2 = A._arrayInstanceType(t1);
        return new A.Chain(A.List_List$unmodifiable(new A.MappedIterable(new A.WhereIterable(t1, new A.Chain_Chain$parse_closure(), t2._eval$1("WhereIterable<1>")), A.trace_Trace___parseVM_tearOff$closure(), t2._eval$1("MappedIterable<1,Trace>")), type$.Trace));
      }
      if (!B.JSString_methods.contains$1(chain, _s51_))
        return new A.Chain(A.List_List$unmodifiable(A._setArrayType([A.Trace_Trace$parse(chain)], type$.JSArray_Trace), type$.Trace));
      return new A.Chain(A.List_List$unmodifiable(new A.MappedListIterable(A._setArrayType(chain.split(_s51_), type$.JSArray_String), A.trace_Trace___parseFriendly_tearOff$closure(), type$.MappedListIterable_String_Trace), type$.Trace));
    },
    Chain: function Chain(t0) {
      this.traces = t0;
    },
    Chain_Chain$parse_closure: function Chain_Chain$parse_closure() {
    },
    Chain_toTrace_closure: function Chain_toTrace_closure() {
    },
    Chain_toString_closure0: function Chain_toString_closure0() {
    },
    Chain_toString__closure0: function Chain_toString__closure0() {
    },
    Chain_toString_closure: function Chain_toString_closure(t0) {
      this.longest = t0;
    },
    Chain_toString__closure: function Chain_toString__closure(t0) {
      this.longest = t0;
    },
    Frame___parseVM_tearOff(frame) {
      return A.Frame_Frame$parseVM(frame);
    },
    Frame_Frame$parseVM(frame) {
      return A.Frame__catchFormatException(frame, new A.Frame_Frame$parseVM_closure(frame));
    },
    Frame___parseV8_tearOff(frame) {
      return A.Frame_Frame$parseV8(frame);
    },
    Frame_Frame$parseV8(frame) {
      return A.Frame__catchFormatException(frame, new A.Frame_Frame$parseV8_closure(frame));
    },
    Frame_Frame$_parseFirefoxEval(frame) {
      return A.Frame__catchFormatException(frame, new A.Frame_Frame$_parseFirefoxEval_closure(frame));
    },
    Frame___parseFirefox_tearOff(frame) {
      return A.Frame_Frame$parseFirefox(frame);
    },
    Frame_Frame$parseFirefox(frame) {
      return A.Frame__catchFormatException(frame, new A.Frame_Frame$parseFirefox_closure(frame));
    },
    Frame___parseFriendly_tearOff(frame) {
      return A.Frame_Frame$parseFriendly(frame);
    },
    Frame_Frame$parseFriendly(frame) {
      return A.Frame__catchFormatException(frame, new A.Frame_Frame$parseFriendly_closure(frame));
    },
    Frame__uriOrPathToUri(uriOrPath) {
      if (B.JSString_methods.contains$1(uriOrPath, $.$get$Frame__uriRegExp()))
        return A.Uri_parse(uriOrPath);
      else if (B.JSString_methods.contains$1(uriOrPath, $.$get$Frame__windowsRegExp()))
        return A._Uri__Uri$file(uriOrPath, true);
      else if (B.JSString_methods.startsWith$1(uriOrPath, "/"))
        return A._Uri__Uri$file(uriOrPath, false);
      if (B.JSString_methods.contains$1(uriOrPath, "\\"))
        return $.$get$windows().toUri$1(uriOrPath);
      return A.Uri_parse(uriOrPath);
    },
    Frame__catchFormatException(text, body) {
      var t1, exception;
      try {
        t1 = body.call$0();
        return t1;
      } catch (exception) {
        if (type$.FormatException._is(A.unwrapException(exception)))
          return new A.UnparsedFrame(A._Uri__Uri(null, "unparsed", null, null), text);
        else
          throw exception;
      }
    },
    Frame: function Frame(t0, t1, t2, t3) {
      var _ = this;
      _.uri = t0;
      _.line = t1;
      _.column = t2;
      _.member = t3;
    },
    Frame_Frame$parseVM_closure: function Frame_Frame$parseVM_closure(t0) {
      this.frame = t0;
    },
    Frame_Frame$parseV8_closure: function Frame_Frame$parseV8_closure(t0) {
      this.frame = t0;
    },
    Frame_Frame$parseV8_closure_parseLocation: function Frame_Frame$parseV8_closure_parseLocation(t0) {
      this.frame = t0;
    },
    Frame_Frame$_parseFirefoxEval_closure: function Frame_Frame$_parseFirefoxEval_closure(t0) {
      this.frame = t0;
    },
    Frame_Frame$parseFirefox_closure: function Frame_Frame$parseFirefox_closure(t0) {
      this.frame = t0;
    },
    Frame_Frame$parseFriendly_closure: function Frame_Frame$parseFriendly_closure(t0) {
      this.frame = t0;
    },
    LazyTrace: function LazyTrace(t0) {
      this._thunk = t0;
      this.__LazyTrace__trace_FI = $;
    },
    LazyTrace_terse_closure: function LazyTrace_terse_closure(t0) {
      this.$this = t0;
    },
    Trace_Trace$from(trace) {
      if (type$.Trace._is(trace))
        return trace;
      if (trace instanceof A.Chain)
        return trace.toTrace$0();
      return new A.LazyTrace(new A.Trace_Trace$from_closure(trace));
    },
    Trace_Trace$parse(trace) {
      var error, t1, exception;
      try {
        if (trace.length === 0) {
          t1 = A.Trace$(A._setArrayType([], type$.JSArray_Frame), null);
          return t1;
        }
        if (B.JSString_methods.contains$1(trace, $.$get$_v8Trace())) {
          t1 = A.Trace$parseV8(trace);
          return t1;
        }
        if (B.JSString_methods.contains$1(trace, "\tat ")) {
          t1 = A.Trace$parseJSCore(trace);
          return t1;
        }
        if (B.JSString_methods.contains$1(trace, $.$get$_firefoxSafariTrace()) || B.JSString_methods.contains$1(trace, $.$get$_firefoxEvalTrace())) {
          t1 = A.Trace$parseFirefox(trace);
          return t1;
        }
        if (B.JSString_methods.contains$1(trace, string$.x3d_____)) {
          t1 = A.Chain_Chain$parse(trace).toTrace$0();
          return t1;
        }
        if (B.JSString_methods.contains$1(trace, $.$get$_friendlyTrace())) {
          t1 = A.Trace$parseFriendly(trace);
          return t1;
        }
        t1 = A.Trace$parseVM(trace);
        return t1;
      } catch (exception) {
        t1 = A.unwrapException(exception);
        if (type$.FormatException._is(t1)) {
          error = t1;
          throw A.wrapException(A.FormatException$(J.get$message$x(error) + "\nStack trace:\n" + trace, null, null));
        } else
          throw exception;
      }
    },
    Trace___parseVM_tearOff(trace) {
      return A.Trace$parseVM(trace);
    },
    Trace$parseVM(trace) {
      var t1 = A.List_List$unmodifiable(A.Trace__parseVM(trace), type$.Frame);
      return new A.Trace(t1, new A._StringStackTrace(trace));
    },
    Trace__parseVM(trace) {
      var $frames,
        t1 = B.JSString_methods.trim$0(trace),
        t2 = $.$get$vmChainGap(),
        t3 = type$.WhereIterable_String,
        lines = new A.WhereIterable(A._setArrayType(A.stringReplaceAllUnchecked(t1, t2, "").split("\n"), type$.JSArray_String), new A.Trace__parseVM_closure(), t3);
      if (!lines.get$iterator(0).moveNext$0())
        return A._setArrayType([], type$.JSArray_Frame);
      t1 = A.TakeIterable_TakeIterable(lines, lines.get$length(0) - 1, t3._eval$1("Iterable.E"));
      t1 = A.MappedIterable_MappedIterable(t1, A.frame_Frame___parseVM_tearOff$closure(), A._instanceType(t1)._eval$1("Iterable.E"), type$.Frame);
      $frames = A.List_List$of(t1, true, A._instanceType(t1)._eval$1("Iterable.E"));
      if (!J.endsWith$1$s(lines.get$last(0), ".da"))
        B.JSArray_methods.add$1($frames, A.Frame_Frame$parseVM(lines.get$last(0)));
      return $frames;
    },
    Trace$parseV8(trace) {
      var t1 = A.SubListIterable$(A._setArrayType(trace.split("\n"), type$.JSArray_String), 1, null, type$.String).super$Iterable$skipWhile(0, new A.Trace$parseV8_closure()),
        t2 = type$.Frame;
      t2 = A.List_List$unmodifiable(A.MappedIterable_MappedIterable(t1, A.frame_Frame___parseV8_tearOff$closure(), t1.$ti._eval$1("Iterable.E"), t2), t2);
      return new A.Trace(t2, new A._StringStackTrace(trace));
    },
    Trace$parseJSCore(trace) {
      var t1 = A.List_List$unmodifiable(new A.MappedIterable(new A.WhereIterable(A._setArrayType(trace.split("\n"), type$.JSArray_String), new A.Trace$parseJSCore_closure(), type$.WhereIterable_String), A.frame_Frame___parseV8_tearOff$closure(), type$.MappedIterable_String_Frame), type$.Frame);
      return new A.Trace(t1, new A._StringStackTrace(trace));
    },
    Trace$parseFirefox(trace) {
      var t1 = A.List_List$unmodifiable(new A.MappedIterable(new A.WhereIterable(A._setArrayType(B.JSString_methods.trim$0(trace).split("\n"), type$.JSArray_String), new A.Trace$parseFirefox_closure(), type$.WhereIterable_String), A.frame_Frame___parseFirefox_tearOff$closure(), type$.MappedIterable_String_Frame), type$.Frame);
      return new A.Trace(t1, new A._StringStackTrace(trace));
    },
    Trace___parseFriendly_tearOff(trace) {
      return A.Trace$parseFriendly(trace);
    },
    Trace$parseFriendly(trace) {
      var t1 = trace.length === 0 ? A._setArrayType([], type$.JSArray_Frame) : new A.MappedIterable(new A.WhereIterable(A._setArrayType(B.JSString_methods.trim$0(trace).split("\n"), type$.JSArray_String), new A.Trace$parseFriendly_closure(), type$.WhereIterable_String), A.frame_Frame___parseFriendly_tearOff$closure(), type$.MappedIterable_String_Frame);
      t1 = A.List_List$unmodifiable(t1, type$.Frame);
      return new A.Trace(t1, new A._StringStackTrace(trace));
    },
    Trace$($frames, original) {
      var t1 = A.List_List$unmodifiable($frames, type$.Frame);
      return new A.Trace(t1, new A._StringStackTrace(original == null ? "" : original));
    },
    Trace: function Trace(t0, t1) {
      this.frames = t0;
      this.original = t1;
    },
    Trace_Trace$from_closure: function Trace_Trace$from_closure(t0) {
      this.trace = t0;
    },
    Trace__parseVM_closure: function Trace__parseVM_closure() {
    },
    Trace$parseV8_closure: function Trace$parseV8_closure() {
    },
    Trace$parseJSCore_closure: function Trace$parseJSCore_closure() {
    },
    Trace$parseFirefox_closure: function Trace$parseFirefox_closure() {
    },
    Trace$parseFriendly_closure: function Trace$parseFriendly_closure() {
    },
    Trace_terse_closure: function Trace_terse_closure() {
    },
    Trace_foldFrames_closure: function Trace_foldFrames_closure(t0) {
      this.oldPredicate = t0;
    },
    Trace_foldFrames_closure0: function Trace_foldFrames_closure0(t0) {
      this._box_0 = t0;
    },
    Trace_toString_closure0: function Trace_toString_closure0() {
    },
    Trace_toString_closure: function Trace_toString_closure(t0) {
      this.longest = t0;
    },
    UnparsedFrame: function UnparsedFrame(t0, t1) {
      this.uri = t0;
      this.member = t1;
    },
    TransformByHandlers_transformByHandlers(_this, onData, onDone, $S, $T) {
      var _null = null, t1 = {},
        controller = A.StreamController_StreamController(_null, _null, _null, _null, true, $T);
      t1.subscription = null;
      controller.onListen = new A.TransformByHandlers_transformByHandlers_closure(t1, _this, onData, controller, A.instantiate1(A.from_handlers__TransformByHandlers__defaultHandleError$closure(), $T), onDone, $S);
      return controller.get$stream();
    },
    TransformByHandlers__defaultHandleError(error, stackTrace, sink) {
      sink.addError$2(error, stackTrace);
    },
    TransformByHandlers_transformByHandlers_closure: function TransformByHandlers_transformByHandlers_closure(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._box_1 = t0;
      _._this = t1;
      _.handleData = t2;
      _.controller = t3;
      _.handleError = t4;
      _.handleDone = t5;
      _.S = t6;
    },
    TransformByHandlers_transformByHandlers__closure: function TransformByHandlers_transformByHandlers__closure(t0, t1, t2) {
      this.handleData = t0;
      this.controller = t1;
      this.S = t2;
    },
    TransformByHandlers_transformByHandlers__closure1: function TransformByHandlers_transformByHandlers__closure1(t0, t1) {
      this.handleError = t0;
      this.controller = t1;
    },
    TransformByHandlers_transformByHandlers__closure0: function TransformByHandlers_transformByHandlers__closure0(t0, t1, t2) {
      this._box_0 = t0;
      this.handleDone = t1;
      this.controller = t2;
    },
    TransformByHandlers_transformByHandlers__closure2: function TransformByHandlers_transformByHandlers__closure2(t0, t1) {
      this._box_1 = t0;
      this._box_0 = t1;
    },
    RateLimit__debounceAggregate(_this, duration, collect, leading, trailing, $T, $S) {
      var t1 = {};
      t1.soFar = t1.timer = null;
      t1.emittedLatestAsLeading = t1.shouldClose = t1.hasPending = false;
      return A.TransformByHandlers_transformByHandlers(_this, new A.RateLimit__debounceAggregate_closure(t1, $S, collect, false, duration, true, $T), new A.RateLimit__debounceAggregate_closure0(t1, true, $S), $T, $S);
    },
    _collect($event, soFar, $T) {
      var t1 = soFar == null ? A._setArrayType([], $T._eval$1("JSArray<0>")) : soFar;
      J.add$1$ax(t1, $event);
      return t1;
    },
    RateLimit__debounceAggregate_closure: function RateLimit__debounceAggregate_closure(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._box_0 = t0;
      _.S = t1;
      _.collect = t2;
      _.leading = t3;
      _.duration = t4;
      _.trailing = t5;
      _.T = t6;
    },
    RateLimit__debounceAggregate_closure_emit: function RateLimit__debounceAggregate_closure_emit(t0, t1, t2) {
      this._box_0 = t0;
      this.sink = t1;
      this.S = t2;
    },
    RateLimit__debounceAggregate__closure: function RateLimit__debounceAggregate__closure(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.trailing = t1;
      _.emit = t2;
      _.sink = t3;
    },
    RateLimit__debounceAggregate_closure0: function RateLimit__debounceAggregate_closure0(t0, t1, t2) {
      this._box_0 = t0;
      this.trailing = t1;
      this.S = t2;
    },
    StringScannerException$(message, span, source) {
      return new A.StringScannerException(source, message, span);
    },
    StringScannerException: function StringScannerException(t0, t1, t2) {
      this.source = t0;
      this._span_exception$_message = t1;
      this._span = t2;
    },
    LineScanner$(string) {
      return new A.LineScanner(null, string);
    },
    LineScanner: function LineScanner(t0, t1) {
      var _ = this;
      _._line_scanner$_column = _._line_scanner$_line = 0;
      _.sourceUrl = t0;
      _.string = t1;
      _._string_scanner$_position = 0;
      _._lastMatchPosition = _._lastMatch = null;
    },
    SpanScanner$(string, sourceUrl) {
      var t2,
        t1 = A.SourceFile$fromString(string, sourceUrl);
      if (sourceUrl == null)
        t2 = null;
      else
        t2 = typeof sourceUrl == "string" ? A.Uri_parse(sourceUrl) : type$.Uri._as(sourceUrl);
      return new A.SpanScanner(t1, t2, string);
    },
    SpanScanner: function SpanScanner(t0, t1, t2) {
      var _ = this;
      _._sourceFile = t0;
      _.sourceUrl = t1;
      _.string = t2;
      _._string_scanner$_position = 0;
      _._lastMatchPosition = _._lastMatch = null;
    },
    _SpanScannerState: function _SpanScannerState(t0, t1) {
      this._scanner = t0;
      this.position = t1;
    },
    StringScanner$(string, position, sourceUrl) {
      var t1;
      if (sourceUrl == null)
        t1 = null;
      else
        t1 = typeof sourceUrl == "string" ? A.Uri_parse(sourceUrl) : type$.Uri._as(sourceUrl);
      return new A.StringScanner(t1, string);
    },
    StringScanner: function StringScanner(t0, t1) {
      var _ = this;
      _.sourceUrl = t0;
      _.string = t1;
      _._string_scanner$_position = 0;
      _._lastMatchPosition = _._lastMatch = null;
    },
    AsciiGlyphSet: function AsciiGlyphSet() {
    },
    UnicodeGlyphSet: function UnicodeGlyphSet() {
    },
    WatchEvent: function WatchEvent(t0, t1) {
      this.type = t0;
      this.path = t1;
    },
    ChangeType: function ChangeType(t0) {
      this._watch_event$_name = t0;
    },
    AnySelectorVisitor0: function AnySelectorVisitor0() {
    },
    AnySelectorVisitor_visitComplexSelector_closure0: function AnySelectorVisitor_visitComplexSelector_closure0(t0) {
      this.$this = t0;
    },
    AnySelectorVisitor_visitCompoundSelector_closure0: function AnySelectorVisitor_visitCompoundSelector_closure0(t0) {
      this.$this = t0;
    },
    SupportsAnything0: function SupportsAnything0(t0, t1) {
      this.contents = t0;
      this.span = t1;
    },
    Argument0: function Argument0(t0, t1, t2) {
      this.name = t0;
      this.defaultValue = t1;
      this.span = t2;
    },
    ArgumentDeclaration_ArgumentDeclaration$parse0(contents, url) {
      return A.ScssParser$0(contents, null, url).parseArgumentDeclaration$0();
    },
    ArgumentDeclaration0: function ArgumentDeclaration0(t0, t1, t2) {
      this.$arguments = t0;
      this.restArgument = t1;
      this.span = t2;
    },
    ArgumentDeclaration_verify_closure1: function ArgumentDeclaration_verify_closure1() {
    },
    ArgumentDeclaration_verify_closure2: function ArgumentDeclaration_verify_closure2() {
    },
    ArgumentInvocation$empty0(span) {
      return new A.ArgumentInvocation0(B.List_empty20, B.Map_empty14, null, null, span);
    },
    ArgumentInvocation0: function ArgumentInvocation0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.positional = t0;
      _.named = t1;
      _.rest = t2;
      _.keywordRest = t3;
      _.span = t4;
    },
    argumentListClass_closure: function argumentListClass_closure() {
    },
    argumentListClass__closure: function argumentListClass__closure() {
    },
    argumentListClass__closure0: function argumentListClass__closure0() {
    },
    SassArgumentList$0(contents, keywords, separator) {
      var t1 = type$.Value_2;
      t1 = new A.SassArgumentList0(A.ConstantMap_ConstantMap$from(keywords, type$.String, t1), A.List_List$unmodifiable(contents, t1), separator, false);
      t1.SassList$3$brackets0(contents, separator, false);
      return t1;
    },
    SassArgumentList0: function SassArgumentList0(t0, t1, t2, t3) {
      var _ = this;
      _._argument_list$_keywords = t0;
      _._argument_list$_wereKeywordsAccessed = false;
      _._list1$_contents = t1;
      _._list1$_separator = t2;
      _._list1$_hasBrackets = t3;
    },
    JSArray1: function JSArray1() {
    },
    AsyncImporter0: function AsyncImporter0() {
    },
    JSToDartAsyncImporter: function JSToDartAsyncImporter(t0, t1, t2) {
      this._async0$_canonicalize = t0;
      this._load = t1;
      this._nonCanonicalSchemes = t2;
    },
    JSToDartAsyncImporter_canonicalize_closure: function JSToDartAsyncImporter_canonicalize_closure(t0, t1) {
      this.$this = t0;
      this.url = t1;
    },
    JSToDartAsyncImporter_load_closure: function JSToDartAsyncImporter_load_closure(t0, t1) {
      this.$this = t0;
      this.url = t1;
    },
    AsyncBuiltInCallable$mixin0($name, $arguments, callback, acceptsContent, url) {
      return new A.AsyncBuiltInCallable0($name, A.ScssParser$0("@mixin " + $name + "(" + $arguments + ") {", null, url).parseArgumentDeclaration$0(), new A.AsyncBuiltInCallable$mixin_closure0(callback), false);
    },
    AsyncBuiltInCallable0: function AsyncBuiltInCallable0(t0, t1, t2, t3) {
      var _ = this;
      _.name = t0;
      _._async_built_in0$_arguments = t1;
      _._async_built_in0$_callback = t2;
      _.acceptsContent = t3;
    },
    AsyncBuiltInCallable$mixin_closure0: function AsyncBuiltInCallable$mixin_closure0(t0) {
      this.callback = t0;
    },
    compileAsync0(path, charset, fatalDeprecations, functions, futureDeprecations, importCache, indentWidth, lineFeed, logger, nodeImporter, quietDeps, silenceDeprecations, sourceMap, style, syntax, useSpaces, verbose) {
      var $async$goto = 0,
        $async$completer = A._makeAsyncAwaitCompleter(type$.CompileResult_2),
        $async$returnValue, t3, t4, t0, stylesheet, result, t1, t2;
      var $async$compileAsync0 = A._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return A._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = type$.Deprecation_3;
              t2 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
              if (silenceDeprecations != null)
                t2.addAll$1(0, silenceDeprecations);
              t3 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
              if (fatalDeprecations != null)
                t3.addAll$1(0, fatalDeprecations);
              t1 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
              if (futureDeprecations != null)
                t1.addAll$1(0, futureDeprecations);
              logger = A.DeprecationProcessingLogger$0(logger, t3, t1, !verbose, t2);
              t1 = nodeImporter == null;
              if (t1)
                t2 = syntax == null || syntax === A.Syntax_forPath0(path);
              else
                t2 = false;
              $async$goto = t2 ? 3 : 5;
              break;
            case 3:
              // then
              if (importCache == null)
                importCache = A.AsyncImportCache$none(logger);
              t2 = $.$get$FilesystemImporter_cwd0();
              t3 = A.isNodeJs() ? self.process : null;
              if (!J.$eq$(t3 == null ? null : J.get$platform$x(t3), "win32")) {
                t3 = A.isNodeJs() ? self.process : null;
                t3 = J.$eq$(t3 == null ? null : J.get$platform$x(t3), "darwin");
              } else
                t3 = true;
              if (t3) {
                t3 = $.$get$context();
                t4 = A._realCasePath0(A.absolute(t3.normalize$1(path), null, null, null, null, null, null, null, null, null, null, null, null, null, null));
                t0 = t4;
                t4 = t3;
                t3 = t0;
              } else {
                t3 = $.$get$context();
                t4 = t3.canonicalize$1(0, path);
                t0 = t4;
                t4 = t3;
                t3 = t0;
              }
              $async$goto = 6;
              return A._asyncAwait(importCache.importCanonical$3$originalUrl(t2, t4.toUri$1(t3), t4.toUri$1(path)), $async$compileAsync0);
            case 6:
              // returning from await.
              t4 = $async$result;
              t4.toString;
              stylesheet = t4;
              // goto join
              $async$goto = 4;
              break;
            case 5:
              // else
              t2 = A.readFile0(path);
              t3 = syntax == null ? A.Syntax_forPath0(path) : syntax;
              stylesheet = A.Stylesheet_Stylesheet$parse0(t2, t3, logger, $.$get$context().toUri$1(path));
            case 4:
              // join
              $async$goto = 7;
              return A._asyncAwait(A._compileStylesheet2(stylesheet, logger, importCache, nodeImporter, $.$get$FilesystemImporter_cwd0(), functions, style, useSpaces, indentWidth, lineFeed, quietDeps, sourceMap, charset), $async$compileAsync0);
            case 7:
              // returning from await.
              result = $async$result;
              logger.summarize$1$js(!t1);
              $async$returnValue = result;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return A._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return A._asyncStartSync($async$compileAsync0, $async$completer);
    },
    compileStringAsync0(source, charset, fatalDeprecations, functions, futureDeprecations, importCache, importer, indentWidth, lineFeed, logger, nodeImporter, quietDeps, silenceDeprecations, sourceMap, style, syntax, url, useSpaces, verbose) {
      var $async$goto = 0,
        $async$completer = A._makeAsyncAwaitCompleter(type$.CompileResult_2),
        $async$returnValue, t3, stylesheet, result, t1, t2;
      var $async$compileStringAsync0 = A._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return A._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = type$.Deprecation_3;
              t2 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
              if (silenceDeprecations != null)
                t2.addAll$1(0, silenceDeprecations);
              t3 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
              if (fatalDeprecations != null)
                t3.addAll$1(0, fatalDeprecations);
              t1 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
              if (futureDeprecations != null)
                t1.addAll$1(0, futureDeprecations);
              logger = A.DeprecationProcessingLogger$0(logger, t3, t1, !verbose, t2);
              stylesheet = A.Stylesheet_Stylesheet$parse0(source, syntax == null ? B.Syntax_SCSS_scss0 : syntax, logger, url);
              if (importer == null)
                t1 = A.isBrowser() ? new A.NoOpImporter0() : $.$get$FilesystemImporter_cwd0();
              else
                t1 = importer;
              $async$goto = 3;
              return A._asyncAwait(A._compileStylesheet2(stylesheet, logger, importCache, nodeImporter, t1, functions, style, useSpaces, indentWidth, lineFeed, quietDeps, sourceMap, charset), $async$compileStringAsync0);
            case 3:
              // returning from await.
              result = $async$result;
              logger.summarize$1$js(nodeImporter != null);
              $async$returnValue = result;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return A._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return A._asyncStartSync($async$compileStringAsync0, $async$completer);
    },
    _compileStylesheet2(stylesheet, logger, importCache, nodeImporter, importer, functions, style, useSpaces, indentWidth, lineFeed, quietDeps, sourceMap, charset) {
      var $async$goto = 0,
        $async$completer = A._makeAsyncAwaitCompleter(type$.CompileResult_2),
        $async$returnValue, evaluateResult, serializeResult, resultSourceMap;
      var $async$_compileStylesheet2 = A._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return A._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              $async$goto = 3;
              return A._asyncAwait(A._EvaluateVisitor$2(functions, importCache, logger, nodeImporter, quietDeps, sourceMap).run$2(0, importer, stylesheet), $async$_compileStylesheet2);
            case 3:
              // returning from await.
              evaluateResult = $async$result;
              serializeResult = A.serialize0(evaluateResult._1, charset, indentWidth, false, lineFeed, sourceMap, style, useSpaces);
              resultSourceMap = serializeResult._1;
              if (resultSourceMap != null && importCache != null)
                A.mapInPlace0(resultSourceMap.urls, new A._compileStylesheet_closure2(stylesheet, importCache));
              $async$returnValue = new A.CompileResult0(evaluateResult, serializeResult);
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return A._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return A._asyncStartSync($async$_compileStylesheet2, $async$completer);
    },
    _compileStylesheet_closure2: function _compileStylesheet_closure2(t0, t1) {
      this.stylesheet = t0;
      this.importCache = t1;
    },
    AsyncEnvironment$0() {
      var t1 = type$.String,
        t2 = type$.Module_AsyncCallable_2,
        t3 = type$.AstNode_2,
        t4 = type$.int,
        t5 = type$.AsyncCallable_2,
        t6 = type$.JSArray_Map_String_AsyncCallable_2;
      return new A.AsyncEnvironment0(A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), A.LinkedHashMap_LinkedHashMap$_empty(t1, t3), A.LinkedHashMap_LinkedHashMap$_empty(t2, t3), A.LinkedHashMap_LinkedHashMap$_empty(t2, t3), null, null, A._setArrayType([], type$.JSArray_Module_AsyncCallable_2), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Value_2)], type$.JSArray_Map_String_Value_2), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, t3)], type$.JSArray_Map_String_AstNode_2), A.LinkedHashMap_LinkedHashMap$_empty(t1, t4), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), A.LinkedHashMap_LinkedHashMap$_empty(t1, t4), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), A.LinkedHashMap_LinkedHashMap$_empty(t1, t4), null);
    },
    AsyncEnvironment$_0(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, _functions, _mixins, _content) {
      var t1 = type$.String,
        t2 = type$.int;
      return new A.AsyncEnvironment0(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _functions, A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _mixins, A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _content);
    },
    _EnvironmentModule__EnvironmentModule2(environment, css, preModuleComments, extensionStore, forwarded) {
      var t1, t2, t3, t4, t5, t6, module, result, t7;
      if (forwarded == null)
        forwarded = B.Set_empty6;
      t1 = type$.dynamic;
      t1 = A.LinkedHashMap_LinkedHashMap$_empty(t1, t1);
      for (t2 = type$.Module_AsyncCallable_2, t3 = type$.List_CssComment_2, t4 = A.MapExtensions_get_pairs0(preModuleComments, t2, t3), t4 = t4.get$iterator(t4), t5 = type$.CssComment_2; t4.moveNext$0();) {
        t6 = t4.get$current(t4);
        module = t6._0;
        result = A.List_List$from(t6._1, false, t5);
        result.fixed$length = Array;
        result.immutable$list = Array;
        t1.$indexSet(0, module, result);
      }
      t1 = A.ConstantMap_ConstantMap$from(t1, t2, t3);
      t2 = A._EnvironmentModule__makeModulesByVariable2(forwarded);
      t3 = A._EnvironmentModule__memberMap2(B.JSArray_methods.get$first(environment._async_environment0$_variables), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure17(), type$.Map_String_Value_2), type$.Value_2);
      t4 = A._EnvironmentModule__memberMap2(B.JSArray_methods.get$first(environment._async_environment0$_variableNodes), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure18(), type$.Map_String_AstNode_2), type$.AstNode_2);
      t5 = type$.Map_String_AsyncCallable_2;
      t6 = type$.AsyncCallable_2;
      t7 = A._EnvironmentModule__memberMap2(B.JSArray_methods.get$first(environment._async_environment0$_functions), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure19(), t5), t6);
      t6 = A._EnvironmentModule__memberMap2(B.JSArray_methods.get$first(environment._async_environment0$_mixins), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure20(), t5), t6);
      t5 = J.get$isNotEmpty$asx(css.get$children(css)) || preModuleComments.get$isNotEmpty(preModuleComments) || B.JSArray_methods.any$1(environment._async_environment0$_allModules, new A._EnvironmentModule__EnvironmentModule_closure21());
      return A._EnvironmentModule$_2(environment, css, t1, extensionStore, t2, t3, t4, t7, t6, t5, !extensionStore.get$isEmpty(extensionStore) || B.JSArray_methods.any$1(environment._async_environment0$_allModules, new A._EnvironmentModule__EnvironmentModule_closure22()));
    },
    _EnvironmentModule__makeModulesByVariable2(forwarded) {
      var modulesByVariable, t1, t2, t3, t4, t5;
      if (forwarded.get$isEmpty(forwarded))
        return B.Map_empty16;
      modulesByVariable = A.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.Module_AsyncCallable_2);
      for (t1 = forwarded.get$iterator(forwarded); t1.moveNext$0();) {
        t2 = t1.get$current(t1);
        if (t2 instanceof A._EnvironmentModule2) {
          for (t3 = t2._async_environment0$_modulesByVariable, t3 = t3.get$values(t3), t3 = t3.get$iterator(t3); t3.moveNext$0();) {
            t4 = t3.get$current(t3);
            t5 = t4.get$variables();
            A.setAll0(modulesByVariable, t5.get$keys(t5), t4);
          }
          A.setAll0(modulesByVariable, J.get$keys$z(B.JSArray_methods.get$first(t2._async_environment0$_environment._async_environment0$_variables)), t2);
        } else {
          t3 = t2.get$variables();
          A.setAll0(modulesByVariable, t3.get$keys(t3), t2);
        }
      }
      return modulesByVariable;
    },
    _EnvironmentModule__memberMap2(localMap, otherMaps, $V) {
      var t1, t2, t3;
      localMap = new A.PublicMemberMapView0(localMap, $V._eval$1("PublicMemberMapView0<0>"));
      if (otherMaps.get$isEmpty(otherMaps))
        return localMap;
      t1 = A._setArrayType([], $V._eval$1("JSArray<Map<String,0>>"));
      for (t2 = otherMaps.get$iterator(otherMaps); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        if (t3.get$isNotEmpty(t3))
          t1.push(t3);
      }
      t1.push(localMap);
      if (t1.length === 1)
        return localMap;
      return A.MergedMapView$0(t1, type$.String, $V);
    },
    _EnvironmentModule$_2(_environment, css, preModuleComments, extensionStore, _modulesByVariable, variables, variableNodes, functions, mixins, transitivelyContainsCss, transitivelyContainsExtensions) {
      return new A._EnvironmentModule2(_environment._async_environment0$_allModules, variables, variableNodes, functions, mixins, extensionStore, css, preModuleComments, transitivelyContainsCss, transitivelyContainsExtensions, _environment, _modulesByVariable);
    },
    AsyncEnvironment0: function AsyncEnvironment0(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) {
      var _ = this;
      _._async_environment0$_modules = t0;
      _._async_environment0$_namespaceNodes = t1;
      _._async_environment0$_globalModules = t2;
      _._async_environment0$_importedModules = t3;
      _._async_environment0$_forwardedModules = t4;
      _._async_environment0$_nestedForwardedModules = t5;
      _._async_environment0$_allModules = t6;
      _._async_environment0$_variables = t7;
      _._async_environment0$_variableNodes = t8;
      _._async_environment0$_variableIndices = t9;
      _._async_environment0$_functions = t10;
      _._async_environment0$_functionIndices = t11;
      _._async_environment0$_mixins = t12;
      _._async_environment0$_mixinIndices = t13;
      _._async_environment0$_content = t14;
      _._async_environment0$_inMixin = false;
      _._async_environment0$_inSemiGlobalScope = true;
      _._async_environment0$_lastVariableIndex = _._async_environment0$_lastVariableName = null;
    },
    AsyncEnvironment__getVariableFromGlobalModule_closure0: function AsyncEnvironment__getVariableFromGlobalModule_closure0(t0) {
      this.name = t0;
    },
    AsyncEnvironment_setVariable_closure2: function AsyncEnvironment_setVariable_closure2(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    AsyncEnvironment_setVariable_closure3: function AsyncEnvironment_setVariable_closure3(t0) {
      this.name = t0;
    },
    AsyncEnvironment_setVariable_closure4: function AsyncEnvironment_setVariable_closure4(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    AsyncEnvironment__getFunctionFromGlobalModule_closure0: function AsyncEnvironment__getFunctionFromGlobalModule_closure0(t0) {
      this.name = t0;
    },
    AsyncEnvironment__getMixinFromGlobalModule_closure0: function AsyncEnvironment__getMixinFromGlobalModule_closure0(t0) {
      this.name = t0;
    },
    AsyncEnvironment_toModule_closure0: function AsyncEnvironment_toModule_closure0() {
    },
    AsyncEnvironment_toDummyModule_closure0: function AsyncEnvironment_toDummyModule_closure0() {
    },
    _EnvironmentModule2: function _EnvironmentModule2(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11) {
      var _ = this;
      _.upstream = t0;
      _.variables = t1;
      _.variableNodes = t2;
      _.functions = t3;
      _.mixins = t4;
      _.extensionStore = t5;
      _.css = t6;
      _.preModuleComments = t7;
      _.transitivelyContainsCss = t8;
      _.transitivelyContainsExtensions = t9;
      _._async_environment0$_environment = t10;
      _._async_environment0$_modulesByVariable = t11;
    },
    _EnvironmentModule__EnvironmentModule_closure17: function _EnvironmentModule__EnvironmentModule_closure17() {
    },
    _EnvironmentModule__EnvironmentModule_closure18: function _EnvironmentModule__EnvironmentModule_closure18() {
    },
    _EnvironmentModule__EnvironmentModule_closure19: function _EnvironmentModule__EnvironmentModule_closure19() {
    },
    _EnvironmentModule__EnvironmentModule_closure20: function _EnvironmentModule__EnvironmentModule_closure20() {
    },
    _EnvironmentModule__EnvironmentModule_closure21: function _EnvironmentModule__EnvironmentModule_closure21() {
    },
    _EnvironmentModule__EnvironmentModule_closure22: function _EnvironmentModule__EnvironmentModule_closure22() {
    },
    _EvaluateVisitor$2(functions, importCache, logger, nodeImporter, quietDeps, sourceMap) {
      var t4,
        t1 = type$.Uri,
        t2 = type$.Module_AsyncCallable_2,
        t3 = A._setArrayType([], type$.JSArray_Record_2_String_and_AstNode_2);
      if (importCache == null)
        t4 = nodeImporter == null ? A.AsyncImportCache$none(logger) : null;
      else
        t4 = importCache;
      t1 = new A._EvaluateVisitor2(t4, nodeImporter, A.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.AsyncCallable_2), A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Configuration_2), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.AstNode_2), logger, A.LinkedHashSet_LinkedHashSet$_empty(type$.Record_2_String_and_SourceSpan), quietDeps, sourceMap, A.AsyncEnvironment$0(), A.LinkedHashSet_LinkedHashSet$_empty(t1), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.nullable_AstNode_2), t3, B.Configuration_Map_empty_null0);
      t1._EvaluateVisitor$6$functions$importCache$logger$nodeImporter$quietDeps$sourceMap2(functions, importCache, logger, nodeImporter, quietDeps, sourceMap);
      return t1;
    },
    _EvaluateVisitor2: function _EvaluateVisitor2(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15) {
      var _ = this;
      _._async_evaluate0$_importCache = t0;
      _._async_evaluate0$_nodeImporter = t1;
      _._async_evaluate0$_builtInFunctions = t2;
      _._async_evaluate0$_builtInModules = t3;
      _._async_evaluate0$_modules = t4;
      _._async_evaluate0$_moduleConfigurations = t5;
      _._async_evaluate0$_moduleNodes = t6;
      _._async_evaluate0$_logger = t7;
      _._async_evaluate0$_warningsEmitted = t8;
      _._async_evaluate0$_quietDeps = t9;
      _._async_evaluate0$_sourceMap = t10;
      _._async_evaluate0$_environment = t11;
      _._async_evaluate0$_declarationName = _._async_evaluate0$__parent = _._async_evaluate0$_mediaQuerySources = _._async_evaluate0$_mediaQueries = _._async_evaluate0$_styleRuleIgnoringAtRoot = null;
      _._async_evaluate0$_member = "root stylesheet";
      _._async_evaluate0$_importSpan = _._async_evaluate0$_callableNode = _._async_evaluate0$_currentCallable = null;
      _._async_evaluate0$_inSupportsDeclaration = _._async_evaluate0$_inKeyframes = _._async_evaluate0$_atRootExcludingStyleRule = _._async_evaluate0$_inUnknownAtRule = _._async_evaluate0$_inFunction = false;
      _._async_evaluate0$_loadedUrls = t12;
      _._async_evaluate0$_activeModules = t13;
      _._async_evaluate0$_stack = t14;
      _._async_evaluate0$_importer = null;
      _._async_evaluate0$_inDependency = false;
      _._async_evaluate0$__extensionStore = _._async_evaluate0$_preModuleComments = _._async_evaluate0$_outOfOrderImports = _._async_evaluate0$__endOfImports = _._async_evaluate0$__root = _._async_evaluate0$__stylesheet = null;
      _._async_evaluate0$_configuration = t15;
    },
    _EvaluateVisitor_closure38: function _EvaluateVisitor_closure38(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure39: function _EvaluateVisitor_closure39(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure40: function _EvaluateVisitor_closure40(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure41: function _EvaluateVisitor_closure41(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure42: function _EvaluateVisitor_closure42(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure43: function _EvaluateVisitor_closure43(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure44: function _EvaluateVisitor_closure44(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure45: function _EvaluateVisitor_closure45(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure46: function _EvaluateVisitor_closure46(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure14: function _EvaluateVisitor__closure14(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.module = t2;
    },
    _EvaluateVisitor_closure47: function _EvaluateVisitor_closure47(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure13: function _EvaluateVisitor__closure13(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.module = t2;
    },
    _EvaluateVisitor_closure48: function _EvaluateVisitor_closure48(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure49: function _EvaluateVisitor_closure49(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure11: function _EvaluateVisitor__closure11(t0, t1, t2) {
      this.values = t0;
      this.span = t1;
      this.callableNode = t2;
    },
    _EvaluateVisitor__closure12: function _EvaluateVisitor__closure12(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure50: function _EvaluateVisitor_closure50(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_run_closure2: function _EvaluateVisitor_run_closure2(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.importer = t2;
    },
    _EvaluateVisitor_run__closure2: function _EvaluateVisitor_run__closure2(t0, t1, t2) {
      this.$this = t0;
      this.importer = t1;
      this.node = t2;
    },
    _EvaluateVisitor__loadModule_closure5: function _EvaluateVisitor__loadModule_closure5(t0, t1) {
      this._box_1 = t0;
      this.callback = t1;
    },
    _EvaluateVisitor__loadModule_closure6: function _EvaluateVisitor__loadModule_closure6(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.nodeWithSpan = t2;
      _.baseUrl = t3;
      _.namesInErrors = t4;
      _.configuration = t5;
      _.callback = t6;
    },
    _EvaluateVisitor__loadModule__closure5: function _EvaluateVisitor__loadModule__closure5(t0, t1) {
      this.$this = t0;
      this.message = t1;
    },
    _EvaluateVisitor__loadModule__closure6: function _EvaluateVisitor__loadModule__closure6(t0, t1, t2) {
      this._box_0 = t0;
      this.callback = t1;
      this.firstLoad = t2;
    },
    _EvaluateVisitor__execute_closure2: function _EvaluateVisitor__execute_closure2(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.stylesheet = t2;
      _.extensionStore = t3;
      _.configuration = t4;
      _.css = t5;
      _.preModuleComments = t6;
    },
    _EvaluateVisitor__combineCss_closure5: function _EvaluateVisitor__combineCss_closure5() {
    },
    _EvaluateVisitor__combineCss_closure6: function _EvaluateVisitor__combineCss_closure6(t0) {
      this.selectors = t0;
    },
    _EvaluateVisitor__combineCss_visitModule2: function _EvaluateVisitor__combineCss_visitModule2(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.seen = t1;
      _.clone = t2;
      _.css = t3;
      _.imports = t4;
      _.sorted = t5;
    },
    _EvaluateVisitor__extendModules_closure5: function _EvaluateVisitor__extendModules_closure5(t0) {
      this.originalSelectors = t0;
    },
    _EvaluateVisitor__extendModules_closure6: function _EvaluateVisitor__extendModules_closure6() {
    },
    _EvaluateVisitor_visitAtRootRule_closure5: function _EvaluateVisitor_visitAtRootRule_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure6: function _EvaluateVisitor_visitAtRootRule_closure6(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure17: function _EvaluateVisitor__scopeForAtRoot_closure17(t0, t1, t2) {
      this.$this = t0;
      this.newParent = t1;
      this.node = t2;
    },
    _EvaluateVisitor__scopeForAtRoot_closure18: function _EvaluateVisitor__scopeForAtRoot_closure18(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure19: function _EvaluateVisitor__scopeForAtRoot_closure19(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot__closure2: function _EvaluateVisitor__scopeForAtRoot__closure2(t0, t1) {
      this.innerScope = t0;
      this.callback = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure20: function _EvaluateVisitor__scopeForAtRoot_closure20(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure21: function _EvaluateVisitor__scopeForAtRoot_closure21() {
    },
    _EvaluateVisitor__scopeForAtRoot_closure22: function _EvaluateVisitor__scopeForAtRoot_closure22(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor_visitContentRule_closure2: function _EvaluateVisitor_visitContentRule_closure2(t0, t1) {
      this.$this = t0;
      this.content = t1;
    },
    _EvaluateVisitor_visitDeclaration_closure2: function _EvaluateVisitor_visitDeclaration_closure2(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitEachRule_closure8: function _EvaluateVisitor_visitEachRule_closure8(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure9: function _EvaluateVisitor_visitEachRule_closure9(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure10: function _EvaluateVisitor_visitEachRule_closure10(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.list = t1;
      _.setVariables = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitEachRule__closure2: function _EvaluateVisitor_visitEachRule__closure2(t0, t1, t2) {
      this.$this = t0;
      this.setVariables = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitEachRule___closure2: function _EvaluateVisitor_visitEachRule___closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitAtRule_closure8: function _EvaluateVisitor_visitAtRule_closure8(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitAtRule_closure9: function _EvaluateVisitor_visitAtRule_closure9(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.children = t2;
    },
    _EvaluateVisitor_visitAtRule__closure2: function _EvaluateVisitor_visitAtRule__closure2(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitAtRule_closure10: function _EvaluateVisitor_visitAtRule_closure10() {
    },
    _EvaluateVisitor_visitForRule_closure14: function _EvaluateVisitor_visitForRule_closure14(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure15: function _EvaluateVisitor_visitForRule_closure15(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure16: function _EvaluateVisitor_visitForRule_closure16(t0) {
      this.fromNumber = t0;
    },
    _EvaluateVisitor_visitForRule_closure17: function _EvaluateVisitor_visitForRule_closure17(t0, t1) {
      this.toNumber = t0;
      this.fromNumber = t1;
    },
    _EvaluateVisitor_visitForRule_closure18: function _EvaluateVisitor_visitForRule_closure18(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.node = t2;
      _.from = t3;
      _.direction = t4;
      _.fromNumber = t5;
    },
    _EvaluateVisitor_visitForRule__closure2: function _EvaluateVisitor_visitForRule__closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitForwardRule_closure5: function _EvaluateVisitor_visitForwardRule_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForwardRule_closure6: function _EvaluateVisitor_visitForwardRule_closure6(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__registerCommentsForModule_closure2: function _EvaluateVisitor__registerCommentsForModule_closure2() {
    },
    _EvaluateVisitor_visitIfRule_closure2: function _EvaluateVisitor_visitIfRule_closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIfRule__closure2: function _EvaluateVisitor_visitIfRule__closure2(t0, t1) {
      this.$this = t0;
      this.clause = t1;
    },
    _EvaluateVisitor_visitIfRule___closure2: function _EvaluateVisitor_visitIfRule___closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport_closure2: function _EvaluateVisitor__visitDynamicImport_closure2(t0, t1) {
      this.$this = t0;
      this.$import = t1;
    },
    _EvaluateVisitor__visitDynamicImport__closure11: function _EvaluateVisitor__visitDynamicImport__closure11(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport__closure12: function _EvaluateVisitor__visitDynamicImport__closure12() {
    },
    _EvaluateVisitor__visitDynamicImport__closure13: function _EvaluateVisitor__visitDynamicImport__closure13() {
    },
    _EvaluateVisitor__visitDynamicImport__closure14: function _EvaluateVisitor__visitDynamicImport__closure14(t0, t1, t2, t3, t4) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.loadsUserDefinedModules = t2;
      _.environment = t3;
      _.children = t4;
    },
    _EvaluateVisitor__applyMixin_closure5: function _EvaluateVisitor__applyMixin_closure5(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.$arguments = t1;
      _.mixin = t2;
      _.nodeWithSpanWithoutContent = t3;
    },
    _EvaluateVisitor__applyMixin__closure6: function _EvaluateVisitor__applyMixin__closure6(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.$arguments = t1;
      _.mixin = t2;
      _.nodeWithSpanWithoutContent = t3;
    },
    _EvaluateVisitor__applyMixin_closure6: function _EvaluateVisitor__applyMixin_closure6(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.contentCallable = t1;
      _.mixin = t2;
      _.nodeWithSpanWithoutContent = t3;
    },
    _EvaluateVisitor__applyMixin__closure5: function _EvaluateVisitor__applyMixin__closure5(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpanWithoutContent = t2;
    },
    _EvaluateVisitor__applyMixin___closure2: function _EvaluateVisitor__applyMixin___closure2(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpanWithoutContent = t2;
    },
    _EvaluateVisitor__applyMixin____closure2: function _EvaluateVisitor__applyMixin____closure2(t0, t1) {
      this.$this = t0;
      this.statement = t1;
    },
    _EvaluateVisitor_visitIncludeRule_closure8: function _EvaluateVisitor_visitIncludeRule_closure8(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitIncludeRule_closure9: function _EvaluateVisitor_visitIncludeRule_closure9(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure10: function _EvaluateVisitor_visitIncludeRule_closure10(t0) {
      this.node = t0;
    },
    _EvaluateVisitor_visitMediaRule_closure8: function _EvaluateVisitor_visitMediaRule_closure8(t0, t1) {
      this.$this = t0;
      this.queries = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure9: function _EvaluateVisitor_visitMediaRule_closure9(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.mergedQueries = t1;
      _.queries = t2;
      _.mergedSources = t3;
      _.node = t4;
    },
    _EvaluateVisitor_visitMediaRule__closure2: function _EvaluateVisitor_visitMediaRule__closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule___closure2: function _EvaluateVisitor_visitMediaRule___closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure10: function _EvaluateVisitor_visitMediaRule_closure10(t0) {
      this.mergedSources = t0;
    },
    _EvaluateVisitor_visitStyleRule_closure14: function _EvaluateVisitor_visitStyleRule_closure14(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure15: function _EvaluateVisitor_visitStyleRule_closure15() {
    },
    _EvaluateVisitor_visitStyleRule_closure17: function _EvaluateVisitor_visitStyleRule_closure17(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitStyleRule__closure2: function _EvaluateVisitor_visitStyleRule__closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure16: function _EvaluateVisitor_visitStyleRule_closure16() {
    },
    _EvaluateVisitor_visitStyleRule_closure18: function _EvaluateVisitor_visitStyleRule_closure18() {
    },
    _EvaluateVisitor_visitSupportsRule_closure5: function _EvaluateVisitor_visitSupportsRule_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule__closure2: function _EvaluateVisitor_visitSupportsRule__closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule_closure6: function _EvaluateVisitor_visitSupportsRule_closure6() {
    },
    _EvaluateVisitor__visitSupportsCondition_closure2: function _EvaluateVisitor__visitSupportsCondition_closure2(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure8: function _EvaluateVisitor_visitVariableDeclaration_closure8(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure9: function _EvaluateVisitor_visitVariableDeclaration_closure9(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure10: function _EvaluateVisitor_visitVariableDeclaration_closure10(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.value = t2;
    },
    _EvaluateVisitor_visitUseRule_closure2: function _EvaluateVisitor_visitUseRule_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWarnRule_closure2: function _EvaluateVisitor_visitWarnRule_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule_closure2: function _EvaluateVisitor_visitWhileRule_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule__closure2: function _EvaluateVisitor_visitWhileRule__closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitBinaryOperationExpression_closure2: function _EvaluateVisitor_visitBinaryOperationExpression_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__slash_recommendation2: function _EvaluateVisitor__slash_recommendation2() {
    },
    _EvaluateVisitor_visitVariableExpression_closure2: function _EvaluateVisitor_visitVariableExpression_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitUnaryOperationExpression_closure2: function _EvaluateVisitor_visitUnaryOperationExpression_closure2(t0, t1) {
      this.node = t0;
      this.operand = t1;
    },
    _EvaluateVisitor_visitListExpression_closure2: function _EvaluateVisitor_visitListExpression_closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitFunctionExpression_closure8: function _EvaluateVisitor_visitFunctionExpression_closure8(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitFunctionExpression_closure9: function _EvaluateVisitor_visitFunctionExpression_closure9() {
    },
    _EvaluateVisitor_visitFunctionExpression_closure10: function _EvaluateVisitor_visitFunctionExpression_closure10(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.node = t2;
    },
    _EvaluateVisitor__checkCalculationArguments_check2: function _EvaluateVisitor__checkCalculationArguments_check2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__visitCalculationExpression_closure2: function _EvaluateVisitor__visitCalculationExpression_closure2(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.node = t2;
      _.inLegacySassFunction = t3;
    },
    _EvaluateVisitor_visitInterpolatedFunctionExpression_closure2: function _EvaluateVisitor_visitInterpolatedFunctionExpression_closure2(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.$function = t2;
    },
    _EvaluateVisitor__runUserDefinedCallable_closure2: function _EvaluateVisitor__runUserDefinedCallable_closure2(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.callable = t1;
      _.evaluated = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable__closure2: function _EvaluateVisitor__runUserDefinedCallable__closure2(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable___closure2: function _EvaluateVisitor__runUserDefinedCallable___closure2(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable____closure2: function _EvaluateVisitor__runUserDefinedCallable____closure2() {
    },
    _EvaluateVisitor__runFunctionCallable_closure2: function _EvaluateVisitor__runFunctionCallable_closure2(t0, t1) {
      this.$this = t0;
      this.callable = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure8: function _EvaluateVisitor__runBuiltInCallable_closure8(t0, t1, t2) {
      this._box_0 = t0;
      this.evaluated = t1;
      this.namedSet = t2;
    },
    _EvaluateVisitor__runBuiltInCallable_closure9: function _EvaluateVisitor__runBuiltInCallable_closure9(t0, t1) {
      this._box_0 = t0;
      this.evaluated = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure10: function _EvaluateVisitor__runBuiltInCallable_closure10() {
    },
    _EvaluateVisitor__evaluateArguments_closure11: function _EvaluateVisitor__evaluateArguments_closure11() {
    },
    _EvaluateVisitor__evaluateArguments_closure12: function _EvaluateVisitor__evaluateArguments_closure12(t0, t1) {
      this.$this = t0;
      this.restNodeForSpan = t1;
    },
    _EvaluateVisitor__evaluateArguments_closure13: function _EvaluateVisitor__evaluateArguments_closure13(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.namedNodes = t3;
    },
    _EvaluateVisitor__evaluateArguments_closure14: function _EvaluateVisitor__evaluateArguments_closure14() {
    },
    _EvaluateVisitor__evaluateMacroArguments_closure11: function _EvaluateVisitor__evaluateMacroArguments_closure11(t0) {
      this.restArgs = t0;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure12: function _EvaluateVisitor__evaluateMacroArguments_closure12(t0, t1, t2) {
      this.$this = t0;
      this.restNodeForSpan = t1;
      this.restArgs = t2;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure13: function _EvaluateVisitor__evaluateMacroArguments_closure13(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.restArgs = t3;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure14: function _EvaluateVisitor__evaluateMacroArguments_closure14(t0, t1, t2) {
      this.$this = t0;
      this.keywordRestNodeForSpan = t1;
      this.keywordRestArgs = t2;
    },
    _EvaluateVisitor__addRestMap_closure2: function _EvaluateVisitor__addRestMap_closure2(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.values = t1;
      _.convert = t2;
      _.expressionNode = t3;
      _.map = t4;
      _.nodeWithSpan = t5;
    },
    _EvaluateVisitor__verifyArguments_closure2: function _EvaluateVisitor__verifyArguments_closure2(t0, t1, t2) {
      this.$arguments = t0;
      this.positional = t1;
      this.named = t2;
    },
    _EvaluateVisitor_visitCssAtRule_closure5: function _EvaluateVisitor_visitCssAtRule_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssAtRule_closure6: function _EvaluateVisitor_visitCssAtRule_closure6() {
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure5: function _EvaluateVisitor_visitCssKeyframeBlock_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure6: function _EvaluateVisitor_visitCssKeyframeBlock_closure6() {
    },
    _EvaluateVisitor_visitCssMediaRule_closure8: function _EvaluateVisitor_visitCssMediaRule_closure8(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure9: function _EvaluateVisitor_visitCssMediaRule_closure9(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.mergedQueries = t1;
      _.node = t2;
      _.mergedSources = t3;
    },
    _EvaluateVisitor_visitCssMediaRule__closure2: function _EvaluateVisitor_visitCssMediaRule__closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule___closure2: function _EvaluateVisitor_visitCssMediaRule___closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure10: function _EvaluateVisitor_visitCssMediaRule_closure10(t0) {
      this.mergedSources = t0;
    },
    _EvaluateVisitor_visitCssStyleRule_closure6: function _EvaluateVisitor_visitCssStyleRule_closure6(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssStyleRule__closure2: function _EvaluateVisitor_visitCssStyleRule__closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssStyleRule_closure5: function _EvaluateVisitor_visitCssStyleRule_closure5() {
    },
    _EvaluateVisitor_visitCssSupportsRule_closure5: function _EvaluateVisitor_visitCssSupportsRule_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule__closure2: function _EvaluateVisitor_visitCssSupportsRule__closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule_closure6: function _EvaluateVisitor_visitCssSupportsRule_closure6() {
    },
    _EvaluateVisitor__performInterpolationHelper_closure2: function _EvaluateVisitor__performInterpolationHelper_closure2(t0) {
      this.interpolation = t0;
    },
    _EvaluateVisitor__serialize_closure2: function _EvaluateVisitor__serialize_closure2(t0, t1) {
      this.value = t0;
      this.quote = t1;
    },
    _EvaluateVisitor__expressionNode_closure2: function _EvaluateVisitor__expressionNode_closure2(t0, t1) {
      this.$this = t0;
      this.expression = t1;
    },
    _EvaluateVisitor__withoutSlash_recommendation2: function _EvaluateVisitor__withoutSlash_recommendation2() {
    },
    _EvaluateVisitor__stackFrame_closure2: function _EvaluateVisitor__stackFrame_closure2(t0) {
      this.$this = t0;
    },
    _ImportedCssVisitor2: function _ImportedCssVisitor2(t0) {
      this._async_evaluate0$_visitor = t0;
    },
    _ImportedCssVisitor_visitCssAtRule_closure2: function _ImportedCssVisitor_visitCssAtRule_closure2() {
    },
    _ImportedCssVisitor_visitCssMediaRule_closure2: function _ImportedCssVisitor_visitCssMediaRule_closure2(t0) {
      this.hasBeenMerged = t0;
    },
    _ImportedCssVisitor_visitCssStyleRule_closure2: function _ImportedCssVisitor_visitCssStyleRule_closure2() {
    },
    _ImportedCssVisitor_visitCssSupportsRule_closure2: function _ImportedCssVisitor_visitCssSupportsRule_closure2() {
    },
    _EvaluationContext2: function _EvaluationContext2(t0, t1) {
      this._async_evaluate0$_visitor = t0;
      this._async_evaluate0$_defaultWarnNodeWithSpan = t1;
    },
    JSToDartAsyncFileImporter: function JSToDartAsyncFileImporter(t0) {
      this._findFileUrl = t0;
    },
    JSToDartAsyncFileImporter_canonicalize_closure: function JSToDartAsyncFileImporter_canonicalize_closure(t0, t1) {
      this.$this = t0;
      this.url = t1;
    },
    AsyncImportCache$(importers, loadPaths, logger, packageConfig) {
      var t1 = type$.nullable_Record_3_AsyncImporter_and_Uri_and_Uri_originalUrl_2,
        t2 = type$.Record_3_AsyncImporter_and_Uri_and_bool_forImport_2,
        t3 = type$.Uri,
        t4 = A.AsyncImportCache__toImporters0(importers, loadPaths, packageConfig);
      return new A.AsyncImportCache0(t4, logger, A.LinkedHashMap_LinkedHashMap$_empty(type$.Record_2_Uri_and_bool_forImport, t1), A.LinkedHashMap_LinkedHashMap$_empty(t2, t1), A.LinkedHashMap_LinkedHashMap$_empty(t2, t3), A.LinkedHashMap_LinkedHashMap$_empty(t3, type$.nullable_Stylesheet_2), A.LinkedHashMap_LinkedHashMap$_empty(t3, type$.ImporterResult_2));
    },
    AsyncImportCache$none(logger) {
      var t1 = type$.nullable_Record_3_AsyncImporter_and_Uri_and_Uri_originalUrl_2,
        t2 = type$.Record_3_AsyncImporter_and_Uri_and_bool_forImport_2,
        t3 = type$.Uri;
      return new A.AsyncImportCache0(B.List_empty25, logger, A.LinkedHashMap_LinkedHashMap$_empty(type$.Record_2_Uri_and_bool_forImport, t1), A.LinkedHashMap_LinkedHashMap$_empty(t2, t1), A.LinkedHashMap_LinkedHashMap$_empty(t2, t3), A.LinkedHashMap_LinkedHashMap$_empty(t3, type$.nullable_Stylesheet_2), A.LinkedHashMap_LinkedHashMap$_empty(t3, type$.ImporterResult_2));
    },
    AsyncImportCache__toImporters0(importers, loadPaths, packageConfig) {
      var t1, t2, t3, t4, _i, path, _null = null,
        sassPath = A.getEnvironmentVariable0("SASS_PATH");
      if (A.isBrowser()) {
        t1 = A._setArrayType([], type$.JSArray_AsyncImporter);
        if (importers != null)
          B.JSArray_methods.addAll$1(t1, importers);
        return t1;
      }
      t1 = A._setArrayType([], type$.JSArray_AsyncImporter);
      if (importers != null)
        B.JSArray_methods.addAll$1(t1, importers);
      if (loadPaths != null)
        for (t2 = J.get$iterator$ax(loadPaths); t2.moveNext$0();) {
          t3 = t2.get$current(t2);
          t1.push(new A.FilesystemImporter0($.$get$context().absolute$15(t3, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null), false));
        }
      if (sassPath != null) {
        t2 = A.isNodeJs() ? self.process : _null;
        t3 = sassPath.split(J.$eq$(t2 == null ? _null : J.get$platform$x(t2), "win32") ? ";" : ":");
        t4 = t3.length;
        _i = 0;
        for (; _i < t4; ++_i) {
          path = t3[_i];
          t1.push(new A.FilesystemImporter0($.$get$context().absolute$15(path, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null), false));
        }
      }
      return t1;
    },
    AsyncImportCache0: function AsyncImportCache0(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._async_import_cache0$_importers = t0;
      _._async_import_cache0$_logger = t1;
      _._async_import_cache0$_canonicalizeCache = t2;
      _._async_import_cache0$_perImporterCanonicalizeCache = t3;
      _._async_import_cache0$_nonCanonicalRelativeUrls = t4;
      _._async_import_cache0$_importCache = t5;
      _._async_import_cache0$_resultsCache = t6;
    },
    AsyncImportCache_canonicalize_closure0: function AsyncImportCache_canonicalize_closure0(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.baseImporter = t1;
      _.resolvedUrl = t2;
      _.baseUrl = t3;
      _.forImport = t4;
      _.key = t5;
      _.url = t6;
    },
    AsyncImportCache__canonicalize_closure0: function AsyncImportCache__canonicalize_closure0(t0, t1) {
      this.importer = t0;
      this.url = t1;
    },
    AsyncImportCache_importCanonical_closure0: function AsyncImportCache_importCanonical_closure0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _.originalUrl = t3;
      _.quiet = t4;
    },
    AsyncImportCache_humanize_closure3: function AsyncImportCache_humanize_closure3(t0) {
      this.canonicalUrl = t0;
    },
    AsyncImportCache_humanize_closure4: function AsyncImportCache_humanize_closure4() {
    },
    AsyncImportCache_humanize_closure5: function AsyncImportCache_humanize_closure5() {
    },
    AsyncImportCache_humanize_closure6: function AsyncImportCache_humanize_closure6(t0) {
      this.canonicalUrl = t0;
    },
    AtRootQueryParser$0(contents, logger, url) {
      var t1 = A.SpanScanner$(contents, url);
      return new A.AtRootQueryParser0(t1, logger, null);
    },
    AtRootQueryParser0: function AtRootQueryParser0(t0, t1, t2) {
      this.scanner = t0;
      this.logger = t1;
      this._parser0$_interpolationMap = t2;
    },
    AtRootQueryParser_parse_closure0: function AtRootQueryParser_parse_closure0(t0) {
      this.$this = t0;
    },
    AtRootQuery0: function AtRootQuery0(t0, t1, t2, t3) {
      var _ = this;
      _.include = t0;
      _.names = t1;
      _._at_root_query0$_all = t2;
      _._at_root_query0$_rule = t3;
    },
    AtRootRule$0(children, span, query) {
      var t1 = A.List_List$unmodifiable(children, type$.Statement_2),
        t2 = B.JSArray_methods.any$1(t1, new A.ParentStatement_closure0());
      return new A.AtRootRule0(query, span, t1, t2);
    },
    AtRootRule0: function AtRootRule0(t0, t1, t2, t3) {
      var _ = this;
      _.query = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    ModifiableCssAtRule$0($name, span, childless, value) {
      var t1 = A._setArrayType([], type$.JSArray_ModifiableCssNode_2);
      return new A.ModifiableCssAtRule0($name, value, childless, span, new A.UnmodifiableListView(t1, type$.UnmodifiableListView_ModifiableCssNode_2), t1);
    },
    ModifiableCssAtRule0: function ModifiableCssAtRule0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.isChildless = t2;
      _.span = t3;
      _.children = t4;
      _._node$_children = t5;
      _._node$_indexInParent = _._node$_parent = null;
      _.isGroupEnd = false;
    },
    AtRule$0($name, span, children, value) {
      var t1 = children == null ? null : A.List_List$unmodifiable(children, type$.Statement_2),
        t2 = t1 == null ? null : B.JSArray_methods.any$1(t1, new A.ParentStatement_closure0());
      return new A.AtRule0($name, value, span, t1, t2 === true);
    },
    AtRule0: function AtRule0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    AttributeSelector0: function AttributeSelector0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.op = t1;
      _.value = t2;
      _.modifier = t3;
      _.span = t4;
    },
    AttributeOperator0: function AttributeOperator0(t0, t1) {
      this._attribute0$_text = t0;
      this._name = t1;
    },
    BinaryOperationExpression0: function BinaryOperationExpression0(t0, t1, t2, t3) {
      var _ = this;
      _.operator = t0;
      _.left = t1;
      _.right = t2;
      _.allowsSlash = t3;
    },
    BinaryOperator0: function BinaryOperator0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.operator = t1;
      _.precedence = t2;
      _.isAssociative = t3;
      _._name = t4;
    },
    BooleanExpression0: function BooleanExpression0(t0, t1) {
      this.value = t0;
      this.span = t1;
    },
    booleanClass_closure: function booleanClass_closure() {
    },
    booleanClass__closure: function booleanClass__closure() {
    },
    legacyBooleanClass_closure: function legacyBooleanClass_closure() {
    },
    legacyBooleanClass__closure: function legacyBooleanClass__closure() {
    },
    legacyBooleanClass__closure0: function legacyBooleanClass__closure0() {
    },
    SassBoolean0: function SassBoolean0(t0) {
      this.value = t0;
    },
    Box0: function Box0(t0, t1) {
      this._box0$_inner = t0;
      this.$ti = t1;
    },
    ModifiableBox0: function ModifiableBox0(t0, t1) {
      this.value = t0;
      this.$ti = t1;
    },
    BuiltInCallable$function0($name, $arguments, callback, url) {
      return new A.BuiltInCallable0($name, A._setArrayType([new A._Record_2(A.ScssParser$0("@function " + $name + "(" + $arguments + ") {", null, url).parseArgumentDeclaration$0(), callback)], type$.JSArray_Record_2_ArgumentDeclaration_and_Value_Function_List_Value_2), false);
    },
    BuiltInCallable$mixin0($name, $arguments, callback, acceptsContent, url) {
      return new A.BuiltInCallable0($name, A._setArrayType([new A._Record_2(A.ScssParser$0("@mixin " + $name + "(" + $arguments + ") {", null, url).parseArgumentDeclaration$0(), new A.BuiltInCallable$mixin_closure0(callback))], type$.JSArray_Record_2_ArgumentDeclaration_and_Value_Function_List_Value_2), acceptsContent);
    },
    BuiltInCallable$overloadedFunction0($name, overloads) {
      var t2, t3, t4, t5, t6, args, callback,
        t1 = A._setArrayType([], type$.JSArray_Record_2_ArgumentDeclaration_and_Value_Function_List_Value_2);
      for (t2 = type$.String, t3 = A.MapExtensions_get_pairs0(overloads, t2, type$.Value_Function_List_Value_2), t3 = t3.get$iterator(t3), t4 = "@function " + $name + "(", t5 = type$.VariableDeclaration_2; t3.moveNext$0();) {
        t6 = t3.get$current(t3);
        args = t6._0;
        callback = t6._1;
        t6 = A.SpanScanner$(t4 + args + ") {", null);
        t1.push(new A._Record_2(new A.ScssParser0(A.LinkedHashMap_LinkedHashMap$_empty(t2, t5), t6, B.StderrLogger_false0, null).parseArgumentDeclaration$0(), callback));
      }
      return new A.BuiltInCallable0($name, t1, false);
    },
    BuiltInCallable0: function BuiltInCallable0(t0, t1, t2) {
      this.name = t0;
      this._built_in$_overloads = t1;
      this.acceptsContent = t2;
    },
    BuiltInCallable$mixin_closure0: function BuiltInCallable$mixin_closure0(t0) {
      this.callback = t0;
    },
    BuiltInModule$0($name, functions, mixins, variables, $T) {
      var t1 = A._Uri__Uri(null, $name, null, "sass"),
        t2 = A.BuiltInModule__callableMap0(functions, $T),
        t3 = A.BuiltInModule__callableMap0(mixins, $T),
        t4 = variables == null ? B.Map_empty13 : new A.UnmodifiableMapView(variables, type$.UnmodifiableMapView_String_Value_2);
      return new A.BuiltInModule0(t1, t2, t3, t4, $T._eval$1("BuiltInModule0<0>"));
    },
    BuiltInModule__callableMap0(callables, $T) {
      var t2, _i, callable,
        t1 = type$.String;
      if (callables == null)
        t1 = A.LinkedHashMap_LinkedHashMap$_empty(t1, $T);
      else {
        t1 = A.LinkedHashMap_LinkedHashMap$_empty(t1, $T);
        for (t2 = callables.length, _i = 0; _i < callables.length; callables.length === t2 || (0, A.throwConcurrentModificationError)(callables), ++_i) {
          callable = callables[_i];
          t1.$indexSet(0, J.get$name$x(callable), callable);
        }
        t1 = new A.UnmodifiableMapView(t1, type$.$env_1_1_String._bind$1($T)._eval$1("UnmodifiableMapView<1,2>"));
      }
      return new A.UnmodifiableMapView(t1, type$.$env_1_1_String._bind$1($T)._eval$1("UnmodifiableMapView<1,2>"));
    },
    BuiltInModule0: function BuiltInModule0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.url = t0;
      _.functions = t1;
      _.mixins = t2;
      _.variables = t3;
      _.$ti = t4;
    },
    _assertCalculationValue(arg) {
      var t1;
      $label0$0: {
        if (!(arg instanceof A.SassNumber0))
          t1 = arg instanceof A.SassString0 && !arg._string0$_hasQuotes || arg instanceof A.SassCalculation0 || arg instanceof A.CalculationOperation0 || arg instanceof A.CalculationInterpolation;
        else
          t1 = true;
        if (t1) {
          t1 = null;
          break $label0$0;
        }
        t1 = A.jsThrow0(new self.Error("Argument `" + A.S(arg) + "` must be one of SassNumber, unquoted SassString, SassCalculation, CalculationOperation, CalculationInterpolation"));
      }
      return t1;
    },
    _isValidClampArg(arg) {
      var t1;
      $label0$0: {
        if (!(arg instanceof A.CalculationInterpolation))
          t1 = arg instanceof A.SassString0 && !arg._string0$_hasQuotes;
        else
          t1 = true;
        if (t1)
          break $label0$0;
        break $label0$0;
      }
      return t1;
    },
    calculationClass_closure: function calculationClass_closure() {
    },
    calculationClass__closure: function calculationClass__closure() {
    },
    calculationClass__closure0: function calculationClass__closure0() {
    },
    calculationClass__closure1: function calculationClass__closure1() {
    },
    calculationClass__closure2: function calculationClass__closure2() {
    },
    calculationClass__closure3: function calculationClass__closure3() {
    },
    calculationClass__closure4: function calculationClass__closure4() {
    },
    calculationClass__closure5: function calculationClass__closure5() {
    },
    calculationOperationClass_closure: function calculationOperationClass_closure() {
    },
    calculationOperationClass__closure: function calculationOperationClass__closure() {
    },
    calculationOperationClass___closure: function calculationOperationClass___closure(t0) {
      this.strOperator = t0;
    },
    calculationOperationClass__closure0: function calculationOperationClass__closure0() {
    },
    calculationOperationClass__closure1: function calculationOperationClass__closure1() {
    },
    calculationOperationClass__closure2: function calculationOperationClass__closure2() {
    },
    calculationOperationClass__closure3: function calculationOperationClass__closure3() {
    },
    calculationOperationClass__closure4: function calculationOperationClass__closure4() {
    },
    calculationInterpolationClass_closure: function calculationInterpolationClass_closure() {
    },
    calculationInterpolationClass__closure: function calculationInterpolationClass__closure() {
    },
    calculationInterpolationClass__closure0: function calculationInterpolationClass__closure0() {
    },
    calculationInterpolationClass__closure1: function calculationInterpolationClass__closure1() {
    },
    calculationInterpolationClass__closure2: function calculationInterpolationClass__closure2() {
    },
    SassCalculation_calc0(argument) {
      var t1,
        _0_0 = A.SassCalculation__simplify0(argument);
      $label0$0: {
        if (_0_0 instanceof A.SassNumber0) {
          t1 = _0_0;
          break $label0$0;
        }
        if (_0_0 instanceof A.SassCalculation0) {
          t1 = _0_0;
          break $label0$0;
        }
        t1 = new A.SassCalculation0("calc", A.List_List$unmodifiable([_0_0], type$.Object));
        break $label0$0;
      }
      return t1;
    },
    SassCalculation_min0($arguments) {
      var minimum, _i, arg, t2,
        args = A.List_List$unmodifiable(new A.MappedListIterable($arguments, A.calculation0_SassCalculation__simplify$closure(), A._arrayInstanceType($arguments)._eval$1("MappedListIterable<1,@>")), type$.Object),
        t1 = args.length;
      if (t1 === 0)
        throw A.wrapException(A.ArgumentError$("min() must have at least one argument.", null));
      for (minimum = null, _i = 0; _i < t1; ++_i) {
        arg = args[_i];
        if (arg instanceof A.SassNumber0)
          t2 = minimum != null && !minimum.isComparableTo$1(arg);
        else
          t2 = true;
        if (t2) {
          minimum = null;
          break;
        } else if (minimum == null || minimum.greaterThan$1(arg).value)
          minimum = arg;
      }
      if (minimum != null)
        return minimum;
      A.SassCalculation__verifyCompatibleNumbers0(args);
      return new A.SassCalculation0("min", args);
    },
    SassCalculation_max0($arguments) {
      var maximum, _i, arg, t2,
        args = A.List_List$unmodifiable(new A.MappedListIterable($arguments, A.calculation0_SassCalculation__simplify$closure(), A._arrayInstanceType($arguments)._eval$1("MappedListIterable<1,@>")), type$.Object),
        t1 = args.length;
      if (t1 === 0)
        throw A.wrapException(A.ArgumentError$("max() must have at least one argument.", null));
      for (maximum = null, _i = 0; _i < t1; ++_i) {
        arg = args[_i];
        if (arg instanceof A.SassNumber0)
          t2 = maximum != null && !maximum.isComparableTo$1(arg);
        else
          t2 = true;
        if (t2) {
          maximum = null;
          break;
        } else if (maximum == null || maximum.lessThan$1(arg).value)
          maximum = arg;
      }
      if (maximum != null)
        return maximum;
      A.SassCalculation__verifyCompatibleNumbers0(args);
      return new A.SassCalculation0("max", args);
    },
    SassCalculation_hypot0($arguments) {
      var first, subtotal, i, number, value, t2, t3,
        args = A.List_List$unmodifiable(new A.MappedListIterable($arguments, A.calculation0_SassCalculation__simplify$closure(), A._arrayInstanceType($arguments)._eval$1("MappedListIterable<1,@>")), type$.Object),
        t1 = args.length;
      if (t1 === 0)
        throw A.wrapException(A.ArgumentError$("hypot() must have at least one argument.", null));
      A.SassCalculation__verifyCompatibleNumbers0(args);
      first = B.JSArray_methods.get$first(args);
      if (!(first instanceof A.SassNumber0) || first.hasUnit$1("%"))
        return new A.SassCalculation0("hypot", args);
      for (subtotal = 0, i = 0; i < t1;) {
        number = args[i];
        if (!(number instanceof A.SassNumber0) || !number.hasCompatibleUnits$1(first))
          return new A.SassCalculation0("hypot", args);
        ++i;
        value = number.convertValueToMatch$3(first, "numbers[" + i + "]", "numbers[1]");
        subtotal += value * value;
      }
      t1 = Math.sqrt(subtotal);
      t2 = J.getInterceptor$x(first);
      t3 = t2.get$numeratorUnits(first);
      return A.SassNumber_SassNumber$withUnits0(t1, t2.get$denominatorUnits(first), t3);
    },
    SassCalculation_abs0(argument) {
      argument = A.SassCalculation__simplify0(argument);
      if (!(argument instanceof A.SassNumber0))
        return new A.SassCalculation0("abs", A._setArrayType([argument], type$.JSArray_Object));
      if (argument.hasUnit$1("%"))
        A.warnForDeprecation0(string$.Passinp + argument.toString$0(0) + ")\nTo emit a CSS abs() now: abs(#{" + argument.toString$0(0) + string$.x7d__Mor, B.Deprecation_jYb);
      return A.SassNumber_SassNumber0(Math.abs(argument._number1$_value), null).coerceToMatch$1(argument);
    },
    SassCalculation_exp0(argument) {
      argument = A.SassCalculation__simplify0(argument);
      if (!(argument instanceof A.SassNumber0))
        return new A.SassCalculation0("exp", A._setArrayType([argument], type$.JSArray_Object));
      argument.assertNoUnits$0();
      return A.pow1(A.SassNumber_SassNumber0(2.718281828459045, null), argument);
    },
    SassCalculation_sign0(argument) {
      var t1, _0_2, t2, arg;
      argument = A.SassCalculation__simplify0(argument);
      $label0$0: {
        t1 = argument instanceof A.SassNumber0;
        if (t1) {
          _0_2 = argument._number1$_value;
          if (!isNaN(_0_2))
            t2 = 0 === _0_2;
          else
            t2 = true;
        } else
          t2 = false;
        if (t2) {
          t1 = argument;
          break $label0$0;
        }
        if (t1) {
          t1 = !argument.hasUnit$1("%");
          arg = argument;
        } else {
          arg = null;
          t1 = false;
        }
        if (t1) {
          t1 = A.SassNumber_SassNumber0(J.get$sign$in(arg._number1$_value), null).coerceToMatch$1(argument);
          break $label0$0;
        }
        t1 = new A.SassCalculation0("sign", A._setArrayType([argument], type$.JSArray_Object));
        break $label0$0;
      }
      return t1;
    },
    SassCalculation_clamp0(min, value, max) {
      var t1, args;
      if (value == null && max != null)
        throw A.wrapException(A.ArgumentError$("If value is null, max must also be null.", null));
      min = A.SassCalculation__simplify0(min);
      value = A.NullableExtension_andThen0(value, A.calculation0_SassCalculation__simplify$closure());
      max = A.NullableExtension_andThen0(max, A.calculation0_SassCalculation__simplify$closure());
      if (min instanceof A.SassNumber0 && value instanceof A.SassNumber0 && max instanceof A.SassNumber0 && min.hasCompatibleUnits$1(value) && min.hasCompatibleUnits$1(max)) {
        if (value.lessThanOrEquals$1(min).value)
          return min;
        if (value.greaterThanOrEquals$1(max).value)
          return max;
        return value;
      }
      t1 = [min];
      if (value != null)
        t1.push(value);
      if (max != null)
        t1.push(max);
      args = A.List_List$unmodifiable(t1, type$.Object);
      A.SassCalculation__verifyCompatibleNumbers0(args);
      A.SassCalculation__verifyLength0(args, 3);
      return new A.SassCalculation0("clamp", args);
    },
    SassCalculation_pow0(base, exponent) {
      var t1 = A._setArrayType([base], type$.JSArray_Object);
      if (exponent != null)
        t1.push(exponent);
      A.SassCalculation__verifyLength0(t1, 2);
      base = A.SassCalculation__simplify0(base);
      exponent = A.NullableExtension_andThen0(exponent, A.calculation0_SassCalculation__simplify$closure());
      if (!(base instanceof A.SassNumber0) || !(exponent instanceof A.SassNumber0))
        return new A.SassCalculation0("pow", t1);
      base.assertNoUnits$0();
      exponent.assertNoUnits$0();
      return A.pow1(base, exponent);
    },
    SassCalculation_log0(number, base) {
      var t1, t2;
      number = A.SassCalculation__simplify0(number);
      base = A.NullableExtension_andThen0(base, A.calculation0_SassCalculation__simplify$closure());
      t1 = A._setArrayType([number], type$.JSArray_Object);
      t2 = base != null;
      if (t2)
        t1.push(base);
      if (number instanceof A.SassNumber0)
        t2 = t2 && !(base instanceof A.SassNumber0);
      else
        t2 = true;
      if (t2)
        return new A.SassCalculation0("log", t1);
      number.assertNoUnits$0();
      if (base instanceof A.SassNumber0) {
        base.assertNoUnits$0();
        return A.log0(number, base);
      }
      return A.log0(number, null);
    },
    SassCalculation_atan20(y, x) {
      var t1;
      y = A.SassCalculation__simplify0(y);
      x = A.NullableExtension_andThen0(x, A.calculation0_SassCalculation__simplify$closure());
      t1 = A._setArrayType([y], type$.JSArray_Object);
      if (x != null)
        t1.push(x);
      A.SassCalculation__verifyLength0(t1, 2);
      A.SassCalculation__verifyCompatibleNumbers0(t1);
      if (!(y instanceof A.SassNumber0) || !(x instanceof A.SassNumber0) || y.hasUnit$1("%") || x.hasUnit$1("%") || !y.hasCompatibleUnits$1(x))
        return new A.SassCalculation0("atan2", t1);
      return A.SassNumber_SassNumber$withUnits0(Math.atan2(y._number1$_value, x.convertValueToMatch$3(y, "x", "y")) * 57.29577951308232, null, A._setArrayType(["deg"], type$.JSArray_String));
    },
    SassCalculation_rem0(dividend, modulus) {
      var t1, result;
      dividend = A.SassCalculation__simplify0(dividend);
      modulus = A.NullableExtension_andThen0(modulus, A.calculation0_SassCalculation__simplify$closure());
      t1 = A._setArrayType([dividend], type$.JSArray_Object);
      if (modulus != null)
        t1.push(modulus);
      A.SassCalculation__verifyLength0(t1, 2);
      A.SassCalculation__verifyCompatibleNumbers0(t1);
      if (!(dividend instanceof A.SassNumber0) || !(modulus instanceof A.SassNumber0) || !dividend.hasCompatibleUnits$1(modulus))
        return new A.SassCalculation0("rem", t1);
      result = dividend.modulo$1(modulus);
      t1 = modulus._number1$_value;
      if (A.DoubleWithSignedZero_get_signIncludingZero0(t1) !== A.DoubleWithSignedZero_get_signIncludingZero0(dividend._number1$_value)) {
        if (t1 == 1 / 0 || t1 == -1 / 0)
          return dividend;
        if (result._number1$_value === 0)
          return result.unaryMinus$0();
        return result.minus$1(modulus);
      }
      return result;
    },
    SassCalculation_mod0(dividend, modulus) {
      var t1;
      dividend = A.SassCalculation__simplify0(dividend);
      modulus = A.NullableExtension_andThen0(modulus, A.calculation0_SassCalculation__simplify$closure());
      t1 = A._setArrayType([dividend], type$.JSArray_Object);
      if (modulus != null)
        t1.push(modulus);
      A.SassCalculation__verifyLength0(t1, 2);
      A.SassCalculation__verifyCompatibleNumbers0(t1);
      if (!(dividend instanceof A.SassNumber0) || !(modulus instanceof A.SassNumber0) || !dividend.hasCompatibleUnits$1(modulus))
        return new A.SassCalculation0("mod", t1);
      return dividend.modulo$1(modulus);
    },
    SassCalculation_round0(strategyOrNumber, numberOrStep, step) {
      var _0_4, _0_5_isSet, _0_20, _0_6, t1, _0_50, _0_6_isSet, number, t2, _0_2_isSet, _0_10_isSet, _0_8, _0_12_isSet, _0_12, _0_14_isSet, _0_14, _0_16_isSet, _0_16, t3, strategy, _0_8_isSet, t4, rest, _null = null, _s5_ = "round",
        _0_1 = A.SassCalculation__simplify0(strategyOrNumber),
        _0_2 = A.NullableExtension_andThen0(numberOrStep, A.calculation0_SassCalculation__simplify$closure()),
        _0_5 = A.NullableExtension_andThen0(step, A.calculation0_SassCalculation__simplify$closure()),
        _0_10 = _0_1,
        _0_4_isSet = _0_1 instanceof A.SassNumber0;
      if (_0_4_isSet) {
        type$.SassNumber_2._as(_0_10);
        _0_4 = _0_2 == null;
        _0_5_isSet = _0_4;
        _0_20 = _0_2;
        if (_0_5_isSet) {
          _0_6 = _0_5 == null;
          t1 = _0_6;
          _0_50 = _0_5;
        } else {
          _0_50 = _null;
          _0_6 = _0_50;
          t1 = false;
        }
        _0_6_isSet = _0_5_isSet;
        number = _0_10;
        _0_1 = number;
      } else {
        number = _null;
        _0_50 = number;
        _0_6 = _0_50;
        _0_20 = _0_6;
        _0_4 = _0_20;
        _0_1 = _0_10;
        _0_6_isSet = false;
        _0_5_isSet = false;
        t1 = false;
      }
      if (t1) {
        t1 = B.JSNumber_methods.round$0(number._number1$_value);
        t2 = number.get$numeratorUnits(number);
        return A.SassNumber_SassNumber$withUnits0(t1, number.get$denominatorUnits(number), t2);
      }
      if (_0_1 instanceof A.SassNumber0) {
        if (_0_4_isSet) {
          t1 = _0_20;
          _0_2_isSet = _0_4_isSet;
        } else {
          t1 = _0_2;
          _0_20 = t1;
          _0_2_isSet = true;
        }
        if (t1 instanceof A.SassNumber0) {
          if (_0_2_isSet)
            t1 = _0_20;
          else {
            t1 = _0_2;
            _0_20 = t1;
            _0_2_isSet = true;
          }
          type$.SassNumber_2._as(t1);
          if (_0_6_isSet)
            t2 = _0_6;
          else {
            if (_0_5_isSet)
              t2 = _0_50;
            else {
              t2 = _0_5;
              _0_50 = t2;
              _0_5_isSet = true;
            }
            _0_6 = t2 == null;
            t2 = _0_6;
            _0_6_isSet = true;
          }
          t2 = t2 && !_0_1.hasCompatibleUnits$1(t1);
          step = t1;
          t1 = t2;
        } else {
          step = _null;
          t1 = false;
        }
        number = _0_1;
      } else {
        step = _null;
        number = step;
        _0_2_isSet = _0_4_isSet;
        t1 = false;
      }
      if (t1) {
        t1 = type$.JSArray_Object;
        A.SassCalculation__verifyCompatibleNumbers0(A._setArrayType([number, step], t1));
        return new A.SassCalculation0(_s5_, A._setArrayType([number, step], t1));
      }
      if (_0_1 instanceof A.SassNumber0) {
        if (_0_2_isSet)
          t1 = _0_20;
        else {
          t1 = _0_2;
          _0_20 = t1;
          _0_2_isSet = true;
        }
        if (t1 instanceof A.SassNumber0) {
          if (_0_2_isSet)
            t1 = _0_20;
          else {
            t1 = _0_2;
            _0_20 = t1;
            _0_2_isSet = true;
          }
          type$.SassNumber_2._as(t1);
          if (_0_6_isSet)
            t2 = _0_6;
          else {
            if (_0_5_isSet)
              t2 = _0_50;
            else {
              t2 = _0_5;
              _0_50 = t2;
              _0_5_isSet = true;
            }
            _0_6 = t2 == null;
            t2 = _0_6;
            _0_6_isSet = true;
          }
          step = t1;
          t1 = t2;
        } else {
          step = _null;
          t1 = false;
        }
        number = _0_1;
      } else {
        step = _null;
        number = step;
        t1 = false;
      }
      if (t1) {
        A.SassCalculation__verifyCompatibleNumbers0(A._setArrayType([number, step], type$.JSArray_Object));
        return A.SassCalculation__roundWithStep0("nearest", number, step);
      }
      _0_10_isSet = _0_1 instanceof A.SassString0;
      if (_0_10_isSet) {
        _0_8 = _0_1._string0$_text;
        t1 = _0_8;
        _0_10 = "nearest" === t1;
        t1 = _0_10;
        _0_12_isSet = !t1;
        if (_0_12_isSet) {
          _0_12 = "up" === _0_8;
          t1 = _0_12;
          _0_14_isSet = !t1;
          if (_0_14_isSet) {
            _0_14 = "down" === _0_8;
            t1 = _0_14;
            _0_16_isSet = !t1;
            if (_0_16_isSet) {
              _0_16 = "to-zero" === _0_8;
              t1 = _0_16;
            } else {
              _0_16 = _null;
              t1 = true;
            }
          } else {
            _0_16 = _null;
            _0_14 = _0_16;
            _0_16_isSet = false;
            t1 = true;
          }
        } else {
          _0_16 = _null;
          _0_14 = _0_16;
          _0_12 = _0_14;
          _0_14_isSet = false;
          _0_16_isSet = false;
          t1 = true;
        }
        if (t1) {
          if (_0_2_isSet)
            t1 = _0_20;
          else {
            t1 = _0_2;
            _0_20 = t1;
            _0_2_isSet = true;
          }
          if (t1 instanceof A.SassNumber0) {
            if (_0_2_isSet)
              t1 = _0_20;
            else {
              t1 = _0_2;
              _0_20 = t1;
              _0_2_isSet = true;
            }
            t2 = type$.SassNumber_2;
            t2._as(t1);
            if (_0_5_isSet)
              t3 = _0_50;
            else {
              t3 = _0_5;
              _0_50 = t3;
              _0_5_isSet = true;
            }
            if (t3 instanceof A.SassNumber0) {
              if (_0_5_isSet)
                t3 = _0_50;
              else {
                t3 = _0_5;
                _0_50 = t3;
                _0_5_isSet = true;
              }
              t2._as(t3);
              t2 = !t1.hasCompatibleUnits$1(t3);
              step = t3;
            } else {
              step = _null;
              t2 = false;
            }
            number = t1;
            t1 = t2;
          } else {
            step = _null;
            number = step;
            t1 = false;
          }
          strategy = _0_1;
        } else {
          step = _null;
          number = step;
          strategy = number;
          t1 = false;
        }
      } else {
        step = _null;
        number = step;
        strategy = number;
        _0_16 = strategy;
        _0_14 = _0_16;
        _0_12 = _0_14;
        _0_8 = _0_12;
        _0_10 = _0_8;
        _0_12_isSet = false;
        _0_14_isSet = false;
        _0_16_isSet = false;
        t1 = false;
      }
      if (t1) {
        t1 = type$.JSArray_Object;
        A.SassCalculation__verifyCompatibleNumbers0(A._setArrayType([number, step], t1));
        return new A.SassCalculation0(_s5_, A._setArrayType([strategy, number, step], t1));
      }
      if (_0_1 instanceof A.SassString0) {
        if (_0_10_isSet) {
          t1 = _0_10;
          _0_8_isSet = _0_10_isSet;
        } else {
          _0_8 = _0_1._string0$_text;
          t1 = _0_8;
          _0_10 = "nearest" === t1;
          t1 = _0_10;
          _0_10_isSet = true;
          _0_8_isSet = true;
        }
        if (!t1) {
          if (_0_12_isSet)
            t1 = _0_12;
          else {
            if (_0_8_isSet)
              t1 = _0_8;
            else {
              _0_8 = _0_1._string0$_text;
              t1 = _0_8;
              _0_8_isSet = true;
            }
            _0_12 = "up" === t1;
            t1 = _0_12;
            _0_12_isSet = true;
          }
          if (!t1) {
            if (_0_14_isSet)
              t1 = _0_14;
            else {
              if (_0_8_isSet)
                t1 = _0_8;
              else {
                _0_8 = _0_1._string0$_text;
                t1 = _0_8;
                _0_8_isSet = true;
              }
              _0_14 = "down" === t1;
              t1 = _0_14;
              _0_14_isSet = true;
            }
            if (!t1)
              if (_0_16_isSet)
                t1 = _0_16;
              else {
                if (_0_8_isSet)
                  t1 = _0_8;
                else {
                  _0_8 = _0_1._string0$_text;
                  t1 = _0_8;
                  _0_8_isSet = true;
                }
                _0_16 = "to-zero" === t1;
                t1 = _0_16;
                _0_16_isSet = true;
              }
            else
              t1 = true;
          } else
            t1 = true;
        } else
          t1 = true;
        if (t1) {
          if (_0_2_isSet)
            t1 = _0_20;
          else {
            t1 = _0_2;
            _0_20 = t1;
            _0_2_isSet = true;
          }
          if (t1 instanceof A.SassNumber0) {
            if (_0_2_isSet)
              t1 = _0_20;
            else {
              t1 = _0_2;
              _0_20 = t1;
              _0_2_isSet = true;
            }
            t2 = type$.SassNumber_2;
            t2._as(t1);
            if (_0_5_isSet)
              t3 = _0_50;
            else {
              t3 = _0_5;
              _0_50 = t3;
              _0_5_isSet = true;
            }
            t3 = t3 instanceof A.SassNumber0;
            if (t3) {
              if (_0_5_isSet)
                t4 = _0_50;
              else {
                t4 = _0_5;
                _0_50 = t4;
                _0_5_isSet = true;
              }
              t2._as(t4);
              step = t4;
            } else
              step = _null;
            t2 = t3;
            number = t1;
            t1 = t2;
          } else {
            step = _null;
            number = step;
            t1 = false;
          }
          strategy = _0_1;
        } else {
          step = _null;
          number = step;
          strategy = number;
          t1 = false;
        }
      } else {
        step = _null;
        number = step;
        strategy = number;
        _0_8_isSet = _0_10_isSet;
        t1 = false;
      }
      if (t1) {
        A.SassCalculation__verifyCompatibleNumbers0(A._setArrayType([number, step], type$.JSArray_Object));
        return A.SassCalculation__roundWithStep0(strategy._string0$_text, number, step);
      }
      if (_0_1 instanceof A.SassString0) {
        if (_0_10_isSet)
          t1 = _0_10;
        else {
          if (_0_8_isSet)
            t1 = _0_8;
          else {
            _0_8 = _0_1._string0$_text;
            t1 = _0_8;
            _0_8_isSet = true;
          }
          _0_10 = "nearest" === t1;
          t1 = _0_10;
          _0_10_isSet = true;
        }
        if (!t1) {
          if (_0_12_isSet)
            t1 = _0_12;
          else {
            if (_0_8_isSet)
              t1 = _0_8;
            else {
              _0_8 = _0_1._string0$_text;
              t1 = _0_8;
              _0_8_isSet = true;
            }
            _0_12 = "up" === t1;
            t1 = _0_12;
            _0_12_isSet = true;
          }
          if (!t1) {
            if (_0_14_isSet)
              t1 = _0_14;
            else {
              if (_0_8_isSet)
                t1 = _0_8;
              else {
                _0_8 = _0_1._string0$_text;
                t1 = _0_8;
                _0_8_isSet = true;
              }
              _0_14 = "down" === t1;
              t1 = _0_14;
              _0_14_isSet = true;
            }
            if (!t1)
              if (_0_16_isSet)
                t1 = _0_16;
              else {
                if (_0_8_isSet)
                  t1 = _0_8;
                else {
                  _0_8 = _0_1._string0$_text;
                  t1 = _0_8;
                  _0_8_isSet = true;
                }
                _0_16 = "to-zero" === t1;
                t1 = _0_16;
                _0_16_isSet = true;
              }
            else
              t1 = true;
          } else
            t1 = true;
        } else
          t1 = true;
        if (t1) {
          if (_0_2_isSet)
            t1 = _0_20;
          else {
            t1 = _0_2;
            _0_20 = t1;
            _0_2_isSet = true;
          }
          if (t1 instanceof A.SassString0) {
            if (_0_2_isSet)
              t1 = _0_20;
            else {
              t1 = _0_2;
              _0_20 = t1;
              _0_2_isSet = true;
            }
            type$.SassString_2._as(t1);
            if (_0_6_isSet)
              t2 = _0_6;
            else {
              if (_0_5_isSet)
                t2 = _0_50;
              else {
                t2 = _0_5;
                _0_50 = t2;
                _0_5_isSet = true;
              }
              _0_6 = t2 == null;
              t2 = _0_6;
              _0_6_isSet = true;
            }
            rest = t1;
            t1 = t2;
          } else {
            rest = _null;
            t1 = false;
          }
          strategy = _0_1;
        } else {
          rest = _null;
          strategy = rest;
          t1 = false;
        }
      } else {
        rest = _null;
        strategy = rest;
        t1 = false;
      }
      if (t1)
        return new A.SassCalculation0(_s5_, A._setArrayType([strategy, rest], type$.JSArray_Object));
      if (_0_1 instanceof A.SassString0) {
        if (_0_10_isSet)
          t1 = _0_10;
        else {
          if (_0_8_isSet)
            t1 = _0_8;
          else {
            _0_8 = _0_1._string0$_text;
            t1 = _0_8;
            _0_8_isSet = true;
          }
          _0_10 = "nearest" === t1;
          t1 = _0_10;
          _0_10_isSet = true;
        }
        if (!t1) {
          if (_0_12_isSet)
            t1 = _0_12;
          else {
            if (_0_8_isSet)
              t1 = _0_8;
            else {
              _0_8 = _0_1._string0$_text;
              t1 = _0_8;
              _0_8_isSet = true;
            }
            _0_12 = "up" === t1;
            t1 = _0_12;
            _0_12_isSet = true;
          }
          if (!t1) {
            if (_0_14_isSet)
              t1 = _0_14;
            else {
              if (_0_8_isSet)
                t1 = _0_8;
              else {
                _0_8 = _0_1._string0$_text;
                t1 = _0_8;
                _0_8_isSet = true;
              }
              _0_14 = "down" === t1;
              t1 = _0_14;
              _0_14_isSet = true;
            }
            if (!t1)
              if (_0_16_isSet)
                t1 = _0_16;
              else {
                if (_0_8_isSet)
                  t1 = _0_8;
                else {
                  _0_8 = _0_1._string0$_text;
                  t1 = _0_8;
                  _0_8_isSet = true;
                }
                _0_16 = "to-zero" === t1;
                t1 = _0_16;
                _0_16_isSet = true;
              }
            else
              t1 = true;
          } else
            t1 = true;
        } else
          t1 = true;
        if (t1) {
          if (_0_2_isSet)
            t1 = _0_20;
          else {
            t1 = _0_2;
            _0_20 = t1;
            _0_2_isSet = true;
          }
          if (t1 != null)
            if (_0_6_isSet)
              t1 = _0_6;
            else {
              if (_0_5_isSet)
                t1 = _0_50;
              else {
                t1 = _0_5;
                _0_50 = t1;
                _0_5_isSet = true;
              }
              _0_6 = t1 == null;
              t1 = _0_6;
              _0_6_isSet = true;
            }
          else
            t1 = false;
        } else
          t1 = false;
      } else
        t1 = false;
      if (t1)
        throw A.wrapException(A.SassScriptException$0(string$.If_str, _null));
      if (_0_1 instanceof A.SassString0) {
        if (_0_10_isSet)
          t1 = _0_10;
        else {
          if (_0_8_isSet)
            t1 = _0_8;
          else {
            _0_8 = _0_1._string0$_text;
            t1 = _0_8;
            _0_8_isSet = true;
          }
          _0_10 = "nearest" === t1;
          t1 = _0_10;
          _0_10_isSet = true;
        }
        if (!t1) {
          if (_0_12_isSet)
            t1 = _0_12;
          else {
            if (_0_8_isSet)
              t1 = _0_8;
            else {
              _0_8 = _0_1._string0$_text;
              t1 = _0_8;
              _0_8_isSet = true;
            }
            _0_12 = "up" === t1;
            t1 = _0_12;
            _0_12_isSet = true;
          }
          if (!t1) {
            if (_0_14_isSet)
              t1 = _0_14;
            else {
              if (_0_8_isSet)
                t1 = _0_8;
              else {
                _0_8 = _0_1._string0$_text;
                t1 = _0_8;
                _0_8_isSet = true;
              }
              _0_14 = "down" === t1;
              t1 = _0_14;
              _0_14_isSet = true;
            }
            if (!t1)
              if (_0_16_isSet)
                t1 = _0_16;
              else {
                if (_0_8_isSet)
                  t1 = _0_8;
                else {
                  _0_8 = _0_1._string0$_text;
                  t1 = _0_8;
                  _0_8_isSet = true;
                }
                _0_16 = "to-zero" === t1;
                t1 = _0_16;
                _0_16_isSet = true;
              }
            else
              t1 = true;
          } else
            t1 = true;
        } else
          t1 = true;
        if (t1) {
          if (_0_4_isSet)
            t1 = _0_4;
          else {
            if (_0_2_isSet)
              t1 = _0_20;
            else {
              t1 = _0_2;
              _0_20 = t1;
              _0_2_isSet = true;
            }
            _0_4 = t1 == null;
            t1 = _0_4;
            _0_4_isSet = true;
          }
          if (t1)
            if (_0_6_isSet)
              t1 = _0_6;
            else {
              if (_0_5_isSet)
                t1 = _0_50;
              else {
                t1 = _0_5;
                _0_50 = t1;
                _0_5_isSet = true;
              }
              _0_6 = t1 == null;
              t1 = _0_6;
              _0_6_isSet = true;
            }
          else
            t1 = false;
        } else
          t1 = false;
      } else
        t1 = false;
      if (t1)
        throw A.wrapException(A.SassScriptException$0(string$.Number, _null));
      if (_0_1 instanceof A.SassString0) {
        if (_0_4_isSet)
          t1 = _0_4;
        else {
          if (_0_2_isSet)
            t1 = _0_20;
          else {
            t1 = _0_2;
            _0_20 = t1;
            _0_2_isSet = true;
          }
          _0_4 = t1 == null;
          t1 = _0_4;
          _0_4_isSet = true;
        }
        if (t1)
          if (_0_6_isSet)
            t1 = _0_6;
          else {
            if (_0_5_isSet)
              t1 = _0_50;
            else {
              t1 = _0_5;
              _0_50 = t1;
              _0_5_isSet = true;
            }
            _0_6 = t1 == null;
            t1 = _0_6;
            _0_6_isSet = true;
          }
        else
          t1 = false;
        rest = _0_1;
      } else {
        rest = _null;
        t1 = false;
      }
      if (t1)
        return new A.SassCalculation0(_s5_, A._setArrayType([rest], type$.JSArray_Object));
      if (_0_4_isSet)
        t1 = _0_4;
      else {
        if (_0_2_isSet)
          t1 = _0_20;
        else {
          t1 = _0_2;
          _0_20 = t1;
          _0_2_isSet = true;
        }
        _0_4 = t1 == null;
        t1 = _0_4;
      }
      if (t1)
        if (_0_6_isSet)
          t1 = _0_6;
        else {
          if (_0_5_isSet)
            t1 = _0_50;
          else {
            t1 = _0_5;
            _0_50 = t1;
            _0_5_isSet = true;
          }
          _0_6 = t1 == null;
          t1 = _0_6;
          _0_6_isSet = true;
        }
      else
        t1 = false;
      if (t1)
        throw A.wrapException(A.SassScriptException$0("Single argument " + A.S(_0_1) + " expected to be simplifiable.", _null));
      if (_0_2_isSet)
        t1 = _0_20;
      else {
        t1 = _0_2;
        _0_20 = t1;
        _0_2_isSet = true;
      }
      if (t1 != null) {
        if (_0_2_isSet)
          step = _0_20;
        else {
          step = _0_2;
          _0_20 = step;
          _0_2_isSet = true;
        }
        if (step == null)
          step = type$.Object._as(step);
        if (_0_6_isSet)
          t1 = _0_6;
        else {
          if (_0_5_isSet)
            t1 = _0_50;
          else {
            t1 = _0_5;
            _0_50 = t1;
            _0_5_isSet = true;
          }
          _0_6 = t1 == null;
          t1 = _0_6;
        }
      } else {
        step = _null;
        t1 = false;
      }
      if (t1)
        return new A.SassCalculation0(_s5_, A._setArrayType([_0_1, step], type$.JSArray_Object));
      if (_0_1 instanceof A.SassString0) {
        if (_0_10_isSet)
          t1 = _0_10;
        else {
          if (_0_8_isSet)
            t1 = _0_8;
          else {
            _0_8 = _0_1._string0$_text;
            t1 = _0_8;
            _0_8_isSet = true;
          }
          _0_10 = "nearest" === t1;
          t1 = _0_10;
        }
        if (!t1) {
          if (_0_12_isSet)
            t1 = _0_12;
          else {
            if (_0_8_isSet)
              t1 = _0_8;
            else {
              _0_8 = _0_1._string0$_text;
              t1 = _0_8;
              _0_8_isSet = true;
            }
            _0_12 = "up" === t1;
            t1 = _0_12;
          }
          if (!t1) {
            if (_0_14_isSet)
              t1 = _0_14;
            else {
              if (_0_8_isSet)
                t1 = _0_8;
              else {
                _0_8 = _0_1._string0$_text;
                t1 = _0_8;
                _0_8_isSet = true;
              }
              _0_14 = "down" === t1;
              t1 = _0_14;
            }
            if (!t1)
              if (_0_16_isSet)
                t1 = _0_16;
              else {
                if (_0_8_isSet)
                  t1 = _0_8;
                else {
                  _0_8 = _0_1._string0$_text;
                  t1 = _0_8;
                }
                _0_16 = "to-zero" === t1;
                t1 = _0_16;
              }
            else
              t1 = true;
          } else
            t1 = true;
        } else
          t1 = true;
      } else
        t1 = false;
      if (!t1)
        if (_0_1 instanceof A.SassString0)
          t1 = _0_1.get$isVar();
        else
          t1 = false;
      else
        t1 = true;
      if (t1) {
        type$.SassString_2._as(_0_1);
        if (_0_2_isSet)
          t1 = _0_20;
        else {
          t1 = _0_2;
          _0_20 = t1;
          _0_2_isSet = true;
        }
        if (t1 != null) {
          if (_0_2_isSet)
            number = _0_20;
          else {
            number = _0_2;
            _0_20 = number;
            _0_2_isSet = true;
          }
          if (number == null)
            number = type$.Object._as(number);
          if (_0_5_isSet)
            t1 = _0_50;
          else {
            t1 = _0_5;
            _0_50 = t1;
            _0_5_isSet = true;
          }
          t1 = t1 != null;
          if (t1) {
            if (_0_5_isSet)
              step = _0_50;
            else {
              step = _0_5;
              _0_50 = step;
              _0_5_isSet = true;
            }
            if (step == null)
              step = type$.Object._as(step);
          } else
            step = _null;
        } else {
          step = _null;
          number = step;
          t1 = false;
        }
        strategy = _0_1;
      } else {
        step = _null;
        number = step;
        strategy = number;
        t1 = false;
      }
      if (t1)
        return new A.SassCalculation0(_s5_, A._setArrayType([strategy, number, step], type$.JSArray_Object));
      if ((_0_2_isSet ? _0_20 : _0_2) != null)
        t1 = (_0_5_isSet ? _0_50 : _0_5) != null;
      else
        t1 = false;
      if (t1)
        throw A.wrapException(A.SassScriptException$0(A.S(strategyOrNumber) + string$.x20must_b, _null));
      t1 = A.SassScriptException$0("Invalid parameters.", _null);
      throw A.wrapException(t1);
    },
    SassCalculation_operateInternal0(operator, left, right, inLegacySassFunction, simplify) {
      var t1;
      if (!simplify)
        return new A.CalculationOperation0(operator, left, right);
      left = A.SassCalculation__simplify0(left);
      right = A.SassCalculation__simplify0(right);
      if (B.CalculationOperator_g2q0 === operator || B.CalculationOperator_CxF0 === operator) {
        if (left instanceof A.SassNumber0)
          if (right instanceof A.SassNumber0)
            t1 = inLegacySassFunction ? left.isComparableTo$1(right) : left.hasCompatibleUnits$1(right);
          else
            t1 = false;
        else
          t1 = false;
        if (t1)
          return operator === B.CalculationOperator_g2q0 ? left.plus$1(right) : left.minus$1(right);
        A.SassCalculation__verifyCompatibleNumbers0(A._setArrayType([left, right], type$.JSArray_Object));
        if (right instanceof A.SassNumber0) {
          t1 = right._number1$_value;
          t1 = t1 < 0 && !A.fuzzyEquals0(t1, 0);
        } else
          t1 = false;
        if (t1) {
          right = right.times$1(A.SassNumber_SassNumber0(-1, null));
          operator = operator === B.CalculationOperator_g2q0 ? B.CalculationOperator_CxF0 : B.CalculationOperator_g2q0;
        }
        return new A.CalculationOperation0(operator, left, right);
      } else if (left instanceof A.SassNumber0 && right instanceof A.SassNumber0)
        return operator === B.CalculationOperator_1710 ? left.times$1(right) : left.dividedBy$1(right);
      else
        return new A.CalculationOperation0(operator, left, right);
    },
    SassCalculation__roundWithStep0(strategy, number, step) {
      var _0_2, t1, _0_6, _0_8_isSet, _0_8, _0_9_isSet, _0_9, _0_11, _0_13, stepWithNumberUnit, t2, _null = null;
      if (!A.LinkedHashSet_LinkedHashSet$_literal(["nearest", "up", "down", "to-zero"], type$.String).contains$1(0, strategy))
        throw A.wrapException(A.ArgumentError$(strategy + string$.x20must_b, _null));
      _0_2 = number._number1$_value;
      if (_0_2 == 1 / 0 || _0_2 == -1 / 0) {
        t1 = step._number1$_value;
        t1 = t1 == 1 / 0 || t1 == -1 / 0;
      } else
        t1 = false;
      if (!t1) {
        t1 = step._number1$_value;
        t1 = t1 === 0 || isNaN(_0_2) || isNaN(t1);
      } else
        t1 = true;
      if (t1) {
        t1 = number.get$numeratorUnits(number);
        return A.SassNumber_SassNumber$withUnits0(0 / 0, number.get$denominatorUnits(number), t1);
      }
      if (_0_2 == 1 / 0 || _0_2 == -1 / 0)
        return number;
      t1 = step._number1$_value;
      if (t1 == 1 / 0 || t1 == -1 / 0) {
        $label0$0: {
          if (0 === _0_2) {
            t1 = number;
            break $label0$0;
          }
          _0_6 = "nearest" === strategy;
          t1 = _0_6;
          _0_8_isSet = !t1;
          if (_0_8_isSet) {
            _0_8 = "to-zero" === strategy;
            _0_9_isSet = _0_8;
          } else {
            _0_8 = _null;
            _0_9_isSet = true;
          }
          if (_0_9_isSet) {
            _0_9 = _0_2 > 0;
            t1 = _0_9;
          } else {
            _0_9 = _null;
            t1 = false;
          }
          if (t1) {
            t1 = number.get$numeratorUnits(number);
            t1 = A.SassNumber_SassNumber$withUnits0(0, number.get$denominatorUnits(number), t1);
            break $label0$0;
          }
          if (!_0_6)
            if (_0_8_isSet)
              t1 = _0_8;
            else {
              _0_8 = "to-zero" === strategy;
              t1 = _0_8;
            }
          else
            t1 = true;
          if (t1) {
            t1 = number.get$numeratorUnits(number);
            t1 = A.SassNumber_SassNumber$withUnits0(-0.0, number.get$denominatorUnits(number), t1);
            break $label0$0;
          }
          _0_11 = "up" === strategy;
          t1 = _0_11;
          if (t1)
            if (_0_9_isSet)
              t1 = _0_9;
            else {
              _0_9 = _0_2 > 0;
              t1 = _0_9;
            }
          else
            t1 = false;
          if (t1) {
            t1 = number.get$numeratorUnits(number);
            t1 = A.SassNumber_SassNumber$withUnits0(1 / 0, number.get$denominatorUnits(number), t1);
            break $label0$0;
          }
          if (_0_11) {
            t1 = number.get$numeratorUnits(number);
            t1 = A.SassNumber_SassNumber$withUnits0(-0.0, number.get$denominatorUnits(number), t1);
            break $label0$0;
          }
          _0_13 = "down" === strategy;
          t1 = _0_13;
          if (t1)
            t1 = _0_2 < 0;
          else
            t1 = false;
          if (t1) {
            t1 = number.get$numeratorUnits(number);
            t1 = A.SassNumber_SassNumber$withUnits0(-1 / 0, number.get$denominatorUnits(number), t1);
            break $label0$0;
          }
          if (_0_13) {
            t1 = number.get$numeratorUnits(number);
            t1 = A.SassNumber_SassNumber$withUnits0(0, number.get$denominatorUnits(number), t1);
            break $label0$0;
          }
          t1 = A.throwExpression(A.UnsupportedError$("Invalid argument: " + strategy + "."));
        }
        return t1;
      }
      stepWithNumberUnit = step.convertValueToMatch$1(number);
      $label1$1: {
        if ("nearest" === strategy) {
          t1 = B.JSNumber_methods.round$0(_0_2 / stepWithNumberUnit);
          t2 = number.get$numeratorUnits(number);
          t2 = A.SassNumber_SassNumber$withUnits0(t1 * stepWithNumberUnit, number.get$denominatorUnits(number), t2);
          t1 = t2;
          break $label1$1;
        }
        if ("up" === strategy) {
          t2 = _0_2 / stepWithNumberUnit;
          t1 = t1 < 0 ? B.JSNumber_methods.floor$0(t2) : B.JSNumber_methods.ceil$0(t2);
          t2 = number.get$numeratorUnits(number);
          t2 = A.SassNumber_SassNumber$withUnits0(t1 * stepWithNumberUnit, number.get$denominatorUnits(number), t2);
          t1 = t2;
          break $label1$1;
        }
        if ("down" === strategy) {
          t2 = _0_2 / stepWithNumberUnit;
          t1 = t1 < 0 ? B.JSNumber_methods.ceil$0(t2) : B.JSNumber_methods.floor$0(t2);
          t2 = number.get$numeratorUnits(number);
          t2 = A.SassNumber_SassNumber$withUnits0(t1 * stepWithNumberUnit, number.get$denominatorUnits(number), t2);
          t1 = t2;
          break $label1$1;
        }
        if ("to-zero" === strategy) {
          t1 = _0_2 / stepWithNumberUnit;
          if (_0_2 < 0) {
            t1 = B.JSNumber_methods.ceil$0(t1);
            t2 = number.get$numeratorUnits(number);
            t2 = A.SassNumber_SassNumber$withUnits0(t1 * stepWithNumberUnit, number.get$denominatorUnits(number), t2);
            t1 = t2;
          } else {
            t1 = B.JSNumber_methods.floor$0(t1);
            t2 = number.get$numeratorUnits(number);
            t2 = A.SassNumber_SassNumber$withUnits0(t1 * stepWithNumberUnit, number.get$denominatorUnits(number), t2);
            t1 = t2;
          }
          break $label1$1;
        }
        t1 = number.get$numeratorUnits(number);
        t1 = A.SassNumber_SassNumber$withUnits0(0 / 0, number.get$denominatorUnits(number), t1);
        break $label1$1;
      }
      return t1;
    },
    SassCalculation__simplify0(arg) {
      var t1, _0_11_isSet, _0_11, _0_12, _0_15, _0_16_isSet, _0_16, text, _0_12_isSet, _0_15_isSet, value, _null = null,
        _s32_ = " can't be used in a calculation.";
      $label0$0: {
        if (arg instanceof A.SassNumber0 || arg instanceof A.CalculationOperation0) {
          t1 = arg;
          break $label0$0;
        }
        if (arg instanceof A.CalculationInterpolation) {
          t1 = new A.SassString0("(" + arg._calculation0$_value + ")", false);
          break $label0$0;
        }
        t1 = arg instanceof A.SassString0;
        if (t1 && !arg._string0$_hasQuotes) {
          t1 = arg;
          break $label0$0;
        }
        if (t1)
          A.throwExpression(A.SassScriptException$0("Quoted string " + arg.toString$0(0) + _s32_, _null));
        _0_11_isSet = arg instanceof A.SassCalculation0;
        if (_0_11_isSet) {
          _0_11 = "calc" === arg.name;
          if (_0_11) {
            _0_12 = arg.$arguments;
            _0_15 = _0_12.length === 1;
            _0_16_isSet = _0_15;
            if (_0_16_isSet) {
              _0_16 = _0_12[0];
              t1 = _0_16;
              if (t1 instanceof A.SassString0) {
                type$.SassString_2._as(_0_16);
                if (!_0_16._string0$_hasQuotes) {
                  text = _0_16._string0$_text;
                  t1 = A.SassCalculation__needsParentheses0(text);
                } else {
                  text = _null;
                  t1 = false;
                }
              } else {
                text = _null;
                t1 = false;
              }
            } else {
              text = _null;
              _0_16 = text;
              t1 = false;
            }
          } else {
            text = _null;
            _0_16 = text;
            _0_12 = _0_16;
            _0_15 = _0_12;
            _0_16_isSet = false;
            t1 = false;
          }
          _0_12_isSet = _0_11;
          _0_15_isSet = _0_12_isSet;
        } else {
          text = _null;
          _0_16 = text;
          _0_12 = _0_16;
          _0_15 = _0_12;
          _0_11 = _0_15;
          _0_15_isSet = false;
          _0_12_isSet = false;
          _0_16_isSet = false;
          t1 = false;
        }
        if (t1) {
          t1 = new A.SassString0("(" + A.S(text) + ")", false);
          break $label0$0;
        }
        if (_0_11_isSet)
          if (_0_11)
            if (_0_15_isSet)
              t1 = _0_15;
            else {
              if (_0_12_isSet)
                t1 = _0_12;
              else {
                _0_12 = arg.$arguments;
                t1 = _0_12;
                _0_12_isSet = true;
              }
              _0_15 = t1.length === 1;
              t1 = _0_15;
            }
          else
            t1 = false;
        else
          t1 = false;
        if (t1) {
          if (_0_16_isSet)
            value = _0_16;
          else {
            _0_16 = (_0_12_isSet ? _0_12 : arg.$arguments)[0];
            value = _0_16;
          }
          t1 = value;
          break $label0$0;
        }
        if (_0_11_isSet) {
          t1 = arg;
          break $label0$0;
        }
        if (arg instanceof A.Value0)
          A.throwExpression(A.SassScriptException$0("Value " + arg.toString$0(0) + _s32_, _null));
        t1 = A.throwExpression(A.ArgumentError$("Unexpected calculation argument " + A.S(arg) + ".", _null));
      }
      return t1;
    },
    SassCalculation__needsParentheses0(text) {
      var t1, couldBeVar, second, third, fourth, i, t2,
        first = text.charCodeAt(0);
      if (first === 32 || first === 9 || first === 10 || first === 13 || first === 12 || first === 47 || first === 42)
        return true;
      t1 = text.length;
      couldBeVar = t1 >= 4 && A.characterEqualsIgnoreCase0(first, 118);
      if (t1 < 2)
        return false;
      second = text.charCodeAt(1);
      if (second === 32 || second === 9 || second === 10 || second === 13 || second === 12 || second === 47 || second === 42)
        return true;
      couldBeVar = couldBeVar && A.characterEqualsIgnoreCase0(second, 97);
      if (t1 < 3)
        return false;
      third = text.charCodeAt(2);
      if (third === 32 || third === 9 || third === 10 || third === 13 || third === 12 || third === 47 || third === 42)
        return true;
      couldBeVar = couldBeVar && A.characterEqualsIgnoreCase0(third, 114);
      if (t1 < 4)
        return false;
      fourth = text.charCodeAt(3);
      if (couldBeVar && fourth === 40)
        return true;
      if (fourth === 32 || fourth === 9 || fourth === 10 || fourth === 13 || fourth === 12 || fourth === 47 || fourth === 42)
        return true;
      for (i = 4; i < t1; ++i) {
        t2 = text.charCodeAt(i);
        if (t2 === 32 || t2 === 9 || t2 === 10 || t2 === 13 || t2 === 12 || t2 === 47 || t2 === 42)
          return true;
      }
      return false;
    },
    SassCalculation__verifyCompatibleNumbers0(args) {
      var t1, _i, t2, arg, i, number1, j, number2;
      for (t1 = args.length, _i = 0; t2 = args.length, _i < t2; args.length === t1 || (0, A.throwConcurrentModificationError)(args), ++_i) {
        arg = args[_i];
        if (arg instanceof A.SassNumber0 && arg.get$hasComplexUnits())
          throw A.wrapException(A.SassScriptException$0("Number " + A.S(arg) + " isn't compatible with CSS calculations.", null));
      }
      for (t1 = t2, i = 0; i < t1 - 1; ++i) {
        number1 = args[i];
        if (!(number1 instanceof A.SassNumber0))
          continue;
        for (j = i + 1; t1 = args.length, j < t1; ++j) {
          number2 = args[j];
          if (!(number2 instanceof A.SassNumber0))
            continue;
          if (number1.hasPossiblyCompatibleUnits$1(number2))
            continue;
          throw A.wrapException(A.SassScriptException$0(number1.toString$0(0) + " and " + number2.toString$0(0) + " are incompatible.", null));
        }
      }
    },
    SassCalculation__verifyLength0(args, expectedLength) {
      var t1;
      if (args.length === expectedLength)
        return;
      if (B.JSArray_methods.any$1(args, new A.SassCalculation__verifyLength_closure0()))
        return;
      t1 = args.length;
      throw A.wrapException(A.SassScriptException$0("" + expectedLength + " arguments required, but only " + t1 + " " + A.pluralize0("was", t1, "were") + " passed.", null));
    },
    SassCalculation__singleArgument0($name, argument, mathFunc, forbidUnits) {
      argument = A.SassCalculation__simplify0(argument);
      if (!(argument instanceof A.SassNumber0))
        return new A.SassCalculation0($name, A._setArrayType([argument], type$.JSArray_Object));
      if (forbidUnits)
        argument.assertNoUnits$0();
      return mathFunc.call$1(argument);
    },
    SassCalculation0: function SassCalculation0(t0, t1) {
      this.name = t0;
      this.$arguments = t1;
    },
    SassCalculation__verifyLength_closure0: function SassCalculation__verifyLength_closure0() {
    },
    CalculationOperation0: function CalculationOperation0(t0, t1, t2) {
      this._calculation0$_operator = t0;
      this._calculation0$_left = t1;
      this._calculation0$_right = t2;
    },
    CalculationOperator0: function CalculationOperator0(t0, t1, t2, t3) {
      var _ = this;
      _.name = t0;
      _.operator = t1;
      _.precedence = t2;
      _._name = t3;
    },
    CalculationInterpolation: function CalculationInterpolation(t0) {
      this._calculation0$_value = t0;
    },
    CallableDeclaration0: function CallableDeclaration0() {
    },
    updateCanonicalizeContextPrototype() {
      var t1 = type$.JSClass._as(new A.CanonicalizeContext0(false, null).constructor);
      A.LinkedHashMap_LinkedHashMap$_literal(["fromImport", new A.updateCanonicalizeContextPrototype_closure(), "containingUrl", new A.updateCanonicalizeContextPrototype_closure0()], type$.String, type$.Function).forEach$1(0, A.JSClassExtension_get_defineGetter(t1));
      return null;
    },
    updateCanonicalizeContextPrototype_closure: function updateCanonicalizeContextPrototype_closure() {
    },
    updateCanonicalizeContextPrototype_closure0: function updateCanonicalizeContextPrototype_closure0() {
    },
    CanonicalizeContext0: function CanonicalizeContext0(t0, t1) {
      this._canonicalize_context$_fromImport = t0;
      this._canonicalize_context$_containingUrl = t1;
      this._canonicalize_context$_wasContainingUrlAccessed = false;
    },
    Chokidar0: function Chokidar0() {
    },
    ChokidarOptions0: function ChokidarOptions0() {
    },
    ChokidarWatcher0: function ChokidarWatcher0() {
    },
    ClassSelector0: function ClassSelector0(t0, t1) {
      this.name = t0;
      this.span = t1;
    },
    cloneCssStylesheet0(stylesheet, extensionStore) {
      var _0_0 = extensionStore.clone$0();
      return new A._Record_2(new A._CloneCssVisitor0(_0_0._1)._clone_css$_visitChildren$2(A.ModifiableCssStylesheet$0(stylesheet.get$span(stylesheet)), stylesheet), _0_0._0);
    },
    _CloneCssVisitor0: function _CloneCssVisitor0(t0) {
      this._clone_css$_oldToNewSelectors = t0;
    },
    ColorExpression0: function ColorExpression0(t0, t1) {
      this.value = t0;
      this.span = t1;
    },
    _updateComponents0($arguments, adjust, change, scale) {
      var keywords, alpha, red, green, blue, hue, saturation, lightness, whiteness, blackness, hasRgb, hasSL, hasWB, t2, t3, t4, _null = null,
        t1 = J.getInterceptor$asx($arguments),
        color = t1.$index($arguments, 0).assertColor$1("color"),
        argumentList = type$.SassArgumentList_2._as(t1.$index($arguments, 1));
      if (argumentList._list1$_contents.length !== 0)
        throw A.wrapException(A.SassScriptException$0(string$.Only_op, _null));
      argumentList._argument_list$_wereKeywordsAccessed = true;
      keywords = A.LinkedHashMap_LinkedHashMap$of(argumentList._argument_list$_keywords, type$.String, type$.Value_2);
      t1 = new A._updateComponents_getParam0(keywords, scale, change);
      alpha = t1.call$3$checkUnitless("alpha", 1, true);
      red = t1.call$2("red", 255);
      green = t1.call$2("green", 255);
      blue = t1.call$2("blue", 255);
      hue = scale ? _null : A.NullableExtension_andThen0(keywords.remove$1(0, "hue"), new A._updateComponents_closure1());
      saturation = t1.call$3$checkPercent("saturation", 100, true);
      lightness = t1.call$3$checkPercent("lightness", 100, true);
      whiteness = t1.call$3$assertPercent("whiteness", 100, true);
      blackness = t1.call$3$assertPercent("blackness", 100, true);
      t1 = keywords.__js_helper$_length;
      if (t1 !== 0)
        throw A.wrapException(A.SassScriptException$0("No " + A.pluralize0("argument", t1, _null) + " named " + A.toSentence0(keywords.get$keys(0).map$1$1(0, new A._updateComponents_closure2(), type$.Object), "or") + ".", _null));
      hasRgb = red != null || green != null || blue != null;
      hasSL = saturation != null || lightness != null;
      hasWB = whiteness != null || blackness != null;
      if (hasRgb)
        t1 = hasSL || hasWB || hue != null;
      else
        t1 = false;
      if (t1)
        throw A.wrapException(A.SassScriptException$0(string$.RGB_pa + (hasWB ? "HWB" : "HSL") + " parameters.", _null));
      if (hasSL && hasWB)
        throw A.wrapException(A.SassScriptException$0(string$.HSL_pa, _null));
      t1 = new A._updateComponents_updateValue0(change, adjust);
      t2 = new A._updateComponents_updateRgb0(t1);
      if (hasRgb) {
        t3 = t2.call$2(color.get$red(0), red);
        t4 = t2.call$2(color.get$green(0), green);
        t2 = t2.call$2(color.get$blue(0), blue);
        return color.changeRgb$4$alpha$blue$green$red(t1.call$3(color._color1$_alpha, alpha, 1), t2, t4, t3);
      } else if (hasWB) {
        if (change)
          t2 = hue;
        else {
          t2 = color.get$hue(0);
          t2 += hue == null ? 0 : hue;
        }
        t3 = t1.call$3(color.get$whiteness(0), whiteness, 100);
        t4 = t1.call$3(color.get$blackness(0), blackness, 100);
        return color.changeHwb$4$alpha$blackness$hue$whiteness(t1.call$3(color._color1$_alpha, alpha, 1), t4, t2, t3);
      } else {
        t2 = hue == null;
        if (!t2 || hasSL) {
          if (change)
            t2 = hue;
          else {
            t3 = color.get$hue(0);
            t3 += t2 ? 0 : hue;
            t2 = t3;
          }
          t3 = t1.call$3(color.get$saturation(0), saturation, 100);
          t4 = t1.call$3(color.get$lightness(0), lightness, 100);
          return color.changeHsl$4$alpha$hue$lightness$saturation(t1.call$3(color._color1$_alpha, alpha, 1), t2, t4, t3);
        } else if (alpha != null)
          return color.changeAlpha$1(t1.call$3(color._color1$_alpha, alpha, 1));
        else
          return color;
      }
    },
    _functionString0($name, $arguments) {
      return new A.SassString0($name + "(" + J.map$1$1$ax($arguments, new A._functionString_closure0(), type$.String).join$1(0, ", ") + ")", false);
    },
    _removedColorFunction0($name, argument, negative) {
      return A.BuiltInCallable$function0($name, "$color, $amount", new A._removedColorFunction_closure0($name, argument, negative), "sass:color");
    },
    _rgb0($name, $arguments) {
      var t2, red, green, blue, t3, t4,
        t1 = J.getInterceptor$asx($arguments),
        alpha = t1.get$length($arguments) > 3 ? t1.$index($arguments, 3) : null;
      if (!t1.$index($arguments, 0).get$isSpecialNumber())
        if (!t1.$index($arguments, 1).get$isSpecialNumber())
          if (!t1.$index($arguments, 2).get$isSpecialNumber()) {
            t2 = alpha == null ? null : alpha.get$isSpecialNumber();
            t2 = t2 === true;
          } else
            t2 = true;
        else
          t2 = true;
      else
        t2 = true;
      if (t2)
        return A._functionString0($name, $arguments);
      red = t1.$index($arguments, 0).assertNumber$1("red");
      green = t1.$index($arguments, 1).assertNumber$1("green");
      blue = t1.$index($arguments, 2).assertNumber$1("blue");
      t1 = A.fuzzyRound0(A._percentageOrUnitless0(red, 255, "red"));
      t2 = A.fuzzyRound0(A._percentageOrUnitless0(green, 255, "green"));
      t3 = A.fuzzyRound0(A._percentageOrUnitless0(blue, 255, "blue"));
      t4 = A.NullableExtension_andThen0(alpha, new A._rgb_closure0());
      return A.SassColor$rgbInternal0(t1, t2, t3, t4 == null ? 1 : t4, B._ColorFormatEnum_rgbFunction0);
    },
    _rgbTwoArg0($name, $arguments) {
      var t2, color,
        t1 = J.getInterceptor$asx($arguments);
      if (!t1.$index($arguments, 0).get$isVar())
        t2 = !(t1.$index($arguments, 0) instanceof A.SassColor0) && t1.$index($arguments, 1).get$isVar();
      else
        t2 = true;
      if (t2)
        return A._functionString0($name, $arguments);
      else if (t1.$index($arguments, 1).get$isSpecialNumber()) {
        color = t1.$index($arguments, 0).assertColor$1("color");
        return new A.SassString0($name + "(" + color.get$red(0) + ", " + color.get$green(0) + ", " + color.get$blue(0) + ", " + A.serializeValue0(t1.$index($arguments, 1), false, true) + ")", false);
      }
      return t1.$index($arguments, 0).assertColor$1("color").changeAlpha$1(A._percentageOrUnitless0(t1.$index($arguments, 1).assertNumber$1("alpha"), 1, "alpha"));
    },
    _hsl0($name, $arguments) {
      var t2, hue, saturation, lightness, t3,
        _s10_ = "saturation",
        _s9_ = "lightness",
        t1 = J.getInterceptor$asx($arguments),
        alpha = t1.get$length($arguments) > 3 ? t1.$index($arguments, 3) : null;
      if (!t1.$index($arguments, 0).get$isSpecialNumber())
        if (!t1.$index($arguments, 1).get$isSpecialNumber())
          if (!t1.$index($arguments, 2).get$isSpecialNumber()) {
            t2 = alpha == null ? null : alpha.get$isSpecialNumber();
            t2 = t2 === true;
          } else
            t2 = true;
        else
          t2 = true;
      else
        t2 = true;
      if (t2)
        return A._functionString0($name, $arguments);
      hue = A._angleValue0(t1.$index($arguments, 0), "hue");
      saturation = t1.$index($arguments, 1).assertNumber$1(_s10_);
      lightness = t1.$index($arguments, 2).assertNumber$1(_s9_);
      A._checkPercent0(saturation, _s10_);
      A._checkPercent0(lightness, _s9_);
      t1 = B.JSNumber_methods.clamp$2(saturation._number1$_value, 0, 100);
      t2 = B.JSNumber_methods.clamp$2(lightness._number1$_value, 0, 100);
      t3 = A.NullableExtension_andThen0(alpha, new A._hsl_closure0());
      return A.SassColor$hslInternal0(hue, t1, t2, t3 == null ? 1 : t3, B._ColorFormatEnum_hslFunction0);
    },
    _angleValue0(angleValue, $name) {
      var angle = angleValue.assertNumber$1($name);
      if (angle.compatibleWithUnit$1("deg"))
        return angle.coerceValueToUnit$1("deg");
      A.warnForDeprecation0("$" + $name + ": Passing a unit other than deg (" + angle.toString$0(0) + string$.x29x20is_d + angle.unitSuggestion$1($name) + string$.x0a_See_, B.Deprecation_oCX);
      return angle._number1$_value;
    },
    _checkPercent0(number, $name) {
      if (number.hasUnit$1("%"))
        return;
      A.warnForDeprecation0("$" + $name + ": Passing a number without unit % (" + number.toString$0(0) + string$.x29x20is_d + number.unitSuggestion$2($name, "%") + string$.x0a_Morex3a, B.Deprecation_oCX);
    },
    _hwb0($arguments) {
      var t2, t3,
        _s9_ = "whiteness",
        _s9_0 = "blackness",
        t1 = J.getInterceptor$asx($arguments),
        alpha = t1.get$length($arguments) > 3 ? t1.$index($arguments, 3) : null,
        hue = A._angleValue0(t1.$index($arguments, 0), "hue"),
        whiteness = t1.$index($arguments, 1).assertNumber$1(_s9_),
        blackness = t1.$index($arguments, 2).assertNumber$1(_s9_0);
      whiteness.assertUnit$2("%", _s9_);
      blackness.assertUnit$2("%", _s9_0);
      t1 = whiteness.valueInRange$3(0, 100, _s9_);
      t2 = blackness.valueInRange$3(0, 100, _s9_0);
      t3 = A.NullableExtension_andThen0(alpha, new A._hwb_closure0());
      return A.SassColor_SassColor$hwb0(hue, t1, t2, t3 == null ? 1 : t3);
    },
    _parseChannels0($name, argumentNames, channels) {
      var list, t1, channels0, alphaFromSlashList, isCommaSeparated, isBracketed, buffer, _0_4, _1_0, _1_2_isSet, _1_2, t2, _null = null,
        _s17_ = "$channels must be";
      if (channels.get$isVar())
        return A._functionString0($name, A._setArrayType([channels], type$.JSArray_Value_2));
      if (channels.get$separator(channels) === B.ListSeparator_cQA0) {
        list = channels.get$asList();
        t1 = list.length;
        if (t1 !== 2)
          throw A.wrapException(A.SassScriptException$0(string$.Only_2 + t1 + " " + A.pluralize0("was", t1, "were") + " passed.", _null));
        channels0 = list[0];
        alphaFromSlashList = list[1];
        if (!alphaFromSlashList.get$isSpecialNumber())
          alphaFromSlashList.assertNumber$1("alpha");
        if (list[0].get$isVar())
          return A._functionString0($name, A._setArrayType([channels], type$.JSArray_Value_2));
      } else {
        alphaFromSlashList = _null;
        channels0 = channels;
      }
      isCommaSeparated = channels0.get$separator(channels0) === B.ListSeparator_ECn0;
      isBracketed = channels0.get$hasBrackets();
      if (isCommaSeparated || isBracketed) {
        buffer = new A.StringBuffer(_s17_);
        if (isBracketed) {
          t1 = _s17_ + " an unbracketed";
          buffer._contents = t1;
        } else
          t1 = _s17_;
        if (isCommaSeparated) {
          t1 += isBracketed ? "," : " a";
          buffer._contents = t1;
          t1 = buffer._contents = t1 + " space-separated";
        }
        buffer._contents = t1 + " list.";
        throw A.wrapException(A.SassScriptException$0(buffer.toString$0(0), _null));
      }
      list = channels0.get$asList();
      if (list.length >= 2) {
        _0_4 = list[0];
        t1 = _0_4;
        if (t1 instanceof A.SassString0) {
          type$.SassString_2._as(_0_4);
          t1 = !_0_4._string0$_hasQuotes && A.equalsIgnoreCase0(_0_4._string0$_text, "from");
        } else
          t1 = false;
      } else
        t1 = false;
      if (t1)
        return A._functionString0($name, A._setArrayType([channels], type$.JSArray_Value_2));
      t1 = list.length;
      if (t1 > 3)
        throw A.wrapException(A.SassScriptException$0("Only 3 elements allowed, but " + t1 + " were passed.", _null));
      else if (t1 < 3) {
        if (!B.JSArray_methods.any$1(list, new A._parseChannels_closure0()))
          if (list.length !== 0) {
            t1 = B.JSArray_methods.get$last(list);
            if (t1 instanceof A.SassString0)
              if (t1._string0$_hasQuotes) {
                t1 = t1._string0$_text;
                t1 = A.startsWithIgnoreCase0(t1, "var(") && B.JSString_methods.contains$1(t1, "/");
              } else
                t1 = false;
            else
              t1 = false;
          } else
            t1 = false;
        else
          t1 = true;
        if (t1)
          return A._functionString0($name, A._setArrayType([channels], type$.JSArray_Value_2));
        else
          throw A.wrapException(A.SassScriptException$0("Missing element " + argumentNames[list.length] + ".", _null));
      }
      if (alphaFromSlashList != null) {
        t1 = A.List_List$of(list, true, type$.Value_2);
        t1.push(alphaFromSlashList);
        return t1;
      }
      _1_0 = list[2];
      $label0$0: {
        _1_2_isSet = _1_0 instanceof A.SassNumber0;
        if (_1_2_isSet) {
          _1_2 = _1_0.asSlash;
          t1 = type$.Record_2_nullable_Object_and_nullable_Object._is(_1_2);
        } else {
          _1_2 = _null;
          t1 = false;
        }
        if (t1) {
          if (_1_2_isSet)
            t1 = _1_2;
          else {
            _1_2 = _1_0.asSlash;
            t1 = _1_2;
            _1_2_isSet = true;
          }
          if (t1 == null)
            t1 = type$.Record_2_nullable_Object_and_nullable_Object._as(t1);
          t2 = _1_2_isSet ? _1_2 : _1_0.asSlash;
          if (t2 == null)
            t2 = type$.Record_2_nullable_Object_and_nullable_Object._as(t2);
          t2 = A._setArrayType([list[0], list[1], t1._0, t2._1], type$.JSArray_Value_2);
          t1 = t2;
          break $label0$0;
        }
        if (_1_0 instanceof A.SassString0)
          if (!_1_0._string0$_hasQuotes)
            t1 = B.JSString_methods.contains$1(_1_0._string0$_text, "/");
          else
            t1 = false;
        else
          t1 = false;
        if (t1) {
          t1 = A._functionString0($name, A._setArrayType([channels0], type$.JSArray_Value_2));
          break $label0$0;
        }
        t1 = list;
        break $label0$0;
      }
      return t1;
    },
    _percentageOrUnitless0(number, max, $name) {
      var value;
      if (!number.get$hasUnits())
        value = number._number1$_value;
      else if (number.hasUnit$1("%"))
        value = max * number._number1$_value / 100;
      else
        throw A.wrapException(A.SassScriptException$0("$" + $name + ": Expected " + number.toString$0(0) + ' to have unit "%" or no units.', null));
      return B.JSNumber_methods.clamp$2(value, 0, max);
    },
    _mixColors0(color1, color2, weight) {
      var weightScale, normalizedWeight, t1, t2, alphaDistance, t3, weight1, weight2;
      A._checkPercent0(weight, "weight");
      weightScale = weight.valueInRange$3(0, 100, "weight") / 100;
      normalizedWeight = weightScale * 2 - 1;
      t1 = color1._color1$_alpha;
      t2 = color2._color1$_alpha;
      alphaDistance = t1 - t2;
      t3 = normalizedWeight * alphaDistance;
      weight1 = ((t3 === -1 ? normalizedWeight : (normalizedWeight + alphaDistance) / (1 + t3)) + 1) / 2;
      weight2 = 1 - weight1;
      return A.SassColor$rgb0(A.fuzzyRound0(color1.get$red(0) * weight1 + color2.get$red(0) * weight2), A.fuzzyRound0(color1.get$green(0) * weight1 + color2.get$green(0) * weight2), A.fuzzyRound0(color1.get$blue(0) * weight1 + color2.get$blue(0) * weight2), t1 * weightScale + t2 * (1 - weightScale));
    },
    _opacify0($arguments) {
      var t1 = J.getInterceptor$asx($arguments),
        color = t1.$index($arguments, 0).assertColor$1("color");
      return color.changeAlpha$1(B.JSNumber_methods.clamp$2(color._color1$_alpha + t1.$index($arguments, 1).assertNumber$1("amount").valueInRangeWithUnit$4(0, 1, "amount", ""), 0, 1));
    },
    _transparentize0($arguments) {
      var t1 = J.getInterceptor$asx($arguments),
        color = t1.$index($arguments, 0).assertColor$1("color");
      return color.changeAlpha$1(B.JSNumber_methods.clamp$2(color._color1$_alpha - t1.$index($arguments, 1).assertNumber$1("amount").valueInRangeWithUnit$4(0, 1, "amount", ""), 0, 1));
    },
    _function11($name, $arguments, callback) {
      return A.BuiltInCallable$function0($name, $arguments, callback, "sass:color");
    },
    global_closure32: function global_closure32() {
    },
    global_closure33: function global_closure33() {
    },
    global_closure34: function global_closure34() {
    },
    global_closure35: function global_closure35() {
    },
    global_closure36: function global_closure36() {
    },
    global_closure37: function global_closure37() {
    },
    global_closure38: function global_closure38() {
    },
    global_closure39: function global_closure39() {
    },
    global_closure40: function global_closure40() {
    },
    global_closure41: function global_closure41() {
    },
    global_closure42: function global_closure42() {
    },
    global_closure43: function global_closure43() {
    },
    global_closure44: function global_closure44() {
    },
    global_closure45: function global_closure45() {
    },
    global_closure46: function global_closure46() {
    },
    global_closure47: function global_closure47() {
    },
    global_closure48: function global_closure48() {
    },
    global_closure49: function global_closure49() {
    },
    global_closure50: function global_closure50() {
    },
    global_closure51: function global_closure51() {
    },
    global_closure52: function global_closure52() {
    },
    global_closure53: function global_closure53() {
    },
    global_closure54: function global_closure54() {
    },
    global_closure55: function global_closure55() {
    },
    global_closure56: function global_closure56() {
    },
    global_closure57: function global_closure57() {
    },
    global__closure0: function global__closure0() {
    },
    global_closure58: function global_closure58() {
    },
    module_closure12: function module_closure12() {
    },
    module_closure13: function module_closure13() {
    },
    module_closure14: function module_closure14() {
    },
    module_closure15: function module_closure15() {
    },
    module_closure16: function module_closure16() {
    },
    module_closure17: function module_closure17() {
    },
    module_closure18: function module_closure18() {
    },
    module_closure19: function module_closure19() {
    },
    module__closure4: function module__closure4() {
    },
    module_closure20: function module_closure20() {
    },
    _red_closure0: function _red_closure0() {
    },
    _green_closure0: function _green_closure0() {
    },
    _blue_closure0: function _blue_closure0() {
    },
    _mix_closure0: function _mix_closure0() {
    },
    _hue_closure0: function _hue_closure0() {
    },
    _saturation_closure0: function _saturation_closure0() {
    },
    _lightness_closure0: function _lightness_closure0() {
    },
    _complement_closure0: function _complement_closure0() {
    },
    _adjust_closure0: function _adjust_closure0() {
    },
    _scale_closure0: function _scale_closure0() {
    },
    _change_closure0: function _change_closure0() {
    },
    _ieHexStr_closure0: function _ieHexStr_closure0() {
    },
    _ieHexStr_closure_hexString0: function _ieHexStr_closure_hexString0() {
    },
    _updateComponents_getParam0: function _updateComponents_getParam0(t0, t1, t2) {
      this.keywords = t0;
      this.scale = t1;
      this.change = t2;
    },
    _updateComponents_closure1: function _updateComponents_closure1() {
    },
    _updateComponents_closure2: function _updateComponents_closure2() {
    },
    _updateComponents_updateValue0: function _updateComponents_updateValue0(t0, t1) {
      this.change = t0;
      this.adjust = t1;
    },
    _updateComponents_updateRgb0: function _updateComponents_updateRgb0(t0) {
      this.updateValue = t0;
    },
    _functionString_closure0: function _functionString_closure0() {
    },
    _removedColorFunction_closure0: function _removedColorFunction_closure0(t0, t1, t2) {
      this.name = t0;
      this.argument = t1;
      this.negative = t2;
    },
    _rgb_closure0: function _rgb_closure0() {
    },
    _hsl_closure0: function _hsl_closure0() {
    },
    _hwb_closure0: function _hwb_closure0() {
    },
    _parseChannels_closure0: function _parseChannels_closure0() {
    },
    colorClass_closure: function colorClass_closure() {
    },
    colorClass__closure: function colorClass__closure() {
    },
    colorClass__closure0: function colorClass__closure0() {
    },
    colorClass__closure1: function colorClass__closure1() {
    },
    colorClass__closure2: function colorClass__closure2() {
    },
    colorClass__closure3: function colorClass__closure3() {
    },
    colorClass__closure4: function colorClass__closure4() {
    },
    colorClass__closure5: function colorClass__closure5() {
    },
    colorClass__closure6: function colorClass__closure6() {
    },
    colorClass__closure7: function colorClass__closure7() {
    },
    colorClass__closure8: function colorClass__closure8() {
    },
    colorClass__closure9: function colorClass__closure9() {
    },
    _Channels: function _Channels() {
    },
    _NodeSassColor: function _NodeSassColor() {
    },
    legacyColorClass_closure: function legacyColorClass_closure() {
    },
    legacyColorClass_closure0: function legacyColorClass_closure0() {
    },
    legacyColorClass_closure1: function legacyColorClass_closure1() {
    },
    legacyColorClass_closure2: function legacyColorClass_closure2() {
    },
    legacyColorClass_closure3: function legacyColorClass_closure3() {
    },
    legacyColorClass_closure4: function legacyColorClass_closure4() {
    },
    legacyColorClass_closure5: function legacyColorClass_closure5() {
    },
    legacyColorClass_closure6: function legacyColorClass_closure6() {
    },
    legacyColorClass_closure7: function legacyColorClass_closure7() {
    },
    SassColor$rgb0(red, green, blue, alpha) {
      var _null = null,
        t1 = new A.SassColor0(red, green, blue, _null, _null, _null, A.fuzzyAssertRange0(A.SassColor__handleNullAlpha0(alpha), 0, 1, "alpha"), _null);
      A.RangeError_checkValueInInterval(t1.get$red(0), 0, 255, "red");
      A.RangeError_checkValueInInterval(t1.get$green(0), 0, 255, "green");
      A.RangeError_checkValueInInterval(t1.get$blue(0), 0, 255, "blue");
      return t1;
    },
    SassColor$rgbInternal0(_red, _green, _blue, alpha, format) {
      var t1 = new A.SassColor0(_red, _green, _blue, null, null, null, A.fuzzyAssertRange0(alpha, 0, 1, "alpha"), format);
      A.RangeError_checkValueInInterval(t1.get$red(0), 0, 255, "red");
      A.RangeError_checkValueInInterval(t1.get$green(0), 0, 255, "green");
      A.RangeError_checkValueInInterval(t1.get$blue(0), 0, 255, "blue");
      return t1;
    },
    SassColor$hsl(hue, saturation, lightness, alpha) {
      var _null = null,
        t1 = A.SassColor__handleNullAlpha0(alpha);
      return new A.SassColor0(_null, _null, _null, B.JSNumber_methods.$mod(hue, 360), A.fuzzyAssertRange0(saturation, 0, 100, "saturation"), A.fuzzyAssertRange0(lightness, 0, 100, "lightness"), A.fuzzyAssertRange0(t1, 0, 1, "alpha"), _null);
    },
    SassColor$hslInternal0(hue, saturation, lightness, alpha, format) {
      return new A.SassColor0(null, null, null, B.JSNumber_methods.$mod(hue, 360), A.fuzzyAssertRange0(saturation, 0, 100, "saturation"), A.fuzzyAssertRange0(lightness, 0, 100, "lightness"), A.fuzzyAssertRange0(alpha, 0, 1, "alpha"), format);
    },
    SassColor_SassColor$hwb0(hue, whiteness, blackness, alpha) {
      var t2, t1 = {},
        scaledHue = B.JSNumber_methods.$mod(hue, 360) / 360,
        scaledWhiteness = t1.scaledWhiteness = A.fuzzyAssertRange0(whiteness, 0, 100, "whiteness") / 100,
        scaledBlackness = A.fuzzyAssertRange0(blackness, 0, 100, "blackness") / 100,
        sum = scaledWhiteness + scaledBlackness;
      if (sum > 1) {
        t2 = t1.scaledWhiteness = scaledWhiteness / sum;
        scaledBlackness /= sum;
      } else
        t2 = scaledWhiteness;
      t2 = new A.SassColor_SassColor$hwb_toRgb0(t1, 1 - t2 - scaledBlackness);
      return A.SassColor$rgb0(t2.call$1(scaledHue + 0.3333333333333333), t2.call$1(scaledHue), t2.call$1(scaledHue - 0.3333333333333333), alpha);
    },
    SassColor__handleNullAlpha0(alpha) {
      if (alpha != null)
        return alpha;
      A.warnForDeprecation0("Passing null for alpha in the JS API is deprecated.\nTo preserve current behavior, pass 1 or undefined instead.\nMore info: https://sass-lang.com/d/null-alpha", B.Deprecation_omH);
      return 1;
    },
    SassColor__hueToRgb0(m1, m2, hue) {
      var t1;
      if (hue < 0)
        ++hue;
      if (hue > 1)
        --hue;
      $label0$0: {
        if (hue < 0.16666666666666666) {
          t1 = m1 + (m2 - m1) * hue * 6;
          break $label0$0;
        }
        if (hue < 0.5) {
          t1 = m2;
          break $label0$0;
        }
        if (hue < 0.6666666666666666) {
          t1 = m1 + (m2 - m1) * (0.6666666666666666 - hue) * 6;
          break $label0$0;
        }
        t1 = m1;
        break $label0$0;
      }
      return t1;
    },
    SassColor0: function SassColor0(t0, t1, t2, t3, t4, t5, t6, t7) {
      var _ = this;
      _._color1$_red = t0;
      _._color1$_green = t1;
      _._color1$_blue = t2;
      _._color1$_hue = t3;
      _._color1$_saturation = t4;
      _._color1$_lightness = t5;
      _._color1$_alpha = t6;
      _.format = t7;
    },
    SassColor_SassColor$hwb_toRgb0: function SassColor_SassColor$hwb_toRgb0(t0, t1) {
      this._box_0 = t0;
      this.factor = t1;
    },
    _ColorFormatEnum0: function _ColorFormatEnum0(t0) {
      this._color1$_name = t0;
    },
    SpanColorFormat0: function SpanColorFormat0(t0) {
      this._color1$_span = t0;
    },
    Combinator0: function Combinator0(t0, t1) {
      this._combinator0$_text = t0;
      this._name = t1;
    },
    ModifiableCssComment0: function ModifiableCssComment0(t0, t1) {
      var _ = this;
      _.text = t0;
      _.span = t1;
      _._node$_indexInParent = _._node$_parent = null;
      _.isGroupEnd = false;
    },
    compile0(path, options) {
      var color, ascii, logger, result, error, stackTrace, t1, color0, ascii0, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, exception, _null = null;
      if (!A.isNodeJs())
        A.jsThrow(new self.Error("The compile() method is only available in Node.js."));
      t1 = options == null;
      color0 = t1 ? _null : J.get$alertColor$x(options);
      color = color0 == null ? A.hasTerminal0() : color0;
      ascii0 = t1 ? _null : J.get$alertAscii$x(options);
      ascii = ascii0 == null ? $._glyphs === B.C_AsciiGlyphSet : ascii0;
      t2 = t1 ? _null : J.get$logger$x(options);
      t3 = ascii;
      if (t3 == null)
        t3 = $._glyphs === B.C_AsciiGlyphSet;
      logger = new A.JSToDartLogger(t2, new A.StderrLogger0(color), t3);
      try {
        t2 = t1 ? _null : J.get$loadPaths$x(options);
        t3 = t1 ? _null : J.get$quietDeps$x(options);
        if (t3 == null)
          t3 = false;
        t4 = A._parseOutputStyle0(t1 ? _null : J.get$style$x(options));
        t5 = t1 ? _null : J.get$verbose$x(options);
        if (t5 == null)
          t5 = false;
        t6 = t1 ? _null : J.get$charset$x(options);
        if (t6 == null)
          t6 = true;
        t7 = t1 ? _null : J.get$sourceMap$x(options);
        if (t7 == null)
          t7 = false;
        t8 = logger;
        if (t1)
          t9 = _null;
        else {
          t9 = J.get$importers$x(options);
          t9 = t9 == null ? _null : J.map$1$1$ax(t9, A.compile___parseImporter$closure(), type$.Importer);
        }
        t10 = A._parseFunctions0(t1 ? _null : J.get$functions$x(options), false);
        t11 = t1 ? _null : J.get$fatalDeprecations$x(options);
        t11 = A._parseDeprecations(logger, t11, true);
        t12 = t1 ? _null : J.get$silenceDeprecations$x(options);
        t12 = A._parseDeprecations(logger, t12, false);
        t13 = t1 ? _null : J.get$futureDeprecations$x(options);
        t13 = A._parseDeprecations(logger, t13, false);
        result = A.compile(path, t6, t11, new A.CastList(t10, A._arrayInstanceType(t10)._eval$1("CastList<1,Callable>")), t13, A.ImportCache$0(t9, t2, t8 == null ? new A.StderrLogger0(color) : t8, _null), _null, _null, t8, _null, t3, t12, t7, t4, _null, true, t5);
        t1 = t1 ? _null : J.get$sourceMapIncludeSources$x(options);
        if (t1 == null)
          t1 = false;
        t1 = A._convertResult(result, t1);
        return t1;
      } catch (exception) {
        t1 = A.unwrapException(exception);
        if (t1 instanceof A.SassException0) {
          error = t1;
          stackTrace = A.getTraceFromException(exception);
          A.throwNodeException(error, ascii, color, stackTrace);
        } else
          throw exception;
      }
    },
    compileString0(text, options) {
      var logger, result, error, stackTrace, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, exception, _null = null,
        t1 = options == null,
        color0 = t1 ? _null : J.get$alertColor$x(options),
        color = color0 == null ? A.hasTerminal0() : color0,
        ascii0 = t1 ? _null : J.get$alertAscii$x(options),
        ascii = ascii0 == null ? $._glyphs === B.C_AsciiGlyphSet : ascii0,
        t2 = t1 ? _null : J.get$logger$x(options),
        t3 = ascii;
      if (t3 == null)
        t3 = $._glyphs === B.C_AsciiGlyphSet;
      logger = new A.JSToDartLogger(t2, new A.StderrLogger0(color), t3);
      try {
        t2 = A.parseSyntax(t1 ? _null : J.get$syntax$x(options));
        t3 = t1 ? _null : A.NullableExtension_andThen0(J.get$url$x(options), A.utils1__jsToDartUrl$closure());
        t4 = t1 ? _null : J.get$loadPaths$x(options);
        t5 = t1 ? _null : J.get$quietDeps$x(options);
        if (t5 == null)
          t5 = false;
        t6 = A._parseOutputStyle0(t1 ? _null : J.get$style$x(options));
        t7 = t1 ? _null : J.get$verbose$x(options);
        if (t7 == null)
          t7 = false;
        t8 = t1 ? _null : J.get$charset$x(options);
        if (t8 == null)
          t8 = true;
        t9 = t1 ? _null : J.get$sourceMap$x(options);
        if (t9 == null)
          t9 = false;
        t10 = logger;
        if (t1)
          t11 = _null;
        else {
          t11 = J.get$importers$x(options);
          t11 = t11 == null ? _null : J.map$1$1$ax(t11, A.compile___parseImporter$closure(), type$.Importer);
        }
        t12 = t1 ? _null : A.NullableExtension_andThen0(J.get$importer$x(options), A.compile___parseImporter$closure());
        if (t12 == null)
          t12 = (t1 ? _null : J.get$url$x(options)) == null ? new A.NoOpImporter0() : _null;
        t13 = A._parseFunctions0(t1 ? _null : J.get$functions$x(options), false);
        t14 = t1 ? _null : J.get$fatalDeprecations$x(options);
        t14 = A._parseDeprecations(logger, t14, true);
        t15 = t1 ? _null : J.get$silenceDeprecations$x(options);
        t15 = A._parseDeprecations(logger, t15, false);
        t16 = t1 ? _null : J.get$futureDeprecations$x(options);
        t16 = A._parseDeprecations(logger, t16, false);
        result = A.compileString(text, t8, t14, new A.CastList(t13, A._arrayInstanceType(t13)._eval$1("CastList<1,Callable>")), t16, A.ImportCache$0(t11, t4, t10 == null ? new A.StderrLogger0(color) : t10, _null), t12, _null, _null, t10, _null, t5, t15, t9, t6, t2, t3, true, t7);
        t1 = t1 ? _null : J.get$sourceMapIncludeSources$x(options);
        if (t1 == null)
          t1 = false;
        t1 = A._convertResult(result, t1);
        return t1;
      } catch (exception) {
        t1 = A.unwrapException(exception);
        if (t1 instanceof A.SassException0) {
          error = t1;
          stackTrace = A.getTraceFromException(exception);
          A.throwNodeException(error, ascii, color, stackTrace);
        } else
          throw exception;
      }
    },
    compileAsync1(path, options) {
      var t1, color, ascii;
      if (!A.isNodeJs())
        A.jsThrow(new self.Error("The compileAsync() method is only available in Node.js."));
      t1 = options == null;
      color = t1 ? null : J.get$alertColor$x(options);
      if (color == null)
        color = A.hasTerminal0();
      ascii = t1 ? null : J.get$alertAscii$x(options);
      if (ascii == null)
        ascii = $._glyphs === B.C_AsciiGlyphSet;
      t1 = t1 ? null : J.get$logger$x(options);
      return A._wrapAsyncSassExceptions(A.futureToPromise0(new A.compileAsync_closure(path, color, options, new A.JSToDartLogger(t1, new A.StderrLogger0(color), ascii)).call$0()), ascii, color);
    },
    compileStringAsync1(text, options) {
      var ascii,
        t1 = options == null,
        color = t1 ? null : J.get$alertColor$x(options);
      if (color == null)
        color = A.hasTerminal0();
      ascii = t1 ? null : J.get$alertAscii$x(options);
      if (ascii == null)
        ascii = $._glyphs === B.C_AsciiGlyphSet;
      t1 = t1 ? null : J.get$logger$x(options);
      return A._wrapAsyncSassExceptions(A.futureToPromise0(new A.compileStringAsync_closure(text, options, color, new A.JSToDartLogger(t1, new A.StderrLogger0(color), ascii)).call$0()), ascii, color);
    },
    _convertResult(result, includeSourceContents) {
      var loadedUrls,
        t1 = result._compile_result$_serialize,
        t2 = t1._1,
        sourceMap = t2 == null ? null : t2.toJson$1$includeSourceContents(includeSourceContents);
      if (type$.Map_String_dynamic._is(sourceMap) && !sourceMap.containsKey$1("sources"))
        sourceMap.$indexSet(0, "sources", A._setArrayType([], type$.JSArray_String));
      loadedUrls = A.toJSArray(result._evaluate._0.map$1$1(0, A.utils1__dartToJSUrl$closure(), type$.nullable_Object));
      t1 = t1._0;
      return sourceMap == null ? {css: t1, loadedUrls: loadedUrls} : {css: t1, sourceMap: A.jsify0(sourceMap), loadedUrls: loadedUrls};
    },
    _wrapAsyncSassExceptions(promise, ascii, color) {
      return J.then$2$x(promise, null, A.allowInterop(new A._wrapAsyncSassExceptions_closure(color, ascii)));
    },
    _parseOutputStyle0(style) {
      var t1;
      $label0$0: {
        if (style == null || "expanded" === style) {
          t1 = B.OutputStyle_00;
          break $label0$0;
        }
        if ("compressed" === style) {
          t1 = B.OutputStyle_10;
          break $label0$0;
        }
        t1 = A.jsThrow(new self.Error('Unknown output style "' + A.S(style) + '".'));
      }
      return t1;
    },
    _parseAsyncImporter(importer) {
      var t1, canonicalize, load, _0_0;
      if (importer instanceof A.NodePackageImporter0)
        return importer;
      if (importer == null)
        A.jsThrow(new self.Error("Importers may not be null."));
      type$.JSImporter._as(importer);
      t1 = J.getInterceptor$x(importer);
      canonicalize = t1.get$canonicalize(importer);
      load = t1.get$load(importer);
      _0_0 = t1.get$findFileUrl(importer);
      if (_0_0 != null)
        if (canonicalize != null || load != null)
          A.jsThrow(new self.Error(string$.An_impa));
        else
          return new A.JSToDartAsyncFileImporter(_0_0);
      else if (canonicalize == null || load == null)
        A.jsThrow(new self.Error(string$.An_impu));
      else {
        t1 = A._normalizeNonCanonicalSchemes(t1.get$nonCanonicalScheme(importer));
        t1 = t1 == null ? B.Set_empty7 : A.Set_Set$unmodifiable(t1, type$.String);
        t1.forEach$1(0, A.utils2__validateUrlScheme$closure());
        return new A.JSToDartAsyncImporter(canonicalize, load, t1);
      }
    },
    _parseImporter0(importer) {
      var t1, canonicalize, load, _0_0;
      if (importer instanceof A.NodePackageImporter0)
        return importer;
      if (importer == null)
        A.jsThrow(new self.Error("Importers may not be null."));
      type$.JSImporter._as(importer);
      t1 = J.getInterceptor$x(importer);
      canonicalize = t1.get$canonicalize(importer);
      load = t1.get$load(importer);
      _0_0 = t1.get$findFileUrl(importer);
      if (_0_0 != null)
        if (canonicalize != null || load != null)
          A.jsThrow(new self.Error(string$.An_impa));
        else
          return new A.JSToDartFileImporter(_0_0);
      else if (canonicalize == null || load == null)
        A.jsThrow(new self.Error(string$.An_impu));
      else {
        t1 = A._normalizeNonCanonicalSchemes(t1.get$nonCanonicalScheme(importer));
        t1 = t1 == null ? B.Set_empty7 : A.Set_Set$unmodifiable(t1, type$.String);
        t1.forEach$1(0, A.utils2__validateUrlScheme$closure());
        return new A.JSToDartImporter(canonicalize, load, t1);
      }
    },
    _normalizeNonCanonicalSchemes(schemes) {
      var t1;
      $label0$0: {
        if (typeof schemes == "string") {
          t1 = A._setArrayType([schemes], type$.JSArray_String);
          break $label0$0;
        }
        if (type$.List_dynamic._is(schemes)) {
          t1 = J.cast$1$0$ax(schemes, type$.String);
          break $label0$0;
        }
        if (schemes == null) {
          t1 = null;
          break $label0$0;
        }
        t1 = A.jsThrow(new self.Error('nonCanonicalScheme must be a string or list of strings, was "' + A.S(schemes) + '"'));
      }
      return t1;
    },
    _simplifyValue(value) {
      var _0_1, t1, t2, _0_4, _0_3, _0_4_isSet, _0_5, _0_40, _0_8, first, _0_10, min, _null = null;
      $label1$1: {
        if (value instanceof A.SassCalculation0) {
          _0_1 = value.name;
          t1 = value.$arguments;
          t2 = A._arrayInstanceType(t1)._eval$1("MappedListIterable<1,Object>");
          _0_4 = A.List_List$of(new A.MappedListIterable(t1, A.compile___simplifyCalcArg$closure(), t2), true, t2._eval$1("ListIterable.E"));
          $label0$0: {
            _0_3 = "calc" === _0_1;
            _0_4_isSet = _0_3;
            if (_0_4_isSet) {
              _0_5 = _0_4.length;
              t1 = _0_5;
              _0_40 = _0_4;
              t1 = t1 === 1;
            } else {
              _0_40 = _null;
              _0_5 = _0_40;
              t1 = false;
            }
            if (t1) {
              _0_8 = (_0_4_isSet ? _0_40 : _0_4)[0];
              first = _0_8;
              type$.Value_2._as(first);
              t1 = first;
              break $label0$0;
            }
            if (_0_3)
              A.throwExpression(A.ArgumentError$("calc() requires exactly one argument.", _null));
            _0_10 = "clamp" === _0_1;
            t1 = _0_10;
            if (t1) {
              if (_0_4_isSet)
                t1 = _0_5;
              else {
                _0_5 = _0_4.length;
                t1 = _0_5;
                _0_40 = _0_4;
                _0_4_isSet = true;
              }
              t1 = t1 === 3;
            } else
              t1 = false;
            if (t1) {
              if (_0_4_isSet)
                t1 = _0_40;
              else {
                t1 = _0_4;
                _0_40 = t1;
                _0_4_isSet = true;
              }
              _0_8 = t1[0];
              min = _0_8;
              if (_0_4_isSet)
                t1 = _0_40;
              else {
                t1 = _0_4;
                _0_40 = t1;
                _0_4_isSet = true;
              }
              value = t1[1];
              t1 = A.SassCalculation_clamp0(min, value, (_0_4_isSet ? _0_40 : _0_4)[2]);
              break $label0$0;
            }
            if (_0_10)
              A.throwExpression(A.ArgumentError$("clamp() requires exactly 3 arguments.", _null));
            if ("min" === _0_1) {
              t1 = A.SassCalculation_min0(_0_4_isSet ? _0_40 : _0_4);
              break $label0$0;
            }
            if ("max" === _0_1) {
              t1 = A.SassCalculation_max0(_0_4_isSet ? _0_40 : _0_4);
              break $label0$0;
            }
            t1 = A.throwExpression(A.ArgumentError$('"' + _0_1 + '" is not a recognized calculation type.', _null));
          }
          break $label1$1;
        }
        t1 = value;
        break $label1$1;
      }
      return t1;
    },
    _simplifyCalcArg(value) {
      var t1;
      $label0$0: {
        if (value instanceof A.SassCalculation0) {
          t1 = A._simplifyValue(value);
          break $label0$0;
        }
        if (value instanceof A.CalculationOperation0) {
          t1 = A.SassCalculation_operateInternal0(value._calculation0$_operator, A._simplifyCalcArg(value._calculation0$_left), A._simplifyCalcArg(value._calculation0$_right), false, true);
          break $label0$0;
        }
        t1 = value;
        break $label0$0;
      }
      return t1;
    },
    _parseFunctions0(functions, asynch) {
      var result;
      if (functions == null)
        return B.List_empty24;
      result = A._setArrayType([], type$.JSArray_AsyncCallable_2);
      A.jsForEach(functions, new A._parseFunctions_closure0(asynch, result));
      return result;
    },
    _parseDeprecations(logger, deprecations, supportVersions) {
      if (deprecations == null)
        return null;
      return new A._parseDeprecations_closure(deprecations, logger, supportVersions).call$0();
    },
    compileAsync_closure: function compileAsync_closure(t0, t1, t2, t3) {
      var _ = this;
      _.path = t0;
      _.color = t1;
      _.options = t2;
      _.logger = t3;
    },
    compileAsync__closure: function compileAsync__closure() {
    },
    compileStringAsync_closure: function compileStringAsync_closure(t0, t1, t2, t3) {
      var _ = this;
      _.text = t0;
      _.options = t1;
      _.color = t2;
      _.logger = t3;
    },
    compileStringAsync__closure: function compileStringAsync__closure() {
    },
    compileStringAsync__closure0: function compileStringAsync__closure0() {
    },
    _wrapAsyncSassExceptions_closure: function _wrapAsyncSassExceptions_closure(t0, t1) {
      this.color = t0;
      this.ascii = t1;
    },
    _parseFunctions_closure0: function _parseFunctions_closure0(t0, t1) {
      this.asynch = t0;
      this.result = t1;
    },
    _parseFunctions__closure2: function _parseFunctions__closure2(t0, t1) {
      this.callback = t0;
      this.callable = t1;
    },
    _parseFunctions___closure6: function _parseFunctions___closure6(t0, t1) {
      this.callback = t0;
      this.$arguments = t1;
    },
    _parseFunctions__closure3: function _parseFunctions__closure3(t0, t1) {
      this.callback = t0;
      this.callable = t1;
    },
    _parseFunctions___closure5: function _parseFunctions___closure5(t0, t1) {
      this.callback = t0;
      this.$arguments = t1;
    },
    _parseDeprecations_closure: function _parseDeprecations_closure(t0, t1, t2) {
      this.deprecations = t0;
      this.logger = t1;
      this.supportVersions = t2;
    },
    nodePackageImporterClass_closure: function nodePackageImporterClass_closure() {
    },
    nodePackageImporterClass__closure: function nodePackageImporterClass__closure() {
    },
    compile(path, charset, fatalDeprecations, functions, futureDeprecations, importCache, indentWidth, lineFeed, logger, nodeImporter, quietDeps, silenceDeprecations, sourceMap, style, syntax, useSpaces, verbose) {
      var t3, t4, t0, stylesheet, result, _null = null,
        t1 = type$.Deprecation_3,
        t2 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
      if (silenceDeprecations != null)
        t2.addAll$1(0, silenceDeprecations);
      t3 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
      if (fatalDeprecations != null)
        t3.addAll$1(0, fatalDeprecations);
      t1 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
      if (futureDeprecations != null)
        t1.addAll$1(0, futureDeprecations);
      logger = A.DeprecationProcessingLogger$0(logger, t3, t1, !verbose, t2);
      t1 = nodeImporter == null;
      if (t1)
        t2 = syntax == null || syntax === A.Syntax_forPath0(path);
      else
        t2 = false;
      if (t2) {
        if (importCache == null)
          importCache = A.ImportCache$none(logger);
        t2 = $.$get$FilesystemImporter_cwd0();
        t3 = A.isNodeJs() ? self.process : _null;
        if (!J.$eq$(t3 == null ? _null : J.get$platform$x(t3), "win32")) {
          t3 = A.isNodeJs() ? self.process : _null;
          t3 = J.$eq$(t3 == null ? _null : J.get$platform$x(t3), "darwin");
        } else
          t3 = true;
        if (t3) {
          t3 = $.$get$context();
          t4 = A._realCasePath0(A.absolute(t3.normalize$1(path), _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null, _null));
          t0 = t4;
          t4 = t3;
          t3 = t0;
        } else {
          t3 = $.$get$context();
          t4 = t3.canonicalize$1(0, path);
          t0 = t4;
          t4 = t3;
          t3 = t0;
        }
        t4 = importCache.importCanonical$3$originalUrl(t2, t4.toUri$1(t3), t4.toUri$1(path));
        t4.toString;
        stylesheet = t4;
      } else {
        t2 = A.readFile0(path);
        t3 = syntax == null ? A.Syntax_forPath0(path) : syntax;
        stylesheet = A.Stylesheet_Stylesheet$parse0(t2, t3, logger, $.$get$context().toUri$1(path));
      }
      result = A._compileStylesheet1(stylesheet, logger, importCache, nodeImporter, $.$get$FilesystemImporter_cwd0(), functions, style, useSpaces, indentWidth, lineFeed, quietDeps, sourceMap, charset);
      logger.summarize$1$js(!t1);
      return result;
    },
    compileString(source, charset, fatalDeprecations, functions, futureDeprecations, importCache, importer, indentWidth, lineFeed, logger, nodeImporter, quietDeps, silenceDeprecations, sourceMap, style, syntax, url, useSpaces, verbose) {
      var t3, stylesheet, result,
        t1 = type$.Deprecation_3,
        t2 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
      if (silenceDeprecations != null)
        t2.addAll$1(0, silenceDeprecations);
      t3 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
      if (fatalDeprecations != null)
        t3.addAll$1(0, fatalDeprecations);
      t1 = A.LinkedHashSet_LinkedHashSet$_empty(t1);
      if (futureDeprecations != null)
        t1.addAll$1(0, futureDeprecations);
      logger = A.DeprecationProcessingLogger$0(logger, t3, t1, !verbose, t2);
      stylesheet = A.Stylesheet_Stylesheet$parse0(source, syntax == null ? B.Syntax_SCSS_scss0 : syntax, logger, url);
      if (importer == null)
        t1 = A.isBrowser() ? new A.NoOpImporter0() : $.$get$FilesystemImporter_cwd0();
      else
        t1 = importer;
      result = A._compileStylesheet1(stylesheet, logger, importCache, nodeImporter, t1, functions, style, useSpaces, indentWidth, lineFeed, quietDeps, sourceMap, charset);
      logger.summarize$1$js(nodeImporter != null);
      return result;
    },
    _compileStylesheet1(stylesheet, logger, importCache, nodeImporter, importer, functions, style, useSpaces, indentWidth, lineFeed, quietDeps, sourceMap, charset) {
      var evaluateResult = A._EvaluateVisitor$1(functions, importCache, logger, nodeImporter, quietDeps, sourceMap).run$2(0, importer, stylesheet),
        serializeResult = A.serialize0(evaluateResult._1, charset, indentWidth, false, lineFeed, sourceMap, style, useSpaces),
        resultSourceMap = serializeResult._1;
      if (resultSourceMap != null && importCache != null)
        A.mapInPlace0(resultSourceMap.urls, new A._compileStylesheet_closure1(stylesheet, importCache));
      return new A.CompileResult0(evaluateResult, serializeResult);
    },
    _compileStylesheet_closure1: function _compileStylesheet_closure1(t0, t1) {
      this.stylesheet = t0;
      this.importCache = t1;
    },
    CompileOptions: function CompileOptions() {
    },
    CompileStringOptions: function CompileStringOptions() {
    },
    NodeCompileResult: function NodeCompileResult() {
    },
    CompileResult0: function CompileResult0(t0, t1) {
      this._evaluate = t0;
      this._compile_result$_serialize = t1;
    },
    initCompiler() {
      return new A.Compiler();
    },
    initAsyncCompiler() {
      return A.futureToPromise0(new A.initAsyncCompiler_closure().call$0());
    },
    Compiler: function Compiler() {
      this._disposed = false;
    },
    AsyncCompiler: function AsyncCompiler(t0) {
      this.compilations = t0;
      this._disposed = false;
    },
    AsyncCompiler_addCompilation_closure: function AsyncCompiler_addCompilation_closure() {
    },
    compilerClass_closure: function compilerClass_closure() {
    },
    compilerClass__closure: function compilerClass__closure() {
    },
    compilerClass__closure0: function compilerClass__closure0() {
    },
    compilerClass__closure1: function compilerClass__closure1() {
    },
    compilerClass__closure2: function compilerClass__closure2() {
    },
    asyncCompilerClass_closure: function asyncCompilerClass_closure() {
    },
    asyncCompilerClass__closure: function asyncCompilerClass__closure() {
    },
    asyncCompilerClass__closure0: function asyncCompilerClass__closure0() {
    },
    asyncCompilerClass__closure1: function asyncCompilerClass__closure1() {
    },
    asyncCompilerClass__closure2: function asyncCompilerClass__closure2() {
    },
    asyncCompilerClass___closure: function asyncCompilerClass___closure(t0) {
      this.self = t0;
    },
    initAsyncCompiler_closure: function initAsyncCompiler_closure() {
    },
    ComplexSassNumber0: function ComplexSassNumber0(t0, t1, t2, t3) {
      var _ = this;
      _._complex0$_numeratorUnits = t0;
      _._complex0$_denominatorUnits = t1;
      _._number1$_value = t2;
      _.hashCache = null;
      _.asSlash = t3;
    },
    ComplexSelector$0(leadingCombinators, components, span, lineBreak) {
      var t1 = A.List_List$unmodifiable(leadingCombinators, type$.CssValue_Combinator_2),
        t2 = A.List_List$unmodifiable(components, type$.ComplexSelectorComponent_2);
      if (t1.length === 0 && t2.length === 0)
        A.throwExpression(A.ArgumentError$(string$.leadin, null));
      return new A.ComplexSelector0(t1, t2, lineBreak, span);
    },
    ComplexSelector0: function ComplexSelector0(t0, t1, t2, t3) {
      var _ = this;
      _.leadingCombinators = t0;
      _.components = t1;
      _.lineBreak = t2;
      _._complex$__ComplexSelector_specificity_FI = $;
      _.span = t3;
    },
    ComplexSelector_specificity_closure0: function ComplexSelector_specificity_closure0() {
    },
    ComplexSelectorComponent0: function ComplexSelectorComponent0(t0, t1, t2) {
      this.selector = t0;
      this.combinators = t1;
      this.span = t2;
    },
    ComplexSelectorComponent_toString_closure0: function ComplexSelectorComponent_toString_closure0() {
    },
    CompoundSelector$0(components, span) {
      var t1 = A.List_List$unmodifiable(components, type$.SimpleSelector_2);
      if (t1.length === 0)
        A.throwExpression(A.ArgumentError$("components may not be empty.", null));
      return new A.CompoundSelector0(t1, span);
    },
    CompoundSelector0: function CompoundSelector0(t0, t1) {
      var _ = this;
      _.components = t0;
      _._compound$__CompoundSelector_hasComplicatedSuperselectorSemantics_FI = _._compound$__CompoundSelector_specificity_FI = $;
      _.span = t1;
    },
    CompoundSelector_specificity_closure0: function CompoundSelector_specificity_closure0() {
    },
    CompoundSelector_hasComplicatedSuperselectorSemantics_closure0: function CompoundSelector_hasComplicatedSuperselectorSemantics_closure0() {
    },
    Configuration0: function Configuration0(t0, t1) {
      this._configuration0$_values = t0;
      this._configuration0$__originalConfiguration = t1;
    },
    ExplicitConfiguration0: function ExplicitConfiguration0(t0, t1, t2) {
      this.nodeWithSpan = t0;
      this._configuration0$_values = t1;
      this._configuration0$__originalConfiguration = t2;
    },
    ConfiguredValue0: function ConfiguredValue0(t0, t1, t2) {
      this.value = t0;
      this.configurationSpan = t1;
      this.assignmentNode = t2;
    },
    ConfiguredVariable0: function ConfiguredVariable0(t0, t1, t2, t3) {
      var _ = this;
      _.name = t0;
      _.expression = t1;
      _.isGuarded = t2;
      _.span = t3;
    },
    ContentBlock$0($arguments, children, span) {
      var _s8_ = "@content",
        t1 = A.stringReplaceAllUnchecked(_s8_, "_", "-"),
        t2 = A.List_List$unmodifiable(children, type$.Statement_2),
        t3 = B.JSArray_methods.any$1(t2, new A.ParentStatement_closure0());
      return new A.ContentBlock0(t1, _s8_, $arguments, span, t2, t3);
    },
    ContentBlock0: function ContentBlock0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.name = t0;
      _.originalName = t1;
      _.$arguments = t2;
      _.span = t3;
      _.children = t4;
      _.hasDeclarations = t5;
    },
    ContentRule0: function ContentRule0(t0, t1) {
      this.$arguments = t0;
      this.span = t1;
    },
    _disallowedFunctionNames_closure0: function _disallowedFunctionNames_closure0() {
    },
    CssParser0: function CssParser0(t0, t1, t2, t3) {
      var _ = this;
      _._stylesheet0$_isUseAllowed = true;
      _._stylesheet0$_inExpression = _._stylesheet0$_inParentheses = _._stylesheet0$_inStyleRule = _._stylesheet0$_inUnknownAtRule = _._stylesheet0$_inControlDirective = _._stylesheet0$_inContentBlock = _._stylesheet0$_inMixin = false;
      _._stylesheet0$_globalVariables = t0;
      _.lastSilentComment = null;
      _.scanner = t1;
      _.logger = t2;
      _._parser0$_interpolationMap = t3;
    },
    DebugRule0: function DebugRule0(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    ModifiableCssDeclaration$0($name, value, span, parsedAsCustomProperty, valueSpanForMap) {
      var t2,
        t1 = valueSpanForMap == null ? value.span : valueSpanForMap;
      if (parsedAsCustomProperty)
        if (!J.startsWith$1$s($name.value, "--"))
          A.throwExpression(A.ArgumentError$(string$.parsed, null));
        else {
          t2 = value.value;
          if (!(t2 instanceof A.SassString0))
            A.throwExpression(A.ArgumentError$(string$.If_par + value.toString$0(0) + "` of type " + A.getRuntimeTypeOfDartObject(t2).toString$0(0) + ").", null));
        }
      return new A.ModifiableCssDeclaration0($name, value, parsedAsCustomProperty, t1, span);
    },
    ModifiableCssDeclaration0: function ModifiableCssDeclaration0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.parsedAsCustomProperty = t2;
      _.valueSpanForMap = t3;
      _.span = t4;
      _._node$_indexInParent = _._node$_parent = null;
      _.isGroupEnd = false;
    },
    Declaration$0($name, value, span) {
      return new A.Declaration0($name, value, span, null, false);
    },
    Declaration$nested0($name, children, span, value) {
      var t1 = A.List_List$unmodifiable(children, type$.Statement_2),
        t2 = B.JSArray_methods.any$1(t1, new A.ParentStatement_closure0());
      return new A.Declaration0($name, value, span, t1, t2);
    },
    Declaration0: function Declaration0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    SupportsDeclaration0: function SupportsDeclaration0(t0, t1, t2) {
      this.name = t0;
      this.value = t1;
      this.span = t2;
    },
    Deprecation_fromId0(id) {
      return A.IterableExtension_firstWhereOrNull(B.List_jM9, new A.Deprecation_fromId_closure0(id));
    },
    Deprecation_forVersion0(version) {
      var t2, _i, deprecation, $self, t3,
        t1 = A.LinkedHashSet_LinkedHashSet$_empty(type$.Deprecation_3);
      for (t2 = A.VersionRange_VersionRange(true, version).get$allows(), _i = 0; _i < 18; ++_i) {
        deprecation = B.List_jM9[_i];
        $self = deprecation._deprecation$_deprecatedIn;
        t3 = $self == null ? null : A.Version___parse_tearOff($self);
        t3 = t3 == null ? null : t2.call$1(t3);
        if (t3 == null ? false : t3)
          t1.add$1(0, deprecation);
      }
      return t1;
    },
    Deprecation0: function Deprecation0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.id = t0;
      _._deprecation$_deprecatedIn = t1;
      _.description = t2;
      _.isFuture = t3;
      _._name = t4;
    },
    Deprecation_fromId_closure0: function Deprecation_fromId_closure0(t0) {
      this.id = t0;
    },
    DeprecationProcessingLogger$0(_inner, fatalDeprecations, futureDeprecations, limitRepetition, silenceDeprecations) {
      var t1 = new A.DeprecationProcessingLogger0(A.LinkedHashMap_LinkedHashMap$_empty(type$.Deprecation_3, type$.int), _inner, silenceDeprecations, fatalDeprecations, futureDeprecations, limitRepetition);
      t1.DeprecationProcessingLogger$5$fatalDeprecations$futureDeprecations$limitRepetition$silenceDeprecations0(_inner, fatalDeprecations, futureDeprecations, limitRepetition, silenceDeprecations);
      return t1;
    },
    DeprecationProcessingLogger0: function DeprecationProcessingLogger0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._deprecation_processing$_warningCounts = t0;
      _._deprecation_processing$_inner = t1;
      _.silenceDeprecations = t2;
      _.fatalDeprecations = t3;
      _.futureDeprecations = t4;
      _.limitRepetition = t5;
    },
    DeprecationProcessingLogger_summarize_closure1: function DeprecationProcessingLogger_summarize_closure1() {
    },
    DeprecationProcessingLogger_summarize_closure2: function DeprecationProcessingLogger_summarize_closure2() {
    },
    Deprecation1: function Deprecation1() {
    },
    deprecations_closure: function deprecations_closure(t0) {
      this.deprecation = t0;
    },
    versionClass_closure: function versionClass_closure() {
    },
    versionClass__closure: function versionClass__closure() {
    },
    versionClass__closure0: function versionClass__closure0() {
    },
    DynamicImport0: function DynamicImport0(t0, t1) {
      this.urlString = t0;
      this.span = t1;
    },
    EachRule$0(variables, list, children, span) {
      var t1 = A.List_List$unmodifiable(variables, type$.String),
        t2 = A.List_List$unmodifiable(children, type$.Statement_2),
        t3 = B.JSArray_methods.any$1(t2, new A.ParentStatement_closure0());
      return new A.EachRule0(t1, list, span, t2, t3);
    },
    EachRule0: function EachRule0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.variables = t0;
      _.list = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    EachRule_toString_closure0: function EachRule_toString_closure0() {
    },
    EmptyExtensionStore0: function EmptyExtensionStore0() {
    },
    Environment$0() {
      var t1 = type$.String,
        t2 = type$.Module_Callable_2,
        t3 = type$.AstNode_2,
        t4 = type$.int,
        t5 = type$.Callable_2,
        t6 = type$.JSArray_Map_String_Callable_2;
      return new A.Environment0(A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), A.LinkedHashMap_LinkedHashMap$_empty(t1, t3), A.LinkedHashMap_LinkedHashMap$_empty(t2, t3), A.LinkedHashMap_LinkedHashMap$_empty(t2, t3), null, null, A._setArrayType([], type$.JSArray_Module_Callable_2), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Value_2)], type$.JSArray_Map_String_Value_2), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, t3)], type$.JSArray_Map_String_AstNode_2), A.LinkedHashMap_LinkedHashMap$_empty(t1, t4), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), A.LinkedHashMap_LinkedHashMap$_empty(t1, t4), A._setArrayType([A.LinkedHashMap_LinkedHashMap$_empty(t1, t5)], t6), A.LinkedHashMap_LinkedHashMap$_empty(t1, t4), null);
    },
    Environment$_0(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, _functions, _mixins, _content) {
      var t1 = type$.String,
        t2 = type$.int;
      return new A.Environment0(_modules, _namespaceNodes, _globalModules, _importedModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _functions, A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _mixins, A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _content);
    },
    _EnvironmentModule__EnvironmentModule1(environment, css, preModuleComments, extensionStore, forwarded) {
      var t1, t2, t3, t4, t5, t6, module, result, t7;
      if (forwarded == null)
        forwarded = B.Set_empty4;
      t1 = type$.dynamic;
      t1 = A.LinkedHashMap_LinkedHashMap$_empty(t1, t1);
      for (t2 = type$.Module_Callable_2, t3 = type$.List_CssComment_2, t4 = A.MapExtensions_get_pairs0(preModuleComments, t2, t3), t4 = t4.get$iterator(t4), t5 = type$.CssComment_2; t4.moveNext$0();) {
        t6 = t4.get$current(t4);
        module = t6._0;
        result = A.List_List$from(t6._1, false, t5);
        result.fixed$length = Array;
        result.immutable$list = Array;
        t1.$indexSet(0, module, result);
      }
      t1 = A.ConstantMap_ConstantMap$from(t1, t2, t3);
      t2 = A._EnvironmentModule__makeModulesByVariable1(forwarded);
      t3 = A._EnvironmentModule__memberMap1(B.JSArray_methods.get$first(environment._environment0$_variables), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure11(), type$.Map_String_Value_2), type$.Value_2);
      t4 = A._EnvironmentModule__memberMap1(B.JSArray_methods.get$first(environment._environment0$_variableNodes), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure12(), type$.Map_String_AstNode_2), type$.AstNode_2);
      t5 = type$.Map_String_Callable_2;
      t6 = type$.Callable_2;
      t7 = A._EnvironmentModule__memberMap1(B.JSArray_methods.get$first(environment._environment0$_functions), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure13(), t5), t6);
      t6 = A._EnvironmentModule__memberMap1(B.JSArray_methods.get$first(environment._environment0$_mixins), forwarded.map$1$1(0, new A._EnvironmentModule__EnvironmentModule_closure14(), t5), t6);
      t5 = J.get$isNotEmpty$asx(css.get$children(css)) || preModuleComments.get$isNotEmpty(preModuleComments) || B.JSArray_methods.any$1(environment._environment0$_allModules, new A._EnvironmentModule__EnvironmentModule_closure15());
      return A._EnvironmentModule$_1(environment, css, t1, extensionStore, t2, t3, t4, t7, t6, t5, !extensionStore.get$isEmpty(extensionStore) || B.JSArray_methods.any$1(environment._environment0$_allModules, new A._EnvironmentModule__EnvironmentModule_closure16()));
    },
    _EnvironmentModule__makeModulesByVariable1(forwarded) {
      var modulesByVariable, t1, t2, t3, t4, t5;
      if (forwarded.get$isEmpty(forwarded))
        return B.Map_empty10;
      modulesByVariable = A.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.Module_Callable_2);
      for (t1 = forwarded.get$iterator(forwarded); t1.moveNext$0();) {
        t2 = t1.get$current(t1);
        if (t2 instanceof A._EnvironmentModule1) {
          for (t3 = t2._environment0$_modulesByVariable, t3 = t3.get$values(t3), t3 = t3.get$iterator(t3); t3.moveNext$0();) {
            t4 = t3.get$current(t3);
            t5 = t4.get$variables();
            A.setAll0(modulesByVariable, t5.get$keys(t5), t4);
          }
          A.setAll0(modulesByVariable, J.get$keys$z(B.JSArray_methods.get$first(t2._environment0$_environment._environment0$_variables)), t2);
        } else {
          t3 = t2.get$variables();
          A.setAll0(modulesByVariable, t3.get$keys(t3), t2);
        }
      }
      return modulesByVariable;
    },
    _EnvironmentModule__memberMap1(localMap, otherMaps, $V) {
      var t1, t2, t3;
      localMap = new A.PublicMemberMapView0(localMap, $V._eval$1("PublicMemberMapView0<0>"));
      if (otherMaps.get$isEmpty(otherMaps))
        return localMap;
      t1 = A._setArrayType([], $V._eval$1("JSArray<Map<String,0>>"));
      for (t2 = otherMaps.get$iterator(otherMaps); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        if (t3.get$isNotEmpty(t3))
          t1.push(t3);
      }
      t1.push(localMap);
      if (t1.length === 1)
        return localMap;
      return A.MergedMapView$0(t1, type$.String, $V);
    },
    _EnvironmentModule$_1(_environment, css, preModuleComments, extensionStore, _modulesByVariable, variables, variableNodes, functions, mixins, transitivelyContainsCss, transitivelyContainsExtensions) {
      return new A._EnvironmentModule1(_environment._environment0$_allModules, variables, variableNodes, functions, mixins, extensionStore, css, preModuleComments, transitivelyContainsCss, transitivelyContainsExtensions, _environment, _modulesByVariable);
    },
    Environment0: function Environment0(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14) {
      var _ = this;
      _._environment0$_modules = t0;
      _._environment0$_namespaceNodes = t1;
      _._environment0$_globalModules = t2;
      _._environment0$_importedModules = t3;
      _._environment0$_forwardedModules = t4;
      _._environment0$_nestedForwardedModules = t5;
      _._environment0$_allModules = t6;
      _._environment0$_variables = t7;
      _._environment0$_variableNodes = t8;
      _._environment0$_variableIndices = t9;
      _._environment0$_functions = t10;
      _._environment0$_functionIndices = t11;
      _._environment0$_mixins = t12;
      _._environment0$_mixinIndices = t13;
      _._environment0$_content = t14;
      _._environment0$_inMixin = false;
      _._environment0$_inSemiGlobalScope = true;
      _._environment0$_lastVariableIndex = _._environment0$_lastVariableName = null;
    },
    Environment__getVariableFromGlobalModule_closure0: function Environment__getVariableFromGlobalModule_closure0(t0) {
      this.name = t0;
    },
    Environment_setVariable_closure2: function Environment_setVariable_closure2(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    Environment_setVariable_closure3: function Environment_setVariable_closure3(t0) {
      this.name = t0;
    },
    Environment_setVariable_closure4: function Environment_setVariable_closure4(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    Environment__getFunctionFromGlobalModule_closure0: function Environment__getFunctionFromGlobalModule_closure0(t0) {
      this.name = t0;
    },
    Environment__getMixinFromGlobalModule_closure0: function Environment__getMixinFromGlobalModule_closure0(t0) {
      this.name = t0;
    },
    Environment_toModule_closure0: function Environment_toModule_closure0() {
    },
    Environment_toDummyModule_closure0: function Environment_toDummyModule_closure0() {
    },
    _EnvironmentModule1: function _EnvironmentModule1(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11) {
      var _ = this;
      _.upstream = t0;
      _.variables = t1;
      _.variableNodes = t2;
      _.functions = t3;
      _.mixins = t4;
      _.extensionStore = t5;
      _.css = t6;
      _.preModuleComments = t7;
      _.transitivelyContainsCss = t8;
      _.transitivelyContainsExtensions = t9;
      _._environment0$_environment = t10;
      _._environment0$_modulesByVariable = t11;
    },
    _EnvironmentModule__EnvironmentModule_closure11: function _EnvironmentModule__EnvironmentModule_closure11() {
    },
    _EnvironmentModule__EnvironmentModule_closure12: function _EnvironmentModule__EnvironmentModule_closure12() {
    },
    _EnvironmentModule__EnvironmentModule_closure13: function _EnvironmentModule__EnvironmentModule_closure13() {
    },
    _EnvironmentModule__EnvironmentModule_closure14: function _EnvironmentModule__EnvironmentModule_closure14() {
    },
    _EnvironmentModule__EnvironmentModule_closure15: function _EnvironmentModule__EnvironmentModule_closure15() {
    },
    _EnvironmentModule__EnvironmentModule_closure16: function _EnvironmentModule__EnvironmentModule_closure16() {
    },
    ErrorRule0: function ErrorRule0(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    _EvaluateVisitor$1(functions, importCache, logger, nodeImporter, quietDeps, sourceMap) {
      var t4,
        t1 = type$.Uri,
        t2 = type$.Module_Callable_2,
        t3 = A._setArrayType([], type$.JSArray_Record_2_String_and_AstNode_2);
      if (importCache == null)
        t4 = nodeImporter == null ? A.ImportCache$none(logger) : null;
      else
        t4 = importCache;
      t1 = new A._EvaluateVisitor1(t4, nodeImporter, A.LinkedHashMap_LinkedHashMap$_empty(type$.String, type$.Callable_2), A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), A.LinkedHashMap_LinkedHashMap$_empty(t1, t2), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Configuration_2), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.AstNode_2), logger, A.LinkedHashSet_LinkedHashSet$_empty(type$.Record_2_String_and_SourceSpan), quietDeps, sourceMap, A.Environment$0(), A.LinkedHashSet_LinkedHashSet$_empty(t1), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.nullable_AstNode_2), t3, B.Configuration_Map_empty_null0);
      t1._EvaluateVisitor$6$functions$importCache$logger$nodeImporter$quietDeps$sourceMap1(functions, importCache, logger, nodeImporter, quietDeps, sourceMap);
      return t1;
    },
    _EvaluateVisitor1: function _EvaluateVisitor1(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15) {
      var _ = this;
      _._evaluate0$_importCache = t0;
      _._nodeImporter = t1;
      _._evaluate0$_builtInFunctions = t2;
      _._evaluate0$_builtInModules = t3;
      _._evaluate0$_modules = t4;
      _._evaluate0$_moduleConfigurations = t5;
      _._evaluate0$_moduleNodes = t6;
      _._evaluate0$_logger = t7;
      _._evaluate0$_warningsEmitted = t8;
      _._evaluate0$_quietDeps = t9;
      _._evaluate0$_sourceMap = t10;
      _._evaluate0$_environment = t11;
      _._evaluate0$_declarationName = _._evaluate0$__parent = _._evaluate0$_mediaQuerySources = _._evaluate0$_mediaQueries = _._evaluate0$_styleRuleIgnoringAtRoot = null;
      _._evaluate0$_member = "root stylesheet";
      _._evaluate0$_importSpan = _._evaluate0$_callableNode = _._evaluate0$_currentCallable = null;
      _._evaluate0$_inSupportsDeclaration = _._evaluate0$_inKeyframes = _._evaluate0$_atRootExcludingStyleRule = _._evaluate0$_inUnknownAtRule = _._evaluate0$_inFunction = false;
      _._evaluate0$_loadedUrls = t12;
      _._evaluate0$_activeModules = t13;
      _._evaluate0$_stack = t14;
      _._evaluate0$_importer = null;
      _._evaluate0$_inDependency = false;
      _._evaluate0$__extensionStore = _._evaluate0$_preModuleComments = _._evaluate0$_outOfOrderImports = _._evaluate0$__endOfImports = _._evaluate0$__root = _._evaluate0$__stylesheet = null;
      _._evaluate0$_configuration = t15;
    },
    _EvaluateVisitor_closure25: function _EvaluateVisitor_closure25(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure26: function _EvaluateVisitor_closure26(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure27: function _EvaluateVisitor_closure27(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure28: function _EvaluateVisitor_closure28(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure29: function _EvaluateVisitor_closure29(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure30: function _EvaluateVisitor_closure30(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure31: function _EvaluateVisitor_closure31(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure32: function _EvaluateVisitor_closure32(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure33: function _EvaluateVisitor_closure33(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure10: function _EvaluateVisitor__closure10(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.module = t2;
    },
    _EvaluateVisitor_closure34: function _EvaluateVisitor_closure34(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure9: function _EvaluateVisitor__closure9(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.module = t2;
    },
    _EvaluateVisitor_closure35: function _EvaluateVisitor_closure35(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure36: function _EvaluateVisitor_closure36(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure7: function _EvaluateVisitor__closure7(t0, t1, t2) {
      this.values = t0;
      this.span = t1;
      this.callableNode = t2;
    },
    _EvaluateVisitor__closure8: function _EvaluateVisitor__closure8(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure37: function _EvaluateVisitor_closure37(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_run_closure1: function _EvaluateVisitor_run_closure1(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.importer = t2;
    },
    _EvaluateVisitor_run__closure1: function _EvaluateVisitor_run__closure1(t0, t1, t2) {
      this.$this = t0;
      this.importer = t1;
      this.node = t2;
    },
    _EvaluateVisitor__loadModule_closure3: function _EvaluateVisitor__loadModule_closure3(t0, t1) {
      this._box_1 = t0;
      this.callback = t1;
    },
    _EvaluateVisitor__loadModule_closure4: function _EvaluateVisitor__loadModule_closure4(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.nodeWithSpan = t2;
      _.baseUrl = t3;
      _.namesInErrors = t4;
      _.configuration = t5;
      _.callback = t6;
    },
    _EvaluateVisitor__loadModule__closure3: function _EvaluateVisitor__loadModule__closure3(t0, t1) {
      this.$this = t0;
      this.message = t1;
    },
    _EvaluateVisitor__loadModule__closure4: function _EvaluateVisitor__loadModule__closure4(t0, t1, t2) {
      this._box_0 = t0;
      this.callback = t1;
      this.firstLoad = t2;
    },
    _EvaluateVisitor__execute_closure1: function _EvaluateVisitor__execute_closure1(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.stylesheet = t2;
      _.extensionStore = t3;
      _.configuration = t4;
      _.css = t5;
      _.preModuleComments = t6;
    },
    _EvaluateVisitor__combineCss_closure3: function _EvaluateVisitor__combineCss_closure3() {
    },
    _EvaluateVisitor__combineCss_closure4: function _EvaluateVisitor__combineCss_closure4(t0) {
      this.selectors = t0;
    },
    _EvaluateVisitor__combineCss_visitModule1: function _EvaluateVisitor__combineCss_visitModule1(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.seen = t1;
      _.clone = t2;
      _.css = t3;
      _.imports = t4;
      _.sorted = t5;
    },
    _EvaluateVisitor__extendModules_closure3: function _EvaluateVisitor__extendModules_closure3(t0) {
      this.originalSelectors = t0;
    },
    _EvaluateVisitor__extendModules_closure4: function _EvaluateVisitor__extendModules_closure4() {
    },
    _EvaluateVisitor_visitAtRootRule_closure3: function _EvaluateVisitor_visitAtRootRule_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure4: function _EvaluateVisitor_visitAtRootRule_closure4(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure11: function _EvaluateVisitor__scopeForAtRoot_closure11(t0, t1, t2) {
      this.$this = t0;
      this.newParent = t1;
      this.node = t2;
    },
    _EvaluateVisitor__scopeForAtRoot_closure12: function _EvaluateVisitor__scopeForAtRoot_closure12(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure13: function _EvaluateVisitor__scopeForAtRoot_closure13(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot__closure1: function _EvaluateVisitor__scopeForAtRoot__closure1(t0, t1) {
      this.innerScope = t0;
      this.callback = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure14: function _EvaluateVisitor__scopeForAtRoot_closure14(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure15: function _EvaluateVisitor__scopeForAtRoot_closure15() {
    },
    _EvaluateVisitor__scopeForAtRoot_closure16: function _EvaluateVisitor__scopeForAtRoot_closure16(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor_visitContentRule_closure1: function _EvaluateVisitor_visitContentRule_closure1(t0, t1) {
      this.$this = t0;
      this.content = t1;
    },
    _EvaluateVisitor_visitDeclaration_closure1: function _EvaluateVisitor_visitDeclaration_closure1(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitEachRule_closure5: function _EvaluateVisitor_visitEachRule_closure5(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure6: function _EvaluateVisitor_visitEachRule_closure6(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.nodeWithSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure7: function _EvaluateVisitor_visitEachRule_closure7(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.list = t1;
      _.setVariables = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitEachRule__closure1: function _EvaluateVisitor_visitEachRule__closure1(t0, t1, t2) {
      this.$this = t0;
      this.setVariables = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitEachRule___closure1: function _EvaluateVisitor_visitEachRule___closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitAtRule_closure5: function _EvaluateVisitor_visitAtRule_closure5(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitAtRule_closure6: function _EvaluateVisitor_visitAtRule_closure6(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.children = t2;
    },
    _EvaluateVisitor_visitAtRule__closure1: function _EvaluateVisitor_visitAtRule__closure1(t0, t1) {
      this.$this = t0;
      this.children = t1;
    },
    _EvaluateVisitor_visitAtRule_closure7: function _EvaluateVisitor_visitAtRule_closure7() {
    },
    _EvaluateVisitor_visitForRule_closure9: function _EvaluateVisitor_visitForRule_closure9(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure10: function _EvaluateVisitor_visitForRule_closure10(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure11: function _EvaluateVisitor_visitForRule_closure11(t0) {
      this.fromNumber = t0;
    },
    _EvaluateVisitor_visitForRule_closure12: function _EvaluateVisitor_visitForRule_closure12(t0, t1) {
      this.toNumber = t0;
      this.fromNumber = t1;
    },
    _EvaluateVisitor_visitForRule_closure13: function _EvaluateVisitor_visitForRule_closure13(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.node = t2;
      _.from = t3;
      _.direction = t4;
      _.fromNumber = t5;
    },
    _EvaluateVisitor_visitForRule__closure1: function _EvaluateVisitor_visitForRule__closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitForwardRule_closure3: function _EvaluateVisitor_visitForwardRule_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForwardRule_closure4: function _EvaluateVisitor_visitForwardRule_closure4(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__registerCommentsForModule_closure1: function _EvaluateVisitor__registerCommentsForModule_closure1() {
    },
    _EvaluateVisitor_visitIfRule_closure1: function _EvaluateVisitor_visitIfRule_closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIfRule__closure1: function _EvaluateVisitor_visitIfRule__closure1(t0, t1) {
      this.$this = t0;
      this.clause = t1;
    },
    _EvaluateVisitor_visitIfRule___closure1: function _EvaluateVisitor_visitIfRule___closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport_closure1: function _EvaluateVisitor__visitDynamicImport_closure1(t0, t1) {
      this.$this = t0;
      this.$import = t1;
    },
    _EvaluateVisitor__visitDynamicImport__closure7: function _EvaluateVisitor__visitDynamicImport__closure7(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport__closure8: function _EvaluateVisitor__visitDynamicImport__closure8() {
    },
    _EvaluateVisitor__visitDynamicImport__closure9: function _EvaluateVisitor__visitDynamicImport__closure9() {
    },
    _EvaluateVisitor__visitDynamicImport__closure10: function _EvaluateVisitor__visitDynamicImport__closure10(t0, t1, t2, t3, t4) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.loadsUserDefinedModules = t2;
      _.environment = t3;
      _.children = t4;
    },
    _EvaluateVisitor__applyMixin_closure3: function _EvaluateVisitor__applyMixin_closure3(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.$arguments = t1;
      _.mixin = t2;
      _.nodeWithSpanWithoutContent = t3;
    },
    _EvaluateVisitor__applyMixin__closure4: function _EvaluateVisitor__applyMixin__closure4(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.$arguments = t1;
      _.mixin = t2;
      _.nodeWithSpanWithoutContent = t3;
    },
    _EvaluateVisitor__applyMixin_closure4: function _EvaluateVisitor__applyMixin_closure4(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.contentCallable = t1;
      _.mixin = t2;
      _.nodeWithSpanWithoutContent = t3;
    },
    _EvaluateVisitor__applyMixin__closure3: function _EvaluateVisitor__applyMixin__closure3(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpanWithoutContent = t2;
    },
    _EvaluateVisitor__applyMixin___closure1: function _EvaluateVisitor__applyMixin___closure1(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.nodeWithSpanWithoutContent = t2;
    },
    _EvaluateVisitor__applyMixin____closure1: function _EvaluateVisitor__applyMixin____closure1(t0, t1) {
      this.$this = t0;
      this.statement = t1;
    },
    _EvaluateVisitor_visitIncludeRule_closure5: function _EvaluateVisitor_visitIncludeRule_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitIncludeRule_closure6: function _EvaluateVisitor_visitIncludeRule_closure6(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitIncludeRule_closure7: function _EvaluateVisitor_visitIncludeRule_closure7(t0) {
      this.node = t0;
    },
    _EvaluateVisitor_visitMediaRule_closure5: function _EvaluateVisitor_visitMediaRule_closure5(t0, t1) {
      this.$this = t0;
      this.queries = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure6: function _EvaluateVisitor_visitMediaRule_closure6(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.mergedQueries = t1;
      _.queries = t2;
      _.mergedSources = t3;
      _.node = t4;
    },
    _EvaluateVisitor_visitMediaRule__closure1: function _EvaluateVisitor_visitMediaRule__closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule___closure1: function _EvaluateVisitor_visitMediaRule___closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure7: function _EvaluateVisitor_visitMediaRule_closure7(t0) {
      this.mergedSources = t0;
    },
    _EvaluateVisitor_visitStyleRule_closure9: function _EvaluateVisitor_visitStyleRule_closure9(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure10: function _EvaluateVisitor_visitStyleRule_closure10() {
    },
    _EvaluateVisitor_visitStyleRule_closure12: function _EvaluateVisitor_visitStyleRule_closure12(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitStyleRule__closure1: function _EvaluateVisitor_visitStyleRule__closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure11: function _EvaluateVisitor_visitStyleRule_closure11() {
    },
    _EvaluateVisitor_visitStyleRule_closure13: function _EvaluateVisitor_visitStyleRule_closure13() {
    },
    _EvaluateVisitor_visitSupportsRule_closure3: function _EvaluateVisitor_visitSupportsRule_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule__closure1: function _EvaluateVisitor_visitSupportsRule__closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule_closure4: function _EvaluateVisitor_visitSupportsRule_closure4() {
    },
    _EvaluateVisitor__visitSupportsCondition_closure1: function _EvaluateVisitor__visitSupportsCondition_closure1(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure5: function _EvaluateVisitor_visitVariableDeclaration_closure5(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure6: function _EvaluateVisitor_visitVariableDeclaration_closure6(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure7: function _EvaluateVisitor_visitVariableDeclaration_closure7(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.value = t2;
    },
    _EvaluateVisitor_visitUseRule_closure1: function _EvaluateVisitor_visitUseRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWarnRule_closure1: function _EvaluateVisitor_visitWarnRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule_closure1: function _EvaluateVisitor_visitWhileRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule__closure1: function _EvaluateVisitor_visitWhileRule__closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitBinaryOperationExpression_closure1: function _EvaluateVisitor_visitBinaryOperationExpression_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__slash_recommendation1: function _EvaluateVisitor__slash_recommendation1() {
    },
    _EvaluateVisitor_visitVariableExpression_closure1: function _EvaluateVisitor_visitVariableExpression_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitUnaryOperationExpression_closure1: function _EvaluateVisitor_visitUnaryOperationExpression_closure1(t0, t1) {
      this.node = t0;
      this.operand = t1;
    },
    _EvaluateVisitor_visitListExpression_closure1: function _EvaluateVisitor_visitListExpression_closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitFunctionExpression_closure5: function _EvaluateVisitor_visitFunctionExpression_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitFunctionExpression_closure6: function _EvaluateVisitor_visitFunctionExpression_closure6() {
    },
    _EvaluateVisitor_visitFunctionExpression_closure7: function _EvaluateVisitor_visitFunctionExpression_closure7(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.node = t2;
    },
    _EvaluateVisitor__checkCalculationArguments_check1: function _EvaluateVisitor__checkCalculationArguments_check1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__visitCalculationExpression_closure1: function _EvaluateVisitor__visitCalculationExpression_closure1(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.node = t2;
      _.inLegacySassFunction = t3;
    },
    _EvaluateVisitor_visitInterpolatedFunctionExpression_closure1: function _EvaluateVisitor_visitInterpolatedFunctionExpression_closure1(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.$function = t2;
    },
    _EvaluateVisitor__runUserDefinedCallable_closure1: function _EvaluateVisitor__runUserDefinedCallable_closure1(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.callable = t1;
      _.evaluated = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable__closure1: function _EvaluateVisitor__runUserDefinedCallable__closure1(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable___closure1: function _EvaluateVisitor__runUserDefinedCallable___closure1(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
      _.V = t5;
    },
    _EvaluateVisitor__runUserDefinedCallable____closure1: function _EvaluateVisitor__runUserDefinedCallable____closure1() {
    },
    _EvaluateVisitor__runFunctionCallable_closure1: function _EvaluateVisitor__runFunctionCallable_closure1(t0, t1) {
      this.$this = t0;
      this.callable = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure5: function _EvaluateVisitor__runBuiltInCallable_closure5(t0, t1, t2) {
      this._box_0 = t0;
      this.evaluated = t1;
      this.namedSet = t2;
    },
    _EvaluateVisitor__runBuiltInCallable_closure6: function _EvaluateVisitor__runBuiltInCallable_closure6(t0, t1) {
      this._box_0 = t0;
      this.evaluated = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure7: function _EvaluateVisitor__runBuiltInCallable_closure7() {
    },
    _EvaluateVisitor__evaluateArguments_closure7: function _EvaluateVisitor__evaluateArguments_closure7() {
    },
    _EvaluateVisitor__evaluateArguments_closure8: function _EvaluateVisitor__evaluateArguments_closure8(t0, t1) {
      this.$this = t0;
      this.restNodeForSpan = t1;
    },
    _EvaluateVisitor__evaluateArguments_closure9: function _EvaluateVisitor__evaluateArguments_closure9(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.namedNodes = t3;
    },
    _EvaluateVisitor__evaluateArguments_closure10: function _EvaluateVisitor__evaluateArguments_closure10() {
    },
    _EvaluateVisitor__evaluateMacroArguments_closure7: function _EvaluateVisitor__evaluateMacroArguments_closure7(t0) {
      this.restArgs = t0;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure8: function _EvaluateVisitor__evaluateMacroArguments_closure8(t0, t1, t2) {
      this.$this = t0;
      this.restNodeForSpan = t1;
      this.restArgs = t2;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure9: function _EvaluateVisitor__evaluateMacroArguments_closure9(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.named = t1;
      _.restNodeForSpan = t2;
      _.restArgs = t3;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure10: function _EvaluateVisitor__evaluateMacroArguments_closure10(t0, t1, t2) {
      this.$this = t0;
      this.keywordRestNodeForSpan = t1;
      this.keywordRestArgs = t2;
    },
    _EvaluateVisitor__addRestMap_closure1: function _EvaluateVisitor__addRestMap_closure1(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.$this = t0;
      _.values = t1;
      _.convert = t2;
      _.expressionNode = t3;
      _.map = t4;
      _.nodeWithSpan = t5;
    },
    _EvaluateVisitor__verifyArguments_closure1: function _EvaluateVisitor__verifyArguments_closure1(t0, t1, t2) {
      this.$arguments = t0;
      this.positional = t1;
      this.named = t2;
    },
    _EvaluateVisitor_visitCssAtRule_closure3: function _EvaluateVisitor_visitCssAtRule_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssAtRule_closure4: function _EvaluateVisitor_visitCssAtRule_closure4() {
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure3: function _EvaluateVisitor_visitCssKeyframeBlock_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure4: function _EvaluateVisitor_visitCssKeyframeBlock_closure4() {
    },
    _EvaluateVisitor_visitCssMediaRule_closure5: function _EvaluateVisitor_visitCssMediaRule_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure6: function _EvaluateVisitor_visitCssMediaRule_closure6(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.mergedQueries = t1;
      _.node = t2;
      _.mergedSources = t3;
    },
    _EvaluateVisitor_visitCssMediaRule__closure1: function _EvaluateVisitor_visitCssMediaRule__closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule___closure1: function _EvaluateVisitor_visitCssMediaRule___closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure7: function _EvaluateVisitor_visitCssMediaRule_closure7(t0) {
      this.mergedSources = t0;
    },
    _EvaluateVisitor_visitCssStyleRule_closure4: function _EvaluateVisitor_visitCssStyleRule_closure4(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssStyleRule__closure1: function _EvaluateVisitor_visitCssStyleRule__closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssStyleRule_closure3: function _EvaluateVisitor_visitCssStyleRule_closure3() {
    },
    _EvaluateVisitor_visitCssSupportsRule_closure3: function _EvaluateVisitor_visitCssSupportsRule_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule__closure1: function _EvaluateVisitor_visitCssSupportsRule__closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule_closure4: function _EvaluateVisitor_visitCssSupportsRule_closure4() {
    },
    _EvaluateVisitor__performInterpolationHelper_closure1: function _EvaluateVisitor__performInterpolationHelper_closure1(t0) {
      this.interpolation = t0;
    },
    _EvaluateVisitor__serialize_closure1: function _EvaluateVisitor__serialize_closure1(t0, t1) {
      this.value = t0;
      this.quote = t1;
    },
    _EvaluateVisitor__expressionNode_closure1: function _EvaluateVisitor__expressionNode_closure1(t0, t1) {
      this.$this = t0;
      this.expression = t1;
    },
    _EvaluateVisitor__withoutSlash_recommendation1: function _EvaluateVisitor__withoutSlash_recommendation1() {
    },
    _EvaluateVisitor__stackFrame_closure1: function _EvaluateVisitor__stackFrame_closure1(t0) {
      this.$this = t0;
    },
    _ImportedCssVisitor1: function _ImportedCssVisitor1(t0) {
      this._evaluate0$_visitor = t0;
    },
    _ImportedCssVisitor_visitCssAtRule_closure1: function _ImportedCssVisitor_visitCssAtRule_closure1() {
    },
    _ImportedCssVisitor_visitCssMediaRule_closure1: function _ImportedCssVisitor_visitCssMediaRule_closure1(t0) {
      this.hasBeenMerged = t0;
    },
    _ImportedCssVisitor_visitCssStyleRule_closure1: function _ImportedCssVisitor_visitCssStyleRule_closure1() {
    },
    _ImportedCssVisitor_visitCssSupportsRule_closure1: function _ImportedCssVisitor_visitCssSupportsRule_closure1() {
    },
    _EvaluationContext1: function _EvaluationContext1(t0, t1) {
      this._evaluate0$_visitor = t0;
      this._evaluate0$_defaultWarnNodeWithSpan = t1;
    },
    EveryCssVisitor0: function EveryCssVisitor0() {
    },
    EveryCssVisitor_visitCssAtRule_closure0: function EveryCssVisitor_visitCssAtRule_closure0(t0) {
      this.$this = t0;
    },
    EveryCssVisitor_visitCssKeyframeBlock_closure0: function EveryCssVisitor_visitCssKeyframeBlock_closure0(t0) {
      this.$this = t0;
    },
    EveryCssVisitor_visitCssMediaRule_closure0: function EveryCssVisitor_visitCssMediaRule_closure0(t0) {
      this.$this = t0;
    },
    EveryCssVisitor_visitCssStyleRule_closure0: function EveryCssVisitor_visitCssStyleRule_closure0(t0) {
      this.$this = t0;
    },
    EveryCssVisitor_visitCssStylesheet_closure0: function EveryCssVisitor_visitCssStylesheet_closure0(t0) {
      this.$this = t0;
    },
    EveryCssVisitor_visitCssSupportsRule_closure0: function EveryCssVisitor_visitCssSupportsRule_closure0(t0) {
      this.$this = t0;
    },
    throwNodeException(exception, ascii, color, trace) {
      var wasAscii, jsException, t1, trace0;
      trace = trace;
      wasAscii = $._glyphs === B.C_AsciiGlyphSet;
      $._glyphs = ascii ? B.C_AsciiGlyphSet : B.C_UnicodeGlyphSet;
      try {
        t1 = A.callConstructor($.$get$exceptionClass(), [exception, B.JSString_methods.replaceFirst$2(exception.toString$1$color(0, color), "Error: ", "")]);
        jsException = type$._NodeException._as(t1);
        trace0 = A.getTrace0(exception);
        trace = trace0 == null ? trace : trace0;
        if (trace != null)
          A.attachJsStack(jsException, trace);
        A.jsThrow(jsException);
      } finally {
        $._glyphs = wasAscii ? B.C_AsciiGlyphSet : B.C_UnicodeGlyphSet;
      }
    },
    _NodeException: function _NodeException() {
    },
    exceptionClass_closure: function exceptionClass_closure() {
    },
    exceptionClass__closure: function exceptionClass__closure() {
    },
    exceptionClass__closure0: function exceptionClass__closure0() {
    },
    exceptionClass__closure1: function exceptionClass__closure1() {
    },
    SassException$0(message, span, loadedUrls) {
      return new A.SassException0(loadedUrls == null ? B.Set_empty : A.Set_Set$unmodifiable(loadedUrls, type$.Uri), message, span);
    },
    MultiSpanSassException$0(message, span, primaryLabel, secondarySpans, loadedUrls) {
      var t1 = A.ConstantMap_ConstantMap$from(secondarySpans, type$.FileSpan, type$.String);
      return new A.MultiSpanSassException0(primaryLabel, t1, loadedUrls == null ? B.Set_empty : A.Set_Set$unmodifiable(loadedUrls, type$.Uri), message, span);
    },
    SassRuntimeException$0(message, span, trace, loadedUrls) {
      return new A.SassRuntimeException0(trace, loadedUrls == null ? B.Set_empty : A.Set_Set$unmodifiable(loadedUrls, type$.Uri), message, span);
    },
    MultiSpanSassRuntimeException$0(message, span, primaryLabel, secondarySpans, trace, loadedUrls) {
      var t1 = A.ConstantMap_ConstantMap$from(secondarySpans, type$.FileSpan, type$.String);
      return new A.MultiSpanSassRuntimeException0(trace, primaryLabel, t1, loadedUrls == null ? B.Set_empty : A.Set_Set$unmodifiable(loadedUrls, type$.Uri), message, span);
    },
    SassFormatException$0(message, span, loadedUrls) {
      return new A.SassFormatException0(loadedUrls == null ? B.Set_empty : A.Set_Set$unmodifiable(loadedUrls, type$.Uri), message, span);
    },
    MultiSpanSassFormatException$0(message, span, primaryLabel, secondarySpans, loadedUrls) {
      var t1 = A.ConstantMap_ConstantMap$from(secondarySpans, type$.FileSpan, type$.String);
      return new A.MultiSpanSassFormatException0(primaryLabel, t1, loadedUrls == null ? B.Set_empty : A.Set_Set$unmodifiable(loadedUrls, type$.Uri), message, span);
    },
    SassScriptException$0(message, argumentName) {
      return new A.SassScriptException0(argumentName == null ? message : "$" + argumentName + ": " + message);
    },
    MultiSpanSassScriptException$0(message, primaryLabel, secondarySpans) {
      var t1 = A.ConstantMap_ConstantMap$from(secondarySpans, type$.FileSpan, type$.String);
      return new A.MultiSpanSassScriptException0(primaryLabel, t1, message);
    },
    SassException0: function SassException0(t0, t1, t2) {
      this.loadedUrls = t0;
      this._span_exception$_message = t1;
      this._span = t2;
    },
    MultiSpanSassException0: function MultiSpanSassException0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.primaryLabel = t0;
      _.secondarySpans = t1;
      _.loadedUrls = t2;
      _._span_exception$_message = t3;
      _._span = t4;
    },
    SassRuntimeException0: function SassRuntimeException0(t0, t1, t2, t3) {
      var _ = this;
      _.trace = t0;
      _.loadedUrls = t1;
      _._span_exception$_message = t2;
      _._span = t3;
    },
    MultiSpanSassRuntimeException0: function MultiSpanSassRuntimeException0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.trace = t0;
      _.primaryLabel = t1;
      _.secondarySpans = t2;
      _.loadedUrls = t3;
      _._span_exception$_message = t4;
      _._span = t5;
    },
    SassFormatException0: function SassFormatException0(t0, t1, t2) {
      this.loadedUrls = t0;
      this._span_exception$_message = t1;
      this._span = t2;
    },
    MultiSpanSassFormatException0: function MultiSpanSassFormatException0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.primaryLabel = t0;
      _.secondarySpans = t1;
      _.loadedUrls = t2;
      _._span_exception$_message = t3;
      _._span = t4;
    },
    SassScriptException0: function SassScriptException0(t0) {
      this.message = t0;
    },
    MultiSpanSassScriptException0: function MultiSpanSassScriptException0(t0, t1, t2) {
      this.primaryLabel = t0;
      this.secondarySpans = t1;
      this.message = t2;
    },
    Exports: function Exports() {
    },
    LoggerNamespace: function LoggerNamespace() {
    },
    _IsCalculationSafeVisitor0: function _IsCalculationSafeVisitor0() {
    },
    _IsCalculationSafeVisitor_visitListExpression_closure0: function _IsCalculationSafeVisitor_visitListExpression_closure0(t0) {
      this.$this = t0;
    },
    expressionToCalc0(expression) {
      var t4,
        t1 = A._setArrayType([B.C__MakeExpressionCalculationSafe0.visitBinaryOperationExpression$1(expression)], type$.JSArray_Expression_2),
        t2 = expression.get$span(0),
        t3 = type$.Expression_2;
      t1 = A.List_List$unmodifiable(t1, t3);
      t3 = A.ConstantMap_ConstantMap$from(B.Map_empty14, type$.String, t3);
      t4 = expression.get$span(0);
      return new A.FunctionExpression0(null, A.stringReplaceAllUnchecked("calc", "_", "-"), "calc", new A.ArgumentInvocation0(t1, t3, null, null, t2), t4);
    },
    _MakeExpressionCalculationSafe0: function _MakeExpressionCalculationSafe0() {
    },
    __MakeExpressionCalculationSafe_Object_ReplaceExpressionVisitor0: function __MakeExpressionCalculationSafe_Object_ReplaceExpressionVisitor0() {
    },
    ExtendRule0: function ExtendRule0(t0, t1, t2) {
      this.selector = t0;
      this.isOptional = t1;
      this.span = t2;
    },
    Extension0: function Extension0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.extender = t0;
      _.target = t1;
      _.mediaContext = t2;
      _.isOptional = t3;
      _.span = t4;
    },
    Extender0: function Extender0(t0, t1) {
      this.selector = t0;
      this.isOriginal = t1;
      this._extension$_extension = null;
    },
    ExtensionStore__extendOrReplace0(selector, source, targets, mode, span) {
      var t1, t2, t3, t4, t5, t6, t7, t8, _i, complex, compound, t9, t10, t11, _i0, simple, t12, _i1, t13, t14,
        extender = A.ExtensionStore$_mode0(mode);
      if (!selector.accept$1(B._IsInvisibleVisitor_true0))
        extender._extension_store$_originals.addAll$1(0, selector.components);
      for (t1 = targets.components, t2 = t1.length, t3 = source.components, t4 = t3.length, t5 = type$.ComplexSelector_2, t6 = type$.Extension_2, t7 = type$.SimpleSelector_2, t8 = type$.Map_ComplexSelector_Extension_2, _i = 0; _i < t2; ++_i) {
        complex = t1[_i];
        compound = complex.get$singleCompound();
        if (compound == null)
          throw A.wrapException(A.SassScriptException$0("Can't extend complex selector " + A.S(complex) + ".", null));
        t9 = A.LinkedHashMap_LinkedHashMap$_empty(t7, t8);
        for (t10 = compound.components, t11 = t10.length, _i0 = 0; _i0 < t11; ++_i0) {
          simple = t10[_i0];
          t12 = A.LinkedHashMap_LinkedHashMap$_empty(t5, t6);
          for (_i1 = 0; _i1 < t4; ++_i1) {
            complex = t3[_i1];
            complex.get$specificity();
            t13 = new A.Extender0(complex, false);
            t14 = new A.Extension0(t13, simple, null, true, span);
            t13._extension$_extension = t14;
            t12.$indexSet(0, complex, t14);
          }
          t9.$indexSet(0, simple, t12);
        }
        selector = extender._extension_store$_extendList$2(selector, t9);
      }
      return selector;
    },
    ExtensionStore$0() {
      var t1 = type$.SimpleSelector_2;
      return new A.ExtensionStore0(A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Set_ModifiableBox_SelectorList_2), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Map_ComplexSelector_Extension_2), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.List_Extension_2), A.LinkedHashMap_LinkedHashMap$_empty(type$.ModifiableBox_SelectorList_2, type$.List_CssMediaQuery_2), new A.JsIdentityLinkedHashMap(type$.JsIdentityLinkedHashMap_SimpleSelector_int_2), new A._LinkedIdentityHashSet(type$._LinkedIdentityHashSet_ComplexSelector_2), B.ExtendMode_normal_normal0);
    },
    ExtensionStore$_mode0(_mode) {
      var t1 = type$.SimpleSelector_2;
      return new A.ExtensionStore0(A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Set_ModifiableBox_SelectorList_2), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.Map_ComplexSelector_Extension_2), A.LinkedHashMap_LinkedHashMap$_empty(t1, type$.List_Extension_2), A.LinkedHashMap_LinkedHashMap$_empty(type$.ModifiableBox_SelectorList_2, type$.List_CssMediaQuery_2), new A.JsIdentityLinkedHashMap(type$.JsIdentityLinkedHashMap_SimpleSelector_int_2), new A._LinkedIdentityHashSet(type$._LinkedIdentityHashSet_ComplexSelector_2), _mode);
    },
    ExtensionStore0: function ExtensionStore0(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._extension_store$_selectors = t0;
      _._extension_store$_extensions = t1;
      _._extension_store$_extensionsByExtender = t2;
      _._extension_store$_mediaContexts = t3;
      _._extension_store$_sourceSpecificity = t4;
      _._extension_store$_originals = t5;
      _._extension_store$_mode = t6;
    },
    ExtensionStore_extensionsWhereTarget_closure0: function ExtensionStore_extensionsWhereTarget_closure0() {
    },
    ExtensionStore__registerSelector_closure0: function ExtensionStore__registerSelector_closure0() {
    },
    ExtensionStore_addExtension_closure2: function ExtensionStore_addExtension_closure2() {
    },
    ExtensionStore_addExtension_closure3: function ExtensionStore_addExtension_closure3() {
    },
    ExtensionStore_addExtension_closure4: function ExtensionStore_addExtension_closure4(t0) {
      this.complex = t0;
    },
    ExtensionStore__extendExistingExtensions_closure1: function ExtensionStore__extendExistingExtensions_closure1() {
    },
    ExtensionStore__extendExistingExtensions_closure2: function ExtensionStore__extendExistingExtensions_closure2() {
    },
    ExtensionStore_addExtensions_closure0: function ExtensionStore_addExtensions_closure0() {
    },
    ExtensionStore__extendComplex_closure0: function ExtensionStore__extendComplex_closure0(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.complex = t2;
    },
    ExtensionStore__extendComplex__closure0: function ExtensionStore__extendComplex__closure0(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.complex = t2;
    },
    ExtensionStore__extendCompound_closure2: function ExtensionStore__extendCompound_closure2() {
    },
    ExtensionStore__extendCompound_closure3: function ExtensionStore__extendCompound_closure3() {
    },
    ExtensionStore__extendCompound_closure4: function ExtensionStore__extendCompound_closure4(t0) {
      this.original = t0;
    },
    ExtensionStore__extendSimple_withoutPseudo0: function ExtensionStore__extendSimple_withoutPseudo0(t0, t1, t2) {
      this.$this = t0;
      this.extensions = t1;
      this.targetsUsed = t2;
    },
    ExtensionStore__extendSimple_closure1: function ExtensionStore__extendSimple_closure1(t0, t1) {
      this.$this = t0;
      this.withoutPseudo = t1;
    },
    ExtensionStore__extendSimple_closure2: function ExtensionStore__extendSimple_closure2() {
    },
    ExtensionStore__extendPseudo_closure4: function ExtensionStore__extendPseudo_closure4() {
    },
    ExtensionStore__extendPseudo_closure5: function ExtensionStore__extendPseudo_closure5() {
    },
    ExtensionStore__extendPseudo_closure6: function ExtensionStore__extendPseudo_closure6() {
    },
    ExtensionStore__extendPseudo_closure7: function ExtensionStore__extendPseudo_closure7(t0) {
      this.pseudo = t0;
    },
    ExtensionStore__extendPseudo_closure8: function ExtensionStore__extendPseudo_closure8(t0, t1) {
      this.pseudo = t0;
      this.selector = t1;
    },
    ExtensionStore__trim_closure1: function ExtensionStore__trim_closure1(t0, t1) {
      this._box_0 = t0;
      this.complex1 = t1;
    },
    ExtensionStore__trim_closure2: function ExtensionStore__trim_closure2(t0, t1) {
      this._box_0 = t0;
      this.complex1 = t1;
    },
    ExtensionStore_clone_closure0: function ExtensionStore_clone_closure0(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.newSelectors = t1;
      _.oldToNewSelectors = t2;
      _.newMediaContexts = t3;
    },
    FiberClass: function FiberClass() {
    },
    Fiber: function Fiber() {
    },
    JSToDartFileImporter: function JSToDartFileImporter(t0) {
      this._file0$_findFileUrl = t0;
    },
    JSToDartFileImporter_canonicalize_closure: function JSToDartFileImporter_canonicalize_closure(t0, t1) {
      this.$this = t0;
      this.url = t1;
    },
    FilesystemImporter0: function FilesystemImporter0(t0, t1) {
      this._filesystem$_loadPath = t0;
      this._filesystem$_loadPathDeprecated = t1;
    },
    FilesystemImporter_canonicalize_closure0: function FilesystemImporter_canonicalize_closure0() {
    },
    ForRule$0(variable, from, to, children, span, exclusive) {
      var t1 = A.List_List$unmodifiable(children, type$.Statement_2),
        t2 = B.JSArray_methods.any$1(t1, new A.ParentStatement_closure0());
      return new A.ForRule0(variable, from, to, exclusive, span, t1, t2);
    },
    ForRule0: function ForRule0(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.variable = t0;
      _.from = t1;
      _.to = t2;
      _.isExclusive = t3;
      _.span = t4;
      _.children = t5;
      _.hasDeclarations = t6;
    },
    ForwardRule0: function ForwardRule0(t0, t1, t2, t3, t4, t5, t6, t7) {
      var _ = this;
      _.url = t0;
      _.shownMixinsAndFunctions = t1;
      _.shownVariables = t2;
      _.hiddenMixinsAndFunctions = t3;
      _.hiddenVariables = t4;
      _.prefix = t5;
      _.configuration = t6;
      _.span = t7;
    },
    ForwardedModuleView_ifNecessary0(inner, rule, $T) {
      var t1;
      if (rule.prefix == null)
        if (rule.shownMixinsAndFunctions == null)
          if (rule.shownVariables == null) {
            t1 = rule.hiddenMixinsAndFunctions;
            t1 = t1 == null ? null : t1._base.get$isEmpty(0);
            if (t1 === true) {
              t1 = rule.hiddenVariables;
              t1 = t1 == null ? null : t1._base.get$isEmpty(0);
              t1 = t1 === true;
            } else
              t1 = false;
          } else
            t1 = false;
        else
          t1 = false;
      else
        t1 = false;
      if (t1)
        return inner;
      else
        return A.ForwardedModuleView$0(inner, rule, $T);
    },
    ForwardedModuleView$0(_inner, _rule, $T) {
      var t1 = _rule.prefix,
        t2 = _rule.shownVariables,
        t3 = _rule.hiddenVariables,
        t4 = _rule.shownMixinsAndFunctions,
        t5 = _rule.hiddenMixinsAndFunctions;
      return new A.ForwardedModuleView0(_inner, _rule, A.ForwardedModuleView__forwardedMap0(_inner.get$variables(), t1, t2, t3, type$.Value_2), A.ForwardedModuleView__forwardedMap0(_inner.get$variableNodes(), t1, t2, t3, type$.AstNode_2), A.ForwardedModuleView__forwardedMap0(_inner.get$functions(_inner), t1, t4, t5, $T), A.ForwardedModuleView__forwardedMap0(_inner.get$mixins(), t1, t4, t5, $T), $T._eval$1("ForwardedModuleView0<0>"));
    },
    ForwardedModuleView__forwardedMap0(map, prefix, safelist, blocklist, $V) {
      var t2,
        t1 = prefix == null;
      if (t1)
        if (safelist == null)
          t2 = blocklist == null || blocklist._base.get$isEmpty(0);
        else
          t2 = false;
      else
        t2 = false;
      if (t2)
        return map;
      if (!t1)
        map = new A.PrefixedMapView0(map, prefix, $V._eval$1("PrefixedMapView0<0>"));
      if (safelist != null)
        map = new A.LimitedMapView0(map, safelist._base.intersection$1(new A.MapKeySet(map, type$.MapKeySet_nullable_Object)), type$.$env_1_1_String._bind$1($V)._eval$1("LimitedMapView0<1,2>"));
      else if (blocklist != null && blocklist._base.get$isNotEmpty(0))
        map = A.LimitedMapView$blocklist0(map, blocklist, type$.String, $V);
      return map;
    },
    ForwardedModuleView0: function ForwardedModuleView0(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._forwarded_view0$_inner = t0;
      _._forwarded_view0$_rule = t1;
      _.variables = t2;
      _.variableNodes = t3;
      _.functions = t4;
      _.mixins = t5;
      _.$ti = t6;
    },
    FunctionExpression0: function FunctionExpression0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.namespace = t0;
      _.name = t1;
      _.originalName = t2;
      _.$arguments = t3;
      _.span = t4;
    },
    JSFunction0: function JSFunction0() {
    },
    SupportsFunction0: function SupportsFunction0(t0, t1, t2) {
      this.name = t0;
      this.$arguments = t1;
      this.span = t2;
    },
    functionClass_closure: function functionClass_closure() {
    },
    functionClass__closure: function functionClass__closure() {
    },
    functionClass__closure0: function functionClass__closure0() {
    },
    SassFunction0: function SassFunction0(t0) {
      this.callable = t0;
    },
    FunctionRule$0($name, $arguments, children, span, comment) {
      var t1 = A.stringReplaceAllUnchecked($name, "_", "-"),
        t2 = A.List_List$unmodifiable(children, type$.Statement_2),
        t3 = B.JSArray_methods.any$1(t2, new A.ParentStatement_closure0());
      return new A.FunctionRule0(t1, $name, $arguments, span, t2, t3);
    },
    FunctionRule0: function FunctionRule0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.name = t0;
      _.originalName = t1;
      _.$arguments = t2;
      _.span = t3;
      _.children = t4;
      _.hasDeclarations = t5;
    },
    unifyComplex0(complexes, span) {
      var t2, trailingCombinator, leadingCombinator, unifiedBase, t3, t4, _0_6_isSet, _0_6, t5, newLeadingCombinator, base, _1_1, newTrailingCombinator, _i, t6, t7, t8, _null = null,
        t1 = J.getInterceptor$asx(complexes);
      if (t1.get$length(complexes) === 1)
        return complexes;
      for (t2 = t1.get$iterator(complexes), trailingCombinator = _null, leadingCombinator = trailingCombinator, unifiedBase = leadingCombinator; t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        if (t3.accept$1(B.C__IsUselessVisitor0))
          return _null;
        t4 = t3.components;
        _0_6_isSet = t4.length === 1;
        if (_0_6_isSet) {
          _0_6 = t3.leadingCombinators;
          t5 = _0_6.length === 1;
        } else {
          _0_6 = _null;
          t5 = false;
        }
        if (t5) {
          newLeadingCombinator = (_0_6_isSet ? _0_6 : t3.leadingCombinators)[0];
          if (leadingCombinator == null)
            leadingCombinator = newLeadingCombinator;
          else if (!(leadingCombinator.$ti._is(newLeadingCombinator) && J.$eq$(newLeadingCombinator.value, leadingCombinator.value)))
            return _null;
        }
        base = B.JSArray_methods.get$last(t4);
        _1_1 = base.combinators;
        if (_1_1.length === 1) {
          newTrailingCombinator = _1_1[0];
          if (trailingCombinator != null)
            t3 = !(trailingCombinator.$ti._is(newTrailingCombinator) && J.$eq$(newTrailingCombinator.value, trailingCombinator.value));
          else
            t3 = false;
          if (t3)
            return _null;
          trailingCombinator = newTrailingCombinator;
        }
        if (unifiedBase == null)
          unifiedBase = base.selector.components;
        else
          for (t3 = base.selector.components, t4 = t3.length, _i = 0; _i < t4; ++_i) {
            unifiedBase = t3[_i].unify$1(unifiedBase);
            if (unifiedBase == null)
              return _null;
          }
      }
      t2 = type$.JSArray_ComplexSelector_2;
      t3 = A._setArrayType([], t2);
      for (t4 = t1.get$iterator(complexes); t4.moveNext$0();) {
        t5 = t4.get$current(t4);
        t6 = t5.components;
        t7 = t6.length;
        if (t7 > 1) {
          t8 = t5.leadingCombinators;
          t3.push(A.ComplexSelector$0(t8, B.JSArray_methods.take$1(t6, t7 - 1), t5.span, t5.lineBreak));
        }
      }
      t4 = leadingCombinator == null ? B.List_empty13 : A._setArrayType([leadingCombinator], type$.JSArray_CssValue_Combinator_2);
      unifiedBase.toString;
      t5 = A.CompoundSelector$0(unifiedBase, span);
      t6 = trailingCombinator == null ? B.List_empty13 : A._setArrayType([trailingCombinator], type$.JSArray_CssValue_Combinator_2);
      base = A.ComplexSelector$0(t4, A._setArrayType([new A.ComplexSelectorComponent0(t5, A.List_List$unmodifiable(t6, type$.CssValue_Combinator_2), span)], type$.JSArray_ComplexSelectorComponent_2), span, t1.any$1(complexes, new A.unifyComplex_closure0()));
      if (t3.length === 0)
        t1 = A._setArrayType([base], t2);
      else {
        t1 = A.List_List$of(A.IterableExtension_get_exceptLast0(t3), true, type$.ComplexSelector_2);
        t1.push(B.JSArray_methods.get$last(t3).concatenate$2(base, span));
      }
      return A.weave0(t1, span, false);
    },
    unifyCompound0(compound1, compound2) {
      var t1, t2, _i, unified,
        result = compound2.components;
      for (t1 = compound1.components, t2 = t1.length, _i = 0; _i < t2; ++_i, result = unified) {
        unified = t1[_i].unify$1(result);
        if (unified == null)
          return null;
      }
      return A.CompoundSelector$0(result, compound1.span);
    },
    unifyUniversalAndElement0(selector1, selector2) {
      var namespace, $name, t1,
        _0_0 = A._namespaceAndName0(selector1, "selector1"),
        namespace1 = _0_0._0,
        name1 = _0_0._1,
        _1_0 = A._namespaceAndName0(selector2, "selector2"),
        namespace2 = _1_0._0,
        name2 = _1_0._1;
      if (namespace1 == namespace2 || namespace2 === "*")
        namespace = namespace1;
      else {
        if (namespace1 !== "*")
          return null;
        namespace = namespace2;
      }
      if (name1 == name2 || name2 == null)
        $name = name1;
      else {
        if (!(name1 == null || name1 === "*"))
          return null;
        $name = name2;
      }
      t1 = selector1.span;
      return $name == null ? new A.UniversalSelector0(namespace, t1) : new A.TypeSelector0(new A.QualifiedName0($name, namespace), t1);
    },
    _namespaceAndName0(selector, $name) {
      var t1, _0_4;
      $label0$0: {
        if (selector instanceof A.UniversalSelector0) {
          t1 = new A._Record_2(selector.namespace, null);
          break $label0$0;
        }
        if (selector instanceof A.TypeSelector0) {
          _0_4 = selector.name;
          t1 = new A._Record_2(_0_4.namespace, _0_4.name);
          break $label0$0;
        }
        t1 = A.throwExpression(A.ArgumentError$value(selector, $name, string$.must_b));
      }
      return t1;
    },
    weave0(complexes, span, forceLineBreak) {
      var complex, t2, prefixes, t3, t4, t5, t6, i, t7, t8, _i, t9, t10, _i0, parentPrefix, t11, t12,
        t1 = J.getInterceptor$asx(complexes);
      if (t1.get$length(complexes) === 1) {
        complex = t1.$index(complexes, 0);
        if (!forceLineBreak || complex.lineBreak)
          return complexes;
        return A._setArrayType([A.ComplexSelector$0(complex.leadingCombinators, complex.components, complex.span, true)], type$.JSArray_ComplexSelector_2);
      }
      t2 = type$.JSArray_ComplexSelector_2;
      prefixes = A._setArrayType([t1.get$first(complexes)], t2);
      for (t1 = t1.skip$1(complexes, 1), t3 = t1.$ti, t1 = new A.ListIterator(t1, t1.get$length(0), t3._eval$1("ListIterator<ListIterable.E>")), t4 = type$.ComplexSelectorComponent_2, t3 = t3._eval$1("ListIterable.E"); t1.moveNext$0();) {
        t5 = t1.__internal$_current;
        if (t5 == null)
          t5 = t3._as(t5);
        t6 = t5.components;
        if (t6.length === 1) {
          for (i = 0; i < prefixes.length; ++i)
            prefixes[i] = prefixes[i].concatenate$3$forceLineBreak(t5, span, forceLineBreak);
          continue;
        }
        t7 = A._setArrayType([], t2);
        for (t8 = prefixes.length, _i = 0; _i < prefixes.length; prefixes.length === t8 || (0, A.throwConcurrentModificationError)(prefixes), ++_i) {
          t9 = A._weaveParents0(prefixes[_i], t5, span);
          if (t9 == null)
            t9 = B.List_empty14;
          t10 = t9.length;
          _i0 = 0;
          for (; _i0 < t9.length; t9.length === t10 || (0, A.throwConcurrentModificationError)(t9), ++_i0) {
            parentPrefix = t9[_i0];
            t11 = B.JSArray_methods.get$last(t6);
            t12 = A.List_List$of(parentPrefix.components, true, t4);
            t12.push(t11);
            t11 = parentPrefix.lineBreak || forceLineBreak;
            t7.push(A.ComplexSelector$0(parentPrefix.leadingCombinators, t12, span, t11));
          }
        }
        prefixes = t7;
      }
      return prefixes;
    },
    _weaveParents0(prefix, base, span) {
      var t1, queue1, queue2, trailingCombinators, _0_1, _0_3, _0_3_isSet, rootish1, t2, rootish2, _0_30, rootish, t3, rootish_case_0, t0, rootish_case_1, groups1, groups2, lcs, choices, t4, _i, group, t5, t6, t7, _i0, chunk, t8, t9, _null = null,
        leadingCombinators = A._mergeLeadingCombinators0(prefix.leadingCombinators, base.leadingCombinators);
      if (leadingCombinators == null)
        return _null;
      t1 = type$.ComplexSelectorComponent_2;
      queue1 = A.QueueList_QueueList$from(prefix.components, t1);
      queue2 = A.QueueList_QueueList$from(A.IterableExtension_get_exceptLast0(base.components), t1);
      trailingCombinators = A._mergeTrailingCombinators0(queue1, queue2, span, _null);
      if (trailingCombinators == null)
        return _null;
      $label0$0: {
        _0_1 = A._firstIfRootish0(queue1);
        _0_3 = A._firstIfRootish0(queue2);
        _0_3_isSet = _0_1 != null;
        if (_0_3_isSet) {
          rootish1 = _0_1 == null ? t1._as(_0_1) : _0_1;
          t2 = _0_3 != null;
          if (t2)
            rootish2 = _0_3 == null ? t1._as(_0_3) : _0_3;
          else
            rootish2 = _null;
          _0_30 = _0_3;
        } else {
          rootish2 = _null;
          rootish1 = rootish2;
          _0_30 = rootish1;
          t2 = false;
        }
        if (t2) {
          rootish = A.unifyCompound0(rootish1.selector, rootish2.selector);
          if (rootish == null)
            return _null;
          t1 = rootish1.combinators;
          t2 = rootish1.span;
          t3 = type$.CssValue_Combinator_2;
          queue1.addFirst$1(new A.ComplexSelectorComponent0(rootish, A.List_List$unmodifiable(t1, t3), t2));
          queue2.addFirst$1(new A.ComplexSelectorComponent0(rootish, A.List_List$unmodifiable(rootish2.combinators, t3), t2));
          break $label0$0;
        }
        if (_0_1 != null) {
          rootish_case_0 = _0_1;
          if (_0_3_isSet)
            t2 = _0_30;
          else {
            t2 = _0_3;
            _0_30 = t2;
            _0_3_isSet = true;
          }
          t2 = t2 == null;
          t3 = t2 ? rootish_case_0 : _null;
          t0 = t3;
          t3 = t2;
          t2 = t0;
        } else {
          t2 = _null;
          t3 = false;
        }
        if (!t3)
          if (_0_1 == null) {
            if (_0_3_isSet)
              t3 = _0_30;
            else {
              t3 = _0_3;
              _0_30 = t3;
              _0_3_isSet = true;
            }
            t3 = t3 != null;
            if (t3) {
              rootish_case_1 = _0_3_isSet ? _0_30 : _0_3;
              if (rootish_case_1 == null)
                rootish_case_1 = t1._as(rootish_case_1);
              t1 = rootish_case_1;
            } else
              t1 = t2;
            t2 = t3;
          } else {
            t1 = t2;
            t2 = false;
          }
        else {
          t1 = t2;
          t2 = true;
        }
        if (t2) {
          queue1.addFirst$1(t1);
          queue2.addFirst$1(t1);
        }
      }
      groups1 = A._groupSelectors0(queue1);
      groups2 = A._groupSelectors0(queue2);
      t1 = type$.List_ComplexSelectorComponent_2;
      lcs = A.longestCommonSubsequence0(groups2, groups1, new A._weaveParents_closure3(span), t1);
      choices = A._setArrayType([], type$.JSArray_List_Iterable_ComplexSelectorComponent_2);
      for (t2 = lcs.length, t3 = type$.JSArray_Iterable_ComplexSelectorComponent_2, t4 = type$.JSArray_ComplexSelectorComponent_2, _i = 0; _i < lcs.length; lcs.length === t2 || (0, A.throwConcurrentModificationError)(lcs), ++_i) {
        group = lcs[_i];
        t5 = A._setArrayType([], t3);
        for (t6 = A._chunks0(groups1, groups2, new A._weaveParents_closure4(group), t1), t7 = t6.length, _i0 = 0; _i0 < t6.length; t6.length === t7 || (0, A.throwConcurrentModificationError)(t6), ++_i0) {
          chunk = t6[_i0];
          t8 = A._setArrayType([], t4);
          for (t9 = B.JSArray_methods.get$iterator(chunk); t9.moveNext$0();)
            B.JSArray_methods.addAll$1(t8, t9.get$current(0));
          t5.push(t8);
        }
        choices.push(t5);
        choices.push(A._setArrayType([group], t3));
        groups1.removeFirst$0();
        groups2.removeFirst$0();
      }
      t2 = A._setArrayType([], t3);
      for (t1 = A._chunks0(groups1, groups2, new A._weaveParents_closure5(), t1), t3 = t1.length, _i = 0; _i < t1.length; t1.length === t3 || (0, A.throwConcurrentModificationError)(t1), ++_i) {
        chunk = t1[_i];
        t5 = A._setArrayType([], t4);
        for (t6 = B.JSArray_methods.get$iterator(chunk); t6.moveNext$0();)
          B.JSArray_methods.addAll$1(t5, t6.get$current(0));
        t2.push(t5);
      }
      choices.push(t2);
      B.JSArray_methods.addAll$1(choices, trailingCombinators);
      t1 = A._setArrayType([], type$.JSArray_ComplexSelector_2);
      for (t2 = J.get$iterator$ax(A.paths0(new A.WhereIterable(choices, new A._weaveParents_closure6(), type$.WhereIterable_List_Iterable_ComplexSelectorComponent_2), type$.Iterable_ComplexSelectorComponent_2)), t3 = !prefix.lineBreak, t5 = base.lineBreak; t2.moveNext$0();) {
        t6 = t2.get$current(t2);
        t7 = A._setArrayType([], t4);
        for (t6 = J.get$iterator$ax(t6); t6.moveNext$0();)
          B.JSArray_methods.addAll$1(t7, t6.get$current(t6));
        t1.push(A.ComplexSelector$0(leadingCombinators, t7, span, !t3 || t5));
      }
      return t1;
    },
    _firstIfRootish0(queue) {
      var first, t1, t2, _i, simple, t3;
      if (queue.get$length(0) >= 1) {
        first = queue.$index(0, 0);
        for (t1 = first.selector.components, t2 = t1.length, _i = 0; _i < t2; ++_i) {
          simple = t1[_i];
          if (simple instanceof A.PseudoSelector0)
            if (simple.isClass)
              t3 = $._rootishPseudoClasses0.contains$1(0, simple.normalizedName);
            else
              t3 = false;
          else
            t3 = false;
          if (t3) {
            queue.removeFirst$0();
            return first;
          }
        }
      }
      return null;
    },
    _mergeLeadingCombinators0(combinators1, combinators2) {
      var _0_4, t1, _0_7_isSet, _0_7, t2, _0_11_isSet, _0_11, _0_4_isSet, combinators, _null = null;
      $label0$0: {
        _0_4 = combinators2;
        t1 = type$.List_CssValue_Combinator_2;
        _0_7_isSet = t1._is(combinators1);
        if (_0_7_isSet) {
          _0_7 = combinators1.length;
          t2 = _0_7;
          t2 = t2 > 1;
        } else {
          _0_7 = _null;
          t2 = false;
        }
        if (!t2) {
          t2 = _0_4;
          _0_11_isSet = t1._is(t2);
          if (_0_11_isSet) {
            t2 = _0_4;
            _0_11 = (t2 == null ? t1._as(t2) : t2).length;
            t2 = _0_11;
            _0_4_isSet = true;
            t2 = t2 > 1;
          } else {
            _0_11 = _null;
            _0_4_isSet = true;
            t2 = false;
          }
        } else {
          _0_11 = _null;
          _0_4_isSet = true;
          _0_11_isSet = false;
          t2 = true;
        }
        if (t2) {
          t1 = _null;
          break $label0$0;
        }
        if (t1._is(combinators1)) {
          if (_0_7_isSet)
            t2 = _0_7;
          else {
            _0_7 = combinators1.length;
            t2 = _0_7;
          }
          t2 = t2 <= 0;
          if (t2)
            if (_0_4_isSet)
              combinators = _0_4;
            else {
              combinators = combinators2;
              _0_4 = combinators;
              _0_4_isSet = true;
            }
          else
            combinators = _null;
        } else {
          combinators = _null;
          t2 = false;
        }
        if (!t2) {
          if (_0_4_isSet)
            t2 = _0_4;
          else {
            t2 = combinators2;
            _0_4 = t2;
            _0_4_isSet = true;
          }
          if (t1._is(t2)) {
            if (_0_11_isSet)
              t1 = _0_11;
            else {
              t2 = _0_4_isSet ? _0_4 : combinators2;
              _0_11 = (t2 == null ? t1._as(t2) : t2).length;
              t1 = _0_11;
            }
            t1 = t1 <= 0;
          } else
            t1 = false;
          combinators = combinators1;
        } else
          t1 = true;
        if (t1) {
          t1 = combinators;
          break $label0$0;
        }
        t1 = B.C_ListEquality.equals$2(0, combinators1, combinators2) ? combinators1 : _null;
        break $label0$0;
      }
      return t1;
    },
    _mergeTrailingCombinators0(components1, components2, span, result) {
      var _0_1, t1, _1_1, t2, t3, _4_1, _4_3, _4_4_isSet, _4_4, _4_5, component1, component2, t4, t5, choices, _2_0, _4_4_isSet0, _4_9, _4_6_isSet, _4_6, _4_7, nextComponents, followingComponents, _4_7_isSet, _4_10_isSet, _4_10, _4_5_isSet, next, following, _3_0, siblingComponents_case_0, t0, siblingComponents_case_1, combinator1, combinator2, unified, combinator_case_0, combinatorComponents_case_0, descendantComponents_case_0, t6, combinator_case_1, descendantComponents_case_1, combinatorComponents_case_1, _null = null;
      if (result == null)
        result = A.QueueList$(_null, type$.List_List_ComplexSelectorComponent_2);
      $label0$0: {
        _0_1 = components1.get$length(0);
        if (_0_1 >= 1) {
          t1 = components1.$index(0, _0_1 - 1).combinators;
          break $label0$0;
        }
        t1 = B.List_empty13;
        break $label0$0;
      }
      $label1$1: {
        _1_1 = components2.get$length(0);
        if (_1_1 >= 1) {
          t2 = components2.$index(0, _1_1 - 1).combinators;
          break $label1$1;
        }
        t2 = B.List_empty13;
        break $label1$1;
      }
      t3 = t1.length;
      if (t3 === 0 && t2.length === 0)
        return result;
      if (t3 > 1 || t2.length > 1)
        return _null;
      $label2$2: {
        t3 = A.IterableExtension_get_firstOrNull(t1);
        t3 = t3 == null ? _null : t3.value;
        t2 = A.IterableExtension_get_firstOrNull(t2);
        t2 = [t3, t2 == null ? _null : t2.value, components1, components2];
        _4_1 = t2[0];
        _4_3 = B.Combinator_y180 === _4_1;
        _4_4_isSet = _4_3;
        if (_4_4_isSet) {
          _4_4 = t2[1];
          _4_5 = B.Combinator_y180 === _4_4;
          t3 = _4_5;
        } else {
          _4_4 = _null;
          _4_5 = _4_4;
          t3 = false;
        }
        if (t3) {
          component1 = components1.removeLast$0(0);
          component2 = components2.removeLast$0(0);
          t2 = component1.selector;
          t3 = component2.selector;
          if (A.compoundIsSuperselector0(t2, t3, _null))
            result.addFirst$1(A._setArrayType([A._setArrayType([component2], type$.JSArray_ComplexSelectorComponent_2)], type$.JSArray_List_ComplexSelectorComponent_2));
          else {
            t4 = type$.JSArray_ComplexSelectorComponent_2;
            t5 = type$.JSArray_List_ComplexSelectorComponent_2;
            if (A.compoundIsSuperselector0(t3, t2, _null))
              result.addFirst$1(A._setArrayType([A._setArrayType([component1], t4)], t5));
            else {
              choices = A._setArrayType([A._setArrayType([component1, component2], t4), A._setArrayType([component2, component1], t4)], t5);
              _2_0 = A.unifyCompound0(t2, t3);
              if (_2_0 != null)
                choices.push(A._setArrayType([new A.ComplexSelectorComponent0(_2_0, A.List_List$unmodifiable(A._setArrayType([B.JSArray_methods.get$first(t1)], type$.JSArray_CssValue_Combinator_2), type$.CssValue_Combinator_2), span)], t4));
              result.addFirst$1(choices);
            }
          }
          break $label2$2;
        }
        if (_4_3) {
          if (_4_4_isSet) {
            t3 = _4_4;
            _4_4_isSet0 = _4_4_isSet;
          } else {
            _4_4 = t2[1];
            t3 = _4_4;
            _4_4_isSet0 = true;
          }
          _4_9 = B.Combinator_gRV0 === t3;
          _4_6_isSet = _4_9;
          if (_4_6_isSet) {
            _4_6 = t2[2];
            _4_7 = t2[3];
            nextComponents = _4_7;
            followingComponents = _4_6;
          } else {
            nextComponents = _null;
            followingComponents = nextComponents;
            _4_7 = followingComponents;
            _4_6 = _4_7;
          }
          t3 = _4_6_isSet;
          _4_7_isSet = t3;
        } else {
          nextComponents = _null;
          followingComponents = nextComponents;
          _4_7 = followingComponents;
          _4_6 = _4_7;
          _4_9 = _4_6;
          _4_4_isSet0 = _4_4_isSet;
          _4_6_isSet = false;
          _4_7_isSet = false;
          t3 = false;
        }
        _4_10_isSet = !t3;
        if (_4_10_isSet) {
          _4_10 = B.Combinator_gRV0 === _4_1;
          t3 = _4_10;
          if (t3) {
            if (_4_4_isSet) {
              t3 = _4_5;
              _4_5_isSet = _4_4_isSet;
              _4_4_isSet = _4_4_isSet0;
            } else {
              if (_4_4_isSet0) {
                t3 = _4_4;
                _4_4_isSet = _4_4_isSet0;
              } else {
                _4_4 = t2[1];
                t3 = _4_4;
                _4_4_isSet = true;
              }
              _4_5 = B.Combinator_y180 === t3;
              t3 = _4_5;
              _4_5_isSet = true;
            }
            if (t3) {
              if (_4_6_isSet)
                nextComponents = _4_6;
              else {
                _4_6 = t2[2];
                nextComponents = _4_6;
                _4_6_isSet = true;
              }
              if (_4_7_isSet)
                followingComponents = _4_7;
              else {
                _4_7 = t2[3];
                followingComponents = _4_7;
                _4_7_isSet = true;
              }
            }
          } else {
            _4_5_isSet = _4_4_isSet;
            _4_4_isSet = _4_4_isSet0;
            t3 = false;
          }
        } else {
          _4_10 = _null;
          _4_5_isSet = _4_4_isSet;
          _4_4_isSet = _4_4_isSet0;
          t3 = true;
        }
        if (t3) {
          next = nextComponents.removeLast$0(0);
          following = followingComponents.removeLast$0(0);
          t1 = following.selector;
          t2 = next.selector;
          t3 = type$.JSArray_ComplexSelectorComponent_2;
          t4 = type$.JSArray_List_ComplexSelectorComponent_2;
          if (A.compoundIsSuperselector0(t1, t2, _null))
            result.addFirst$1(A._setArrayType([A._setArrayType([next], t3)], t4));
          else {
            t4 = A._setArrayType([A._setArrayType([following, next], t3)], t4);
            _3_0 = A.unifyCompound0(t1, t2);
            if (_3_0 != null)
              t4.push(A._setArrayType([new A.ComplexSelectorComponent0(_3_0, A.List_List$unmodifiable(next.combinators, type$.CssValue_Combinator_2), span)], t3));
            result.addFirst$1(t4);
          }
          break $label2$2;
        }
        if (B.Combinator_8I80 === _4_1) {
          if (_4_3)
            t3 = _4_9;
          else {
            if (_4_4_isSet)
              t3 = _4_4;
            else {
              _4_4 = t2[1];
              t3 = _4_4;
              _4_4_isSet = true;
            }
            _4_9 = B.Combinator_gRV0 === t3;
            t3 = _4_9;
          }
          if (!t3)
            if (_4_5_isSet)
              t3 = _4_5;
            else {
              if (_4_4_isSet)
                t3 = _4_4;
              else {
                _4_4 = t2[1];
                t3 = _4_4;
                _4_4_isSet = true;
              }
              _4_5 = B.Combinator_y180 === t3;
              t3 = _4_5;
            }
          else
            t3 = true;
          if (t3) {
            if (_4_7_isSet)
              siblingComponents_case_0 = _4_7;
            else {
              _4_7 = t2[3];
              siblingComponents_case_0 = _4_7;
              _4_7_isSet = true;
            }
            t4 = siblingComponents_case_0;
          } else
            t4 = _null;
          t0 = t4;
          t4 = t3;
          t3 = t0;
        } else {
          t3 = _null;
          t4 = false;
        }
        if (!t4) {
          if (_4_10_isSet)
            t4 = _4_10;
          else {
            _4_10 = B.Combinator_gRV0 === _4_1;
            t4 = _4_10;
          }
          if (!t4)
            t4 = _4_3;
          else
            t4 = true;
          if (t4) {
            if (_4_4_isSet)
              t4 = _4_4;
            else {
              _4_4 = t2[1];
              t4 = _4_4;
              _4_4_isSet = true;
            }
            t4 = B.Combinator_8I80 === t4;
            if (t4) {
              if (_4_6_isSet)
                siblingComponents_case_1 = _4_6;
              else {
                _4_6 = t2[2];
                siblingComponents_case_1 = _4_6;
                _4_6_isSet = true;
              }
              t3 = siblingComponents_case_1;
            }
          } else
            t4 = false;
        } else
          t4 = true;
        if (t4) {
          result.addFirst$1(A._setArrayType([A._setArrayType([t3.removeLast$0(0)], type$.JSArray_ComplexSelectorComponent_2)], type$.JSArray_List_ComplexSelectorComponent_2));
          break $label2$2;
        }
        t3 = _4_1 == null;
        t4 = !t3;
        if (t4) {
          combinator1 = _4_1;
          if (_4_4_isSet)
            t5 = _4_4;
          else {
            _4_4 = t2[1];
            t5 = _4_4;
            _4_4_isSet = true;
          }
          if (t5 != null) {
            if (_4_4_isSet)
              combinator2 = _4_4;
            else {
              _4_4 = t2[1];
              combinator2 = _4_4;
              _4_4_isSet = true;
            }
            t5 = combinator1 === (combinator2 == null ? type$.Combinator_2._as(combinator2) : combinator2);
          } else
            t5 = false;
        } else
          t5 = false;
        if (t5) {
          unified = A.unifyCompound0(components1.removeLast$0(0).selector, components2.removeLast$0(0).selector);
          if (unified == null)
            return _null;
          result.addFirst$1(A._setArrayType([A._setArrayType([new A.ComplexSelectorComponent0(unified, A.List_List$unmodifiable(A._setArrayType([B.JSArray_methods.get$first(t1)], type$.JSArray_CssValue_Combinator_2), type$.CssValue_Combinator_2), span)], type$.JSArray_ComplexSel