@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Home')

@section('content')
<div class="container">
    <h1 class="mb-4 text-primary">إضافة تذكرة</h1>

    <div class="card shadow-lg">
        <div class="card-header bg-primary text-white text-center">
            <h5 class="text-white">املأ التفاصيل لإنشاء تذكرة</h5>
        </div>
        <div class="card-body p-4">
            <form action="{{ route('tickets.store') }}" method="POST">
                @csrf
                <div class="mb-4">
                    <label for="title" class="form-label">العنوان</label>
                    <input type="text" name="title" id="title" class="form-control @error('title') is-invalid @enderror" placeholder="أدخل عنوان التذكرة" required>
                    @error('title')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-4">
                    <label for="description" class="form-label">الوصف</label>
                    <textarea name="description" id="description" class="form-control @error('description') is-invalid @enderror" rows="5" placeholder="قدم وصفاً مفصلاً"></textarea>
                    @error('description')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="row mb-4">
                    <div class="col-md-6">
                        <label for="priority" class="form-label">الأولوية</label>
                        <select name="priority" id="priority" class="form-select @error('priority') is-invalid @enderror" required>
                            <option value="">اختر الأولوية</option>
                            <option value="low">منخفضة</option>
                            <option value="medium">متوسطة</option>
                            <option value="high">عالية</option>
                            <option value="critical">حرجة</option>
                        </select>
                        @error('priority')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6 mb-4">
                        <label for="product_id" class="form-label">المنتج</label>
                        <select name="product_id" id="product_id" class="form-select @error('product_id') is-invalid @enderror" required>
                            <option value="">اختر المنتج</option>
                            @foreach($products as $product)
                            <option value="{{ $product->id }}">{{ $product->name }}</option>
                            @endforeach
                        </select>
                        @error('product_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-4">
                        <label for="file" class="form-label">إرفاق ملف (اختياري)</label>
                        <input type="file" name="file" id="file" class="form-control @error('file') is-invalid @enderror">
                        @error('file')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="d-flex justify-content-between">
                    <button type="submit" class="btn btn-primary px-4">إنشاء تذكرة</button>
                    <a href="{{ route('tickets') }}" class="btn btn-secondary px-4">إلغاء</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection