@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Home')

@section('content')
<div class="container">
    <h1>Tickets</h1>

    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form action="{{ route('tickets') }}" method="GET">
                <div class="row">
                    <div class="col-md-3">
                        <select name="exact[status]" class="form-control">
                            <option value="">اختر الحالة</option>
                            <option value="open">مفتوح</option>
                            <option value="in progress">قيد التنفيذ</option>
                            <option value="closed">مغلق</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select name="exact[priority]" class="form-control">
                            <option value="">اختر الأولوية</option>
                            <option value="low">منخفضة</option>
                            <option value="medium">متوسطة</option>
                            <option value="high">عالية</option>
                            <option value="critical">حرجة</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <input type="number" name="exact[employee.phone]" class="form-control" placeholder="رقم هاتف الموظف">
                    </div>
                    <div class="col-md-3">
                        <button type="submit" class="btn btn-primary">Filter</button>
                    </div>
                </div>

            </form>

        </div>
    </div>




    <div class="card">

        <div class="card-body">
            <div class="d-flex justify-content-end mb-3">
                <a href="{{ route('tickets.create') }}" class="btn btn-success">+ إضافة تذكرة</a>
            </div>
            @if ($tickets->isEmpty())
            <div class="alert alert-info text-center" role="alert">
                لا يوجد تذاكر
            </div>
            @else
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Title</th>
                        <th>Status</th>
                        <th>Priority</th>
                        <th>Employee ID</th>
                        <th>Created At</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($tickets as $ticket)
                    <tr>
                        <td>{{ $ticket->id }}</td>
                        <td>{{ $ticket->title }}</td>
                        <td>{{ $ticket->status }}</td>
                        <td>{{ $ticket->priority }}</td>
                        <td>{{ $ticket->employee_id }}</td>
                        <td>{{ $ticket->created_at }}</td>
                        <td>
                            <a href="{{ route('tickets.show', $ticket->id) }}" class="btn btn-info btn-sm">عرض</a>
                            <a href="{{ route('tickets.edit', $ticket->id) }}" class="btn btn-warning btn-sm">تعديل</a>
                            <form action="{{ route('tickets.destroy', $ticket->id) }}" method="POST" style="display: inline-block;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد أنك تريد حذف هذه التذكرة؟')">مسح</button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @endif
        </div>
    </div>
</div>
@endsection