@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Home')

@section('content')
<div class="container">
    <h1 class="mb-4 text-center">تفاصيل التذكرة</h1>

    <div class="card shadow-lg mb-4">
        <div class="card-header bg-primary text-white">
            <h5 class="text-white">التفاصيل</h5>
        </div>
        <div class="card-body mt-3">
            <p><strong>العنوان:</strong> {{ $ticket->title }}</p>
            <p><strong>الوصف:</strong> {{ $ticket->description }}</p>
            <p><strong>الحالة:</strong> {{ ucfirst($ticket->status) }}</p>
            <p><strong>الأولوية:</strong> {{ ucfirst($ticket->priority) }}</p>
            <p><strong>رقم الموظف:</strong> {{ $ticket->employee->name }}</p>
            <p><strong>المنتج:</strong> {{ $ticket->product->name }}</p>
            @if ($ticket->file_path)
            <p><strong>الملف:</strong> <a href="{{ asset('storage/' . $ticket->file_path) }}" target="_blank">تحميل</a></p>
            @endif
        </div>
    </div>

    <div class="card shadow-lg mb-4">
        <div class="card-header bg-secondary ">
            <h5 class="text-white">تحديث الحالة</h5>
        </div>
        <div class="card-body mt-4">
            <form action="{{ route('tickets.status.update', $ticket->id) }}" method="POST">
                @csrf
                @method('PATCH')
                <div class="mb-3">
                    <label for="status" class="form-label">الحالة</label>
                    <select name="status" id="status" class="form-select">
                        <option value="open" {{ $ticket->status == 'open' ? 'selected' : '' }}>مفتوح</option>
                        <option value="in progress" {{ $ticket->status == 'in progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                        <option value="closed" {{ $ticket->status == 'closed' ? 'selected' : '' }}>مغلق</option>
                        <option value="escalated" {{ $ticket->status == 'escalated' ? 'selected' : '' }}>تم التصعيد</option>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">تحديث الحالة</button>
            </form>
        </div>
    </div>

    <div class="card shadow-lg">
        <div class="card-header bg-success text-white">
            <h5 class="text-white">التعليقات</h5>
        </div>
        <div class="card-body mt-4">
            <form action="{{ route('tickets.comments.add', $ticket->id) }}" method="POST">
                @csrf
                <div class="mb-3">
                    <label for="comment" class="form-label">إضافة تعليق</label>
                    <textarea name="comment" id="comment" class="form-control" rows="3" required></textarea>
                </div>
                <button type="submit" class="btn btn-success">إضافة تعليق</button>
            </form>

            <hr>

            @if ($ticket->comments->isEmpty())
            <p>لا توجد تعليقات حتى الآن.</p>
            @else
            <ul class="list-group">
                @foreach ($ticket->comments as $comment)
                <li class="list-group-item">
                    <p><strong>{{ $comment->user->name }}</strong> ({{ $comment->created_at->format('Y-m-d H:i') }})</p>
                    <p>{{ $comment->comment }}</p>
                </li>
                @endforeach
            </ul>
            @endif
        </div>
    </div>
</div>
@endsection