@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'إنشاء مستخدم')

@section('content')

<div class="container">
    <h1 class="mb-4 text-center text-primary">إنشاء مستخدم</h1>

    <div class="card shadow-lg">
        <div class="card-header bg-success text-white text-center">
            <h5>املأ تفاصيل المستخدم</h5>
        </div>
        <div class="card-body">
        <ul>
              @foreach ($errors->all() as $error)
              <li class="text-danger">{{ $error }}</li>
              @endforeach
            </ul>
            <form action="{{ route('users.store') }}" method="POST" enctype="multipart/form-data">
                @csrf

                @include('content.pages.users.form')

                <div class="d-flex justify-content-between">
                    <button type="submit" class="btn btn-primary">إنشاء مستخدم</button>
                    <a href="{{ route('users.index') }}" class="btn btn-secondary">إلغاء</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection