<div class="mb-4">
    <label for="name" class="form-label">الاسم</label>
    <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name', $user->name ?? '') }}" required>
    @error('name')
    <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>

<div class="mb-4">
    <label for="email" class="form-label">البريد الإلكتروني</label>
    <input type="email" name="email" id="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email', $user->email ?? '') }}" required>
    @error('email')
    <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>

<div class="mb-4">
    <label for="phone_number" class="form-label">رقم الهاتف</label>
    <input type="text" name="phone_number" id="phone_number" class="form-control @error('phone_number') is-invalid @enderror" value="{{ old('phone_number', $user->phone_number ?? '') }}" required>
    @error('phone_number')
    <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>

<div class="mb-6 form-password-toggle">
    <label class="form-label" for="password">كلمة المرور</label>
    <div class="input-group input-group-merge">
        <input type="password" id="password" class="form-control" name="password" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" aria-describedby="password" />
        <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
    </div>
</div>
<div class="mb-6 form-password-toggle">
    <label class="form-label" for="password">تأكيد كلمة المرور</label>
    <div class="input-group input-group-merge">
        <input type="password" id="confirm-password" class="form-control" name="password_confirmation" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" aria-describedby="password" />
        <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
    </div>
</div>
<div class="mb-4">
    <label for="department" class="form-label">القسم</label>
    <select name="department" id="department" class="form-select @error('department') is-invalid @enderror">
        <option value="">اختر القسم</option>
        <option value="Customer Service" {{ old('department', $user->department ?? '') == 'Customer Service' ? 'selected' : '' }}>خدمة العملاء</option>
        <option value="Operations" {{ old('department', $user->department ?? '') == 'Operations' ? 'selected' : '' }}>العمليات</option>
        <option value="Sales and Marketing" {{ old('department', $user->department ?? '') == 'Sales and Marketing' ? 'selected' : '' }}>المبيعات والتسويق</option>
    </select>
    @error('department')
    <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>

<div class="mb-4">
    <label for="photo_path" class="form-label">الصورة (اختياري)</label>
    <input type="file" name="photo_path" id="photo_path" class="form-control @error('photo_path') is-invalid @enderror">
    @error('photo_path')
    <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>