<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\language\LanguageController;
use App\Http\Controllers\pages\HomePage;
use App\Http\Controllers\pages\Page2;
use App\Http\Controllers\pages\MiscError;
use App\Http\Controllers\authentications\LoginBasic;
use App\Http\Controllers\authentications\RegisterBasic;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\UserController;

// Main Page Route

Route::get('/page-2', [Page2::class, 'index'])->name('pages-page-2');

// locale
Route::get('/lang/{locale}', [LanguageController::class, 'swap']);
Route::get('/pages/misc-error', [MiscError::class, 'index'])->name('pages-misc-error');

// authentication

Route::prefix('auth')->group(function () {
    Route::get('/login', [LoginBasic::class, 'index'])->name('login');
    Route::post('/login-basic', [LoginBasic::class, 'login'])->name('login-basic');
    Route::post('/logout', [LoginBasic::class, 'logout'])->name('logout');
    Route::get('/register-basic', [RegisterBasic::class, 'index'])->name('auth-register-basic');
    Route::post('/register', [RegisterBasic::class, 'register'])->name('register');
});


Route::middleware(['auth'])->group(function () {
    Route::get('/', [HomePage::class, 'index'])->name('home');


    Route::prefix('tickets')->group(function () {
        Route::get('/', [TicketController::class, 'index'])->name('tickets');
        Route::get('/create', [TicketController::class, 'create'])->name('tickets.create');
        Route::post('/store', [TicketController::class, 'store'])->name('tickets.store');
        Route::get('/{ticket}', [TicketController::class, 'show'])->name('tickets.show');
        Route::get('/{ticket}/edit', [TicketController::class, 'edit'])->name('tickets.edit');
        Route::put('/{ticket}', [TicketController::class, 'update'])->name('tickets.update');
        Route::delete('/{ticket}', [TicketController::class, 'destroy'])->name('tickets.destroy');
        Route::post('/tickets/{ticket}/comments', [TicketController::class, 'addComment'])->name('tickets.comments.add');
        Route::patch('/tickets/{ticket}/status', [TicketController::class, 'updateStatus'])->name('tickets.status.update');
    });

    Route::resource('users', UserController::class);

});
