<?php
$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'المستخدمين'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <h1 class="mb-4 text-center">إدارة المستخدمين</h1>
    <a href="<?php echo e(route('users.create')); ?>" class="btn btn-success mb-3">+ إنشاء مستخدم</a>
    <div class="card shadow-lg">
        <div class="card-header text-white">
            <h5>المستخدمين</h5>
        </div>
        <div class="card-body">
            <?php if($users->isEmpty()): ?>
                <p>لم يتم العثور على مستخدمين.</p>
            <?php else: ?>
                <table class="table table-striped table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>المعرف</th>
                            <th>الاسم</th>
                            <th>البريد الإلكتروني</th>
                            <th>الدور</th>
                            <th>القسم</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($user->id); ?></td>
                                <td><?php echo e($user->name); ?></td>
                                <td><?php echo e($user->email); ?></td>
                                <td><?php echo e(ucfirst($user->role)); ?></td>
                                <td><?php echo e($user->department); ?></td>
                                <td>
                                    <a href="<?php echo e(route('users.show', $user->id)); ?>" class="btn btn-info btn-sm">عرض</a>
                                    <a href="<?php echo e(route('users.edit', $user->id)); ?>" class="btn btn-warning btn-sm">تعديل</a>
                                    <form action="<?php echo e(route('users.destroy', $user->id)); ?>" method="POST" style="display: inline-block;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد؟')">حذف</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/munaalboashi/Desktop/Apps/vnx-it-support/resources/views/content/pages/users/index.blade.php ENDPATH**/ ?>